(* 
   Title:      CoreGrailExamples.thy
   ID:         $Id: CoreGrailExamples.thy,v 1.1 2003/02/15 09:06:15 da Exp $ 
   Author:     ME
   Copyright:  GPL

   Example evaluations of dyn sem and various lemmas over resources. All for CoreGrail.
*)

(* ToDo: merge changes in Q.thy back into CoreGrailDynSem *)
theory CoreGrailExamples = CoreGrailDynSem:

subsection "Generic constants"

constdefs one::"int"
"one \<equiv> int 1"
constdefs two::"int"
"two \<equiv> int 2"
constdefs three::"int"
"three \<equiv> two + one"
constdefs four::"int"
"four \<equiv> two + two"

constdefs six::"int"
"six \<equiv> three + three"
constdefs  twentyfour::"int"
"twentyfour \<equiv> six * four"

subsection "Example programs"

subsubsection "foo"

text {*
Simple example mainly testing function call.
*}

consts foo :: "Fname"

constdefs fooRes :: "Result"
"fooRes \<equiv> PRIMres (FUNres foo EMPTYvar)"

constdefs fooCall :: "FunBody"
"fooCall \<equiv> FUNbody 
                         EMPTYdec
                         fooRes"

constdefs fooFun :: "FunBody"
"fooFun \<equiv> FUNbody 
                (FULLdec (VOIDdec (VALop (INTval 1))) EMPTYdec) 
                (PRIMres (OPres (VALop (INTval 2))))"

constdefs fooHeap :: "Heap"
"fooHeap \<equiv>  
   emptyHeap ( foo := Some (EMPTYal, fooFun) )"

constdefs fooState :: "State"
"fooState \<equiv> emptyState \<lparr> heap := fooHeap \<rparr>"

constdefs one_plus_one :: "FunBody"
"one_plus_one \<equiv> FUNbody 
                         EMPTYdec
                         (PRIMres (OPres (BINop ADDop (INTval 1) (INTval 1))))"

consts xx :: "Vname"
       yy :: "Vname"

constdefs xx_plus_yy :: "FunBody"
"xx_plus_yy \<equiv> FUNbody 
                         (FULLdec (VALdec xx (VALop (INTval 1))) 
                         (FULLdec (VALdec yy (VALop (INTval 2))) EMPTYdec))
                         (PRIMres (OPres (BINop ADDop (VARval xx) (VARval yy))))"

subsubsection "bar"

text {*
Simple example mainly testing conditional.
*}

consts z :: "Vname"

constdefs barBody :: "FunBody"
"barBody \<equiv> FUNbody 
                (FULLdec (VALdec z (VALop (INTval 1))) EMPTYdec) 
                (CHOICEres (CONDhead (VARval z) LESStest (INTval 0)) 
                    (OPres (VALop (INTval 0)))
                    (OPres (BINop SUBop (VARval z) (INTval 1))))"

subsubsection "Recursive functions"

text {*
A simple recursive function implementing \<lambda> x . 0 
*}

consts q :: "Vname"
consts bonzo :: "Fname"
consts bonzoElseBranch :: "Fname"

constdefs bonzoThen :: "PrimRes"
 "bonzoThen \<equiv> OPres (VALop (VARval q))"
constdefs bonzoElseBranchBody :: "FunBody"
 "bonzoElseBranchBody \<equiv> FUNbody 
                            (FULLdec (VALdec q (BINop SUBop (VARval q) (INTval 1)))
                             EMPTYdec)
                            (PRIMres (FUNres bonzo (FULLvar q (EMPTYvar))))"
constdefs bonzoElse :: "PrimRes"
 "bonzoElse \<equiv> FUNres bonzoElseBranch (FULLvar q EMPTYvar)"
constdefs bonzoBody ::"FunBody"
 "bonzoBody \<equiv> FUNbody EMPTYdec (CHOICEres (CONDhead (VARval q) LESStest (INTval one)) bonzoThen bonzoElse)"

constdefs bonzoCall :: "int => FunBody"
 "bonzoCall k \<equiv> FUNbody
                           (FULLdec (VALdec q (VALop (INTval k))) EMPTYdec)
                           (PRIMres (FUNres bonzo (FULLvar q (EMPTYvar))))"

constdefs bonzoHeap :: "Heap"
"bonzoHeap \<equiv>  
    emptyHeap (bonzoElseBranch := Some ((FULLal (ARG INTty q) EMPTYal), bonzoElseBranchBody),
               bonzo := Some ((FULLal (ARG INTty q) EMPTYal), bonzoBody) )"

constdefs bonzoState :: "State"
"bonzoState \<equiv> emptyState \<lparr> heap := bonzoHeap \<rparr>"

subsubsection "fib"

consts n :: "Vname"
       acc :: "Vname"
       m :: "Vname"
consts fac :: "Fname"
consts elseBranch :: "Fname"
consts facThree :: "Fname"

constdefs thenPres:: "PrimRes"
"thenPres \<equiv> OPres (VALop (VARval n))"
constdefs elsePres:: "PrimRes"
"elsePres \<equiv> FUNres elseBranch (FULLvar n (FULLvar acc EMPTYvar))"
constdefs facBody::"FunBody"
"facBody \<equiv> 
  FUNbody EMPTYdec (CHOICEres (CONDhead (VARval n) LESStest (INTval one)) thenPres elsePres)"
constdefs elseBody::"FunBody"
"elseBody \<equiv> 
  FUNbody (FULLdec (VALdec m (BINop SUBop (VARval n) (INTval one)))
             (FULLdec (VALdec acc (BINop MULop (VARval acc) (VARval n))) EMPTYdec))
          (PRIMres (FUNres fac (FULLvar acc (FULLvar m EMPTYvar))))"

constdefs facThreeBody :: "FunBody"
"facThreeBody \<equiv> 
   FUNbody 
     (FULLdec (VALdec m (VALop (INTval (int 3)))) EMPTYdec)
     (PRIMres (FUNres fac (FULLvar m EMPTYvar)))"

constdefs facThreeCall :: "Result"
"facThreeCall \<equiv> PRIMres (FUNres facThree EMPTYvar)"

constdefs facHeap :: "Heap"
"facHeap \<equiv>  
  emptyHeap (
    fac := Some ((FULLal (ARG INTty acc) (FULLal (ARG INTty n) EMPTYal)), facBody), 
    elseBranch := Some ((FULLal (ARG INTty n) (FULLal (ARG INTty acc) EMPTYal)), elseBody), 
    facThree := Some (EMPTYal, facThreeBody) )"

constdefs facState :: "State"
"facState \<equiv> emptyState \<lparr> heap := facHeap \<rparr>"

constdefs Fac:: "nat \<Rightarrow> FunBody"
"Fac k \<equiv> 
  FUNbody (FULLdec (VALdec acc (VALop (INTval one)))
           (FULLdec (VALdec n (VALop (INTval (int k)))) EMPTYdec))
          (PRIMres (FUNres fac (FULLvar acc (FULLvar n EMPTYvar))))"

constdefs FacZero:: "FunBody"
"FacZero \<equiv> Fac 0"
constdefs FacOne:: "FunBody"
"FacOne \<equiv> Fac 1"
constdefs FacTwo:: "FunBody"
"FacTwo \<equiv> Fac 2"
constdefs FacThree:: "FunBody"
"FacThree \<equiv> Fac (1+2)"
constdefs FacFour:: "FunBody"
"FacFour \<equiv> Fac (2+2)"

consts facSpec:: "nat \<Rightarrow> int"
recdef facSpec "measure (\<lambda> k . k)"
"facSpec 0 = int 1" 
"facSpec k = (int k) * (facSpec (k-(nat 1)))"


subsubsection "Predicates over Resource Consumption"

constdefs 
  needsTime :: "FunBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. ? v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>b \<langle>v,s\<rangle>) & (clock s) = n))"

  boundedTime :: "FunBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. ? v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>b \<langle>v,s\<rangle>) & (clock s) <= n))"

  needsTimeWithState :: "State \<Rightarrow> FunBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>b \<langle>v,s'\<rangle>) & (clock s') = n))"

  boundedTimeWithState :: "State \<Rightarrow> FunBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>b \<langle>v,s'\<rangle>) & (clock s') <= n))"

  boundedTimeV :: "Value \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeV \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. ? v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>) & (clock s) <= n))"

subsection "Lemmas and stuff"

subsubsection "Example evaluations"

subsubsection "The most primitive expressions"

(* Code: \<lambda> () . 2 *)
(* Comment: a very verbose proof, explicitly naming all rules of the dyn sem *)

lemma "\<langle>fooFun,emptyState\<rangle> \<longrightarrow>\<^sub>b \<langle>(rtInt 2),tick (tick emptyState)\<rangle>"

apply (unfold fooFun_def)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
apply  (rule CoreGrailDynSem.eval_LetDecs.FULLdec)
apply   (rule CoreGrailDynSem.eval_LetDec.VOIDdec)
apply    (rule CoreGrailDynSem.eval_PrimOp.VALop)
apply     (rule CoreGrailDynSem.eval_Value.INTval)
apply (simp)
apply  (rule CoreGrailDynSem.eval_LetDecs.EMPTYdec)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.PRIMres)
apply  (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.OPres)
apply   (rule CoreGrailDynSem.eval_PrimOp.VALop)
apply    (rule CoreGrailDynSem.eval_Value.INTval)
apply (simp_all)
done
(* OK *)

(* Code: \<lambda> () . 2 *)
(* Comment: use a resource predicate for convenience *)

lemma "needsTime fooFun 2"

apply (unfold needsTime_def)
apply (unfold fooFun_def)
apply (rule exI)+
apply (rule conjI)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
apply  (rule CoreGrailDynSem.eval_LetDecs.FULLdec)
apply   (rule CoreGrailDynSem.eval_LetDec.VOIDdec)
apply    (rule CoreGrailDynSem.eval_PrimOp.VALop)
apply     (rule CoreGrailDynSem.eval_Value.INTval)
defer 1
apply  (rule CoreGrailDynSem.eval_LetDecs.EMPTYdec)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.PRIMres)
apply  (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.OPres)
apply   (rule CoreGrailDynSem.eval_PrimOp.VALop)
apply    (rule CoreGrailDynSem.eval_Value.INTval)
apply (simp_all add:tick_def)
apply (simp add:CoreGrailState.State.clock_update_def)
done
(* OK *)

(* Code:    \<lambda> (). 1+1 *)
(* Comment: this predicate specifies an upper bound on the runtime *)

lemma "boundedTime one_plus_one 2"

(* unfold the code *)
apply (unfold one_plus_one_def)
apply (unfold boundedTime_def)
apply (rule exI)+
apply (rule conjI)
(* evaluate the code *)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
apply  (rule CoreGrailDynSem.eval_LetDecs.EMPTYdec)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.PRIMres)
apply  (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.OPres)
apply   (rule CoreGrailDynSem.eval_PrimOp.BINop)
apply    (rule CoreGrailDynSem.eval_Value.INTval)
apply    (rule CoreGrailDynSem.eval_Value.INTval)
apply (simp_all add:tick_def)
done
(* OK *)

(* Code:    \<lambda> (). xx+yy *)
(* Comment: testing variable lookup and stuff *)

lemma "boundedTime xx_plus_yy 3"

apply (unfold boundedTime_def)
apply (unfold xx_plus_yy_def)
apply (rule exI)+
apply (rule conjI)
apply (rule FUNbody)
apply (rule FULLdec)
apply  (rule VALdec)
apply   (rule VALop)
apply    (rule INTval)
defer 1
defer 1
apply (rule FULLdec)
apply  (rule VALdec)
apply   (rule VALop)
apply    (rule INTval)
defer 1
defer 1
apply (rule EMPTYdec)
apply (rule PRIMres)
apply  (rule OPres)
apply   (rule BINop)
apply    (rule VARval)
apply (simp_all)
apply    (rule VARval)
apply (simp_all)
apply (unfold lupd_def)
apply (simp_all add:tick_def)
done
(* OK *)

subsubsection "Function Calls"

(* Code:    (\<lambda> (). 2) () *)
(* Comment: A Lemma over both result and time, using eval_Result *)

lemma "\<langle>fooRes,fooState\<rangle> \<longrightarrow>\<^sub>r \<langle>(rtInt 2),tick (tick (tick fooState))\<rangle>"

(* unfold the code *)
apply (unfold fooRes_def)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.PRIMres)
apply  (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.FUNres)
apply (unfold fooState_def)
apply (unfold fooHeap_def)
apply (unfold get_body_def)
apply (simp)
apply (unfold fooFun_def)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
apply  (rule CoreGrailDynSem.eval_LetDecs.FULLdec)
apply   (rule CoreGrailDynSem.eval_LetDec.VOIDdec)
apply    (rule CoreGrailDynSem.eval_PrimOp.VALop)
apply     (rule CoreGrailDynSem.eval_Value.INTval)
defer 1
apply  (rule CoreGrailDynSem.eval_LetDecs.EMPTYdec)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.PRIMres)
apply  (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.OPres)
apply   (rule CoreGrailDynSem.eval_PrimOp.VALop)
apply    (rule CoreGrailDynSem.eval_Value.INTval)
apply (simp_all)
done
(* OK *)

(* A resource lemma over code including function calls *)
lemma "boundedTimeWithState fooState fooCall 3"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (unfold fooCall_def)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
apply  (rule CoreGrailDynSem.eval_LetDecs.EMPTYdec)
apply (unfold fooRes_def)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.PRIMres)
apply  (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.FUNres)
apply (unfold fooState_def)
apply (unfold fooHeap_def)
apply (unfold get_body_def)
apply (simp)
apply (unfold fooFun_def)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
apply  (rule CoreGrailDynSem.eval_LetDecs.FULLdec)
apply   (rule CoreGrailDynSem.eval_LetDec.VOIDdec)
apply    (rule CoreGrailDynSem.eval_PrimOp.VALop)
apply     (rule CoreGrailDynSem.eval_Value.INTval)
defer 1
apply  (rule CoreGrailDynSem.eval_LetDecs.EMPTYdec)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.PRIMres)
apply  (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.OPres)
apply   (rule CoreGrailDynSem.eval_PrimOp.VALop)
apply    (rule CoreGrailDynSem.eval_Value.INTval)
apply (simp_all add:tick_def)
apply (simp add:CoreGrailState.State.clock_update_def)
done
(* OK *)

lemma "boundedTimeWithState facState FacTwo 4"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (unfold FacTwo_def)
apply (unfold Fac_def)
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.FUNbody)
defer 1
apply (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.PRIMres)
apply  (rule CoreGrailDynSem.eval_PrimRes_eval_Result_eval_FunBody.FUNres)
apply (unfold facState_def)
apply (unfold facHeap_def)
apply (simp_all)
(* apply (simp only:get_body_nodec) *)
apply (unfold get_body_def)
prefer 3
apply  (rule CoreGrailDynSem.eval_LetDecs.FULLdec)
apply   (rule CoreGrailDynSem.eval_LetDec.VALdec)
apply    (rule CoreGrailDynSem.eval_PrimOp.VALop)
apply     (rule CoreGrailDynSem.eval_Value.INTval)
apply (simp_all)
apply  (rule CoreGrailDynSem.eval_LetDecs.FULLdec)
apply   (rule CoreGrailDynSem.eval_LetDec.VALdec)
apply    (rule CoreGrailDynSem.eval_PrimOp.VALop)
apply     (rule CoreGrailDynSem.eval_Value.INTval)
prefer 3
apply  (rule CoreGrailDynSem.eval_LetDecs.EMPTYdec)
apply (simp_all)
(* FAIL; should get body for fac from heap, but for some reason doesn't *)
apply (clarify)


apply (unfold facState_def)
apply (unfold facHeap_def)
apply (unfold tick_def)
defer 1
defer 1
defer 1
defer 1
apply (unfold get_body_def)
(* apply (case_tac) *)
apply (rule FunBody_case)
apply (simp)
apply (simp)
apply   (rule CoreGrailDynSem.eval_VarList.FULLvar)
apply    (rule CoreGrailDynSem.eval_VarList.FULLvar)
apply     (rule CoreGrailDynSem.eval_VarList.EMPTYvar)

(* More on fac? *)

lemma [simp]: "facSpec 0 = one"
apply(simp only:one_def)
apply(auto)
done

subsubsection "Broken lemmas and stuff"

(* proving cheapness-theorem over one specific construct *)
lemma NULLval_cheap: 
  "? v. ? s'. \<langle>NULLval str,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle> \<and> (clock s') = (clock s)"

apply (rule exI)+
apply (rule conjI)
apply (rule Q.eval_Value.NULLval)
apply (simp)
done

lemma INTval_cheap: 
  "? v. ? s'. \<langle>INTval i,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle> \<and> (clock s') = (clock s)"

apply (rule exI)+
apply (rule conjI)
apply (rule Q.eval_Value.INTval)
apply (simp)
done

lemma VARval_cheap: 
  "? v. ? s'. \<langle>VARval x,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle> \<and> (clock s') = (clock s)"

apply (rule exI)+
apply (rule conjI)
apply (rule Q.eval_Value.VARval)
apply (simp)
apply (simp)
done

lemma NULLval_cheap: 
  "! c. ? v. ? s'. \<langle>c,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle> \<and> (clock s') = (clock s)"

apply (rule allI)
apply (rule exI)+
apply (rule conjI)
apply (case_tac c)
prefer 3
apply (simp)
apply (rule Q.eval_Value.NULLval)
prefer 2
apply (rule Q.eval_Value.INTval)
apply (rule Q.eval_Value.VARval)
apply (simp)

(* lemma "? v. ? s'. \<langle>c,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle>"
     & (clock s') <= (clock s)" *)

lemma "! c. ! v. ! s'. \<langle>c,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle> --> (clock s) = (clock s')"

apply (rule allI)+
apply (rule impI)
(* apply (rule conjI) *)
apply (case_tac c)
apply (simp_all)
prefer 3
apply (simp only:NULLval_cheap)

apply (drule exE)
apply (simp_all add:VARval_cheap INTval_cheap NULLval_cheap)
apply (assumption)
apply (simp)
apply (simp)
apply (simp only:NULLval_bonzo)
apply (simp_all only:INTval_cheap)
apply (simp)
apply (rule Q.eval_Value.INTval)
prefer 3
apply (rule Q.eval_Value.NULLval)
apply (rule Q.eval_Value.VARval)

(* *)

(* lemma "\<lbrakk> ? v. \<langle>c,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle> \<rbrakk> \<Longrightarrow> s' = s" *)

apply (case_tac c)
apply (simp_all)
prefer 3
apply (drule someE)
apply (drule exE)


lemma "\<lbrakk> ? v. \<langle>c,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle> \<rbrakk> \<Longrightarrow> (clock s') <= (clock s)"

apply (case_tac c)
apply (simp_all)
prefer 3
apply (simp)
apply (drule CoreGrailDynSem.eval_Value.NULLval)
(* case: NULLvar *)
apply (rule exI)+
apply (simp)
apply (rule CoreGrailDynSem.eval_Value.NULLval)

apply (rule conjI)
apply (simp)
apply (rule CoreGrailDynSem.eval_Value.NULLval)
apply (rule_tac v2="rtVoid" in exI)
apply (rule conjI)
apply (rule VARval)

apply (rule exI)
apply (rule conjI)
apply (case_tac c)
apply (simp)

apply (rule VARval)

lemma "\<lbrakk> boundedTimeV x n1 \<and> boundedTimeV y n2 \<rbrakk>
       \<Longrightarrow>
       boundedTime (FUNbody EMPTYdec (PRIMres (OPres (BINop ADDop x y)))) (n1+n2)"

apply (unfold boundedTime_def)
apply (rule exI)+
apply (rule conjI)
apply (rule FUNbody)
apply  (rule EMPTYdec)
apply  (rule PRIMres)
apply   (rule OPres)
apply    (rule BINop)
prefer 4
apply (unfold boundedTimeV_def)
apply (unfold clock
       
lemma "\<lbrakk> \<exists> s. \<exists> v. (\<langle>x,emptyState\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>) & (clock s) <= n1 ;
         \<exists> s. \<exists> v. (\<langle>y,emptyState\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>) & (clock s) <= n2 \<rbrakk>
       \<Longrightarrow> 
       boundedTime (FUNbody EMPTYdec (PRIMres (OPres (BINop ADDop x y)))) (n1+n2)"


lemma "\<lbrakk> \<exists> s. \<exists> v. (\<langle>l1,emptyState\<rangle> \<longrightarrow>\<^sub>l \<langle>v,s\<rangle>) & (clock s) <= n1 ;
         \<exists> s. \<exists> v. (\<langle>ls,emptyState\<rangle> \<longrightarrow>\<^sub>1 \<langle>v,s\<rangle>) & (clock s) <= n2 \<rbrakk>
       \<Longrightarrow> 
       boundedTime (FUNbody (FULLdec l1 ls) res) (n1+n2)"

apply (unfold boundedTime_def)
apply (rule exI)+
apply (rule conjI)
apply (rule FUNbody)
apply  (rule FULLdec)
apply (simp_all)
(* ToDo: apply rules exactly twice *)
apply (drule exE)+
apply (drule conjE)+
apply (drule exE)+
prefer 10
apply (drule exE)+
apply (drule conjE)+
apply (drule exE)+
apply (simp_all)


lemma "\<lbrakk> \<exists> s. \<exists> v. (\<langle>p1,emptyState\<rangle> \<longrightarrow>\<^sub>p \<langle>v,s\<rangle>) & (clock s) <= n1 ;
         \<exists> s. \<exists> v. (\<langle>p2,emptyState\<rangle> \<longrightarrow>\<^sub>p \<langle>v,s\<rangle>) & (clock s) <= n2 \<rbrakk>
       \<Longrightarrow> 
       boundedTime (FUNbody EMPTYdec (CHOICEres head p1 p2)) (1+(max n1 n2))"

apply (unfold boundedTime_def)
apply (rule exI)+
apply (rule conjI)
apply (rule FUNbody)
apply  (rule EMPTYdec)
apply   (rule CHOICEres)
(* FAIL; need case here *)


end

