(* 
   Title:      CoreGrailAxSem.thy
   ID:         $Id: CoreGrailAxSem.thy,v 1.1 2003/02/15 09:06:14 da Exp $
   Author:     ME
   Copyright:  GPL

   Axiomatic semantics for CoreGrail, Abadi-Leino style.
   VERY INCOMPLETE
*)

theory CoreGrailAxSem = CoreGrailAbsyn + CoreGrailState:

section "Bonzos"

text {*
The structure of the judgement is taken from \cite{Lein98}
\[
 E,\; V  a :  :: R
\]
means ``expression $a$ has type $$ and it satisfies the relation
$R$''; the latter contains references to pre- and post-values for
result, and in our case heap consumption and computation costs.
The environment consists of program environment $E$, a list of
declarations, and $V$ is a list of local variable declarations.

We write $V.(x  ::R)$ for extending the environment $V$ with a
binding of $x$ to type $$ and relation $R$, possibly hiding already
existing bindings for $x$.

Whereas the syntax of the language uses a deep embedding (see CoreGrailAbsSyn.thy)
the assertion language uses a shallow embedding, with assertions essentially
predicates over the state, using meta-logic in the assertion language. A lot
of the techniques, including shallow embedding, are borrowed from Micro/Nano-Java.
*}

subsection "Constants"

(* We use pseudo-(program)-variables to talk about the result of an expression. *)
consts             (* pre- and post-pseudo-variables *)
  r_ :: "Vname" 
  h_ :: "Vname" 
  c_ :: "Vname" 
  rr :: "Vname" 
  hh :: "Vname" 
  cc :: "Vname" 

subsection "Types"

datatype Type = VoidTy 
              | IntTy 
              | BoolTy 
              | StringTy 
              | ListTy Type 
              | ProdTy Type Type 
              | FunTy Type Type

types 
 Relation  = "State \<Rightarrow> Vname list \<Rightarrow> bool"
 Relations = "Relation set"
 Assn      = "Relation"
 AxVal     = "RTVal"
 Env       = "Vname \<leadsto> FunBody * Type * Assn"
 Vass      = "Vname \<leadsto> Type * Assn"

(* Judgement = "Env * Vass * Stmt * Type * Relation" *)

subsection "Aux functions"

(*
constdefs
  get_V     :: "Vass \<Rightarrow> Vname \<Rightarrow> (Type * Relations)"    ("_<_>" [99,0] 99)
 "get_V vass x  \<equiv> (vass x)"
*)

constdefs zero :: int
 "zero \<equiv> 0"
constdefs one :: int
 "one \<equiv> 1"
constdefs two :: int
 "two \<equiv> 2"

(*
constdefs tough :: "Type * Assn"
 "tough \<equiv> (VoidTy, \<lambda> s z. False)"
*)

constdefs tough :: "Type * int * int * (State => RTVal)"
 "tough \<equiv> (VoidTy, zero, zero, \<lambda> s. rtBool False)"

(* TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST TEST *)
constdefs
  bonzoBOP :: "BinOp \<Rightarrow> Value \<Rightarrow> Value \<Rightarrow> (Type * int * int * (State \<Rightarrow> RTVal))"
 "bonzoBOP  binop N M \<equiv> 
  (case binop of
     ADDop \<Rightarrow>
      (case N of 
           VARval vn \<Rightarrow> 
               (case M of 
                 VARval vm \<Rightarrow> (IntTy, one, zero, \<lambda> s. (rtInt ((the_Int (s<vn>))+(the_Int (s<vm>)))))
               | INTval i \<Rightarrow> tough
               | NULLval s \<Rightarrow> tough)
         | INTval i \<Rightarrow> tough
         | NULLval s \<Rightarrow> tough)
    | SUBop \<Rightarrow> tough
    | MULop \<Rightarrow> tough)"

constdefs  
  leinoBOP :: "BinOp \<Rightarrow> Value \<Rightarrow> Value \<Rightarrow> (Type * int * int * (State \<Rightarrow> RTVal))"
 "leinoBOP binop N M \<equiv> 
  (case binop of
     ADDop \<Rightarrow>
      (case N of 
          VARval vn \<Rightarrow> 
               (case M of 
                VARval vm \<Rightarrow> (IntTy, one, zero, \<lambda> s. (rtInt ((the_Int (s<vn>))+(the_Int (s<vm>)))))
              | INTval i \<Rightarrow>  (IntTy, one, zero, \<lambda> s. (rtInt ((the_Int (s<vn>))+i)))
              | NULLval s \<Rightarrow> tough)
        | INTval i \<Rightarrow>
      	       (case M of 
      	        VARval vm \<Rightarrow> (IntTy, one, zero, \<lambda> s. (rtInt ((i+(the_Int (s<vm>))))))
      	      | INTval j \<Rightarrow>  (IntTy, one, zero, \<lambda> s. (rtInt (i+j)))
      	      | NULLval s \<Rightarrow> tough)
        | NULLval s \<Rightarrow> tough)
   | SUBop \<Rightarrow>
      (case N of 
          VARval vn \<Rightarrow> 
               (case M of 
                VARval vm \<Rightarrow> (IntTy, one, zero, \<lambda> s. (rtInt (((the_Int (s<vn>))-(the_Int (s<vm>))))))
              | INTval i \<Rightarrow>  (IntTy, one, zero, \<lambda> s. (rtInt ((the_Int (s<vn>))-i)))
              | NULLval s \<Rightarrow> tough)
        | INTval i \<Rightarrow>
      	   (case M of 
      	    VARval vm \<Rightarrow> (IntTy, one, zero, \<lambda> s. (rtInt (i-(the_Int (s<vm>)))))
      	  | INTval j \<Rightarrow>  (IntTy, one, zero, \<lambda> s. (rtInt (i-j)))
      	  | NULLval s \<Rightarrow> tough)
        | NULLval s \<Rightarrow> tough)
   | MULop \<Rightarrow>
      (case N of 
          VARval vn \<Rightarrow> 
               (case M of 
                VARval vm \<Rightarrow> (IntTy, one, zero, \<lambda> s. (rtInt ((the_Int (s<vn>))*(the_Int (s<vm>)))))
              | INTval i \<Rightarrow>  (IntTy, one, zero, \<lambda> s. (rtInt ((the_Int (s<vn>))*i)))
              | NULLval s \<Rightarrow> tough)
        | INTval i \<Rightarrow>
      	   (case M of 
      	    VARval vm \<Rightarrow> (IntTy, one, zero, \<lambda> s. (rtInt ((i*(the_Int (s<vm>))))))
      	  | INTval j \<Rightarrow>  (IntTy, one, zero, \<lambda> s. (rtInt (i*j)))
      	  | NULLval s \<Rightarrow> tough)
        | NULLval s \<Rightarrow> tough))"

constdefs 
  leinoTest :: "Test \<Rightarrow> Value \<Rightarrow> Value \<Rightarrow> (Type * int * int * (State \<Rightarrow> RTVal))"
 "leinoTest test N M \<equiv> 
  (case test of
   EQUALStest \<Rightarrow>
      (case N of 
          VARval vn \<Rightarrow> 
             (case M of 
	         VARval vm \<Rightarrow> (BoolTy, one, zero, \<lambda> s. (rtBool ((the_Int (s<vn>))=(the_Int (s<vm>)))))
	       | INTval i \<Rightarrow> (BoolTy, one, zero, \<lambda> s. (rtBool ((the_Int (s<vn>))=i)))
	       | NULLval s \<Rightarrow> tough)
        | INTval i \<Rightarrow>
             (case M of 
	         VARval vm \<Rightarrow> (BoolTy, one, zero, \<lambda> s. (rtBool (i=(the_Int (s<vm>)))))
	       | INTval j \<Rightarrow> (BoolTy, one, zero, \<lambda> s. (rtBool (i=j)))
	       | NULLval s \<Rightarrow> tough)
        | NULLval s \<Rightarrow> tough)
   | IStest \<Rightarrow>
      (case N of 
          VARval vn \<Rightarrow> 
             (case M of 
	         VARval vm \<Rightarrow> tough
	       | INTval i \<Rightarrow> tough
	       | NULLval s \<Rightarrow> tough)
        | INTval i \<Rightarrow> tough
        | NULLval s \<Rightarrow> tough)
   | LESStest \<Rightarrow>
      (case N of 
          VARval vn \<Rightarrow> 
             (case M of 
	         VARval vm \<Rightarrow> (BoolTy, one, zero, \<lambda> s. (rtBool ((the_Int (s<vn>))<(the_Int (s<vm>)))))
	       | INTval i \<Rightarrow> (BoolTy, one, zero, \<lambda> s. (rtBool ((the_Int (s<vn>))<i)))
	       | NULLval s \<Rightarrow> tough)
        | INTval i \<Rightarrow>
             (case M of 
	         VARval vm \<Rightarrow> (BoolTy, one, zero, \<lambda> s. (rtBool (i<(the_Int (s<vm>)))))
	       | INTval j \<Rightarrow> (BoolTy, one, zero, \<lambda> s. (rtBool (i<j)))
	       | NULLval s \<Rightarrow> tough)
        | NULLval s \<Rightarrow> tough))"

(* reverse direction for subst: rep is a "replace-with" function *)
constdefs
  appSubst :: "(Vname \<Rightarrow> Vname option) \<Rightarrow> State \<Rightarrow> State"
 "appSubst f s \<equiv> s \<lparr> heap := heap s, locals := \<lambda> x. if (f x) \<noteq> None then locals s (the (f x)) else locals s x , clock := clock s, heapsz := heapsz s \<rparr>" 

subsection "Program Logic Rules"

consts
 leino_Result   :: "(Env * Vass * Result * Type * Assn) set"
 leino_PrimRes  :: "(Env * Vass * PrimRes * Type * Assn) set"
 leino_CondHead :: "(Env * Vass * CondHead * Type * Assn) set"
 leino_PrimOp   :: "(Env * Vass * PrimOp * Type * Assn) set"
 leino_Value    :: "(Env * Vass * Value * Type * Assn) set"
 leino_LetDec   :: "(Env * Vass * LetDec * Vass * Type * Assn) set"
 leino_LetDecs  :: "(Env * Vass * LetDecs * Vass * Type * Assn) set"
 leino_Arg      :: "(Env * Vass * Arg * Type * Assn) set"
 leino_ArgList  :: "(Env * Vass * ArgList * Type * Assn) set"
 leino_FunBody  :: "(Env * Vass * FunBody * Type * Assn) set"
 leino_FunDec   :: "(Env * Vass * FunDec * Vass * Type * Assn) set"
 leino_FunDecs  :: "(Env * Vass * FunDecs * Vass * Type * Assn) set"

(* prettier syntax following Abadi-Leino "_, _ \<turnstile> _ : _ :: _" *)
syntax
 leino_Result   :: "[Env, Vass, Result, Type, Assn] \<Rightarrow> bool"   ("_, _ \<turnstile>\<^sub>r _ : _ :: _")
 leino_PrimRes  :: "[Env, Vass, PrimRes, Type, Assn] \<Rightarrow> bool"  ("_, _ \<turnstile>\<^sub>p _ : _ :: _")
 leino_CondHead :: "[Env, Vass, CondHead, Type, Assn] \<Rightarrow> bool" ("_, _ \<turnstile>\<^sub>c _ : _ :: _")
 leino_PrimOp   :: "[Env, Vass, PrimOp, Type, Assn] \<Rightarrow> bool"   ("_, _ \<turnstile>\<^sub>o _ : _ :: _")
 leino_Value    :: "[Env, Vass, Value, Type, Assn] \<Rightarrow> bool"    ("_, _ \<turnstile>\<^sub>v _ : _ :: _")
 leino_LetDec   :: "[Env, Vass, LetDec, Vass, Type, Assn] \<Rightarrow> bool"   ("_, _ \<turnstile>\<^sub>l _ : _ : _ :: _")
 leino_LetDecs  :: "[Env, Vass, LetDecs, Vass, Type, Assn] \<Rightarrow> bool"  ("_, _ \<turnstile>\<^sub>1 _ : _ : _ :: _")
 leino_Arg      :: "[Env, Vass, Arg, Type, Assn] \<Rightarrow> bool"      ("_, _ \<turnstile>\<^sub>a _ : _ :: _")
 leino_ArgList  :: "[Env, Vass, ArgList, Type, Assn] \<Rightarrow> bool"  ("_, _ \<turnstile>\<^sub>2 _ : _ :: _")
 leino_FunBody  :: "[Env, Vass, FunBody, Type, Assn] \<Rightarrow> bool"  ("_, _ \<turnstile>\<^sub>b _ : _ :: _")
 leino_FunDec   :: "[Env, Vass, Arg, FunDec, Vass, Type, Assn] \<Rightarrow> bool"    ("_, _ \<turnstile>\<^sub>f _ : _ : _ :: _")
 leino_FunDecs  :: "[Env, Vass, Arg, FunDecs, Vass, Type, Assn] \<Rightarrow> bool"   ("_, _ \<turnstile>\<^sub>3 _ : _ : _ :: _")

translations
 "E, V \<turnstile>\<^sub>r c : t :: R" == "(E, V, c, t, R) :  leino_Result"
 "E, V \<turnstile>\<^sub>p c : t :: R" == "(E, V, c, t, R) :  leino_PrimRes"
 "E, V \<turnstile>\<^sub>c c : t :: R" == "(E, V, c, t, R) :  leino_CondHead"
 "E, V \<turnstile>\<^sub>o c : t :: R" == "(E, V, c, t, R) :  leino_PrimOp"
 "E, V \<turnstile>\<^sub>v c : t :: R" == "(E, V, c, t, R) :  leino_Value"
 "E, V \<turnstile>\<^sub>l c : V' : t :: R" == "(E, V, c, V', t, R) :  leino_LetDec"
 "E, V \<turnstile>\<^sub>1 c : V' : t :: R" == "(E, V, c, V', t, R) :  leino_LetDecs"
 "E, V \<turnstile>\<^sub>a c : t :: R" == "(E, V, c, t, R) :  leino_Arg"
 "E, V \<turnstile>\<^sub>2 c : t :: R" == "(E, V, c, t, R) :  leino_ArgList"
 "E, V \<turnstile>\<^sub>b c : t :: R" == "(E, V, c, t, R) :  leino_FunBody"
 "E, V \<turnstile>\<^sub>f c : V' : t :: R" == "(E, V, c, V', t, R) :  leino_FunDec"
 "E, V \<turnstile>\<^sub>3 c : V' : t :: R" == "(E, V, c, V', t, R) :  leino_FunDecs"

inductive leino_Value intros
 VARval:  "\<lbrakk> (ty,R) = the (V x) \<rbrakk> \<Longrightarrow> E, V \<turnstile>\<^sub>v (VARval x) : ty :: (\<lambda> s z. R s z \<and> (s<r_>=s<x>))"
 INTval:  "E, V \<turnstile>\<^sub>v (INTval i) : IntTy :: \<lambda> s z. s<r_>=(rtInt i)"
 NULLval: "E, V \<turnstile>\<^sub>v (NULLval str) : ListTy IntTy :: \<lambda> s z. s<r_>=rtRef nullRef"  (* ToDo: polymorphic elem type *)

inductive leino_PrimOp intros
 VALop: "\<lbrakk> E, V \<turnstile>\<^sub>v x : ty :: R \<rbrakk> 
         \<Longrightarrow> 
         E, V \<turnstile>\<^sub>o (VALop x) : ty :: R"
 BINop: "\<lbrakk> E, V \<turnstile>\<^sub>v v1 : ty1 :: R1 ; E, V \<turnstile>\<^sub>v v2 : ty2 :: R2 ; (ty,cb,hb,fr) = leinoBOP b r1 r2 \<rbrakk>
         \<Longrightarrow>
         E, V \<turnstile>\<^sub>o (BINop b v1 v2) : ty :: (\<lambda> s z. R1 s z \<and> R2 s z \<and> s<r_>=fr s)"

inductive leino_PrimRes leino_Result leino_FunBody leino_CondHead intros
 OPres: "\<lbrakk> E, V \<turnstile>\<^sub>o p : ty :: R \<rbrakk>
         \<Longrightarrow>
         E, V \<turnstile>\<^sub>p (OPres p) : ty :: R"
 VOIDres: "E, V \<turnstile>\<^sub>p VOIDres : VoidTy :: (\<lambda> s z. s<r_>=rtVoid)"
 FUNres: "\<lbrakk> (bdy,ty,R) = the (E f) ; E, V \<turnstile>\<^sub>b bdy : ty :: R \<rbrakk>
          \<Longrightarrow>
          E, V \<turnstile>\<^sub>p (FUNres f xs) : ty :: R"

 PRIMres: "\<lbrakk> E, V \<turnstile>\<^sub>p p : ty :: R \<rbrakk>
           \<Longrightarrow>
           E, V \<turnstile>\<^sub>r (PRIMres p) : ty :: R"
 CHOICEres: "\<lbrakk> E, V \<turnstile>\<^sub>c head : BoolTy :: R ; 
               E, V \<turnstile>\<^sub>p p1 : ty :: R1 ; 
               E, V \<turnstile>\<^sub>p p2 : ty :: R2 \<rbrakk>
             \<Longrightarrow>
             E, V \<turnstile>\<^sub>r (CHOICEres head p1 p2) : ty :: 
             (\<lambda> s z. 
              (\<exists> r'. \<exists> h'. \<exists> c'. \<exists> h''. \<exists> c''. 
               R (appSubst ((\<lambda>x::Vname. None)(r':=(Some r_),h':=(Some h_),c':=(Some c_))) s) z \<and> 
               (s<r'>=(rtBool True)) \<longrightarrow> R1 (appSubst ((\<lambda>x::Vname. None)(h'':=(Some h_), c'':=(Some c_))) s) z \<and>
               (s<r'>=(rtBool False)) \<longrightarrow> R2 (appSubst ((\<lambda>x::Vname. None)(h'':=(Some h_), c'':=(Some c_))) s) z \<and>
               s<h_>=(rtInt ((s<h'>\<^sub>i)+(s<h''>\<^sub>i))) \<and> 
               s<c_>=(rtInt ((s<c'>\<^sub>i)+(s<c''>\<^sub>i)))))"

 FUNbody: "\<lbrakk> E, V \<turnstile>\<^sub>1 decls : V' : VoidTy :: R ; 
             E, V' \<turnstile>\<^sub>r res : ty :: R \<rbrakk>
          \<Longrightarrow>
          E, V \<turnstile>\<^sub>b (FUNbody decls res) : ty :: R"

 CONDhead: "\<lbrakk> 
              E, V \<turnstile>\<^sub>v v1 : ty1 :: R1 ;
              E, V \<turnstile>\<^sub>v v2 : ty2 :: R2 ;
              (t',ct,ht,fr) = leinoTest t v1 v2 
           \<rbrakk>
            \<Longrightarrow>
            E, V \<turnstile>\<^sub>c CONDhead v1 t v2 : BoolTy :: 
            (\<lambda> s z.
             (\<exists> r1'. \<exists> r2'. \<exists> h1'. \<exists> h2'. \<exists> c1'. \<exists> c2'.
              (R1 (appSubst ((\<lambda>x::Vname. None)(r1':=(Some r_), h1':=(Some h_), c1':=(Some c_))) s) z) \<and>
              (R2 (appSubst ((\<lambda>x::Vname. None)(r2':=(Some r_), h2':=(Some h_), c2':=(Some c_))) s) z) \<and>
              s<r_>=(fr s) \<and> 
              s<h_>=(rtInt (ht+s<h1'>\<^sub>i+s<h2'>\<^sub>i)) \<and> 
              s<c_>=(rtInt (ct+s<c1'>\<^sub>i+s<c2'>\<^sub>i))))"

inductive leino_LetDecs intros
 EMPTYdec: "E, V \<turnstile>\<^sub>1 EMPTYdec : V : VoidTy :: \<lambda> s z.  s<r_>=rtVoid"
 FULLdec: "\<lbrakk> E, V \<turnstile>\<^sub>l l : V' : ty1 :: R1 ; E, V' \<turnstile>\<^sub>1 ls : V'' : tys :: Rs \<rbrakk>
           \<Longrightarrow>
           E, V \<turnstile>\<^sub>1 (FULLdec l ls) : V'' : tys :: 
           (\<lambda> s z.
           (\<exists> h1. \<exists> h2. \<exists> c1. \<exists> c2 .
             R1 (appSubst ((\<lambda>x::Vname. None::Vname option)(h1:=(Some h_), c1:=(Some c_))) s) z \<and>
             Rs (appSubst ((\<lambda>x::Vname. None::Vname option)(h2:=(Some h_), c2:=(Some c_))) s) z \<and>
             (s<r_>=rtVoid) \<and> 
             (s<h_>=(rtInt (s<h1>\<^sub>i+s<h2>\<^sub>i))) \<and> 
             (s<c_>=(rtInt (s<c1>\<^sub>i+s<c2>\<^sub>i)))))"

inductive leino_LetDec intros
 VALdec: "\<lbrakk> E, V \<turnstile>\<^sub>o p : ty :: R \<rbrakk>
          \<Longrightarrow>
          E, V \<turnstile>\<^sub>l (VALdec x p) : V(x \<mapsto> (ty,R)) : ty :: (\<lambda> s z. R s z \<and> s<r_>=rtVoid)"
 VOIDdec: "\<lbrakk> E, V \<turnstile>\<^sub>o p : ty :: R \<rbrakk>
           \<Longrightarrow>
           E, V \<turnstile>\<^sub>l (VOIDdec p) : V : ty :: (\<lambda> s z. R s z \<and> s<r_>=rtVoid)"

(* ToDo: ; V' = V.(x \<mapsto> (ty,R)) *)

inductive leino_ArgList intros
 EMPTYal: "E, V \<turnstile>\<^sub>2 EMPTYal : VoidTy :: \<lambda> s z. s<r_>=rtVoid"
 FULLal:  "\<lbrakk> E, V \<turnstile>\<^sub>a a : ty1 :: R1 ; E, V \<turnstile>\<^sub>2 as : tys :: Rs \<rbrakk>
           \<Longrightarrow>
           E, V \<turnstile>\<^sub>2 (FULLal a as) : ProdTy ty1 tys :: 
           (\<lambda> s z. 
           (\<exists> h1. \<exists> h2. \<exists> c1. \<exists> c2 .
               R1 (appSubst ((\<lambda>x::Vname. None)(h1:=(Some h_), c1:=(Some c_))) s) z \<and> 
               Rs (appSubst ((\<lambda>x::Vname. None)(h2:=(Some h_), c2:=(Some c_))) s) z \<and>
               s<r_>=rtVoid \<and> 
               s<h_>=(rtInt (s<h1>\<^sub>i+s<h2>\<^sub>i)) \<and>
               s<c_>=(rtInt (s<c1>\<^sub>i+s<c2>\<^sub>i))))"

inductive leino_FunDecs intros
 EMPTYfundec: "E, V \<turnstile>\<^sub>3 EMPTfundec : V : VoidTy :: \<lambda> s z. s<r_>=rtVoid"
 FULLfundec:  "\<lbrakk> E, V \<turnstile>\<^sub>f f : V' : ty1 :: R1 ; E, V' \<turnstile>\<^sub>3 fs : Vs : tys :: Rs \<rbrakk>
           \<Longrightarrow>
           E, V \<turnstile>\<^sub>3 (FULLfundec f fs) : Vs : FunTy ty1 tys :: 
           (\<lambda> s z. 
           (\<exists> h1. \<exists> h2. \<exists> c1 . \<exists> c2 .
             R1 (appSubst ((\<lambda>x::Vname. None)(h1:=(Some h_), c1:=(Some c_))) s) z \<and> 
             Rs (appSubst ((\<lambda>x::Vname. None)(h2:=(Some h_), c2:=(Some c_))) s) z \<and>
             s<r_>=rtVoid \<and> 
             s<h_>=(rtInt (s<h1>\<^sub>i+s<h2>\<^sub>i)) \<and> 
             s<c_>=(rtInt (s<c1>\<^sub>i+s<c2>\<^sub>i))))"

inductive leino_FunDec intros
 FDEC: "\<lbrakk> E, V \<turnstile>\<^sub>2 args : ty :: R ;
          E, V \<turnstile>\<^sub>b b : ty' :: R' \<rbrakk>
        \<Longrightarrow> 
        E, V \<turnstile>\<^sub>f (FDEC fname args b) : V(fname \<mapsto> (ty,R)) : FunTy ty ty':: 
         (\<lambda> s z. R s z \<and> R' (hupd fname args b s) z)"

(* ToDo:           V' = V.(fname \<mapsto> (ty,R)) ; *)

end