;; grail.el	Tiny Emacs mode for GRAIL programs
;;
;; David Aspinall
;;
;; $Id: grail.el,v 1.4 2004/02/17 15:30:07 a1hloidl Exp $
;;
;;
;; To use this put (load "path/to/this/file/grail.el") in your 
;; .emacs or .xemacs/init.el file.
;;
;; ---------------------------------------------------------------------------

;@menu
;* Auto loading::		
;* old mode definition::	
;* Aux thingies::		
;* The major mode::		
;* Fonts::			
;@end menu

;@node Auto loading, old mode definition
;@section Auto loading

(unless (featurep 'grail)  ;; don't add it twice
  (setq auto-mode-alist
	(cons '("\\.gr$" . grail-mode) auto-mode-alist)))

;@node old mode definition, Aux thingies, Auto loading
;@section old mode definition

;; (define-derived-mode grail-mode fundamental-mode "GRAIL"
;;   ;; Block comments
;;   (modify-syntax-entry ?\* ". 23")
;;   ;;(modify-syntax-entry ?\( "//1")
;;   ;; (modify-syntax-entry ?\) ")(4")
;;   ;; No indentation!
;;   ;; Font lock
;;   (setq font-lock-keywords grail-font-lock-keywords))

;@node Aux thingies, The major mode, old mode definition
;@section Aux thingies

(defvar emacs-type
  ;; from emacs-vers.el
  (cond ((string-match "XEmacs" emacs-version)
	 ;; NOTE that this "XEmacs" test must come before the
	 ;; "Lucid" test.
	 'xemacs)
	((string-match "Lucid" emacs-version)
	 'lucid)
	((and (boundp 'epoch::version)
	      ;; I have heard of poorly-written packages that
	      ;; bind `epoch::version' to `nil', so we're extra
	      ;; paranoid here.
	      ;;
	      ;; This `symbol-value' stuff is here in order to
	      ;; avoid a warning from the byte-compiler about
	      ;; "reference to free variable epoch::version."
	      (stringp (symbol-value 'epoch::version))
	      (string-match "Epoch"
			    (symbol-value 'epoch::version)))
	 'epoch)
	(t
	 'fsf))
  "Type of emacs: 'fsf, 'xemacs, 'lucid, or 'epoch")

;@node The major mode, Fonts, Aux thingies
;@section The major mode

(defvar grail-mode-syntax-table nil
  "Syntax table in use in Grail mode buffers.")

;; build it if it doesn't exist, yet
(if grail-mode-syntax-table
    ()
  (setq grail-mode-syntax-table (make-syntax-table))
  ; backslash is an escape sequence
  (modify-syntax-entry ?\\ "\\" grail-mode-syntax-table)
  ; ( is first character of comment start
  (modify-syntax-entry ?\( "()1" grail-mode-syntax-table)
  ; * is second character of comment start,
  ; and first character of comment end
  (modify-syntax-entry ?*  ". 23" grail-mode-syntax-table)
  ; ) is last character of comment end
  (modify-syntax-entry ?\) ")(4" grail-mode-syntax-table)
  (modify-syntax-entry ?/ "(12b" grail-mode-syntax-table)
  ; backquote was a string-like delimiter (for character literals)
  ; (modify-syntax-entry ?` "\"" grail-mode-syntax-table)
  ; quote and underscore are part of words
  (modify-syntax-entry ?. "w" grail-mode-syntax-table)
  (modify-syntax-entry ?' "w" grail-mode-syntax-table)
  (modify-syntax-entry ?_ "w" grail-mode-syntax-table))

(defvar grail-mode-map nil
  "Keymap used in Grail mode.")

(if (fboundp 'grail-oo-face)
    nil
  (make-face 'grail-oo-face)
  ;;(make-face-bold 'grail-oo-face)
  (set-face-foreground 'grail-oo-face "Blue")
  (set-face-background 'grail-oo-face "White")
)

(defun grail-mode ()
  "Major mode for editing Grail code.

\\{grail-mode-map}"

  (interactive)
  (kill-all-local-variables)
  (setq major-mode 'grail-mode)
  (setq mode-name "Grail")
  (use-local-map grail-mode-map)
  (set-syntax-table grail-mode-syntax-table)
;;   (setq local-abbrev-table grail-mode-abbrev-table)
  (make-local-variable 'paragraph-start)
  (setq paragraph-start (concat "^$\\|" page-delimiter))
  (make-local-variable 'paragraph-separate)
  (setq paragraph-separate paragraph-start)
  (make-local-variable 'paragraph-ignore-fill-prefix)
  (setq paragraph-ignore-fill-prefix t)
  (make-local-variable 'require-final-newline)
  (setq require-final-newline t)
  (make-local-variable 'comment-start)
  (setq comment-start "(*")
  (make-local-variable 'comment-end)
  (setq comment-end "*)")
  (make-local-variable 'comment-column)
  (setq comment-column 40)
  (make-local-variable 'comment-start-skip)
  (setq comment-start-skip "(\\*+ *")
  (make-local-variable 'parse-sexp-ignore-comments)
  (setq parse-sexp-ignore-comments nil)
  (make-local-variable 'indent-line-function)
  (setq indent-line-function 'camelot-indent-command)
  ;; font-lock support
  ;(setq font-lock-warning-face 'grail-oo-face)
  (make-local-variable 'font-lock-defaults)
  (setq font-lock-defaults '(grail-font-lock-keywords nil t))
  (run-hooks 'grail-mode-hook))


;@node Fonts,  , The major mode
;@section Fonts

(defun grail-ids-to-regexp (l)
  "Maps a non-empty list of tokens `l' to a regexp matching any element"
  (mapconcat (lambda (s) (concat "\\<" s "\\>")) l "\\|"))

(defconst grail-types
  '("int" "float" "string" "void" ))

(defconst grail-oo-keywords 
  '( ;;  see gdf/src/Lexer.lex
     ;; oo stuff
     "alias" "class" "field" "method" 
     "new" "checkcast" "extends" "implements" "instanceof"))

(defconst grail-type-keywords
  '( ;;  see gdf/src/Lexer.lex
     ;; types
     "int" "boolean" "float" "ref" "void"))

(defconst grail-modifier-keywords 
  '( ;;  see gdf/src/Lexer.lex
     ;; modifiers
     "public" "private" "protected" "static" "final"))

(defconst grail-keywords 
  '( ;;  see gdf/src/Lexer.lex
     "let" "fun" "in" "and" "end" "val" "if" "then" "else"
     ;; invokes
     "invokestatic" "invokevirtual" "invokespecial" "invokeinterface"
     ;; fields
     "getfield" "putfield" "getstatic" "putstatic"
     ;; (bin) ops
     "add"  "mul" "sub" "div" "mod" "null"
     ;; arrays
     "makearray" "get" "set" "length" "empty" 
     ;; numeric
     "itof" "ftoi"
     "string"))

(defconst grail-font-lock-keywords
  (list 
   `(,(grail-ids-to-regexp grail-keywords) . 'font-lock-keyword-face)
   `(,(grail-ids-to-regexp grail-oo-keywords ) . 'grail-oo-face)
   `(,(grail-ids-to-regexp grail-modifier-keywords ) . 'font-lock-function-face)
   `(,(grail-ids-to-regexp grail-type-keywords) . 'font-lock-type-face)))

(provide 'grail)
