(* Time-stamp: <Thu Aug 04 2005 23:57:32 Stardate: [-29]4349.57 hwloidl> *)
(* $Id: CertGenC.sml,v 1.15.2.7 2005/08/04 22:09:15 a1hloidl Exp $ *)
(* ------------Certificate generation at consumer side: Certificate2 & Certificate3 ----------------*)



fun fst (x,y) = x
fun snd (x,y) = y
fun id x = x

val slash = "\\"
val newline = "\n"

(* functions hardwired into the compiler; ToDo: define this in Lib.sml and import -- HWL *)
val magic_funs = ["atol$","atol1$","atol$_1","atol1$_1","atol1$_2","atol1$_3","main","start","dummy","start_1","start_2","show_list0","show_list","stringList_to_intList"]

(*
val logic_version = ref 6
val tactic_flavour = ref 0
*)
val which_wrapper = ref 0 (* default: hacked one for demo *)

(*stolen from Camelot/src/Util.sml*)
fun listToString toString separator l =
case l of [] => ""
        | [h] => toString h
        | h::t => (toString h) ^ separator ^ (listToString toString separator t)

(* Don't want messages mixed with syntax going to stdout *)
(*
fun printToStdErr s = 
    if not (!ToyGrailAbsyn.shut_up) then
	TextIO.output(TextIO.stdErr, s)
else ()
*)
fun printToStdErr s = TextIO.output(TextIO.stdErr, s)

fun mkCorrectlemma_Name methodname = methodname ^ "_Correct"

fun mkCorrectlemma className thySyntax (m as {flags, name, msig as (m_args, m_ret), attrs}: Classdecl.method_decl) =
 if name = "<init>" then ("","")
 else
  let
    val tac_str = case (thySyntax) of
                5 => " by (WpGenL " ^ name ^ "_pdefs)\n\n"           (* pre-demo version *)
              | 6 => " by (W " ^ name ^ "_pdefs)\n\n"                (* post-demo version *)
              | 7 => " by (method_Weaks, ltac7gen,  fastsimp)\n\n"   (* HWL hacked here *)
              | _ =>  " by (W " ^ name ^ "_pdefs)\n\n"               (* default: post-demo version *)
  in
    ((* "ML {* val global_v = global_v_"^name^" *}\n"^ *)
     "lemma " ^ mkCorrectlemma_Name name ^ 
             ": \" Context " ^ slash ^ "<rhd> snd (methtable " ^
             className ^ " " ^ (*className ^ "'" ^ *) name ^ "_) : SPEC " ^ (* className ^ "'" ^ *) name ^ "_\" " ^ (* HWL: should be (unqual name) but unqual not in scope! *)
             newline ^ tac_str, mkCorrectlemma_Name name )
   end
(* ToDo: ship part of zz_map as a translation table and use it here to get proper method name!! *)

fun makeCert2 cname thySyntax tFlavour mdecls outDir =
  let val theoryname = cname ^ "_Consumer1"
      val s1 = "theory " ^ theoryname ^ " = " ^ cname ^ "Certificate + " ^cname ^"_TACTIC:" ^ newline ^ newline
      (* useful sanity check *)	       
      val mdecls':Classdecl.method_decl list 
                 = List.filter (fn x => not (GrailUtils.is_elem (#name x ) magic_funs)) mdecls (* nuke_magic_funs *) 

      val s01 = "lemma Context_finite[simp]: \"finite Context\" by (simp add: Context_def)" ^ newline

      val s02 = "lemma \"CERT_prg_name = ''"^cname^"''\"\nby (simp add: CERT_prg_name_def)"^newline
                (* more sanity checks 
                "lemma \"logic_version = "^(Int.toString thySyntax)^"\" by (simp add: logic_version_def)"^newline^
                "lemma \"tactic_flavour = "^(Int.toString tFlavour)^"\" by (simp add: tactic_flavour_def)"^newline^newline
		*)

      val (s2,s3) =
        List.foldl 
               (fn mds => let val entry = mkCorrectlemma cname thySyntax (fst mds)
                          in ((fst (snd mds)) ^ (fst entry), 
                              (snd (snd mds)) ^ " " ^ (snd entry))
                          end)
               ("","")
               mdecls'
      val s4 = "lemmas MethodbodiesCorrect =" ^ s3 ^ newline
      val s = s1 ^ s01 ^ s02 ^ s2 ^ s4 ^ "end" ^ newline
      val fname = GrailUtils.makeFullFilename outDir theoryname "thy"
      val os = TextIO.openOut fname
      val () = TextIO.output(os,s)
      val () = TextIO.closeOut os  
      val () = printToStdErr ("Wrote "^fname^"\n")
  in 
     () (* YUCK *)
  end

(*
fun makeCert4 cname mdecls outDir =
  let val theoryname = cname ^ "_Consumer4"
      val s1 = "theory " ^ theoryname ^ " = " ^ cname ^ "Certificate + Generic_TACTIC:" ^ newline ^ newline
      (* useful sanity check *)	       
      val mdecls':Classdecl.method_decl list 
                 = List.filter (fn x => not (GrailUtils.is_elem (#name x ) magic_funs)) mdecls (* nuke_magic_funs *) 

      val s01 = "lemma Context_finite[simp]: \"finite Context\" by (simp add: Context_def)" ^ newline

      val s02 = "lemma \"CERT_prg_name = ''"^cname^"''\"\nby (simp add: CERT_prg_name_def)"^newline^ newline
      val (s2,s3) =
        List.foldl 
               (fn mds => let val entry = mkCorrectlemma cname (fst mds)
                          in ((fst (snd mds)) ^ (fst entry), 
                              (snd (snd mds)) ^ " " ^ (snd entry))
                          end)
               ("","")
               mdecls'
      val s4 = "lemmas MethodbodiesCorrect =" ^ s3 ^ newline
      val s = s1 ^ s01 ^ s02 ^ s2 ^ s4 ^ "end" ^ newline
      val fname = GrailUtils.makeFullFilename outDir theoryname "thy"
      val os = TextIO.openOut fname
      val () = TextIO.output(os,s)
      val () = TextIO.closeOut os  
      val () = printToStdErr ("Wrote "^fname^"\n")
  in 
     () (* YUCK *)
  end
*)

fun ff Jvmtype.Tboolean i = "TBOOL"
  | ff Jvmtype.Tchar i = "TCHAR"
  | ff Jvmtype.Tfloat i = "TFLOAT"
  | ff Jvmtype.Tdouble i = "TDOUBLE"
  | ff Jvmtype.Tbyte i = "TBYTE"
  | ff Jvmtype.Tshort i = "TSHORT"
  | ff Jvmtype.Tint i = "INarg x" ^ (Int.toString i)
  | ff Jvmtype.Tlong i = "TLONG"
  | ff (Jvmtype.Tarray tp) i = "TARRAY[??]"
  | ff (Jvmtype.Tclass c) i = "RNarg x" ^ (Int.toString i)

fun f [] i = ""
  | f [h] i = ff h i
  | f (h :: t) i = (ff h i) ^ "," ^ f t (i+1)

fun arbargs args = "[" ^ (f args 0) ^ "]"

fun MDECL2THM cname (m as {flags, name, msig as (m_args, m_ret), attrs}: Classdecl.method_decl, s) =
          let val arguments = arbargs m_args
          in if name = "<init>" then s
             else ("theorem T_" ^ name ^ 
               ": \"" ^ slash ^ "<rhd> " ^ cname ^ slash ^ 
               "<bullet>" ^ (* cname ^ "'" ^ *) name ^ "_ (" ^ 
               arguments ^ ") : sMST " ^ cname ^ " " ^ 
               (* cname ^ "'" ^ *) name ^ "_ " ^ arguments ^ "\"" ^ 
               newline ^ 
               "by (fastsimp intro: Context_good GCInvs simp: ctxt_def)" ^ 
               newline ^ newline ^ s)
           end

fun makeCert3 cname mdecls outDir =
  let val theoryname = cname ^ "_Consumer2"
      val s1 = "theory " ^ theoryname ^ " = " ^ cname ^ "_Consumer1:" ^ newline
      val s2 = "lemma triv: \"" ^ slash ^ "<lbrakk>x:S; S=S1; x:S1 " ^ slash ^
               "<longrightarrow> P" ^ slash ^ "<rbrakk>" ^ slash ^ 
               "<Longrightarrow> P\" by simp" ^ newline
      val s3 = "lemma Context_good: \"goodContext FST vMST sMST Context\"" ^ newline ^
                "apply (simp only: goodContext_def)" ^ newline ^
                "apply (intro strip)" ^ newline ^
                "apply (rule disjI2)+" ^ newline ^
                "apply (erule triv, simp add: ctxt_def,safe)" ^ newline ^
                "by (simp add: sMST_def, intro strip, rule vdm_conseq," ^ newline ^
                "rule MethodbodiesCorrect,intro strip,simp add: SPEC_def , erule DAss_PConst)+" ^ newline
      val mdecls':Classdecl.method_decl list 
                 = List.filter (fn x => not (GrailUtils.is_elem (#name x ) magic_funs)) mdecls (* nuke_magic_funs *)
      val s4 =
        List.foldl (fn x => MDECL2THM cname x) "" mdecls'
      val header = "ML {*  val n1 = Time.now (); *}"
      val footer = "ML_command {* writeln \"SUCCESS: Resource property proven\"; *}\nML_command {* let val n2 = Time.now () in TextIO.print (\"Elapsed time: \"^(Time.toString (n2-n1))^\"sec\") end ; *}ML_command {* OS.Process.exit(OS.Process.success):unit; *}\n"
      val s = s1 ^ s2 ^ s3 ^ newline ^ s4 ^ newline ^ "end" ^ newline
      val fname = GrailUtils.makeFullFilename outDir theoryname "thy"
      val os = TextIO.openOut fname
      val () = TextIO.output(os,s)
      val () = TextIO.closeOut os  
      val () = printToStdErr ("Wrote "^fname^"\n")
  in
     () (* YUCK *)
  end

fun makeCert4 cname mdecls outDir =
  let val theoryname = cname ^ "_Consumer2"
      val s1 = "theory " ^ theoryname ^ " = " ^ cname ^ "_Consumer1:" ^ newline
      val s2 = 
"lemma triv: \"" ^ slash ^ "<lbrakk>x:S; S=S1; x:S1 " ^ slash ^
"<longrightarrow> P" ^ slash ^ "<rbrakk>" ^ slash ^ 
"<Longrightarrow> P\" by simp" ^ newline ^
"(*The appication of this lemma in the consumer2-files can probably be" ^ newline ^
"  eliminated if the definition of SPEC and/or sMST is modified slightly.*)" ^ newline ^
"lemma FRAME_unique[rule_format]:" ^ newline ^
"\"(r, a, x, E', E) \\<in> FRAME \\<Longrightarrow>" ^ newline ^
"         \\<forall>  EE. (r, a, x, E', EE) \\<in> FRAME \\<longrightarrow> E=EE\"" ^ newline ^
"apply (erule FRAME.induct)" ^ newline ^
"apply clarsimp" ^ newline ^
"apply (erule FRAME.elims) apply clarsimp apply clarsimp apply clarsimp apply clarsimp" ^ newline ^
"apply (rule, rule) apply (rotate_tac -1)" ^ newline ^
"  apply (erule FRAME.elims) apply clarify apply clarify apply (erule_tac x=EEb in allE, simp) apply clarify apply clarify" ^ newline ^
"apply (rule, rule) apply (rotate_tac -1)" ^ newline ^
"  apply (erule FRAME.elims) apply clarify apply clarify apply clarify apply (erule_tac x=EEb in allE, simp) apply clarify " ^ newline ^
"apply (rule, rule) apply (rotate_tac -1)" ^ newline ^
"  apply (erule FRAME.elims) apply clarify apply clarify  apply clarify apply clarify apply (erule_tac x=EEb in allE, simp) " ^ newline ^
"done" ^ newline ^
"" ^ newline 

      val s3 =
"lemma Context_good: \"goodContext FST vMST sMST Context\"" ^ newline ^
"apply (simp only: goodContext_def)" ^ newline ^
"apply (intro strip)" ^ newline ^
"apply (rule disjI2)+" ^ newline ^
"apply (erule triv, simp add: ctxt_def,safe)" ^ newline ^
"apply (simp add: sMST_def, intro strip, rule vdm_conseq, rule MethodbodiesCorrect, " ^ newline ^
"       intro strip, simp add: SPEC_def, drule FRAME_unique, assumption, clarsimp, " ^ newline ^
"       erule DAss_PConst)+" ^ newline ^
"done" ^ newline

      val mdecls':Classdecl.method_decl list 
                 = List.filter (fn x => not (GrailUtils.is_elem (#name x ) magic_funs)) mdecls (* nuke_magic_funs *)
      val s4 =
        List.foldl (fn x => MDECL2THM cname x) "" mdecls'
      val header = "ML {*  val n1 = Time.now (); *}"
      val footer = "ML_command {* writeln \"SUCCESS: Resource property proven\"; *}\nML_command {* let val n2 = Time.now () in TextIO.print (\"Elapsed time: \"^(Time.toString (n2-n1))^\"sec\") end ; *}ML_command {* OS.Process.exit(OS.Process.success):unit; *}\n"
      (* s2 and s3 not needed with heap MRG (but needed with heap NULL_rules) *)
      val s = s1 ^ (*s2 ^*) s3 ^ newline ^ s4 ^ newline ^ "end" ^ newline
      val fname = GrailUtils.makeFullFilename outDir theoryname "thy"
      val os = TextIO.openOut fname
      val () = TextIO.output(os,s)
      val () = TextIO.closeOut os  
      val () = printToStdErr ("Wrote "^fname^"\n")
  in
     () (* YUCK *)
  end

fun mk_tactics0 cname outDir =
  let val theoryname = cname ^ "_TACTIC"
      val s1 = "theory " ^ theoryname ^ " = " ^ cname ^ "Certificate:" ^ 
               newline ^ newline
 val s2 = 
"method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms \"meth_defs\") (l_tac6 (thms \"dmp_defs\", thms \"meth_defs\", pdefs, thms \"ctxt_def\")) ctxt 1)) *}"
^ newline ^
" \"parametric Method for starting: use weakening, simplification with args, fast\" "
 ^ newline ^ newline ^ 
"method_setup ltac6 = {* Method.ctxt_args (fn ctxt => Method.METHOD (fn facts => l_tac6 (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}"
^ newline ^
"\"Main method\""
 ^ newline ^ newline ^ 
"method_setup method_NullGenL = {* Method.ctxt_args (fn ctxt => Method.METHOD (fn facts => null_tac_genl ctxt 1)) *}"
^ newline ^
" \"Method for Nullresult, nulltree and nulllist with left slack\""
^ newline ^ newline ^
"method_setup method_LetrinvsGenL = {* Method.ctxt_args (fn ctxt => Method.METHOD (fn facts => letrinvRename_tac_genl ctxt (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") stop 1)) *}"
^ newline ^
" \"Method for Letrinvoke with left slack\""
^ newline ^ newline ^
"method_setup method_invsGenL = {* Method.ctxt_args (fn ctxt => Method.METHOD (fn facts => inv_Rename_tac_genl ctxt (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") 1)) *}"
^ newline ^
" \"Method for invoke with left slack\""
^ newline ^ newline ^ 
"method_setup ltac6genl = {* Method.ctxt_args (fn ctxt => Method.METHOD (fn facts => l_tac6_genl (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}"
^ newline ^ 
" \"Main method with left slack\""
^ newline ^ newline ^ 
"method_setup WpGenL = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms \"meth_defs\") (l_tac6_genl (thms \"dmp_defs\", thms \"meth_defs\", pdefs, thms \"ctxt_def\")) ctxt 1)) *}"
^ newline ^
" \"parametric Method for starting: use weakening, simplification with args, fast, left slack\" " 


 (* HWL: modified tacs needed for heap sort and debugging tacs *)
 val s3 =
"(* ---------------------------------------- HW's tools *)" ^ newline ^
"" ^ newline ^
"ML_setup {*" ^ newline ^
"  fun weak_only_tac thms tac ctxt i = " ^ newline ^
"    EVERY" ^ newline ^
"      [localsimp_tac_thms ctxt thms i,  (* expand SPEC, methtable *)" ^ newline ^
"       rtac vcg_weak i]" ^ newline ^
"" ^ newline ^
"  fun null_tac_trace ctxt i =" ^ newline ^
"   EVERY [TRY (localsimp_tac ctxt i)," ^ newline ^
"         (tracing (\"__ NULL_TAC: trying null rules .. \");" ^ newline ^
"          ((rtac vcg_nullresult i) THEN (localsimp_tac ctxt i))" ^ newline ^
"          ORELSE ((rtac vcg_nulltree i) THEN (localsimp_tac ctxt i))" ^ newline ^
"          ORELSE ((rtac vcg_nulllist i) THEN (localsimp_tac ctxt i)))]" ^ newline ^
"" ^ newline ^
"  fun leaf_tac_trace ctxt thms i = " ^ newline ^
"  FIRST" ^ newline ^
"   [(tracing (\"__ LEAF_TAC: trying int, ivar, prim ...\");" ^ newline ^
"    resolve_tac [vcg_int, vcg_ivar, vcg_prim] i)," ^ newline ^
"    (tracing (\"__ LEAF_TAC: trying rvar ... \");" ^ newline ^
"    EVERY [rtac vcg_rvar i, localsimp_tac ctxt i])," ^ newline ^
"    (tracing (\"__ LEAF_TAC: trying prim ... \");" ^ newline ^
"    resolve_tac [vcg_prim] i)," ^ newline ^
"    (tracing (\"__ LEAF_TAC: trying rprim ... \");" ^ newline ^
"    EVERY [resolve_tac [vcg_rprim] i," ^ newline ^
"           repeat 2 (localsimp_tac ctxt i)])," ^ newline ^
"    (tracing (\"__ LEAF_TAC: trying makelist ... \");" ^ newline ^
"    EVERY [resolve_tac [vcg_makelist] i," ^ newline ^
"           FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                          rtac conjI i," ^ newline ^
"                          repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                  localsimp_tac ctxt i]," ^ newline ^
"           localsimp_tac ctxt i])," ^ newline ^
"    (tracing (\"__ LEAF_TAC: trying makelist_ml ... \");" ^ newline ^
"    EVERY [resolve_tac [vcg_makelist_ml] i," ^ newline ^
"           FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                          rtac conjI i," ^ newline ^
"                          repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                  localsimp_tac ctxt i]," ^ newline ^
"    repeat 3 (localsimp_tac ctxt i)])," ^ newline ^
"    (tracing (\"__ LEAF_TAC: trying makeresult ... \");" ^ newline ^
"    EVERY [resolve_tac [vcg_makeresult] i," ^ newline ^
"    repeat 2 (localsimp_tac ctxt i)])," ^ newline ^
"    (tracing (\"__ LEAF_TAC: trying maketree ... \");" ^ newline ^
"    EVERY [resolve_tac [vcg_maketree] i," ^ newline ^
"           FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                          rtac conjI i," ^ newline ^
"                          repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                  localsimp_tac ctxt i]," ^ newline ^
"           FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                          rtac conjI i," ^ newline ^
"                          repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                  localsimp_tac ctxt i]," ^ newline ^
"    repeat 2 (localsimp_tac ctxt i)])," ^ newline ^
"    stop_thms thms ctxt i," ^ newline ^
"    (tracing (\"__ LEAF_TAC: trying inv_Rename ... \");" ^ newline ^
"     inv_Rename_tac ctxt thms i)," ^ newline ^
"   (tracing (\"__ LEAF_TAC: THIS LEAF SUCKS \");" ^ newline ^
"    all_tac)]" ^ newline ^
"" ^ newline ^
"  fun if_tac_trace ctxt rec_tacTHEN rec_tacELSE i =" ^ newline ^
"   EVERY [rtac vcg_if i," ^ newline ^
"          (tracing (\"__ IF_TAC: doing else... \");" ^ newline ^
"   rec_tacELSE ctxt (i+1))," ^ newline ^
"          (tracing (\"__ IF_TAC: doing then \");" ^ newline ^
"          rec_tacTHEN ctxt i)]" ^ newline ^
"" ^ newline ^
"  fun let_tac_trace ctxt thms rec_tac i =" ^ newline ^
"   FIRST [EVERY [rtac vcg_letint i," ^ newline ^
"                 (tracing (\"__ LET_TAC: letint \");" ^ newline ^
"    rec_tac ctxt i)]," ^ newline ^
"          EVERY [rtac vcg_letprim i," ^ newline ^
"                 (tracing (\"__ LET_TAC: letprim \");" ^ newline ^
"    rec_tac ctxt i)]," ^ newline ^
"          EVERY [resolve_tac [vcg_letrprim] i," ^ newline ^
"                 (tracing (\"__ LET_TAC: letrprim \");" ^ newline ^
"          localsimp_tac ctxt i)," ^ newline ^
"          localsimp_tac ctxt i," ^ newline ^
"          rec_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letnull i," ^ newline ^
"                 (tracing (\"__ LET_TAC: letnull \");" ^ newline ^
"          rec_tac ctxt (i+1))," ^ newline ^
"                 null_tac_trace ctxt (i+1)," ^ newline ^
"   localsimp_tac ctxt i]," ^ newline ^
"" ^ newline ^
"          EVERY [letrmakelist_tac ctxt thms rec_tac i]," ^ newline ^
"" ^ newline ^
"   EVERY [rtac vcg_letrmakeresult i," ^ newline ^
"                 (tracing (\"__ LET_TAC: letrmakeresult \");" ^ newline ^
"          repeat 2 (localsimp_tac ctxt i))," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letrmaketree i," ^ newline ^
"                 (tracing (\"__ LET_TAC: letrmaketree \");" ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i])," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i]," ^ newline ^
"          repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]]" ^ newline ^
"" ^ newline ^
"" ^ newline ^
"   fun l_tac6_trace (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> " ^ newline ^
"    FIRST [if_tac_trace ctxt (l_tac6_trace thms) (l_tac6_trace thms) i," ^ newline ^
"           let_tac_trace ctxt thms (l_tac6_trace thms) i," ^ newline ^
"           call_tac ctxt dmp_defs (l_tac6_trace thms ctxt) i," ^ newline ^
"           dom_tac ctxt fun_defs (l_tac6_trace thms) (w_tac fun_defs (l_tac6_trace thms)) i," ^ newline ^
"           match_tac ctxt (l_tac6_trace thms) i," ^ newline ^
"           letrinvRename_tac ctxt thms (l_tac6_trace thms) i," ^ newline ^
"           letiinvRename_tac ctxt thms (l_tac6_trace thms) i," ^ newline ^
"           null_tac_trace ctxt i," ^ newline ^
"           leaf_tac_trace ctxt thms i]" ^ newline ^
"" ^ newline ^
"   fun l_tac6_norec_trace (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> " ^ newline ^
"    FIRST [if_tac_trace ctxt (stop_thms thms) (stop_thms thms) i," ^ newline ^
"           let_tac_trace ctxt thms (stop_thms thms) i," ^ newline ^
"           call_tac ctxt dmp_defs (stop_thms thms ctxt) i," ^ newline ^
"           dom_tac ctxt fun_defs (stop_thms thms) (w_tac fun_defs (stop_thms thms)) i," ^ newline ^
"           match_tac ctxt (stop_thms thms) i," ^ newline ^
"           letrinvRename_tac ctxt thms (stop_thms thms) i," ^ newline ^
"           letiinvRename_tac ctxt thms (stop_thms thms) i," ^ newline ^
"           null_tac_trace ctxt i," ^ newline ^
"           leaf_tac_trace ctxt thms i]" ^ newline ^
"" ^ newline ^
"*}" ^ newline ^
"" ^ newline ^
"(*method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms \"meth_defs\") (l_tac6 (thms \"dmp_defs\", thms \"meth_defs\", pdefs, thms \"ctxt_def\")) ctxt 1)) *}" ^ newline ^
" \"parametric Method for starting: use weakening, simplification with args, fast\" " ^ newline ^
"*)" ^ newline ^
"method_setup Wp_trace = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms \"meth_defs\") (l_tac6_trace (thms \"dmp_defs\", thms \"meth_defs\", pdefs, thms \"ctxt_def\")) ctxt 1)) *}" ^ newline ^
" \"parametric Method for starting: use weakening, simplification with args, fast\" " ^ newline ^
"" ^ newline ^
"method_setup Wp_norec_trace = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms \"meth_defs\") (l_tac6_norec_trace (thms \"dmp_defs\", thms \"meth_defs\", pdefs, thms \"ctxt_def\")) ctxt 1)) *}" ^ newline ^
" \"parametric Method for starting: use weakening, simplification with args, fast\" " ^ newline ^
"" ^ newline ^
"method_setup Bonzo1 = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms \"meth_defs\") stop  ctxt 1)) *}" ^ newline ^
" \"parametric Method for starting: use weakening, simplification with args, fast\" " ^ newline ^
"" ^ newline ^
"method_setup Bonzo2 = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => weak_only_tac (thms \"meth_defs\") stop  ctxt 1)) *}" ^ newline ^
" \"parametric Method for starting: use weakening, simplification with args, fast\" " ^ newline ^
"" ^ newline ^
"(* ---------------------------------------- Lennart's tools *)" ^ newline ^
"" ^ newline ^
"method_setup method_leaf = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => leaf_tac ctxt (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") 1))  *}" ^ newline ^
" \"Method for solving leaf cases in the derivation.\"    " ^ newline ^
" " ^ newline ^
"method_setup method_If = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => if_tac ctxt stop stop 1)) *}" ^ newline ^
"  \"Method for If, reduces to two subgoals\"" ^ newline ^
"" ^ newline ^
"method_setup method_Let = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => let_tac ctxt (thms,thms,thms) stop 1)) *}" ^ newline ^
"  \"Method for LetPrim/LetRPrim/LetNull, reduces to one subgoal\"" ^ newline ^
"" ^ newline ^
"method_setup method_Letinv = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => letinv_tac ctxt (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") " ^ newline ^
"                                             (l_tac (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"Method for Letrinvoke\"" ^ newline ^
"" ^ newline ^
"method_setup method_Letinvs = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => letinv_tac ctxt (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") " ^ newline ^
"                                             stop 1)) *}" ^ newline ^
"  \"Method for Letrinvoke\"" ^ newline ^
"" ^ newline ^
"(* apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def) *)" ^ newline ^
"method_setup method_Call = {* Method.thms_ctxt_args (fn thms => " ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (stop ctxt) 1)) *}" ^ newline ^
"  \"Method for Call, leaves dominates subgoal\"" ^ newline ^
"(*" ^ newline ^
"method_setup method_CallDom = {* Method.thms_ctxt_args (fn thms => " ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (fn ctxt => fn thms => dom_tac ctxt thms (K stop)) 1)) *}" ^ newline ^
"  \"Method for Call, leaves dominates subgoal\"" ^ newline ^
"*)" ^ newline ^
"" ^ newline ^
"(* apply (simp?, (rule DA_NullResult, simp) | rule DA_NullTree | rule DA_NullList) *)" ^ newline ^
"method_setup method_Null = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => null_tac ctxt 1)) *}" ^ newline ^
"  \"Method for Nullresult, nulltree and nulllist\"" ^ newline ^
"" ^ newline ^
"(* FIXME: to combine method_Call with method_Dom or mergepoint stuff, we need to" ^ newline ^
"   ideally need a method which accepts more than one parameter *)" ^ newline ^
"" ^ newline ^
"(* apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs) *)" ^ newline ^
"method_setup method_Dom = {* Method.thms_ctxt_args (fn thms => " ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => dom_tac ctxt thms stop stop 1)) *}" ^ newline ^
"  \"Method for Dom\" " ^ newline ^
"" ^ newline ^
"method_setup ltac = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"" ^ newline ^
"method_setup ltac2 = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac2 (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"" ^ newline ^
"method_setup ltac3 = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac3 (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"" ^ newline ^
"method_setup ltac4 = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac4 (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"" ^ newline ^
"method_setup ltac5 = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac5 (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"" ^ newline ^
"(* method_setup ltac6 = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac6 (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"*)" ^ newline ^
"method_setup rmd = {* Method.ctxt_args (" ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt (l_tac (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"test for resultmatchd\"" ^ newline ^
"" ^ newline ^
"method_setup rmds = {* Method.ctxt_args (" ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt stop 1)) *}" ^ newline ^
"  \"test for resultmatchd\"" ^ newline ^
"" ^ newline ^
"method_setup lmd = {* Method.ctxt_args (" ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => cons_matchd_tac ctxt (l_tac (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"test for listmatchd\"" ^ newline ^
"" ^ newline ^
"method_setup lmds = {* Method.ctxt_args (" ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => cons_matchd_tac ctxt stop 1)) *}" ^ newline ^
"  \"test for listmatchd\"" ^ newline ^
"" ^ newline ^
"method_setup lm = {* Method.ctxt_args (" ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => cons_match_tac ctxt (l_tac (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"test for listmatch\"" ^ newline ^
"" ^ newline ^
"method_setup lms = {* Method.ctxt_args (" ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => cons_match_tac ctxt stop 1)) *}" ^ newline ^
"  \"test for listmatch\"" ^ newline ^
"" ^ newline ^
"method_setup tmd = {* Method.ctxt_args (" ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => node_matchd_tac ctxt (l_tac (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"test for treematchd\"" ^ newline ^
"" ^ newline ^
"method_setup tmds = {* Method.ctxt_args (" ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => node_matchd_tac ctxt stop 1)) *}" ^ newline ^
"  \"test for treematchd\"" ^ newline ^
"method_setup tm = {* Method.ctxt_args (" ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => node_match_tac ctxt (l_tac (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"test for treematch\"" ^ newline ^
"" ^ newline ^
"method_setup tms = {* Method.ctxt_args (" ^ newline ^
"  fn ctxt => Method.METHOD (fn facts => node_match_tac ctxt stop 1)) *}" ^ newline ^
"  \"test for treematch\"" ^ newline ^
"" ^ newline ^
"method_setup method_fast = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => fst_tac 1)) *}" ^ newline ^
"  \"Method for fast\"" ^ newline ^
"" ^ newline ^
"method_setup method_simp = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => localsimp_tac ctxt 1)) *}" ^ newline ^
"  \"Method for simp\"" ^ newline ^
"" ^ newline ^
"method_setup method_Weaks = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => weak_tac ctxt (thms \"meth_defs\") stop 1)) *}" ^ newline ^
"  \"Method for starting: use weakening, simplification with args\" " ^ newline ^
"" ^ newline ^
"method_setup method_Weak = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => weak_tac ctxt (thms \"meth_defs\") (l_tac6 (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"Method for starting: use weakening, simplification with args\" " ^ newline ^
"" ^ newline ^
"method_setup letrmakelist = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => letrmakelist_tac ctxt (thms \"meth_defs\") (l_tac6 (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"Method for starting: use weakening, simplification with args\" " ^ newline ^
"" ^ newline ^
"method_setup letrmakelists = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => letrmakelist_tac ctxt (thms \"meth_defs\") stop 1)) *}" ^ newline ^
"  \"Method for starting: use weakening, simplification with args\" " ^ newline ^
"" ^ newline ^
"method_setup letcons = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => let_cons ctxt (l_tac6 (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"Method for starting: use weakening, simplification with args\" " ^ newline ^
"" ^ newline ^
"method_setup letconsML = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => let_cons_ML ctxt (l_tac6 (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"Method for starting: use weakening, simplification with args\" " ^ newline ^
"" ^ newline ^
"method_setup method_REN = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => REN_tac 1)) *}" ^ newline ^
"  \"Method for starting: use weakening, simplification with args, fast\"" ^ newline ^
"" ^ newline ^
"(* ------------------------------------------ new stuff  *)" ^ newline ^
"" ^ newline ^
"ML {*" ^ newline ^
"  fun null_res_tac ctxt i =" ^ newline ^
"   EVERY [TRY (localsimp_tac ctxt i)," ^ newline ^
"          ((rtac vcg_nullresult i) THEN (localsimp_tac ctxt i)) " ^ newline ^
"          ORELSE ((rtac vcg_nulltree i) THEN (localsimp_tac ctxt i))" ^ newline ^
"          ORELSE ((rtac vcg_nulllist i) THEN (localsimp_tac ctxt i))]" ^ newline ^
"" ^ newline ^
"  fun null_tree_tac ctxt i =" ^ newline ^
"   EVERY [TRY (localsimp_tac ctxt i)," ^ newline ^
"          ((rtac vcg_nulltree i) THEN (localsimp_tac ctxt i))" ^ newline ^
"          ORELSE ((rtac vcg_nullresult i) THEN (localsimp_tac ctxt i))" ^ newline ^
"          ORELSE ((rtac vcg_nulllist i) THEN (localsimp_tac ctxt i))]" ^ newline ^
"" ^ newline ^
"  (* --------------------------------------------------------------------------- *)" ^ newline ^
"  (* Version 7 *)" ^ newline ^
"" ^ newline ^
"   fun letrinvRename7_tac ctxt (dmp_defs,meth_defs,fun_defs,ctxt_defs) rec_tac i =" ^ newline ^
"          EVERY [rtac vcg_letrinvokeconstRename i," ^ newline ^
"                 localsimp_tac_thms ctxt ctxt_defs (i+1)," ^ newline ^
"                 localsimp_tac_thms ctxt meth_defs (i+1)," ^ newline ^
"                 localsimp_tac_thms ctxt meth_defs (i+1)," ^ newline ^
"                 localsimp_tac ctxt (i+1)," ^ newline ^
"                 localsimp_tac ctxt (i+1)," ^ newline ^
"                 localsimp_tac ctxt (i+1)," ^ newline ^
"                 localsimp_tac_thms ctxt meth_defs (i+1)," ^ newline ^
"                 localsimp_tac ctxt (i+1)," ^ newline ^
"                 localsimp_tac ctxt (i+1)," ^ newline ^
"                 localsimp_tac ctxt (i+1)," ^ newline ^
"                 localsimp_tac ctxt (i+1)," ^ newline ^
"                 localsimp_tac_thms ctxt meth_defs (i+1), REN_tac (i+1)," ^ newline ^
"                 localsimp_tac_thms ctxt ([thm \"newframe_env_def\", thm \"evalARGS_def\"] @ meth_defs) (i+1)," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt (i+1)," ^ newline ^
"                                rtac conjI (i+1)," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt (i+1))]," ^ newline ^
"                         localsimp_tac ctxt (i+1)]," ^ newline ^
"                 rec_tac ctxt (i+1)," ^ newline ^
"                 localsimp_tac ctxt i]" ^ newline ^
"" ^ newline ^
"  fun let7_tac ctxt thms rec_tac i =" ^ newline ^
"   FIRST [EVERY [rtac vcg_letint i," ^ newline ^
"   rec_tac ctxt i]," ^ newline ^
"          EVERY [rtac vcg_letprim i," ^ newline ^
"   rec_tac ctxt i]," ^ newline ^
"          EVERY [resolve_tac [vcg_letrprim] i," ^ newline ^
"          localsimp_tac ctxt i," ^ newline ^
"          localsimp_tac ctxt i," ^ newline ^
"          rec_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letnull i," ^ newline ^
"          rec_tac ctxt (i+1)," ^ newline ^
"                 null_tac ctxt (i+1),       (* <-- it is a list! *)" ^ newline ^
"   localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac vcg_letrmakelist i," ^ newline ^
"                 FIRST [ EVERY [ TRY (localsimp_tac ctxt i)," ^ newline ^
"                          rec_tac ctxt i," ^ newline ^
"                                 repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                         EVERY [ localsimp_tac ctxt i, (*????*)" ^ newline ^
"                                 rtac conjI i," ^ newline ^
"                                 repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                          rec_tac ctxt (i+1)," ^ newline ^
"                                 repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                         EVERY [ localsimp_tac ctxt i," ^ newline ^
"                          rec_tac ctxt (i+1)," ^ newline ^
"                                 repeat 3 (localsimp_tac ctxt i)]]] ," ^ newline ^
"   EVERY [rtac vcg_letrmakeresult i," ^ newline ^
"          repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letrmaketree i," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i]," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i]," ^ newline ^
"          repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]]" ^ newline ^
"" ^ newline ^
"  fun let7res_tac ctxt thms rec_tac i =" ^ newline ^
"   FIRST [EVERY [rtac vcg_letint i," ^ newline ^
"   rec_tac ctxt i]," ^ newline ^
"          EVERY [rtac vcg_letprim i," ^ newline ^
"   rec_tac ctxt i]," ^ newline ^
"          EVERY [resolve_tac [vcg_letrprim] i," ^ newline ^
"          localsimp_tac ctxt i," ^ newline ^
"          localsimp_tac ctxt i," ^ newline ^
"          rec_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letnull i," ^ newline ^
"          rec_tac ctxt (i+1)," ^ newline ^
"                 null_res_tac ctxt (i+1),   (* <-- it is a res! *)" ^ newline ^
"   localsimp_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letrmakeresult i," ^ newline ^
"          repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac vcg_letrmakelist i," ^ newline ^
"                 FIRST [ EVERY [ TRY (localsimp_tac ctxt i)," ^ newline ^
"                          rec_tac ctxt i," ^ newline ^
"                                 repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                         EVERY [ localsimp_tac ctxt i, (*????*)" ^ newline ^
"                                 rtac conjI i," ^ newline ^
"                                 repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                          rec_tac ctxt (i+1)," ^ newline ^
"                                 repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                         EVERY [ localsimp_tac ctxt i," ^ newline ^
"                          rec_tac ctxt (i+1)," ^ newline ^
"                                 repeat 3 (localsimp_tac ctxt i)]]] ," ^ newline ^
"   EVERY [rtac vcg_letrmaketree i," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i]," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i]," ^ newline ^
"          repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]]" ^ newline ^
"" ^ newline ^
"  fun let7tree_tac ctxt thms rec_tac i =" ^ newline ^
"   FIRST [EVERY [rtac vcg_letint i," ^ newline ^
"   rec_tac ctxt i]," ^ newline ^
"          EVERY [rtac vcg_letprim i," ^ newline ^
"   rec_tac ctxt i]," ^ newline ^
"          EVERY [resolve_tac [vcg_letrprim] i," ^ newline ^
"          localsimp_tac ctxt i," ^ newline ^
"          localsimp_tac ctxt i," ^ newline ^
"          rec_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letnull i," ^ newline ^
"          rec_tac ctxt (i+1)," ^ newline ^
"                 null_tree_tac ctxt (i+1),  (* <-- it is a tree! *)" ^ newline ^
"   localsimp_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letrmaketree i," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i]," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i]," ^ newline ^
"          repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac vcg_letrmakelist i," ^ newline ^
"                 FIRST [ EVERY [ TRY (localsimp_tac ctxt i)," ^ newline ^
"                          rec_tac ctxt i," ^ newline ^
"                                 repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                         EVERY [ localsimp_tac ctxt i, (*????*)" ^ newline ^
"                                 rtac conjI i," ^ newline ^
"                                 repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                          rec_tac ctxt (i+1)," ^ newline ^
"                                 repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                         EVERY [ localsimp_tac ctxt i," ^ newline ^
"                          rec_tac ctxt (i+1)," ^ newline ^
"                                 repeat 3 (localsimp_tac ctxt i)]]] ," ^ newline ^
"   EVERY [rtac vcg_letrmakeresult i," ^ newline ^
"          repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]]" ^ newline ^
"" ^ newline ^
"  fun cons_matchd7_tac ctxt rec_tac i state = state |> " ^ newline ^
"    EVERY [rtac vcg_listmatchd i," ^ newline ^
"           localsimp_tac ctxt (i+1)," ^ newline ^
"             rtac conjI (i+1)," ^ newline ^
"             repeat 2 (localsimp_tac ctxt (i+1))," ^ newline ^
"           localsimp_tac ctxt (i+1)," ^ newline ^
"    (CHANGED (localsimp_tac ctxt (i+1)))," ^ newline ^
"            rec_tac ctxt (i+1)," ^ newline ^
"            repeat 1 (localsimp_tac ctxt i)]" ^ newline ^
"" ^ newline ^
"" ^ newline ^
"   fun l_tac7 (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> " ^ newline ^
"    FIRST [if_tac ctxt (l_tac7 thms) (l_tac7 thms) i," ^ newline ^
"           let7_tac ctxt thms (l_tac7 thms) i," ^ newline ^
"           call_tac ctxt dmp_defs (l_tac7 thms ctxt) i," ^ newline ^
"           dom_tac ctxt fun_defs (l_tac7 thms) (w_tac fun_defs (l_tac7 thms)) i," ^ newline ^
"           cons_matchd7_tac ctxt (l_tac7 thms) i," ^ newline ^
"           letrinvRename7_tac ctxt thms (l_tac7 thms) i," ^ newline ^
"           letiinvRename_tac ctxt thms (l_tac7 thms) i," ^ newline ^
"           null_tac ctxt i," ^ newline ^
"           leaf_tac ctxt thms i]" ^ newline ^
"" ^ newline ^
"   fun l_tac7res (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> " ^ newline ^
"    FIRST [if_tac ctxt (l_tac7 thms) (l_tac7 thms) i," ^ newline ^
"           let7res_tac ctxt thms (l_tac7 thms) i,         (* <-- it is a res! *)" ^ newline ^
"           call_tac ctxt dmp_defs (l_tac7 thms ctxt) i," ^ newline ^
"           dom_tac ctxt fun_defs (l_tac7 thms) (w_tac fun_defs (l_tac7 thms)) i," ^ newline ^
"           cons_matchd7_tac ctxt (l_tac7 thms) i," ^ newline ^
"           letrinvRename7_tac ctxt thms (l_tac7 thms) i," ^ newline ^
"           letiinvRename_tac ctxt thms (l_tac7 thms) i," ^ newline ^
"           null_res_tac ctxt i,                            (* <-- it is a res! *)" ^ newline ^
"           leaf_tac ctxt thms i]" ^ newline ^
"" ^ newline ^
"   fun l_tac7tree (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> " ^ newline ^
"    FIRST [if_tac ctxt (l_tac7 thms) (l_tac7 thms) i," ^ newline ^
"           let7tree_tac ctxt thms (l_tac7 thms) i,           (* <-- it is a tree! *)" ^ newline ^
"           call_tac ctxt dmp_defs (l_tac7 thms ctxt) i," ^ newline ^
"           dom_tac ctxt fun_defs (l_tac7 thms) (w_tac fun_defs (l_tac7 thms)) i," ^ newline ^
"           cons_matchd7_tac ctxt (l_tac7 thms) i," ^ newline ^
"           letrinvRename7_tac ctxt thms (l_tac7 thms) i," ^ newline ^
"           letiinvRename_tac ctxt thms (l_tac7 thms) i," ^ newline ^
"           null_tree_tac ctxt i,                               (* <-- it is a tree! *)" ^ newline ^
"           leaf_tac ctxt thms i]" ^ newline ^
"" ^ newline ^
"   fun l_tac7s (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> " ^ newline ^
"    FIRST [if_tac ctxt stop stop i," ^ newline ^
"           let7_tac ctxt thms stop i," ^ newline ^
"           call_tac ctxt dmp_defs (l_tac7 thms ctxt) i," ^ newline ^
"           dom_tac ctxt fun_defs stop (w_tac fun_defs stop) i," ^ newline ^
"           cons_matchd7_tac ctxt stop i," ^ newline ^
"           letrinvRename7_tac ctxt thms stop i," ^ newline ^
"           letiinvRename_tac ctxt thms stop i," ^ newline ^
"           null_tac ctxt i," ^ newline ^
"           leaf_tac ctxt thms i]" ^ newline ^
"" ^ newline ^
"   fun l_tac7gen v (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = " ^ newline ^
"    if (v=1) then l_tac7 thms ctxt i state" ^ newline ^
"    else if (v=2) then l_tac7res thms ctxt i state" ^ newline ^
"    else if (v=3) then l_tac7tree thms ctxt i state" ^ newline ^
"    else l_tac7 thms ctxt i state" ^ newline ^
"" ^ newline ^
"  (* --------------------------------------------------------------------------- *)" ^ newline ^
"  (* Version 6 tinkering *)" ^ newline ^
"" ^ newline ^
"  (* forces all nulls to be Trees!!! works for: Letint, Letprim, LetRPrim, LetNull *)" ^ newline ^
"  fun let_tree_tac ctxt thms rec_tac i =" ^ newline ^
"   FIRST [EVERY [rtac vcg_letint i," ^ newline ^
"   rec_tac ctxt i]," ^ newline ^
"          EVERY [rtac vcg_letprim i," ^ newline ^
"   rec_tac ctxt i]," ^ newline ^
"          EVERY [resolve_tac [vcg_letrprim] i," ^ newline ^
"          localsimp_tac ctxt i," ^ newline ^
"          localsimp_tac ctxt i," ^ newline ^
"          rec_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letnull i," ^ newline ^
"          rec_tac ctxt (i+1)," ^ newline ^
"                 null_tree_tac ctxt (i+1)," ^ newline ^
"   localsimp_tac ctxt i]," ^ newline ^
"          letrmakelist_tac ctxt thms rec_tac i," ^ newline ^
"   EVERY [rtac vcg_letrmakeresult i," ^ newline ^
"          repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letrmaketree i," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i]," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i]," ^ newline ^
"          repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]]" ^ newline ^
"" ^ newline ^
"" ^ newline ^
"   fun l_tac6tree (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> " ^ newline ^
"    FIRST [if_tac ctxt (l_tac6tree thms) (l_tac6tree thms) i," ^ newline ^
"           let_tree_tac ctxt thms (l_tac6tree thms) i," ^ newline ^
"           call_tac ctxt dmp_defs (l_tac6tree thms ctxt) i," ^ newline ^
"           dom_tac ctxt fun_defs (l_tac6tree thms) (w_tac fun_defs (l_tac6tree thms)) i," ^ newline ^
"           match_tac ctxt (l_tac6tree thms) i," ^ newline ^
"           letrinvRename_tac ctxt thms (l_tac6tree thms) i," ^ newline ^
"           letiinvRename_tac ctxt thms (l_tac6tree thms) i," ^ newline ^
"           null_tac ctxt i," ^ newline ^
"           leaf_tac ctxt thms i]" ^ newline ^
"" ^ newline ^
"  (* forces all nulls to be Trees!!! works for: Letint, Letprim, LetRPrim, LetNull *)" ^ newline ^
"  fun let_res_tac ctxt thms rec_tac i =" ^ newline ^
"   FIRST [EVERY [rtac vcg_letint i," ^ newline ^
"   rec_tac ctxt i]," ^ newline ^
"          EVERY [rtac vcg_letprim i," ^ newline ^
"   rec_tac ctxt i]," ^ newline ^
"          EVERY [resolve_tac [vcg_letrprim] i," ^ newline ^
"          localsimp_tac ctxt i," ^ newline ^
"          localsimp_tac ctxt i," ^ newline ^
"          rec_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letnull i," ^ newline ^
"          rec_tac ctxt (i+1)," ^ newline ^
"                 null_res_tac ctxt (i+1)," ^ newline ^
"   localsimp_tac ctxt i]," ^ newline ^
"          letrmakelist_tac ctxt thms rec_tac i," ^ newline ^
"   EVERY [rtac vcg_letrmakeresult i," ^ newline ^
"          repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]," ^ newline ^
"   EVERY [rtac vcg_letrmaketree i," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i]," ^ newline ^
"                 FIRST [ EVERY [localsimp_tac ctxt i," ^ newline ^
"                                rtac conjI i," ^ newline ^
"                                repeat 2 (localsimp_tac ctxt i)]," ^ newline ^
"                        localsimp_tac ctxt i]," ^ newline ^
"          repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 rec_tac ctxt i," ^ newline ^
"                 localsimp_tac ctxt i]]" ^ newline ^
"" ^ newline ^
"" ^ newline ^
"   fun l_tac6res (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> " ^ newline ^
"    FIRST [if_tac ctxt (l_tac6res thms) (l_tac6res thms) i," ^ newline ^
"           let_tree_tac ctxt thms (l_tac6res thms) i," ^ newline ^
"           call_tac ctxt dmp_defs (l_tac6res thms ctxt) i," ^ newline ^
"           dom_tac ctxt fun_defs (l_tac6res thms) (w_tac fun_defs (l_tac6res thms)) i," ^ newline ^
"           match_tac ctxt (l_tac6res thms) i," ^ newline ^
"           letrinvRename_tac ctxt thms (l_tac6res thms) i," ^ newline ^
"           letiinvRename_tac ctxt thms (l_tac6res thms) i," ^ newline ^
"           null_tac ctxt i," ^ newline ^
"           leaf_tac ctxt thms i]" ^ newline ^
"" ^ newline ^
"   fun l_tac6gen v (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = " ^ newline ^
"    if (v=1) then l_tac6 thms ctxt i state" ^ newline ^
"    else if (v=2) then l_tac6res thms ctxt i state" ^ newline ^
"    else if (v=3) then l_tac6tree thms ctxt i state" ^ newline ^
"    else l_tac6 thms ctxt i state" ^ newline ^
"" ^ newline ^
"*}" ^ newline ^
"" ^ newline ^
"method_setup ltac6tree = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac6tree (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"" ^ newline ^
"method_setup ltac6res = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac6res (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"" ^ newline ^
"ML {* " ^ newline ^
" val global_v:int = 1" ^ newline ^
"*}" ^ newline ^
"" ^ newline ^
"method_setup ltac6gen = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac6gen global_v (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"" ^ newline ^
"method_setup ltac7 = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac7 (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"" ^ newline ^
"method_setup ltac7gen = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac7gen global_v (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"" ^ newline ^
"method_setup ltac7s = {* Method.ctxt_args (fn ctxt =>" ^ newline ^
"  Method.METHOD (fn facts => l_tac7s (thms \"dmp_defs\", thms \"meth_defs\", thms \"fun_defs\", thms \"ctxt_def\") ctxt 1)) *}" ^ newline ^
"  \"Main method\"" ^ newline ^
"" ^ newline ^
"method_setup method_Let7 = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => let7_tac ctxt (thms,thms,thms) stop 1)) *}" ^ newline ^
"  \"Method for LetPrim/LetRPrim/LetNull, reduces to one subgoal\"" ^ newline ^
"" ^ newline ^
"" ^ newline ^
"(* --------------------------------------------------------------------------- *)" ^ newline 

  val s = s1 ^ newline ^ s2 ^ newline ^ s3 ^ newline ^ "end"

  val fname = GrailUtils.makeFullFilename outDir theoryname "thy"
  val os = TextIO.openOut fname
  val () = TextIO.output(os,s)
  val () = TextIO.closeOut os  
  val () = printToStdErr ("Wrote "^fname^"\n")
 in
   () (* YUCK *)
 end

(* TODO: produce tactic for version MRG *)

fun mk_tactics4 cname outDir =
  let val theoryname = cname ^ "_TACTIC"
      val s1 = "theory " ^ theoryname ^ " = " ^ cname ^ "Certificate:" ^ 
               newline ^ newline
 val s2 = 
"ML_setup {*" ^ newline ^
"  exception MRG of string" ^ newline ^
"" ^ newline ^
"  val basicsimpset_tac = simp_tac HOL_basic_ss" ^ newline ^
"  fun sym_basicsimp i = FIRST [CHANGED (simp_tac HOL_basic_ss i), rtac add_commute i]" ^ newline ^
"" ^ newline ^
"  fun localsimp_tac ctxt i = simp_tac (Simplifier.get_local_simpset ctxt) i" ^ newline ^
"  fun localsimp_tac_thms ctxt thms = " ^ newline ^
"     simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)" ^ newline ^
"  fun simpset_tac_thms t i = simp_tac (HOL_basic_ss addsimps ([fst_conv,snd_conv]@t)) i" ^ newline ^
"" ^ newline ^
" fun testFalse i =" ^ newline ^
"   SUBGOAL (fn (prop,_) =>" ^ newline ^
"      let val concl = Logic.strip_assums_concl prop in" ^ newline ^
"          case concl of " ^ newline ^
"          (Const (\"Trueprop\", _) $ Const (\"False\", _)) => (raise MRG \"this is soooooooooooooooooooooo FALSE\")" ^ newline ^
"        | _ => all_tac  end) i" ^ newline ^
"" ^ newline ^
"  fun repeat 0 tac = all_tac" ^ newline ^
"    | repeat n tac = tac THEN (repeat (n-1) tac)" ^ newline ^
"" ^ newline ^
"  val mrg_int = thm \"MRG_Int\"" ^ newline ^
"  val mrg_ivar = thm \"MRG_IVar\"" ^ newline ^
"  val mrg_rvar = thm \"MRG_RVar\"" ^ newline ^
"  val mrg_prim = thm \"MRG_Prim\"" ^ newline ^
"  val mrg_rprim = thm \"MRG_RPrim\"" ^ newline ^
"  val mrg_nulllist = thm \"MRG_NullList\"" ^ newline ^
"  val mrg_nullres = thm \"MRG_NullRes\"" ^ newline ^
"  val mrg_nulltree = thm \"MRG_NullTree\"" ^ newline ^
"  val mrg_makelist = thm \"MRG_MakeList\"" ^ newline ^
"  val mrg_maketree = thm \"MRG_MakeTree\"" ^ newline ^
"  val mrg_makeresult = thm \"MRG_MakeResultSome\"" ^ newline ^
"  val mrg_invstat = thm \"MRG_InvStat\"" ^ newline ^
"  val mrg_letv = thm \"MRG_Letv\"" ^ newline ^
"  val mrg_leti = thm \"MRG_Leti\"" ^ newline ^
"  val mrg_letr = thm \"MRG_Letr\"" ^ newline ^
"  val mrg_letrnull = thm \"MRG_LetrNull\"" ^ newline ^
"  val mrg_listmatch = thm \"MRG_ListMatch\"" ^ newline ^
"  val mrg_listmatchd = thm \"MRG_ListMatchD\"" ^ newline ^
"  val mrg_treematch = thm \"MRG_TreeMatch\"" ^ newline ^
"  val mrg_treematchd = thm \"MRG_TreeMatchD\"" ^ newline ^
"  val mrg_resultmatch = thm \"MRG_ResultMatch\"" ^ newline ^
"  val mrg_resultmatchd = thm \"MRG_ResultMatchD\"" ^ newline ^
"  val mrg_if = thm \"MRG_If\"" ^ newline ^
"  val mrg_weak = thm \"MRG_Weak\"" ^ newline ^
"" ^ newline ^
"  val mrg_call = thm \"MRG_Call\"" ^ newline ^
"  val mrg_domcallnil = thm \"DOM_CallNIL\"" ^ newline ^
"  val mrg_domcallcons = thm \"DOM_CallCONS\"" ^ newline ^
"" ^ newline ^
"  val rena_nil = thm \"RENA_NIL\"" ^ newline ^
"  val rena_in = thm \"RENA_IN\"" ^ newline ^
"  val rena_rn = thm \"RENA_RN\"" ^ newline ^
"" ^ newline ^
"  val mrg_sound = thm \"MRG_sound\"" ^ newline ^
"" ^ newline ^
"  fun getr_tac ctxt i = localsimp_tac ctxt i" ^ newline ^
"  fun getr_clar_tac ctxt i = EVERY [localsimp_tac ctxt i, clarify_tac HOL_cs i]" ^ newline ^
"  fun getr_fast ctxt i = SELECT_GOAL (FIRST [SOLVE (getr_tac ctxt i), EVERY [getr_tac ctxt i, fast_tac (claset()) i]]) i" ^ newline ^
"" ^ newline ^
"  fun bsf i = SELECT_GOAL (FIRST [SOLVE (basicsimpset_tac i), EVERY [basicsimpset_tac i, fast_tac (claset()) i]]) i" ^ newline ^
"  fun lsf ctxt i = SELECT_GOAL (FIRST [SOLVE (localsimp_tac ctxt i), EVERY [localsimp_tac ctxt i, fast_tac (claset()) i]]) i" ^ newline ^
"" ^ newline ^
"  fun type_tac i = basicsimpset_tac i" ^ newline ^
"  fun context_tac ctxt thms i = localsimp_tac_thms ctxt thms i" ^ newline ^
"" ^ newline ^
"  fun stop ctxt thms i = all_tac" ^ newline ^
"" ^ newline ^
"  fun ast i = asm_simp_tac (simpset()) i " ^ newline ^
"" ^ newline ^
"  fun ast_thms thms i = " ^ newline ^
"     asm_simp_tac ((simpset()) addsimps thms) i" ^ newline ^
"" ^ newline ^
"  fun ast_fast i =" ^ newline ^
"         SELECT_GOAL (FIRST[SOLVE (ast i)," ^ newline ^
"                            EVERY [ast i,fast_tac (claset()) i]]) i" ^ newline ^
"  fun ast_thms_fast thms i = " ^ newline ^
"         SELECT_GOAL (FIRST[SOLVE (ast_thms thms i), " ^ newline ^
"                            EVERY [ast_thms thms i,fast_tac (claset()) i]]) i" ^ newline ^
"" ^ newline 

 val s3 = "  fun RENA_tac i state = state |> " ^ newline ^
"    FIRST [EVERY [rtac rena_in i, RENA_tac i]," ^ newline ^
"           EVERY [rtac rena_rn i, RENA_tac i]," ^ newline ^
"           rtac rena_nil i]" ^ newline ^
"" ^ newline ^
"  fun null_tac ctxt i =" ^ newline ^
"    FIRST [EVERY [rtac mrg_nulllist i, localsimp_tac ctxt i]," ^ newline ^
"           EVERY [rtac mrg_nullres i, localsimp_tac ctxt i]," ^ newline ^
"           EVERY [rtac mrg_nulltree i, localsimp_tac ctxt i]]" ^ newline ^
"" ^ newline ^
"  fun null_tac_simp ctxt i = " ^ newline ^
"     EVERY [SELECT_GOAL (FIRST [null_tac ctxt i, EVERY[localsimp_tac ctxt i, null_tac ctxt i]]) i]" ^ newline ^
"" ^ newline ^
"  fun leaf_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i =" ^ newline ^
"   FIRST [EVERY [rtac mrg_int i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_ivar i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_rvar i, getr_fast ctxt i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_prim i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_rprim i, repeat 2 (getr_fast ctxt i), localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_maketree i, getr_fast ctxt i, getr_fast ctxt i," ^ newline ^
"                 localsimp_tac ctxt i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_makelist i, getr_fast ctxt i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_makeresult i, getr_fast ctxt i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_invstat i," ^ newline ^
"                 localsimp_tac_thms ctxt c_defs i, " ^ newline ^
"                 localsimp_tac_thms ctxt m_defs i, " ^ newline ^
"                 ast_thms m_defs i," ^ newline ^
"                 ast i," ^ newline ^
"                 ast_thms_fast m_defs i, ast_fast i, " ^ newline ^
"                 repeat 2 (localsimp_tac_thms ctxt [thm \"DOM_def\"] i)," ^ newline ^
"                 repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 ast_thms m_defs i," ^ newline ^
"                 RENA_tac i," ^ newline ^
"                 localsimp_tac ctxt i," ^ newline ^
"                 (* HWL: sometimes more clean-up necessary *)" ^ newline ^
"                 TRY(EVERY[rtac conjI i, localsimp_tac ctxt i, localsimp_tac ctxt i])," ^ newline ^
"                 TRY(EVERY[clarify_tac (claset()) i, testFalse 1, no_tac])]," ^ newline ^
"          null_tac_simp ctxt i" ^ newline ^
"         ]" ^ newline ^
"    THEN" ^ newline ^
"    testFalse 1" ^ newline ^
"" ^ newline ^
"  fun let_tac ctxt thms rectac i = " ^ newline ^
"      FIRST [EVERY [rtac mrg_letv i, leaf_tac ctxt thms i, rectac i, bsf i]," ^ newline ^
"             EVERY [rtac mrg_leti i, leaf_tac ctxt thms i, rectac i, bsf i]," ^ newline ^
"(*             EVERY [rtac mrg_letrnull i, rectac i, leaf_tac ctxt thms i, lsf ctxt i, bsf i],*)" ^ newline ^
"             EVERY [rtac mrg_letrnull i, rectac i, null_tac_simp ctxt i, lsf ctxt i, bsf i]," ^ newline ^
"             EVERY [rtac mrg_letr i, leaf_tac ctxt thms i, rectac i, lsf ctxt i, bsf i]]" ^ newline ^
"" ^ newline ^
"  fun match_tac ctxt rectac i = " ^ newline ^
"    FIRST [EVERY [rtac mrg_listmatchd i, getr_fast ctxt i, " ^ newline ^
"                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i]," ^ newline ^
"           EVERY [rtac mrg_resultmatchd i, getr_fast ctxt i, " ^ newline ^
"                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i]," ^ newline ^
"           EVERY [rtac mrg_treematchd i, (getr_fast ctxt i)," ^ newline ^
"                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i]," ^ newline ^
"           EVERY [rtac mrg_listmatch i, (getr_fast ctxt i)," ^ newline ^
"                  basicsimpset_tac i, rectac i, lsf ctxt i]," ^ newline ^
"           EVERY [rtac mrg_resultmatch i, (getr_fast ctxt i)," ^ newline ^
"                  basicsimpset_tac i, rectac i, lsf ctxt i]," ^ newline ^
"           EVERY [rtac mrg_treematch i, (getr_fast ctxt i)," ^ newline ^
"                  basicsimpset_tac i, localsimp_tac ctxt i, localsimp_tac ctxt i, rectac i, lsf ctxt i]]" ^ newline ^
"  " ^ newline ^
"  fun call_tac ctxt thms tac i =" ^ newline ^
"   EVERY [rtac mrg_call i, " ^ newline ^
"      localsimp_tac_thms ctxt thms i," ^ newline ^
"          tac i]" ^ newline ^
"" ^ newline ^
"  fun call_stop_tac ctxt thms tac i =" ^ newline ^
"   EVERY [rtac mrg_call i, " ^ newline ^
"      localsimp_tac_thms ctxt thms i," ^ newline ^
"          stop ctxt thms i]" ^ newline ^
"" ^ newline ^
"  fun asm_localsimp_tac ctxt = asm_simp_tac (Simplifier.get_local_simpset ctxt)" ^ newline ^
"  fun funsimp_tac_thms t = simp_tac (HOL_basic_ss addsimps (snd_conv :: t))" ^ newline ^
"  fun domm_tac ctxt thms tac1 tac2 i =" ^ newline ^
"    FIRST [EVERY [rtac mrg_domcallnil i, asm_localsimp_tac ctxt i," ^ newline ^
"                  funsimp_tac_thms thms i, rtac mrg_sound i," ^ newline ^
"                  tac1 i]," ^ newline ^
"           EVERY [rtac mrg_domcallcons i, tac1 i," ^ newline ^
"                  localsimp_tac_thms ctxt thms i,tac2 i]," ^ newline ^
"           EVERY [rtac conjI i,  (* leaves subgoal of form ?U = X *)" ^ newline ^
"                  localsimp_tac_thms ctxt thms i," ^ newline ^
"              TRY(rtac disjI1 i), (* HWL: not if call was in dom set!! *)" ^ newline ^
"                  localsimp_tac_thms ctxt thms i]]" ^ newline ^
"" ^ newline ^
"     (* here: solve a subgoal of the same form, then simplify with MFS_defs to expand method body" ^ newline ^
"        in other subgoals (for each of the dominators?)" ^ newline ^
"    We want to do this to maintain invariant for VCG." ^ newline ^
"        asm_localsimp_tac_thms ctxt thms 2" ^ newline ^
"     *)" ^ newline ^
"  (* rec_tac : ctxt  thms  int  tactic  tactic  int  tactic*)" ^ newline ^
"  fun dom_tac ctxt thms rec_tac tac2 i =" ^ newline ^
"    let fun domcall n state = state |> " ^ newline ^
"       ((((rtac mrg_domcallcons i) THEN domcall (n+1))" ^ newline ^
"     ORELSE" ^ newline ^
"     (EVERY " ^ newline ^
"      ([(rtac mrg_domcallnil i)," ^ newline ^
"        asm_localsimp_tac ctxt i," ^ newline ^
"       (* asm_localsimp_tac_thms ctxt thms i,*)" ^ newline ^
"        funsimp_tac_thms thms i," ^ newline ^
"            rtac mrg_sound i," ^ newline ^
"        rec_tac i] @" ^ newline ^
"       (map tac2 (rev (i upto (i+n-1)))))))" ^ newline ^
"     ORELSE" ^ newline ^
"     (* solve for a merge point by projecting on the context, " ^ newline ^
"        solving a set-equality subgoal *)" ^ newline ^
"     (EVERY" ^ newline ^
"      [rtac conjI i,  (* leaves subgoal of form ?U = X *)" ^ newline ^
"           localsimp_tac_thms ctxt thms i," ^ newline ^
"       rtac disjI1 i," ^ newline ^
"       localsimp_tac_thms ctxt thms i]))" ^ newline ^
"      in domcall 0 end" ^ newline ^
"" ^ newline ^
"  fun if_tac rec_tacTHEN rec_tacELSE i =" ^ newline ^
"   EVERY [rtac mrg_if i," ^ newline ^
"          rec_tacTHEN i," ^ newline ^
"      rec_tacELSE i]" ^ newline ^
"" ^ newline ^
"  fun w_tac ctxt thms tac i = " ^ newline ^
"    EVERY" ^ newline ^
"      [TRY(localsimp_tac_thms ctxt thms i),  (* expand SPEC, methtable *)" ^ newline ^
"       rtac mrg_sound i," ^ newline ^
"       rtac mrg_weak i," ^ newline ^
"       tac i," ^ newline ^
"       fast_tac (claset()) i]" ^ newline ^
"" ^ newline ^
"  fun main_stop ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> " ^ newline ^
"    FIRST [if_tac (stop ctxt thms) (stop ctxt thms) i," ^ newline ^
"           call_tac ctxt (d_defs@m_defs@f_defs@c_defs) (stop ctxt thms) i,(*HWL: all ?_defs???*)" ^ newline ^
"(*           dom_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt f_defs (stop ctxt thms)) i,*)" ^ newline ^
"           domm_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt f_defs (stop ctxt thms)) i," ^ newline ^
"           leaf_tac ctxt thms i," ^ newline ^
"           match_tac ctxt (stop ctxt thms) i," ^ newline ^
"           let_tac ctxt thms (stop ctxt thms) i]" ^ newline ^
"    THEN" ^ newline ^
"    testFalse 1" ^ newline ^
"" ^ newline ^
"   fun main_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> " ^ newline ^
"    FIRST [if_tac (main_tac ctxt thms) (main_tac ctxt thms) i," ^ newline ^
"           call_tac ctxt d_defs (main_tac ctxt thms) i," ^ newline ^
"(*           dom_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i,*)" ^ newline ^
"           domm_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i," ^ newline ^
"           leaf_tac ctxt thms i," ^ newline ^
"           match_tac ctxt (main_tac ctxt thms) i," ^ newline ^
"           let_tac ctxt thms (main_tac ctxt thms) i]" ^ newline ^
"    THEN" ^ newline ^
"    testFalse 1" ^ newline ^
"*}" ^ newline 

 val s4 = 
"(* -------------------- TACTIC *)" ^ newline ^
"" ^ newline ^
"method_setup AST_THMS = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => (ast_thms thms 1)))*}" ^ newline ^
"  \"Method for asm_simp_tac\"" ^ newline ^
"method_setup AST_THMS_FAST = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => (ast_thms_fast thms 1)))*}" ^ newline ^
"  \"Method for asm_simp_tac\"" ^ newline ^
"method_setup LEAF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => leaf_tac ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\") 1))*}" ^ newline ^
"  \"Method for leaf rules\"" ^ newline ^
"method_setup BS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => basicsimpset_tac 1))*}" ^ newline ^
"  \"Method for basic simpset\"" ^ newline ^
"method_setup BSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => bsf 1))*}" ^ newline ^
"  \"Method for basic simpset + fast\"" ^ newline ^
"method_setup SB = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => sym_basicsimp 1))*}" ^ newline ^
"  \"Method for symmetric basic simpset\"" ^ newline ^
"method_setup GT = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => getr_tac ctxt 1))*}" ^ newline ^
"  \"Method for GETr\"" ^ newline ^
"method_setup GTC = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => getr_clar_tac ctxt 1))*}" ^ newline ^
"  \"Method for GETr with clarify\"" ^ newline ^
"method_setup GTF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => getr_fast ctxt 1))*}" ^ newline ^
"  \"Method for GETr with fast\"" ^ newline ^
"method_setup STT = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => simpset_tac_thms thms 1))*}" ^ newline ^
"  \"Method for basic simpset\"" ^ newline ^
"method_setup LS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => localsimp_tac ctxt 1))*}" ^ newline ^
"  \"Method for local simpset\"" ^ newline ^
"method_setup LSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => lsf ctxt 1))*}" ^ newline ^
"  \"Method for local simpset + fast\"" ^ newline ^
"method_setup LSTT = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => localsimp_tac_thms ctxt thms 1))*}" ^ newline ^
"  \"Method for local_simpset_thms\"" ^ newline ^
"method_setup LET = {* Method.thms_ctxt_args (fn t => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => let_tac ctxt ([],thms \"meth_defs\",t,thms \"ctxt_def\") (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1))*}" ^ newline ^
"  \"Method for local_simpset_thms\"" ^ newline ^
"method_setup IF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => if_tac (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\"))  (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"Method for a Conditional\"" ^ newline ^
"method_setup CALL = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => call_tac ctxt pdefs (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"Method for a Call\"" ^ newline ^
"method_setup CALLS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => call_stop_tac ctxt pdefs (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"Method for a Call\"" ^ newline ^
"(*" ^ newline ^
"method_setup IF = {* Method.thms_ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => if_tac ctxt ([],thms \"meth_defs\",t,thms \"ctxt_def\") (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1))*}" ^ newline ^
"  \"Method for Conditionals\"" ^ newline ^
"method_setup CALL = {* Method.thms_ctxt_args (fn t => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => call_tac ctxt ([],thms \"meth_defs\",t,thms \"ctxt_def\") (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1))*}" ^ newline ^
"  \"Method for Calls\"" ^ newline ^
"*)" ^ newline ^
"method_setup MATCH = {* Method.thms_ctxt_args (fn t => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => match_tac ctxt (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1))*}" ^ newline ^
"  \"Method for matches\"" ^ newline ^
"method_setup SBS = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => (sym_basicsimp 1)))*}" ^ newline ^
"  \"Method for symbasicsimp\"" ^ newline ^
"method_setup ASM_LOC = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => " ^ newline ^
"    asm_simp_tac (Simplifier.get_local_simpset ctxt) 1))*}" ^ newline ^
"\"asm_local_simpset\"" ^ newline ^
"method_setup MS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => main_stop ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\") 1)) *}" ^ newline ^
"  \"main Method with stop continuation, simplification with args\" " ^ newline ^
"method_setup M = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => main_tac ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\") 1)) *}" ^ newline ^
"  \"main Method: simplification with args\" " ^ newline ^
" " ^ newline ^
"method_setup W = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => w_tac ctxt ((thms \"meth_defs\")@(thms \"fun_defs\")@(thms \"ctxt_def\")) (main_tac ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"parametric Method for starting: use weakening, simplification with args, fast\" " ^ newline ^
"method_setup WS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => w_tac ctxt ((thms \"meth_defs\")@(thms \"fun_defs\")) (main_stop ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"parametric Method for starting: use weakening, simplification with args, fast\"" ^ newline ^
"" ^ newline ^
"method_setup DOMM = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => domm_tac ctxt pdefs (main_tac ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\")) (w_tac ctxt (thms \"meth_defs\") (main_tac ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\"))) 1)) *}" ^ newline ^
"  \"parametric Method for DOMM\"" ^ newline ^
"" ^ newline ^
"method_setup DOMS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => domm_tac ctxt pdefs (stop ctxt []) (stop ctxt []) 1)) *}" ^ newline ^
"  \"parametric Method for DOMM; 1-step\"" ^ newline ^
"" ^ newline 

  val s = s1 ^ newline ^ s2 ^ newline ^ s3 ^ newline ^ s4 ^ newline ^ "end"

  val fname = GrailUtils.makeFullFilename outDir theoryname "thy"
  val os = TextIO.openOut fname
  val () = TextIO.output(os,s)
  val () = TextIO.closeOut os  
  val () = printToStdErr ("Wrote "^fname^"\n")
 in
   () (* YUCK *)
 end

fun mk_tactics6 cname outDir =
  let val theoryname = cname ^ "_TACTIC"
      val s1 = "theory " ^ theoryname ^ " = " ^ cname ^ "Certificate:" ^ 
               newline ^ newline

      val s2 = "" ^ newline ^ 
"ML_setup {*" ^ newline ^
"  exception MRG of string" ^ newline ^
"" ^ newline ^
"  val indent = ref 0" ^ newline ^
"" ^ newline ^
"  fun spaces 0 s = s" ^ newline ^
"    | spaces n s = spaces (n-1) (\" \"^s)" ^ newline ^
"" ^ newline ^
"  val basicsimpset_tac = simp_tac HOL_basic_ss" ^ newline ^
"  fun sym_basicsimp i = FIRST [CHANGED (simp_tac HOL_basic_ss i), rtac add_commute i]" ^ newline ^
"" ^ newline ^
"  fun localsimp_tac ctxt i = simp_tac (Simplifier.get_local_simpset ctxt) i" ^ newline ^
"  fun localsimp_tac_thms ctxt thms = " ^ newline ^
"     simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)" ^ newline ^
"  fun simpset_tac_thms t i = simp_tac (HOL_basic_ss addsimps ([fst_conv,snd_conv]@t)) i" ^ newline ^
"" ^ newline ^
" fun testFalse i =" ^ newline ^
"   SUBGOAL (fn (prop,_) =>" ^ newline ^
"      let val concl = Logic.strip_assums_concl prop in" ^ newline ^
"          case concl of " ^ newline ^
"          (Const (\"Trueprop\", _) $ Const (\"False\", _)) => (print_tac \"=+=  1\" ; raise MRG \"this is soooooooooooooooooooooo FALSE\")" ^ newline ^
"        | _ => all_tac  end) i" ^ newline ^
"" ^ newline ^
"  fun repeat 0 tac = all_tac" ^ newline ^
"    | repeat n tac = tac THEN (repeat (n-1) tac)" ^ newline ^
"" ^ newline ^
"  val mrg_int = thm \"MRG_Int\"" ^ newline ^
"  val mrg_ivar = thm \"MRG_IVar\"" ^ newline ^
"  val mrg_rvar = thm \"MRG_RVar\"" ^ newline ^
"  val mrg_prim = thm \"MRG_Prim\"" ^ newline ^
"  val mrg_rprim = thm \"MRG_RPrim\"" ^ newline ^
"  val mrg_nulllist = thm \"MRG_NullList\"" ^ newline ^
"  val mrg_nullres = thm \"MRG_NullRes\"" ^ newline ^
"  val mrg_nulltree = thm \"MRG_NullTree\"" ^ newline ^
"  val mrg_makelist = thm \"MRG_MakeList\"" ^ newline ^
"  val mrg_maketree = thm \"MRG_MakeTree\"" ^ newline ^
"  val mrg_makeresult = thm \"MRG_MakeResultSome\"" ^ newline ^
"  val mrg_invstat = thm \"MRG_InvStat\"" ^ newline ^
"  val mrg_letv = thm \"MRG_Letv\"" ^ newline ^
"  val mrg_leti = thm \"MRG_Leti\"" ^ newline ^
"  val mrg_letr = thm \"MRG_Letr\"" ^ newline ^
"  val mrg_letrnull = thm \"MRG_LetrNull\"" ^ newline ^
"  val mrg_listmatch = thm \"MRG_ListMatch\"" ^ newline ^
"  val mrg_listmatchd = thm \"MRG_ListMatchD\"" ^ newline ^
"  val mrg_treematch = thm \"MRG_TreeMatch\"" ^ newline ^
"  val mrg_treematchd = thm \"MRG_TreeMatchD\"" ^ newline ^
"  val mrg_resultmatch = thm \"MRG_ResultMatch\"" ^ newline ^
"  val mrg_resultmatchd = thm \"MRG_ResultMatchD\"" ^ newline ^
"  val mrg_if = thm \"MRG_If\"" ^ newline ^
"  val mrg_weak = thm \"MRG_Weak\"" ^ newline ^
"" ^ newline ^
"  val mrg_call = thm \"MRG_Call\"" ^ newline ^
"  val mrg_domcallnil = thm \"DOM_CallNIL\"" ^ newline ^
"  val mrg_domcallcons = thm \"DOM_CallCONS\"" ^ newline ^
"" ^ newline ^
"  val rena_nil = thm \"RENA_NIL\"" ^ newline ^
"  val rena_in = thm \"RENA_IN\"" ^ newline ^
"  val rena_rn = thm \"RENA_RN\"" ^ newline ^
"" ^ newline ^
"  val mrg_sound = thm \"MRG_sound\"" ^ newline ^
"" ^ newline 

    val s3 = "" ^
"  fun getr_tac ctxt i = localsimp_tac ctxt i" ^ newline ^
"  fun getr_clar_tac ctxt i = EVERY [localsimp_tac ctxt i, clarify_tac HOL_cs i]" ^ newline ^
"  fun getr_fast ctxt i = SELECT_GOAL (FIRST [SOLVE (getr_tac ctxt i), EVERY [getr_tac ctxt i, fast_tac (claset()) i]]) i" ^ newline ^
"" ^ newline ^
"  fun hwl_bsf i = SELECT_GOAL (FIRST [SOLVE (basicsimpset_tac i), EVERY [basicsimpset_tac i, fast_tac (claset()) i], TRY (basicsimpset_tac i)]) i" ^ newline ^
"  fun hwl_lsf ctxt i = SELECT_GOAL (FIRST [SOLVE (localsimp_tac ctxt i), EVERY [localsimp_tac_thms ctxt [thm \"set_diff_def\"] i]]) i" ^ newline ^
"" ^ newline ^
"  fun bsf i = SELECT_GOAL (FIRST [SOLVE (basicsimpset_tac i), EVERY [basicsimpset_tac i, fast_tac (claset()) i]]) i" ^ newline ^
"  fun lsf ctxt i = SELECT_GOAL (FIRST [SOLVE (localsimp_tac ctxt i), EVERY [localsimp_tac ctxt i, fast_tac (claset()) i]]) i" ^ newline ^
"" ^ newline ^
"  fun type_tac i = basicsimpset_tac i" ^ newline ^
"  fun context_tac ctxt thms i = localsimp_tac_thms ctxt thms i" ^ newline ^
"" ^ newline ^
"  fun stop ctxt thms i = all_tac" ^ newline ^
"" ^ newline ^
"  fun ast i = asm_simp_tac (simpset()) i " ^ newline ^
"" ^ newline ^
"  fun ast_thms thms i = " ^ newline ^
"     asm_simp_tac ((simpset()) addsimps thms) i" ^ newline ^
"" ^ newline ^
"  fun ast_fast i =" ^ newline ^
"         SELECT_GOAL (FIRST[SOLVE (ast i)," ^ newline ^
"                            EVERY [ast i,fast_tac (claset()) i]]) i" ^ newline ^
"  fun ast_thms_fast thms i = " ^ newline ^
"         SELECT_GOAL (FIRST[SOLVE (ast_thms thms i), " ^ newline ^
"                            EVERY [ast_thms thms i,fast_tac (claset()) i]]) i" ^ newline ^
"" ^ newline ^
"  fun RENA_tac i state = state |> " ^ newline ^
"    (indent := (!indent)+1 ; all_tac)" ^ newline ^
"    THEN" ^ newline ^
"    print_tac (spaces (!indent) \"^RENA_TAC: rena_tac ...\")" ^ newline ^
"    THEN" ^ newline ^
"    FIRST [EVERY [rtac rena_in i, RENA_tac i]," ^ newline ^
"           EVERY [rtac rena_rn i, RENA_tac i]," ^ newline ^
"           rtac rena_nil i]" ^ newline ^
"    THEN" ^ newline ^
"    print_tac (spaces (!indent) \"+RENA_tac ...\")" ^ newline ^
"    THEN" ^ newline ^
"    (indent := (!indent)-1 ; all_tac)" ^ newline ^
"" ^ newline ^
"  fun null_tac ctxt i =" ^ newline ^
"    FIRST [EVERY [rtac mrg_nulllist i, print_tac (spaces (!indent)  \"@@@ nulllist\"), localsimp_tac ctxt i]," ^ newline ^
"           EVERY [rtac mrg_nullres i, print_tac (spaces (!indent)  \"@@@ nullres\"), localsimp_tac ctxt i]," ^ newline ^
"           EVERY [rtac mrg_nulltree i, print_tac (spaces (!indent)  \"@@@ nulltree\"), localsimp_tac ctxt i]]" ^ newline ^
"" ^ newline ^
"  fun null_tac_simp ctxt i = " ^ newline ^
"     EVERY [SELECT_GOAL (FIRST [null_tac ctxt i, EVERY[localsimp_tac ctxt i, null_tac ctxt i]]) i]" ^ newline ^
"" ^ newline ^
"  fun leaf_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i =" ^ newline ^
"   (indent := (!indent)+1 ; all_tac)" ^ newline ^
"   THEN" ^ newline ^
"   print_tac (spaces (!indent) \"^LEAF_TAC: leaf_tac ...\")" ^ newline ^
"   THEN" ^ newline ^
"   FIRST [EVERY [rtac mrg_int i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_ivar i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_rvar i, getr_fast ctxt i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_prim i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_rprim i, repeat 2 (getr_fast ctxt i), localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_maketree i, print_tac (spaces (!indent)  \"@@@ maketree\"), getr_fast ctxt i, getr_fast ctxt i," ^ newline ^
"                 localsimp_tac ctxt i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_makelist i, print_tac (spaces (!indent)  \"@@@ makelist\"), getr_fast ctxt i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_makeresult i, print_tac (spaces (!indent)  \"@@@ makeresult\"), getr_fast ctxt i, localsimp_tac ctxt i]," ^ newline ^
"          EVERY [rtac mrg_invstat i," ^ newline ^
"                 print_tac (spaces (!indent)  \"@@@ invstat\"), " ^ newline ^
"                 localsimp_tac_thms ctxt c_defs i, " ^ newline ^
"                 localsimp_tac_thms ctxt m_defs i, " ^ newline ^
"                 ast_thms m_defs i," ^ newline ^
"                 ast i," ^ newline ^
"                 ast_thms_fast m_defs i, ast_fast i, " ^ newline ^
"                 repeat 2 (localsimp_tac_thms ctxt [thm \"DOM_def\"] i)," ^ newline ^
"                 repeat 2 (localsimp_tac ctxt i)," ^ newline ^
"                 ast_thms m_defs i," ^ newline ^
"                 RENA_tac i," ^ newline ^
"                 localsimp_tac ctxt i," ^ newline ^
"                 (* HWL: sometimes more clean-up necessary *)" ^ newline ^
"                 TRY(EVERY[rtac conjI i, localsimp_tac ctxt i, localsimp_tac ctxt i," ^ newline ^
"                           print_tac (spaces (!indent)  \"@@@ BONZO was here (InvokeStatic cleanup)\")])," ^ newline ^
"                 TRY(EVERY[clarify_tac (claset()) i, testFalse 1, no_tac])]," ^ newline ^
"          null_tac_simp ctxt i" ^ newline ^
"         ]" ^ newline ^
"  THEN" ^ newline ^
"  print_tac (spaces (!indent) \"+leaf_tac ...\")" ^ newline ^
"  THEN" ^ newline ^
"  (indent := (!indent)-1 ; all_tac)" ^ newline ^
"    THEN" ^ newline ^
"    testFalse 1" ^ newline ^
"" ^ newline ^
"  fun let_tac ctxt thms rectac i = " ^ newline ^
"     (indent := (!indent)+1 ; all_tac)" ^ newline ^
"     THEN" ^ newline ^
"      print_tac (spaces (!indent) \"^LET_TAC: let_tac ...\")" ^ newline ^
"      THEN" ^ newline ^
"      FIRST [EVERY [print_tac (spaces (!indent)  \"___ trying letv\"), rtac mrg_letv i, print_tac (spaces (!indent)  \"@@@ letv\"), leaf_tac ctxt thms i, rectac i, bsf i]," ^ newline ^
"             EVERY [print_tac (spaces (!indent)  \"___ trying leti\"), rtac mrg_leti i, print_tac (spaces (!indent)  \"@@@ leti\"), leaf_tac ctxt thms i, rectac i, bsf i]," ^ newline ^
"(*           EVERY [rtac mrg_letrnull i, rectac i, leaf_tac ctxt thms i, lsf ctxt i, bsf i],*)" ^ newline ^
"             EVERY [print_tac (spaces (!indent)  \"___ trying letrnull\"), rtac mrg_letrnull i, print_tac (spaces (!indent) \"@@@ letnull\"), rectac i, null_tac_simp ctxt i, lsf ctxt i, bsf i]," ^ newline ^
"             EVERY [print_tac (spaces (!indent)  \"___ trying letr\"), rtac mrg_letr i, print_tac (spaces (!indent) \"@@@ letr\"), leaf_tac ctxt thms i, rectac i, lsf ctxt i, bsf i]]" ^ newline ^
"  THEN" ^ newline ^
"  print_tac (spaces (!indent) \"+LET_tac ...\")" ^ newline ^
"  THEN" ^ newline ^
"  (if ((!indent)=1) then no_tac else all_tac)" ^ newline ^
"  THEN" ^ newline ^
"  (indent := (!indent)-1 ; all_tac)" ^ newline ^
"" ^ newline ^
"" ^ newline ^
"  fun match_tac ctxt rectac i = " ^ newline ^
"    (indent := (!indent)+1 ; all_tac)" ^ newline ^
"    THEN" ^ newline ^
"    FIRST [" ^ newline ^
"            EVERY [rtac mrg_listmatchd i, " ^ newline ^
"                   print_tac (spaces (!indent) \"@@@ LISTmatchD\")," ^ newline ^
"                  getr_fast ctxt i, " ^ newline ^
"                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i]," ^ newline ^
"            EVERY [rtac mrg_resultmatchd i, " ^ newline ^
"                  print_tac (spaces (!indent) \"@@@ RESULTmatchD\")," ^ newline ^
"                  getr_fast ctxt i, " ^ newline ^
"                   basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i]," ^ newline ^
"            EVERY [rtac mrg_treematchd i, " ^ newline ^
"                   print_tac (spaces (!indent) \"@@@ TREEmatchD\")," ^ newline ^
"                   (getr_fast ctxt i)," ^ newline ^
"                   basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i]," ^ newline ^
"            EVERY [rtac mrg_listmatch i, " ^ newline ^
"                  print_tac (spaces (!indent) \"@@@ LISTmatch\")," ^ newline ^
"                  (getr_fast ctxt i)," ^ newline ^
"                  basicsimpset_tac i, rectac i, lsf ctxt i]," ^ newline ^
"            EVERY [rtac mrg_resultmatch i, " ^ newline ^
"                   print_tac (spaces (!indent) \"@@@ RESULTmatch\")," ^ newline ^
"                   (getr_fast ctxt i)," ^ newline ^
"                   basicsimpset_tac i, rectac i, lsf ctxt i]," ^ newline ^
"            EVERY [rtac mrg_treematch i, " ^ newline ^
"                  print_tac (spaces (!indent) \"@@@ TREEmatch\")," ^ newline ^
"                  (getr_fast ctxt i)," ^ newline ^
"                  basicsimpset_tac i, localsimp_tac ctxt i, localsimp_tac ctxt i, rectac i, lsf ctxt i]]" ^ newline ^
"    THEN" ^ newline ^
"    (indent := (!indent)-1 ; all_tac)" ^ newline ^
"  " ^ newline ^
"  (* verbose version reporting every tried tac *)" ^ newline ^
"  fun verbose_main_tac ctxt rectac i = " ^ newline ^
"    (indent := (!indent)+1 ; all_tac)" ^ newline ^
"    THEN" ^ newline ^
"    FIRST [" ^ newline ^
"            EVERY [print_tac (spaces (!indent) \"___ MATCH_TAC: trying LISTmatchD etc ...\")," ^ newline ^
"                  rtac mrg_listmatchd i, " ^ newline ^
"                  print_tac \"++listmatch\"," ^ newline ^
"                  getr_fast ctxt i, " ^ newline ^
"                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i]," ^ newline ^
"            EVERY [print_tac (spaces (!indent) \"___ MATCH_TAC: trying RESULTmatchD etc ...\")," ^ newline ^
"                   rtac mrg_resultmatchd i, " ^ newline ^
"                  print_tac \"++resultmatchD\"," ^ newline ^
"                  getr_fast ctxt i, " ^ newline ^
"                   basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i]," ^ newline ^
"            EVERY [print_tac (spaces (!indent) \"___ MATCH_TAC: trying TREEmatchD etc ...\")," ^ newline ^
"                   rtac mrg_treematchd i, " ^ newline ^
"                   print_tac \"++treematchd\"," ^ newline ^
"                   (getr_fast ctxt i)," ^ newline ^
"                   basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i]," ^ newline ^
"            EVERY [print_tac (spaces (!indent) \"___ MATCH_TAC: trying LISTmatch etc ...\")," ^ newline ^
"                  rtac mrg_listmatch i, " ^ newline ^
"                  print_tac \"++listmatchd\"," ^ newline ^
"                  (getr_fast ctxt i)," ^ newline ^
"                  basicsimpset_tac i, rectac i, lsf ctxt i]," ^ newline ^
"            EVERY [print_tac (spaces (!indent) \"___ MATCH_TAC: trying RESULTmatch etc ...\")," ^ newline ^
"                   rtac mrg_resultmatch i, " ^ newline ^
"                  print_tac \"++resultmatchd\"," ^ newline ^
"                   (getr_fast ctxt i)," ^ newline ^
"                   basicsimpset_tac i, rectac i, lsf ctxt i]," ^ newline ^
"            EVERY [print_tac (spaces (!indent) \"___ MATCH_TAC: trying TREEmatch etc ...\")," ^ newline ^
"                   rtac mrg_treematch i, " ^ newline ^
"                  print_tac \"++treematchd\"," ^ newline ^
"                  (getr_fast ctxt i)," ^ newline ^
"                  basicsimpset_tac i, localsimp_tac ctxt i, localsimp_tac ctxt i, rectac i, lsf ctxt i]]" ^ newline ^
"    THEN" ^ newline ^
"    testFalse 1" ^ newline ^
"    THEN" ^ newline ^
"    (indent := (!indent)-1 ; all_tac)" ^ newline ^
"  " ^ newline ^
"  fun call_tac ctxt thms tac i =" ^ newline ^
"   (indent := (!indent)+1 ; all_tac)" ^ newline ^
"   THEN" ^ newline ^
"   print_tac (spaces (!indent) \"^CALL_TAC: call_tac ...\")" ^ newline ^
"   THEN" ^ newline ^
"   EVERY [rtac mrg_call i, " ^ newline ^
"      localsimp_tac_thms ctxt thms i," ^ newline ^
"          tac i]" ^ newline ^
"   THEN" ^ newline ^
"   print_tac (spaces (!indent) \"+call_tac ...\")" ^ newline ^
"   THEN" ^ newline ^
"   (indent := (!indent)-1 ; all_tac)" ^ newline ^
"" ^ newline ^
"  fun call_stop_tac ctxt thms tac i =" ^ newline ^
"   EVERY [rtac mrg_call i, " ^ newline ^
"      localsimp_tac_thms ctxt thms i," ^ newline ^
"          stop ctxt thms i]" ^ newline ^
"" ^ newline ^
"  fun asm_localsimp_tac ctxt = asm_simp_tac (Simplifier.get_local_simpset ctxt)" ^ newline ^
"  fun funsimp_tac_thms t = simp_tac (HOL_basic_ss addsimps (snd_conv :: t))" ^ newline ^
"  fun domm_tac ctxt thms tac1 tac2 i =" ^ newline ^
"    print_tac (spaces (!indent) \"^DOMM_TAC: domm_tac ...\")" ^ newline ^
"    THEN" ^ newline ^
"    FIRST [EVERY [rtac mrg_domcallnil i, asm_localsimp_tac ctxt i," ^ newline ^
"                  funsimp_tac_thms thms i, rtac mrg_sound i," ^ newline ^
"                  tac1 i]," ^ newline ^
"           EVERY [rtac mrg_domcallcons i, tac1 i," ^ newline ^
"                  localsimp_tac_thms ctxt thms i,tac2 i]," ^ newline ^
"           EVERY [rtac conjI i,  (* leaves subgoal of form ?U = X *)" ^ newline ^
"                  localsimp_tac_thms ctxt thms i," ^ newline ^
"              TRY(rtac disjI1 i), (* HWL: not if call was in dom set!! *)" ^ newline ^
"                  localsimp_tac_thms ctxt thms i]]" ^ newline ^
"    THEN" ^ newline ^
"    print_tac (spaces (!indent) \"+domm_tac ...\")" ^ newline ^
"" ^ newline ^
"     (* here: solve a subgoal of the same form, then simplify with MFS_defs to expand method body" ^ newline ^
"        in other subgoals (for each of the dominators?)" ^ newline ^
"    We want to do this to maintain invariant for VCG." ^ newline ^
"        asm_localsimp_tac_thms ctxt thms 2" ^ newline ^
"     *)" ^ newline ^
"  (* rec_tac : ctxt \\<rightarrow> thms \\<rightarrow> int \\<rightarrow> tactic \\<rightarrow> tactic \\<rightarrow> int \\<rightarrow> tactic*)" ^ newline ^
"  fun dom_tac ctxt thms rec_tac tac2 i =" ^ newline ^
"    let fun domcall n state = state |> " ^ newline ^
"       ((((rtac mrg_domcallcons i) THEN domcall (n+1))" ^ newline ^
"     ORELSE" ^ newline ^
"     (EVERY " ^ newline ^
"      ([(rtac mrg_domcallnil i)," ^ newline ^
"        asm_localsimp_tac ctxt i," ^ newline ^
"       (* asm_localsimp_tac_thms ctxt thms i,*)" ^ newline ^
"        funsimp_tac_thms thms i," ^ newline ^
"            rtac mrg_sound i," ^ newline ^
"        rec_tac i] @" ^ newline ^
"       (map tac2 (rev (i upto (i+n-1)))))))" ^ newline ^
"     ORELSE" ^ newline ^
"     (* solve for a merge point by projecting on the context, " ^ newline ^
"        solving a set-equality subgoal *)" ^ newline ^
"     (EVERY" ^ newline ^
"      [rtac conjI i,  (* leaves subgoal of form ?U = X *)" ^ newline ^
"           localsimp_tac_thms ctxt thms i," ^ newline ^
"       rtac disjI1 i," ^ newline ^
"       localsimp_tac_thms ctxt thms i]))" ^ newline ^
"      in domcall 0 end" ^ newline ^
"" ^ newline ^
"  fun if_tac rec_tacTHEN rec_tacELSE i =" ^ newline ^
"    (indent := (!indent)+1 ; all_tac)" ^ newline ^
"    THEN" ^ newline ^
"    print_tac (spaces (!indent) \"^IF_TAC: if_tac ...\")" ^ newline ^
"    THEN" ^ newline ^
"   EVERY [rtac mrg_if i," ^ newline ^
"          rec_tacTHEN i," ^ newline ^
"      rec_tacELSE i]" ^ newline ^
"    THEN" ^ newline ^
"    print_tac (spaces (!indent) \"+if_tac ...\")" ^ newline ^
"     THEN" ^ newline ^
"     (indent := (!indent)-1 ; all_tac)" ^ newline ^
"" ^ newline ^
"  fun w_tac ctxt thms tac i = " ^ newline ^
"    EVERY" ^ newline ^
"      [TRY(localsimp_tac_thms ctxt thms i),  (* expand SPEC, methtable *)" ^ newline ^
"       rtac mrg_sound i," ^ newline ^
"       rtac mrg_weak i," ^ newline ^
"       tac i," ^ newline ^
"       fast_tac (claset()) i]" ^ newline ^
"" ^ newline ^
"  fun main_stop ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> " ^ newline ^
"    FIRST [if_tac (stop ctxt thms) (stop ctxt thms) i," ^ newline ^
"           call_tac ctxt (d_defs@m_defs@f_defs@c_defs) (stop ctxt thms) i,(*HWL: all ?_defs???*)" ^ newline ^
"(*           dom_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt f_defs (stop ctxt thms)) i,*)" ^ newline ^
"           domm_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt f_defs (stop ctxt thms)) i," ^ newline ^
"           leaf_tac ctxt thms i," ^ newline ^
"           match_tac ctxt (stop ctxt thms) i," ^ newline ^
"           let_tac ctxt thms (stop ctxt thms) i]" ^ newline ^
"" ^ newline ^
"   (* verbose version of the main tac reporting every tried tactic *)" ^ newline ^
"   fun verbose_main_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> " ^ newline ^
"    (indent := (!indent)+1 ; all_tac)" ^ newline ^
"    THEN" ^ newline ^
"    FIRST [EVERY[print_tac (spaces (!indent) \"^IF_TAC: trying if_tac ...\")," ^ newline ^
"                 if_tac (verbose_main_tac ctxt thms) (verbose_main_tac ctxt thms) i," ^ newline ^
"                 print_tac \"+if\"]," ^ newline ^
"           EVERY[print_tac (spaces (!indent) \"^CALL_TAC: trying call_tac ...\")," ^ newline ^
"                 call_tac ctxt d_defs (verbose_main_tac ctxt thms) i," ^ newline ^
"                 print_tac \"+call\"]," ^ newline ^
"(*           dom_tac ctxt f_defs (verbose_main_tac ctxt thms) (w_tac ctxt f_defs (verbose_main_tac ctxt thms)) i,*)" ^ newline ^
"           EVERY[print_tac (spaces (!indent) \"^DOMM_TAC: trying domm_tac ...\")," ^ newline ^
"                 domm_tac ctxt f_defs (verbose_main_tac ctxt thms) (w_tac ctxt f_defs (verbose_main_tac ctxt thms)) i," ^ newline ^
"                 print_tac \"+domm\"]," ^ newline ^
"           EVERY[print_tac (spaces (!indent) \"^LEAF_TAC: trying leaf_tac ...\")," ^ newline ^
"                 leaf_tac ctxt thms i," ^ newline ^
"                 print_tac \"+leaf\"]," ^ newline ^
"           EVERY[print_tac (spaces (!indent) \"^MATCH_TAC: trying match_tac ...\")," ^ newline ^
"                 match_tac ctxt (verbose_main_tac ctxt thms) i," ^ newline ^
"                 print_tac \"+match\"]," ^ newline ^
"           EVERY[print_tac (spaces (!indent) \"^LET_TAC: trying let_tac ...\")," ^ newline ^
"                 let_tac ctxt thms (verbose_main_tac ctxt thms) i," ^ newline ^
"                 print_tac \"+let\"]]" ^ newline ^
"    THEN" ^ newline ^
"    testFalse 1" ^ newline ^
"     THEN" ^ newline ^
"     (indent := (!indent)-1 ; all_tac)" ^ newline ^
"" ^ newline ^
"   fun main_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> " ^ newline ^
"    (indent := (!indent)+1 ; all_tac)" ^ newline ^
"    THEN" ^ newline ^
"    FIRST [EVERY[if_tac (main_tac ctxt thms) (main_tac ctxt thms) i]," ^ newline ^
"           EVERY[call_tac ctxt d_defs (main_tac ctxt thms) i]," ^ newline ^
"(*           dom_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i,*)" ^ newline ^
"           EVERY[domm_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i]," ^ newline ^
"           EVERY[leaf_tac ctxt thms i]," ^ newline ^
"           EVERY[match_tac ctxt (main_tac ctxt thms) i]," ^ newline ^
"           EVERY[let_tac ctxt thms (main_tac ctxt thms) i]]" ^ newline ^
"    THEN" ^ newline ^
"    testFalse 1" ^ newline ^
"     THEN" ^ newline ^
"     (indent := (!indent)-1 ; all_tac)" ^ newline ^
"" ^ newline ^
"*}" ^ newline ^
"" ^ newline 

    val s4 = "" ^
"(* -------------------- TACTIC *)" ^ newline ^
"" ^ newline ^
"method_setup AST_THMS = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => (ast_thms thms 1)))*}" ^ newline ^
"  \"Method for asm_simp_tac\"" ^ newline ^
"method_setup AST_THMS_FAST = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => (ast_thms_fast thms 1)))*}" ^ newline ^
"  \"Method for asm_simp_tac\"" ^ newline ^
"method_setup LEAF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => leaf_tac ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\") 1))*}" ^ newline ^
"  \"Method for leaf rules\"" ^ newline ^
"method_setup BS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => basicsimpset_tac 1))*}" ^ newline ^
"  \"Method for basic simpset\"" ^ newline ^
"method_setup BSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => bsf 1))*}" ^ newline ^
"  \"Method for basic simpset + fast\"" ^ newline ^
"method_setup SB = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => sym_basicsimp 1))*}" ^ newline ^
"  \"Method for symmetric basic simpset\"" ^ newline ^
"method_setup GT = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => getr_tac ctxt 1))*}" ^ newline ^
"  \"Method for GETr\"" ^ newline ^
"method_setup GTC = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => getr_clar_tac ctxt 1))*}" ^ newline ^
"  \"Method for GETr with clarify\"" ^ newline ^
"method_setup GTF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => getr_fast ctxt 1))*}" ^ newline ^
"  \"Method for GETr with fast\"" ^ newline ^
"method_setup STT = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => simpset_tac_thms thms 1))*}" ^ newline ^
"  \"Method for basic simpset\"" ^ newline ^
"method_setup LS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => localsimp_tac ctxt 1))*}" ^ newline ^
"  \"Method for local simpset\"" ^ newline ^
"method_setup LSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => lsf ctxt 1))*}" ^ newline ^
"  \"Method for local simpset + fast\"" ^ newline ^
"method_setup LSTT = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => localsimp_tac_thms ctxt thms 1))*}" ^ newline ^
"  \"Method for local_simpset_thms\"" ^ newline ^
"method_setup LET = {* Method.thms_ctxt_args (fn t => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => let_tac ctxt ([],thms \"meth_defs\",t,thms \"ctxt_def\") (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1))*}" ^ newline ^
"  \"Method for local_simpset_thms\"" ^ newline ^
"method_setup IF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => if_tac (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\"))  (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"Method for a Conditional\"" ^ newline ^
"method_setup CALL = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => call_tac ctxt pdefs (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"Method for a Call\"" ^ newline ^
"method_setup CALLS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => call_stop_tac ctxt pdefs (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"Method for a Call\"" ^ newline ^
"(*" ^ newline ^
"method_setup IF = {* Method.thms_ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => if_tac ctxt ([],thms \"meth_defs\",t,thms \"ctxt_def\") (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1))*}" ^ newline ^
"  \"Method for Conditionals\"" ^ newline ^
"method_setup CALL = {* Method.thms_ctxt_args (fn t => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => call_tac ctxt ([],thms \"meth_defs\",t,thms \"ctxt_def\") (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1))*}" ^ newline ^
"  \"Method for Calls\"" ^ newline ^
"*)" ^ newline ^
"method_setup MATCH = {* Method.thms_ctxt_args (fn t => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => match_tac ctxt (stop ctxt ([],thms \"meth_defs\",[],thms \"ctxt_def\")) 1))*}" ^ newline ^
"  \"Method for matches\"" ^ newline ^
"method_setup SBS = {* Method.thms_ctxt_args (fn thms => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => (sym_basicsimp 1)))*}" ^ newline ^
"  \"Method for symbasicsimp\"" ^ newline ^
"method_setup ASM_LOC = {* Method.ctxt_args (fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => " ^ newline ^
"    asm_simp_tac (Simplifier.get_local_simpset ctxt) 1))*}" ^ newline ^
"\"asm_local_simpset\"" ^ newline ^
"method_setup MS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => main_stop ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\") 1)) *}" ^ newline ^
"  \"main Method with stop continuation, simplification with args\" " ^ newline ^
"method_setup M = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => main_tac ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\") 1)) *}" ^ newline ^
"  \"main Method: simplification with args\" " ^ newline ^
" " ^ newline ^
"method_setup W = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => w_tac ctxt ((thms \"meth_defs\")@(thms \"fun_defs\")@(thms \"ctxt_def\")) (main_tac ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"parametric Method for starting: use weakening, simplification with args, fast\" " ^ newline ^
"method_setup WS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => w_tac ctxt ((thms \"meth_defs\")@(thms \"fun_defs\")) (main_stop ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\")) 1)) *}" ^ newline ^
"  \"parametric Method for starting: use weakening, simplification with args, fast\"" ^ newline ^
"" ^ newline ^
"method_setup DOMM = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => domm_tac ctxt pdefs (main_tac ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\")) (w_tac ctxt (thms \"meth_defs\") (main_tac ctxt (thms \"dmp_defs\",thms \"meth_defs\",pdefs,thms \"ctxt_def\"))) 1)) *}" ^ newline ^
"  \"parametric Method for DOMM\"" ^ newline ^
"" ^ newline ^
"method_setup DOMS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => " ^ newline ^
"  Method.METHOD (fn facts => domm_tac ctxt pdefs (stop ctxt []) (stop ctxt []) 1)) *}" ^ newline ^
"  \"parametric Method for DOMM; 1-step\"" ^ newline 

  val s = s1 ^ newline ^ s2 ^ newline ^ s3 ^ newline ^ s4 ^ newline ^ "end"

  val fname = GrailUtils.makeFullFilename outDir theoryname "thy"
  val os = TextIO.openOut fname
  val () = TextIO.output(os,s)
  val () = TextIO.closeOut os  
  val () = printToStdErr ("Wrote "^fname^"\n")
 in
   () (* YUCK *)
 end


(*
fun mk_tactics4 cname outDir =
  let val theoryname = cname ^ "_TACTIC"
      val s1 = "theory " ^ theoryname ^ " = " ^ cname ^ "Certificate:" ^ 
               newline ^ newline
  val s = s1 ^ newline ^ s2 ^ newline ^ s3 ^ newline ^ "end"

  val fname = GrailUtils.makeFullFilename outDir theoryname "thy"
  val os = TextIO.openOut fname
  val () = TextIO.output(os,s)
  val () = TextIO.closeOut os  
  val () = printToStdErr ("Wrote "^fname^"\n")
 in
   () (* YUCK *)
 end
*)

fun getWrapperFromCert cname = 
 let
   val cert_file = cname^"Certificate.thy"
   val tmp_file = cname^"Certificate-tmp.thy"
   val status = Process.system ("cat " ^ cert_file ^ " |  sed '/^(\\*# WRAPPER/,/^#\\*)/!d' | sed '1d;$d' | sed '$d' | sed 's/^M$//' > " ^ tmp_file )
   val str = if (FileSys.fileSize tmp_file > 0)
             then let 
                    val is = TextIO.openIn tmp_file
                    val str = TextIO.inputAll is
                    val _ = TextIO.closeIn is
                  in
                    str
                  end
              else ""
 in 
  str
 end

fun getCertMethodFromCert cname = 
 let
   val cert_file = cname^"Certificate.thy"
   val tmp_file = cname^"Certificate-tmp.thy"
   val status = Process.system ("cat " ^ cert_file ^ " |  sed '/^(\\*# CERTIFIED_METHOD/!d' | sed 's/^(\\*# CERTIFIED_METHOD: *\"\\(.*\\)\" *#\\*)/\\1/g' > " ^ tmp_file )
   val str = if (FileSys.fileSize tmp_file > 0)
             then let 
                    val is = TextIO.openIn tmp_file
                    val str = TextIO.inputAll is
                    val _ = TextIO.closeIn is
    	          in
                    str
                  end
              else ""
 in 
  str
 end

fun makeWrapper0 cname wrapperStr outDir = 
 let
   val wrapper_file = cname ^ "Wrap.thy"

   val s0 = ("theory " ^ cname ^ "Wrap = ResourcePolicy + " ^ cname ^ "_Consumer2:\n");

   val s1 = "(* --------------------------------------------------------------------------- *)" ^newline ^
"(* WRAPPER *)" ^newline ^
"" ^newline ^
"axioms sort_parlist:" ^newline ^
" \"fst (methtable "^cname ^" "^cname^"'sort) = [RNpar "^cname^"'sort'l]\"" ^newline ^
"" ^newline ^
"consts init :: mname" ^newline ^
"       INPUT :: \"ARG list\"" ^newline ^
"       l0 :: rname " ^newline ^
"" ^newline ^
"translations " ^newline ^
"       \"init\" == \"(MN ''init_'') \"" ^newline ^
"       \"l0\" == \"(RN ''l0_'') \"" ^newline ^
"" ^newline ^
"(*# UNFOLD_LIB init #*)" ^newline ^
"constdefs initSpecDA :: \"vdmassn\"" ^newline ^
"\"initSpecDA  == \\<lbrace> {}, 0, (emptyfinmap("^cname^"'sort'l \\<mapsto>\\<^sub>f(IlistET 1 0))) \\<ggreater> (IlistET 0 0), 0\\<rbrace>\"" ^newline ^
"" ^newline 

 val s2 = 
"constdefs emptyheap :: \"heap\"" ^newline ^
"\"emptyheap == (| oheap = emptyfinmap, iheap = (% x r . (0::int)) , rheap = (% x r. Nullref), sheap = (% c r . Nullref) |)\"" ^newline ^
"" ^newline ^
"constdefs emptyenv :: \"env\"" ^newline ^
"\"emptyenv == (| ienv = emptyi , renv = emptyr |)\"" ^newline ^
"" ^newline ^
"axioms bonzo: \"  \\<rhd> InvokeStatic cn mn args  : %E. DAss U n G  T m " ^newline ^
"            (newframe_env Nullref args' args E) " ^newline ^
"       ==> \\<rhd> Invokestatic cn mn args  : DAss U n G  T m \"" ^newline ^
"" ^newline ^
"" ^newline ^
"lemma card_emptyheap0: \"card (Dom emptyheap) = 0\"" ^newline ^
"apply (simp add: emptyheap_def)" ^newline ^
"done" ^newline ^
"" ^newline ^
"lemma bonzo_1838: \"oheap h = oheap hh ==> Dom h = Dom hh\"" ^newline ^
"apply (simp add: fmap_dom_def)" ^newline ^
"done" ^newline ^
"" ^newline ^
"lemma empFree: \"freelist emptyheap {} 0\"" ^newline ^
"apply (simp add: freelist_def emptyheap_def)" ^newline ^
"apply (rule FL_NIL)" ^newline ^
"done" ^newline ^
"" ^newline ^
"lemma eq_sym: \"(a::oheap)=b ==> b=a\"" ^newline ^
"apply auto" ^newline ^
"done" ^newline ^
"" ^newline ^
"lemma DA_Weaken_Context: \"\\<lbrakk> \\<rhd> e : \\<lbrace> U, m, C  \\<ggreater>  T , n \\<rbrace> ; \\<forall> x. x:U \\<longrightarrow> GETr D x = GETr C x \\<rbrakk> \\<Longrightarrow> \\<rhd> e : \\<lbrace> U, m, D  \\<ggreater>  T , n \\<rbrace>\"" ^newline ^
"apply (rule vdm_conseq)" ^newline ^
"apply simp" ^newline ^
"apply clarsimp" ^newline ^
"apply (rule DAss_Contexts_same_on_U)" ^newline ^
"apply (rotate_tac -1)" ^newline ^
"apply simp" ^newline ^
"apply clarsimp" ^newline ^
"done"

   val s3 = "\n(* ------------ *)\n(* Main wrapper theorem *)\n"^
            "theorem resourceStatement: \"" ^ 
            " \\<rhd> InvokeStatic " ^ cname ^ " init INPUT : initSpecDA \\<Longrightarrow> \\<rhd> (LET rf "^cname^"'sort'l = InvokeStatic "^cname^" init INPUT IN " ^ wrapperStr ^ " END) : (\\<lambda> E h hh v p . (ALL n m a X .  h = emptyheap & E = emptyenv & n = length INPUT\n -->\n (HSize hh < (int HEAP_BOUND) )))\"\n"

   val s4 = "apply (rule vdm_conseq)" ^newline ^
"apply (rule DA_letr)" ^newline ^
"apply (simp add: initSpecDA_def)" ^newline ^
"apply (erule thin_rl)" ^newline ^
"apply (insert T_sort [of \""^cname^"'sort'l\"])" ^newline ^
"(*<<*)" ^newline ^
"apply (simp add: sMST_def SPEC_def)" ^newline ^
"apply (drule bonzo)" ^newline ^
"apply (rule DA_Weaken_Context)" ^newline ^
"apply simp" ^newline ^
"(* -- only side conditions left *)" ^newline ^
"apply clarsimp" ^newline ^
"apply simp" ^newline ^
"apply simp" ^newline ^
"apply simp" ^newline ^
"apply clarsimp" ^newline ^
"(* -- now unwind DASS, and discharge preconds for emptyheap and emptyenv *)" ^newline ^
"apply (erule thin_rl)   (* don't need spec of init any more *)" ^newline ^
"apply (erule thin_rl)   (* don't need spec of sort any more *)" ^newline ^
"apply (drule DAss_Contexts_same_on_U)" ^newline ^
"apply simp" ^newline ^
"" ^newline ^
"apply (simp add: DAss_def)" ^newline ^
"apply (erule_tac x=\"0\" in allE)" ^newline ^
"apply (erule_tac x=\"{}\" in allE)" ^newline ^
"apply (erule_tac x=\"{}\" in allE)" ^newline ^
"apply clarsimp" ^newline ^
"apply (erule impE)" ^newline ^
"apply (rule_tac x=\"0\" in exI)" ^newline ^
"apply (rule conjI)" ^newline ^
"apply (rule empFree)" ^newline ^
"apply (rule_tac x=\"0\" in exI)" ^newline ^
"apply (rule conjI)" ^newline ^
"apply (insert CS_NIL)" ^newline ^
"defer 1" ^newline ^
"(* fails on non-empty usage set claimed by initSpec *)" ^newline ^
"apply simp" ^newline ^
"apply (rotate_tac -1)" ^newline ^
"apply clarsimp" ^newline ^
"(* apply (erule thin_rl) apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl) *)" ^newline ^
"apply (rotate_tac -1) apply (drule eq_sym) apply (rotate_tac -1)" ^newline ^
"apply (drule bonzo_1838)" ^newline ^
"apply (simp)" ^newline ^
"apply (insert card_emptyheap0)" ^newline ^
"apply (simp)" ^newline ^
"(* last side-cond: prove the bound! *)" ^newline ^
"apply (rule CS_NIL)" ^newline ^
"apply simp" ^newline ^
"apply simp" ^newline ^
"done" 

   val s4 = "end" ^ newline

   val s = s0 ^ newline ^ s1  ^ newline ^ s2 ^ newline ^ s3 ^ newline ^ s4
   val os = TextIO.openOut wrapper_file
   val _ = TextIO.output(os,s)
   val _ = TextIO.closeOut os  
   val _ = printToStdErr ("Wrote "^wrapper_file^"\n")
 in
   () (* YUCK *)
 end


fun makeWrapper1 cname wrapperStr outDir = 
 let
   val wrapper_file = cname ^ "Wrap.thy"

   val s0 = ("theory " ^ cname ^ "Wrap = ResourcePolicy + " ^ cname ^ "_Consumer2:\n");

   val s1 =" (* --------------------------------------------------------------------------- *)" ^newline^
"(* WRAPPER *)" ^newline^
"" ^newline^
"consts init :: mname" ^newline^
"       INPUT :: \"ARG list\"" ^newline^
"       l0 :: rname " ^newline^
"" ^newline^
"translations " ^newline^
"       \"init\" == \"(MN ''init_'') \"" ^newline^
"       \"l0\" == \"(RN ''l0_'') \"" ^newline^
"" ^newline^
"constdefs emptyheap :: \"heap\"" ^newline^
"\"emptyheap == (| oheap = emptyfinmap, iheap = (% x r . (0::int)) , rheap = (% x r. Nullref), sheap = (% c r . Nullref) |)\"" ^newline^
"" ^newline^
"constdefs emptyenv :: \"env\"" ^newline^
"\"emptyenv == (| ienv = emptyi , renv = emptyr |)\"" ^newline^
"" ^newline^
"(*# UNFOLD_LIB init #*)" ^newline^
"constdefs initSpecDA :: \"vdmassn\"" ^newline^
"\"initSpecDA  == \\<lbrace> {}, 0, (emptyfinmap("^cname^"'sort'l \\<mapsto>\\<^sub>f(IlistET 0 0))) \\<ggreater> (IlistET 0 0), 0\\<rbrace>\"" ^newline^
"" ^newline^
"(*<*)" ^newline^
"(* U \\<subseteq> set args ; *)" ^newline^
"consts \"set_of_rnames\" :: \"ARGTYPE \\<Rightarrow> rname set\"" ^newline^
"primrec" ^newline^
" \"set_of_rnames [] = {}\"" ^newline^
" \"set_of_rnames (x#xs) = (case x of" ^newline^
"                            INarg iname => set_of_rnames xs" ^newline^
"                          | RNarg rname => insert rname (set_of_rnames xs)" ^newline^
"                          | VALarg val => set_of_rnames xs)\"" ^newline^
"" ^newline^
"lemma CS_Weaken_Env_Aux : \"(E', h, U, G, R, P) \\<in> CS \\<Longrightarrow>" ^newline^
" (\\<forall> E . (\\<forall> r . r : U \\<longrightarrow> E\\<lfloor>r\\<rfloor>=E'\\<lfloor>r\\<rfloor>) \\<longrightarrow>  (E, h, U, G, R, P) \\<in> CS)\"" ^newline^
"apply (erule CS.induct)" ^newline^
"apply clarsimp" ^newline^
"apply (rule CS_NIL)" ^newline^
"apply simp apply simp" ^newline^
"apply clarsimp" ^newline^
"apply (rule CS_CONS)" ^newline^
"prefer 5" ^newline^
"apply simp" ^newline^
"prefer 5" ^newline^
"apply simp" ^newline^
"prefer 4" ^newline^
"apply simp" ^newline^
"prefer 2" ^newline^
"apply simp" ^newline^
"apply simp?" ^newline^
"apply (erule_tac x=\"Ea\" in allE)" ^newline^
"apply (drule mp)" ^newline^
"apply simp" ^newline^
"apply (erule CS.cases)" ^newline^
"apply simp" ^newline^
"apply clarsimp" ^newline^
"prefer 4" ^newline^
"apply (erule_tac x=\"Ea\" in allE)" ^newline^
"apply (drule mp)" ^newline^
"apply simp" ^newline^
"apply simp" ^newline^
"apply simp" ^newline^
"apply simp" ^newline^
"apply simp" ^newline^
"done" ^newline^
"" ^newline^
"lemma CS_Weaken_Env : \"\\<lbrakk> (E', h, U, G, R, P) \\<in> CS ; (\\<forall> r . r : U \\<longrightarrow> E\\<lfloor>r\\<rfloor>=E'\\<lfloor>r\\<rfloor>) \\<rbrakk> \\<Longrightarrow> (E, h, U, G, R, P) \\<in> CS\"" ^newline^
"apply (frule CS_Weaken_Env_Aux)" ^newline^
"apply (erule_tac x=\"E\" in allE)" ^newline^
"apply (drule mp)" ^newline^
"apply clarsimp" ^newline^
"apply simp" ^newline^
"done" ^newline^
"" ^newline^
"lemma DAss_Weaken_EnvU: \"\\<lbrakk> \\<forall> r . r : U \\<longrightarrow> E\\<lfloor>r\\<rfloor>=E'\\<lfloor>r\\<rfloor> ; " ^newline^
"                DAss U n G T m E h hh v p \\<rbrakk>" ^newline^
"      \\<Longrightarrow> DAss U n G  T m E' h hh v p\"" ^newline^
"apply (simp add:  DAss_def)" ^newline^
"apply clarsimp" ^newline^
"apply (erule_tac x=\"q\" in allE)" ^newline^
"apply (erule_tac x=\"F\" in allE)" ^newline^
"apply (erule_tac x=\"R\" in allE)" ^newline^
"apply (erule impE) " ^newline^
"apply (rotate_tac -1)" ^newline^
"apply (rule_tac x=\"N\" in exI)" ^newline^
"apply simp" ^newline^
"apply (rule_tac x=\"P\" in exI)" ^newline^
"apply (rule conjI)" ^newline^
"apply (rule CS_Weaken_Env)" ^newline^
"apply (rotate_tac -2)" ^newline^
"apply simp" ^newline^
"apply clarsimp" ^newline^
"apply simp" ^newline^
"apply simp" ^newline^
"done" ^newline^
"" ^newline^
"" ^newline^
"lemma card_emptyheap0: \"card (Dom emptyheap) = 0\"" ^newline^
"apply (simp add: emptyheap_def)" ^newline^
"done" ^newline^
"" ^newline^
"lemma bonzo_1838: \"oheap h = oheap hh ==> Dom h = Dom hh\"" ^newline^
"apply (simp add: fmap_dom_def)" ^newline^
"done" ^newline^
"" ^newline^
"lemma empFree: \"freelist emptyheap {} 0\"" ^newline^
"apply (simp add: freelist_def emptyheap_def)" ^newline^
"apply (rule FL_NIL)" ^newline^
"done" ^newline^
"" ^newline^
"lemma eq_sym: \"(a::oheap)=b ==> b=a\"" ^newline^
"apply auto" ^newline^
"done" ^newline^
"" ^newline^
"(* some finmap lemmas needed below ------------------------------ *)" ^newline^
"" ^newline^
"axioms extFi:\"\\<forall> x . fmap_lookup f x = fmap_lookup f' x ==> f = f'\"" ^newline^
"" ^newline^
"" ^newline^
"lemma lookupUpdateOtherfinmap[simp]: \"a \\<noteq> c \\<Longrightarrow> fmap_lookup (f(a \\<mapsto>\\<^sub>f b)) c= fmap_lookup f c\"" ^newline^
"apply (induct f)" ^newline^
"apply (simp add: fmap_upd_def fmap_lookup_def)" ^newline^
"apply clarsimp" ^newline^
"done" ^newline^
"" ^newline^
"lemma finmap_upd_same0: \"\\<forall> y . fmap_lookup (C(x\\<mapsto>\\<^sub>fz)(x\\<mapsto>\\<^sub>fz)) y = fmap_lookup (C(x\\<mapsto>\\<^sub>fz)) y\"" ^newline^
"apply clarsimp" ^newline^
"(* apply (simp add: fmap_upd_def fmap_lookup_def) *)" ^newline^
"apply (case_tac \"x=y\")" ^newline^
" apply simp" ^newline^
" apply (simp add: lookupUpdateOtherfinmap)" ^newline^
"done" ^newline^
"" ^newline^
"lemma finmap_upd_same[rule_format]: \"C(x\\<mapsto>\\<^sub>fz)(x\\<mapsto>\\<^sub>fz) = C(x\\<mapsto>\\<^sub>fz)\"" ^newline^
"apply (rule extFi)" ^newline^
"apply (insert finmap_upd_same0 [of \"C\" \"x\" \"z\"])" ^newline^
"apply clarsimp" ^newline^
"done" ^newline^
"" ^newline^
"lemma DA_Weaken_Context: \"\\<lbrakk> \\<rhd> e : \\<lbrace> U, m, C  \\<ggreater>  T , n \\<rbrace> ; \\<forall> x. x:U \\<longrightarrow> GETr D x = GETr C x \\<rbrakk> \\<Longrightarrow> \\<rhd> e : \\<lbrace> U, m, D  \\<ggreater>  T , n \\<rbrace>\"" ^newline^
"apply (rule vdm_conseq)" ^newline^
"apply simp" ^newline^
"apply clarsimp" ^newline^
"apply (rule DAss_Contexts_same_on_U)" ^newline^
"apply (rotate_tac -1)" ^newline^
"apply simp" ^newline^
"apply clarsimp" ^newline^
"done" ^newline^
"(*>*)" ^newline^
"(* ------------ *)" ^newline^
"(* Main wrapper theorem *)" ^newline

 val s2 = "theorem resourceStatement: \" \\<rhd> InvokeStatic "^cname^" init INPUT : initSpecDA \\<Longrightarrow> \\<rhd> (LET rf "^cname^"'sort'l = InvokeStatic "^cname^" init INPUT IN "^wrapperStr^" "^newline^
"  END) : (\\<lambda> E h hh v p . (ALL n .  h = emptyheap & E = emptyenv & n = length INPUT" ^newline^
" -->" ^newline^
" (HSize hh < (int HEAP_BOUND) )))\"" ^newline^
"apply (rule vdm_conseq)" ^newline^
"apply (rule DA_letr)" ^newline^
"apply (simp add: initSpecDA_def)" ^newline^
"apply (erule thin_rl)" ^newline^
"apply (insert T_sort [of \""^cname^"'sort'l\"])" ^newline^
"(*<<*)" ^newline^
"apply (simp add: sMST_def SPEC_def)" ^newline^
"apply (rule vdm_conseq)" ^newline^
"apply simp" ^newline^
"apply clarsimp" ^newline^
"apply (rule DAss_Weaken_EnvU)" ^newline^
"apply clarsimp" ^newline^
"apply (subgoal_tac \"renv (newframe_env Nullref (fst (methtable "^cname^" "^cname^"'sort)) [RNarg "^cname^"'sort'l] E) r = renv E r\")" ^newline^
" apply simp" ^newline^
"prefer 2" ^newline^
"apply (subgoal_tac \"emptyfinmap("^cname^"'sort'l\\<mapsto>\\<^sub>fIlistET 0 0)" ^newline^
"           ("^cname^"'sort'l\\<mapsto>\\<^sub>fIlistET 0 0) = emptyfinmap("^cname^"'sort'l\\<mapsto>\\<^sub>fIlistET 0 0)\")" ^newline^
" apply simp" ^newline^
"apply (rule DAss_Weaken_EnvU)" ^newline^
"defer 1" ^newline^
"apply simp" ^newline^
"defer 1" ^newline^
"defer 1" ^newline^
"(* apply (simp add: newframe_env_def evalARGS_def assign_def) *)" ^newline^
"apply simp+" ^newline^
"apply clarsimp" ^newline^
"" ^newline^
"apply (simp add: DAss_def)" ^newline^
"apply (erule_tac x=\"0\" in allE)" ^newline^
"apply (erule_tac x=\"{}\" in allE)" ^newline^
"apply (erule_tac x=\"{}\" in allE)" ^newline^
"apply clarsimp" ^newline^
"apply (erule impE)" ^newline^
"apply (rule_tac x=\"0\" in exI)" ^newline^
"apply (rule conjI)" ^newline^
"apply (rule empFree)" ^newline^
"apply (rule_tac x=\"0\" in exI)" ^newline^
"apply (rule conjI)" ^newline^
"apply (insert CS_NIL)" ^newline^
"defer 1" ^newline^
"(* fails on non-empty usage set claimed by initSpec *)" ^newline^
"apply simp" ^newline^
"apply (rotate_tac -1)" ^newline^
"apply clarsimp" ^newline^
"(* apply (erule thin_rl) apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl) *)" ^newline^
"apply (rotate_tac -1) apply (drule eq_sym) apply (rotate_tac -1)" ^newline^
"apply (drule bonzo_1838)" ^newline^
"apply (simp)" ^newline^
"apply (insert card_emptyheap0)" ^newline^
"apply (simp)" ^newline^
"(* 4 unproven subgoals *)" ^newline^
"prefer 4" ^newline^
"apply (rule CS_NIL)apply simp apply simp" ^newline^
"(* remaining 3 trivial *)" ^newline^
"apply clarsimp" ^newline^
"apply (simp add: newframe_env_def evalARGS_def meth_defs)" ^newline^
"prefer 2" ^newline^
"apply (simp add: newframe_env_def evalARGS_def meth_defs)" ^newline^
"apply (simp add: finmap_upd_same)" ^newline^
"done"  ^newline ^newline ^"end"^newline
   


   val s = s0 ^ newline ^ s1 ^ newline ^ s2
   val os = TextIO.openOut wrapper_file
   val _ = TextIO.output(os,s)
   val _ = TextIO.closeOut os  
   val _ = printToStdErr ("Wrote "^wrapper_file^"\n")
 in
   () (* YUCK *)
 end

fun makeWrapper4 cname wrapperStr outDir = 
 let
   val wrapper_file = cname ^ "Wrap.thy"
   (* extract method from string: must be 3rd word; beware of leading spaces! *)
   val ps = GrailUtils.splitBy #" " wrapperStr
   val mn0 = List.nth (ps, 2) (* name of method; with trailing _ *)
   val mname = String.substring (mn0, 0, (String.size(mn0)-1))

   val pn0 = List.nth (ps, 4) (* name of 1st par; with trailing , or ] *)
   val pname = String.substring (pn0, 0, (String.size(pn0)-2))

   val s0 = ("theory " ^ cname ^ "Wrap = ResourcePolicy + " ^ cname ^ "_Consumer2:\n");

   val s1 = "(* --------------------------------------------------------------------------- *)" ^newline ^
"(* WRAPPER *)" ^ newline ^
"" ^ newline ^
"consts init :: mname" ^ newline ^
"       INPUT :: \"ARG list\"" ^ newline ^
"       l0 :: rname " ^ newline ^
"       l1 :: rname " ^ newline ^
"" ^ newline ^
"translations " ^ newline ^
"       \"init\" == \"(MN ''init_'') \"" ^ newline ^
"       \"l0\" == \"(RN ''l0_'') \"" ^ newline ^
"       \"l1\" == \"(RN ''l1_'') \"" ^ newline ^
"" ^ newline ^
"(*# UNFOLD_LIB init #*)" ^ newline ^
"constdefs initSpecDA :: \"vdmassn\"" ^ newline ^
"\"initSpecDA  == \\<lbrace> {}, 0, [(l1 , (ListET 0 0))] \\<ggreater> (ListET 0 0), 0\\<rbrace>\"" ^ newline ^
"" ^ newline 

 val s2 = 
"constdefs emptyheap :: \"heap\"" ^ newline ^
"\"emptyheap == (| oheap = emptyfinmap, iheap = (% x r . (0::int)) , rheap = (% x r. Nullref), sheap = (% c r . Nullref) |)\"" ^ newline ^
"" ^ newline ^
"constdefs emptyenv :: \"env\"" ^ newline ^
"\"emptyenv == (| ienv = emptyi , renv = emptyr |)\"" ^ newline ^
"" ^ newline ^
"(*<*)" ^ newline ^
"(* U \\<subseteq> set args ; *)" ^ newline ^
"consts \"set_of_rnames\" :: \"ARGTYPE \\<Rightarrow> rname set\"" ^ newline ^
"primrec" ^ newline ^
" \"set_of_rnames [] = {}\"" ^ newline ^
" \"set_of_rnames (x#xs) = (case x of" ^ newline ^
"                            INarg iname => set_of_rnames xs" ^ newline ^
"                          | RNarg rname => insert rname (set_of_rnames xs)" ^ newline ^
"                          | VALarg val => set_of_rnames xs)\"" ^ newline ^
"" ^ newline ^
"lemma CS_Weaken_Env_Aux : \"(E', h, U, G, R, P) \\<in> CS \\<Longrightarrow>" ^ newline ^
" (\\<forall> E . (\\<forall> r . r : U \\<longrightarrow> E\\<lfloor>r\\<rfloor>=E'\\<lfloor>r\\<rfloor>) \\<longrightarrow>  (E, h, U, G, R, P) \\<in> CS)\"" ^ newline ^
"apply (erule CS.induct)" ^ newline ^
"apply clarsimp" ^ newline ^
"apply (rule CS_NIL)" ^ newline ^
"apply simp apply simp" ^ newline ^
"apply clarsimp" ^ newline ^
"apply (rule CS_CONS)" ^ newline ^
"prefer 5" ^ newline ^
"apply simp" ^ newline ^
"prefer 5" ^ newline ^
"apply simp" ^ newline ^
"prefer 4" ^ newline ^
"apply simp" ^ newline ^
"prefer 2" ^ newline ^
"prefer 3" ^ newline ^
"apply (erule_tac x=\"Ea\" in allE)" ^ newline ^
"apply simp" ^ newline ^
"apply simp?" ^ newline ^
"apply assumption" ^ newline ^
"done" ^ newline ^
"" ^ newline ^
"lemma CS_Weaken_Env : \"\\<lbrakk> (E', h, U, G, R, P) \\<in> CS ; (\\<forall> r . r : U \\<longrightarrow> E\\<lfloor>r\\<rfloor>=E'\\<lfloor>r\\<rfloor>) \\<rbrakk> \\<Longrightarrow> (E, h, U, G, R, P) \\<in> CS\"" ^ newline ^
"apply (frule CS_Weaken_Env_Aux)" ^ newline ^
"apply (erule_tac x=\"E\" in allE)" ^ newline ^
"apply (drule mp)" ^ newline ^
"apply clarsimp" ^ newline ^
"apply simp" ^ newline ^
"done" ^ newline ^
"" ^ newline ^
"lemma DAss_Weaken_EnvU: \"\\<lbrakk> \\<forall> r . r : U \\<longrightarrow> E\\<lfloor>r\\<rfloor>=E'\\<lfloor>r\\<rfloor> ; " ^ newline ^
"                DAss U n G T m E h hh v p \\<rbrakk>" ^ newline ^
"      \\<Longrightarrow> DAss U n G  T m E' h hh v p\"" ^ newline ^
"apply (simp add:  DAss_def)" ^ newline ^
"apply clarsimp" ^ newline ^
"apply (erule_tac x=\"q\" in allE)" ^ newline ^
"apply (erule_tac x=\"F\" in allE)" ^ newline ^
"apply (erule_tac x=\"R\" in allE)" ^ newline ^
"apply (erule impE) " ^ newline ^
"apply (rotate_tac -1)" ^ newline ^
"apply (rule_tac x=\"N\" in exI)" ^ newline ^
"apply simp" ^ newline ^
"apply (rule_tac x=\"P\" in exI)" ^ newline ^
"apply (rule conjI)" ^ newline ^
"apply (rule CS_Weaken_Env)" ^ newline ^
"apply (rotate_tac -2)" ^ newline ^
"apply simp" ^ newline ^
"apply clarsimp" ^ newline ^
"apply simp" ^ newline ^
"apply simp" ^ newline ^
"done" ^ newline ^
"" ^ newline ^
"" ^ newline ^
"lemma card_emptyheap0: \"card (Dom emptyheap) = 0\"" ^ newline ^
"apply (simp add: emptyheap_def)" ^ newline ^
"done" ^ newline ^
"" ^ newline ^
"lemma bonzo_1838: \"oheap h = oheap hh ==> Dom h = Dom hh\"" ^ newline ^
"apply (simp add: fmap_dom_def)" ^ newline ^
"done" ^ newline ^
"" ^ newline ^
"lemma empFree: \"freelist emptyheap {} 0\"" ^ newline ^
"apply (simp add: freelist_def emptyheap_def)" ^ newline ^
"apply (rule FL_NIL)" ^ newline ^
"done" ^ newline ^
"" ^ newline ^
"lemma eq_sym: \"(a::oheap)=b ==> b=a\"" ^ newline ^
"apply auto" ^ newline ^
"done" ^ newline ^
"" ^ newline ^
"lemma DA_Weaken_Context: \"\\<lbrakk> \\<rhd> e : \\<lbrace> U, m, C  \\<ggreater>  T , n \\<rbrace> ; \\<forall> x. x:U \\<longrightarrow> GETr D x = GETr C x \\<rbrakk> \\<Longrightarrow> \\<rhd> e : \\<lbrace> U, m, D  \\<ggreater>  T , n \\<rbrace>\"" ^ newline ^
"apply (rule vdm_conseq)" ^ newline ^
"apply simp" ^ newline ^
"apply clarsimp" ^ newline ^
"apply (rule DAss_Contexts_same_on_U)" ^ newline ^
"apply (rotate_tac -1)" ^ newline ^
"apply simp" ^ newline ^
"apply clarsimp" ^ newline ^
"done" ^ newline ^
"(*>*)" ^ newline ^
"" ^ newline

 val s4 = "" ^ newline ^
"apply (rule vdm_conseq)" ^ newline ^
"apply (rule vdm_letr)" ^ newline ^
"apply (simp add: initSpecDA_def)" ^ newline ^
"apply (simp add: initSpecDA_def)" ^ newline ^
"apply (erule thin_rl)" ^ newline ^
"apply (insert T_" ^mname^"  [of \""^pname^"\"])" ^ newline ^
"apply (simp add: sMST_def SPEC_def)" ^ newline ^
"apply clarsimp" ^ newline ^
"apply (erule_tac x=\"?EE\" in allE)" ^ newline ^
"apply (drule mp)" ^ newline ^
"apply (simp add: meth_defs)" ^ newline ^
"apply (rule FRAME_RN) apply (rule FRAME_NIL) apply simp " ^ newline ^
"apply (simp add: DAss_def)" ^ newline ^
"apply (erule_tac x=\"0\" in allE) apply (rotate_tac -1)" ^ newline ^
"apply (erule_tac x=\"{}\" in allE) apply (rotate_tac -1)" ^ newline ^
"apply (erule_tac x=\"{}\" in allE) apply (rotate_tac -1)" ^ newline ^
"apply clarsimp" ^ newline ^
"apply (erule impE)" ^ newline ^
"apply (rule_tac x=\"0\" in exI)" ^ newline ^
"apply (rule conjI)" ^ newline ^
"apply (rule empFree)" ^ newline ^
"apply (rule_tac x=\"0\" in exI)" ^ newline ^
"apply (rule conjI)" ^ newline ^
"apply (insert CS_NIL)" ^ newline ^
"defer 1" ^ newline ^
"apply simp" ^ newline ^
"apply clarsimp" ^ newline ^
"apply (subgoal_tac \"M=0\")" ^ newline ^
"apply clarsimp" ^ newline ^
"apply (erule_tac x=\"0\" in allE) apply (rotate_tac -1)" ^ newline ^
"apply (erule_tac x=\"{}\" in allE) apply (rotate_tac -1)" ^ newline ^
"apply (erule_tac x=\"{}\" in allE) apply (rotate_tac -1)" ^ newline ^
"apply clarsimp" ^ newline ^
"apply (erule impE)" ^ newline ^
"apply (rule_tac x=\"0\" in exI)" ^ newline ^
"apply (rule conjI)" ^ newline ^
"apply simp" ^ newline ^
"apply (rule_tac x=\"0\" in exI)" ^ newline ^
"apply (rule conjI)" ^ newline ^
"apply (rule CS_CONS)" ^ newline ^
"apply simp" ^ newline ^
"apply simp" ^ newline ^
"apply simp" ^ newline ^
"apply (rule CS_NIL)" ^ newline ^
"apply simp" ^ newline ^
"apply simp" ^ newline ^
"apply simp" ^ newline ^
"apply simp" ^ newline ^
"apply simp" ^ newline ^
"apply simp" ^ newline ^
"apply clarsimp" ^ newline ^
"apply (rotate_tac -6) apply (drule eq_sym) apply (rotate_tac -1)" ^ newline ^
"apply (drule bonzo_1838)" ^ newline ^
"apply simp" ^ newline ^
"apply (insert card_emptyheap0)" ^ newline ^
"apply simp" ^ newline ^
"apply (simp add: freelist_def)" ^ newline ^
"apply (rule FL.cases)" ^ newline ^
"apply simp_all" ^ newline ^
"apply simp" ^ newline ^
"apply simp" ^ newline ^
"done" ^ newline

 (* NB: l1 must match with arg in wrapperStr *)
 val s3 = 
"(* ------------ *)" ^ newline ^
"(* Main wrapper theorem *)" ^ newline ^
"theorem resourceStatement: \" \\<rhd> InvokeStatic "^cname^" init INPUT : initSpecDA \\<Longrightarrow> \\<rhd> (LET rf l1 = InvokeStatic "^cname^" init INPUT IN "^wrapperStr^" "^newline^
"  END) : (\\<lambda> E h hh v p . (ALL n .  h = emptyheap & E = emptyenv & n = length INPUT" ^newline^
" -->" ^newline^
" (HSize hh < (int HEAP_BOUND) )))\"" ^newline

   val s9 = "end" ^ newline

   (* s2 not needed with heap MRG (but needed with heap NULL_rules) *)
   val s = s0 ^ newline ^ s1  ^ newline ^ (*s2 ^ newline ^*) s3 ^ newline ^ s4 ^ newline ^ s9
   val os = TextIO.openOut wrapper_file
   val _ = TextIO.output(os,s)
   val _ = TextIO.closeOut os  
   val _ = printToStdErr ("Wrote "^wrapper_file^"\n")
 in
   () (* YUCK *)
 end

fun makeCert cname  thySyntax tFlavour mdecls outDir = 
  let
    val _       = makeCert2 cname thySyntax tFlavour mdecls outDir
    val tac_str = case (thySyntax) of
                6 => makeCert4 cname mdecls outDir                (* post-demo version *)
              | _ => makeCert3 cname mdecls outDir
  in
     () (* YUCK *)
  end

fun makeWrapper cname thySyntax tFlavour wrapperStr outDir = 
  case (tFlavour) of
                5 => makeWrapper1 cname wrapperStr outDir      (* pre-demo version *)
              | 4 => makeWrapper4 cname wrapperStr outDir      (* post-demo version *)
              | _ => makeWrapper1 cname wrapperStr outDir      (* default: review-y3 *)


fun mk_tactics cname  thySyntax tFlavour outDir =
  case (tFlavour) of
                5 => mk_tactics0 cname outDir           (* pre-demo version *)
              | 4 => mk_tactics4 cname outDir           (* post-demo version *)
              | 6 => mk_tactics6 cname outDir           (* post-demo version; verbose *)
              | 7 => mk_tactics0 cname outDir           (* HWL hacked here *)
              | _ => mk_tactics0 cname outDir           (* default *)


