(* $Id: Stardate.sml,v 1.2 2004/12/09 00:15:53 a1hloidl Exp $
    Compute stardate based on current time.
    Based on a C version
 *  by Andrew Main, 1994-11-28, stardate [-31]4836.09
 *  <zefram@dcs.warwick.ac.uk> <csuth@csv.warwick.ac.uk>
*)

fun mymod x y  = x - y * real(floor(x/y))

fun stardate () = let 
                     val r0 =  Time.toReal (Time.now ())
                     val fract = ((floor (mymod r0 17280.0)) * 3125) div 54
                     val ints =  (floor (r0/17280.0)) + 9350			     
                     val issue = (ints div 10000) - 36
                     val intss  =  (ints mod 10000)
                  in
                   ("Stardate: [" ^ (Int.toString(issue)) ^ "]" ^ Int.toString(intss) ^ "." ^ (Int.toString(fract div 10000)) ^ "\n")
                  end


