local
in
datatype token =
    ADD
  | ALIAS
  | AND
  | ARROW
  | BAR
  | BOOLEAN
  | CASE
  | CHECKCAST
  | CLASS
  | COLON
  | COMMA
  | DIV
  | DOTDOT
  | ELSE
  | EMPTY
  | END
  | EOF
  | EQUALS
  | EXTENDS
  | FIELD
  | FIELDS
  | FINAL
  | FLOAT
  | FTOI
  | FUN
  | GET
  | GETFIELD
  | GETSTATIC
  | GREATER
  | GREATEREQ
  | IAND
  | IF
  | IMPLEMENTS
  | IN
  | INSTANCEOF
  | INT
  | INVOKEINTERFACE
  | INVOKESPECIAL
  | INVOKESTATIC
  | INVOKEVIRTUAL
  | IOR
  | ISHL
  | ISHR
  | ITOF
  | IUSHR
  | IXOR
  | LAYOUT
  | LBRACE
  | LENGTH
  | LESS
  | LESSEQ
  | LET
  | LPAREN
  | LSQ
  | MAKE
  | METHOD
  | MOD
  | MUL
  | NEW
  | NOTEQUAL
  | NULL
  | OF
  | PRIVATE
  | PROTECTED
  | PUBLIC
  | PUTFIELD
  | PUTSTATIC
  | RBRACE
  | REF
  | RPAREN
  | RSQ
  | SET
  | STATIC
  | STRING
  | SUB
  | TAG
  | THEN
  | TYPE
  | VAL
  | VOID
  | floatval of real
  | intval of int
  | quoteval of string
  | stringval of string
end;

open Obj Parsing;
prim_val vector_ : int -> 'a -> 'a Vector.vector = 2 "make_vect";
prim_val update_ : 'a Vector.vector -> int -> 'a -> unit = 3 "set_vect_item";

 
  open GrailAbsyn Classdecl

  fun stripquotes s = String.substring(s, 1, String.size s - 2)

  val thisClass = ref "";		
  fun expandSimpleName s =
	if Char.contains s #"." then s else (!thisClass)^s 

  val aliasTable: (string * string) list ref  = ref [];
  fun makeAlias (s,t) = aliasTable := (s, t) :: (!aliasTable)
  fun expand s 
	= let fun expand' s [] = s
	    | expand' s ((p,q)::t) = 
		  if s=p then q
		  else if String.isPrefix (p^".") s 
			then q ^ (String.extract(s,String.size p, NONE))
		  else expand' s t
	in expand' s (!aliasTable) end


  exception NoSuchAlias of string;
  val fieldAliasTable: (string * FieldDesc) list ref  = ref [];
  fun makeFieldAlias (s,f) = fieldAliasTable := (s, f) :: (!fieldAliasTable)
  fun expandField s 
	= let fun expand' s [] = raise (NoSuchAlias s)
	    | expand' s ((p,q)::t) = 
		  if s=p then q
		  else expand' s t
	in expand' s (!fieldAliasTable) end
(* Line 36, file Parser.sml *)
val yytransl = #[
  257 (* ADD *),
  258 (* ALIAS *),
  259 (* AND *),
  260 (* ARROW *),
  261 (* BAR *),
  262 (* BOOLEAN *),
  263 (* CASE *),
  264 (* CHECKCAST *),
  265 (* CLASS *),
  266 (* COLON *),
  267 (* COMMA *),
  268 (* DIV *),
  269 (* DOTDOT *),
  270 (* ELSE *),
  271 (* EMPTY *),
  272 (* END *),
  273 (* EOF *),
  274 (* EQUALS *),
  275 (* EXTENDS *),
  276 (* FIELD *),
  277 (* FIELDS *),
  278 (* FINAL *),
  279 (* FLOAT *),
  280 (* FTOI *),
  281 (* FUN *),
  282 (* GET *),
  283 (* GETFIELD *),
  284 (* GETSTATIC *),
  285 (* GREATER *),
  286 (* GREATEREQ *),
  287 (* IAND *),
  288 (* IF *),
  289 (* IMPLEMENTS *),
  290 (* IN *),
  291 (* INSTANCEOF *),
  292 (* INT *),
  293 (* INVOKEINTERFACE *),
  294 (* INVOKESPECIAL *),
  295 (* INVOKESTATIC *),
  296 (* INVOKEVIRTUAL *),
  297 (* IOR *),
  298 (* ISHL *),
  299 (* ISHR *),
  300 (* ITOF *),
  301 (* IUSHR *),
  302 (* IXOR *),
  303 (* LAYOUT *),
  304 (* LBRACE *),
  305 (* LENGTH *),
  306 (* LESS *),
  307 (* LESSEQ *),
  308 (* LET *),
  309 (* LPAREN *),
  310 (* LSQ *),
  311 (* MAKE *),
  312 (* METHOD *),
  313 (* MOD *),
  314 (* MUL *),
  315 (* NEW *),
  316 (* NOTEQUAL *),
  317 (* NULL *),
  318 (* OF *),
  319 (* PRIVATE *),
  320 (* PROTECTED *),
  321 (* PUBLIC *),
  322 (* PUTFIELD *),
  323 (* PUTSTATIC *),
  324 (* RBRACE *),
  325 (* REF *),
  326 (* RPAREN *),
  327 (* RSQ *),
  328 (* SET *),
  329 (* STATIC *),
  330 (* STRING *),
  331 (* SUB *),
  332 (* TAG *),
  333 (* THEN *),
  334 (* TYPE *),
  335 (* VAL *),
  336 (* VOID *),
  337 (* floatval *),
  338 (* intval *),
  339 (* quoteval *),
  340 (* stringval *),
    0];

val yylhs = "\255\255\
\\001\000\003\000\003\000\002\000\002\000\004\000\057\000\057\000\
\\058\000\058\000\059\000\059\000\008\000\008\000\009\000\005\000\
\\005\000\006\000\007\000\014\000\014\000\013\000\013\000\015\000\
\\015\000\010\000\010\000\011\000\012\000\012\000\017\000\017\000\
\\017\000\038\000\038\000\037\000\016\000\016\000\016\000\018\000\
\\018\000\018\000\018\000\018\000\018\000\019\000\019\000\019\000\
\\019\000\019\000\019\000\019\000\019\000\019\000\019\000\019\000\
\\019\000\019\000\019\000\019\000\019\000\019\000\019\000\019\000\
\\019\000\021\000\020\000\023\000\022\000\022\000\039\000\039\000\
\\039\000\039\000\039\000\039\000\040\000\040\000\040\000\040\000\
\\040\000\040\000\041\000\041\000\041\000\041\000\041\000\041\000\
\\024\000\024\000\024\000\024\000\024\000\026\000\026\000\026\000\
\\026\000\026\000\026\000\025\000\025\000\025\000\025\000\025\000\
\\025\000\035\000\035\000\031\000\031\000\032\000\032\000\027\000\
\\027\000\028\000\028\000\033\000\033\000\034\000\034\000\030\000\
\\030\000\029\000\029\000\051\000\053\000\052\000\054\000\055\000\
\\056\000\036\000\042\000\042\000\043\000\044\000\044\000\045\000\
\\046\000\046\000\047\000\048\000\048\000\048\000\049\000\050\000\
\\050\000\050\000\050\000\050\000\050\000\000\000";

val yylen = "\002\000\
\\003\000\002\000\000\000\004\000\004\000\010\000\002\000\000\000\
\\002\000\000\000\001\000\002\000\002\000\000\000\004\000\002\000\
\\000\000\009\000\006\000\001\000\000\000\001\000\002\000\004\000\
\\004\000\002\000\000\000\007\000\001\000\005\000\001\000\008\000\
\\010\000\003\000\001\000\006\000\001\000\001\000\004\000\001\000\
\\001\000\001\000\001\000\001\000\001\000\001\000\003\000\005\000\
\\003\000\003\000\005\000\006\000\006\000\006\000\003\000\004\000\
\\002\000\003\000\003\000\003\000\004\000\002\000\003\000\002\000\
\\002\000\006\000\007\000\004\000\004\000\001\000\002\000\002\000\
\\002\000\002\000\002\000\000\000\002\000\002\000\002\000\002\000\
\\002\000\000\000\002\000\002\000\002\000\002\000\002\000\000\000\
\\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\\001\000\004\000\007\000\001\000\001\000\001\000\001\000\001\000\
\\003\000\001\000\001\000\001\000\000\000\002\000\004\000\001\000\
\\000\000\001\000\003\000\001\000\000\000\001\000\003\000\001\000\
\\000\000\001\000\003\000\001\000\001\000\001\000\001\000\001\000\
\\001\000\002\000\001\000\000\000\004\000\002\000\000\000\003\000\
\\001\000\002\000\011\000\001\000\003\000\000\000\005\000\001\000\
\\001\000\001\000\001\000\001\000\003\000\002\000";

val yydefred = "\000\000\
\\000\000\000\000\000\000\150\000\000\000\000\000\127\000\000\000\
\\002\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\075\000\073\000\072\000\071\000\074\000\001\000\000\000\
\\000\000\128\000\005\000\004\000\124\000\000\000\101\000\102\000\
\\100\000\103\000\000\000\104\000\000\000\000\000\000\000\000\000\
\\007\000\000\000\000\000\105\000\068\000\000\000\009\000\000\000\
\\012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\013\000\081\000\079\000\
\\078\000\077\000\080\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\016\000\126\000\015\000\087\000\085\000\
\\084\000\083\000\086\000\106\000\000\000\000\000\000\000\006\000\
\\131\000\125\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\108\000\000\000\133\000\134\000\129\000\000\000\
\\000\000\136\000\000\000\000\000\000\000\000\000\138\000\000\000\
\\111\000\000\000\018\000\000\000\000\000\020\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\023\000\
\\000\000\130\000\000\000\000\000\000\000\000\000\026\000\000\000\
\\089\000\000\000\092\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\093\000\090\000\000\000\000\000\000\000\000\000\000\000\091\000\
\\096\000\095\000\097\000\025\000\000\000\046\000\094\000\024\000\
\\000\000\000\000\000\000\000\000\031\000\000\000\037\000\038\000\
\\000\000\000\000\000\000\000\000\065\000\000\000\000\000\000\000\
\\070\000\057\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\064\000\062\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\019\000\000\000\000\000\
\\049\000\000\000\060\000\055\000\000\000\050\000\000\000\000\000\
\\000\000\000\000\000\000\059\000\000\000\000\000\000\000\000\000\
\\058\000\000\000\047\000\000\000\000\000\040\000\044\000\045\000\
\\042\000\043\000\041\000\000\000\000\000\116\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\112\000\000\000\
\\000\000\000\000\000\000\056\000\061\000\000\000\000\000\000\000\
\\039\000\000\000\000\000\000\000\000\000\069\000\000\000\000\000\
\\000\000\000\000\051\000\000\000\000\000\120\000\000\000\048\000\
\\000\000\000\000\028\000\029\000\000\000\000\000\119\000\000\000\
\\139\000\000\000\054\000\053\000\000\000\115\000\052\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\141\000\000\000\
\\123\000\066\000\099\000\000\000\000\000\000\000\145\000\146\000\
\\144\000\147\000\000\000\148\000\067\000\000\000\000\000\032\000\
\\143\000\000\000\030\000\000\000\149\000\000\000\000\000\033\000\
\\000\000\000\000\000\000\034\000\000\000\000\000\036\000";

val yydgoto = "\002\000\
\\004\000\005\000\006\000\015\000\060\000\061\000\115\000\051\000\
\\052\000\126\000\127\000\019\001\118\000\119\000\120\000\173\000\
\\174\000\236\000\175\000\191\000\197\000\186\000\027\000\165\000\
\\097\000\166\000\246\000\247\000\014\001\015\001\098\000\099\000\
\\237\000\238\000\086\000\176\000\063\001\064\001\016\000\058\000\
\\074\000\088\000\089\000\095\000\096\000\106\000\107\000\004\001\
\\005\001\051\001\046\000\078\000\091\000\177\000\036\000\167\000\
\\038\000\043\000\047\000";

val yysindex = "\013\000\
\\041\255\000\000\239\254\000\000\041\255\085\255\000\000\054\255\
\\000\000\085\255\085\255\085\255\085\255\085\255\057\255\077\255\
\\214\254\000\000\000\000\000\000\000\000\000\000\000\000\005\255\
\\021\255\000\000\000\000\000\000\000\000\098\255\000\000\000\000\
\\000\000\000\000\238\254\000\000\005\255\086\255\052\255\097\255\
\\000\000\005\255\080\255\000\000\000\000\005\255\000\000\122\255\
\\000\000\110\255\096\255\122\255\110\255\110\255\110\255\110\255\
\\110\255\021\255\121\255\065\255\096\255\000\000\000\000\000\000\
\\000\000\000\000\000\000\240\254\121\255\121\255\121\255\121\255\
\\121\255\003\255\094\255\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\102\255\076\255\120\255\000\000\
\\000\000\000\000\116\255\092\255\021\255\239\254\108\255\092\255\
\\024\255\111\255\000\000\239\254\000\000\000\000\000\000\176\255\
\\164\255\000\000\239\254\178\255\021\255\137\255\000\000\117\255\
\\000\000\119\255\000\000\174\255\209\254\000\000\175\255\119\255\
\\114\255\129\255\192\255\196\255\239\254\181\255\175\255\000\000\
\\206\255\000\000\128\000\128\000\165\255\006\000\000\000\198\255\
\\000\000\005\255\000\000\055\255\055\255\055\255\136\255\222\254\
\\005\255\136\255\136\255\172\255\136\255\055\255\055\255\055\255\
\\000\000\000\000\173\255\170\255\136\255\222\254\055\255\000\000\
\\000\000\000\000\000\000\000\000\055\255\000\000\000\000\000\000\
\\021\255\136\255\055\255\000\000\000\000\214\255\000\000\000\000\
\\179\255\216\255\136\255\021\255\000\000\055\255\222\254\021\255\
\\000\000\000\000\136\255\172\255\172\255\003\255\182\255\172\255\
\\000\000\000\000\055\255\153\255\190\255\005\255\222\254\055\255\
\\055\255\055\255\177\255\210\255\161\255\000\000\136\255\194\255\
\\000\000\102\255\000\000\000\000\238\254\000\000\193\255\199\255\
\\153\255\055\255\202\255\000\000\204\255\055\255\180\255\055\255\
\\000\000\055\255\000\000\231\255\207\255\000\000\000\000\000\000\
\\000\000\000\000\000\000\055\255\205\255\000\000\255\255\221\255\
\\235\255\055\255\055\255\219\255\012\000\211\255\000\000\055\255\
\\021\255\217\255\232\255\000\000\000\000\201\255\209\255\215\255\
\\000\000\136\255\212\255\222\255\028\000\000\000\228\255\234\255\
\\021\255\055\255\000\000\237\255\011\255\000\000\238\255\000\000\
\\225\255\119\255\000\000\000\000\034\000\067\000\000\000\038\000\
\\000\000\221\255\000\000\000\000\242\255\000\000\000\000\021\255\
\\025\000\245\255\024\000\243\255\046\000\022\255\000\000\037\000\
\\000\000\000\000\000\000\006\000\003\000\067\000\000\000\000\000\
\\000\000\000\000\234\254\000\000\000\000\054\000\009\000\000\000\
\\000\000\005\000\000\000\251\255\000\000\076\000\078\000\000\000\
\\239\254\251\255\031\000\000\000\136\255\015\000\000\000";

val yyrindex = "\000\000\
\\081\255\000\000\000\000\000\000\081\255\077\000\000\000\000\000\
\\000\000\077\000\077\000\077\000\077\000\077\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\241\254\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\044\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\053\000\000\000\059\255\
\\000\000\025\255\035\000\059\255\025\255\025\255\025\255\025\255\
\\025\255\000\000\018\255\000\000\035\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\018\255\018\255\018\255\018\255\
\\018\255\000\000\091\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\026\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\041\000\042\000\000\000\000\000\041\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\043\000\
\\000\000\000\000\042\255\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\255\000\000\000\000\000\000\000\000\080\000\087\255\
\\000\000\000\000\000\000\000\000\000\000\000\000\080\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\042\000\000\000\000\000\048\255\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\045\000\000\000\
\\000\000\252\254\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\047\000\000\000\000\000\000\000\047\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\048\000\050\000\
\\000\000\047\000\047\000\000\000\049\000\000\000\000\000\047\000\
\\057\000\000\000\190\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\052\000\000\000\000\000\000\000\
\\057\000\000\000\000\000\000\000\060\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\050\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\251\254\000\000\
\\000\000\000\000\000\000\000\000\045\000\000\000\000\000";

val yygindex = "\000\000\
\\000\000\000\000\126\001\000\000\071\001\000\000\000\000\083\001\
\\000\000\010\001\000\000\000\000\141\255\000\000\000\000\038\255\
\\015\255\000\000\171\255\230\255\000\000\113\255\000\000\000\000\
\\233\255\185\255\148\255\131\000\106\000\135\000\232\000\037\001\
\\084\000\145\000\228\000\047\001\000\000\103\000\193\000\043\001\
\\088\001\000\000\000\000\074\001\000\000\064\001\000\000\147\000\
\\000\000\000\000\236\255\000\000\000\000\253\255\240\255\162\255\
\\000\000\000\000\128\001";

val YYTABLESIZE = 530;
val yytable = "\008\000\
\\028\000\035\000\104\000\030\000\128\000\122\000\057\001\025\000\
\\031\000\063\000\035\000\063\000\020\001\001\000\200\000\184\000\
\\041\000\008\000\040\000\035\000\063\000\032\001\124\000\088\000\
\\021\000\032\000\031\000\047\001\035\000\063\000\082\000\058\001\
\\008\000\021\000\068\000\039\000\103\000\039\000\033\000\212\000\
\\088\000\026\000\003\000\032\000\048\001\164\000\168\000\082\000\
\\183\000\185\000\085\000\188\000\189\000\088\000\192\000\224\000\
\\033\000\049\001\054\001\037\001\082\000\129\000\199\000\129\000\
\\039\000\026\000\007\000\077\000\180\000\181\000\182\000\017\000\
\\129\000\023\000\063\000\204\000\034\000\039\000\193\000\194\000\
\\195\000\129\000\084\000\056\001\209\000\024\000\026\000\201\000\
\\029\000\003\000\100\000\088\000\214\000\202\000\034\000\050\001\
\\108\000\088\000\082\000\205\000\127\000\088\000\003\000\108\000\
\\026\000\026\000\010\000\103\000\082\000\137\000\211\000\022\000\
\\239\000\250\000\014\000\156\000\037\000\179\000\042\000\137\000\
\\022\000\133\000\044\000\220\000\187\000\045\000\014\000\048\000\
\\225\000\226\000\227\000\053\000\075\000\007\001\008\001\161\000\
\\162\000\163\000\103\000\012\001\087\000\050\000\069\000\003\000\
\\003\000\003\000\245\000\011\000\012\000\013\000\245\000\059\000\
\\252\000\003\000\253\000\039\000\210\000\014\000\035\001\090\000\
\\213\000\215\000\216\000\239\000\000\001\219\000\085\000\092\000\
\\093\000\094\000\245\000\245\000\054\000\055\000\056\000\101\000\
\\245\000\223\000\230\000\221\000\105\000\110\000\057\000\070\000\
\\071\000\072\000\109\000\112\000\114\000\231\000\232\000\121\000\
\\116\000\073\000\245\000\129\000\241\000\117\000\130\000\125\000\
\\244\000\137\000\018\000\019\000\020\000\021\000\022\000\170\000\
\\138\000\131\000\233\000\234\000\139\000\132\000\134\000\140\000\
\\136\000\169\000\178\000\103\000\235\000\190\000\196\000\198\000\
\\141\000\013\001\142\000\143\000\144\000\206\000\239\000\207\000\
\\171\000\208\000\218\000\145\000\026\000\146\000\147\000\148\000\
\\149\000\013\001\222\000\229\000\150\000\242\000\228\000\240\000\
\\254\000\151\000\251\000\243\000\018\001\122\000\248\000\152\000\
\\249\000\153\000\154\000\155\000\255\000\156\000\137\000\006\001\
\\013\001\002\001\157\000\158\000\170\000\138\000\003\001\009\001\
\\159\000\139\000\001\001\160\000\140\000\052\001\010\001\017\001\
\\011\001\161\000\162\000\163\000\172\000\141\000\016\001\142\000\
\\143\000\144\000\021\001\022\001\025\001\171\000\026\001\024\001\
\\145\000\027\001\146\000\147\000\148\000\149\000\036\001\028\001\
\\038\001\150\000\031\001\033\001\034\001\042\001\151\000\040\001\
\\043\001\044\001\122\000\046\001\152\000\067\001\153\000\154\000\
\\155\000\053\001\156\000\137\000\045\001\059\001\060\001\157\000\
\\158\000\055\001\138\000\061\001\062\001\159\000\139\000\065\001\
\\160\000\140\000\066\001\069\001\071\001\076\000\161\000\162\000\
\\163\000\172\000\141\000\010\000\142\000\143\000\144\000\063\000\
\\064\000\065\000\066\000\067\000\011\000\145\000\017\000\146\000\
\\147\000\148\000\149\000\132\000\135\000\107\000\150\000\109\000\
\\110\000\027\000\117\000\151\000\113\000\118\000\114\000\122\000\
\\142\000\152\000\140\000\153\000\154\000\155\000\121\000\156\000\
\\137\000\122\000\009\000\076\000\157\000\158\000\062\000\138\000\
\\135\000\041\001\159\000\139\000\030\001\160\000\140\000\029\001\
\\203\000\113\000\023\001\161\000\162\000\163\000\172\000\141\000\
\\070\001\142\000\143\000\144\000\079\000\080\000\081\000\082\000\
\\083\000\217\000\145\000\123\000\146\000\147\000\148\000\149\000\
\\068\001\102\000\111\000\150\000\039\001\049\000\000\000\000\000\
\\151\000\000\000\000\000\000\000\000\000\000\000\152\000\000\000\
\\153\000\154\000\155\000\000\000\156\000\000\000\000\000\000\000\
\\000\000\157\000\158\000\098\000\000\000\000\000\000\000\159\000\
\\098\000\000\000\160\000\098\000\000\000\098\000\000\000\098\000\
\\161\000\162\000\163\000\103\000\098\000\000\000\098\000\000\000\
\\000\000\000\000\098\000\098\000\000\000\000\000\000\000\098\000\
\\000\000\098\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\098\000\
\\098\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\098\000\098\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\098\000\000\000\000\000\000\000\098\000\
\\000\000\000\000\098\000\000\000\098\000\000\000\098\000\098\000\
\\098\000\098\000";

val yycheck = "\003\000\
\\017\000\025\000\097\000\024\000\120\000\053\001\029\001\050\001\
\\006\001\014\001\016\001\016\001\254\000\001\000\158\000\050\001\
\\037\000\033\001\035\000\025\001\025\001\011\001\117\000\006\001\
\\025\001\023\001\006\001\006\001\034\001\034\001\006\001\054\001\
\\048\001\034\001\058\000\054\001\084\001\054\001\036\001\183\000\
\\023\001\084\001\002\001\023\001\023\001\131\000\132\000\023\001\
\\143\000\084\001\074\000\146\000\147\000\036\001\149\000\199\000\
\\036\001\036\001\044\001\022\001\036\001\014\001\157\000\016\001\
\\054\001\084\001\084\001\084\001\140\000\141\000\142\000\018\001\
\\025\001\017\001\079\001\170\000\074\001\054\001\150\000\151\000\
\\152\000\034\001\080\001\046\001\179\000\009\001\084\001\159\000\
\\084\001\009\001\094\000\074\001\187\000\165\000\074\001\074\001\
\\100\000\080\001\074\001\171\000\053\001\084\001\022\001\107\000\
\\084\001\084\001\022\001\084\001\084\001\068\001\182\000\025\001\
\\207\000\222\000\056\001\061\001\019\001\138\000\033\001\078\001\
\\034\001\125\000\071\001\195\000\145\000\029\001\068\001\048\001\
\\200\000\201\000\202\000\022\001\068\001\242\000\243\000\081\001\
\\082\001\083\001\084\001\248\000\047\001\020\001\022\001\063\001\
\\064\001\065\001\218\000\063\001\064\001\065\001\222\000\056\001\
\\224\000\073\001\226\000\054\001\180\000\073\001\018\001\084\001\
\\184\000\188\000\189\000\002\001\236\000\192\000\190\000\048\001\
\\053\001\078\001\242\000\243\000\063\001\064\001\065\001\068\001\
\\248\000\198\000\018\001\196\000\070\001\018\001\073\001\063\001\
\\064\001\065\001\011\001\010\001\052\001\029\001\030\001\018\001\
\\076\001\073\001\010\001\082\001\213\000\079\001\070\001\025\001\
\\217\000\001\001\010\000\011\000\012\000\013\000\014\000\007\001\
\\008\001\018\001\050\001\051\001\012\001\018\001\034\001\015\001\
\\011\001\053\001\021\001\084\001\060\001\050\001\050\001\054\001\
\\024\001\249\000\026\001\027\001\028\001\016\001\069\001\053\001\
\\032\001\018\001\053\001\035\001\084\001\037\001\038\001\039\001\
\\040\001\009\001\053\001\034\001\044\001\053\001\070\001\054\001\
\\018\001\049\001\071\001\053\001\052\001\053\001\053\001\055\001\
\\053\001\057\001\058\001\059\001\054\001\061\001\001\001\029\001\
\\032\001\011\001\066\001\067\001\007\001\008\001\050\001\053\001\
\\072\001\012\001\070\001\075\001\015\001\038\001\011\001\048\001\
\\070\001\081\001\082\001\083\001\084\001\024\001\070\001\026\001\
\\027\001\028\001\082\001\077\001\071\001\032\001\011\001\084\001\
\\035\001\070\001\037\001\038\001\039\001\040\001\013\001\070\001\
\\011\001\044\001\070\001\070\001\084\001\029\001\049\001\070\001\
\\068\001\034\001\053\001\014\001\055\001\065\001\057\001\058\001\
\\059\001\029\001\061\001\001\001\082\001\016\001\062\001\066\001\
\\067\001\071\001\008\001\071\001\082\001\072\001\012\001\004\001\
\\075\001\015\001\005\001\053\001\070\001\009\001\081\001\082\001\
\\083\001\084\001\024\001\048\001\026\001\027\001\028\001\053\000\
\\054\000\055\000\056\000\057\000\048\001\035\001\068\001\037\001\
\\038\001\039\001\040\001\017\001\068\001\084\001\044\001\070\001\
\\070\001\034\001\070\001\049\001\070\001\070\001\070\001\053\001\
\\071\001\055\001\071\001\057\001\058\001\059\001\070\001\061\001\
\\001\001\070\001\005\000\061\000\066\001\067\001\052\000\008\001\
\\127\000\032\001\072\001\012\001\010\001\075\001\015\001\009\001\
\\169\000\109\000\002\001\081\001\082\001\083\001\084\001\024\001\
\\069\001\026\001\027\001\028\001\069\000\070\000\071\000\072\000\
\\073\000\190\000\035\001\117\000\037\001\038\001\039\001\040\001\
\\066\001\096\000\107\000\044\001\026\001\046\000\255\255\255\255\
\\049\001\255\255\255\255\255\255\255\255\255\255\055\001\255\255\
\\057\001\058\001\059\001\255\255\061\001\255\255\255\255\255\255\
\\255\255\066\001\067\001\006\001\255\255\255\255\255\255\072\001\
\\011\001\255\255\075\001\014\001\255\255\016\001\255\255\018\001\
\\081\001\082\001\083\001\084\001\023\001\255\255\025\001\255\255\
\\255\255\255\255\029\001\030\001\255\255\255\255\255\255\034\001\
\\255\255\036\001\255\255\255\255\255\255\255\255\255\255\255\255\
\\255\255\255\255\255\255\255\255\255\255\255\255\255\255\050\001\
\\051\001\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\\255\255\060\001\061\001\255\255\255\255\255\255\255\255\255\255\
\\255\255\255\255\255\255\070\001\255\255\255\255\255\255\074\001\
\\255\255\255\255\077\001\255\255\079\001\255\255\081\001\082\001\
\\083\001\084\001";

val yyact = vector_ 151 (fn () => ((raise Fail "parser") : obj));
(* Rule 1, file Parser.grm, line 116 *)
val _ = update_ yyact 1
(fn () => repr(let
val d__1__ = peekVal 2 : unit
val d__2__ = peekVal 1 : GrailAbsyn.ClassDef
in
(((d__1__);(d__2__))) end : GrailAbsyn.ClassDef))
;
(* Rule 2, file Parser.grm, line 120 *)
val _ = update_ yyact 2
(fn () => repr(let
val d__1__ = peekVal 1 : unit
val d__2__ = peekVal 0 : unit
in
(((d__1__);(d__2__))) end : unit))
;
(* Rule 3, file Parser.grm, line 121 *)
val _ = update_ yyact 3
(fn () => repr(let
in
(()) end : unit))
;
(* Rule 4, file Parser.grm, line 125 *)
val _ = update_ yyact 4
(fn () => repr(let
val d__2__ = peekVal 2 : string
val d__4__ = peekVal 0 : string
in
( makeAlias((d__2__),(d__4__)) ) end : unit))
;
(* Rule 5, file Parser.grm, line 126 *)
val _ = update_ yyact 5
(fn () => repr(let
val d__2__ = peekVal 2 : string
val d__4__ = peekVal 0 : GrailAbsyn.FieldDesc
in
( makeFieldAlias((d__2__),(d__4__)) ) end : unit))
;
(* Rule 6, file Parser.grm, line 132 *)
val _ = update_ yyact 6
(fn () => repr(let
val d__1__ = peekVal 9 : Classdecl.class_access_flag list
val d__3__ = peekVal 7 : string
val d__4__ = peekVal 6 : string option
val d__5__ = peekVal 5 : string list
val d__7__ = peekVal 3 : GrailAbsyn.FieldDef list
val d__8__ = peekVal 2 : GrailAbsyn.MethodDef list
val d__10__ = peekVal 0 : GrailAbsyn.layout list option
in
( (thisClass := (d__3__); CDEF((d__1__), (d__3__), (d__4__), (d__5__), (d__7__), (d__8__), (d__10__))) ) end : GrailAbsyn.ClassDef))
;
(* Rule 7, file Parser.grm, line 136 *)
val _ = update_ yyact 7
(fn () => repr(let
val d__2__ = peekVal 0 : string
in
( SOME (d__2__) ) end : string option))
;
(* Rule 8, file Parser.grm, line 137 *)
val _ = update_ yyact 8
(fn () => repr(let
in
( NONE ) end : string option))
;
(* Rule 9, file Parser.grm, line 141 *)
val _ = update_ yyact 9
(fn () => repr(let
val d__2__ = peekVal 0 : string list
in
( (d__2__) ) end : string list))
;
(* Rule 10, file Parser.grm, line 142 *)
val _ = update_ yyact 10
(fn () => repr(let
in
( [] ) end : string list))
;
(* Rule 11, file Parser.grm, line 145 *)
val _ = update_ yyact 11
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
([(d__1__)]) end : string list))
;
(* Rule 12, file Parser.grm, line 146 *)
val _ = update_ yyact 12
(fn () => repr(let
val d__1__ = peekVal 1 : string
val d__2__ = peekVal 0 : string list
in
((d__1__)::(d__2__)) end : string list))
;
(* Rule 13, file Parser.grm, line 149 *)
val _ = update_ yyact 13
(fn () => repr(let
val d__1__ = peekVal 1 : GrailAbsyn.FieldDef
val d__2__ = peekVal 0 : GrailAbsyn.FieldDef list
in
((d__1__)::(d__2__)) end : GrailAbsyn.FieldDef list))
;
(* Rule 14, file Parser.grm, line 150 *)
val _ = update_ yyact 14
(fn () => repr(let
in
([]) end : GrailAbsyn.FieldDef list))
;
(* Rule 15, file Parser.grm, line 154 *)
val _ = update_ yyact 15
(fn () => repr(let
val d__2__ = peekVal 2 : Classdecl.field_access_flag list
val d__3__ = peekVal 1 : GrailAbsyn.Ty
val d__4__ = peekVal 0 : string
in
(FDEF((d__2__),(d__3__),(d__4__))) end : GrailAbsyn.FieldDef))
;
(* Rule 16, file Parser.grm, line 158 *)
val _ = update_ yyact 16
(fn () => repr(let
val d__1__ = peekVal 1 : GrailAbsyn.MethodDef
val d__2__ = peekVal 0 : GrailAbsyn.MethodDef list
in
((d__1__)::(d__2__)) end : GrailAbsyn.MethodDef list))
;
(* Rule 17, file Parser.grm, line 159 *)
val _ = update_ yyact 17
(fn () => repr(let
in
([]) end : GrailAbsyn.MethodDef list))
;
(* Rule 18, file Parser.grm, line 164 *)
val _ = update_ yyact 18
(fn () => repr(let
val d__2__ = peekVal 7 : Classdecl.method_access_flag list
val d__3__ = peekVal 6 : GrailAbsyn.RTy
val d__4__ = peekVal 5 : string
val d__6__ = peekVal 3 : (GrailAbsyn.Ty * GrailAbsyn.Var) list
val d__9__ = peekVal 0 : GrailAbsyn.MethodBody
in
(MDEF((d__2__),(d__3__),(d__4__),(d__6__),(d__9__))) end : GrailAbsyn.MethodDef))
;
(* Rule 19, file Parser.grm, line 168 *)
val _ = update_ yyact 19
(fn () => repr(let
val d__2__ = peekVal 4 : GrailAbsyn.LetDec list
val d__3__ = peekVal 3 : GrailAbsyn.FunDec list
val d__5__ = peekVal 1 : GrailAbsyn.Result
in
(MBODY((d__2__),(d__3__),(d__5__))) end : GrailAbsyn.MethodBody))
;
(* Rule 20, file Parser.grm, line 173 *)
val _ = update_ yyact 20
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.LetDec list
in
((d__1__)) end : GrailAbsyn.LetDec list))
;
(* Rule 21, file Parser.grm, line 174 *)
val _ = update_ yyact 21
(fn () => repr(let
in
([]) end : GrailAbsyn.LetDec list))
;
(* Rule 22, file Parser.grm, line 178 *)
val _ = update_ yyact 22
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.LetDec
in
([(d__1__)]) end : GrailAbsyn.LetDec list))
;
(* Rule 23, file Parser.grm, line 179 *)
val _ = update_ yyact 23
(fn () => repr(let
val d__1__ = peekVal 1 : GrailAbsyn.LetDec
val d__2__ = peekVal 0 : GrailAbsyn.LetDec list
in
((d__1__)::(d__2__)) end : GrailAbsyn.LetDec list))
;
(* Rule 24, file Parser.grm, line 183 *)
val _ = update_ yyact 24
(fn () => repr(let
val d__2__ = peekVal 2 : string
val d__4__ = peekVal 0 : GrailAbsyn.PrimOp
in
(VALdec((d__2__),(d__4__))) end : GrailAbsyn.LetDec))
;
(* Rule 25, file Parser.grm, line 184 *)
val _ = update_ yyact 25
(fn () => repr(let
val d__2__ = peekVal 2 : GrailAbsyn.RTy
val d__4__ = peekVal 0 : GrailAbsyn.PrimOp
in
(VOIDdec((d__4__))) end : GrailAbsyn.LetDec))
;
(* Rule 26, file Parser.grm, line 188 *)
val _ = update_ yyact 26
(fn () => repr(let
val d__1__ = peekVal 1 : GrailAbsyn.FunDec
val d__2__ = peekVal 0 : GrailAbsyn.FunDec list
in
((d__1__)::(d__2__)) end : GrailAbsyn.FunDec list))
;
(* Rule 27, file Parser.grm, line 189 *)
val _ = update_ yyact 27
(fn () => repr(let
in
([]) end : GrailAbsyn.FunDec list))
;
(* Rule 28, file Parser.grm, line 194 *)
val _ = update_ yyact 28
(fn () => repr(let
val d__2__ = peekVal 5 : string
val d__4__ = peekVal 3 : (GrailAbsyn.Ty * GrailAbsyn.Var) list
val d__7__ = peekVal 0 : GrailAbsyn.FunBody
in
(FDEC((d__2__),(d__4__),(d__7__))) end : GrailAbsyn.FunDec))
;
(* Rule 29, file Parser.grm, line 198 *)
val _ = update_ yyact 29
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.Result
in
(FUNbody([],(d__1__))) end : GrailAbsyn.FunBody))
;
(* Rule 30, file Parser.grm, line 199 *)
val _ = update_ yyact 30
(fn () => repr(let
val d__2__ = peekVal 3 : GrailAbsyn.LetDec list
val d__4__ = peekVal 1 : GrailAbsyn.Result
in
(FUNbody((d__2__),(d__4__))) end : GrailAbsyn.FunBody))
;
(* Rule 31, file Parser.grm, line 203 *)
val _ = update_ yyact 31
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.PrimRes
in
(PRIMres((d__1__))) end : GrailAbsyn.Result))
;
(* Rule 32, file Parser.grm, line 205 *)
val _ = update_ yyact 32
(fn () => repr(let
val d__2__ = peekVal 6 : GrailAbsyn.Value
val d__3__ = peekVal 5 : GrailAbsyn.Test
val d__4__ = peekVal 4 : GrailAbsyn.Value
val d__6__ = peekVal 2 : GrailAbsyn.PrimRes
val d__8__ = peekVal 0 : GrailAbsyn.PrimRes
in
(CHOICEres((d__2__),(d__3__),(d__4__),(d__6__),(d__8__))) end : GrailAbsyn.Result))
;
(* Rule 33, file Parser.grm, line 207 *)
val _ = update_ yyact 33
(fn () => repr(let
val d__2__ = peekVal 8 : string
val d__5__ = peekVal 5 : int
val d__7__ = peekVal 3 : int
val d__10__ = peekVal 0 : (int * string * GrailAbsyn.Var list) list
in
(CASEres((d__2__),(d__5__),(d__7__),(d__10__))) end : GrailAbsyn.Result))
;
(* Rule 34, file Parser.grm, line 211 *)
val _ = update_ yyact 34
(fn () => repr(let
val d__1__ = peekVal 2 : int * string * GrailAbsyn.Var list
val d__3__ = peekVal 0 : (int * string * GrailAbsyn.Var list) list
in
( (d__1__)::(d__3__) ) end : (int * string * GrailAbsyn.Var list) list))
;
(* Rule 35, file Parser.grm, line 212 *)
val _ = update_ yyact 35
(fn () => repr(let
val d__1__ = peekVal 0 : int * string * GrailAbsyn.Var list
in
( [(d__1__)] ) end : (int * string * GrailAbsyn.Var list) list))
;
(* Rule 36, file Parser.grm, line 216 *)
val _ = update_ yyact 36
(fn () => repr(let
val d__1__ = peekVal 5 : int
val d__3__ = peekVal 3 : string
val d__5__ = peekVal 1 : GrailAbsyn.Var list
in
(((d__1__), (d__3__), (d__5__))) end : int * string * GrailAbsyn.Var list))
;
(* Rule 37, file Parser.grm, line 221 *)
val _ = update_ yyact 37
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.PrimOp
in
(OPres((d__1__))) end : GrailAbsyn.PrimRes))
;
(* Rule 38, file Parser.grm, line 222 *)
val _ = update_ yyact 38
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.RTy
in
(VOIDres) end : GrailAbsyn.PrimRes))
;
(* Rule 39, file Parser.grm, line 223 *)
val _ = update_ yyact 39
(fn () => repr(let
val d__1__ = peekVal 3 : string
val d__3__ = peekVal 1 : GrailAbsyn.Var list
in
(FUNres((d__1__),(d__3__))) end : GrailAbsyn.PrimRes))
;
(* Rule 40, file Parser.grm, line 228 *)
val _ = update_ yyact 40
(fn () => repr(let
in
(EQtest) end : GrailAbsyn.Test))
;
(* Rule 41, file Parser.grm, line 229 *)
val _ = update_ yyact 41
(fn () => repr(let
in
(NEtest) end : GrailAbsyn.Test))
;
(* Rule 42, file Parser.grm, line 230 *)
val _ = update_ yyact 42
(fn () => repr(let
in
(Ltest) end : GrailAbsyn.Test))
;
(* Rule 43, file Parser.grm, line 231 *)
val _ = update_ yyact 43
(fn () => repr(let
in
(LEtest) end : GrailAbsyn.Test))
;
(* Rule 44, file Parser.grm, line 232 *)
val _ = update_ yyact 44
(fn () => repr(let
in
(Gtest) end : GrailAbsyn.Test))
;
(* Rule 45, file Parser.grm, line 233 *)
val _ = update_ yyact 45
(fn () => repr(let
in
(GEtest) end : GrailAbsyn.Test))
;
(* Rule 46, file Parser.grm, line 237 *)
val _ = update_ yyact 46
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.Value
in
(VALop((d__1__))) end : GrailAbsyn.PrimOp))
;
(* Rule 47, file Parser.grm, line 238 *)
val _ = update_ yyact 47
(fn () => repr(let
val d__1__ = peekVal 2 : GrailAbsyn.BinOp
val d__2__ = peekVal 1 : GrailAbsyn.Value
val d__3__ = peekVal 0 : GrailAbsyn.Value
in
(BINop((d__1__),(d__2__),(d__3__))) end : GrailAbsyn.PrimOp))
;
(* Rule 48, file Parser.grm, line 239 *)
val _ = update_ yyact 48
(fn () => repr(let
val d__2__ = peekVal 3 : GrailAbsyn.MethDesc
val d__4__ = peekVal 1 : GrailAbsyn.Value list
in
(NEWop((d__2__),(d__4__))) end : GrailAbsyn.PrimOp))
;
(* Rule 49, file Parser.grm, line 240 *)
val _ = update_ yyact 49
(fn () => repr(let
val d__2__ = peekVal 1 : string
val d__3__ = peekVal 0 : string
in
(CHECKCASTop((d__2__),(d__3__))) end : GrailAbsyn.PrimOp))
;
(* Rule 50, file Parser.grm, line 241 *)
val _ = update_ yyact 50
(fn () => repr(let
val d__2__ = peekVal 1 : string
val d__3__ = peekVal 0 : string
in
(INSTANCEop((d__2__),(d__3__))) end : GrailAbsyn.PrimOp))
;
(* Rule 51, file Parser.grm, line 243 *)
val _ = update_ yyact 51
(fn () => repr(let
val d__2__ = peekVal 3 : GrailAbsyn.MethDesc
val d__4__ = peekVal 1 : GrailAbsyn.Value list
in
(INVOKESTATICop((d__2__),(d__4__))) end : GrailAbsyn.PrimOp))
;
(* Rule 52, file Parser.grm, line 245 *)
val _ = update_ yyact 52
(fn () => repr(let
val d__2__ = peekVal 4 : string
val d__3__ = peekVal 3 : GrailAbsyn.MethDesc
val d__5__ = peekVal 1 : GrailAbsyn.Value list
in
(INVOKEVIRTUALop((d__2__),(d__3__),(d__5__))) end : GrailAbsyn.PrimOp))
;
(* Rule 53, file Parser.grm, line 247 *)
val _ = update_ yyact 53
(fn () => repr(let
val d__2__ = peekVal 4 : string
val d__3__ = peekVal 3 : GrailAbsyn.MethDesc
val d__5__ = peekVal 1 : GrailAbsyn.Value list
in
(INVOKESPECIALop((d__2__),(d__3__),(d__5__))) end : GrailAbsyn.PrimOp))
;
(* Rule 54, file Parser.grm, line 249 *)
val _ = update_ yyact 54
(fn () => repr(let
val d__2__ = peekVal 4 : string
val d__3__ = peekVal 3 : GrailAbsyn.MethDesc
val d__5__ = peekVal 1 : GrailAbsyn.Value list
in
(INVOKEINTERFACEop((d__2__),(d__3__),(d__5__))) end : GrailAbsyn.PrimOp))
;
(* Rule 55, file Parser.grm, line 250 *)
val _ = update_ yyact 55
(fn () => repr(let
val d__2__ = peekVal 1 : string
val d__3__ = peekVal 0 : GrailAbsyn.FieldDesc
in
(GETFIELDop((d__2__),(d__3__))) end : GrailAbsyn.PrimOp))
;
(* Rule 56, file Parser.grm, line 251 *)
val _ = update_ yyact 56
(fn () => repr(let
val d__2__ = peekVal 2 : string
val d__3__ = peekVal 1 : GrailAbsyn.FieldDesc
val d__4__ = peekVal 0 : GrailAbsyn.Value
in
(PUTFIELDop((d__2__),(d__3__),(d__4__))) end : GrailAbsyn.PrimOp))
;
(* Rule 57, file Parser.grm, line 252 *)
val _ = update_ yyact 57
(fn () => repr(let
val d__2__ = peekVal 0 : GrailAbsyn.FieldDesc
in
(GETSTATICop((d__2__))) end : GrailAbsyn.PrimOp))
;
(* Rule 58, file Parser.grm, line 253 *)
val _ = update_ yyact 58
(fn () => repr(let
val d__2__ = peekVal 1 : GrailAbsyn.FieldDesc
val d__3__ = peekVal 0 : GrailAbsyn.Value
in
(PUTSTATICop((d__2__),(d__3__))) end : GrailAbsyn.PrimOp))
;
(* Rule 59, file Parser.grm, line 255 *)
val _ = update_ yyact 59
(fn () => repr(let
val d__2__ = peekVal 1 : GrailAbsyn.Value
val d__3__ = peekVal 0 : GrailAbsyn.Value
in
(MAKEop((d__3__),(d__2__))) end : GrailAbsyn.PrimOp))
;
(* Rule 60, file Parser.grm, line 256 *)
val _ = update_ yyact 60
(fn () => repr(let
val d__2__ = peekVal 1 : GrailAbsyn.Value
val d__3__ = peekVal 0 : GrailAbsyn.Value
in
(GETop((d__2__),(d__3__))) end : GrailAbsyn.PrimOp))
;
(* Rule 61, file Parser.grm, line 257 *)
val _ = update_ yyact 61
(fn () => repr(let
val d__2__ = peekVal 2 : GrailAbsyn.Value
val d__3__ = peekVal 1 : GrailAbsyn.Value
val d__4__ = peekVal 0 : GrailAbsyn.Value
in
(SETop((d__2__),(d__3__),(d__4__))) end : GrailAbsyn.PrimOp))
;
(* Rule 62, file Parser.grm, line 258 *)
val _ = update_ yyact 62
(fn () => repr(let
val d__2__ = peekVal 0 : GrailAbsyn.Value
in
(LENGTHop((d__2__))) end : GrailAbsyn.PrimOp))
;
(* Rule 63, file Parser.grm, line 259 *)
val _ = update_ yyact 63
(fn () => repr(let
val d__2__ = peekVal 1 : GrailAbsyn.Value
val d__3__ = peekVal 0 : GrailAbsyn.Ty
in
(EMPTYop((d__2__),(d__3__))) end : GrailAbsyn.PrimOp))
;
(* Rule 64, file Parser.grm, line 260 *)
val _ = update_ yyact 64
(fn () => repr(let
val d__2__ = peekVal 0 : GrailAbsyn.Value
in
(ITOFop((d__2__))) end : GrailAbsyn.PrimOp))
;
(* Rule 65, file Parser.grm, line 261 *)
val _ = update_ yyact 65
(fn () => repr(let
val d__2__ = peekVal 0 : GrailAbsyn.Value
in
(FTOIop((d__2__))) end : GrailAbsyn.PrimOp))
;
(* Rule 66, file Parser.grm, line 265 *)
val _ = update_ yyact 66
(fn () => repr(let
val d__2__ = peekVal 4 : string
val d__4__ = peekVal 2 : GrailAbsyn.Ty list
in
(MDESC(NONE,(d__2__),(d__4__))) end : GrailAbsyn.MethDesc))
;
(* Rule 67, file Parser.grm, line 269 *)
val _ = update_ yyact 67
(fn () => repr(let
val d__2__ = peekVal 5 : GrailAbsyn.RTy
val d__3__ = peekVal 4 : string
val d__5__ = peekVal 2 : GrailAbsyn.Ty list
in
(MDESC((d__2__),(d__3__),(d__5__))) end : GrailAbsyn.MethDesc))
;
(* Rule 68, file Parser.grm, line 273 *)
val _ = update_ yyact 68
(fn () => repr(let
val d__2__ = peekVal 2 : GrailAbsyn.Ty
val d__3__ = peekVal 1 : string
in
(FDESC((d__2__),expandSimpleName (d__3__))) end : GrailAbsyn.FieldDesc))
;
(* Rule 69, file Parser.grm, line 277 *)
val _ = update_ yyact 69
(fn () => repr(let
val d__2__ = peekVal 2 : GrailAbsyn.Ty
val d__3__ = peekVal 1 : string
in
(FDESC((d__2__),expandSimpleName (d__3__))) end : GrailAbsyn.FieldDesc))
;
(* Rule 70, file Parser.grm, line 278 *)
val _ = update_ yyact 70
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
(expandField (d__1__)) end : GrailAbsyn.FieldDesc))
;
(* Rule 71, file Parser.grm, line 284 *)
val _ = update_ yyact 71
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.class_access_flag list
in
(C_ACCpublic   ::(d__2__)) end : Classdecl.class_access_flag list))
;
(* Rule 72, file Parser.grm, line 285 *)
val _ = update_ yyact 72
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.class_access_flag list
in
(C_ACCprotected::(d__2__)) end : Classdecl.class_access_flag list))
;
(* Rule 73, file Parser.grm, line 286 *)
val _ = update_ yyact 73
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.class_access_flag list
in
(C_ACCprivate  ::(d__2__)) end : Classdecl.class_access_flag list))
;
(* Rule 74, file Parser.grm, line 287 *)
val _ = update_ yyact 74
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.class_access_flag list
in
(C_ACCstatic::(d__2__)) end : Classdecl.class_access_flag list))
;
(* Rule 75, file Parser.grm, line 288 *)
val _ = update_ yyact 75
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.class_access_flag list
in
(C_ACCfinal::(d__2__)) end : Classdecl.class_access_flag list))
;
(* Rule 76, file Parser.grm, line 289 *)
val _ = update_ yyact 76
(fn () => repr(let
in
([]) end : Classdecl.class_access_flag list))
;
(* Rule 77, file Parser.grm, line 293 *)
val _ = update_ yyact 77
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.field_access_flag list
in
(F_ACCpublic   ::(d__2__)) end : Classdecl.field_access_flag list))
;
(* Rule 78, file Parser.grm, line 294 *)
val _ = update_ yyact 78
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.field_access_flag list
in
(F_ACCprotected::(d__2__)) end : Classdecl.field_access_flag list))
;
(* Rule 79, file Parser.grm, line 295 *)
val _ = update_ yyact 79
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.field_access_flag list
in
(F_ACCprivate  ::(d__2__)) end : Classdecl.field_access_flag list))
;
(* Rule 80, file Parser.grm, line 296 *)
val _ = update_ yyact 80
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.field_access_flag list
in
(F_ACCstatic::(d__2__)) end : Classdecl.field_access_flag list))
;
(* Rule 81, file Parser.grm, line 297 *)
val _ = update_ yyact 81
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.field_access_flag list
in
(F_ACCfinal::(d__2__)) end : Classdecl.field_access_flag list))
;
(* Rule 82, file Parser.grm, line 298 *)
val _ = update_ yyact 82
(fn () => repr(let
in
([]) end : Classdecl.field_access_flag list))
;
(* Rule 83, file Parser.grm, line 302 *)
val _ = update_ yyact 83
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.method_access_flag list
in
(M_ACCpublic   ::(d__2__)) end : Classdecl.method_access_flag list))
;
(* Rule 84, file Parser.grm, line 303 *)
val _ = update_ yyact 84
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.method_access_flag list
in
(M_ACCprotected::(d__2__)) end : Classdecl.method_access_flag list))
;
(* Rule 85, file Parser.grm, line 304 *)
val _ = update_ yyact 85
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.method_access_flag list
in
(M_ACCprivate  ::(d__2__)) end : Classdecl.method_access_flag list))
;
(* Rule 86, file Parser.grm, line 305 *)
val _ = update_ yyact 86
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.method_access_flag list
in
(M_ACCstatic::(d__2__)) end : Classdecl.method_access_flag list))
;
(* Rule 87, file Parser.grm, line 306 *)
val _ = update_ yyact 87
(fn () => repr(let
val d__2__ = peekVal 0 : Classdecl.method_access_flag list
in
(M_ACCfinal::(d__2__)) end : Classdecl.method_access_flag list))
;
(* Rule 88, file Parser.grm, line 307 *)
val _ = update_ yyact 88
(fn () => repr(let
in
([]) end : Classdecl.method_access_flag list))
;
(* Rule 89, file Parser.grm, line 311 *)
val _ = update_ yyact 89
(fn () => repr(let
in
(ADDop) end : GrailAbsyn.BinOp))
;
(* Rule 90, file Parser.grm, line 312 *)
val _ = update_ yyact 90
(fn () => repr(let
in
(MULop) end : GrailAbsyn.BinOp))
;
(* Rule 91, file Parser.grm, line 313 *)
val _ = update_ yyact 91
(fn () => repr(let
in
(SUBop) end : GrailAbsyn.BinOp))
;
(* Rule 92, file Parser.grm, line 314 *)
val _ = update_ yyact 92
(fn () => repr(let
in
(DIVop) end : GrailAbsyn.BinOp))
;
(* Rule 93, file Parser.grm, line 315 *)
val _ = update_ yyact 93
(fn () => repr(let
in
(MODop) end : GrailAbsyn.BinOp))
;
(* Rule 94, file Parser.grm, line 319 *)
val _ = update_ yyact 94
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
(VARval((d__1__))) end : GrailAbsyn.Value))
;
(* Rule 95, file Parser.grm, line 320 *)
val _ = update_ yyact 95
(fn () => repr(let
val d__1__ = peekVal 0 : int
in
(INTval((d__1__))) end : GrailAbsyn.Value))
;
(* Rule 96, file Parser.grm, line 321 *)
val _ = update_ yyact 96
(fn () => repr(let
val d__1__ = peekVal 0 : real
in
(FLOATval((d__1__))) end : GrailAbsyn.Value))
;
(* Rule 97, file Parser.grm, line 322 *)
val _ = update_ yyact 97
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
(STRINGval(stripquotes (d__1__))) end : GrailAbsyn.Value))
;
(* Rule 98, file Parser.grm, line 323 *)
val _ = update_ yyact 98
(fn () => repr(let
val d__3__ = peekVal 1 : string
in
(NULLval((d__3__), NONE)) end : GrailAbsyn.Value))
;
(* Rule 99, file Parser.grm, line 324 *)
val _ = update_ yyact 99
(fn () => repr(let
val d__3__ = peekVal 4 : string
val d__6__ = peekVal 1 : string
in
(NULLval((d__3__),SOME (d__6__))) end : GrailAbsyn.Value))
;
(* Rule 100, file Parser.grm, line 328 *)
val _ = update_ yyact 100
(fn () => repr(let
in
(INTty) end : GrailAbsyn.Ty))
;
(* Rule 101, file Parser.grm, line 329 *)
val _ = update_ yyact 101
(fn () => repr(let
in
(BOOLEANty) end : GrailAbsyn.Ty))
;
(* Rule 102, file Parser.grm, line 330 *)
val _ = update_ yyact 102
(fn () => repr(let
in
(FLOATty) end : GrailAbsyn.Ty))
;
(* Rule 103, file Parser.grm, line 331 *)
val _ = update_ yyact 103
(fn () => repr(let
in
(REFty("java.lang.String")) end : GrailAbsyn.Ty))
;
(* Rule 104, file Parser.grm, line 332 *)
val _ = update_ yyact 104
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
(REFty((d__1__))) end : GrailAbsyn.Ty))
;
(* Rule 105, file Parser.grm, line 333 *)
val _ = update_ yyact 105
(fn () => repr(let
val d__1__ = peekVal 2 : GrailAbsyn.Ty
in
(ARRAYty((d__1__))) end : GrailAbsyn.Ty))
;
(* Rule 106, file Parser.grm, line 337 *)
val _ = update_ yyact 106
(fn () => repr(let
in
(NONE) end : GrailAbsyn.RTy))
;
(* Rule 107, file Parser.grm, line 338 *)
val _ = update_ yyact 107
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.Ty
in
(SOME (d__1__)) end : GrailAbsyn.RTy))
;
(* Rule 108, file Parser.grm, line 341 *)
val _ = update_ yyact 108
(fn () => repr(let
val d__1__ = peekVal 0 : (GrailAbsyn.Ty * GrailAbsyn.Var) list
in
((d__1__)) end : (GrailAbsyn.Ty * GrailAbsyn.Var) list))
;
(* Rule 109, file Parser.grm, line 342 *)
val _ = update_ yyact 109
(fn () => repr(let
in
([]) end : (GrailAbsyn.Ty * GrailAbsyn.Var) list))
;
(* Rule 110, file Parser.grm, line 346 *)
val _ = update_ yyact 110
(fn () => repr(let
val d__1__ = peekVal 1 : GrailAbsyn.Ty
val d__2__ = peekVal 0 : string
in
([((d__1__),(d__2__))]) end : (GrailAbsyn.Ty * GrailAbsyn.Var) list))
;
(* Rule 111, file Parser.grm, line 347 *)
val _ = update_ yyact 111
(fn () => repr(let
val d__1__ = peekVal 3 : GrailAbsyn.Ty
val d__2__ = peekVal 2 : string
val d__4__ = peekVal 0 : (GrailAbsyn.Ty * GrailAbsyn.Var) list
in
(((d__1__),(d__2__))::(d__4__)) end : (GrailAbsyn.Ty * GrailAbsyn.Var) list))
;
(* Rule 112, file Parser.grm, line 351 *)
val _ = update_ yyact 112
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.Value list
in
((d__1__)) end : GrailAbsyn.Value list))
;
(* Rule 113, file Parser.grm, line 352 *)
val _ = update_ yyact 113
(fn () => repr(let
in
([]) end : GrailAbsyn.Value list))
;
(* Rule 114, file Parser.grm, line 356 *)
val _ = update_ yyact 114
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.Value
in
([(d__1__)]) end : GrailAbsyn.Value list))
;
(* Rule 115, file Parser.grm, line 357 *)
val _ = update_ yyact 115
(fn () => repr(let
val d__1__ = peekVal 2 : GrailAbsyn.Value
val d__3__ = peekVal 0 : GrailAbsyn.Value list
in
((d__1__)::(d__3__)) end : GrailAbsyn.Value list))
;
(* Rule 116, file Parser.grm, line 361 *)
val _ = update_ yyact 116
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.Var list
in
((d__1__)) end : GrailAbsyn.Var list))
;
(* Rule 117, file Parser.grm, line 362 *)
val _ = update_ yyact 117
(fn () => repr(let
in
([]) end : GrailAbsyn.Var list))
;
(* Rule 118, file Parser.grm, line 366 *)
val _ = update_ yyact 118
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
([(d__1__)]) end : GrailAbsyn.Var list))
;
(* Rule 119, file Parser.grm, line 367 *)
val _ = update_ yyact 119
(fn () => repr(let
val d__1__ = peekVal 2 : string
val d__3__ = peekVal 0 : GrailAbsyn.Var list
in
((d__1__)::(d__3__)) end : GrailAbsyn.Var list))
;
(* Rule 120, file Parser.grm, line 371 *)
val _ = update_ yyact 120
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.Ty list
in
((d__1__)) end : GrailAbsyn.Ty list))
;
(* Rule 121, file Parser.grm, line 372 *)
val _ = update_ yyact 121
(fn () => repr(let
in
([]) end : GrailAbsyn.Ty list))
;
(* Rule 122, file Parser.grm, line 375 *)
val _ = update_ yyact 122
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.Ty
in
([(d__1__)]) end : GrailAbsyn.Ty list))
;
(* Rule 123, file Parser.grm, line 376 *)
val _ = update_ yyact 123
(fn () => repr(let
val d__1__ = peekVal 2 : GrailAbsyn.Ty
val d__3__ = peekVal 0 : GrailAbsyn.Ty list
in
((d__1__)::(d__3__)) end : GrailAbsyn.Ty list))
;
(* Rule 124, file Parser.grm, line 380 *)
val _ = update_ yyact 124
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
((d__1__)) end : string))
;
(* Rule 125, file Parser.grm, line 384 *)
val _ = update_ yyact 125
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
((d__1__)) end : string))
;
(* Rule 126, file Parser.grm, line 388 *)
val _ = update_ yyact 126
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
((d__1__)) end : string))
;
(* Rule 127, file Parser.grm, line 392 *)
val _ = update_ yyact 127
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
((d__1__)) end : string))
;
(* Rule 128, file Parser.grm, line 396 *)
val _ = update_ yyact 128
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
(expand (d__1__)) end : string))
;
(* Rule 129, file Parser.grm, line 400 *)
val _ = update_ yyact 129
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
((d__1__)) end : string))
;
(* Rule 130, file Parser.grm, line 404 *)
val _ = update_ yyact 130
(fn () => repr(let
in
(NONE) end : GrailAbsyn.RTy))
;
(* Rule 131, file Parser.grm, line 408 *)
val _ = update_ yyact 131
(fn () => repr(let
val d__1__ = peekVal 0 : GrailAbsyn.layout list
in
(SOME (d__1__)) end : GrailAbsyn.layout list option))
;
(* Rule 132, file Parser.grm, line 409 *)
val _ = update_ yyact 132
(fn () => repr(let
in
(NONE) end : GrailAbsyn.layout list option))
;
(* Rule 133, file Parser.grm, line 413 *)
val _ = update_ yyact 133
(fn () => repr(let
val d__3__ = peekVal 1 : GrailAbsyn.layout list
in
((d__3__)) end : GrailAbsyn.layout list))
;
(* Rule 134, file Parser.grm, line 417 *)
val _ = update_ yyact 134
(fn () => repr(let
val d__1__ = peekVal 1 : GrailAbsyn.layout
val d__2__ = peekVal 0 : GrailAbsyn.layout list
in
( (d__1__)::(d__2__) ) end : GrailAbsyn.layout list))
;
(* Rule 135, file Parser.grm, line 418 *)
val _ = update_ yyact 135
(fn () => repr(let
in
([]) end : GrailAbsyn.layout list))
;
(* Rule 136, file Parser.grm, line 422 *)
val _ = update_ yyact 136
(fn () => repr(let
val d__2__ = peekVal 1 : string
val d__3__ = peekVal 0 : (string*int*(string*string) list) list
in
( ((d__2__),(d__3__)) ) end : GrailAbsyn.layout))
;
(* Rule 137, file Parser.grm, line 426 *)
val _ = update_ yyact 137
(fn () => repr(let
val d__1__ = peekVal 0 : string*int*(string*string) list
in
([(d__1__)]) end : (string*int*(string*string) list) list))
;
(* Rule 138, file Parser.grm, line 427 *)
val _ = update_ yyact 138
(fn () => repr(let
val d__1__ = peekVal 1 : string*int*(string*string) list
val d__2__ = peekVal 0 : (string*int*(string*string) list) list
in
((d__1__)::(d__2__)) end : (string*int*(string*string) list) list))
;
(* Rule 139, file Parser.grm, line 431 *)
val _ = update_ yyact 139
(fn () => repr(let
val d__1__ = peekVal 10 : string
val d__5__ = peekVal 6 : int
val d__10__ = peekVal 1 : (string*string) list
in
( ((d__1__), (d__5__), (d__10__)) ) end : string*int*(string*string) list))
;
(* Rule 140, file Parser.grm, line 435 *)
val _ = update_ yyact 140
(fn () => repr(let
val d__1__ = peekVal 0 : string*string
in
([(d__1__)]) end : (string*string) list))
;
(* Rule 141, file Parser.grm, line 436 *)
val _ = update_ yyact 141
(fn () => repr(let
val d__1__ = peekVal 2 : string*string
val d__3__ = peekVal 0 : (string*string) list
in
((d__1__)::(d__3__)) end : (string*string) list))
;
(* Rule 142, file Parser.grm, line 437 *)
val _ = update_ yyact 142
(fn () => repr(let
in
([]) end : (string*string) list))
;
(* Rule 143, file Parser.grm, line 441 *)
val _ = update_ yyact 143
(fn () => repr(let
val d__2__ = peekVal 3 : string
val d__4__ = peekVal 1 : string
in
(((d__2__),(d__4__))) end : string*string))
;
(* Rule 144, file Parser.grm, line 445 *)
val _ = update_ yyact 144
(fn () => repr(let
in
("int") end : string))
;
(* Rule 145, file Parser.grm, line 446 *)
val _ = update_ yyact 145
(fn () => repr(let
in
("bool") end : string))
;
(* Rule 146, file Parser.grm, line 447 *)
val _ = update_ yyact 146
(fn () => repr(let
in
("float") end : string))
;
(* Rule 147, file Parser.grm, line 448 *)
val _ = update_ yyact 147
(fn () => repr(let
in
("string") end : string))
;
(* Rule 148, file Parser.grm, line 449 *)
val _ = update_ yyact 148
(fn () => repr(let
val d__1__ = peekVal 0 : string
in
((d__1__)) end : string))
;
(* Rule 149, file Parser.grm, line 450 *)
val _ = update_ yyact 149
(fn () => repr(let
val d__1__ = peekVal 2 : string
in
((d__1__)^"[]") end : string))
;
(* Entry Top *)
val _ = update_ yyact 150 (fn () => raise yyexit (peekVal 0));
val yytables : parseTables =
  ( yyact,
    yytransl,
    yylhs,
    yylen,
    yydefred,
    yydgoto,
    yysindex,
    yyrindex,
    yygindex,
    YYTABLESIZE,
    yytable,
    yycheck );
fun Top lexer lexbuf = yyparse yytables 1 lexer lexbuf;
