local open Obj Lexing in

 

 (* Grail parser.  Adapted from example in Moscow ML distribution. *)

open Lexing Parser;

exception LexicalError of string * int * int (* (message, loc1, loc2) *)

fun lexerError lexbuf s = 
     raise LexicalError (s, getLexemeStart lexbuf, getLexemeEnd lexbuf);

val commentStart = ref 0;  (* Start of outermost comment being scanned *)
 
fun commentNotClosed lexbuf =
     raise LexicalError ("Comment not terminated", 
                         !commentStart, getLexemeEnd lexbuf);
     
val commentDepth = ref 0;  (* Current comment nesting *)


fun getString lexbuf = 
     let 
	val s = getLexeme lexbuf
     in case String.fromString s of 
         SOME _ => quoteval s (* return the unconverted string:  we're only checking for errors *)
       | NONE => lexerError lexbuf "Badly-formed string literal"
     end

 exception noSuchWord
val keyword_table: (string,token) Polyhash.hash_table
       = Polyhash.mkTable(Polyhash.hash, op=) (64, noSuchWord)

(* Hashtable for identifiers *)

val () =
   List.app (fn (str,tok) => Polyhash.insert keyword_table (str, tok))
 [
  ("alias", ALIAS),
  ("class", CLASS),
  ("field", FIELD),
  ("method", METHOD),
  ("let", LET),
  ("fun", FUN),
  ("in", IN),
  ("and", AND),
  ("end", END),
  ("val", VAL),
  ("if", IF),
  ("then", THEN),
  ("else", ELSE),
  ("case", CASE),
  ("of", OF),
  ("new", NEW),
  ("checkcast", CHECKCAST),
  ("extends", EXTENDS),
  ("implements", IMPLEMENTS),
  ("instanceof", INSTANCEOF),
  ("invokestatic", INVOKESTATIC),
  ("invokevirtual", INVOKEVIRTUAL),
  ("invokespecial", INVOKESPECIAL),
  ("invokeinterface", INVOKEINTERFACE),
  ("getfield", GETFIELD),
  ("putfield", PUTFIELD),
  ("getstatic", GETSTATIC),
  ("putstatic", PUTSTATIC),
  ("add", ADD),
  ("mul", MUL),
  ("sub", SUB),
  ("div", DIV),
  ("mod", MOD),
  ("iand", IAND),
  ("ior", IOR),
  ("ixor", IXOR),
  ("ishr", ISHR),
  ("ishl", ISHL),
  ("iushr", IUSHR        ),
  ("null", NULL),
  ("int", INT),
  ("boolean", BOOLEAN),
  ("float", FLOAT),
  ("ref", REF),
  ("void", VOID),
  ("public", PUBLIC),
  ("private", PRIVATE),
  ("protected", PROTECTED),
  ("static", STATIC),
  ("final", FINAL),
  ("makearray", MAKE),
  ("get", GET),
  ("set", SET),
  ("length", LENGTH),
  ("empty", EMPTY),
  ("itof", ITOF),
  ("ftoi", FTOI),
  ("string", STRING),
  ("layout", LAYOUT),
  ("type", TYPE),
  ("$tag", TAG),
  ("$fields", FIELDS)
]

fun mkKeyword lexbuf =
  let val s = getLexeme lexbuf in
    Polyhash.find keyword_table s
    handle noSuchWord => stringval s
  end

fun action_31 lexbuf = (
 lexerError lexbuf "Illegal symbol in input" )
and action_30 lexbuf = (
 EOF )
and action_29 lexbuf = (
 COMMA )
and action_28 lexbuf = (
 BAR )
and action_27 lexbuf = (
 RSQ )
and action_26 lexbuf = (
 LSQ )
and action_25 lexbuf = (
 RBRACE )
and action_24 lexbuf = (
 LBRACE )
and action_23 lexbuf = (
 RPAREN )
and action_22 lexbuf = (
 LPAREN )
and action_21 lexbuf = (
 DOTDOT )
and action_20 lexbuf = (
 ARROW )
and action_19 lexbuf = (
 GREATEREQ )
and action_18 lexbuf = (
 GREATER )
and action_17 lexbuf = (
 LESSEQ )
and action_16 lexbuf = (
 LESS )
and action_15 lexbuf = (
 NOTEQUAL )
and action_14 lexbuf = (
 EQUALS )
and action_13 lexbuf = (
 DiscardRestOfLine lexbuf; Token lexbuf )
and action_12 lexbuf = (
 commentStart := getLexemeStart lexbuf;
                          commentDepth := 1; 
                          SkipComment lexbuf; Token lexbuf )
and action_11 lexbuf = (
 getString lexbuf )
and action_10 lexbuf = (
 stringval (getLexeme lexbuf) )
and action_9 lexbuf = (
 mkKeyword lexbuf )
and action_8 lexbuf = (
 case Real.fromString (getLexeme lexbuf) of
                               NONE   => lexerError lexbuf "internal error"
			    | SOME i => floatval i
                        )
and action_7 lexbuf = (
 case Int.fromString (getLexeme lexbuf) of
                               NONE   => lexerError lexbuf "internal error"
			    | SOME i => intval i
			)
and action_6 lexbuf = (
 Token lexbuf )
and action_5 lexbuf = (
 SkipComment lexbuf )
and action_4 lexbuf = (
 commentNotClosed lexbuf )
and action_3 lexbuf = (
 commentDepth := !commentDepth + 1; 
                          SkipComment lexbuf )
and action_2 lexbuf = (
 commentDepth := !commentDepth - 1;  
                          if !commentDepth = 0 then ()
                          else SkipComment lexbuf 
                        )
and action_1 lexbuf = (
 DiscardRestOfLine lexbuf )
and action_0 lexbuf = (
 () )
and state_0 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\n" => action_0 lexbuf
 |  #"\^@" => action_0 lexbuf
 |  _ => action_1 lexbuf
 end)
and state_1 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"*" => state_50 lexbuf
 |  #"(" => state_49 lexbuf
 |  #"\^Z" => action_4 lexbuf
 |  #"\^@" => action_4 lexbuf
 |  _ => action_5 lexbuf
 end)
and state_2 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"A" andalso currChar <= #"Z" then  state_7 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_7 lexbuf
 else if currChar >= #"0" andalso currChar <= #"9" then  state_14 lexbuf
 else case currChar of
    #"$" => state_7 lexbuf
 |  #"?" => state_7 lexbuf
 |  #"_" => state_7 lexbuf
 |  #"\n" => action_6 lexbuf
 |  #"\t" => action_6 lexbuf
 |  #"\r" => action_6 lexbuf
 |  #" " => action_6 lexbuf
 |  #"}" => action_25 lexbuf
 |  #"|" => action_28 lexbuf
 |  #"{" => action_24 lexbuf
 |  #"]" => action_27 lexbuf
 |  #"[" => action_26 lexbuf
 |  #">" => state_17 lexbuf
 |  #"=" => state_16 lexbuf
 |  #"<" => state_15 lexbuf
 |  #"/" => state_13 lexbuf
 |  #"." => state_12 lexbuf
 |  #"-" => state_11 lexbuf
 |  #"," => action_29 lexbuf
 |  #")" => action_23 lexbuf
 |  #"(" => state_8 lexbuf
 |  #"\"" => state_6 lexbuf
 |  #"\^@" => action_30 lexbuf
 |  _ => action_31 lexbuf
 end)
and state_6 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_31);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\\" => state_44 lexbuf
 |  #"\"" => action_11 lexbuf
 |  #"\^@" => backtrack lexbuf
 |  _ => state_42 lexbuf
 end)
and state_7 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_9);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #":" then  state_38 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_38 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_38 lexbuf
 else case currChar of
    #"$" => state_38 lexbuf
 |  #"#" => state_38 lexbuf
 |  #"'" => state_38 lexbuf
 |  #"." => state_38 lexbuf
 |  #"_" => state_38 lexbuf
 |  #"<" => state_39 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_8 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_22);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"*" => action_12 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_11 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_31);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_30 lexbuf
 else backtrack lexbuf
 end)
and state_12 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_31);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"." => action_21 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_13 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_31);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"/" => action_13 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_14 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_7);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_30 lexbuf
 else case currChar of
    #"." => state_29 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_15 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_16);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"a" andalso currChar <= #"z" then  state_27 lexbuf
 else case currChar of
    #">" => action_15 lexbuf
 |  #"=" => action_17 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_16 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_14);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #">" => action_20 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_17 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_18);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"=" => action_19 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_27 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"a" andalso currChar <= #"z" then  state_27 lexbuf
 else case currChar of
    #">" => action_10 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_29 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_31 lexbuf
 else backtrack lexbuf
 end)
and state_30 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_7);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_30 lexbuf
 else case currChar of
    #"." => state_29 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_31 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_8);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_31 lexbuf
 else case currChar of
    #"E" => state_32 lexbuf
 |  #"e" => state_32 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_32 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_34 lexbuf
 else case currChar of
    #"-" => state_33 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_33 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_34 lexbuf
 else backtrack lexbuf
 end)
and state_34 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_8);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_34 lexbuf
 else backtrack lexbuf
 end)
and state_38 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_9);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #":" then  state_38 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_38 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_38 lexbuf
 else case currChar of
    #"$" => state_38 lexbuf
 |  #"#" => state_38 lexbuf
 |  #"'" => state_38 lexbuf
 |  #"." => state_38 lexbuf
 |  #"_" => state_38 lexbuf
 |  #"<" => state_39 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_39 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"a" andalso currChar <= #"z" then  state_40 lexbuf
 else backtrack lexbuf
 end)
and state_40 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"a" andalso currChar <= #"z" then  state_40 lexbuf
 else case currChar of
    #">" => state_41 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_41 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_9);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"'" => state_41 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_42 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\\" => state_44 lexbuf
 |  #"\"" => action_11 lexbuf
 |  #"\^@" => backtrack lexbuf
 |  _ => state_42 lexbuf
 end)
and state_44 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\\" => state_44 lexbuf
 |  #"\"" => state_45 lexbuf
 |  #"\^@" => backtrack lexbuf
 |  _ => state_42 lexbuf
 end)
and state_45 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_11);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\\" => state_44 lexbuf
 |  #"\"" => action_11 lexbuf
 |  #"\^@" => backtrack lexbuf
 |  _ => state_42 lexbuf
 end)
and state_49 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_5);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"*" => action_3 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_50 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_5);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #")" => action_2 lexbuf
 |  _ => backtrack lexbuf
 end)
and Token lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_2 lexbuf)

and SkipComment lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_1 lexbuf)

and DiscardRestOfLine lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_0 lexbuf)

(* The following checks type consistency of actions *)
val _ = fn _ => [action_31, action_30, action_29, action_28, action_27, action_26, action_25, action_24, action_23, action_22, action_21, action_20, action_19, action_18, action_17, action_16, action_15, action_14, action_13, action_12, action_11, action_10, action_9, action_8, action_7, action_6];
val _ = fn _ => [action_5, action_4, action_3, action_2];
val _ = fn _ => [action_1, action_0];

end
