(* Time-stamp: <Wed Aug 03 2005 23:32:12 Stardate: [-29]4344.48 hwloidl> *)
(* $Id: CertGenP.sml,v 2.12.2.3 2005/08/03 21:35:16 a1hloidl Exp $ *)
(* ------------Certificate generation at producer side: Certificate1 ----------------*)

open GrailAbsyn
open GrailUtils

exception CertGenError of string;

val slash = "\\"
val newline = "\n"

(* HWL: HACK for setting data layout here *)
(* val data_layout = ref "00" *)

(* HWL: fill in reported types here and use it in makeCert1 *)
val reportedTypes = ref ""
val leak_detected = ref false

val cert_version = "$Id: CertGenP.sml,v 2.12.2.3 2005/08/03 21:35:16 a1hloidl Exp $"

(* functions hardwired into the compiler; ToDo: define this in Lib.sml and import -- HWL *)
val magic_funs = ["atol$","atol1$","atol$_1","atol1$_1","atol1$_2","atol1$_3","main","start","start_1","start_2","show_list0","show_list","stringList_to_intList"]



(*stolen and modified from FlowGraph.sml*)
(*This version keeps the dominates and ismergepoint info seperate for each method.
  This is probably the right thing to be doing, but our VCG tactic can't cop with it.*)
(*
fun mymakeDefsAux (MDEF(flags,rty,mname,params,mbody)) =
    let
	val fg = FlowGraph.flowGraph mbody
	val dom = FlowGraph.dominators fg
	val mergepoints = List.map #1 (List.filter (fn (k,(v_in,_)) => length v_in > 1) (Polyhash.listItems fg))
	val mergePoint_def = mname ^ "isMergePoint_def: \"isMergePoint f == f \\<in> {" 
			     ^ listToString id ", " mergepoints
			     ^ "}\"\n"
	fun makecase (f,l) = "if f = " ^ f ^ " then [" ^ listToString id ", " (rev l) ^ "] else"
	val inv_dom = List.map makecase (FlowGraph.invertDoms dom)
	val dom_def = mname ^ "dominates_def:\n\"dominates f == "
		      ^ (case inv_dom of 
			    [] => "[]\""
			  | _ =>
			    "("
			     ^ listToString id "\n                 " inv_dom
			     ^ " [])\"")
    in
	mergePoint_def ^ dom_def
    end
fun mymakeDefs mdefs = 
  (List.foldl (fn mds => (snd mds) ^ (mymakeDefs (fst mds))) "" mdefs) ^ newline
)
*)

(* Don't want messages mixed with syntax going to stdout *)
(*
fun printToStdErr s = 
    if not (!ToyGrailAbsyn.shut_up) then
	TextIO.output(TextIO.stdErr, s)
else ()
*)
fun printToStdErr s = TextIO.output(TextIO.stdErr, s)

fun makeFunName cn mn s = ToyGrailAbsyn.unqual_name (cn ^ "'" ^ mn ^ "'" ^ s )
 
(*This version combines the info of individual methods in one definition*)
fun mymakeDefsAux cn (MDEF(flags,rty,mname,params,mbody)) =
    let
	val fg = FlowGraph.flowGraph mbody
(*
        val () = TextIO.print "FlowGraph is this: "
        val () = FlowGraph.printGraph fg 
*)
	val dom = FlowGraph.dominators fg
	val mergepointsAux = List.map #1 (List.filter (fn (k,(v_in,_)) => length v_in > 1) (Polyhash.listItems fg))
        val mergepoints = List.map (fn x => makeFunName cn mname x) mergepointsAux
	fun makecase (f,l) = "if f = " ^ (makeFunName cn mname f) ^ " then List.filter isMergePoint [" ^ listToString (fn x => makeFunName cn mname x) ", " (rev l) ^ "] else"
	val inv_dom = List.map makecase (FlowGraph.invertDoms dom)
    in (mergepoints,inv_dom)
    end

fun mymakeDefs cn mdefs = 
    let 
(*
        val () = TextIO.print ("CertGenP.mymakeDefs: maping over a list mdefs ="^
                    (List.foldl (fn (mds, s) => case mds of 
                                             MDEF(flags,rty,mname,params,mbody) => mname^",") 
                                "" 
                                mdefs)^"]\n")
*)
        val (MPs, DOMs) = List.foldl 
                        (fn mds => let val (x,y) = snd mds
                                       val (mps,doms) = (mymakeDefsAux cn (fst mds))
                                   in (x @ mps, y @ doms) end) ([],[]) mdefs
      
	val mergePoint_def = "isMergePoint_def: \"isMergePoint f == f \\<in> {" 
			     ^ listToString id ", " MPs
			     ^ "}\"\n"
	val dom_def = "dominates_def: \"dominates f == "
		      ^ (case DOMs of 
			    [] => "[]\""
			  | _ =>
			    "("
			     ^ listToString id "\n                 " DOMs
			     ^ " [])\"")
    in "defs" ^ newline ^ mergePoint_def ^ dom_def ^ newline
    end

fun makeMethName cn mname = ToyGrailAbsyn.unqual_name (cn ^ "'" ^ mname)

fun fixNames entry = List.foldl (fn ((s,s0),str) => GrailUtils.strReplace s s0 str) entry (!ToyGrailAbsyn.zz_map)

fun mk_SPECentry cn (MDEF(flags,rty,mname,params,body)) richTypes =
  case Binarymap.peek(richTypes,mname) of
     NONE => "No LFD type found for " ^ mname ^ ". Maybe LFD was not called?"
   | SOME entry =>
      "  if M = " ^ (makeMethName cn mname) ^ " then " ^ (fixNames entry) ^ " else" ^ newline

fun SPEC_Def cname mdecls richTypes =
  "defs SPEC_def: \" SPEC M == (" ^ newline ^ 
    listToString (fn mdec => mk_SPECentry cname mdec richTypes) "" mdecls ^
    "  (" ^ slash ^ "<lambda> E h hh v p . False))\"" ^ newline


(* fun mk_MethAxiomName cname mname = "Meth_" ^ cname ^ "'" ^ mname *)

fun mk_MethAxiomName cname mname = "Meth_" ^ (ToyGrailAbsyn.unqual_name (cname ^ "'" ^ mname))

(* fun mk_FunAxiomName cname mname funame = "Fun_" ^ cname ^ "'" ^ mname ^ "'" ^ funame *)
fun mk_FunAxiomName cname mname funame = "Fun_" ^ (ToyGrailAbsyn.unqual_name (cname ^ "'" ^ mname ^ "'" ^ funame))

fun ExtractMethName (MDEF(flags,rty,mname,params,body)) = mname

fun splitMname s = 
  let val L = String.tokens (fn x => x = #".") s
  in (case L of [cn,mn] => (cn,mn)
              | _ => ("??",s))    (* THIS USAGE OF A CLASSNAME ?? IS OF COURSE NONSENSE - should be an exception, but let's ask Kenneth how he creates names*)
  end

fun StringPairCompare ((s1,t1),(s2,t2)) = 
  case String.compare (s1,s2) of
   LESS => LESS
   | EQUAL => String.compare (t1,t2)
   | GREATER => GREATER

val emptycalls = (Binaryset.empty StringPairCompare, Binaryset.empty String.compare)

fun GetCallsPrimop (INVOKESTATICop(MDESC(rty,mname,argtypes),values)) = 
     let val (cn,mn) = splitMname mname
     in if (mn = "make" orelse
            mn = "free" orelse
            mn = "fill" orelse
            mn = "alloc") then emptycalls
        else (Binaryset.singleton StringPairCompare (cn,mn),
              Binaryset.empty String.compare)
     end
  | GetCallsPrimop _ = emptycalls
fun GetCallsLetDec (VALdec(v,p)) = GetCallsPrimop p
  | GetCallsLetDec (VOIDdec p)= GetCallsPrimop p
fun GetCallsLetDecs letdecs = 
  foldl (fn (ld,calls) => let val (m,f) = calls
                              val (cm,cf) = GetCallsLetDec ld
                          in (Binaryset.union (cm,m), Binaryset.union (cf,f)) end)
        emptycalls letdecs
fun GetCallsPrimres (OPres primop) = GetCallsPrimop primop
  | GetCallsPrimres VOIDres = emptycalls
  | GetCallsPrimres (FUNres(f,L)) = (Binaryset.empty StringPairCompare,
                                     Binaryset.singleton String.compare f)
fun GetCallsResult (PRIMres pres) = GetCallsPrimres pres
  | GetCallsResult (CHOICEres(v1,tst,v2,pr1,pr2)) = 
      let val (m1,f1) = GetCallsPrimres pr1
          val (m2,f2) = GetCallsPrimres pr2
      in (Binaryset.union(m1,m2),Binaryset.union(f1,f2)) end
  | GetCallsResult (CASEres(v,i,j,L)) = emptycalls
fun GetCallsFunDec (FDEC(fname,paramlist,FUNbody(letdecs,res))) = 
      let val (m1,f1) = GetCallsLetDecs letdecs
          val (m2,f2) = GetCallsResult res
      in (Binaryset.union(m1,m2),Binaryset.union(f1,f2)) end
fun GetCallsMBody (MBODY(letdecs,fundecs,res)) =
  let val (m1,f1) = GetCallsLetDecs letdecs
      val (m2,f2) = List.foldl (fn (fd,(m2,f2)) => let val (m1,f1) = GetCallsFunDec fd
                                                   in (Binaryset.union(m1,m2), Binaryset.union(f1,f2))
                                                   end)
                               emptycalls
                               fundecs
      val (m12,f12) = (Binaryset.union(m1,m2),Binaryset.union(f1,f2))
      val (m3,f3) = GetCallsResult res
  in (Binaryset.union(m12,m3),Binaryset.union(f12,f3)) end

fun mk_PdefsLemmas add_specdef cname (MDEF(flags,rty,mname,params,body)) = 
  let val calls = GetCallsMBody body
      val calledmethods = Binaryset.listItems(Binaryset.add(fst calls, (cname,mname)))
      val calledfunctions = Binaryset.listItems(snd calls)
      (* need to filter out Cameltolib methods! *)
      val funlemmas = GrailUtils.join #" " (List.map (fn x => mk_FunAxiomName cname mname x) calledfunctions)
      val methodlemmas =  GrailUtils.join #" " (List.filter (fn x => (not (x="xxx"))) (List.map (fn x => if ((fst x) = "Camelotlib") then "xxx" else mk_MethAxiomName (fst x) (snd x))  calledmethods))
  in (if add_specdef then "SPEC_def" else "") ^ " " ^ funlemmas ^ " " ^ (if add_specdef then methodlemmas else "") ^ newline
  end

fun myToStringTypedValue cnmn (INTty,VARval x) = let val h0z = ToyGrailAbsyn.lookup_short_name (cnmn ^ x) in "INarg " ^ h0z ^ "(*"^cnmn ^ x^"*)"^"(*"^h0z^"*)"(*--*)end
  | myToStringTypedValue cnmn (REFty s,VARval x) = let val h0z = ToyGrailAbsyn.lookup_short_name (cnmn ^ x) in "RNarg " ^ h0z ^ "(*"^cnmn ^ x^"*)"^"(*"^h0z^"*)"(*--*)end
  | myToStringTypedValue cnmn (ARRAYty s,VARval x) = let val h0z = ToyGrailAbsyn.lookup_short_name (cnmn ^ x) in "INarg " ^ h0z ^ "(*"^cnmn ^ x^"*)"^"(*"^h0z^"*)"(*--*)end (* Arrays needed for main etc *)(*--*)
  | myToStringTypedValue cnmn (_,VARval x) = (TextIO.print ("Weird type for VARval value in myToStringTypedValue for class_method "^cnmn^": VARval |"^x^"|\n"); ("INarg " ^ cnmn ^ x))
  | myToStringTypedValue cnmn (t,INTval i) = "VALarg " ^ (Int.toString i)
  | myToStringTypedValue cnmn (t,NULLval(s,ss)) = "VALarg (RVal Nullref)"
  (* ToDo: fix generation of var name for a String! Must match code in ToyGrailAbsyn -- HWL *)
  | myToStringTypedValue cnmn (t,STRINGval s) = "RNarg "^cnmn^"String'GenVar"
  | myToStringTypedValue cnmn _ = raise CertGenError ("Weird type in myToStringTypedValue for class_method "^cnmn^"\n")

(* for debugging only 
  | myToStringTypedValue cnmn (t,BYTEval i)  = (TextIO.print ("Weird type in myToStringTypedValue for class_method "^cnmn^": BYTEval "^(Int.toString i)^"\n") ; "ERROR")
  | myToStringTypedValue cnmn (t,SHORTval i) =(TextIO.print ("Weird type in myToStringTypedValue for class_method "^cnmn^": SHORTval "^(Int.toString i)^"\n"); "ERROR")
  | myToStringTypedValue cnmn (t,LONGval i) =(TextIO.print ("Weird type in myToStringTypedValue for class_method "^cnmn^": LONGval "^(Int.toString i)^"\n"); "ERROR")
  | myToStringTypedValue cnmn (t,CHARval i) = (TextIO.print ("Weird type in myToStringTypedValue for class_method "^cnmn^": CHARval "^(Int.toString i)^"\n") ; "ERROR")
  | myToStringTypedValue cnmn (t,FLOATval f) =(TextIO.print ("Weird type in myToStringTypedValue for class_method "^cnmn^": FLOATval "^(Real.toString f)^"\n"); "ERROR")
  | myToStringTypedValue cnmn (t,DOUBLEval r) = (TextIO.print ("Weird type in myToStringTypedValue for class_method "^cnmn^": DOUBLEval "^(Real.toString r)^"\n"); "ERROR")
*)


(*FLOAT and STRING not yet supported!*)

fun myToStringTypedValues cnmn = listToString (fn x => myToStringTypedValue cnmn x) ", "

(*Context_Entries: Given a method Grail method, first collect all 
  internal method invocations (form: (cn,mn,args)), then
  create one entry for each call*)
fun GetInvocationsPrimop myCMname (INVOKESTATICop(MDESC(rty,mname,argtypes),values)) = 
     let val (cn,mn) = splitMname mname
     in if (mn = "make" orelse
            mn = "free" orelse
            mn = "fill" orelse
            mn = "alloc") then []
      else let val typedvals = (GrailUtils.zip (argtypes,values))
           in [(cn,(*cn ^ "'" ^*) mn,myToStringTypedValues myCMname typedvals)]
           end
     end
  | GetInvocationsPrimop myCMname _ = []

fun GetInvocationsLetDec myCMname (VALdec(v,p)) = GetInvocationsPrimop myCMname p
  | GetInvocationsLetDec myCMname (VOIDdec p)= GetInvocationsPrimop myCMname p

fun GetInvocationsLetDecs myCMname letdecs = 
  foldl (fn (ld,invokes) => (GetInvocationsLetDec myCMname ld) @ invokes) [] letdecs
fun GetInvocationsPrimres myCMname (OPres primop) = GetInvocationsPrimop myCMname primop
  | GetInvocationsPrimres myCMname VOIDres = []
  | GetInvocationsPrimres myCMname (FUNres(f,L)) = []
fun GetInvocationsResult myCMname (PRIMres pres) = GetInvocationsPrimres myCMname pres
  | GetInvocationsResult myCMname (CHOICEres(v1,tst,v2,pr1,pr2)) = 
      (GetInvocationsPrimres myCMname pr1) @ (GetInvocationsPrimres myCMname pr2)
  | GetInvocationsResult myCMname (CASEres(v,i,j,L)) = []
fun GetInvocationsFunDec myCMname (FDEC(fname,paramlist,FUNbody(letdecs,res))) = 
  (GetInvocationsLetDecs myCMname letdecs) @ (GetInvocationsResult myCMname res)
fun GetInvocationsMBody myCMname (MBODY(letdecs,fundecs,res)) =
  (GetInvocationsLetDecs myCMname letdecs) @
  (foldl (fn (fd,invokes) => (GetInvocationsFunDec myCMname fd) @ invokes) [] fundecs) @
  (GetInvocationsResult myCMname res)

fun Context_Entries cname (MDEF(flags,rty,mname,params,body)) = 
   let val myCMname = (*- ToyGrailAbsyn.unqual_name -*) (cname ^ "'" ^ mname ^ "'")
       val invokes = GetInvocationsMBody myCMname body
       (* val _ = TextIO.print (String.concat (List.map ((fn (cn,mn,args) => "Context_Entries: found "^mn^"\n")) invokes)) *)
       
       val invokesStringlist = 
             List.filter (fn x => not (x = "xxx")) (* filter out lib fcts *)
               (List.map (fn (cn,mn,args) => 
                         let
                           val mname = ToyGrailAbsyn.unqual_name (cn ^ "'" ^ mn)
                         in
		            if (cn = "Camelotlib") (* not for lib fcts *)
			      then "xxx"
			      else "(" ^ cn ^ slash ^ "<bullet>" ^ mname ^
                                   "([" ^ args ^ "]), sMST " ^ cn ^ " " ^ mname ^ " [" ^ args ^ "]) "
                         end)
                         invokes)
   in 
     listToString (fn x => x) "," invokesStringlist
   end


fun reportTypes cname mdefs outDir richTypes = 
 let
   fun lfd2ty lfd mname = lfd
 in
  String.concat
   (List.map (fn MDEF(flags,rty,mname,params,body) => 
                case Binarymap.peek(richTypes,mname) of
		    NONE => "No LFD type found for " ^ mname ^ "\n"
                  | SOME entry => " " ^ mname ^ " :: " ^ lfd2ty entry mname ^ "\n") mdefs)

 end

fun nuke_magic_funs l = list_diff_with 
                   (fn (x,y) => case x of
                                 MDEF(flags,rty,mname,params,body) => mname=y)
                  l magic_funs

fun makeCert1 cname mdefs outDir richTypes (_ ,data_layout, tag_offset, v, tFlavour) = 
  let 
        val is_dia_class = (if (size cname) < 6 then false else String.extract(cname,(size cname)-6,NONE) = "$dia_0")
  in if is_dia_class then () else
    let val theoryname = cname ^ "Certificate"
        (* Take pre-defined functions out of mdefs list -- HWL *)
        val mdefs' = nuke_magic_funs mdefs

        (* val _ = (TextIO.print ("@@ makeCert1: filtered mdefs list is: "^(join #"," (map (fn x => case x of MDEF(flags,rty,mname,params,body) => mname) mdefs'))^"\n")) *)

        (* HWL: HACK-ish: set data layou as a pragma in the certificate; should be in Metadata! *)
        val s0 = ("(*# CERTGEN: " ^ cert_version ^" #*)" ^ newline ^
                  (if (!leak_detected) then "(*# MEMORY_LEAK: \"1\" #*)" ^ newline else "")^
                 "(*# LOGIC_VERSION: \"" ^ (Int.toString v) ^ "\" #*)" ^ newline ^
                 "(*# DATA_LAYOUT: \"" ^ (Int.toString data_layout) ^ "\" #*)" ^ newline ^
                 "(*# TAG_OFFSET: \"" ^ (Int.toString (tag_offset))) ^ "\" #*)" ^ newline
        
        (* sanity checks                
        val s01 = "constdefs logic_version :: int"^newline^"\"logic_version == " ^ (Int.toString v) ^ "\"" ^ newline ^
                 "constdefs tactic_flavour :: int"^newline^"\"tactic_flavour == " ^ (Int.toString tFlavour) ^ "\"" ^ newline ^
                 "constdefs data_layout :: int"^newline^"\"data_layout == " ^ (Int.toString data_layout) ^ "\"" ^ newline ^
                 "constdefs tag_offset :: int"^newline^"\"tag_offset == " ^ (Int.toString (tag_offset)) ^ "\"" ^ newline
        *)
        val s01 = newline
                        
        val wrapper_file = cname ^ ".cmlt.Wrap"
        fun getAll is acc = if TextIO.endOfStream is
                          then acc
                          else let val line = TextIO.inputLine is 
                                   val line0 = String.translate (fn c => if (ord c = 13 orelse ord c = 10) then "" else if (ord c = 92) then "\\" else if (ord c = 34) then "\"" else Char.toString c) line (* strip ^M ie. 0xd!! HWL *)
                               in getAll is (acc^line0^newline) end
        val s00 = if (Nonstdio.file_exists wrapper_file)
                    then let
                           val is = TextIO.openIn wrapper_file
		           val str = getAll is ""
                           val _ = TextIO.closeIn is
                         in
                           str
                         end
                    else "(* NO WRAPPER FOUND *)\n"
                      
        val s1 = "theory " ^ theoryname ^ " = " ^ cname ^ ":"^newline
        val s2 = newline 
                 (*let fun myprint (key,entry,soFar) = key ^ " " ^ entry ^ newline ^soFar
                 in Binarymap.foldl myprint "" richTypes  
                 end*)
        
        val s3 = mymakeDefs cname mdefs'
        val s4 = SPEC_Def cname mdefs' richTypes
        val s5 = let val entries0 = List.map (Context_Entries cname) mdefs'
                     val entries1 = listToString (fn x => x) ("," ^ newline) entries0
                 in  newline ^ "constdefs  Context:: vdmcontext" ^ newline ^ " \" Context == {" ^ entries1
                   ^ "}\" " ^ newline ^ newline
                 end
        val s7 = "lemmas dmp_defs = dominates_def isMergePoint_def" ^ newline ^
                 "lemmas ctxt_def  = Context_def" ^ newline
        val s8 = "lemmas meth_defs = SPEC_def " ^
                 (listToString (fn x => mk_MethAxiomName cname (ExtractMethName x)) " " mdefs')
        val s9 = listToString (fn x => "lemmas " ^ (case x of MDEF(flags,rty,mname,params,body) => mname) ^ "_pdefs = " ^ mk_PdefsLemmas true cname x) "" mdefs'
        val sa = "lemmas fun_defs = " ^ (listToString (fn x => mk_PdefsLemmas false cname x) "" mdefs') ^ newline

        (* optionally add logic-level types in comments to certificate 
        val sb = "(* " ^ newline ^ reportTypes cname mdefs' outDir richTypes ^ "*)" ^ newline
        val sc = "ML {* val global_v = 1 *}" ^ newline
        val sd = !reportedTypes
	*)
        val sb = ""
        val sc = ""
        val sd = ""
        val s = s0 ^ s00 ^ s1 ^ s2 ^ s01 ^ s3 ^ s4 ^ s5 ^ s7 ^ s8 ^ newline ^ s9 ^ newline ^ sa ^ newline ^ sb ^ newline ^ sc ^ newline ^ sd ^ newline ^ "end" ^ newline
        val fname = GrailUtils.makeFullFilename outDir theoryname "thy"
        val os = TextIO.openOut fname
        val () = TextIO.output(os,s)
        val () = TextIO.closeOut os
        (* strip ^M at end of lines; needed if run from web interface -- HWL *)
	val fname_tmp = fname^"-tmp"
        val _ = if Nonstdio.file_exists fname_tmp then FileSys.remove fname_tmp else ()
        val status =  Process.system ("cat " ^ fname ^ " | sed 's/^M$//' > " ^fname_tmp)
        val _ = FileSys.remove fname
        val _ = FileSys.rename {old=fname_tmp, new=fname}
        val () = printToStdErr ("Wrote "^fname^"\n")
    in
     () (* YUCK *)
    end
  end
