//import priorityQueue;

/* 
 *  File: priorityQueueTest.java
 */


class myTest {
  /*
     Klasse zum Testen von Vorrangswarteschlangen.
     Eingabe: Eine Folge von Schluesseln, die in die Vorrangswarteschlange
              eingefuegt werden. 
     Ausgabe: Darstellung der Folge von Vorrangswarteschlange, die man durch
              iteriertes Einfuegen und Loeschen des Minimums bei jedem
	      4. Element sowie einer decreaseKey Operation bei jedem
	      5. Element erhaelt.

     Die Klasse ist vollstaendig unabhaengig von der Implementation
     der Vorrangswarteschlange  
  */


  public static fibonacciHeap Q;

  public static void main(String args[]){
    Q = new fibonacciHeap();
    if (args.length != 0) {
      
      /* Array zum Speichern aller eingefuegten Knoten */
      int [] A = new int [args.length];

      /* fuege alle Schluessel in das Array A ein */
      for (int i = 0; i < args.length; i++) 
	A[i] = Integer.valueOf(args[i]).intValue();
      test(A);
    }
  }

  public static void test (int [] A) {
    /* Array zum Speichern aller eingefuegten Knoten */
    fibonacciNode [] C = new fibonacciNode [A.length];
    
    for (int i = 0; i < A.length; i++) {
      /* fuege alle Schluessel in die Vorrangwarteschlange ein */
      C[i] = new fibonacciNode (A[i]);
      C[i] = Q.insert((fibonacciNode)C[i]);
      Q.print();
      
      /* jedes 4. Element: deleteMin */
      if ((i+1) % 4 == 0) {
	fibonacciNode min = (fibonacciNode)Q.deleteMin();
	System.out.println("Minimum = "+min.key);

	/* Fuege das Element wieder ein */
	int k = 0;
	/* Finde C[k] mit C[k].key = key */
	while (C[k] != null && C[k].key != min.key) k++;
	C[k] = Q.insert(C[k]);
	Q.print();
      }
      
      /* jedes 5. Element: decreaseKey */
      if ((i+1) % 5 == 0) {
	System.out.print("Decrease key "+i+" from "+C[i].key+" to ");
	System.out.println(C[i].key - 10); 
	Q.decreaseKey(C[i].key - 10, C[i]);
	Q.print();
      }
    }

    int i = 0;
    System.out.print("Decrease key "+i+" from "+C[i].key+" to ");
    System.out.println(C[i].key - 35); 
    Q.decreaseKey(C[i].key - 35, C[i]);
    Q.print();
    
    /* Entferne dreimal das Minimum */
    fibonacciNode min = Q.deleteMin();
    System.out.println("Minimum = "+min.key);
    Q.print();
    min = Q.deleteMin();
    System.out.println("Minimum = "+min.key);
    Q.print();
    min = Q.deleteMin();
    System.out.println("Minimum = "+min.key);
    Q.print();
  }
}


