#!/usr/bin/env perl
# Time-stamp: <Fri Jan 31 2003 14:50:57 hwloidl>
###########################################################################
# Install the files needed for the demo in the "live" dir of the web server
# ToDo: 
#  install .html files too
#  wipe dirs if they exist?
#############################################################################

use File::Basename;

$cvs_root = "/home/mrg"; # root for cvs checkout; must contain mrg/progs/Demo...
#$live_dir = "/tmp/foo";
$user="mrg";
$live_bindir = "/usr/local/apache2/cgi-bin/mrg";
$live_dir = "/home/mrg/public_html";
$setup_file = "/tmp/demo-setup.pl";

open (O,">$setup_file") or die "Cannot open $setup_file: $!\n";

# Dirs in the CVS repository:
$cvs_code_dir="$cvs_root/mrg/progs/Demo/cgi-dat/code";
$cvs_dat_dir="$cvs_root/mrg/progs/Demo/cgi-dat/code/test";
#$cvs_upload_dir="$cvs_root/mrg/progs/Demo/cgi-dat/code/users";
$cvs_code_dir="$cvs_root/mrg/progs/Demo/cgi-dat/code";
$cvs_ourcode_dir="$cvs_root/mrg/progs/Demo/cgi-dat/code/ours";
$cvs_proof_dir="$cvs_root/mrg/progs/Demo/cgi-dat/isabelle";
$cvs_java_dir="$cvs_root/mrg/progs/Demo/cgi-dat/code/java-bin";
$cvs_camelot_dir="$cvs_root/mrg/progs/Demo/cgi-dat/code/camelot-bin";
#$cvs_log_dir="$cvs_root/mrg/progs/Demo/cgi-dat/log";
$cvs_skel_dir="$cvs_root/mrg/progs/Demo/cgi-dat/isabelle/skel";

# Build the required dir structure:
$code_dir="$live_dir/cgi-dat/code";
$dat_dir="$live_dir/cgi-dat/code/test";
$upload_dir="$live_dir/cgi-dat/code/users";
$ours_dir="$live_dir/cgi-dat/code/ours";
$proof_dir="$live_dir/cgi-dat/isabelle";
$java_dir="$live_dir/cgi-dat/code/java-bin";
$camelot_dir="$live_dir/cgi-dat/code/camelot-bin";
$log_dir="$live_dir/cgi-dat/log";
#
$skel_dir="$live_dir/cgi-dat/isabelle/skel";
$wrk_dir="$live_dir/cgi-dat/isabelle/tmp";
$thy_dir = "$live_dir/cgi-dat/thy";

# should use mkdirhier....
print "Checking whether dirs exist ...\n";
mkdir $live_dir    if ! -d $live_dir; 
mkdir "$live_dir/cgi-dat"    if !-d "$live_dir/cgi-dat";
mkdir "$code_dir"            if !-d "$code_dir";
mkdir $dat_dir    if ! -d $dat_dir;
mkdir $upload_dir    if ! -d $upload_dir;
mkdir $ours_dir    if ! -d $ours_dir;
mkdir $proof_dir    if ! -d $proof_dir;
mkdir $java_dir    if ! -d $java_dir;
mkdir $log_dir    if ! -d $log_dir;

print O <<EOF;

\$dat_dir="$dat_dir";
\$upload_dir="$upload_dir";
\$proof_dir="$proof_dir";
\$java_dir="$java_dir";
\$log_dir="$log_dir";
EOF

&copy_dir($cvs_dat_dir,$dat_dir);
&copy_dir($cvs_ourcode_dir,$ours_dir);
&copy_dir($cvs_camelot_dir,$camelot_dir);
&copy_dir($cvs_java_dir,$java_dir);
#&copy_dir($cvs_proof_dir,$proof_dir);
system("cp -R $cvs_proof_dir/* $proof_dir/."); 

# Where to find the programs that we need: gdf gdf2thy isabelle
$l = qx(/bin/sh -c 'which isabelle-process');
# print ">>$l<<";
chomp $l;
$isa_dir = dirname($l);
$isa_prg = basename($l);

print O <<EOF;
\$isa_dir = "$isa_dir";
\$isa_prg="isabelle-process";
\$gdf_prg="gdf2thy";
\$root_file="ROOT.ML";
\$log_file="mrg1-\$\$.log";
\$out_file="mrg1-\$\$.isa";
EOF

if ( -f "$proof_dir/Grail.img" ) {
  print O <<EOF;
  # an Isabelle "image" with the Grail operational semantics
  \$isa_heap="/usr/local/apache2/cgi-dat/isabelle/Grail.img";
EOF
} else {
  print "Cannot find $proof_dir/Grail.img!! Phps copy it from glory:~a1hloidl/Grail.img\n" ;
  print " and add \$isa_heap=\"<wherever-you-put-it>/Grail.img\" to your setup file $setup_file\n";
}

mkdir $skel_dir   if ! -d $skel_dir;
mkdir $wrk_dir    if ! -d $wrk_dir;
mkdir $thy_dir    if ! -d $thy_dir;

&copy_dir($cvs_skel_dir,$skel_dir);

print O <<EOF;
# used in mk_rootML to generate Isabelle files
\$skel_dir="$skel_dir";
\$wrk_dir="$wrk_dir";
\@skel_files = ("GrailAbsyn.thy", "GrailDynSem.thy", "GrailState.thy", "GrailMisc.thy");

# NB: $dat_file is set in process_params reading a field from the form
\$thy_dir="$thy_dir";
EOF

$cvs_bindir = "$cvs_root/mrg/progs/Demo/cgi-bin";
$bindir="$live_bindir"; # "$live_dir/cgi-bin";

mkdir "$bindir" if ! -d "$bindir";
chdir $cvs_bindir;
system("cp demo*.pl do_*pl *.pm *cgi $bindir");

chdir $bindir;
system("chmod a+x *");
unlink "demo-setup.pl" if -f "demo-setup.pl";
unlink "path_module.pl" if -f "path_module.pl";
system("ln -s demo-setup-romulus.pl demo-setup.pl");
system("ln -s path_module-romulus.pm path_module.pm");

$cvs_htmldir = "$cvs_root/mrg/progs/Demo/Htmls";
$htmldir="$live_dir/mrg";

mkdir "$htmldir" if ! -d "$htmldir";
chdir $cvs_htmldir;
system("cp *.html *.css *.png  $htmldir");

chdir "$code_dir";
system ("chmod -R 777 *");

chdir "$proof_dir";
system ("chmod -R 777 *");

close O;

exit ;

# ---------------------------------------------------------------------------0

sub copy_file {
    local ($from,$to) = @_;

    open (FROM,"<$from") or die("copy_file: cannot open from file $from: $!");
    open (TO,">$to") or die("copy_file: cannot open to file $to: $!");
    while (<FROM>) {
	print TO;
    }
    close (FROM);
    close (TO);
}

# ---------------------------------------------------------------------------

sub copy_dir {
 local ($from_dir,$to_dir)  = @_;

 opendir(DIR,"$from_dir") or die("copy_dir: Cannot open dir $from_dir: $!");
 #print "<p>Deleting all files in dir $dir:<br>\n" if $debug_it;
 @files = readdir(DIR);
 foreach $x (@files) {
     next if $x eq "." || $x eq ".." || $x eq "CVS";
     &copy_file("$from_dir/$x","$to_dir/$x");#  unless $dry_run;
     print ".. $from_dir/$x --> $to_dir/$x\n" if 1;
 }
 # print "</ul>\n";
 closedir(DIR);
}

