theory GrailMisc = GrailDynSem:

subsubsection "Predicates over Resource Consumption"

(* Versions working on GrailAbsyn.MethodBody; that's the one used for testing *)
constdefs 
  needsTimeM :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTimeM \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) = n))"

  boundedTimeM :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeM \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) <= n))"

  needsTimeWithStateM :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTimeWithStateM \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') = n))"

  boundedTimeWithStateM :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeWithStateM \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') <= n))"

  boundedTimeVM :: "Value \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeVM \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>) & (clock s) <= n))"

(* same predicates but over GrailAbsyn.Progz this time *)
constdefs 
  needsTime :: "Progz \<Rightarrow> Time \<Rightarrow> bool"
 "needsTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>0 \<langle>v,s\<rangle>) & (clock s) = n))"

  boundedTime :: "Progz \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>0 \<langle>v,s\<rangle>) & (clock s) <= n))"

  needsTimeWithState :: "State \<Rightarrow> Progz \<Rightarrow> Time \<Rightarrow> bool"
 "needsTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>0 \<langle>v,s'\<rangle>) & (clock s') = n))"

  boundedTimeWithState :: "State \<Rightarrow> Progz \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>0 \<langle>v,s'\<rangle>) & (clock s') <= n))"

  boundedTimeV :: "Value \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeV \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>) & (clock s) <= n))"

end

