theory GrailExamples = GrailDynSem:

section "Predicates over Resource Consumption"

constdefs 
  needsTime :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) = n))"

  boundedTime :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) <= n))"

  needsTimeWithState :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') = n))"

  boundedTimeWithState :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') <= n))"

  boundedTimeV :: "Value \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeV \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>) & (clock s) <= n))"

section "foo"

text {*
Simple example mainly testing function call.
Same as foo in CoreGrailExamples but now for methods rather than functions.


 invokestatic rootClass.foo ()

 foo () {
  let 
    () = 1
  in 
    2
*}

consts foo :: "Mname"

constdefs fooRes :: "Result"
"fooRes \<equiv> PRIMres (OPres (INVOKESTATICop (MDESC INTty rootClass foo []) EMPTYvar))"

constdefs fooCall :: "MethBody"
"fooCall \<equiv> MBODY
                         EMPTYdec
                         EMPTYfundec
                         fooRes"

constdefs fooBody :: "MethBody"
"fooBody \<equiv> MBODY
                (FULLdec (VOIDdec (VALop (INTval 1))) EMPTYdec) 
                EMPTYfundec
                (PRIMres (OPres (VALop (INTval 2))))"

constdefs fooMeth :: "Methd"
"fooMeth \<equiv> (| res = INTty, args = EMPTYal, bdy = fooBody, funs = empty |)"

constdefs fooHeap :: "Heap"
"fooHeap \<equiv>  
   emptyHeap"

constdefs fooMStore :: "MethodStore"
"fooMStore \<equiv>  
   let myMMap = empty(foo \<mapsto> fooMeth)
   in let cd = \<lparr> super = rootClass, flds = empty, vars = empty, mthds = myMMap \<rparr>
   in emptyMStore ( rootClass \<mapsto> cd )"

(* MUST use this def, without let, to make proof work *)
constdefs fooMStore2 :: "MethodStore"
"fooMStore2 \<equiv>  
   emptyMStore ( rootClass \<mapsto> \<lparr> super = rootClass, flds = empty, vars = empty, mthds = empty(foo \<mapsto> fooMeth) \<rparr> )"

constdefs fooState :: "State"
"fooState \<equiv> emptyState \<lparr> heap := fooHeap, methodStore := fooMStore \<rparr>"

constdefs fooState2 :: "State"
"fooState2 \<equiv> emptyState \<lparr> heap := fooHeap, methodStore := fooMStore2 \<rparr>"

section "Resource properties"

(* Code: \<lambda> () . 2 *)
(* Comment: a very verbose proof, explicitly naming all rules of the dyn sem *)

lemma a1: "methodStore fooState = fooMStore"

apply (unfold fooState_def)
apply (simp)
done

lemma a2: "methodStore fooState2 = fooMStore2"

apply (unfold fooState2_def)
apply (simp)
done

(* lemma "cn : dom ms ==> get_method s cn mn \<noteq> None" *)

lemma b1: "get_method fooState2 rootClass foo = fooMeth"

apply (unfold get_method_def)
apply (simp add: a2)
apply (unfold fooMStore2_def)
apply (simp)
done

lemma "boundedTimeWithState fooState2 fooCall  10"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (unfold fooCall_def)
apply (rule conjI)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (unfold fooRes_def)
apply (rule PRIMres)
apply (rule OPres)
apply (rule INVOKESTATICop)
apply (unfold grab_mdesc_def)
apply (simp_all)
apply (rule conjI)
apply (simp_all)
apply (simp add: b1)
apply (unfold fooMeth_def)
apply (simp)
apply (unfold fooBody_def)
apply (rule MBODY)
defer 1
apply (rule FULLdec)
apply (rule VOIDdec)
apply (rule VALop)
apply (rule INTval)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule VALop)
apply (rule INTval)
apply (unfold fooState2_def)
apply (simp_all)
apply (simp add: tick_def)
done
(* OK *)

end