theory c2 = GrailDynSem:

section "Predicates over Resource Consumption"

constdefs 
  needsTime :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) = n))"

  boundedTime :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) <= n))"

  needsTimeWithState :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') = n))"

  boundedTimeWithState :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') <= n))"

  boundedTimeV :: "Value \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeV \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>) & (clock s) <= n))"

section "Example programs"

subsection "Function Calls"

(* Code:    (\<lambda> (). 2) () *)
(* Comment: A Lemma over time consumption of evaluation *)

consts c2 :: "Fname"
consts c2M :: "Mname"

constdefs c2Res :: "Result"
"c2Res \<equiv> PRIMres (FUNres c2 EMPTYvar)"

constdefs c2Call :: "FunBody"
"c2Call \<equiv> FUNbody 
                         EMPTYdec
                         c2Res"

constdefs c2Fun :: "FunBody"
"c2Fun \<equiv> FUNbody 
                (FULLdec (VOIDdec (VALop (INTval 1))) EMPTYdec) 
                (PRIMres (OPres (VALop (INTval 2))))"

constdefs c2MBody :: "MethBody"
"c2MBody \<equiv> (MBODY 
                    EMPTYdec 
                    EMPTYfundec 
                    (PRIMres (FUNres c2 EMPTYvar)))"

constdefs c2Mthd :: "Methd"
"c2Mthd \<equiv> \<lparr> res = INTty, args = EMPTYal, bdy = c2MBody, funs = empty(c2 \<mapsto> (EMPTYal, c2Fun)) \<rparr>"

constdefs c2Heap :: "Heap"
"c2Heap \<equiv>  emptyHeap"

(* MUST use this def, without let, to make proof work *)
constdefs c2MStore2 :: "MethodStore"
"c2MStore2 \<equiv>  
   emptyMStore ( rootClass \<mapsto> \<lparr> super = rootClass, flds = empty, vars = empty, mthds = empty(c2M \<mapsto> c2Mthd) \<rparr> )"

constdefs c2State2 :: "State"
"c2State2 \<equiv> emptyState \<lparr> heap := c2Heap, methodStore := c2MStore2 \<rparr>"

section "Resource lemmas"

lemma c2_b1: "get_method c2State2 rootClass c2M = c2Mthd"

apply (unfold get_method_def)
apply (unfold c2State2_def)
apply (simp)
apply (unfold c2MStore2_def)
apply (simp)
done

lemma c2_b2: "get_funbody2 c2State2 rootClass c2M c2 = c2Fun"

apply (unfold get_funbody2_def)
apply (unfold c2State2_def)
apply (simp)
apply (unfold c2MStore2_def)
apply (simp)
apply (unfold c2Mthd_def)
apply (simp)
done

(* A resource lemma over code including function calls *)
lemma "boundedTimeWithState c2State2 
        (MBODY 
          EMPTYdec 
          EMPTYfundec 
          (PRIMres (OPres (INVOKESTATICop (MDESC INTty rootClass c2M []) EMPTYvar)))) 
       10"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule INVOKESTATICop)
apply (unfold grab_mdesc_def)
apply (simp_all)
apply (rule conjI)
apply (simp_all)
apply (simp add: c2_b1)
apply (unfold c2Mthd_def)
apply (simp)
apply (unfold c2MBody_def)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule FUNres)
apply (unfold get_funbody2_def)
apply (simp add: c2_b2)
apply (unfold c2State2_def)
apply (simp add: c2_b2)
apply (unfold c2MStore2_def)
apply (simp add: c2_b2)
apply (unfold c2Mthd_def)
apply (simp add: c2_b2)
apply (unfold c2Fun_def)
apply (rule FUNbody)
defer 1
apply (rule FULLdec)
apply (rule VOIDdec)
apply (rule VALop)
apply (rule INTval)
apply (simp)
apply (rule EMPTYdec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule VALop)
apply (rule INTval)
apply (simp_all)
apply (simp_all add:tick_def)
done
(* OK *)

end