theory GrailDynSem = GrailState:

consts evalBOP :: "BinOp => RTVal => RTVal => RTVal"

primrec
"evalBOP binop N M = 
  (case N of (rtInt n) => 
   (case N of (rtInt m) =>
    ( case binop of ADDop => rtInt (n + m)
                  | SUBop => rtInt (n - m)
                  | MULop => rtInt (n * m)
    )))"

consts evalValue :: "valEnv => Value => RTVal"
primrec
"evalValue E (VARval x) = E x"
"evalValue E (INTval i) = rtInt i"
"evalValue E (STRINGval s) = rtString s"
"evalValue E (NULLval s) = rtRef nullRef"

consts getObject:: "RTVal => Heap => obj"
primrec
"getObject (rtRef ref) H = 
  ( case ref of (locRef l) => H l )"

consts evalPrimop :: "valEnv => Heap => closEnv => PrimOp => (RTVal * Heap)"
primrec
"evalPrimop E H S (VALop v) = (evalValue E v,H)"
"evalPrimop E H S (BINop b v w) =
  (evalBOP b (evalValue E v) (evalValue E w), H)" 
"evalPrimop E H S (GETFIELDop x flddescr) =
  ( let (Class, fields) = getObject (E x)
    in case flddecrs of (FDESC tp classname fldname) => 
         ( case tp of (REFty cname) => fields(fldname,classname)
         )
  )"

  (* -- omitted: check cname against classname*)

primrec
"getObject (rtRef ref) H = 
  ( case ref of (locRef l) => H l )"

consts evalPrimop :: "valEnv => Heap => closEnv => PrimOp => (RTVal * Heap)"
primrec
"evalPrimop E H S (VALop v) = (evalValue E v,H)"
"evalPrimop E H S (BINop b v w) =
  (evalBOP b (evalValue E v) (evalValue E w), H)" 
"evalPrimop E H S (GETFIELDop x flddescr) =
  ( let (Class, fields) = getObject (E x)
    in case flddecrs of (FDESC tp classname fldname) => 
         ( case tp of (REFty cname) => 
            (*omitted: check cname against classname!*)
            fields(fldname,classname)
         )
  )"

consts getObject:: "RTVal => Heap => obj"
primrec
"getObject (rtRef ref) H = 
  ( case ref of (locRef l) => H l )"

(*more to follow...*)

consts evalPrimres :: "valEnv => Heap => closEnv => PrimRes => (RTVal * Heap)"


consts evalCall :: "closEnv => Heap => valEnv => Var list => valEnv => Var list => LetDec list => 
                    Result => (RTVal * Heap)" 
consts evalFunbody :: "valEnv => Heap => closEnv => FunBody => (RTVal * Heap)"
consts evalLetdec :: "valEnv => Heap => closEnv => LetDec => (valEnv * Heap)"
consts evalResult :: "valEnv => Heap => closEnv => Result => (RTVal * Heap)"
consts evalTest :: "RTVal => Test => RTVal => bool"
primrec
"evalLetdec E H S (VALdec x primop) = (let (v,Hprime) = evalPrimop E H S primop 
                                       in (E_update E x v, Hprime))"
"evalLetdec E H S (VOIDdec primop) = (let (v,Hprime) = evalPrimop E H S primop 
                                     in (E,Hprime))"
primrec
"evalResult E H S (PRIMres pres) = evalPrimres E H S pres"
"evalResult E H S (CHOICEres v1 tst v2 pres1 pres2) = 
  ( if (evalTest (evalValue E v1) tst (evalValue E v2)) 
    then evalPrimres E H S pres1
    else evalPrimres E H S pres2
  )"
primrec
"evalPrimres E H S (OPres primop) = evalPrimop E H S primop"
"evalPrimres E H S VOIDres = (rtVoid, H)"
"evalPrimres E H S (FUNres f xs) = 
  ( let (Eprime,ys,body,res) = S f
    in evalCall S H E xs Eprime ys body res
  )"

primrec 
"evalCall S H E xs Eprime ys body res =
  ( case xs of 
      [] => (case ys of [] => (evalFunbody (Eprime,H) S (FUNbody body res)))
    | x # restX => (case ys of 
                      (y # restY) => (evalCall S H E restX (E_update Eprime y (E x)) restY body res))
  )"

(*what kind of equality for references -- type loc_ ??*)
primrec 
"evalTest (intVal A) EQUALStest (intVal B) = (if A=B then True else False)"
"evalTest (rtRef R1) EQUALStest (rtRef R2) = (if (R1 = R2) then True else False)"
"evalTest X EQUALStest Y = False"


primrec 
"evalFunbody E H S (FUNbody letdecs res) = 
  ( case letdecs of 
      [] => evalResult E H S res
    | (letdec # lets) => ( let (Eprime,Hprime) = evalLetdec E H S letdec
                           in evalFunbody Eprime Hprime S (FUNbody lets res)
                         )
  )"

end