theory ToyList = PreList:

datatype 'a list = Nil
                 | Cons 'a "'a list"

consts app :: "'a list => 'a list => 'a list"  (infixr "@" 65)
       rev :: "'a list => 'a list"


primrec
"Nil @ ys = ys"
"(Cons x xs) @ ys = Cons x (xs @ ys)"

primrec
"rev Nil = Nil"
"rev (Cons x xs) = (rev xs) @ (Cons x Nil)"

lemma app_Nil2 [simp]: "xs @ Nil = xs"
apply (induct_tac xs)
apply (auto)
done

lemma app_assoc [simp]: "(xs @ ys) @ zs = xs @ (ys @ zs)"
apply (induct_tac xs)
apply (auto)
done

lemma rev_app [simp]: "rev (xs @ ys) = (rev ys) @ (rev xs)"
apply (induct_tac xs)
apply(auto)
done

theorem rev_rev [simp]: "rev (rev xs) = xs"
apply (induct_tac xs)
apply (auto)
done

end
