theory State = Absyn:

text {* Locations, i.e.\ abstract references to objects *}
typedecl  loc

datatype Reference = nullRef | locRef "loc"

datatype RTVal = rtVoid | rtBool "bool" | rtInt "int" | rtString "string" | rtRef "Reference"

types 
  Fields = "Vname ~=> RTVal"
(*  Fields = "Fname \<leadsto> RTVal" *)(* field name, defining class, value *)
  Obj = "Cname * Fields" (*class instance with class name and fields*)

  (* Vname now in CoreGrailAbsSyn.thy; was: Vname = "string"   *)
  (* now: heap component in State; was: ClosEnv = "Fname => (ValEnv * Var list * LetDec list * Result)" *)
  (* now: locals component in State; was: ValEnv = "Var => RTVal" *)

text {* private: *}
types   ObjHeap   = "loc ~=> Obj"  (* lenb 01/12/2002 *)
        Locals = "Vname \<leadsto> RTVal" 
        Heap = "Fname \<leadsto> (ArgList * FunBody)"  (* for Core Grail *)

text {* For now time and size are both measured in plain nats. For time we could
        use a table mapping instructions to frequencies instead *}
types   Time = nat
        HeapSz = nat

text {* private: *}
record  State
        = oheap  :: ObjHeap (* lenb 01/12/2002 *)
          heap   :: Heap
          locals :: Locals
          clock  :: Time
          heapsz :: HeapSz          

(* lenb 01/12/2002: component oheap added in State *)
translations
  "Fields" \<leftharpoondown> (type)"Vname => RTVal option"
  "Obj"    \<leftharpoondown> (type)"Cname * Fields"
  "State"  \<leftharpoondown> (type)"(|oheap :: ObjHeap, heap :: Heap, locals :: Locals, clock :: Time, heapsz :: HeapSz|)"

(*lenb 01/12/2002: changed Fname to Vname in field*)
consts
  method :: "Cname => (Mname \<leadsto> MethodBody)" 
(*  field  :: "Cname => (Fname \<leadsto> Ty)" *)
  field  :: "Cname => (Vname \<leadsto> Ty)"

constdefs 
  body :: "Cname * Mname => MethodBody"  
 "body \<equiv> \<lambda>(C,m). the (method C m)" 

constdefs  
  init_vars:: "('a \<leadsto> 'b) => ('a \<leadsto> RTVal)"  
 "init_vars m \<equiv> option_map (\<lambda>T. rtRef nullRef) o m" 
 
constdefs
  (* set state to "empty" *) 
  del_locs     :: "State => State"
 "del_locs s \<equiv> s (| locals := empty, clock := 0, heapsz := 0 |)"

  (* BUGGY *)
  (* initialise with values from another state 
  init_locs     :: "Cname => Mname => State => State"
 "init_locs C m s )6 s (| locals := locals s ++ -A
                         init_vars (map_of (lcl (the (method C m)))) |)"
  *)

constdefs
  (* juggling with locations *)
  set_locs  :: "State => State => State"
 "set_locs s s' \<equiv> s' (| locals := locals s |)"

constdefs
  get_local     :: "State => Vname => RTVal" ("_<_>" [99,0] 99)
 "get_local s x \<equiv>  the ((locals s) x)"

constdefs
  get_body :: "Fname => State => FunBody"
 "get_body f s \<equiv> snd (the (heap s f))"

(*
 "get_body f s \<equiv> case snd (the (heap s f)) of 
                   FUNbody decs res => (decs,res)"
*)
--{* local function: *}

(*lenb 01/12/2002: get_obj adapted to oheap*)
constdefs 
  get_obj       :: "State => loc => Obj" 
(* "get_obj s a \<equiv> the (heap s a)"*)
  "get_obj s a \<equiv> the (oheap s a)"

(*lenb 01/12/2002*)
constdefs 
  upd_obj    :: "loc => Vname => RTVal => State => State"  
(* "upd_obj a f v s \<equiv> let (C,fs) = the (heap s a) in hupd(a\<mapsto>(C,fs(f\<mapsto>v))) s"*)
  "upd_obj a f v s \<equiv> let (C,fs) = the (oheap s a) in
                     s (|oheap := (oheap s)(a |-> (C,fs (f |-> v)))|)"

constdefs 
  obj_class     :: "State => loc => Cname" 
 "obj_class s a \<equiv> fst (get_obj s a)"

  get_field     :: "State => loc => Vname => RTVal"
 "get_field s a f \<equiv> the (snd (get_obj s a) f)"

  put_field     :: "State => loc => Vname => RTVal => State"
 "put_field s a f v \<equiv> upd_obj a f v s"

(*lenb 01/12/2002: use oheap - no initialisation yet*)
constdefs 
  new_obj    :: "loc => Cname => State => State" 
(* "new_obj a C \<equiv> hupd (a \<mapsto> (C,init_vars (field C)))" *)
  "new_obj a C s \<equiv> s (| oheap := (oheap s)(a |-> (C, % fn. None)) |)"

(*lenb 01/12/2002*)
(*constdefs 
  new_Addr      :: "State => RTVal"
 "new_Addr s == rtRef (SOME v. (\<exists>r. v = locRef r )6 (heap s) r = None) | v = nullRef)"

*)
constdefs
  newAddr :: "State => Reference"
 "newAddr s \<equiv> (SOME r. (\<exists> a. r = locRef a \<and> oheap s a = None)  | r = nullRef)"

constdefs
(* local function: *)
 (* Version for full Grail 
  hupd       :: "loc => Obj => State => State"   ("hupd'(_|->_')" [10,10] 1000)
 "hupd a obj s \<equiv>  s (| heap   := ((heap   s)(a\<mapsto>obj))|)"
 *)
  hupd       :: "Fname => ArgList => FunBody => State => State"  ("hupd' (_|->_,_) _")
 "hupd fname arglist b s \<equiv> s \<lparr> heap   := ((heap   s)(fname\<mapsto>(arglist,b)))\<rparr>"

constdefs
  lupd       :: "Vname => RTVal => State => State"              ("lupd' (_|->_) _")
 "lupd x v s \<equiv> s \<lparr> locals := ((locals s)(x\<mapsto>v  ))\<rparr>"

syntax (xsymbols)
  hupd       :: "loc => Obj => State => State"   ("hupd'(_\<mapsto>_')" [10,10] 1000)
  lupd       :: "Vname => RTVal => State => State" ("lupd'(_\<mapsto>_')" [10,10] 1000)

constdefs
  tick :: "State => State"
 "tick s \<equiv> s (| clock := (clock s)+1 |)"

  elapsedTime :: "State => Time => bool"
 "elapsedTime s c \<equiv> clock s = c"

  requiredHeap :: "State => HeapSz => bool"
 "requiredHeap s z \<equiv> heapsz s = z"
  
(* Initial settings for environments *)

constdefs emptyLocals ::"Locals"
"emptyLocals \<equiv> (% x . None)"

constdefs emptyHeap :: "Heap"
"emptyHeap \<equiv> (% l . None)"

(*lenb 01/12/2002*)
constdefs emptyObjHeap :: "ObjHeap"
"emptyObjHeap \<equiv> (% l . None)"

(*lenb 01/12/2002: added oHeap component*)
constdefs emptyState :: "State"
"emptyState \<equiv> \<lparr> oheap = emptyObjHeap, heap = emptyHeap, locals = emptyLocals, clock = 0, heapsz = 0 \<rparr>"


lemma [simp]:
  "clock emptyState = 0"
apply (unfold emptyState_def)
(*apply (simp add:CoreGrailState.State.clock_update_def)*)
apply (simp add:State.State.clock_update_def)
done

lemma get_body_nodec:
  "!! f. !! s. get_body f s = get_body f (s (| locals := empty |))"
apply (unfold get_body_def)
apply (simp)
done

end