(*Third example for foundational SL verfication.
  Program: L = new List
           putfield L head 2
           putfield L tail nil
           M = new List
           putfield M head 1
           putfield M tail L
  fulfills forever...
*)

theory SL_Ex3 = Seplogic:

consts LIST :: "Cname"

consts is_LIST_object:: "Obj => bool"
primrec
"is_LIST_object (cname,fields) = (cname = LIST)"

consts L :: "Vname"
consts M :: "Vname"

consts head :: "Vname"
constdefs headDesc :: "FieldDesc"
"headDesc == FDESC INTty head"

consts tail :: "Vname"
constdefs tailDesc :: "FieldDesc"
"tailDesc == FDESC (REFty LIST) tail"

constdefs One :: "Value"
"One == INTval (int 1)"
constdefs Two :: "Value"
"Two == INTval (int 2)"

constdefs NIL_LIST :: "Value"
"NIL_LIST == NULLval LIST"

constdefs PROG:: "LetDecs" 
"PROG == FULLdec (VALdec L (NEWop LIST)) 
        ( FULLdec (VOIDdec (PUTFIELDop L headDesc Two))
          ( FULLdec (VOIDdec (PUTFIELDop L tailDesc NIL_LIST))
            ( FULLdec (VALdec M (NEWop LIST)) 
              ( FULLdec (VOIDdec (PUTFIELDop M headDesc One))
                ( FULLdec (VOIDdec (PUTFIELDop M tailDesc (VARval L)))
                  EMPTYdec )))))"

consts HS::"nat => ass"
primrec
"HS 0 s = emp s"
"HS (Suc n) s = (EX l obj. (star (single l obj) (HS n) s))" 
consts HSmax::"nat => ass"
primrec
"HSmax 0 s = emp s"
"HSmax (Suc n) s = ((HS (Suc n) s) | (HSmax n s))"

lemma HSmaxMonotone: "HSmax n s --> HSmax (Suc n) s"
apply(auto)
done

consts forever::"LetDecs => ass => ass"
primrec
"forever EMPTYdec phi s = (phi s)"
"forever (FULLdec ld lds) phi s =
  (phi s &
  (ALL rtv t. ((ld,s,rtv,t) : eval_LetDec --> forever lds phi t)))" 

constdefs PHI::"ass"
"PHI == forever PROG (HSmax (Suc (Suc 0))) "

lemma newAddrD: 
"(newAddr s = r) \<Longrightarrow> ((\<exists>l. r = locRef l \<and> oheap s l = None) | r = nullRef)"
apply (unfold newAddr_def)
apply (erule subst)
apply (rule someI)
apply (rule disjI2)
apply (rule HOL.refl)
done

lemma newAddrD2: "newAddr s = locRef l --> oheap s l = None"
apply(clarify)
apply(insert newAddrD)
apply(auto)
done

constdefs newAddrProp::"State => loc => bool"
"newAddrProp s l ==  ((newAddr s = locRef l) --> oheap s l = None)"

lemma newAddrD3 : "(newAddr s = locRef l) --> newAddrProp s l"
apply(simp add:newAddrProp_def newAddrD2)
done

(*The inital state satisfies "forever. HSmax 2", 
 irrespectively of whether L=M holds or L ~=M*)
theorem "PHI emptyState"
apply(simp add: PHI_def PROG_def)
apply(rule)
defer 1
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule disjI2)
apply(rule disjI1)
defer 1
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule disjI2)
apply(rule disjI1)
defer 1
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule disjI2)
apply(rule disjI1)
defer 1
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule disjI1)
defer 1
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule disjI1)
defer 1
apply(rule)
apply(rule)
apply(rule)
apply(rule disjI1)
defer 1
(*State 0*)
apply(rule disjI2)
apply(rule disjI2)
apply(simp add: emp_def emptyState_def dom_def emptyObjHeap_def)
(*State 1*)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add:newAddr_def tick_def new_obj_def lupd_def emptyState_def emptyObjHeap_def emptyHeap_def emptyLocals_def)
apply(clarify)
apply(auto)
apply(simp add: emp_def emptyState_def dom_def emptyObjHeap_def star_def single_def)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(subgoal_tac "{a. EX aa b. ((%l. None)(l|->(LIST, %fn. None))) a = Some (aa, b)} = {l}")
apply(auto)
apply(rule)
apply(rule)
apply(auto)
apply(simp add:orthogonal_def dom_def Int_def)
apply(rule)
apply(simp add:override_def)
(*State 2*)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add:newAddr_def tick_def new_obj_def lupd_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: Two_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(simp add: emp_def headDesc_def emptyState_def dom_def emptyObjHeap_def star_def single_def)
apply(auto)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(subgoal_tac "{a. EX aa b. ((%l. None)(l|->(LIST, (%fn. None)(head |-> rtInt 2)))) a = Some (aa, b)} = {l}")
apply(auto)
apply(rule)
apply(rule)
apply(auto)
apply(simp add:orthogonal_def dom_def Int_def)
apply(rule)
apply(simp add:override_def)
(*State 3*)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add:newAddr_def tick_def new_obj_def lupd_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: headDesc_def Two_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: NIL_LIST_def tailDesc_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(simp add: emp_def headDesc_def tailDesc_def emptyState_def dom_def emptyObjHeap_def star_def single_def)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(subgoal_tac "{a. EX aa b. ((%l. None)(l|->(LIST, (%fn. None)(head |-> rtInt 2)(tail|->rtRef nullRef)))) a = Some (aa, b)} = {l}")
apply(auto)
apply(rule)
apply(rule)
apply(auto)
apply(simp add:orthogonal_def dom_def Int_def)
apply(rule)
apply(simp add:override_def)
(*State 4*)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add:newAddr_def tick_def new_obj_def lupd_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: Two_def headDesc_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: NIL_LIST_def tailDesc_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(subgoal_tac "oheap (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))),
                                                     heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l)),
                                                     clock = Suc (Suc (Suc 0)), heapsz = 0 |) la = None")
prefer 2
apply(subgoal_tac "newAddrProp (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))),
                                                     heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l)),
                                                     clock = Suc (Suc (Suc 0)), heapsz = 0 |) la")
apply(auto)
apply(simp add: newAddrProp_def)
apply(simp add: newAddrD3)
apply(simp add:newAddr_def tick_def new_obj_def lupd_def headDesc_def tailDesc_def)
apply(subgoal_tac "star (single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) (SL_Ex3.HS (Suc 0))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la|->(LIST, %fn. None)),
                    heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc 0))), heapsz = 0 |)")
apply(auto)
apply(simp add: star_def)
apply(rule)
apply(rule)
apply(subgoal_tac "single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc 0))), heapsz = 0 |)")
apply(auto)
apply(simp add:single_def dom_def)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(subgoal_tac "single la (LIST, %fn. None)
                 (| oheap = (%l . None)(la|->(LIST, %fn. None)), heap = (%l. None), 
                    locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc 0))), heapsz = 0 |)")
apply(auto)
apply(simp add:single_def dom_def)
apply(rule)
apply(subgoal_tac "emp (| oheap = (%l . None), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                       clock = Suc (Suc (Suc (Suc 0))), heapsz = 0 |) &
                orthogonal ((%l. None)(la|->(LIST, %fn. None))) ((%l . None)) &
                (%l. None)(la|->(LIST, %fn. None)) ++ ((%l . None)) = (%l. None)(la|->(LIST, %fn. None))")
apply(auto)
apply(simp add:emp_def dom_def)
apply(simp add: orthogonal_def dom_def Int_def)
apply(rule)
apply(simp add: override_def)
apply(simp add: orthogonal_def dom_def Int_def)
apply(rule)
apply(simp add: override_def)
(*State 5*)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add:newAddr_def tick_def new_obj_def lupd_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: Two_def headDesc_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: NIL_LIST_def tailDesc_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(subgoal_tac "oheap (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))),
                                                     heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l)),
                                                     clock = Suc (Suc (Suc 0)), heapsz = 0 |) la = None")
prefer 2
apply(subgoal_tac "newAddrProp (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))),
                                                     heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l)),
                                                     clock = Suc (Suc (Suc 0)), heapsz = 0 |) la")
apply(auto)
apply(simp add: newAddrProp_def)
apply(simp add: newAddrD3)
apply(simp add:newAddr_def tick_def new_obj_def lupd_def headDesc_def tailDesc_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: One_def headDesc_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(subgoal_tac "star (single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) (SL_Ex3.HS (Suc 0))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))
                                      (la|->(LIST, (%fn. None)(head|->rtInt 1))),
                    heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc 0)))), heapsz = 0 |)")
apply(auto)
apply(simp add: star_def)
apply(rule)
apply(rule)
apply(subgoal_tac "single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc 0)))), heapsz = 0 |)")
apply(auto)
apply(simp add:single_def dom_def)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(subgoal_tac "single la (LIST, (%fn. None)(head|->rtInt 1))
                 (| oheap = (%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1))), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc 0)))), heapsz = 0 |)")
apply(auto)
apply(simp add:single_def dom_def)
apply(rule)
apply(subgoal_tac "emp (| oheap = (%l. None), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                       clock = Suc (Suc (Suc (Suc (Suc 0)))), heapsz = 0 |) &
                orthogonal ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)))) (%l. None) &
                (%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1))) ++ (%l. None) = (%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)))")
apply(auto)
apply(simp add:emp_def dom_def)
apply(simp add: orthogonal_def dom_def Int_def)
apply(rule)
apply(simp add: override_def)
apply(simp add: orthogonal_def dom_def Int_def)
apply(rule)
apply(simp add: override_def)
(*State 6*)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add:newAddr_def tick_def new_obj_def lupd_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: Two_def headDesc_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: NIL_LIST_def tailDesc_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(subgoal_tac "oheap (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))),
                                                     heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l)),
                                                     clock = Suc (Suc (Suc 0)), heapsz = 0 |) la = None")
prefer 2
apply(subgoal_tac "newAddrProp (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))),
                                                     heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l)),
                                                     clock = Suc (Suc (Suc 0)), heapsz = 0 |) la")
apply(auto)
apply(simp add: newAddrProp_def)
apply(simp add: newAddrD3)
apply(simp add:newAddr_def tick_def new_obj_def lupd_def headDesc_def tailDesc_def)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: One_def headDesc_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add:tailDesc_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
(*Case L = M*)
apply(subgoal_tac "star (single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) (SL_Ex3.HS (Suc 0))
                    (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                         |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))),
                       heap = %l. None, locals = (%fn. None)(M|->rtRef (locRef la)), clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))),
                       heapsz = 0 |)")
apply(auto)
apply(simp add: star_def)
apply(rule)
apply(rule)
apply(subgoal_tac "single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |)")
apply(auto)
apply(simp add:single_def dom_def)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(subgoal_tac "single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))
                 (| oheap = (%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |)")
apply(auto)
apply(simp add:single_def dom_def)
apply(rule)
apply(subgoal_tac "emp (| oheap = (%l. None), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                       clock = Suc (Suc (Suc (Suc (Suc 0)))), heapsz = 0 |) &
                orthogonal ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la))))) (%l. None) &
                (%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))) ++ (%l. None) = (%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la))))")
apply(auto)
apply(simp add:emp_def dom_def)
apply(simp add:emp_def dom_def)
apply(simp add: orthogonal_def dom_def Int_def)
apply(rule)
apply(simp add: override_def)
apply(simp add: orthogonal_def dom_def Int_def)
apply(rule)
apply(simp add: override_def)
(*Case L ~= M*)
apply(subgoal_tac "star (single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) (SL_Ex3.HS (Suc 0))
                    (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                         |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))),
                       heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                       clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |)")
apply(auto)
apply(simp add: star_def)
apply(rule)
apply(rule)
apply(subgoal_tac "single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |)")
apply(auto)
apply(simp add:single_def dom_def)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(subgoal_tac "single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))
                 (| oheap = (%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |)")
apply(auto)
apply(simp add:single_def dom_def)
apply(rule)
apply(subgoal_tac "emp (| oheap = (%l. None), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                       clock = Suc (Suc (Suc (Suc (Suc 0)))), heapsz = 0 |) &
                orthogonal ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))) (%l. None) &
                (%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))) ++ (%l. None) = (%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))")
apply(auto)
apply(simp add:emp_def dom_def)
apply(simp add:emp_def dom_def)
apply(simp add: orthogonal_def dom_def Int_def)
apply(rule)
apply(simp add: override_def)
apply(simp add: orthogonal_def dom_def Int_def)
apply(rule)
apply(simp add: override_def)
done

ML_command {* writeln "Resource property has been proved!!"; *}
ML_command {* OS.Process.exit(OS.Process.success):unit; *}

end
