(* 
   Title:      CoreGrailDynSem.thy
   ID:         $Id: Dynsem.thy,v 1.1 2003/02/03 12:17:23 lenb Exp $ 
   Author:     ME
   Copyright:  GPL

   Dynamic semantics for CoreGrail.
*)

theory Dynsem = State:

subsection "Aux functions"

(* I suppose both constdefs and primrec can be used for defining evalBOP and 
   evalTest; not sure which is better; this definitely looks ugly *)

constdefs evalBOP :: "BinOp \<Rightarrow> RTVal \<Rightarrow> RTVal \<Rightarrow> RTVal"
 "evalBOP binop N M \<equiv>
  (case N of 
     rtVoid \<Rightarrow> rtVoid
   | rtBool b \<Rightarrow> rtVoid
   | rtInt n \<Rightarrow> 
      (case M of 
          rtVoid \<Rightarrow> rtVoid
        | rtBool b \<Rightarrow> rtVoid
        | rtInt m \<Rightarrow>
           (case binop of 
               ADDop \<Rightarrow> rtInt (n + m)
             | SUBop \<Rightarrow> rtInt (n - m)
             | MULop \<Rightarrow> rtInt (n * m))
        | rtString str \<Rightarrow> rtVoid
        | rtRef ref \<Rightarrow> rtVoid )
   | rtString str \<Rightarrow> rtVoid
   | rtRef ref \<Rightarrow> rtVoid )"

constdefs evalTest :: "Test \<Rightarrow> RTVal \<Rightarrow> RTVal \<Rightarrow> RTVal"
 "evalTest test N M \<equiv>
   (case N of 
       rtVoid \<Rightarrow> rtVoid
     | rtBool b \<Rightarrow> rtVoid
     | rtInt n \<Rightarrow> (case M of 
                     rtVoid \<Rightarrow> rtVoid
                   | rtBool b \<Rightarrow> rtVoid
                   | rtInt m \<Rightarrow> (case test of 
                                    EQUALStest \<Rightarrow> rtBool (n = m)
                                  | IStest \<Rightarrow> rtVoid
                                  | LESStest \<Rightarrow> rtBool (n < m) )
                   | rtString str \<Rightarrow> rtVoid
                   | rtRef ref \<Rightarrow> rtVoid )
     | rtString str \<Rightarrow> rtVoid
     | rtRef refn \<Rightarrow> (case M of 
                        rtVoid \<Rightarrow> rtVoid
                      | rtBool b \<Rightarrow> rtVoid
                      | rtInt i \<Rightarrow> rtVoid
                      | rtString str \<Rightarrow> rtVoid
                      | rtRef refm \<Rightarrow> (case test of
                                          EQUALStest \<Rightarrow> rtVoid
                                        | IStest \<Rightarrow> rtBool (refn = refm)
                                        | LESStest \<Rightarrow> rtVoid )) ) "

subsection "Substitutions"

constdefs
  update :: "('a \<Rightarrow> 'b) \<Rightarrow> 'a \<Rightarrow> 'b \<Rightarrow> ('a \<Rightarrow> 'b)" ("_/[_ ::= /_]" [900,0,0] 900)
  "update == fun_upd"

syntax (xsymbols)
  update :: "('a \<Rightarrow> 'b) \<Rightarrow> 'a \<Rightarrow> 'b \<Rightarrow> ('a \<Rightarrow> 'b)" ("_/[_ \<mapsto> /_]" [900,0,0] 900)


subsection "Main evaluation functions"

subsubsection "Prototypes and Syntax"

text {* main evaluation function *}
(* Evaluation function is actually a set; as in NanoJava
   One eval function per non-terminal *)
consts
 eval_Result   :: "(Result   * State * RTVal * State) set"
 eval_PrimRes  :: "(PrimRes  * State * RTVal * State) set"
 eval_CondHead :: "(CondHead * State * RTVal * State) set"
 eval_PrimOp   :: "(PrimOp   * State * RTVal * State) set"
 eval_Value    :: "(Value    * State * RTVal * State) set"
 eval_LetDec   :: "(LetDec   * State * RTVal * State) set"
 eval_LetDecs  :: "(LetDecs  * State * RTVal * State) set"
 eval_Arg      :: "(Arg      * State * RTVal * State) set"
 eval_ArgList  :: "(ArgList  * State * RTVal * State) set"
 eval_FunBody  :: "(FunBody  * State * RTVal * State) set"
 eval_FunDec   :: "(FunDec   * State * RTVal * State) set"
 eval_FunDecs  :: "(FunDecs  * State * RTVal * State) set"

(* prettier syntax; \<longrightarrow> is annotated with (first letter of) name of non-term *)
syntax
 eval_Result   :: "[Result,State,RTVal,State] \<Rightarrow> bool"    ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>r \<langle>_,_\<rangle>")
 eval_PrimRes  :: "[PrimRes,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>p \<langle>_,_\<rangle>")
 eval_CondHead :: "[CondHead,State,RTVal,State] \<Rightarrow> bool"  ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>c \<langle>_,_\<rangle>")
 eval_PrimOp   :: "[PrimOp,State,RTVal,State] \<Rightarrow> bool"    ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>o \<langle>_,_\<rangle>")
 eval_Value    :: "[Value,State,RTVal,State] \<Rightarrow> bool"     ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>v \<langle>_,_\<rangle>")
 eval_LetDec   :: "[LetDec,State,RTVal,State] \<Rightarrow> bool"    ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>l \<langle>_,_\<rangle>")
 eval_LetDecs  :: "[LetDecs,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>1 \<langle>_,_\<rangle>")
 eval_Arg      :: "[Arg,State,RTVal,State] \<Rightarrow> bool"       ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>a \<langle>_,_\<rangle>")
 eval_ArgList  :: "[ArgList,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>2 \<langle>_,_\<rangle>")
 eval_FunBody  :: "[FunBody,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>b \<langle>_,_\<rangle>")
 eval_FunDec   :: "[FunDec,State,RTVal,State] \<Rightarrow> bool"    ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>f \<langle>_,_\<rangle>")
 eval_FunDecs  :: "[FunDecs,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>3 \<langle>_,_\<rangle>")

(* map syntax to evaluations *)
translations
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>r \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_Result"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>p \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_PrimRes"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>c \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_CondHead"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>o \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_PrimOp"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_Value"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>l \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_LetDec"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>1 \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_LetDecs"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>a \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_Arg"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>2 \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_ArgList"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>b \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_FunBody"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>f \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_FunDec"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>3 \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_FunDecs"

subsubsection "Evaluation function definition"

(* Expressions *)

(* Costs: 0; constants and variable lookup are for free *)
inductive eval_Value intros
(*lenb 02/12/2002: corrected VARVal into VARval*)
 VARval[intro!]: "\<lbrakk> v = get_local s x \<rbrakk> 
                \<Longrightarrow> 
                \<langle>VARval x,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>"
 INTval[intro!]: "\<langle>INTval i,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtInt i,s\<rangle>"
 NULLval[intro!]: "\<langle>NULLval str,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtRef nullRef,s\<rangle>"

(* Costs: 1 for every bin op *)
inductive eval_PrimOp intros
 VALop[intro!]: "\<lbrakk> \<langle>x,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle> ; s0 = tick s'\<rbrakk> 
                \<Longrightarrow> 
                \<langle>VALop x,s\<rangle> \<longrightarrow>\<^sub>o \<langle>v,s0\<rangle>"
 BINop[intro!]: "\<lbrakk> \<langle>v1,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtv1,s1\<rangle> ; \<langle>v2,s1\<rangle> \<longrightarrow>\<^sub>v \<langle>rtv2,s2\<rangle> \<rbrakk> 
                \<Longrightarrow>
                \<langle>BINop b v1 v2,s\<rangle> \<longrightarrow>\<^sub>o \<langle>evalBOP b rtv1 rtv2, tick s2\<rangle>"
 NEWop[intro!]: "\<lbrakk> newAddr s = locRef l; new_obj l C s = s0 \<rbrakk>
                \<Longrightarrow>
                \<langle>NEWop C,s\<rangle> \<longrightarrow>\<^sub>o \<langle>rtRef(locRef l), tick s0\<rangle>"
 GETFIELDop[intro!]:"\<lbrakk> \<langle>VARval x,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtRef r,s0\<rangle> ;
                               locRef a = r ;
                               get_field s0 a fldname = rtv
                     \<rbrakk>
                \<Longrightarrow>
                \<langle>GETFIELDop x (FDESC fldtype fldname),s\<rangle> \<longrightarrow>\<^sub>o 
                \<langle>rtv, tick s0\<rangle>"
 PUTFIELDop[intro!]:"\<lbrakk> \<langle>VARval x,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtRef(locRef a),s0\<rangle>;
                               \<langle>v,s0\<rangle> \<longrightarrow>\<^sub>v \<langle>rtv,s1\<rangle>;
                               a : dom (oheap s1);
                               put_field s1 a fldname rtv = s2
                     \<rbrakk>
                \<Longrightarrow>
                \<langle>PUTFIELDop x (FDESC fldtype fldname) v, s\<rangle> \<longrightarrow>\<^sub>o 
                \<langle>rtVoid, tick s2\<rangle>"


(* Costs: 1 for fct call; 1 for conditional; rest summed up; here we know thw
          branch to take; in a static analysis that has to be approximated *)
inductive eval_PrimRes eval_Result eval_FunBody intros
 OPres[intro!]: "\<lbrakk> \<langle>p,s\<rangle> \<longrightarrow>\<^sub>o \<langle>x,s'\<rangle> \<rbrakk> 
                \<Longrightarrow>
                \<langle>OPres p,s\<rangle> \<longrightarrow>\<^sub>p \<langle>x,s'\<rangle>"
 VOIDres[intro!]: "\<langle>VOIDres,s\<rangle> \<longrightarrow>\<^sub>p \<langle>rtVoid,s'\<rangle>"
 FUNres[intro!]: "\<lbrakk> b = get_body f s ; \<langle>b,s\<rangle> \<longrightarrow>\<^sub>b \<langle>x,s'\<rangle> \<rbrakk>
                  \<Longrightarrow>
                  \<langle>FUNres f xs,s\<rangle> \<longrightarrow>\<^sub>p \<langle>x,tick s'\<rangle>"
 (* get_body returning a tuple:
 FUNres[intro!]: "\<lbrakk> (decs,res) = get_body f s ; \<langle>decs, s\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid,s1\<rangle> ; \<langle>res,s1\<rangle> \<longrightarrow>\<^sub>r \<langle>x,s2\<rangle> \<rbrakk>
                  \<Longrightarrow>
                  \<langle>FUNres f xs,s\<rangle> \<longrightarrow>\<^sub>p \<langle>x,tick s2\<rangle>"
 *)
 PRIMres[intro!]: "\<lbrakk> \<langle>pres,s\<rangle> \<longrightarrow>\<^sub>p \<langle>v,s'\<rangle>\<rbrakk> 
                   \<Longrightarrow>  
                   \<langle>PRIMres pres,s\<rangle> \<longrightarrow>\<^sub>r \<langle>v,s'\<rangle>"
 CHOICEres_True[intro!]: "\<lbrakk> \<langle>head,s\<rangle> \<longrightarrow>\<^sub>c \<langle>rtBool True,s'\<rangle>; \<langle>p1,s\<rangle> \<longrightarrow>\<^sub>p \<langle>x,s1\<rangle> \<rbrakk> 
                         \<Longrightarrow> 
                         \<langle>CHOICEres head p1 p2,s\<rangle> \<longrightarrow>\<^sub>r \<langle>x, tick s1\<rangle>"
 CHOICEres_False[intro!]: "\<lbrakk> \<langle>head,s\<rangle> \<longrightarrow>\<^sub>c \<langle>rtBool False,s'\<rangle>; \<langle>p2,s\<rangle> \<longrightarrow>\<^sub>p \<langle>x,s2\<rangle> \<rbrakk> 
                          \<Longrightarrow> 
                          \<langle>CHOICEres head p1 p2,s\<rangle> \<longrightarrow>\<^sub>r \<langle>x, tick s2\<rangle>"

 FUNbody: "\<lbrakk> \<langle>decls, s\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid, s1\<rangle> ; \<langle>res, s1\<rangle> \<longrightarrow>\<^sub>r \<langle>x, s2\<rangle> \<rbrakk>
           \<Longrightarrow>
           \<langle>FUNbody decls res, s\<rangle> \<longrightarrow>\<^sub>b \<langle>x, s2\<rangle>"

(* Costs: 1 for test in head of conditional *)
inductive eval_CondHead intros
 CONDhead[intro!]: "\<lbrakk> \<langle>v1,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtv1,s1\<rangle> ; \<langle>v2,s1\<rangle> \<longrightarrow>\<^sub>v \<langle>rtv2,s2\<rangle> ; x = evalTest t rtv1 rtv2 \<rbrakk> 
            \<Longrightarrow>
            \<langle>CONDhead v1 t v2,s\<rangle> \<longrightarrow>\<^sub>c \<langle>x, tick s2\<rangle>"

(* Declarations; costs are 0 throughout *)

inductive eval_LetDecs intros
 EMPTYdec[intro!]: "\<langle>EMPTYdec,s\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid,s\<rangle>"
 FULLdec[intro!]:  "\<lbrakk> \<langle>l,s\<rangle> \<longrightarrow>\<^sub>l \<langle>rtVoid,s1\<rangle> ; \<langle>ls,s1\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid,s2\<rangle> \<rbrakk>
                \<Longrightarrow>
                \<langle>FULLdec l ls,s\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid,s2\<rangle>"

inductive eval_LetDec intros
 VALdec[intro!]: "\<lbrakk> \<langle>p,s\<rangle> \<longrightarrow>\<^sub>o \<langle>x,s'\<rangle> ; s'' = lupd str x s' \<rbrakk> 
                  \<Longrightarrow>
                  \<langle>VALdec str p,s\<rangle> \<longrightarrow>\<^sub>l \<langle>rtVoid,s''\<rangle>"
 VOIDdec[intro!]: "\<lbrakk> \<langle>p,s\<rangle> \<longrightarrow>\<^sub>o \<langle>x,s'\<rangle> \<rbrakk> 
                   \<Longrightarrow>
                   \<langle>VOIDdec p,s\<rangle> \<longrightarrow>\<^sub>l \<langle>rtVoid,s'\<rangle>"

(* modelling the Grail restriction of formal args are same as function args,
   we throw function args away *)

inductive eval_Arg intros
 ARG[intro!]: "\<langle>ARG ty vname,s\<rangle> \<longrightarrow>\<^sub>a \<langle>rtVoid, s\<rangle>"

inductive eval_ArgList intros
 EMPTYal[intro!]: "\<langle>EMPTYal, s\<rangle> \<longrightarrow>\<^sub>2 \<langle>rtVoid, s'\<rangle>"
 FULLal[intro!]:  "\<lbrakk> \<langle>a,s\<rangle> \<longrightarrow>\<^sub>a \<langle>rtVoid, s'\<rangle> ; \<langle>as,s2\<rangle> \<longrightarrow>\<^sub>2 \<langle>rtVoid,s3\<rangle> \<rbrakk>
                   \<Longrightarrow>
                   \<langle>FULLal a as, s\<rangle> \<longrightarrow>\<^sub>2 \<langle>rtVoid, s3\<rangle>"

inductive eval_FunDecs intros
 EMPTYfundec[intro!]:  "\<langle>EMPTYfundec, s\<rangle> \<longrightarrow>\<^sub>3 \<langle>rtVoid, s'\<rangle>"
 FULLfundec[intro!]:   "\<lbrakk> \<langle>f,s\<rangle> \<longrightarrow>\<^sub>f \<langle>rtVoid, s2\<rangle> ; \<langle>fs,s2\<rangle> \<longrightarrow>\<^sub>3 \<langle>rtVoid,s3\<rangle> \<rbrakk>
                        \<Longrightarrow>
                        \<langle>FULLfundec f fs, s\<rangle> \<longrightarrow>\<^sub>3 \<langle>rtVoid, s3\<rangle>"
 
inductive eval_FunDec intros
 FDEC[intro!]:  "\<lbrakk> s2 = hupd fname args b s \<rbrakk> 
                 \<Longrightarrow>
                 \<langle>FDEC fname args b, s\<rangle> \<longrightarrow>\<^sub>f \<langle>rtVoid, s2\<rangle>"

end