(*Second example for foundational SL verfication.
  Program: L = new List
           putfield L head 2
           putfield L tail nil
           M = new List
           putfield M head 1
           putfield M tail L
  results in a state which fulfills (single l obj1) * (single m obj2)
*)

theory SL_Ex2 = Seplogic:

consts LIST :: "Cname"

consts is_LIST_object:: "Obj => bool"
primrec
"is_LIST_object (cname,fields) = (cname = LIST)"

consts L :: "Vname"
consts M :: "Vname"

consts head :: "Vname"
constdefs headDesc :: "FieldDesc"
"headDesc == FDESC INTty head"

consts tail :: "Vname"
constdefs tailDesc :: "FieldDesc"
"tailDesc == FDESC (REFty LIST) tail"

constdefs One :: "Value"
"One == INTval (int 1)"
constdefs Two :: "Value"
"Two == INTval (int 2)"

constdefs NIL_LIST :: "Value"
"NIL_LIST == NULLval LIST"

constdefs PROG:: "LetDecs" 
"PROG == FULLdec (VALdec L (NEWop LIST)) 
        ( FULLdec (VOIDdec (PUTFIELDop L headDesc Two))
          ( FULLdec (VOIDdec (PUTFIELDop L tailDesc NIL_LIST))
            ( FULLdec (VALdec M (NEWop LIST)) 
              ( FULLdec (VOIDdec (PUTFIELDop M headDesc One))
                ( FULLdec (VOIDdec (PUTFIELDop M tailDesc (VARval L)))
                  EMPTYdec )))))"

(* finalState is true of states which are reachable from emptyState by executing LD3*)
constdefs finalState:: "ass"
"finalState s == EX rtv.
         (\<langle> PROG, emptyState\<rangle> 
          \<longrightarrow>\<^sub>1 
          \<langle>rtv, s\<rangle>
         )"

lemma newAddrD: 
"(newAddr s = r) \<Longrightarrow> ((\<exists>l. r = locRef l \<and> oheap s l = None) | r = nullRef)"
apply (unfold newAddr_def)
apply (erule subst)
apply (rule someI)
apply (rule disjI2)
apply (rule HOL.refl)
done

lemma newAddrD2: "newAddr s = locRef l --> oheap s l = None"
apply(clarify)
apply(insert newAddrD)
apply(auto)
done

constdefs newAddrProp::"State => loc => bool"
"newAddrProp s l ==  ((newAddr s = locRef l) --> oheap s l = None)"

lemma newAddrD3 : "(newAddr s = locRef l) --> newAddrProp s l"
apply(simp add:newAddrProp_def newAddrD2)
done


(* The resulting state fulfills a separating conjunction of 2 singleton LIST-objects*)
lemma L_not_M_isLIST:
  "ALL s.
       ((L ~= M & finalState s) -->
        (EX l m obj1 obj2. ((star (single l obj1) (single m obj2) s) &
                            (is_LIST_object obj1) & (is_LIST_object obj2))))" 
apply(clarify)
apply(simp add: PROG_def single_def emptyState_def emptyObjHeap_def emptyLocals_def emptyHeap_def headDesc_def Two_def finalState_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add:newAddr_def tick_def new_obj_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add:NIL_LIST_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(subgoal_tac "oheap (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(fldname|->rtRef nullRef))), heap = %l. None,
              locals = (%fn. None)(L|->rtRef (locRef l)), clock = Suc (Suc (Suc 0)), heapsz = 0 |) la = None")
prefer 2
apply(subgoal_tac "newAddrProp (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(fldname|->rtRef nullRef))), heap = %l. None,
              locals = (%fn. None)(L|->rtRef (locRef l)), clock = Suc (Suc (Suc 0)), heapsz = 0 |) la")
apply(auto)
apply(simp add: newAddrProp_def)
apply(simp add: newAddrD3)
apply(simp add:newAddr_def tick_def new_obj_def lupd_def headDesc_def tailDesc_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: One_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add:put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def upd_obj_def dom_def tailDesc_def Let_def get_local_def headDesc_def)
(*now the goal*)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(subgoal_tac "(star (single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) 
                         (single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))
                     (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                          |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))),
                        heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                        clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |))")
apply(auto)
apply(simp add:star_def)
apply(rule)
apply(subgoal_tac "single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                (EX La. single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))
                         (| oheap = La, heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                            clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                        orthogonal ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) La &
                        ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) ++ La = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                        |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))))")
apply(auto)
apply(simp add:single_def dom_def Int_def)
apply(rule)
apply(subgoal_tac "single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))
                 (| oheap = ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                orthogonal ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))) &
                (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) ++ ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))) = (%l. None)(l
                |->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))")
apply(auto)
apply(simp add: single_def dom_def Int_def)
prefer 2
apply(rule)
apply(simp add: override_def)
apply(simp add: orthogonal_def dom_def Int_def)
done

(*Indeed, we even know what the objects are: (LIST,(1,l)) and (LIST,(2,nil))*)
lemma L_not_M_precise:
  "ALL s.
       ((L ~= M & finalState s) -->
        (EX l m. ((star (single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) 
                        (single m (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))) s))))"
apply(clarify)
apply(simp add: PROG_def single_def emptyState_def emptyObjHeap_def emptyLocals_def emptyHeap_def headDesc_def Two_def finalState_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add:newAddr_def tick_def new_obj_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add:NIL_LIST_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(subgoal_tac "oheap (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(fldname|->rtRef nullRef))), heap = %l. None,
              locals = (%fn. None)(L|->rtRef (locRef l)), clock = Suc (Suc (Suc 0)), heapsz = 0 |) la = None")
prefer 2
apply(subgoal_tac "newAddrProp (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(fldname|->rtRef nullRef))), heap = %l. None,
              locals = (%fn. None)(L|->rtRef (locRef l)), clock = Suc (Suc (Suc 0)), heapsz = 0 |) la")
apply(auto)
apply(simp add: newAddrProp_def)
apply(simp add: newAddrD3)
apply(simp add:newAddr_def tick_def new_obj_def lupd_def headDesc_def tailDesc_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: One_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add:put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def upd_obj_def dom_def tailDesc_def Let_def get_local_def headDesc_def)
(*now the goal*)
apply(rule)
apply(rule)
apply(subgoal_tac "(star (single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) 
                         (single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))
                     (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                          |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))),
                        heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                        clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |))")
apply(auto)
apply(simp add:star_def)
apply(rule)
apply(subgoal_tac "single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                (EX La. single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))
                         (| oheap = La, heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                            clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                        orthogonal ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) La &
                        ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) ++ La = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                        |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))))")
apply(auto)
apply(simp add:single_def dom_def Int_def)
apply(rule)
apply(subgoal_tac "single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l)))
                 (| oheap = ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))), heap = %l. None, locals = (%fn. None)(L|->rtRef (locRef l))(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                orthogonal ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))) &
                (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) ++ ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))) = (%l. None)(l
                |->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef l))))")
apply(auto)
apply(simp add: single_def dom_def Int_def)
prefer 2
apply(rule)
apply(simp add: override_def)
apply(simp add: orthogonal_def dom_def Int_def)
done

(* Indeed, both properties holds even if L=M!!! (the proofs instantiate the subgoals in a slightly different way)*)
lemma L_is_M_isLIST:
  "ALL s.
       ((L = M & finalState s) -->
        (EX l m obj1 obj2. ((star (single l obj1) (single m obj2) s) &
                            (is_LIST_object obj1) & (is_LIST_object obj2))))" 
apply(clarify)
apply(simp add: PROG_def single_def emptyState_def emptyObjHeap_def emptyLocals_def emptyHeap_def headDesc_def Two_def finalState_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add:newAddr_def tick_def new_obj_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add:NIL_LIST_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(subgoal_tac "oheap (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(fldname|->rtRef nullRef))), heap = %l. None,
              locals = (%fn. None)(L|->rtRef (locRef l)), clock = Suc (Suc (Suc 0)), heapsz = 0 |) la = None")
prefer 2
apply(subgoal_tac "newAddrProp (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(fldname|->rtRef nullRef))), heap = %l. None,
              locals = (%fn. None)(L|->rtRef (locRef l)), clock = Suc (Suc (Suc 0)), heapsz = 0 |) la")
apply(auto)
apply(simp add: newAddrProp_def)
apply(simp add: newAddrD3)
apply(simp add:newAddr_def tick_def new_obj_def lupd_def headDesc_def tailDesc_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: One_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add:put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def upd_obj_def dom_def tailDesc_def Let_def get_local_def headDesc_def)
(*now the goal*)
apply(rule)
apply(rule)
apply(rule)
apply(rule)
apply(subgoal_tac "star (single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))
                        (single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la))))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                      |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))),
                    heap = %l. None, locals = (%fn. None)(M|->rtRef (locRef la)), clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))),
                    heapsz = 0 |)")
apply(auto)
apply(simp add:star_def)
apply(rule)
apply(subgoal_tac "single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))), heap = %l. None, locals = (%fn. None)(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                (EX L. single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))
                        (| oheap = L, heap = %l. None, locals = (%fn. None)(M|->rtRef (locRef la)),
                           clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                       orthogonal ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) L &
                       ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) ++ L = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                       |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))))")
apply(auto)
apply(simp add:single_def dom_def Int_def)
apply(rule)
apply(subgoal_tac "single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))
                 (| oheap = (%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))), heap = %l. None, locals = (%fn. None)(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                orthogonal ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la))))) &
                (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) ++ ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la))))) = (%l. None)(l
                |->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la))))")
apply(auto)
apply(simp add: single_def dom_def Int_def)
prefer 2
apply(rule)
apply(simp add: override_def)
apply(simp add: orthogonal_def dom_def Int_def)
done

(*Of course, for L=M the resulting state represents 2 lists: the infinite list "mu L. (LIST,(1,L))" and the list (LIST,(2,nil))*)
lemma L_is_M_precise:
  "ALL s.
       ((L = M & finalState s) -->
        (EX l m. ((star (single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) 
                        (single m (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef m)))) s))))"
apply(clarify)
apply(simp add: PROG_def single_def emptyState_def emptyObjHeap_def emptyLocals_def emptyHeap_def headDesc_def Two_def finalState_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add:newAddr_def tick_def new_obj_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add:NIL_LIST_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(subgoal_tac "oheap (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(fldname|->rtRef nullRef))), heap = %l. None,
              locals = (%fn. None)(L|->rtRef (locRef l)), clock = Suc (Suc (Suc 0)), heapsz = 0 |) la = None")
prefer 2
apply(subgoal_tac "newAddrProp (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(fldname|->rtRef nullRef))), heap = %l. None,
              locals = (%fn. None)(L|->rtRef (locRef l)), clock = Suc (Suc (Suc 0)), heapsz = 0 |) la")
apply(auto)
apply(simp add: newAddrProp_def)
apply(simp add: newAddrD3)
apply(case_tac "la = l")
apply(auto)
apply(simp add:newAddr_def tick_def new_obj_def lupd_def headDesc_def tailDesc_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: One_def put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add:put_field_def tick_def lupd_def upd_obj_def Let_def get_local_def)
apply(clarify)
apply(auto)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def upd_obj_def dom_def tailDesc_def Let_def get_local_def headDesc_def)
(*now the goal*)
apply(rule)
apply(rule)
apply(subgoal_tac "star (single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))
                        (single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la))))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                      |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))),
                    heap = %l. None, locals = (%fn. None)(M|->rtRef (locRef la)), clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))),
                    heapsz = 0 |)")
apply(auto)
apply(simp add:star_def)
apply(rule)
apply(subgoal_tac "single l (LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))
                 (| oheap = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))), heap = %l. None, locals = (%fn. None)(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                (EX L. single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))
                        (| oheap = L, heap = %l. None, locals = (%fn. None)(M|->rtRef (locRef la)),
                           clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                       orthogonal ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) L &
                       ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) ++ L = (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                       |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))))")
apply(auto)
apply(simp add:single_def dom_def Int_def)
apply(rule)
apply(subgoal_tac "single la (LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))
                 (| oheap = (%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la)))), heap = %l. None, locals = (%fn. None)(M|->rtRef (locRef la)),
                    clock = Suc (Suc (Suc (Suc (Suc (Suc 0))))), heapsz = 0 |) &
                orthogonal ((%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))) ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la))))) &
                (%l. None)(l|->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef))) ++ ((%l. None)(la|->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la))))) = (%l. None)(l
                |->(LIST, (%fn. None)(head|->rtInt 2)(tail|->rtRef nullRef)))(la
                |->(LIST, (%fn. None)(head|->rtInt 1)(tail|->rtRef (locRef la))))")
apply(auto)
apply(simp add: single_def dom_def Int_def)
prefer 2
apply(rule)
apply(simp add: override_def)
apply(simp add: orthogonal_def dom_def Int_def)
done

ML_command {* writeln "Resource property has been proved!!"; *}
ML_command {* OS.Process.exit(OS.Process.success):unit; *}

end
