(* $Id: Absyn.thy,v 1.1 2003/02/03 12:16:53 lenb Exp $ *)

theory Absyn=Main :
(*Author: Lennart Beringer*)
(*Date 01/12/2002*)
(* In first approximation the grammar is cut down to CoreGrail *)

(*taken from /progs/Grail/gdf/src/GrailAbsyn.sml*)
(*order changed during adaption to Isabelle*)
(*no float library in Isabelle?*)

(* datatype ClassdeclAccess_flag = "classdeclaccessflag" *)

types 
  Vname = "string"  (* names of variables *)
  Fname = "string"  (* names of functions, i.e.labels of basic blocks *)
  Cname = "string"  (* names of classes *)
  Mname = "string"  (* names of methods *)

datatype Ty = (* many of these aren't accessible from Grail *)
    INTty 
  | BOOLEANty 
  | REFty "string"
  | ARRAYty "Ty"

types RTy = Ty (* ToDo: FIX *)

(* I avoid using using list constructor of the meta-language; instead I encode
   lists in the grammer; I suppose this makes the embedding deeper than necessary  *)

(* Expressions *)

datatype Value = VARval "Vname"
               | INTval "int"
               | NULLval "string"

(*  | STRINGval "string" *)
(*  | FLOATval "real"*)

datatype Test = EQUALStest | IStest | LESStest

datatype BinOp = ADDop | SUBop | MULop

(*lenb 01/12/2002: MethDesc and FieldDesc reactivated*)
(*datatype MethDesc = MDESC "RTy" "string" "Ty list" 
  datatype FieldDesc = FDESC "Ty" "string"*)
datatype MethDesc = MDESC "RTy" "Mname" "Ty list" 
datatype FieldDesc = FDESC "Ty" "Vname"

(*lenb 01/12/2002: Primops NEW, GETFIELDop and PUTFIELDOP reactivated*)
datatype PrimOp =
    VALop "Value"
  | BINop "BinOp" "Value" "Value"
(*  | NEWop "MethDesc" "Value list"*)
  | NEWop "Cname" (* simplification for the time being*)
  | GETFIELDop "Vname" "FieldDesc"
  | PUTFIELDop "Vname" "FieldDesc" "Value"

datatype VarList  = EMPTYvar 
                  | FULLvar "Vname" "VarList"

datatype PrimRes = OPres "PrimOp"
                 | VOIDres
                 | FUNres "Fname" "VarList"

datatype CondHead = CONDhead "Value" "Test" "Value"  

datatype Result = PRIMres "PrimRes"
                | CHOICEres "CondHead" "PrimRes" "PrimRes"

(* Declarations *)

datatype LetDec = VALdec "Vname" "PrimOp"
                | VOIDdec "PrimOp"

datatype LetDecs = EMPTYdec 
                 | FULLdec "LetDec" "LetDecs"

datatype Arg = ARG Ty Vname

datatype ArgList = EMPTYal 
                 | FULLal "Arg" "ArgList"

datatype FunBody = FUNbody "LetDecs" "Result"

datatype FunDec = FDEC "Fname" "ArgList" "FunBody"

datatype FunDecs = EMPTYfundec 
                 | FULLfundec "FunDec" "FunDecs"

(* Methods *)
datatype MethodBody = MBODY "LetDecs" "FunDecs" "Result"

(* Top level *)
datatype Prog = PROG MethodBody


(*  | INVOKESTATICop "MethDesc" "Value list" *)
(*
datatype PrimOp =
    VALop "Value"
  | BINop "BinOp" "Value" "Value"
  | NEWop "MethDesc" "Value list"
  | CHECKCASTop "string" "Vname"
  | INSTANCEop "string" "Vname"
  | INVOKESTATICop "MethDesc" "Value list"
  | INVOKEVIRTUALop "Vname" "MethDesc" "Value list"
  | INVOKESPECIALop "Vname" "MethDesc" "Value list"
  | GETFIELDop "Vname" "FieldDesc"
  | PUTFIELDop "Vname" "FieldDesc" "Value"
  | GETSTATICop "FieldDesc"
  | PUTSTATICop "FieldDesc" "Value"
  | MAKEop "Value" "Value"
  | GETop "Value" "Value"
  | SETop "Value" "Value" "Value"
  | LENGTHop "Value"  
  | EMPTYop "Value" "Ty"
  | FTOIop "Value"
  | ITOFop "Value"
*)
(* withtype Var = "string" *)
end

