(*First example for foundational verification using SL.
  Program: L = new List
           putfield L head 2
           putfield L tail NIL
*)
theory SL_Ex1 = Seplogic:

consts LIST :: "Cname"
consts is_LIST_object:: "Obj => bool"
primrec
"is_LIST_object (cname,fields) = (cname = LIST)"

consts L :: "Vname"

consts head :: "Vname"
constdefs headDesc :: "FieldDesc"
"headDesc == FDESC INTty head"

consts tail :: "Vname"
constdefs tailDesc :: "FieldDesc"
"tailDesc == FDESC (REFty LIST) tail"

constdefs Two :: "Value"
"Two == INTval (int 2)"

constdefs NIL_LIST :: "Value"
"NIL_LIST == NULLval LIST"

constdefs PROG:: "LetDecs" 
"PROG == FULLdec (VALdec L (NEWop LIST)) 
        ( FULLdec (VOIDdec (PUTFIELDop L headDesc Two))
          ( FULLdec (VOIDdec (PUTFIELDop L tailDesc NIL_LIST))
            EMPTYdec ))"

(* FinalState is true of any state which is reachable from emptyState by 
   executing PROG*)
constdefs FinalState:: "ass"
"FinalState s == EX rtv.
         (\<langle> PROG, emptyState\<rangle> 
          \<longrightarrow>\<^sub>1 
          \<langle>rtv, s\<rangle>
         )"

(* If we know which location was chosen for the new object, the resulting state
   again is a singleton*)
lemma "ALL l. ((FinalState s & (newAddr emptyState = locRef l)) --> 
               (EX obj. ((single l obj s) & is_LIST_object obj)))" 
apply(clarify)
apply(simp add: PROG_def single_def emptyState_def emptyObjHeap_def emptyLocals_def emptyHeap_def headDesc_def Two_def FinalState_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all add: tick_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def upd_obj_def dom_def tailDesc_def Let_def get_local_def headDesc_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: tick_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def upd_obj_def dom_def tailDesc_def Let_def get_local_def headDesc_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_LetDec.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_PrimOp.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all)
apply(clarify)
apply(erule eval_Value.elims)
apply(simp_all add: tick_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def upd_obj_def dom_def tailDesc_def Let_def get_local_def headDesc_def NIL_LIST_def)
apply(clarify)
apply(erule eval_LetDecs.elims)
apply(simp_all add: tick_def new_obj_def emptyObjHeap_def override_def newAddr_def emptyLocals_def lupd_def put_field_def upd_obj_def dom_def tailDesc_def Let_def get_local_def headDesc_def)
apply(clarify)
apply(auto)
done

ML_command {* writeln "Resource property has been proved!!"; *}
ML_command {* OS.Process.exit(OS.Process.success):unit; *}

end