(* Time-stamp: <Sat Jan 18 2003 00:02:33 Stardate: [-30]9699.80 hwloidl>
   Title:      GrailState.thy
   ID:         $Id: GrailState.thy,v 1.1 2003/01/29 12:25:05 a1hloidl Exp $
   Author:     ME
   Copyright:  GPL
   Language:   Klingon
*)

theory GrailState = GrailAbsyn:

subsection "Types"

(* Locations, i.e. abstract references to objects *)
typedecl  Loc

(* Better use "Loc option" here -- HWL *)
datatype Reference = nullRef 
                   | locRef "Loc"

(* Stack (or runtime) values *)
datatype SVal  = rtVoid 
               | rtInt "int" 
               | rtRef "Reference"

types RTVal = SVal

consts
 the_Int    :: "SVal \<Rightarrow> int"
 the_Ref    :: "SVal \<Rightarrow> Reference"
consts
 the_Loc    :: "Reference \<Rightarrow> Loc"

primrec
 "the_Int (rtInt i) = i"
primrec
 "the_Ref (rtRef r) = r"
primrec
 "the_Loc (locRef a) = a"

types 
  Fields = "Fname \<leadsto> SVal"  (* field name, defining class, value *)
  Obj = "Cname * Fields"    (* class instance with class name and fields *)
  HVal = "Obj"

(* See non-terminal FieldDef in GrailAbsyn.thy *)
(* Field declaration *)
types   FDecl          
        = "Fname * RTy"
types   FMap
        = "Fname \<leadsto> RTy"
types   VMap
        = "Fname \<leadsto> SVal"

(* Function declaration *)
types   UMap
        = "Mname \<leadsto> (ArgList * FunBody)"

(* See non-terminal MethDef in GrailAbsyn.thy *)
(* Method body representation (these records live on the heap) *)
record  Methd           
        = (* par :: Type  *)
          res  :: "RTy"
          args :: "ArgList"              (* "(RTy * Vname) list" *)
          bdy  :: "MethBody"
          funs :: "UMap"

(* Method declaration *)
types   MDecl
        = "Mname * Methd"
types   MMap
        = "Mname \<leadsto> Methd"

record  Class
        = super   :: "Cname"  (* link to superclass *)
          flds    :: "FMap"   (* types of fields *)
          vars    :: "VMap"   (* class variables *)
          mthds   :: "MMap"   (* methods of that class *)

(* Class declaration *)
types   CDecl
        = "Cname * Class"
types   CMap
        = "Cname \<leadsto> Class"

(* Program looks likes this *)
types   Prog
        = "CDecl list * MethBody" 

subsection "State"

(* These are the main components of a state *)
types   (* Heap   = "Loc   \<leadsto> Obj" *) (* for full Grail *)
        Locals = "Vname \<leadsto> SVal" 
        MethodStore = "Cname \<leadsto> Class"
        Heap = "Loc \<leadsto> HVal"
        FrameStack = "(SVal option) list"

(* For now time and size are both measured in plain nats. For time we could
   use a table mapping instructions to frequencies instead *)
types   Time = nat
        HeapSz = nat

(* da: add frame stack here and remove heapsz (maybe add max frame stack size) *)
(* later on maybe max heap size if we model GC *)
record  State
        = heap        :: Heap          (* holds objects *)
          methodStore :: MethodStore   (* holds method definitions *)
          locals      :: Locals        (* holds values and addresses into heap *)
          frameStack  :: FrameStack    (* holds activation records for method invocations *)
          CC          :: Cname         (* current class *)
          CM          :: Mname         (* current method *)
          clock       :: Time          (* recording elapsed time *)
          (* heapsz :: HeapSz               recording total heap required *)

(*
translations
  "Fields" \<leftharpoondown> (type)"Vname \<Rightarrow> SVal option"
  "Obj"    \<leftharpoondown> (type)"Cname * Fields"
  "State"  \<leftharpoondown> (type)"(|heap :: Heap, locals :: Locals, clock :: Time|)"
*)

constdefs
  method :: "State \<Rightarrow> Cname \<Rightarrow> Mname \<Rightarrow> MethBody"
 "method s c m \<equiv> bdy (the (mthds (the ((methodStore s) c)) m))"

constdefs
  field  :: "State \<Rightarrow> Loc \<Rightarrow> Fname \<Rightarrow> SVal"
 "field s loc f \<equiv> the ((snd (the ((heap s) loc))) f)"

(*
constdefs
  body :: "State \<Rightarrow> Cname \<Rightarrow> Mname \<Rightarrow> MethBody"
 "body s c m \<equiv> the (method C m)"
*)
constdefs
  init_vars:: "('a \<leadsto> 'b) \<Rightarrow> ('a \<leadsto> SVal)"
 "init_vars m \<equiv> option_map (\<lambda>T. rtRef nullRef) o m"
  
constdefs
  (* set state to "empty" *)
  del_locs     :: "State \<Rightarrow> State"
 "del_locs s \<equiv> s (| locals := empty, clock := 0 |)"

  (* BUGGY *)
  (* initialise with values from another state 
  init_locs     :: "Cname \<Rightarrow> Mname \<Rightarrow> State \<Rightarrow> State"
 "init_locs C m s \<equiv> s (| locals := locals s ++ 
                         init_vars (map_of (lcl (the (method C m)))) |)"
  *)

constdefs
  (* juggling with locations *)
  set_locs  :: "State \<Rightarrow> State \<Rightarrow> State"
 "set_locs s s' \<equiv> s' (| locals := locals s |)"

constdefs
  get_local     :: "State \<Rightarrow> Vname \<Rightarrow> SVal"    ("_<_>" [99,0] 99)
 "get_local s x  \<equiv> the ((locals s) x)"
  get_local_Int :: "State \<Rightarrow> Vname \<Rightarrow> int"    ("_<_>\<^sub>i" [99,0] 99)
 "get_local_Int s x  \<equiv> the_Int (the ((locals s) x))"
  get_local_Ref :: "State \<Rightarrow> Vname \<Rightarrow> Reference"    ("_<_>\<^sub>r" [99,0] 99)
 "get_local_Ref s x  \<equiv> the_Ref (the ((locals s) x))"

(*
constdefs
  get_body :: "Loc \<Rightarrow> State \<Rightarrow> MethBody"
 "get_body f s \<equiv> snd (the (heap s f))"

 "get_body f s \<equiv> case snd (the (heap s f)) of 
                   FUNbody decs res \<Rightarrow> (decs,res)"
*)
(*lenb 01/12/2002*)
constdefs 
  upd_obj    :: "Loc \<Rightarrow> Vname \<Rightarrow> SVal \<Rightarrow> State \<Rightarrow> State"  
 "upd_obj a f v s \<equiv> let (c,fs) = the (heap s a) 
                    in  s (|heap := (heap s)(a |-> (c,fs (f |-> v)))|)"

constdefs
  get_obj       :: "State \<Rightarrow> Loc \<Rightarrow> HVal"
 "get_obj s a \<equiv> the (heap s a)"

constdefs
  obj_class     :: "State \<Rightarrow> Loc \<Rightarrow> Cname"
 "obj_class s a \<equiv> fst (get_obj s a)"

constdefs
  get_class     :: "State \<Rightarrow> Cname \<Rightarrow> Class"
 "get_class s cn \<equiv> the ((methodStore s) cn)"

(* Basic access functions for fields *)
constdefs
  get_field     :: "State \<Rightarrow> Loc \<Rightarrow> Vname \<Rightarrow> SVal"
 "get_field s a fn \<equiv> the (snd (get_obj s a) fn)"

constdefs
  put_field     :: "State \<Rightarrow> Loc \<Rightarrow> Vname \<Rightarrow> SVal \<Rightarrow> State"
 "put_field s a fn v \<equiv> upd_obj a fn v s"

constdefs
  get_static     :: "State \<Rightarrow> Fname \<Rightarrow> SVal"
 "get_static s fn \<equiv>
    let oldClass = get_class s (CC s)
    in  the ((vars oldClass) fn)"

constdefs
  put_static     :: "State \<Rightarrow> Fname \<Rightarrow> SVal \<Rightarrow>  State"
 "put_static s fn v \<equiv> 
    let cn = CC s
    in  let oldClass =  the ((methodStore s) cn)
    in  let newClass = oldClass (| vars := (vars oldClass) (fn \<mapsto> v) |)
    in  s (| methodStore := (methodStore s) (cn \<mapsto> newClass) |)"

constdefs
  get_body :: "State \<Rightarrow> Loc \<Rightarrow> Mname \<Rightarrow> MethBody"
 "get_body s a m \<equiv> let c = obj_class s a 
                   in  bdy (the ((mthds (the ((methodStore s) c))) m))"

(* get a function body from the function store *)
constdefs
  get_funbody :: "State \<Rightarrow> Loc \<Rightarrow> Mname \<Rightarrow> Mname \<Rightarrow> FunBody"
 "get_funbody s a mname fname \<equiv> 
    let c = obj_class s a 
    in let m = the ((mthds (the ((methodStore s) c))) mname)
    in snd (the ((funs m) fname))"

(* uses a Cname rather than an address *)
constdefs
  get_funbody2 :: "State \<Rightarrow> Cname \<Rightarrow> Mname \<Rightarrow> Mname \<Rightarrow> FunBody"
 "get_funbody2 s cname mname fname \<equiv> 
    snd (the (funs (the (mthds (the (methodStore s cname)) mname)) fname))"

(* create new obj on heap
   ToDo: get class vars from class declaration *)
constdefs 
  new_obj    :: "Loc => Cname => State => State" 
  (* "new_obj a C \<equiv> hupd (a \<mapsto> (C,init_vars (field C)))" *)
 "new_obj a c s \<equiv> s (| heap := (heap s)(a |-> (c, \<lambda> f. None)) |)"

(* Given a classname <c> and a methodname <m>, 
   return the body of this method. 
*)
constdefs
  get_method   :: "State => Cname => Mname => Methd"
 "get_method s c m \<equiv> the ((mthds (the ((methodStore s) c))) m)"

constdefs
  get_methodBody   :: "State => Cname => Mname => MethBody"
 "get_methodBody s c m \<equiv> bdy (the ((mthds (the ((methodStore s) c))) m))"

(* Return classname and methodname from a method description *)
constdefs
  grab_mdesc :: "MethDesc => (Cname * Mname * RTy * ArgList)"
 "grab_mdesc mdesc \<equiv> case mdesc of 
                                 (MDESC rty cname mname atys) => (cname,mname,rty,atys)"

(* Field declaration:
    add the fieldname <f> of type <ty> to state <s>
*)
constdefs
  fiupd       :: "State \<Rightarrow> RTy \<Rightarrow> Vname \<Rightarrow> State"
 "fiupd s ty fn \<equiv>
    let cn = CC s
    in  let oldClass = the ((methodStore s) cn)
    in  let newFields = (flds oldClass) (fn \<mapsto> ty)
    in  let newMS = (methodStore s) (cn \<mapsto> oldClass (| flds := newFields |))
    in  s (| methodStore := newMS |)"

(* Method update:
   add the code <b> with return type <ty> and argument list <as> to the
   method store, and bind it to the method name <mn>
*)
constdefs
  mupd       :: "State \<Rightarrow> RTy \<Rightarrow> Mname \<Rightarrow> ArgList \<Rightarrow> MethBody \<Rightarrow> State"
 "mupd s ty mn as b \<equiv> 
    let cn = CC s
    in  let oldClass = the ((methodStore s) cn)
    in  let newMthd = (| res = ty, args = as, bdy = b, funs = empty |)
    in  let newMthds = (mthds oldClass) (mn \<mapsto> newMthd)
    in  let newMS = (methodStore s) (cn \<mapsto> oldClass (| mthds := newMthds |))
    in  s (| methodStore := newMS |)"

(* ngaq Doch
constdefs
  mupd       :: "State \<Rightarrow> RTy \<Rightarrow> Mname \<Rightarrow> ArgList \<Rightarrow> MethBody \<Rightarrow> State"
 "mupd s ty m as b \<equiv> 
    let c = CC s
    in  let myCoolMethod = (| res = ty, args = as, bdy = b, funs = empty |)
    in  let new_mthds = (mthds (the ((methodStore s) c))) (m \<mapsto> myCoolMethod)
    in  s (| methodStore := (methodStore s) 
                             (c \<mapsto>
                                (| flds = flds (the (methodStore s c)),  
                                   mthds = new_mthds |) ) |)"
*)
(* Heap update: 
     add an obj <obj> at address <a> the heap of state <s>
*)
constdefs
  hupd       :: "Loc \<Rightarrow> HVal \<Rightarrow> State \<Rightarrow> State"
 "hupd a obj s \<equiv> s \<lparr> heap := ((heap s) (a \<mapsto> obj)) \<rparr>"

(* Function update:
    add function body <b> and argument list <as> to the functions of
    method <mn>, and bind it to the name <fn>
*)
constdefs
  fupd       :: "Loc \<Rightarrow> Mname \<Rightarrow> Mname \<Rightarrow> ArgList \<Rightarrow> FunBody \<Rightarrow> State \<Rightarrow> State"
 "fupd a mn fn as b s \<equiv> 
    let cn = (obj_class s a)
    in let oldClass = the ((methodStore s) cn)
    in let oldM = the ((mthds oldClass) mn)
    in let newM = oldM (| funs := (funs oldM) (fn \<mapsto> (as,b)) |)
    in let newClass = oldClass (| mthds := (mthds oldClass) (mn \<mapsto> newM) |)
    in let newMS = (methodStore s) (cn \<mapsto> newClass)
    in s (| methodStore := newMS |)"

(*
    in let new_funs = (funs m) (fn \<mapsto> (as,b))
    in let res0 = res m
    in let args0 = args m
    in let bdy0 = bdy m
    in let newM  = (| res = res0, args = args0, bdy = bdy0, funs = new_funs |)
*)
(*
(methodStore s) 
                             (c \<mapsto>
                                (| mthds = m (| res = (res m),
                                                args = (args m),
                                                bdy = (bdy m),
                                                funs = (funs m) |) |) ) |)"
*)
(*
res = (res m),
                                                args = (args m),
                                                bdy = (bdy m),
                                                
*)
(*
flds = flds (the (methodStore s c)),  
*)

(* Local values (stack) update: 
     add the value <sv> to the local values of state <s> under name <x>
*)
constdefs
  lupd       :: "Vname \<Rightarrow> SVal \<Rightarrow> State \<Rightarrow> State" 
 "lupd x sv s  \<equiv> s \<lparr> locals := ((locals s)(x \<mapsto> sv)) \<rparr>"

(*   ("hupd' (_|->_,_) _") *)
(*   ("lupd' (_|->_) _")   *)
(*
syntax (xsymbols)
  hupd       :: "Loc \<Rightarrow> HVal \<Rightarrow> State \<Rightarrow> State"   ("Hupd (_|\<mapsto>_) _)" [10,10] 1000)
  lupd       :: "Vname \<Rightarrow> SVal \<Rightarrow> State \<Rightarrow> State" ("Lupd (_|\<mapsto>_) _')" [10,10] 1000)
constdefs
  upd_obj    :: "Loc \<Rightarrow> Fname \<Rightarrow> SVal \<Rightarrow> State \<Rightarrow> State"
 "upd_obj a f v s \<equiv> let (c,fmap) = the ((heap s) a) 
                           in  hupd (a\<mapsto>(c,fm(f\<mapsto>v))) s"
*)

constdefs
  new_Addr      :: "State \<Rightarrow> SVal"
 "new_Addr s == rtRef (SOME v. (\<exists>r. v = locRef r \<and> (heap s) r = None) | v = nullRef)"

(* for arrays
constdefs
  size_of :: "Ty \<Rightarrow> int"
 "size_of (INTty) = 4
  size_of (BOOLEANty) = 1 
  size_of (REFty s) = 4
  size_of (ARRAYty t) = "

constdefs 
  init_Fields :: "Ty \<Rightarrow> int \<Rightarrow> FMap"
 "init_Fields ty sz = \<lambda> f . case f of 
                               TY \<Rightarrow> ty
                             | SZ \<Rightarrow> sz
                             | otherwise \<Rightarrow> None"

constdefs
  init_Arr :: "Ref \<Rightarrow> Ty \<Rightarrow> int \<Rightarrow> State \<Rightarrow> State"
 "init_Arr a ty sz s = let myMap = init_Fields ty sz 
                       in  s \<lparr> heap := (heap s).(a \<mapsto> (arrayClass, myMap)) \<rparr>"

constdefs
  get_type :: "Vname \<Rightarrow> Ty"
 "get_type v s = let locRef a = s<v>
                 in  (snd ((heap s) a)) TY

constdefs
  get_arr_elem :: "Ref \<Rightarrow> int \<Rightarrow> int \<Rightarrow> RTVal"
 "get_arr_elem a i sz = let x = 2 + i*sz
                        in  ((snd (heap s) a) PL) x"

constdefs
  put_arr_elem :: "Ref \<Rightarrow> int \<Rightarrow> int \<Rightarrow> RTVal \<Rightarrow> RTVal"
 "put_arr_elem a i sz z = let x = 2 + i*sz
                          in  ((snd (heap s) a) PL) \<lparr> x := z \<rparr>"

constdefs
  length_of_arr :: "Ref \<Rightarrow> State \<Rightarrow> int"
 "length_of_arr a s = (snd ((heap s) a)) SZ"
*)

(* Basic functions on heap and time components of the state *)
constdefs
  tick :: "State \<Rightarrow> State"
 "tick s \<equiv> s (| clock := (clock s)+1 |)"

  elapsedTime :: "State \<Rightarrow> Time \<Rightarrow> bool"
 "elapsedTime s c \<equiv> clock s = c"

  inheritTime :: "State => State => State"
 "inheritTime s1 s2 == s1 (| clock := (clock s2)  |)"

(*
  requiredHeap :: "State \<Rightarrow> HeapSz \<Rightarrow> bool"
 "requiredHeap s z \<equiv> heapsz s = z"
*)

subsection "Init values for State etc"

(* Constants *)
  
consts
 rootClass :: "Cname"

consts
 rootObj :: "Obj"

consts
 mainMethod :: "Mname"

consts 
  This :: "Vname" --{* This pointer *}
  (* Par  :: "Vname" --{* method parameter *} *)
  (* Res  :: "Vname" --{* method result *} *)

constdefs
   maxClassRecDep :: nat
  "maxClassRecDep \<equiv> 99"

(* Initial settings for environments *)

constdefs emptyLocals ::"Locals"
"emptyLocals \<equiv> (\<lambda> x . None)"

constdefs emptyHeap :: "Heap"
"emptyHeap \<equiv> (\<lambda> l . None)"

constdefs emptyMStore :: "MethodStore"
"emptyMStore \<equiv> (\<lambda> l . None)"

constdefs emptyState :: "State"
"emptyState \<equiv> \<lparr> heap = emptyHeap, methodStore = emptyMStore, locals = emptyLocals, frameStack = Nil, CC = rootClass, CM = mainMethod, clock = 0 \<rparr>"

subsection "Lemmas over init thingies"

lemma [simp]:
  "clock emptyState = 0"
apply (unfold emptyState_def)
apply (simp add:GrailState.State.clock_update_def)
done


(*
lemma get_body_nodec:
  "!! a. !! s. get_body a s = get_body a (s (| locals := empty |))"
apply (unfold get_body_def)
apply (simp)
done
*)
(*
lemma "\<forall> m. \<forall> a . a \<in> dom m --> ((init_vars m) a = None | the ((init_vars m) a) = rtRef nullRef)"
*)

end