theory GrailExampleInc = GrailDynSem:

section "Predicates over Resource Consumption"

constdefs 
  needsTime :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) = n))"

  boundedTime :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) <= n))"

  needsTimeWithState :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') = n))"

  boundedTimeWithState :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') <= n))"

  boundedTimeV :: "Value \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeV \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>) & (clock s) <= n))"

section "Example programs"

subsection "inc"

text {*
 Simple example mainly testing function call and parameter passing.

 inc (int i) {
   let 
     j+1
   in 
     return j;
 }
*}

consts inc :: "Mname"
consts i :: "Vname"
consts j :: "Vname"

constdefs incRes :: "Result"
"incRes \<equiv> PRIMres (OPres (INVOKESTATICop (MDESC INTty rootClass inc []) EMPTYvar))"

constdefs incCall :: "MethBody"
"incCall \<equiv> MBODY
                         EMPTYdec
                         EMPTYfundec
                         incRes"

constdefs incBody :: "MethBody"
"incBody \<equiv> MBODY
                (FULLdec (VALdec j 
                           (BINop ADDop (VARval i) (INTval 1)))
                   EMPTYdec) 
                EMPTYfundec
                (PRIMres (OPres (VALop (VARval j))))"

constdefs incMeth :: "Methd"
"incMeth \<equiv> \<lparr> res = RTy.INTty, args = FULLal (ARG Ty.INTty i) EMPTYal, bdy = incBody, funs = empty \<rparr>"

constdefs incHeap :: "Heap"
"incHeap \<equiv>  
   emptyHeap"

constdefs incMStore :: "MethodStore"
"incMStore \<equiv>  
   emptyMStore ( rootClass \<mapsto> \<lparr> super = rootClass, flds = empty, vars = empty, mthds = empty(inc \<mapsto> incMeth) \<rparr> )"

constdefs incState :: "State"
"incState \<equiv> emptyState \<lparr> heap := incHeap, methodStore := incMStore \<rparr>"
section "Resource lemmas"

subsection "inc"

lemma inc_time: "boundedTimeWithState incState
                  (MBODY 
                    EMPTYdec 
                    EMPTYfundec 
                    incRes)
             3"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (unfold incRes_def)
apply (rule conjI)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule INVOKESTATICop)
apply (unfold grab_mdesc_def)
apply (simp_all)
apply (rule conjI)
apply (simp_all)
apply (unfold incState_def)
apply (unfold get_method_def)
apply (simp)
apply (unfold incMStore_def)
apply (simp)
apply (unfold incMeth_def)
apply (simp)
apply (unfold incBody_def)
apply (rule MBODY)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp_all)
apply (rule INTval)
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule VALop)
apply (rule VARval)
apply (unfold lupd_def)
apply (simp_all)
apply (simp add: tick_def)
done
(* OK *)

ML_command {* writeln "Resource property has been proved!!"; *}
ML_command {* OS.Process.exit(OS.Process.success):unit; *}

end