(* 
   Title:      GrailDynSem.thy
   ID:         $Id: GrailDynSem.thy,v 1.1 2003/01/30 17:16:28 a1hloidl Exp $ 
   Author:     ME
   Copyright:  GPL
   Shield frequency: 98.112 GHz

   Dynamic semantics for Grail (eventually...).
*)

theory GrailDynSem = GrailState + Main:

subsection "Aux functions"

(* I suppose both constdefs and primrec can be used for defining evalBOP and 
   evalTest; not sure which is better; this definitely looks ugly *)

constdefs evalBOP :: "BinOp \<Rightarrow> RTVal \<Rightarrow> RTVal \<Rightarrow> RTVal"
 "evalBOP binop N M \<equiv>
  (case N of 
     rtVoid \<Rightarrow> rtVoid
   | rtInt n \<Rightarrow> 
      (case M of 
          rtVoid \<Rightarrow> rtVoid
        | rtInt m \<Rightarrow>
           (case binop of 
               ADDop \<Rightarrow> rtInt (n + m)
             | SUBop \<Rightarrow> rtInt (n - m)
             | MULop \<Rightarrow> rtInt (n * m))
        | rtRef ref \<Rightarrow> rtVoid )
   | rtRef ref \<Rightarrow> rtVoid )"


constdefs btoi :: "bool \<Rightarrow> int"
 "btoi b \<equiv> if b then 1 else 0"

constdefs evalTest :: "Test \<Rightarrow> RTVal \<Rightarrow> RTVal \<Rightarrow> RTVal"
 "evalTest test N M \<equiv>
   (case N of 
       rtVoid \<Rightarrow> rtVoid
     | rtInt n \<Rightarrow> (case M of 
                     rtVoid \<Rightarrow> rtVoid
                   | rtInt m \<Rightarrow> (case test of 
                                    EQUALStest \<Rightarrow> rtInt (btoi (n = m))
                                  | IStest \<Rightarrow> rtVoid
                                  | LESStest \<Rightarrow> rtInt (btoi (n < m)))
                   | rtRef ref \<Rightarrow> rtVoid )
     | rtRef refn \<Rightarrow> (case M of 
                        rtVoid \<Rightarrow> rtVoid
                      | rtInt i \<Rightarrow> rtVoid
                      | rtRef refm \<Rightarrow> (case test of
                                          EQUALStest \<Rightarrow> rtVoid
                                        | IStest \<Rightarrow> rtInt (btoi (refn = refm))
                                        | LESStest \<Rightarrow> rtVoid )) ) "

subsection "Substitutions"

(* bind values to formal params and pass them on the stack *)
consts
  initStack :: "VarList => ArgList => State => State" 
primrec 
 "initStack EMPTYvar       aaa s = s"
 "initStack (FULLvar v vs) aaa s = 
   (case aaa of 
        EMPTYal         \<Rightarrow> s
      | (FULLal arg as) \<Rightarrow>
          (case arg of 
              (ARG ty a) \<Rightarrow> 
                 let s0 = s (| locals := (locals s)(a \<mapsto> s<v>) |)
                 in  initStack vs as s0))"

(* doesn't work yet 
constdefs
  mylookup :: "Cname => Mname => RTy => ArgList => State => Cname option"
 "mylookup cn mn rty atys s \<equiv> 
    if cn = rootClass
      then if  mn \<in> dom (mthds (the ((methodStore s) cn))) 
             then Some cn
             else lookup (super (the ((methodStore s) cn))) mn rty atys s"
*)
(* delete push etc functions! *)

(* parameter passing from VarList to ArgList; 
   does it really have to be *this* ugly !??
   now I'm really depressed *)
(* da: could use map if use Isbelle list type in grammar *)
consts
  pushArgs :: "VarList => ArgList => State => State" 
primrec 
 "pushArgs EMPTYvar       aaa s = s"
 "pushArgs (FULLvar v vs) aaa s = 
   (case aaa of 
        EMPTYal         \<Rightarrow> s
      | (FULLal arg as) \<Rightarrow>
          (case arg of 
              (ARG ty a) \<Rightarrow> 
                 let s0 = s (| frameStack := ((locals s) a) # (frameStack s),
                               locals := (locals s)(a \<mapsto> s<v>) |)
                 in  pushArgs vs as s0))"
  (* ToDo: check that types match *)

(* debugging only:
        EMPTYal         \<Rightarrow> s \<lparr> frameStack := None # (frameStack s) \<rparr>
*)

(* getFrame as list and leave frameStack unchanged *)
consts
  getFrame :: "VarList \<Rightarrow> State \<Rightarrow> (SVal option) list" 
primrec 
 "getFrame EMPTYvar       s = []"
 "getFrame (FULLvar v vs) s = hd (frameStack s) # (getFrame vs s)"

consts
  popArgs0 :: "VarList \<Rightarrow> (SVal option) list \<Rightarrow> State \<Rightarrow>  State" 
primrec 
 "popArgs0 EMPTYvar       fs s = s \<lparr> frameStack := drop (length fs) (frameStack s) \<rparr>"
 "popArgs0 (FULLvar v vs) fs s = 
   popArgs0 vs (tl fs) (s \<lparr> locals := (locals s) (v \<mapsto> the (hd fs)) \<rparr>)"

constdefs
  popArgs :: "VarList \<Rightarrow> State \<Rightarrow> State"
 "popArgs vs s \<equiv> popArgs0 vs (getFrame vs s) s"

subsection "Main evaluation functions"

subsubsection "Prototypes and Syntax"

text {* main evaluation function *}
(* Evaluation function is actually a set; as in NanoJava
   One eval function per non-terminal *)
consts
 eval_Result   :: "(Result   * State * RTVal * State) set"
 eval_PrimRes  :: "(PrimRes  * State * RTVal * State) set"
 eval_CondHead :: "(CondHead * State * RTVal * State) set"
 eval_PrimOp   :: "(PrimOp   * State * RTVal * State) set"
 eval_Value    :: "(Value    * State * RTVal * State) set"
 eval_LetDec   :: "(LetDec   * State * RTVal * State) set"
 eval_LetDecs  :: "(LetDecs  * State * RTVal * State) set"
 eval_Arg      :: "(Arg      * State * RTVal * State) set"
 eval_ArgList  :: "(ArgList  * State * RTVal * State) set"
 eval_MethBody :: "(MethBody * State * RTVal * State) set"
 eval_MethDef  :: "(MethDef  * State * RTVal * State) set"
 eval_FieldDef :: "(FieldDef * State * RTVal * State) set"
 eval_ClassDef :: "(ClassDef * State * RTVal * State) set"
 eval_FunBody  :: "(FunBody  * State * RTVal * State) set"
 eval_FunDec   :: "(FunDec   * State * RTVal * State) set"
 eval_FunDecs  :: "(FunDecs  * State * RTVal * State) set"

(* prettier syntax; \<longrightarrow> is annotated with (first letter of) name of non-term *)
syntax
 eval_Result   :: "[Result,State,RTVal,State] \<Rightarrow> bool"    ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>r \<langle>_,_\<rangle>")
 eval_PrimRes  :: "[PrimRes,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>p \<langle>_,_\<rangle>")
 eval_CondHead :: "[CondHead,State,RTVal,State] \<Rightarrow> bool"  ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>h \<langle>_,_\<rangle>")
 eval_PrimOp   :: "[PrimOp,State,RTVal,State] \<Rightarrow> bool"    ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>o \<langle>_,_\<rangle>")
 eval_Value    :: "[Value,State,RTVal,State] \<Rightarrow> bool"     ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>v \<langle>_,_\<rangle>")
 eval_LetDec   :: "[LetDec,State,RTVal,State] \<Rightarrow> bool"    ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>l \<langle>_,_\<rangle>")
 eval_LetDecs  :: "[LetDecs,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>1 \<langle>_,_\<rangle>")
 eval_Arg      :: "[Arg,State,RTVal,State] \<Rightarrow> bool"       ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>a \<langle>_,_\<rangle>")
 eval_ArgList  :: "[ArgList,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>2 \<langle>_,_\<rangle>")
 eval_MethBody :: "[MethBody,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>m \<langle>_,_\<rangle>")
 eval_MethDef  :: "[MethDef,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>n \<langle>_,_\<rangle>")
 eval_FieldDef :: "[FieldDef,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>i \<langle>_,_\<rangle>")
 eval_ClassDef :: "[ClassDef,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>c \<langle>_,_\<rangle>")
 eval_FunBody  :: "[FunBody,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>b \<langle>_,_\<rangle>")
 eval_FunDec   :: "[FunDec,State,RTVal,State] \<Rightarrow> bool"    ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>f \<langle>_,_\<rangle>")
 eval_FunDecs  :: "[FunDecs,State,RTVal,State] \<Rightarrow> bool"   ("\<langle>_,_\<rangle> \<longrightarrow>\<^sub>3 \<langle>_,_\<rangle>")

(* map syntax to evaluations *)
translations
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>r \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_Result"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>p \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_PrimRes"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>h \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_CondHead"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>o \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_PrimOp"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_Value"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>l \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_LetDec"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>1 \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_LetDecs"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>a \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_Arg"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>2 \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_ArgList"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_MethBody"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>n \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_MethDef"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>i \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_FieldDef"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>c \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_ClassDef"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>b \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_FunBody"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>f \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_FunDec"
 "\<langle>c,s\<rangle> \<longrightarrow>\<^sub>3 \<langle>v,s'\<rangle>" == "(c,s,v,s') : eval_FunDecs"

subsubsection "Evaluation function definition"

(* Expressions *)

(* Costs: 0; constants and variable lookup are for free *)
inductive eval_Value intros
 VARval[intro!]: "\<lbrakk> v = get_local s x \<rbrakk> 
                \<Longrightarrow> 
                \<langle>VARval x,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>"

(* da: lemmas for rewriting of this form?
   \<lbrakk> v = get_local s x; X = (v,s) \<rbrakk> \<Longrightarrow>   (VARval x,s) \<longrightarrow>\<^sub>v X   *)

 INTval[intro!]: "\<langle>INTval i,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtInt i,s\<rangle>"
 NULLval[intro!]: "\<langle>NULLval str,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtRef nullRef,s\<rangle>"

(* Those bloody methods introduce mutual recursion in the aval functions, so now all
   of them have to be defined in one definition *sigh* *)

(* Costs: 1 for every bin op *)
inductive eval_MethBody eval_MethDef eval_FieldDef eval_ClassDef eval_PrimOp eval_PrimRes eval_Result eval_FunBody eval_CondHead eval_LetDecs eval_LetDec intros
 (* MethBody *)
 (* inductive eval_MethBody intros *)
 MBODY[intro!]: "\<lbrakk> 
                 oldLocals = (locals s) ;
                 \<langle>valdecls,s\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid,s1\<rangle> ; 
                 \<langle>fundecls,s1\<rangle> \<longrightarrow>\<^sub>3 \<langle>rtVoid,s2\<rangle> ; 
                 \<langle>b,s2\<rangle> \<longrightarrow>\<^sub>r \<langle>v,s3\<rangle> ;
                 s4 = s3 (| locals := oldLocals |)
                \<rbrakk> 
                \<Longrightarrow> 
                \<langle>MBODY valdecls fundecls b, s\<rangle> \<longrightarrow>\<^sub>m \<langle>v, s4\<rangle>"

 (* MethDef *)
 (* inductive eval_MethDef intros *)
 METHOD[intro!]: "\<lbrakk> 
                s' = mupd s rty mname as b 
                \<rbrakk>   
                \<Longrightarrow> 
                \<langle>METHOD mods rty mname as b, s\<rangle> \<longrightarrow>\<^sub>n \<langle>rtVoid,s'\<rangle>"

 (* FieldDef *)
 (* inductive eval_FieldDef intros *)
 FIELD[intro!]: "\<lbrakk> 
                s' = fiupd s rty fname
                \<rbrakk>   
                \<Longrightarrow> 
                \<langle>FIELD mods rty fname, s\<rangle> \<longrightarrow>\<^sub>i \<langle>rtVoid,s'\<rangle>"

 (* ClassDef *)
 (* inductive eval_ClassDef intros *)
 CLASS[intro!]: "\<lbrakk> 
                 s0 = s (| CC := cname |) ;
                 \<langle>field_defs,s0\<rangle> \<longrightarrow>\<^sub>i \<langle>rtVoid,s1\<rangle> ; 
                 \<langle>meth_defs,s1\<rangle> \<longrightarrow>\<^sub>n \<langle>rtVoid,s2\<rangle>  
                \<rbrakk>   
                \<Longrightarrow> 
                \<langle>CLASS cname field_defs meth_defs, s\<rangle> \<longrightarrow>\<^sub>c \<langle>rtVoid,s2\<rangle>"
                (* ToDo: more than just 1 def!! *)

 (* PrimOp *)
 VALop[intro!]: "\<lbrakk> \<langle>x,s\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s'\<rangle> ; s0 = tick s'\<rbrakk> 
                \<Longrightarrow> 
                \<langle>VALop x,s\<rangle> \<longrightarrow>\<^sub>o \<langle>v,s0\<rangle>"
 BINop[intro!]: "\<lbrakk> \<langle>v1,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtv1,s1\<rangle> ; \<langle>v2,s1\<rangle> \<longrightarrow>\<^sub>v \<langle>rtv2,s2\<rangle> \<rbrakk> 
                \<Longrightarrow>
                \<langle>BINop b v1 v2,s\<rangle> \<longrightarrow>\<^sub>o \<langle>evalBOP b rtv1 rtv2, tick s2\<rangle>"

 (* Objects *)
 NEWop[intro!]: "\<lbrakk> newAddr s = locRef l; new_obj l c s = s0 \<rbrakk>
                \<Longrightarrow>
                \<langle>NEWop c,s\<rangle> \<longrightarrow>\<^sub>o \<langle>rtRef (locRef l), tick s0\<rangle>"
(* da: note added a \<in> dom (heap s1) below because get_field would
   otherwise be defined for all a -- watch use of "the" *)
 GETFIELDop[intro!]:"\<lbrakk> \<langle>VARval x,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtRef r,s0\<rangle> ;
                               locRef a = r ;
                               a \<in> dom (heap s0);
                               get_field s0 a fldname = rtv
                     \<rbrakk>
                \<Longrightarrow>
                \<langle>GETFIELDop x (FDESC fldtype fldname),s\<rangle> \<longrightarrow>\<^sub>o 
                \<langle>rtv, tick s0\<rangle>"
 PUTFIELDop[intro!]:"\<lbrakk> \<langle>VARval x,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtRef(locRef a),s0\<rangle>;
                     \<langle>v,s0\<rangle> \<longrightarrow>\<^sub>v \<langle>rtv,s1\<rangle>;
                     a \<in> dom (heap s1);
                     s2 = put_field s1 a fldname rtv
                     \<rbrakk>
                \<Longrightarrow>
                \<langle>PUTFIELDop x (FDESC fldtype fldname) v, s\<rangle> \<longrightarrow>\<^sub>o 
                \<langle>rtVoid, tick s2\<rangle>"
 GETSTATICop[intro!]:"\<lbrakk> 
                       fldname \<in> dom (vars (get_class s (CC s)));
                       rtv = get_static s fldname 
                     \<rbrakk>
                \<Longrightarrow>
                \<langle>GETSTATICop (FDESC fldtype fldname),s\<rangle> \<longrightarrow>\<^sub>o 
                \<langle>rtv, tick s\<rangle>"
 PUTSTATICop[intro!]:"\<lbrakk> 
                       \<langle>v,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtv,s1\<rangle>;
                       fldname \<in> dom (vars (get_class s1 (CC s)));
                       s2 = put_static s1 fldname rtv
                     \<rbrakk>
                \<Longrightarrow>
                \<langle>PUTSTATICop (FDESC fldtype fldname) v, s\<rangle> \<longrightarrow>\<^sub>o 
                \<langle>rtVoid, tick s2\<rangle>"

 INVOKESTATICop[intro!]: "\<lbrakk> 
                (cname,mname) = grab_mdesc mdesc ;
                m = get_method s cname mname ;
                oldLocals = locals s ; 
                s1 = initStack vs (args m) s ; 
                s2 = s1 \<lparr> CM := mname, CC := cname \<rparr> ;
                b = bdy m ;
                \<langle>b, s2\<rangle> \<longrightarrow>\<^sub>m \<langle>rtv, s3\<rangle> ;
                s4 = s3 (| locals := oldLocals |)
                 \<rbrakk>
                \<Longrightarrow>
                \<langle>INVOKESTATICop mdesc vs, s\<rangle> \<longrightarrow>\<^sub>o 
                \<langle>rtv, tick s4\<rangle>"

 (* array primops
 MAKEop[intro!]: "\<lbrakk> 
                 \<langle>z,s\<rangle> \<longrightarrow>\<^sub>v \<langle>x,s1\<rangle> ;
                 ty = get_type v s ;
                 sz = size_of(ty) ;
                 a = new_Addr s ; 
                 s' = init_Arr a ty sz s ;
                 \<rbrakk>
                 \<langle>MAKEop v z, s\<rangle> \<longrightarrow>\<^sub>o 
                 \<langle>rtv, s'\<rangle>"

 GETop[intro!]: "\<lbrakk>
                 \<langle>d,s\<rangle> \<longrightarrow>\<^sub>v \<langle>i,s1\<rangle> ;
                 rtRef a = s<v> ;
                 \<exists> t . get_type v = ARRAYty t \<and> sz = size_of t ;
                 rtv = get_arr_elem a i sz
                 \<rbrakk>
                 \<Longrightarrow>
                 \<langle>GETop v d, s\<rangle> \<longrightarrow>\<^sub>o 
                 \<langle>rtv, s1\<rangle>"

 SETop[intro!]: "\<lbrakk>
                 \<langle>x,s\<rangle> \<longrightarrow>\<^sub>v \<langle>z,s1\<rangle> ;
                 \<langle>d,s1\<rangle> \<longrightarrow>\<^sub>v \<langle>i,s2\<rangle> ;
                 rtRef a = s<v> ;
                 \<exists> t . get_type v = ARRAYty t \<and> sz = size_of t ;
                 rtv = set_arr_elem a i sz z
                 \<rbrakk>
                 \<Longrightarrow>
                 \<langle>SETop v d x, s\<rangle> \<longrightarrow>\<^sub>o 
                 \<langle>rtv, s2\<rangle>"

 LENGTHop[intro!]: "\<lbrakk>
                 rtRef a = s<v> ;
                 \<exists> t . get_type v = ARRAYty t \<and> sz = size_of t ;
                 rtv = length_of_arr a s
                 \<rbrakk>
                 \<Longrightarrow>
                 \<langle>LENGTHop v, s\<rangle> \<longrightarrow>\<^sub>o 
                 \<langle>rtv, s\<rangle>"

 EMPTYop[intro!]: "\<lbrakk>
                 rtv = (dom (snd ((heap s) a)) - {SZ,TY} = \<emptyset>) ;
                 \<rbrakk>
                 \<Longrightarrow>
                 \<langle>EMPTYop v, s\<rangle> \<longrightarrow>\<^sub>o
                 \<langle>rtv, s\<rangle>
 *)
(* Costs: 1 for fct call; 1 for conditional; rest summed up; here we know thw
          branch to take; in a static analysis that has to be approximated *)
 (* inductive eval_PrimRes eval_Result eval_FunBody intros *)
 OPres[intro!]: "\<lbrakk> \<langle>p,s\<rangle> \<longrightarrow>\<^sub>o \<langle>x,s'\<rangle> \<rbrakk> 
                \<Longrightarrow>
                \<langle>OPres p,s\<rangle> \<longrightarrow>\<^sub>p \<langle>x,s'\<rangle>"
 VOIDres[intro!]: "\<langle>VOIDres,s\<rangle> \<longrightarrow>\<^sub>p \<langle>rtVoid,s'\<rangle>"
 FUNres[intro!]: "\<lbrakk> 
                  b = get_funbody2 s (CC s) (CM s) f ; 
                  \<langle>b,s\<rangle> \<longrightarrow>\<^sub>b \<langle>x,s'\<rangle> \<rbrakk>
                  \<Longrightarrow>
                  \<langle>FUNres f xs,s\<rangle> \<longrightarrow>\<^sub>p \<langle>x,tick s'\<rangle>"
 (* get_body returning a tuple:
 FUNres[intro!]: "\<lbrakk> (decs,res) = get_body f s ; \<langle>decs, s\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid,s1\<rangle> ; \<langle>res,s1\<rangle> \<longrightarrow>\<^sub>r \<langle>x,s2\<rangle> \<rbrakk>
                  \<Longrightarrow>
                  \<langle>FUNres f xs,s\<rangle> \<longrightarrow>\<^sub>p \<langle>x,tick s2\<rangle>"
 *)
 PRIMres[intro!]: "\<lbrakk> \<langle>pres,s\<rangle> \<longrightarrow>\<^sub>p \<langle>v,s'\<rangle>\<rbrakk> 
                   \<Longrightarrow>  
                   \<langle>PRIMres pres,s\<rangle> \<longrightarrow>\<^sub>r \<langle>v,s'\<rangle>"
 CHOICEres_True[intro!]: "\<lbrakk> \<langle>head,s\<rangle> \<longrightarrow>\<^sub>h \<langle>rtInt 1,s'\<rangle>; \<langle>p1,s\<rangle> \<longrightarrow>\<^sub>p \<langle>x,s1\<rangle> \<rbrakk> 
                         \<Longrightarrow> 
                         \<langle>CHOICEres head p1 p2,s\<rangle> \<longrightarrow>\<^sub>r \<langle>x, tick s1\<rangle>"
 CHOICEres_False[intro!]: "\<lbrakk> \<langle>head,s\<rangle> \<longrightarrow>\<^sub>h \<langle>rtInt 0,s'\<rangle>; \<langle>p2,s\<rangle> \<longrightarrow>\<^sub>p \<langle>x,s2\<rangle> \<rbrakk> 
                          \<Longrightarrow> 
                          \<langle>CHOICEres head p1 p2,s\<rangle> \<longrightarrow>\<^sub>r \<langle>x, tick s2\<rangle>"

 FUNbody[intro!]: "\<lbrakk> 
           oldLocals = (locals s) ;
           \<langle>ds, s\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid, s1\<rangle> ; 
           \<langle>r, s1\<rangle> \<longrightarrow>\<^sub>r \<langle>x, s2\<rangle> ;
           s3 = s2 (| locals := oldLocals |)  \<rbrakk> 
           \<Longrightarrow>
           \<langle>FUNbody ds r, s\<rangle> \<longrightarrow>\<^sub>b \<langle>x, s3\<rangle>"

(*
 FUNbody[intro!]: "\<lbrakk> \<langle>decls, s\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid, s1\<rangle> ; \<langle>res, s1\<rangle> \<longrightarrow>\<^sub>r \<langle>x, s2\<rangle> \<rbrakk>
           \<Longrightarrow>
           \<langle>FUNbody decls res, s\<rangle> \<longrightarrow>\<^sub>b \<langle>x, s2\<rangle>"
*)

 (* Costs: 1 for test in head of conditional *)
 (* inductive eval_CondHead intros *)
 CONDhead[intro!]: "\<lbrakk> \<langle>v1,s\<rangle> \<longrightarrow>\<^sub>v \<langle>rtv1,s1\<rangle> ; \<langle>v2,s1\<rangle> \<longrightarrow>\<^sub>v \<langle>rtv2,s2\<rangle> ; x = evalTest t rtv1 rtv2 \<rbrakk> 
            \<Longrightarrow>
            \<langle>CONDhead v1 t v2,s\<rangle> \<longrightarrow>\<^sub>h \<langle>x, tick s2\<rangle>"

(* Declarations; costs are 0 throughout *)

 (* inductive eval_LetDecs intros *) 
 EMPTYdec[intro!]: "\<langle>EMPTYdec,s\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid,s\<rangle>"
 FULLdec[intro!]:  "\<lbrakk> \<langle>l,s\<rangle> \<longrightarrow>\<^sub>l \<langle>rtVoid,s1\<rangle> ; \<langle>ls,s1\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid,s2\<rangle> \<rbrakk>
                \<Longrightarrow>
                \<langle>FULLdec l ls,s\<rangle> \<longrightarrow>\<^sub>1 \<langle>rtVoid,s2\<rangle>"

 (* inductive eval_LetDec intros *)
 VALdec[intro!]: "\<lbrakk> \<langle>p,s\<rangle> \<longrightarrow>\<^sub>o \<langle>x,s'\<rangle> ; s'' = lupd str x s' \<rbrakk> 
                  \<Longrightarrow>
                  \<langle>VALdec str p,s\<rangle> \<longrightarrow>\<^sub>l \<langle>rtVoid,s''\<rangle>"
 VOIDdec[intro!]: "\<lbrakk> \<langle>p,s\<rangle> \<longrightarrow>\<^sub>o \<langle>x,s'\<rangle> \<rbrakk> 
                   \<Longrightarrow>
                   \<langle>VOIDdec p,s\<rangle> \<longrightarrow>\<^sub>l \<langle>rtVoid,s'\<rangle>"

(* modelling the Grail restriction of formal args are same as function args,
   we throw function args away *)

inductive eval_Arg intros
 ARG[intro!]: "\<langle>ARG ty vname,s\<rangle> \<longrightarrow>\<^sub>a \<langle>rtVoid, s\<rangle>"

inductive eval_ArgList intros
 EMPTYal[intro!]: "\<langle>EMPTYal, s\<rangle> \<longrightarrow>\<^sub>2 \<langle>rtVoid, s\<rangle>"
 FULLal[intro!]:  "\<lbrakk> \<langle>a,s\<rangle> \<longrightarrow>\<^sub>a \<langle>rtVoid, s'\<rangle> ; \<langle>as,s2\<rangle> \<longrightarrow>\<^sub>2 \<langle>rtVoid,s3\<rangle> \<rbrakk>
                   \<Longrightarrow>
                   \<langle>FULLal a as, s\<rangle> \<longrightarrow>\<^sub>2 \<langle>rtVoid, s3\<rangle>"

(* da: Maybe we could have a class-loading function here which side-effects
   the method store to add the functions being declared: we can treat
   class-loading statically for the time being. *)
inductive eval_FunDecs intros
 EMPTYfundec[intro!]:  "\<langle>EMPTYfundec, s\<rangle> \<longrightarrow>\<^sub>3 \<langle>rtVoid, s\<rangle>"
 FULLfundec[intro!]:   "\<lbrakk> \<langle>f,s\<rangle> \<longrightarrow>\<^sub>f \<langle>rtVoid, s2\<rangle> ; \<langle>fs,s2\<rangle> \<longrightarrow>\<^sub>3 \<langle>rtVoid,s3\<rangle> \<rbrakk>
                        \<Longrightarrow>
                        \<langle>FULLfundec f fs, s\<rangle> \<longrightarrow>\<^sub>3 \<langle>rtVoid, s3\<rangle>"
 
inductive eval_FunDec intros
 FDEC[intro!]:  "\<lbrakk> (locRef a) = s<This>\<^sub>r ; s2 = fupd a (CM s) f as b s \<rbrakk> 
                 \<Longrightarrow>
                 \<langle>FDEC f as b, s\<rangle> \<longrightarrow>\<^sub>f \<langle>rtVoid, s2\<rangle>"

end

