(* Time-stamp: <Tue Dec 03 2002 22:44:19 Stardate: [-30]9474.52 hwloidl> 
   Title:      GrailTypes.thy
   ID:         $Id: GrailTypes.thy,v 1.2 2003/01/30 17:07:52 a1hloidl Exp $
   Author:     ME
   Copyright:  GPL
   Favourite Prime Number: 52999
*)

theory GrailTypes = GrailAbsyn:

text {* Locations, i.e.\ abstract references to objects *}
typedecl  Loc

datatype Reference = nullRef 
                   | locRef "Loc"

datatype SVal  = rtVoid 
               | rtBool "bool" 
               | rtInt "int" 
               | rtString "string" 
               | rtRef "Reference"

consts
 the_Int    :: "SVal \<Rightarrow> int"
 the_Bool   :: "SVal \<Rightarrow> bool"
 the_String :: "SVal \<Rightarrow> string"
 the_Ref    :: "SVal \<Rightarrow> Reference"

primrec
 "the_Int  (rtInt i) = i"
primrec
 "the_Bool (rtBool b) = b"
primrec
 "the_String (rtString s) = s"

types 
  Fields = "Fname \<leadsto> SVal"  (* field name, defining class, value *)
  Obj = "Cname * Fields"     (* class instance with class name and fields *)
  HVal = "Obj"

  (* Vname now in CoreGrailAbsSyn.thy; was: Vname = "string"   *)
  (* now: heap component in State; was: ClosEnv = "Fname => (ValEnv * Var list * LetDec list * Result)" *)
  (* now: locals component in State; was: ValEnv = "Var => SVal" *)

(* See non-terminal FieldDef in GrailAbsyn.thy *)
text{* Field declaration *}
types   FDecl          
        = "Fname * RTy"

types   FMap
        = "Fname \<leadsto> RTy"

(* See non-terminal MethDef in GrailAbsyn.thy *)
text{* Method body representation (these records live on the heap) *}
record  Methd           
        = (* par :: Type  *)
          res  :: "RTy"
          args ::"(RTy * Vname) list"
          bdy  :: "MethBody"

text{* Method declaration *}
types   MDecl
        = "Mname * Methd"
types   MMap
        = "Mname \<leadsto> Methd"

record  Class
        = (* super   :: cname *)
          flds    :: "FMap"
          mthds   :: "MMap"
(*
          flds    ::"FDecl list"
          methods ::"MDecl list"
*)

text{* Class declaration *}
types   CDecl
        = "Cname * Class"

text {* Program looks likes this *}
types   Prog
        = "CDecl list * MethBody" 

(*
translations
  "FDecl" \<leftharpoondown> (type)"Fname * Type"
  "MDecl" \<leftharpoondown> (type)"Mname * Type * Type * FunBody"
  "Class" \<leftharpoondown> (type)"Cname * FDecl list * MDecl list"
  "CDecl" \<leftharpoondown> (type)"Cname * Class"
  (* "prog " \<leftharpoondown> (type)"cdecl list" *)
*)

end
