\begin{verbatim}
subsection "1. Predicates over Resource Consumption"

constdefs 
  boundedTimeWithState :: "State => MethBody => Time => bool"
 "boundedTimeWithState == (% s. % c. % n. (? s'. ? v. 
                           (\<langle>c,s\<rangle> >\<^sub>m \<langle>v,s'\<rangle>) & 
                            (clock s') <= n))"


subsection "2. Program and State"

consts n :: "Vname"
       acc :: "Vname"
       m :: "Vname"
consts fac :: "Fname"
consts elseBranch :: "Fname"
consts facTwo :: "Fname"
consts facThree :: "Fname"
consts facM :: "Mname"
consts facC :: "Cname"

constdefs thenPres:: "PrimRes"
"thenPres == OPres (VALop (VARval n))"

constdefs elsePres:: "PrimRes"
"elsePres == FUNres elseBranch (FULLvar n (FULLvar acc EMPTYvar))"

constdefs facBody::"FunBody"
"facBody == 
  FUNbody EMPTYdec (CHOICEres (CONDhead (VARval n) LESStest (INTval one)) thenPres elsePres)"

constdefs elseBody::"FunBody"
"elseBody == 
  FUNbody (FULLdec (VALdec acc (BINop MULop (VARval acc) (VARval n))) 
            (FULLdec (VALdec n (BINop SUBop (VARval n) (INTval one))) EMPTYdec))
          (PRIMres (FUNres fac (FULLvar n (FULLvar acc EMPTYvar))))"

constdefs facTwoBody :: "FunBody"
"facTwoBody == 
   FUNbody 
     (FULLdec (VALdec n (VALop (INTval (int 2)))) 
       (FULLdec (VALdec acc (VALop (INTval (int 1))))  EMPTYdec))
     (PRIMres (FUNres fac (FULLvar n (FULLvar acc EMPTYvar))))"

constdefs facTwoCall :: "Result"
"facTwoCall == PRIMres (FUNres facTwo EMPTYvar)"

constdefs facUMap :: "UMap"
"facUMap ==  empty 
   (fac |-> ((FULLal (ARG Ty.INTty acc) (FULLal (ARG Ty.INTty n) EMPTYal)), facBody) )
   (elseBranch |-> ((FULLal (ARG Ty.INTty n) (FULLal (ARG Ty.INTty acc) EMPTYal)), elseBody))
   (facTwo |-> (EMPTYal, facTwoBody) ) " 

constdefs facMthd :: "Methd"
 "facMthd == (| 
                    res = RTy.INTty, 
                    args = (FULLal (ARG Ty.INTty acc) (FULLal (ARG Ty.INTty n) EMPTYal)), 
                    bdy = MBODY EMPTYdec EMPTYfundec facThreeCall, 
                    funs = facUMap 
                   |)"

constdefs facClass :: "Class"
 "facClass == (| 
                     super = rootClass, 
                     flds = empty, 
                     vars = empty, 
                     mthds = empty (facM |-> facMthd)
                    |)"

constdefs facMStore :: "MethodStore"
 "facMStore == empty (facC |-> facClass)"

constdefs facState2 :: "State"
 "facState2 == emptyState (| methodStore := facMStore, CC := facC, CM := facM |) "

subsection "3. Proving Resource Properties of Factorial"

lemma fac_a1: "methodStore facState2 = facMStore"

apply (unfold facState2_def)
apply (simp)
done

lemma fac_a2: "get_method facState2 facC facM = facMthd"

apply (unfold get_method_def)
apply (simp add: fac_a1)
apply (unfold facMStore_def)
apply (simp)
apply (unfold facClass_def)
apply (simp)
done

lemma fac_a3: "CC facState2 = facC"
by (unfold facState2_def, simp)

lemma fac_a4: "CM facState2 = facM"
by (unfold facState2_def, simp)

lemma fac_s1[intro!]: "! s . CC (tick s) = CC s"
by (unfold tick_def, simp)

lemma fac_s2[intro!]: "! s . CM (tick s) = CM s"
by (unfold tick_def, simp)

lemma fac_s3[intro!]: "! s . methodStore (tick s) = methodStore s"
by (unfold tick_def, simp)

lemma fac_s4[intro!]: "! s . heap (tick s) = heap s"
by (unfold tick_def, simp)

lemma fac_s5[intro!]: "! s . locals (tick s) = locals s"
by (unfold tick_def, simp)

lemma fac_s7[intro!]: "! s . ! x . get_local (tick s) x = get_local s x"
apply (rule allI)+
apply (unfold get_local_def)
apply (unfold tick_def)
apply (simp)
done

lemma fac_b1: "[| fac ~= elseBranch & fac ~= facTwo |] 
               ==>
               get_funbody2 facState2 facC facM facTwo = facTwoBody"

apply (unfold get_funbody2_def)
apply (unfold facState2_def)
apply (unfold facMStore_def)
apply (unfold facClass_def)
apply (unfold facMthd_def)
apply (simp)
apply (unfold facUMap_def)
apply (simp)
done

lemma fac_b2: "[| fac ~= elseBranch & fac ~= facTwo |] 
               ==>
               get_funbody2 facState2 facC facM fac = facBody"

apply (unfold get_funbody2_def)
apply (unfold facState2_def)
apply (unfold facMStore_def)
apply (unfold facClass_def)
apply (unfold facMthd_def)
apply (simp)
apply (unfold facUMap_def)
apply (simp)
done

lemma fac_b3: "! s . ! c . ! m . ! f . get_funbody2 (tick s) c m f = get_funbody2 s c m f"
by (unfold get_funbody2_def, unfold tick_def, simp)

lemma fac2_true: "[| fac ~= elseBranch & fac ~= facTwo & n ~= acc & elseBranch ~= facTwo |] 
               ==>
             boundedTimeWithState facState2
                  (MBODY 
                    EMPTYdec 
                    EMPTYfundec 
                    (PRIMres (FUNres facTwo EMPTYvar)))
             16"

apply (unfold boundedTimeWithState_def)
apply (rule exI)+
apply (rule conjI)
apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule FUNres)
apply (simp add: fac_a3 fac_a4)
apply (simp add: fac_b1) 
apply (unfold facTwoBody_def)
apply (rule FUNbody)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule VALop)
apply (rule INTval)
apply (unfold lupd_def)
apply (simp)
prefer 2
apply (rule FULLdec)
apply (rule VALdec)
apply (rule VALop)
apply (rule INTval)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule PRIMres)
apply (rule FUNres)
apply (unfold lupd_def)
apply (simp_all)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_a3 fac_a4 fac_b2)+
apply (unfold get_funbody2_def)
apply (unfold facState2_def)
apply (unfold facMStore_def)
apply (unfold facClass_def)
apply (unfold facMthd_def)
apply (simp add: fac_s3)
apply (unfold facUMap_def)
apply (simp)
(* body of fac retrieved from env; n=2 *)
apply (unfold facBody_def)
apply (rule FUNbody)
defer 1
apply (rule EMPTYdec)
apply (rule CHOICEres_False)
apply (rule CONDhead)
apply (rule VARval)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_s7)+
apply (rule INTval)
apply (unfold evalTest_def)
apply (unfold get_local_def)
apply (simp)
apply (unfold btoi_def)
apply (unfold one_def)
apply (simp)
apply (unfold elsePres_def)
apply (rule FUNres)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
apply (unfold elseBody_def)
apply (rule FUNbody)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule VARval)
apply (simp)
apply (unfold lupd_def)
apply (simp_all)
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule INTval)
apply (unfold lupd_def)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule PRIMres)
apply (rule FUNres)
(* recursive call; n=1 *)
apply (simp add: fac_b3)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
(* fct body extracted from env *)
apply (rule FUNbody)
defer 1
apply (rule EMPTYdec)
apply (rule CHOICEres_False)
apply (rule CONDhead)
apply (rule VARval)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_s7)+
apply (rule INTval)
apply (unfold evalTest_def)
apply (unfold get_local_def)
apply (simp)
apply (unfold btoi_def)
apply (unfold one_def)
apply (unfold evalBOP_def)
apply (simp)
apply (rule FUNres)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
apply (rule FUNbody)
defer 1
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule VARval)
apply (simp)
apply (unfold lupd_def)
apply (simp_all)
apply (rule FULLdec)
apply (rule VALdec)
apply (rule BINop)
apply (rule VARval)
apply (simp)
apply (rule INTval)
apply (unfold lupd_def)
apply (simp_all)
apply (rule EMPTYdec)
apply (rule PRIMres)
apply (rule FUNres)
(* recursive call; n=0 BASE CASE *)
apply (simp add: fac_b3)
apply (unfold get_funbody2_def)
apply (simp add: fac_s3 fac_s2 fac_s1)
(* fct body extracted from env *)
apply (rule FUNbody)
defer 1
apply (rule EMPTYdec)
apply (rule CHOICEres_True)
apply (rule CONDhead)
apply (rule VARval)
apply (simp add: fac_s1 fac_s2 fac_s3 fac_s4 fac_s5 fac_s6 fac_s7)+
apply (rule INTval)
apply (unfold evalTest_def)
apply (unfold get_local_def)
apply (simp)
apply (unfold btoi_def)
apply (unfold evalBOP_def)
apply (simp)
apply (unfold thenPres_def)
apply (rule OPres)
apply (rule VALop)
apply (rule VARval)
apply (simp_all)
apply (simp_all add: tick_def clock_update_def)
done
(* OK *)
\end{verbatim}
