(* Time-stamp: <Thu Jan 09 2003 18:16:45 Stardate: [-30]9658.59 hwloidl>
   Title:      GrailTypes.thy
   ID:         $Id: GrailAbsyn.thy,v 1.2 2003/01/30 17:08:14 a1hloidl Exp $
   Author:     ME
   Copyright:  GPL
   Title-in-Morse-Code: --./.-./.-/../.-../-/-.--/.--././.../.-.-.-/-/..../-.--
*)

theory GrailAbsyn=Main :
(*Author: Lennart Beringer*)
(*Date 01/10/2002*)
(* In first approximation the grammar is cut down to CoreGrail *)

(*taken from /progs/Grail/gdf/src/GrailAbsyn.sml*)
(*order changed during adaption to Isabelle*)
(*no float library in Isabelle?*)

(* datatype ClassdeclAccess_flag = "classdeclaccessflag" *)

types 
  Vname = "string"  (* names of variables *)
  Fname = "string"  (* names of functions, i.e.labels of basic blocks *)
  Cname = "string"  (* names of classes *)
  Mname = "string"  (* names of methods *)

datatype Ty = (* many of these aren't accessible from Grail *)
    INTty 
  | BOOLEANty 
  | REFty "string"
  | ARRAYty "Ty"

datatype RTy = 
    INTty 
  | BOOLEANty 
  | REFty "string"
  | ARRAYty "Ty"
  | VOIDTy

(* I avoid using using list constructor of the meta-language; instead I encode
   lists in the grammer; I suppose this makes the embedding deeper than necessary  *)

(* Pointless stuff *)

datatype AccModifiers = PUBLIC | PROTECTED | PRIVATE

datatype BModifiers = STATIC | FINAL

datatype Modifiers = MODS "AccModifiers" "BModifiers option"

(* Expressions *)

datatype Value = VARval "Vname"
               | INTval "int"
               | NULLval "string"

(*  | STRINGval "string" *)
(*  | FLOATval "real"*)

(*lenb 01/12/2002: MethDesc and FieldDesc reactivated*)
(*datatype MethDesc = MDESC "RTy" "string" "Ty list" 
  datatype FieldDesc = FDESC "Ty" "string"*)

datatype MethDesc = MDESC "RTy" "Cname" "Mname" "Ty list" (* NB: Cname added *)

datatype FieldDesc = FDESC "Ty" "Vname"

datatype Test = EQUALStest | IStest | LESStest

datatype BinOp = ADDop | SUBop | MULop

datatype VarList  = EMPTYvar 
                  | FULLvar "Vname" "VarList"

datatype PrimOp =
    VALop "Value"
  | BINop "BinOp" "Value" "Value"
  | NEWop "Cname" (* simplification for the time being*)
  | GETFIELDop "Vname" "FieldDesc"
  | PUTFIELDop "Vname" "FieldDesc" "Value"
  | GETSTATICop "FieldDesc"
  | PUTSTATICop "FieldDesc" "Value"
  | INVOKESTATICop "MethDesc" "VarList"
  | MAKEop "Value" "Value"
  | GETop "Value" "Value"
  | SETop "Value" "Value" "Value"
  | LENGTHop "Value"  
  | EMPTYop "Value" "Ty"
  (* a few PrimOps missing, see below *)

datatype PrimRes = OPres "PrimOp"
                 | VOIDres
                 | FUNres "Fname" "VarList"

datatype CondHead = CONDhead "Value" "Test" "Value"  

datatype Result = PRIMres "PrimRes"
                | CHOICEres "CondHead" "PrimRes" "PrimRes"

(* Declarations *)

(* LetDec should be called ValDec *)
datatype LetDec = VALdec "Vname" "PrimOp"
                | VOIDdec "PrimOp"

datatype LetDecs = EMPTYdec 
                 | FULLdec "LetDec" "LetDecs"

datatype Arg = ARG Ty Vname

datatype ArgList = EMPTYal 
                 | FULLal "Arg" "ArgList"

datatype FunBody = FUNbody "LetDecs" "Result"

datatype FunDec = FDEC "Fname" "ArgList" "FunBody"

datatype FunDecs = EMPTYfundec 
                 | FULLfundec "FunDec" "FunDecs"

(* Methods *)
datatype MethBody = MBODY "LetDecs" "FunDecs" "Result"

datatype MethDef = METHOD "Modifiers" "RTy" "Mname" "ArgList" "MethBody"

datatype FieldDef = FIELD "Modifiers" "RTy" "Fname"

datatype ClassDef = CLASS "Cname" "FieldDef" "MethDef" (* only 1 def for now; FIX! *)
(* datatype ClassDef = CLASS "Cname" "FieldDef list" "MethDef list" *)

(* Top level *)
datatype Prog = PROG "ClassDef list" "MethBody"

(*  | INVOKESTATICop "MethDesc" "Value list" *)
(*
datatype PrimOp =
    VALop "Value"
  | BINop "BinOp" "Value" "Value"
  | NEWop "MethDesc" "Value list"
  | CHECKCASTop "string" "Vname"
  | INSTANCEop "string" "Vname"
  | INVOKESTATICop "MethDesc" "Value list"
  | INVOKEVIRTUALop "Vname" "MethDesc" "Value list"
  | INVOKESPECIALop "Vname" "MethDesc" "Value list"
  | GETFIELDop "Vname" "FieldDesc"
  | PUTFIELDop "Vname" "FieldDesc" "Value"
  | GETSTATICop "FieldDesc"
  | PUTSTATICop "FieldDesc" "Value"
  | MAKEop "Value" "Value"
  | GETop "Value" "Value"
  | SETop "Value" "Value" "Value"
  | LENGTHop "Value"  
  | EMPTYop "Value" "Ty"
  | FTOIop "Value"
  | ITOFop "Value"
*)
(* withtype Var = "string" *)
end
