theory c1 = GrailDynSem:

subsubsection "Predicates over Resource Consumption"

constdefs 
  needsTime :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) = n))"

  boundedTime :: "MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTime \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s\<rangle>) & (clock s) <= n))"

  needsTimeWithState :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "needsTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') = n))"

  boundedTimeWithState :: "State \<Rightarrow> MethBody \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeWithState \<equiv> (\<lambda> s. \<lambda> c. \<lambda> n. (? s'. ? v. (\<langle>c,s\<rangle> \<longrightarrow>\<^sub>m \<langle>v,s'\<rangle>) & (clock s') <= n))"

  boundedTimeV :: "Value \<Rightarrow> Time \<Rightarrow> bool"
 "boundedTimeV \<equiv> (\<lambda> c. \<lambda> n. (\<exists> s. \<exists> v. (\<langle>c,emptyState\<rangle> \<longrightarrow>\<^sub>v \<langle>v,s\<rangle>) & (clock s) <= n))"

section "Resource lemmas"

lemma "\<langle>MBODY EMPTYdec EMPTYfundec (PRIMres (OPres (VALop (INTval 1)))),emptyState\<rangle> \<longrightarrow>\<^sub>m \<langle>rtInt 1, emptyState (| clock := 1 |) \<rangle>"

apply (rule MBODY)
defer 1
apply (rule EMPTYdec)
apply (rule EMPTYfundec)
apply (rule PRIMres)
apply (rule OPres)
apply (rule VALop)
apply (rule INTval)
apply (simp_all add: tick_def inheritTime_def)
apply (simp)+
done
(* OK *)

ML_command {* writeln "Resource property has been proved!!"; *}
ML_command {* OS.Process.exit(OS.Process.success):unit; *}

end