(* Example from Isabelle Tutorial 5.17 *)
theory E = Main:

consts gcd :: "nat*nat => nat"
recdef gcd "measure ((%(m,n).n))"
"gcd (m,n) = (if n=0 then m else gcd(n, m mod n))"

lemma [simp]: "gcd (m, 0) = m"
apply(simp)
done

lemma [simp]: "n ~= 0 ==> gcd(m, n) = gcd(n, m mod n)"
apply(simp)
done

(*
Simplification terminates for these proofs because the condition of the if
simplifies to True or False. Now we can disable the original simplification
rule:
*)

declare gcd.simps [simp del]

(*
lemmas gcd_mult = gcd_mult_distrib2 [of k 1, simplified, THEN sym]

lemma gcd_mult [simp]: "gcd(k, k*n) = k"
by (rule gcd_mult_distrib2 [of k 1, simplified, THEN sym])

lemma gcd_self [simp]: "gcd(k,k) = k"
by (rule gcd_mult [of k 1, simplified])
*)

lemma gcd_dvd_both: "(gcd(m,n) dvd m) & (gcd(m,n) dvd n)"

apply (induct_tac m n rule: gcd.induct)
apply (case_tac "n=0")
apply (simp_all)
apply (blast dest: dvd_mod_imp_dvd)
done

lemmas gcd_dvd1 [iff] = gcd_dvd_both [THEN conjunct1]
lemmas gcd_dvd2 [iff] = gcd_dvd_both [THEN conjunct2]

lemma gcd_greatest [rule_format]:
"k dvd m --> k dvd n --> k dvd gcd(m,n)"

apply (induct_tac m n rule: gcd.induct)
apply (case_tac "n=0")
apply (simp_all add: dvd_mod)
done

theorem gcd_greatest_iff [iff]:
"(k dvd gcd(m,n)) = (k dvd m & k dvd n)"
by (blast intro!: gcd_greatest intro: dvd_trans)

end
