#!/usr/bin/perl 

use strict;

use CGI;
require "demo-setup.pl";
require path_module;

#HWL: set to 0 to get rid of debugging and tracing messages
my $debug_it=0;

my $cgi = new CGI; # neues Objekt erstellen


print "Content-Type: text/html\n\n";
print "<html>";
print "<br>";

print "Entering cgiwrapper<br>" if $debug_it;

my $fname = $cgi->param("action");
my $Verzeichnis;
my @Dateien;
my $flag;

if (($fname eq 'Reset/Grail') || ($fname eq 'Grail') ||
    (index($fname, ".gr" )>0)){
   print '<body bgcolor="#E0EEE0">';
   print '<basefont size="3" color="#E0EEFF">';
   $Verzeichnis = $path_module::grailex;
   chdir($Verzeichnis);
   @Dateien = glob("*.gr");
   $flag=0;
 }
else {
 print '<body bgcolor="#C0EEEE">';
 print '<basefont size="3" color="#E0EEFF">';
 $Verzeichnis = $path_module::camelotex;
 chdir($Verzeichnis);
 @Dateien = glob("*.cmlt");
 $flag=1;
};

my $Datei;

my $wrapper_cgi = $path_module::wrapper;
print "action=|$wrapper_cgi|<br>\n" if $debug_it;

###### Form "Menue": The List of Downloadable examples ####################   

print '<form action="', $wrapper_cgi , '" method="get">';
print "You may choose an example here:", "<br><br>";
print '<table border="2" cellpadding="5" cellspacing="0" bgcolor="#FFFFFF">';
print '<tr>';
print '<td>';
print '<font size="2">';
print '<tt>';
my $i=0;
my $div;
foreach $Datei (@Dateien) {
  print '<input type=submit name=action value=', $Datei, '>';
  $i++;
  $div= int($i / 5); 
  if (($i - $div * 5) > 0) { print "&nbsp;&nbsp;"; }
  else { print "<br>" ; };
};
print '</tt>';
print '</font>';
print '</td>';
print '</tr>';
print '</table>';
print "</form>";

###### end of form ############################


my @Zeilen;

if ((length($fname) == 0) || ($fname eq 'Reset/Grail') || ($fname eq 'Reset/Camelot')  
    || ($fname eq 'Grail') || ($fname eq 'Camelot')){ 
     @Zeilen = (""); }
else { 
       open(DATEI, '<'.$Verzeichnis.'/'.$fname) || die "Datei nicht gefunden";
       flock(DATEI, 2);
       @Zeilen = <DATEI>;
       close(DATEI);
    };

######### Form with Textarea, Uploading and Compiler Runner ################

my $iface_cgi=$path_module::iface;
#"http://129.187.228.110/cgi-bin/mrg/iface.cgi"; # $path_module::iface; # "/cgi-bin/mrg/iface.cgi" ;
print "action=|$iface_cgi|<br>" if $debug_it;
print '<form action="', $iface_cgi , '" method="post" enctype="multipart/form-data">';

print '<hr>';
print "Or/and input/correct your own code here: <br>";
print '<textarea name="code" cols=50 rows=20>';
print @Zeilen;
print "</textarea>";

print "<br>";
print '<hr>';
print "<br>";
print "Or send us a file from your machine:"; 
print "&nbsp;&nbsp; ";
print '<font size="3" color="#000000">';
print '<input type="file" name="upfile">'; #  accept="text/*" maxlength="2097152">';
print "<br>";
print '</font>';

print "<br><br>";

print '<hr>';
print '<font size="3" color="#000000">';
print '<tt>';
if ($flag>0){
 print '<input type="submit" name="action" value="Compile/CamelotToJVML">';
 print '<br>';
 print '<input type="submit" name="action" value="Compile/CamelotToGrail">';
 if (index($fname, ".cmlt")>0) { 
   print '<input type="hidden" name="fileToComp" value=', $fname, '>';
 }
 else {
      print '<input type="hidden" name="fileToComp" value="noname.cmlt">';
      };
}
else { print '<input type="submit" name="action" value="Compile/Grail">';
       if (index($fname, ".gr")>0) {
          print '<input type="hidden" name="fileToComp" value=', $fname, '>';
	}
       else {
         print '<input type="hidden" name="fileToComp" value="noname.gr">';
        }
};
print "<br>";
print "<hr>";
print "<br>";
# HWL: need .thy file to prove something
print '</tt>';
print 'Select an Isabelle theory file containing the resource property';
print "&nbsp;&nbsp; ";
print '<tt>';
print '<input type="file" name="upthy">';
print '<br>';
print '<input type="submit" name="action" value="Prove">';
print '<br>';

print "</form>";

####### end of the form ####################################

print '<hr>';

####### Form to Reset ######################################
print '<form action=', $path_module::wrapper, ' method="get">';
print '<input type="submit" name="action" value="Reset/Grail">';
print '<br>';
print '<input type="submit" name="action" value="Reset/Camelot">';
print "</form>";

####### end of the form ####################################

print "</body>";
print "</html>";
