#!/usr/bin/perl

use strict;

use CGI;
use path_module;
require "demo-setup.pl";

#HWL: ste to 0 to get rid of debugging and tracing messages
my $debug_it=0;

my $cgi = new CGI; # neues Objekt erstellen

my @data = $cgi->param("idata");
my $class = $cgi->param("class");
my $code=$cgi->param("javacode");

## HWL: Should use this function
# &print_header("Running Program on a JVM...",
#               ($path_module::hw =~ s,/mrg1.html,,) . "/mrg.css",
#               "Here are the results from executing the program by the consumer");

print "Content-Type: text/html\n\n";
print "<html>";
print "<head>";
print "<title>Running Program on a JVM</title>";
print "</head>";
print '<body bgcolor="#483D8B" text="#FFFFFF">';
print "<h1>Here are the results of executing the program by the consumer</h1>";
print "<br>";

print "Starting runjava, changing to dir $path_module::javadir<br>\n"  if $debug_it;
chdir($path_module::javadir);
my $classTest = $class."Test";

# $flag is 0 if $classTest.".java" does not exist or is empty
my $flag = 0;
$flag = 1 if -e $classTest.".java";
if ($flag>0){
 $flag = 0 if -z $classTest.".java";
};

if ($flag == 0){
# dateinamen erstellen und die datei auf dem server speichern (WOHIN)
my $fname = $path_module::javadir.$classTest.".java";
open BUF,'>'.$fname or die 'Error processing file: ',$!;
flock(BUF, 2);

if (length($code)>0){
     print BUF $code;
     $flag=1;
   }
else{
    my $file = $cgi->param("upfilejava");
    if (length($file)>0) {
  
    # Dateien in den Binaer-Modus schalten
    binmode $file;
    binmode BUF;

    my $buff;
    while(read $file,$buff,1024) {
      print BUF $buff;
    };
   $flag=1;
  }
};

close BUF;
};
 

my @output;

if ($flag > 0){
 my $classTestE = $classTest.".java";
 print "Executing |$path_module::javac $classTestE|<br>\n" if $debug_it;
 @output=qx($path_module::javac $classTestE);
 print "@output";
 print "<br>";
 print "Executing |$path_module::javarun $classTest @data|<br>\n" if $debug_it;
 @output=qx($path_module::javarun $classTest @data);
 }
else{
print "Executing |$path_module::javarun $class @data|<br>\n" if $debug_it;
@output=qx($path_module::javarun $class @data);
};


my $counter=0;
foreach (@output){
  if (length($_) >0){
    $counter++;
  }
};

if ($counter > 0){
 print "<i>";
 print "Result: ";
 print "</i>";
 print '<br>';
 foreach (@output){
  print "$_" ;
  print '<br>';
  };
}
else{
  print "<i>";
  print "You probably need testing java code or forget to input data";
  print "</i>";
};

print "</body>";
print "</html>";
