#!/usr/bin/perl 

#use strict;

use CGI;
use path_module;

require "demo-setup.pl";
require "demo-aux.pl";
require "demo-iface.pl";

#HWL: set to 0 to get rid of debugging and tracing messages
my $debug_it=0;

my $cgi = new CGI; # neues Objekt erstellen

print "Content-Type: text/html\n\n";

# die datei-daten holen (AUS)
my $file = $cgi->param("upfile");
my $filecomp = $cgi->param("fileToComp");
my $language = $cgi->param("action");
my $fname;
# HWL: I need $upload_dir and $upload_file in my scripts
if ((index($file, ".cmlt")>0) || (index($file, ".gr")>0)){
    $fname = $path_module::userdir.$file;
    # set upload_dir, upload_file, deleting trailing /'s in the former
    $upload_dir = $path_module::userdir;
    $tmp_sep = $/;
    $/ = '/';
    chomp($upload_dir);
    $/ = $tmp_sep;
    $upload_file = $file;
}
else{
    $fname = $path_module::userdir.$filecomp;
    # set upload_dir, upload_file, deleting trailing /'s in the former
    $upload_dir = $path_module::userdir;
    $tmp_sep = $/;
    $/ = '/';
    chomp($upload_dir);
    $/ = $tmp_sep;
    $upload_file = $filecomp;
};
# ASSERT: $fname eq "$upload_dir/$upload_file"
&dienice ("iface: ASSERTION failed: $fname eq $upload_dir/$upload_file") if $debug_it && !($fname eq "$upload_dir/$upload_file");
#print "fname=$fname; $upload_dir/$upload_file=$upload_dir/$upload_file"  if $debug_it;

# $flag is 0 if no code was sent
# $flag is 1 if a Grail code was sent
# $flag is 2 if a Camelot code was sent to be compiled to JVML
# $flag is 3 if a Camelot code was sent to be compiled to Grail
# $flag is 4 if a Proof checker should be called

my $flag;

if ($language eq 'Compile/CamelotToGrail'){
   print '<html><body bgcolor="#C0EEEE">', "\n\n";
   $flag=3;
}
else {
   if ($language eq 'Compile/CamelotToJVML'){
   print '<html><body bgcolor="#E0EEE0">', "\n\n";
   $flag=2;
  }
  else {
       if ($language eq 'Compile/Grail'){
         print '<html><body bgcolor="#E0EEE0">', "\n\n";
         $flag=1;
         }
        else {
	     # HWL: better to use a .css; should change other cases, too (eventually)
             #print '<html><body bgcolor="#9999FF">', "\n\n";
             &print_header("Launch Theorem Prover","$url/demo.css",
                           "Launch Theorem Prover");
             $flag=4;
            };
      };
};


print "<br>";
print "<br>";

###################################################################
#####  Write input for a compiler ################################

&iface($cgi);
# $upload_thy is set in &iface; naughty, naughty
$tname="$upload_dir/$upload_thy" if $cgi->param("upthy") ne ""; 
goto SKIP_UPLOAD;

# HWL->Olha: 
# I'm using the code of iface in demo-iface.pl for now;
# it seems to work and is based on an earlier version of your code;
# I had problems with the code below, but I didn't try to debug it

my $data=$cgi->param("code");
open BUF,'>'.$fname or die 'Error processing file: ',$!;
flock(BUF, 2);

if (length($data)>0){
       print BUF $data;
       print "<i>";
       print "The form is submitted.", "<br>";
       print "We are to work with the text area.", "<br><br>";
       print "</i>";
     }
else {
     # die datei-daten holen (AUS)
     my $file = $cgi->param("upfile");

     if (length($file)>0) {

     # Dateien in den Binaer-Modus schalten
     binmode $file;
     binmode BUF;

     my $filedata;
     while(read $file,$filedata,1024) {
      print BUF $filedata;
      }
     
     print "<i>";
     print "The form is submitted.", "<br>";
     print "We are to work with the file ", $file, ".", "<br><br>";
     print "</i>";
   }
   else {
       print "<i>";
       print "You have sent no code.", "<br><br>";
       print "</i>";
       $flag = 0;
     };
};

close BUF;

SKIP_UPLOAD:

$flag = 0 if -z $fname;

if ($flag>3){
#########################################################################
###### Call HW's page  ################################################

# HWL was here
print "Passing code file $fname and theory file $tname to verifier<br>\n" if $debug_it;
&pass_to_verifier("$fname","$tname"); # "$upload_dir/$upload_file");

# print '<form action=', $path_module::hw, ' method="get" target="_blank">';
# print '<br>';
# print '<hr>';
# print "<i>";
# print "Your file is written in ", "<br>";
# print $fname, "<br>";  
# print "</i>";
# print '<tt>';
# print "<hr>";
# print '<input type="submit" name="action" value="Verifier">';
# print '<input type="hidden" name="fileToVerify" value=', $fname, '>';
# print '<br>';
# print "</form>";
}
else {
#########################################################################
###### Compile the Stuff ################################################
my $flag_error;
my @output;
my $len=0;
if ($flag>0){
 $flag_error=-1;
 print "<hr>";
 print "<pre>";
 print "iface: flag=$flag, gdf=$path_module::gdf<br>\n" if $debug_it;
 if ($flag > 1){
    if ($flag > 2){

     print "Executing |$path_module::camelot -g -c -d $path_module::userdir $fname|<br>" if $debug_it;
     @output=qx($path_module::camelot -g -c -d $path_module::userdir $fname);
    }
    else { 
         print "Executing |$path_module::camelot -c -d $path_module::javadir $fname|<br>" if $debug_it;
         @output=qx($path_module::camelot -c -d $path_module::javadir $fname);
         }
  }
 else {
     print "Executing |$path_module::gdf -c -d $path_module::javadir $fname|<br>" if $debug_it;
     @output=qx($path_module::gdf -c -d $path_module::javadir $fname);
      };
 print "<small>";
 print "Compilation result: ";
 print "</small>";

 $len=@output;

 if ($len>0){
  foreach (@output){
  print $_;
  if (index($_, "error")>=0){
   $flag_error++;
   };
  };
 }
 else{
 $flag_error=0;
 };

 print "</pre>";
 print "<br>";
}
else {
$flag_error=0;
}
##############################################################################
## If Compilation is OK, continue (run or next, Grail->JVML, compilation) ####

if ($flag_error < 0){
  
# Compilation was OK !!!
   print "<pre>";
   if ($flag > 2){
    
######################################################
# Compile the Grail result of Camelot Compiler to Java

    print '<form action=', $path_module::iface, ' method="post" enctype="multipart/form-data">';
    my @Zeilen;
    my $i;
    for ($i=0; $i<$len; $i++){
    open(DATEI, '<'.$path_module::userdir.@output[$i]) || die "Datei nicht gefunden";
    flock(DATEI, 2);
    @Zeilen = <DATEI>;
    close(DATEI);
    print '<hr>';
    print "This is the grail-output: ", @output[$i], "<br>";
    print '<textarea name="code" cols=80 rows=50>';
    print @Zeilen;
    print "</textarea>";
    print "<br>";
  }
    print '<input type="submit" name="action" value="Compile/Grail">';
    print '<input type="hidden" name="fileToComp" value=', @output, '>'; 
    print '</form>';
 }

else {
##########################################################
# Run java on the output of the Grail/CamelotJVML compiler

print "<em>NB: This form will call call " . $path_module::runjava . "<br>\n"  if $debug_it;    
print '</i>';
print '<tt>';
   print '<form action=', $path_module::runjava,' target="_blank" method="post" enctype="multipart/form-data">';
   print '<hr>';
   print "Input Data to run: <br>";
   print '<textarea name="idata" cols=50 rows=1>';
   print "</textarea>";
   print "<br>";
   print "<br>";
   print  "Run ";
   print '<input type=submit name=class value=', @output[0], '>';
   print "<br>";
   print "<br>";
   print '<table border="2" cellpadding="5" cellspacing="0" width=580>';
   print '<tr>';
   print '<td>';
   print "<small>";
   chomp(@output[0]);
   print '<strong style="color:red">If you are working with the example not from us, </strong>';
   print " you may need a testing java code. ";
   print  "Input it in the text area below or upload a file from your machine.";
   print "<br>";
print  '<strong style="color:red">Convention:</strong> your testing java code consists of a java class <b>', @output[0], 'Test</b>';
   print  " and is written in a file <b>", @output[0], "Test.java</b>";
   print "</small>";
   print '</td>';
   print '</tr>';
   print '</table>';
   print '<textarea name="javacode" cols=50 rows=20>';
   print "</textarea>";
   print "<br>";
   print "<br>";
   print '<input type="file" name="upfilejava" accept="text/*" maxlength="2097152">';
   print "</pre>";
   print "</form>";
   };
 };

};

print '</body>';
print '</html>';
