#!/usr/bin/env perl
# Time-stamp: <Fri Jan 31 2003 15:57:08 hwloidl>
###########################################################################
#
# Wrapper script for MRG Demo.
#
###########################################################################

# add this dir to the load path
push(@INC, ".");

#require "/usr/lib/perl5/5.6.0/CGI.pm";
require "CGI.pm";
# require "./upload.lib";

require "getopts.pl";

# body of required .pl files is automatically execed; no need to call init fcts
# setup information for the demo (pathes etc);
require "demo-setup.pl";
# data information for the demo (where to find programs etc);
require "demo-data.pl";
# aux functions used by the main script for the demo
require "demo-aux.pl";
# functions for uploading files etc (Olha's stuff)
require "demo-iface.pl";

# defaults; these are or-combined with corresponding cgi->param's
$debug_it = 0;    # debug execution?
$thyify_it = 0;  # compile a Grail program, producing .class and .thy files?
$log_it = 1;      # log execution in main log file?
$prove_it = 0;    # prove .thy file?
$upload_it = 0;
$preloaded_it = 0;
$compile_it = 0; 
$bytecompile_it = 0;
$dry_run = 0;     # avoid exec'ing stuff? (standard -n option)
$trace_level=1;   # choose how much output we want

&Getopts('hvdip');

print "Content-type:text/html\n\n"; #only needed at very beginning (I think)

&print_header("Proving Theorem", # title
	      "$url/mrg.css",    # stylesheet to use
              "I am now proving the resource property. <a href=\"$url/../cgi-dat/isabelle/tmp\">Please be patient</a> ..."); # unless ($req->param("action") eq "8"); #text

print "<p><hr><em>Tracing messages from here on</em><p>\n" if $debug_it;

$req = new CGI; 

&process_params($req);
&pick_file($req); 

# has to come after process_params
($thy_file = $dat_file) =~ s/\.gr$/.thy/;
($thy_name = $thy_file) =~ s/\.thy//;

&print_env_generic($req) if $debug_it;
&print_env($req) if $debug_it;

open(OUTF,">$log_dir/$out_file") or &dienice("Couldn't open $log_dir/$out_file for writing: $!") if $log_it;
open(OUTL,">>$log_dir/$log_file") or &dienice("Couldn't open $log_dir/$log_file for writing: $!") if $log_it;

# This locks the file so no other CGI can write to it at the 
# same time...
flock(OUTF,2) if $log_it;
flock(OUTL,2) if $log_it;
# Reset the file pointer to the end of the file, in case 
# someone wrote to it while we waited for the lock...
seek(OUTF,0,2) if $log_it;
seek(OUTL,0,2) if $log_it;

&write_log($req);

#&read_env();

#&thank_you();

#$userdir = $wrkdir;
#NB: if it is preloaded, don't load it again; still $req->param('upfile') is the right name
&iface($req) if $upload_it && !$preloaded_it;

&pick_file($req);

if ($req->param("action") eq "8") {
    #print "Spitting out Isabelle code from file |$upload_dir/$upload_file|<br>\n";
    print "Content-type:text/html\n\n";
    #print "Content-type: application/isabelle\n\n";
    &show_file("$upload_dir/$upload_thy");
}

if ($thyify_it) {
  &dienice("<b>Please select a Grail program to compile!</b><br>\n") unless $program || $upload_it || $preloaded_it;
}

if ($prove_it && !thyify_it) {
  &dienice("<b>Please select a Grail program and a time bound!</b><br><em>|$proof_id| |$ex| |$name|</em>\n") unless ($program && $time) || ($proof_id && $ex && $name);

}
&dienice("You selected a non-action. Good-bye<br>\n") if $req->param("action") eq "0"; 

&compile_camelot("$upload_dir/$upload_file") if $compile_it;

&compile_gr("$upload_dir/$upload_file") if $bytecompile_it;

&run_java("$upload_dir/$upload_file") if $req->param("action") eq "4";

&wipe_dir("$thy_dir") if $thyify_it;
&wipe_dir("$wrk_dir") if $prove_it;

&gr2thy($req) if $thyify_it;

# make a proof-script for proving an upper bound on computation time
# should apply if: extracting theory && proving it (might be uploaded or not)
&mk_proofScript("$thy_file") if $prove_it; # && ($thyify_it && !$upload_it);

# copy proof scripts into the right dir
# should apply if: uploaded files && proving it
#&copy_uploadedFiles()  if $prove_it && !$thyify_it && $upload_it;

## this is now part of mk_proofScript
## should copy files from the data base on the consumer
# &copy_proofScript() if $prove_it && !$thyify_it;

&launch_isa($req) if $prove_it ;

&print_footer();

close(OUTF) if $log_it;
close(OUTL) if $log_it;

exit;

# ---------------------------------------------------------------------------
# Extract theory out of Grail file
# Input: Grail file "$dat_dir/$dat_file"

sub gr2thy {
 local ($p) = @_;

 print "<h2>gr2thy (extracting theory file from Grail)</h2>\n" if $debug_it;
 
 $t = localtime();
 #open (LOG,">>$log_dir/mrg0.log") or dienice("Cannot open log file $log_dir/mrg0.log: $!");

 #$exec_str = "$isa_dir/$isa_prg -d $thy_dir $dat_dir/$dat_file";
 $exec_str = "$gdf_dir/$gdf_prg -d $thy_dir $dat_dir/$dat_file 1>/dev/null";
 
 print OUTL "[$t] Working dir is now |$thy_dir|...\n" if $debug_it && $log_it;
 print OUTL "[$t] Processing |$exec_str|...\n" if $debug_it && $log_it;
 
#  #chdir "/home/h/hwloidl/mrg/progs/Grail/gdf/src/Bonzo";
 print "cwd: <b>$thy_dir</b><br>\n" if $debug_it;
 chdir "$thy_dir";
#  print ">> linking in $dat_file<br>\n";
#  link "$dat_dir/$dat_file", ".";
 print "copying  $dat_dir/$dat_file to $dat_file<br>\n" if $debug_it;
 &copy_file("$dat_dir/$dat_file","$thy_dir/$dat_file");
 print "Executing: <em>$exec_str</em><br>\n" if $debug_it;
 system ("$exec_str") unless $dry_run;
 #print "rename $thy_dir/$thy_file $thy_dir/$out_file";

 print "<em>Tracing messages end here</em><hr><p>\n" if $debug_it;

 # post process file
 &fix_file("$thy_dir/$thy_file");

 print "Here is the theory file generated by gdf2thy<br>\n " if $debug_it || $trace_level==1;
 print "File: <a href=\"$url_thy/$thy_file\">$thy_dir/$thy_file</a><br>\n" if $debug_it;
 # show the file
 &show_file("$thy_dir/$thy_file")  if $debug_it || $trace_level==1;;
 print "<hr><br><p>\n"  if $debug_it || $trace_level==1;
}

# ---------------------------------------------------------------------------

sub mk_rootML {
 local ($f) = @_;

 print "<hr>\n"  if $debug_it;
 print "Generating ROOT.ML ...<br>\n" if $debug_it;
 open(O,">$wrk_dir/$root_file") or &dienice("mk_rootML: Cannot open $wrk_dir/$root_file:$!\n");
 print O "use_thy \"$thy_name\";\n"; 
 close O;

 print "Copying |$f| to |$wrk_dir/$thy_file| ...<br>\n" if $debug_it;
 &copy_file("$f","$wrk_dir/$thy_file");
 print "Copying Grail Dyn Sem etc ...<br>\n" if $debug_it;
 foreach $x (@skel_files) {
     &copy_file("$skel_dir/$x","$wrk_dir/$x") unless $dry_run;
     print "mk_rootML: copying |$skel_dir/$x| --> |$wrk_dir/$x|<br>\n" if $debug_it;
 }

# ($url_tmp = $wrk_dir) =~ s,$home/public_html,http://www.tcs.informatik.uni-muenchen.de/~$user,;
 ($url_tmp = $wrk_dir) =~ s,$home/public_html,http://localhost/~$user,;
 print "Top level file: <a href=\"$url_tmp/$dat_file\">$wrk_dir/$dat_file</a><br>\n"  if $debug_it;
 print "Theory: <a href=\"$url_tmp/$thy_file\">$wrk_dir/$thy_file</a><br>\n"  if $debug_it;

 &show_dir("$wrk_dir")  if $debug_it;
}

# ---------------------------------------------------------------------------
# Called if $prove_it is true
# 2 cases: if theory has been extracted ($thyify_it), build a proof script out
#          of it
#          otherwise, copy the proofs from the $dat_dir into the working dir
          
sub mk_proofScript {
 local ($f) = @_;

 ($proof_file = $f) =~ s/\.thy/-p1.thy/;
 print "<br>\n<h2>Generating proof-script</h2>\n" if $debug_it;
 #  $proof_file

 # uploaded file together with theory:
 #  just copy the files to the right place; no need to make new proof scripts
 if ($upload_it && !$thyify_it) {
   &copy_uploadedFiles();
   return;
 }

 # selected file and theory from the list of available files on the server
 #  just copy the files to the right place; no need to make new proof scripts
 if (!$thyify_it) {
   &copy_proofScript();
   return;
 } 

 # make top-level file for Isabelle
 &mk_rootML($f);

 open (O,">>$wrk_dir/$f") or &dienice ("mk_proofScript: Cannot open  $wrk_dir/$f: $!\n");
 print O <<EOF;
constdefs 
  ti :: "Time"
 "ti == $time"

constdefs
  myState2 :: "State"
 "myState2 == emptyState"
EOF

 open (I,"<$dat_dir/$proof_file") or &dienice ("mk_proofScript: Cannot open proof script $dat_dir/$proof_file: $!\n");
 while (<I>) {
     print O;
 }

 # append a final hurrayy message
 print O "ML_command {* writeln \"Resource property has been proven!!\"; *}\n";
 print O "ML_command {* OS.Process.exit(OS.Process.success):unit; *}";
 print O "end\n";

 close (O);

 print "<hr>\n"  if $debug_it;
 print "Now the file $wrk_dir/$f looks like this<br>\n"  if $debug_it;
 &show_file("$wrk_dir/$f") if $debug_it;
}

# ---------------------------------------------------------------------------
# copy *existing* theory files into the main working dir

sub copy_proofScript {
 local (@files);

 print "<br>\nCopying an existing proof script\n" if $debug_it;
 opendir(DIR,"$proof_dir/$ex") or &dienice("copy_proofScript: Cannot open dir $proof_dir/$ex: $!");
 @files = readdir(DIR);
 foreach $x (@files) {
     next if $x eq "." || $x eq "..";
     &copy_file("$proof_dir/$ex/$x","$wrk_dir/$x") unless $dry_run;
     print "Copying: |$proof_dir/$ex/$x| --> |$wrk_dir/$x|<br>\n" if $debug_it;
 }
 closedir(DIR);

 print "<hr>\n"  if $debug_it;
 print "Now the top-level file $wrk_dir/$root_file looks like this<br>\n"  if $debug_it;
 &show_file("$wrk_dir/$root_file") if $debug_it;
}

# ---------------------------------------------------------------------------
# copy uploaded Grail and theory files, together with GrailAbsyn etc files into 
# the main working dir

sub copy_uploadedFiles {
 local (@files);

 print "Copying uploaded files into working dir<br>\n" if $debug_it;

 &copy_file("$upload_dir/$upload_file","$wrk_dir/$upload_file");
 &copy_file("$upload_dir/$upload_thy","$wrk_dir/$upload_thy");

#  opendir(DIR,"$skel_dir") or &dienice("copy_uploadedFiles: Cannot open dir $skel_dir: $!");
#  @files = readdir(DIR);
#  foreach $x (@files) {
#      next if $x eq "." || $x eq "..";
#      &copy_file("$skel_dir/$x","$wrk_dir/$x") unless $dry_run;
#      print "Copying: |$skel_dir/$x| --> |$wrk_dir/$x|<br>\n" if $debug_it;
#  }
#  closedir(DIR);

 ($thy_name = $upload_thy) =~ s/\.thy$//;
 &mk_rootML("$upload_dir/$upload_thy");

 if ($debug_it) { 
     print "The contents of the working dir $wrk_dir is now<br>\n";
     &show_dir("$wrk_dir");
 
     print "The ROOT.ML for this set is<br>\n";
     &show_file("$wrk_dir/$root_file");
     print "which should just use the following uploaded theory file<br>\n";
     &show_file("$wrk_dir/$upload_thy");
 }
}

# ---------------------------------------------------------------------------

sub launch_isa {
 local ($p) = @_;

 # print "Content-type:text/html\n\n";
 
 $t = localtime();
 #open (LOG,">>$log_dir/mrg0.log") or dienice("Cannot open log file $log_dir/mrg0.log: $!");
 
 $isa_heap =~ s/Grail.img/GrailSL.img/ if $ex =~ /^SL_Ex/;
 $exec_str = "$isa_dir/$isa_prg $isa_heap < $wrk_dir/$root_file 1>$log_dir/$out_file";
 
 print OUTL "[$t] Processing |$exec_str|...\n" if $debug_it &&  $log_it;
 
 #chdir "/home/h/hwloidl/mrg/progs/Grail/gdf/src/Bonzo";
 chdir "$wrk_dir";
 print "Executing: |<em>$exec_str</em><br>\n|" if $debug_it;
 system("$exec_str") unless $dry_run;
 
 print "Here is what Isabelle has to say about this proof<br>\n ";
 print "File: <a href=\"$url_log/$out_file\">$log_dir/$out_file</a><br>\n" if $debug_it;

 print "<em>Tracing messages end here</em><hr><p>\n" if $debug_it;

 &show_file("$log_dir/$out_file");

}

# ---------------------------------------------------------------------------
