#!/usr/bin/env perl
# ---------------------------------------------------------------------------
# Olha's code for uploading a file and forwarding it to the compiler
# changes for global setup
# renames $userdir to $upload_dir

#HWL: set to 0 to get rid of debugging and tracing messages
#my $debug_it=0;

sub iface {
    local ($cgi) = @_;

    print "<h2>Uploading file</h2>\n" if $debug_it;
    print '<br>';
    # upload file; die datei-daten holen (AUS)
    my $file = $cgi->param("upfile");
    my $thy_file = $cgi->param("upthy");
    my $data=$cgi->param("code");
    my $action = $cgi->param("action");
    my $ftype = $cgi->param("ftype");

    # $flag is 0 if no code was sent
    # $flag is 1 if a Grail code was sent
    # $flag is 2 if a Camelot code was sent to be compiled to JVML
    # $flag is 3 if a Camelot code was sent to be compiled to Grail

#     # NB: setting of upload_file should be done in the calling routine!
#     if ($p->param("upfile")) {
# 	($upload_file = $p->param("upfile")) =~ s,.*/,,;
#     } else {
# 	$upload_file = $path_module::filecomp;
#     }
    ($upload_thy = $thy_file) =~ s,.*/,, unless ($thy_file eq "");

    my $flag;
    my $fname="$upload_dir/$upload_file"; # full filename on the local machine
    my $tname="$upload_dir/$upload_thy";  # full filename on the local machine

    print "Target file for uploading code: $fname<br>\n"  if $debug_it;
    print "Target file for uploading theory: $tname<br>\n"  if $debug_it && !($thy_file eq "");

#     if ($ftype eq "cmlt" || $language eq 'Compile/CamelotToGrail'){
# 	# print '<html><body bgcolor="#C0EEEE">', "\n\n";
# 	$upload_file = "do1.cmlt";
# 	$fname = "$upload_dir/$upload_file";
# 	$flag=3;
#     } elsif ($ftype eq "cmlt" || $language eq 'Compile/CamelotToJVML'){
# 	# print '<html><body bgcolor="#E0EEE0">', "\n\n";
# 	# dateinamen erstellen und die datei auf dem server speichern (WOHIN)
# 	$upload_file = "do1.cmlt";
# 	$fname = "$upload_dir/$upload_file";
# 	$flag=2;
#     } else {
# 	print '<html><body bgcolor="#E0EEE0">', "\n\n";
# 	# dateinamen erstellen und die datei auf dem server speichern (WOHIN)
# 	$upload_file = "buffer1.gr";
# 	$fname = "$upload_dir/$upload_file";
# 	$flag=1;
#     }

    print "Upload file is |$fname|<br>\n" if $debug_it;

    open (UPLOAD,">$fname") or &dienice("iface: Cannot open $fname: $!");;
    flock(UPLOAD, 2);

    # $data is contents from textarea, if any
    if (length($data)>0){
	print UPLOAD $data;
	print "The code in the textarea has been successfully uploaded. Thank you!<br>\n";
# 	print "<i>";
# 	print "The form is submitted.", "<br>";
# 	print "We are to work with the text area.", "<br><br>";
# 	print "</i>";
    } else {
	# die datei-daten holen (AUS)
	if (length($file)>0) {
	    
	    # Dateien in den Binaer-Modus schalten
	    binmode $file;
	    binmode UPLOAD;
	    
	    my $filedata;
	    while(read $file,$filedata,1024) {
		print UPLOAD $filedata;
	    }
	    
	    print "The file has been successfully uploaded. Thank you!<br>\n";
# 	    print "<i>";
# 	    print "The form is submitted.", "<br>";
# 	    print "We are to work with the file ", $file, ".", "<br><br>";
# 	    print "</i>";
	}
	else {
	    print "You have sent no code. Please use the back button to return to the provious page and select code to submit.<br>";
# 	    print "<i>";
# 	    print "You have sent no code.", "<br><br>";
# 	    print "</i>";
	    $flag = 0;
	};
    };
    
    close UPLOAD;
    if ($debug_it) { 
	print '<br>';
	print "You have uploaded this code into file |$upload_dir/$upload_file|<br>\n";
	&show_file("$upload_dir/$upload_file");
	print '<br>';
    }
    &show_file("$upload_dir/$upload_file") if !$debug_it && $trace_level==1;
    print "<hr><br><p>" if !$debug_it && $trace_level==1;
    if ($thy_file ne "") {
	# Same for attached theory file, but without possibility to edit
	print "Upload theory is |$tname|<br>\n" if $debug_it;

	open (UPLOAD,">$tname") or &dienice("iface: Cannot open theory file $tname: $!");
	flock(UPLOAD, 2);

	my $file = $cgi->param("upthy");
	
	# Dateien in den Binaer-Modus schalten
	binmode $file;
	binmode UPLOAD;
    
	my $filedata;
	while(read $file,$filedata,1024) {
	    print UPLOAD $filedata;
	}
	close UPLOAD;

	print "The theory file has been successfully uploaded. Thank you!<br>\n";
	if ($debug_it) {
	    print "You have uploaded this theory into file |$upload_dir/$upload_thy|<br>\n";
	    &show_file("$upload_dir/$upload_thy");
	}
	&show_file("$upload_dir/$upload_thy") if !$debug_it && $trace_level==1;
	print "<hr><br><p>" if !$debug_it && $trace_level==1;
    }
}

# ---------------------------------------------------------------------------
# Compile a given Camelot file 

sub compile_camelot {
 local ($fname) = @_;

 print "<h2>Compiling Camelot program in $f</h2>" if $debug_it;

 # Camelot -> Grail
 $output=qx($camelot_dir/$camelot_prg -g -d $upload_dir $fname);

 # Camelot -> Java
 $output=qx($camelot_dir/$camelot_prg -d $java_dir $fname);

 #$output=qx($gdf -c -d $java_dir $fname);

 print "<small>";
 print "Compilation result: ";
 print "</small>";
 print "<pre>";
 chomp($output);
 print "$output";
 print "</pre>";
 print "<br>";
}

# ---------------------------------------------------------------------------

sub compile_gr {
    local ($f) = @_;
    local ($exec_str);

    print "<h2>Compiling Grail code</h2>" if $debug_it;
    print "Input file: |$f|<br>" if $debug_it;
    $exec_str="$gdf_dir/$gdf_prg -c -d $java_dir $f";
    print "Executing: <em>$exec_str</em><br>\n" if $debug_it;
    $output=qx($exec_str);

    print "Output from compilation:<br>" if $debug_it;
    print "<pre>\n" if $debug_it;
    print $output if $debug_it;
    print "</pre>\n" if $debug_it;
}

# ---------------------------------------------------------------------------

sub edit_gr {
    local ($f) = @_; 

    open(IN, "<$f") or &dienice("compile_gr: Cannot open file $f : $!\n");
    flock(IN, 2);
    my @Zeilen = <IN>;
    close(IN);

    print '<hr>';
    print '<form action=', $iface, ' method="post" enctype="multipart/form-data">';
    print "This is the grail-output: <br>";
    print '<textarea name="code" cols=80 rows=50>';
    print @Zeilen;
    print "</textarea>";
    print "<br>";
    print '<input type="submit" name="action" value="Compile/Grail">'; 
    print '<input type="hidden" name="upfile" value="">';
    print '</form>';
   
}

# ---------------------------------------------------------------------------
# call another script to actually run the java code

sub run_java {
   local ($f) = @_;

   # Run java class of the output of the Grail/Camelot compiler
    
   print '<form action=', $runjava_script,' method="post" enctype="multipart/form-data">';
   print '<hr>';
   print "Input Data to run: <br>";
   print '<textarea name="idata" cols=50 rows=1>';
   print "</textarea>";
   print "<br>";
   print "<br>";
   print  "Run ";
   print '<input type=submit name=class value=', $output, '>';
   print "<br>";
   print "<br>";
   print '<table border="2" cellpadding="5" cellspacing="0" width=580>';
   print '<tr>';
   print '<td>';
   print "<small>";
   print '<strong style="color:red">If you are working with the example not from us, </strong>';
   print " you may need a testing java code. ";
   print  "Input it in the text area below or upload a file from your machine.";
   print "<br>";
print  '<strong style="color:red">Convention:</strong> your testing java code consists of a java class <b>', $output, 'Test</b>';
   print  " and is written in a file <b>", $output, "Test.java</b>";
   print "</small>";
   print '</td>';
   print '</tr>';
   print '</table>';
   print '<textarea name="javacode" cols=50 rows=20>';
   print "</textarea>";
   print "<br>";
   print "<br>";
   print '<input type="file" name="upfilejava" accept="text/*" maxlength="2097152">';
   print "</pre>";
   print "</form>";

}

# ---------------------------------------------------------------------------
# Takes filenames of code and theory files (full paths!) and produces
# HTML code allowing the user to proceed with extracting or proving

sub pass_to_verifier {
    local ($f,$t) = @_;

    print "Entering pass_to_verifier with files $f and $t<br>\n" if $debug_it;

#     $text = <<EOTEXT;
# <table>
# <tr>
#         <TH align=left ></TH>
# 	<TH align=right></TH>
# <tr>
# <td>
# Launch Proof Checker
# </td>
# <td> 
#   <img src="http://www.lfcs.ed.ac.uk/mrg/images/logo/mrg-parcel-transp-64pix.png" 
#        alt="MRG Logo"></a>
# </td><tr>
# </table>
# EOTEXT

## header must be printed in calling function
#     &print_header("Launch Proof Checker",
#                   "$url/demo.css",
# 		  $text);

    print <<EOF;
<p>
From here you can process the uploaded Grail and Isabelle theory files.
Currently there are three options. You can
<ul>
<li> extract and view an Isabelle theory file corresponding to the Grail program;
<li> prove the theorems contained in the uploaded Isabelle theory file;
<li> prove an upper bound on the execution time of the Grail program, using the
     uploaded Isabelle theory file
</ul>

<p> <em>Note:</em> No check is performed that the Isabelle encoding of
the program code corresponds to the program supplied as Grail
file. The third option currently only works on small programs (only
one top level function) such as the <file>Inc.gr</file>.

<!-- NB: local path!!! -->
<form action="/cgi-bin/mrg/do_compile.pl"
      target="_blank"
      method="POST" 
      enctype="multipart/form-data">

<p>
<!-- Upload and theory file are hidden fields, passed to next script
     after a successful upload of the script printing this text -->
<input type="hidden" name="upfile" value="$f">
<input type="hidden" name="upthy"  value="$t">
<!-- necessary to let the script know the files have been uploaded already -->
<input type="hidden" name="ftype" value="preloaded">

<p>
<em>What do you want to do with this file?</em><br>
<!--
 <input type="radio" name="action" value="2">Compile Camelot to Grail <br>
 <input type="radio" name="action" value="3">Compile Grail to Class file<br>
 <input type="radio" name="action" value="4">Run Java<br>
-->
 <input type="radio" name="action" value="5">Extract Theory from Grail code<br>
 <input type="radio" name="action" value="6" checked>Proof Theorem<br>
 <input type="radio" name="action" value="7">Prove time bound
 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 Specify time bound: <input type="text"  name="time"> <br>

<p>
<input type="submit" value="prove">
</form>
EOF

}

1;
