#!/usr/bin/env perl
# Time-stamp: <Fri Jan 31 2003 15:53:16 hwloidl>
###########################################################################

# ---------------------------------------------------------------------------
# Aux functions:
# ---------------------------------------------------------------------------

sub print_blurb {
# print "Content-type:text/html\n\n";
print <<EndHTML;
<html><head><title>Hi there!</title></head>
<body>
<h1>Hi there!</h1>
It shall be known that I hereby invoke Isabelle as 
"$isa_dir/isabelle  < ROOT.ML"
</body></html>
EndHTML
}

# ---------------------------------------------------------------------------

sub copy_file {
    local ($from,$to) = @_;

    open (FROM,"<$from") or &dienice("copy_file: cannot open from file $from: $!");
    open (TO,">$to") or &dienice("copy_file: cannot open to file $to: $!");
    while (<FROM>) {
	print TO;
    }
    close (FROM);
    close (TO);
}

# ---------------------------------------------------------------------------

sub fix_file {
    local ($f) = @_;
    local ($all,$t,$s);

    $t="bonzo_" . $$;

    $all = "";
    $decs = 0;
    open (F,"<$f") or &dienice("fix_file: Cannot open in file $f: $!");
    open (G,">$log_dir/$t") or &dienice("fix_file: Cannot open out file $t: $!");
    while (<F>) {
	if (/^theory/) {
	    (($s = $_) =~ s/HWsWeeGrailProgram/$thy_name/);
	    $s =~ s/GrailAbsyn:/GrailMisc:/;
	    print G $s."\n";
	    next;
        }
	(($s = $_) =~ s/PROG \[\]/PROGz /), $all .= $s, next  if /PROG \[\]/;
	(($s = $_) =~ s/\"Prog\"/"GrailAbsyn.Progz"/), $all .= $s, next  if /Prog/;
	$decs = 1 if /\(\* ---BEGIN declarations \*\)/;
	if (!$decs) {
	    $all .= $_;
	} else {
	    if (/\(\* ---END declarations \*\)/) {
		$decs = 0; 
		print G;
		print G $all;
	    } else {
		print G;
	    }
	}
		
    }
    close (F);
    close (G);

    &copy_file("$log_dir/$t",$f);
}

# ---------------------------------------------------------------------------

sub show_file {
 local ($f) = @_;

 open(O,"<$f") or &dienice("show_file: Cannot open file $f: $!");
 print "<pre>\n";
 while (<O>) {
     $l = $_;
     $l =~ s/&/&amp;/g;
     $l =~ s/</&lt;/g;
     $l =~ s/>/&gt;/g;
   print $l;
 }
 close(O);
 print "</pre>\n";
 
 #close (LOG);
}

# ---------------------------------------------------------------------------

sub urlify {
 local ($f) = @_;
 local ($url);

 ($url = $f) =~ s,$home/public_html,http://localhost/~$user,;
 return $url;
}

# ---------------------------------------------------------------------------

sub show_dir {
 local ($dir) = @_;

 print "Contents of $dir:<br>\n";
 print "<ul>\n";
 opendir(DIR,"$dir") or &dienice("show_dir: Cannot open dir $dir: $!");
 @files = readdir(DIR);
 foreach $x (@files) {
     next if $x eq "." || $x eq "..";
     $u = &urlify("$dir/$x");
     print "<li> <a href=\"$u\">$x</a><br>\n";
 }
 print "</ul>\n";
 closedir(DIR);
}

# ---------------------------------------------------------------------------

sub wipe_dir {
 local ($dir)  = @_;

 opendir(DIR,"$dir") or &dienice("wipe_dir: Cannot open dir $dir: $!");
 print "<p>Deleting all files in dir $dir:<br>\n" if $debug_it;
 @files = readdir(DIR);
 foreach $x (@files) {
     next if $x eq "." || $x eq "..";
     unlink "$dir/$x" unless $dry_run;
     print "<li> $x<br>\n"  if $debug_it;
 }
 print "</ul>\n";
 closedir(DIR);
}

# -------------------------------------------------------

sub print_header {
    local ($name,$css,$text) = @_; 

#Content-type:text/html


  print <<EndHTML;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"
  "http://www.w3.org/TR/REC-html40/loose.dtd">

<html> 
<head>
  <title>$name</title>
  <link rel="stylesheet" type="text/css" href="$css">
  <meta name="author" lang="en" content="Hans-Wolfgang Loidl">
</head>
<h1>$text</h1>
</h1>
<p>

<body>
<!-- use the code below to include logo
<h1>
<table>
<tr>
        <TH align=left ></TH>
	<TH align=right></TH>
<tr>
<td>
$text
</td>
<td> 
  <img src="http://www.lfcs.ed.ac.uk/mrg/images/logo/mrg-parcel-transp-64pix.png" 
       alt="MRG Logo"></a>
</td><tr>
</table>
</h1>
<p>
-->
EndHTML
}

# ---------------------------------------------------------------------------

sub print_footer {

    print "</body></html>";
}

# ---------------------------------------------------------------------------

sub read_env {
  local ($buffer) = @_;
  local ($pair,$name,$value);

  read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
  @pairs = split(/&/, $buffer);
  foreach $pair (@pairs) {
    print "<b>$name</b> = <em>$value</em><br>\n";
    ($name, $value) = split(/=/, $pair);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $value =~ s/\n/ /g;	# replace newlines with spaces
    $value =~ s/\r//g;	# remove hard returns
    $value =~ s/\cM//g;	# delete ^M's
    $FORM{$name} = $value;
  }
  return %FORM;
}

# ---------------------------------------------------------------------------

sub print_env {
  local ($p) = @_;
  local ($piar,$name,$value);

  print "<h2>Environment</h2>\n";
  print "<b>Id</b> = <em>" . $p->param('program') . ", i.e. name: ". $program_names{$p->param('program')} . "</em><br>\n";
  print "<b>Proof Id</b> = <em>" . $p->param('proof') . ", i.e. name: ". $proof_names{$p->param('proof')} . "</em><br>\n";
  print "<b>dat_file</b> = <em>" . $dat_file ." </em> <br>\n";
  print "<b>Time</b> = <em>" . $p->param('time') . "</em><br>\n";
  print "<b>Upload file</b> = <em>" . $p->param('upfile') . "</em><br>\n";
  print "<b>Upload theory</b> = <em>" . $p->param('upthy') . "</em><br>\n";
  print "<b>File type</b> = <em>" . $p->param('ftype') . "</em><br>\n";
  print "Selected action = <em>" . $p->param('action') ."</em> which translates to<br>\n";
  print "<b>prove_it</b> = <em>" . $prove_it ."</em> <br>\n";
  print "<b>thyify_it</b> = <em>" . $thyify_it ."</em> <br>\n";
  print "<b>upload_it</b> = <em>" . $upload_it ."</em> <br>\n";
  print "<b>compile_it</b> = <em>" . $compile_it ."</em> <br>\n";
  print "<b>bytecompile_it</b> = <em>" . $bytecompile_it ."</em> <br>\n";

#    @params = $p->param();
#    foreach $pair (@params) {
#      ($k, $v) = $pair;
#      print "<b>$k</b> = <em>$v</em><br>\n";
#    }
#    print "<b>Input file</b> = <em> " . $p->param('upfile') . "</em><br>\n";
#    print "<b>Dbfile</b> = <em> " . $p->param('dbfile') . "</em><br>\n";
#    print "<b>Colour</b> = <em> " . ($p->param('colour') eq "yes") ? "ON" : "OFF" . "</em><br>\n";
#    print "<b>Info</b> = <em> " . $p->param('info') . "</em><br>\n";
#    print "<b>View</b> = <em> " . $p->param('view') . "</em><br>\n";
#    print "<b>Map</b> = <em> " . $p->param('map') . "</em><br>\n";
#  # " (" . $maps{$p->param('map')} . ") </em><br>\n";
}

# ---------------------------------------------------------------------------

sub print_env_generic {
  local ($p) = @_;
  local (@params);

  print "<h2>Generic Environment</h2>\n";
  @params = $p->param();
  foreach $pair (@params) {
    ($k, $v) = $pair;
    print "<b>$k</b> = <em>$v</em><br>\n";
  }
}

# ---------------------------------------------------------------------------

sub dienice {
	my($msg) = @_;
	print "<h2>Error</h2>\n";
	print $msg;
	exit;
}

# ---------------------------------------------------------------------------

sub thank_you {

  print <<EndHTML;
<html><head><title>Thanks</title></head>
<body>
<h1>Thank you for visiting the MRG Demo page,</h1>
<p>
For more information about the MRG project visit the <a href="http://www.dcs.ed.ac.uk/home/mrg/">MRG web page</a>.
EndHTML
}

# ---------------------------------------------------------------------------

sub write_log {
  local ($p) = @_;
  local ($now);

  $now = localtime();

  print OUTL "[$now]" if $log_it;
  print OUTL "|Id:" . $p->param('proof') . ", i.e. name: ". $proof_names{$p->param('proof')} . " dir: " . $proof_names{$p->param('proof')} if $log_it;
}

# ---------------------------------------------------------------------------

sub process_params {
 local ($p) = @_;

 $thyify_it = $thyify_it || ($p->param('action')) eq "5" || ($p->param('action')) eq "7";
 $prove_it  = $prove_it  || ($p->param('action')) eq "6" || ($p->param('action')) eq "7";
 $upload_it = $upload_it || ! $p->param("upfile") eq "";
 $preloaded_it = $preloaded_it || $p->param('ftype') eq "preloaded";
 $compile_it = $compile_it || $p->param("action") eq "2";
 $bytecompile_it = $bytecompile_it || $p->param("action") eq "3";
 $time = $time || $p->param('time');
 #$ex = $proof_dirs{$id};
 #$program =  $program_names{$id};
 #$dat_file = $program;
 $program_id = $p->param('program');
 $proof_id = $p->param('proof');
 #$ex = $proof_dirs{$proof_id};
 #$name =  $proof_names{$proof_id};
}

# ---------------------------------------------------------------------------
# One in a list of existing files has been picked; set $dat_file

sub pick_file {
 local ($p) = @_;

 if ($p->param('program')) {
     $program =  $program_names{$program_id};
     $dat_file = $program;
 } elsif ($p->param('proof')) {
     $ex = $proof_dirs{$proof_id};
     $name =  $proof_names{$proof_id};
     $dat_dir = "$proof_dir/$ex";
     $dat_file = "$name";
 } elsif ($p->param('upfile')) {
     ($upload_file = $p->param("upfile")) =~ s,.*/,,;
     ($upload_thy = $p->param("upthy")) =~ s,.*/,,;
     $dat_dir = $upload_dir;
     $dat_file = $upload_file;
 } elsif ($p->param('ftype') eq "preloaded") {
     ($upload_file = $p->param("upfile")) =~ s,.*/,,;
     ($upload_thy = $p->param("upthy")) =~ s,.*/,,;
     $dat_dir = $upload_dir;
     $dat_file = $upload_file;
 } else   {
     print "pick_file: Unknown type of file (neither program nor proof)" if $debug_it;
     &dienice("You probably forgot to upload or select a file. Please go back and do so.");
 }
}

# ---------------------------------------------------------------------------

1;
