<?php
$inferT = 1;
$grailT = 2;
$compileT = 3;
$runT = 4;
$generateJART = 5;
$transmitJART = 6;
$gdfT = 7;
$abortT = 8;
$allT = 9;

//$lib_dir = dirname($_SERVER["SCRIPT_FILENAME"]); // ToDo: global place, not local!
//$lib_file = "Camelotlib.class";

/*
function mktmpdir ($mydir) {
  $tmpdir = "PCCtmp/tmp." . substr(uniqid(""),10) . "/";
  $tmp_full_dir = $mydir . "/" . $tmpdir;
  # print "mkdir $tmp_full_dir;<br>";
  system("mkdir $tmp_full_dir;");

  return $tmp_full_dir;
}

function path2url ($path,$host,$base) {
  $x = preg_match('/^.*\/producer\/(.*)$/',$path,$res);
  if ($debug) {
    if ($x) {
      print "<p>path2URL: match succeeded; matched |$res[1]|<br>\n";
    } else {
      print "<p>path2URL: ERROR match failed for |$path|<br>\n";
    }
  }
  if ($host === "") {
    return $res[1];
  } else {
    return "http://".$host."/".$base."/".$res[1];
  }
}
*/

# ---------------------------------------------------------------------------

function handle_file($file) {
    global $dir, $in_file, $mem_mgmt_file, $cert_file, $cert, $tmp_full_dir, $stream;
    global $generateJART;

    $ty = file_type($file);
    # now give choices what to do with the file:
    switch (file_type($file)) {
      case "cmlt":
      case "gr":
	edit_file($dir,$file,$ty,true);
	# print "<p><font color=\"grey\">copying file to $in_file</font>\n";
	break;

      case "class":
?>

<p>
<h2>What to do with this class file?</h2>

<p>
<form action="http://<?php print $_SERVER['SERVER_NAME'] . "/" . $_SERVER['PHP_SELF']; ?>"
      method="GET"
      enctype="multipart/form-data">
<input type="hidden" name="file" value="<?php echo basename($in_file) ; ?>">
<input type="hidden" name="mem_mgmt" value="<?php echo basename($mem_mgmt_file) ; ?>">
<input type="hidden" name="dir" value="<?php echo $tmp_full_dir ; ?>">
<input type="radio" name="what" value="<?php print $generateJART ?>">generate Jar File
<?php
if ($cert=="") {
?>
<input type="file" name="cert_upload"> Pick a certificate
<?php
} else {
?>
<input type="hidden" name="certificate" value="<?php echo basename($cert_file) ; ?>">
<?php
}
?>
<input type="submit"  value="Submit">
</form>

<?php
       break;
      case "jar":

  if ($debug) {
    print "<p><font size=-1 color=grey>Cached and derived constants:" .
          "<ul> <li> producerhost = |$producerhost| <li> consumerhost = |$consumerhost| <li> producerbase = |$producerbase| <li> consumerbase = |$consumerbase|<li> producerURL = |$producerURL| <li> consumerURL = |$consumerURL| </ul>\n</font></p>";
  }

?>

<p>
<h2>What to do with this jar file?</h2>

<p>
Either download <a href="<?php echo path2url($in_file,$producerhost,$producerbase) ;
?>">this .jar</a> file, and then submit it or

<p>
<blockquote>
<a href="<?php echo $consumerURL
. "?url=". path2url($in_file,$producerhost,$producerbase) ; ?>"
target="bonzo"><b>Submit this jar file directly</b></a>.
</blockquote>

<?php
       break;
    default:
       break;
  }
}

# ---------------------------------------------------------------------------

function infer_it ($in_file,$out_file,$err_file) {
  global $verbose, $debug;
  global $tmp_full_dir; 
  global $lib_dir, $lib_file;
  global $java_dir,  $java_prg, $java_cp  ;
  global $camelot_dir,  $camelot_prg;
  global $lfd_infer_dir,  $lfd_infer_prg ;
  global $lp_solve_dir, $lp_solve_prg ;

  $lfd_file = ereg_replace('.cmlt$','.lfd',$in_file);
  $constraints_file = ereg_replace('.cmlt$','.constraints',$in_file);

    // inference
    $exec_str = "$camelot_dir/$camelot_prg -n -d $tmp_full_dir -a2 $in_file > $lfd_file 2>$err_file";
    if ($debug) {
      print "<p><font size=\"-1\" color=\"grey\">";
      print "Exec: |$exec_str|<br>";
      print "</font></p>";
    }
    //  print "<h2>Generating .lfd file </h2>";
    system($exec_str);
    if ($debug) {
      print "<p><font size=\"-1\"><pre>";
      include($lfd_file);
      print "</pre></font></p>";
      print "<p>ERROR file:<br><font size=\"-1\"><pre>";
      include($err_file);
      print "</pre></font></p>";
    }
    $exec_str = "PATH=\$PATH:$lp_solve_dir; $lfd_infer_dir/$lfd_infer_prg $lfd_file -olhs 4 > $out_file 2>$err_file";
    if ($debug) {
      print "<p><font size=\"-1\" color=\"grey\">";
      print "Exec: |$exec_str|<br>";
      print "</font></p>";
    }
    print "<h2>Performing space inference</h2>";
    system($exec_str);
    print "<p>Result of the inference (constraints can be viewed <a href=\"" . 
              path2url($constraints_file,$producerhost,$producerbase) .
              "\">here</a>):\n";
    print "<p><font size=\"-1\"><pre>";
    include($out_file);
    print "</pre></font></p>";
    if ($debug) {
      print "<p>ERROR file:<br><font size=\"-1\"><pre>";
      include($err_file);
      print "</pre></font></p>";
    }

    // should parse lfd_file to decide about success and pick out results
    return $lfd_file;
}

// ---------------------------------------------------------------------------

function compile_it ($in_file,$out_file,$err_file) {
  global $verbose, $debug;
  global $tmp_full_dir; 
  global $lib_dir, $lib_file;
  global $java_dir,  $java_prg,  $java_cp  ;
  global $camelot_dir,  $camelot_prg, $camelot_flags ;
  global $lfd_infer_dir,  $lfd_infer_prg ;
  global $lp_solve_dir,  $lp_solve_prg ;
  global $jvm_file,  $jvm_class;

  $gr_file = ereg_replace('.cmlt$','.gr',$in_file);
  $jvm_file = ereg_replace('.cmlt$','.class',$in_file);
  $thy_file = ereg_replace('.cmlt$','Certificate.thy',$in_file);
  $jvm_class = ereg_replace('.class$','',basename($in_file));

  if (!file_exists("$camelot_dir/$camelot_prg")) {
    print "<p>Compiler $camelot_dir/$camelot_prg does not exist.\n";
    return "";
  }
  if (!file_exists("$in_file")) {
    print "<p>Input file $in_file does not exist.\n";
    return "";
  }
  if (!is_dir("$tmp_full_dir")) {
    print "<p>Working dir $tmp_full_dir does not exist.\n";
    return "";
  }
  chdir($tmp_full_dir);
  // compilation
  $exec_str = "$camelot_dir/$camelot_prg $camelot_flags -d $tmp_full_dir $in_file 1>/dev/null 2>/dev/null";
  // $exec_str = "$camelot_dir/$camelot_prg $camelot_flags -d $tmp_full_dir $in_file 1> $out_file 2>$err_file";
    print "<h2>Compiling Camelot to JVM</h2>";
    //print "<p>|$exec_str|<br>";
    if ($debug) {
      print "<p><font size=\"-1\" color=\"grey\">";
      print "Exec: |$exec_str|<br>";
      print "</font></p>";
    }
      print "<p><font size=\"-1\" color=\"grey\"><pre>";
    system($exec_str);
      print "</pre></font></p>";
//     if (filesize($out_file)>0) { // show stdout if successful
//       print "<p><font size=\"-1\"><pre>";
//       include($out_file);
//       print "</pre></font></p>";
//       $success = $jvm_file;
//     } else {
//       print "<p>An error has occured in compiling the code:<p><font size=\"-1\"><pre>";
//       include($err_file);
//       print "</pre></font></p>";
//       $success = "";
//     }
    if ($debug) {
      print "<p><font size=\"+1\" color=\"grey\"><pre>";
      $layout = get_pragma_string($thy_file,'DATA_LAYOUT');
      if ($debug && $layout!="") {
	print "Found DATA_LAYOUT pragma: |" . $layout . "|<br>\n";
      }
      $tag_offset = get_pragma_string($thy_file,'TAG_OFFSET');
      if ($debug && $layout!="") {
	print "Found TAG_OFFSET pragma: |" . $tag_offset . "|<br>\n";
      }
      print "</pre></font></p>";
    }
    if (!file_exists($thy_file)) {
      print "<p>Compilation failed, no certificate $thy_file produced.";
    }
    if (!file_exists($jvm_file)) {
      print "<p>Compilation failed, no class file $jvm_file produced.";
    } else {
      $success = $jvm_file;
    }
    return $success;
}

function grail_it ($in_file,$out_file,$err_file) {
  global $verbose,  $debug;
  global $tmp_full_dir; 
  global $lib_dir,  $lib_file;
  global $java_dir,  $java_prg,  $java_cp  ;
  global $camelot_dir,  $camelot_prg ;
  global $lfd_infer_dir,  $lfd_infer_prg ;
  global $lp_solve_dir,  $lp_solve_prg ;

  $gr_file = ereg_replace('.cmlt$','.gr',$in_file);
  $jvm_file = ereg_replace('.cmlt$','.class',$in_file);
  $jvm_class = ereg_replace('.class$','',basename($in_file));

    chdir($tmp_full_dir);
    // compilation
    $exec_str = "$camelot_dir/$camelot_prg -g -q -d $tmp_full_dir $in_file > $out_file 2>$err_file";
    print "<h2>Compiling Camelot to Grail</h2>";
    //print "<p>|$exec_str|<br>";
    if ($debug) {
      print "<p><font size=\"-1\" color=\"grey\">";
      print "Exec: |$exec_str|<br>";
      print "</font></p>";
    }
    system($exec_str);
    if (file_exists($out_file)) { // show stdout if successful
      print "<p>Generated Grail code:</p>";
      print "<p><font size=\"-1\"><pre>";
      include($gr_file);
      print "</pre></font></p>";
      print "<p>Result of compilation:</p>";
      print "<p><font size=\"-1\"><pre>";
      include($out_file);
      print "</pre></font></p>";
      $success = $gr_file;
    } else {
     print "<p>An error has occured in compiling the code:<p><font size=\"-1\"><pre>";
      include($err_file);
      print "</pre></font></p>";
      $success = "";
    }
    return $success;
}

function gdf_it ($in_file,$out_file,$err_file) {
  global $verbose,  $debug;
  global $tmp_full_dir; 
  global $lib_dir,  $lib_file;
  global $java_dir,  $java_prg,  $java_cp  ;
  global $camelot_dir,  $camelot_prg ;
  global $lfd_infer_dir,  $lfd_infer_prg ;
  global $lp_solve_dir,  $lp_solve_prg ;
  global $gdf_dir,  $gdf_prg ;

  #$gr_file = ereg_replace('.cmlt$','.gr',$in_file);
  $jvm_file = ereg_replace('.gr$','.class',$in_file);
  $jvm_class = ereg_replace('.class$','',basename($in_file));

    chdir($tmp_full_dir);
    // compilation
    $exec_str = "$gdf_dir/$gdf_prg $gdf_flags -d $tmp_full_dir $in_file > $out_file 2>$err_file";
    print "<h2>Assembling Grail to JVM</h2>";
    //print "<p>|$exec_str|<br>";
    if ($debug) {
      print "<p><font size=\"-1\" color=\"grey\">";
      print "Exec: |$exec_str|<br>";
      print "</font></p>";
    }
    system($exec_str);
    if (filesize($jvm_file)>0) { // show stdout if successful
      print "<p>Generated JVM class file $jvm_file</p>";
      print "<p><font size=\"-1\"><pre>";
      print "</pre></font></p>";
      $success = $jvm_file;
    } else {
     print "<p>An error has occured in the assembler stage:<p><font size=\"-1\"><pre>";
      include($err_file);
      print "</pre></font></p>";
      $success = "";
    }
    return $success;
}

function run_it ($in_file,$inp_str,$out_file,$err_file) {
  global $verbose,  $debug;
  global $tmp_full_dir; 
  global $lib_dir,  $lib_file;
  global $java_dir,  $java_prg, $java_cp  ;
  global $camelot_dir,  $camelot_prg ;
  global $lfd_infer_dir,  $lfd_infer_prg ;
  global $lp_solve_dir,  $lp_solve_prg ;

  $jvm_file = ereg_replace('.cmlt$','.class',$in_file);
  $jvm_class = ereg_replace('.class$','',basename($jvm_file));

    // execute it
//     if (filesize("$lib_dir/$lib_file")=0) {
//       print ("<p>Camelot library " . $lib_dir . "/" . $lib_file . " doesn't exist; aborting\n");
//       return false;
//     }
    system("cp $lib_dir/$lib_file $tmp_full_dir");
    chdir($tmp_full_dir);
    $exec_str = "$java_dir/$java_prg -cp $java_cp $jvm_class $inp_str > $out_file 2>$err_file";
    print "<h2>Executing JVM code of $jvm_class with input $inp_str</h2>";
    //print "<p>|$exec_str|<br>";
    if ($debug) {
      print "<p><font size=\"-1\" color=\"grey\">";
      print "Exec: |$exec_str|<br>";
      print "</font></p>";
    }
    system($exec_str);
    if (filesize($out_file)>0) { // show stdout if successful
      print "<p>Result of the execution:</p>\n";
      print "<p><font size=\"-1\"><pre>";
      include($out_file);
      print "</pre></font></p>";
      $success = $out_file;
    } else { // no stdout file produced: an error has occurred.
     print "<p>An error has occured in executing the code:<p><font size=\"-1\"><pre>";
     include($err_file);
     print "</pre></font></p>";
      $success = "";
  }
    return $success;
}

function jar_it ($prg_file,$mem_mgmt_file,$cert_file,$out_file,$err_file) {
  global $verbose,  $debug;
  global $tmp_full_dir; 
  global $lib_dir,  $lib_file;
  global $java_dir,  $java_prg, $java_cp  ;
  global $camelot_dir,  $camelot_prg ;
  global $lfd_infer_dir,  $lfd_infer_prg ;
  global $lp_solve_dir,  $lp_solve_prg ;

//   // THIS should be input
//   $prg_file = ereg_replace('.cmlt$','.class',$cmlt_file);
//   // THIS should be input
//   $cert_file = ereg_replace('.cmlt$','Certificate.thy',$cmlt_file);

  // use only basenames, not full path, in jar file
  $prg_file0 = basename($prg_file);
  $mem_mgmt_file0 = basename($mem_mgmt_file);
  $cert_file0 = basename($cert_file);

  $class_name = ereg_replace('.class$','',$prg_file0);
  // $mem_mgmt_file = ereg_replace('.class$','$dia_0.class',$prg_file);
  $jar_file = ereg_replace('.class$','.jar',$prg_file);
  $manifest_file = $tmp_full_dir . "/MANIFEST";
  $manifest_file0 = basename($manifest_file);
  
  // call script to build .jar out of $prg_file,$mem_mgmt_file,$cert_file

  chdir($tmp_full_dir);

  $data_layout = get_pragma_string($cert_file0,'DATA_LAYOUT');

  // create MANIFEST
  $fd = fopen($manifest_file,'w');
  fputs($fd,"MRG-ClassName: $class_name\n");
  fputs($fd,"MRG-CertificateName: $cert_file0\n");
  fputs($fd,"MRG-ProgramFile: $prg_file0\n");
  fputs($fd,"MRG-Data-Layout: $data_layout\n");
  fclose ($fd);

  $exec_str = "jar -cmf $manifest_file0 $jar_file $prg_file0 '$mem_mgmt_file0' $cert_file0";
  if ($debug) {
      print "<p><font size=\"-1\" color=\"grey\">";
      print "Jarring: |$exec_str|<br>";
      print "</font></p>";
  }
  // create jar
  system($exec_str);
  if ($debug) {
      print "<p><font size=\"-1\" color=\"grey\">";
      print "JAR file generated: |$jar_file|<br>";
      print "Contents of the JAR file:<p><pre>";
      system("jar -tf $jar_file");
      print "</pre></font></p>";
  } else {
      print "<p>Contents of the JAR file:<p><pre>";
      system("jar -tf $jar_file");
      print "</pre></p>";
  }

  return $jar_file; // really always successful!?
}

function transmit_it($jar_file,$tmp_out_file,$tmp_err_file) {
  global $consumerURL, $producerhost, $consumerhost, $producerbase, $consumerbase;

 $remoteURL = $consumerURL . "?url=". path2url($jar_file,$producerhost,$producerbase)
?>
      <h2>Transmit this jar file</h2>

<p>
<form enctype="multipart/form-data" action="<?php print $remoteURL ?>" method="POST" target="bonzo">
  <p>
   <!-- Input: <input type="text" size=30 name="jar" ><br> -->
   <!-- <input type="hidden" name="file" value="<?php print $jar_file ; ?>"> -->
   <!-- <input type="hidden" name="what" value="<?php print $transmitJART ; ?>"> -->
   <input type="hidden" name="producerhost" value="<?php print $producerhost ?>">
   <input type="hidden" name="consumerhost" value="<?php print $consumerhost ?>">
   <input type="hidden" name="producerbase" value="<?php print $producerbase ?>">
   <input type="hidden" name="consumerbase" value="<?php print $consumerbase ?>">
   <input type="submit" value="Transmit me"><br>
   </p>
</form>

<?php
}

function file_type ($f) {
  $x = preg_match('/\.([^.]*)/',basename($f),$arr);
  if ($x) {
    # print "<p>file_type of $f is " . $arr[1];
    return $arr[1];
  } else {
    # print "<p>file_type of $f is UNKNOWN";
    return "UNKNOWN";
  }
}

?>
