<?php

$debug_funs = 0;
$mathml = 0;

// // set in mktmpdir
// global $tmpdir;
// global $tmpfulldir;

// initialise lib_specs array with known specs of library functions

// ToDo: turn into a function 
$str_lib_init = <<< EOLIB
constdefs initSpec :: "ARGTYPE \<Rightarrow> vdmassn"
"initSpec args == \<lambda> E h hh v p . 
                   (\<forall> n  . 
                      h = emptyheap \<and> E = emptyenv \<and> n = length args
                      \<longrightarrow>
                      (\<exists> a X Xfl Nfl .
                       v = RVal (Ref a) \<and> 
                       (n,Ref a,X,hh) \<in> mLIST \<and>
                       freelist hh Xfl Nfl \<and> X \<inter> Xfl = {} \<and>
                       HSize hh = HSize h + (int n)))"

EOLIB;

// $str_lib_init = <<< EOLIB
// (* spec of revM\<bullet>init *)
// constdefs initTable :: "bool"
// "initTable == (MS InsSortM init =
//    (\<lambda> args E h hh v p . 
//                    (\<forall> n  . 
//                       h = emptyheap \<and> E = emptyenv \<and> n = length args
//                       \<longrightarrow>
//                       (\<exists> a X Xfl Nfl .
//                        v = RVal (Ref a) \<and> 
//                        (n,Ref a,X,hh) \<in> mLIST \<and>
//                        freelist hh Xfl Nfl \<and> X \<inter> Xfl = {} \<and>
//                        HSize hh = HSize h + (int n)))))"

// EOLIB;

$str_lib_init0 = <<< EOLIB
(* spec of revM\<bullet>init0 *)
constdefs initEmpty :: "bool"
"initEmpty == (MS revM init0 =
   (\<lambda> args E h hh v p . v = RVal Nullref \<and> (0,Nullref,{},hh) \<in> mLIST \<and> h = hh))"

EOLIB;


$lib_specs = array('init' => $str_lib_init,
                   'init0' => $str_lib_init0);




// look for a $pragma in $file
// ToDo: read the file only up to "theory" and search in this string
function get_pragma ($file,$pragma) {
  global $debug_funs;
  if ($debug_funs) {
    print "<p>Searching for pragma " . $pragma . " in file " . $file . "<br>\n";
  }
  $found = 0;   $end = 0; 
  $fd = fopen($file,'r');
  $str = fread($fd,800);
  while (!$found && !feof($fd)) {
    // print $str;
    $found = preg_match("/\(\*\#\s+" . $pragma . ":\s+(\d+)\s+\#\*\)/",$str,$match);
    $str = fread($fd,80);
  }
  fclose($fd);    
//   if ($debug) {
//     print "</pre>";
//     if ($found) {
//       print "Found: " . $match[1];
//     } else {
//       print "Nothing Found<br>";
//     }
//   }
  return ($found) ? $match[1] : "";
}

function get_pragma_string ($file,$pragma) {
  global $debug_funs;
//   if ($debug) {
//     print "<p><I>Get Version</I>:<br> <pre>";
//   }
  $found = 0;   $end = 0; 
  $fd = fopen($file,'r');
  $str = fread($fd,800);
  while (!$found && !feof($fd)) {
    // print $str;
    //$end = ereg('theory ',$str);
    $found = preg_match("/\(\*\#\s+" . $pragma . ":\s+\"(.*)\".*\#\*\)/",$str,$match);
    $str = fread($fd,80);
  }
  fclose($fd);    
//   if ($debug_funs) {
//     print "</pre>";
//     if ($found) {
//       print "Found: " . $match[1];
//     } else {
//       print "Nothing Found<br>";
//     }
//   }
  return ($found) ? $match[1] : "";
}

function get_pragma_block ($file,$pragma) {
  global $debug_funs;
  if ($debug_funs) {
     print "<p>Searching for a pragma block with tag |" . $pragma . "|\n";
  }
  $found = 0;   $in_block= 0; $str = ""; $end_marker = "";
  $lines = file($file);
  for($i = 0;$i < count($lines);$i++) {
    $line = $lines[$i];
    if ($in_block) {
      // check for end of block
      $found = preg_match("/^\s*" . $end_marker . "\s*$/",$line,$match);
      if ($found) {
	$in_block = 0;
	if ($debug_funs) {
	  print "<p>Found end-of-block marker |" . $end_marker . "| on line |" . $line . "|\n";
	}
      } else {
	$str .= $line; // add line to block
      }
    } else { // !$in_block
      // check for start of block
      $found = preg_match("/\(\*#\s+" . $pragma . "\s+<<<\s*(\w+)/",$line,$match);
      if ($found) {
	$end_marker = $match[1];
	$in_block = 1;
	if ($debug_funs) {
	  print "<p>Found start of block with end-of-block marker |" . $end_marker . "| on line |" . $line . "|\n";
	}
      }
    }
  }
      
  return ($str);
}

// Build a temporary directory to run Isabelle in.
// 
// Needs to be under document root so that we can serve it up, though.
//
function mktmpdir ($mydir) {
  $tmpdir = "PCCtmp/tmp." . substr(uniqid(""),10) . "/";
  $tmpfulldir = $mydir . "/" . $tmpdir;
  // print "mkdir $tmpfulldir;<br>";
//   if (is_dir($tmpfulldir)) {
//     print "<p>Planning |rm -fr $tmpfulldir|\n";
//   }
  system("mkdir $tmpfulldir;");

  return $tmpfulldir;
}

// Upload a file $upload_tmp_name to $file
// $upload_tmp_name is typically 'tmp_name' of a file entry in a form e.g.
// $_FILES['proof']['tmp_name']
function upload_file ($upload_tmp_name,$file) {
  global $debug_funs;
  if (is_uploaded_file($upload_tmp_name)) {
    move_uploaded_file($upload_tmp_name, $file);
    // print "<p>The file " . $upload_tmp_name . " has been uploaded as " . $file;
    if ($debug_funs) {
      print "<p><font size=\"-2\" color=\"grey\"> <pre>";
      include $file;
      print "</pre></font></p>";
    }
    if ($debug_funs && (filesize($file)==0)) {
      print "<p>WARNING: uploaded file $file is empty.\n";
    }
  } else {
    die ("<p><b>Error in upload of " . $upload_tmp_name . "</b>"); //$_FILES['proof']['name']);
  }
}

function path2url ($path,$host,$base) {
  global $debug_funs;
  $x = preg_match('/^.*\/producer\/(.*)$/',$path,$res);
  if ($debug_funs) {
    if ($x) {
      print "<p>path2URL: match succeeded; matched |$res[1]|<br>\n";
    } else {
      print "<p>path2URL: ERROR match failed for |$path|<br>\n";
    }
  }
  if ($host == "") {
    return $res[1];
  } else {
    return "http://".$host."/".$base."/".$res[1];
  }
}

function filelinelength($filename) {
  $file = file($filename);
  return count($file);
}


// Markup a theory file.  Based on unsymbolize.pl in Isabelle dist.
function markup_grailfile($filename) {
  $file = file($filename);
  print "<pre>";
  for($i = 0;$i < count($file);$i++) {
	 $line = $file[$i];
	 $line = ereg_replace("<","&lt;",$line);
	 $line = ereg_replace(">","&gt;",$line);
    // FIXME: match against whole keyword here?
	 $line = ereg_replace("(null |class |field |method |let |val |fun |in |end |new |checkcast |instanceof |invokestatic |invokevirtual |invokespecial |getfield |putfield |make |get |set |length |empty |add |sub |mul |static |final |public |protected |private)","<font color=\"#F0B0B0\">\\1</font>",$line);
	 print $line;  
  }
  print "</pre>";
}
  
// Markup a theory file.  Based on unsymbolize.pl in Isabelle dist.
// FIXME: quite broken
function markup_thyfile($filename) {
  global $mathml;

  $file = file($filename);
  if ($mathml) { 
    print "<math xmlns='http://www.w3.org/1998/Math/MathML' display='block'>";
  }
  print "<pre>";
  for($i = 0;$i < count($file);$i++) {
	 $line = $file[$i];
	 // First, escape < and > 
	 $line = ereg_replace("<","&lt;",$line);
	 $line = ereg_replace(">","&gt;",$line);
	 $line = ereg_replace("\\ &lt=\\ ","&le; ",$line);
	 $line = ereg_replace("\\ &gt=\\ ","&ge; ",$line);
	 $line = ereg_replace("\\\\&lt;lambda&gt;","&lambda;",$line);
	 $line = ereg_replace("\\\\&lt;langle&gt;","&lt;",$line);
	 $line = ereg_replace("\\\\&lt;rangle&gt;","&gt;",$line);
	 $line = ereg_replace("\\\\&lt;exists&gt;","&exist;",$line);
	 $line = ereg_replace("\\?\\ ","&exist; ",$line);
	 $line = ereg_replace("\\\\&lt;forall&gt;","&forall;",$line);
	 // Pure
	 $line = ereg_replace("\\\\&lt;And&gt;","!!",$line);
	 $line = ereg_replace("\\\\&lt;Colon&gt;","::",$line);
	 $line = ereg_replace("\\\\&lt;Longrightarrow&gt;","==&gt;",$line);
	 $line = ereg_replace("\\\\&lt;Midarrow&gt;\\\\&lt;Rightarrow&gt;","==&gt;",$line);
	 $line = ereg_replace("\\\\&lt;Rightarrow&gt;","&rArr;",$line); // =&gt
	 $line = ereg_replace("\\\\&lt;equiv&gt;","&equiv;",$line); // ==
	 $line = ereg_replace("\\\\&lt;dots&gt;","...",$line);
	 $line = ereg_replace("\\\\&lt;lbrakk&gt; ?","[| ",$line);
	 $line = ereg_replace("\\\\ ?&lt;rbrakk&gt;"," |]",$line);
	 $line = ereg_replace("\\\\&lt;lparr&gt; ?","(| ",$line);
	 $line = ereg_replace("\\\\ ?&lt;rparr&gt;"," |)",$line);
	 // HOL
	 $line = ereg_replace("\\\\&lt;longleftrightarrow&gt;","&harr;",$line); // lt;-&gt;
	 $line = ereg_replace("\\\\&lt;longrightarrow&gt;","--&gt;",$line); // &rarr not reliable
	 $line = ereg_replace("\\\\&lt;midarrow&gt;\\\\&lt;rightarrow&gt;","--&gt;",$line);
	 $line = ereg_replace("\\\\&lt;rightarrow&gt;","-&gt;",$line);
	 $line = ereg_replace("\\\\&lt;not&gt;","~",$line);
	 $line = ereg_replace("\\\\&lt;epsilon&gt; ?","SOME ",$line);
	 // outer syntax
	 $line = ereg_replace("\\\\&lt;rightleftharpoons&gt;","==",$line);
	 $line = ereg_replace("\\\\&lt;rightharpoonup&gt;","=&gt;",$line);
	 $line = ereg_replace("\\\\&lt;leftharpoondown&gt;","&lt;=",$line);
	 // Patch in some MathML
	 if ($mathml){ 
	   $line = ereg_replace("\\\\&lt;\\^sub&gt;m","<sub>m</sub>",$line);
	   $line = ereg_replace("\\\\&lt;\\^sub&gt;v","<sub>v</sub>",$line);
	   $line = ereg_replace("\\\\&lt;\\^sub&gt;p","<sub>p</sub>",$line);
	   $line = ereg_replace("\\\\&lt;rhd&gt;","<mo>&RightTriangle;</mo>",$line);
	   $line = ereg_replace("\\\\&lt;mapsto&gt;","<mo>&map;</mo>",$line);
	 }
	 $line = preg_replace("/(also|apply|apply_end|assume|automaton|axclass|axioms|back|by|cannot_undo|case|cd|chapter|classes|classrel|clear_undos|coinductive|commit|constdefs|consts|context|datatype|declare|def|defaultsort|defer|defer_recdef|defs|disable_pr|done|enable_pr|end|exit|finally|fix|from|global|have|header|hence|hide|inductive|inductive_cases|init_toplevel|instance|judgment|kill|kill_thy|lemma|lemmas|let|local|method_setup|moreover|next|nonterminals|note|obtain|oops|oracle|parse_ast_translation|parse_translation|prefer|presume|pretty_setmargin|primrec|print_antiquotations|print_ast_translation|print_attributes|print_binds|print_cases|print_claset|print_commands|print_context|print_facts|print_methods|print_simpset|print_syntax|print_theorems|print_theory|print_trans_rules|print_translation|proof|prop|pwd|qed|quit|recdef|recdef_tc|record|redo|remove_thy|rep_datatype|sect|section|setup|show|sorry|subsect|subsection|subsubsect|subsubsection|syntax|term|text|text_raw|then|theorem|theorems|theory|thm|thm_deps|thms_containing|thus|token_translation|touch_all_thys|touch_child_thys|touch_thy|translations|typ|typed_print_translation|typedecl|typedef|types|ultimately|undo|undos_proof|update_thy|update_thy_only|use|use_thy|use_thy_only|welcome|with)/","<font color=\"#F0B0B0\">\\1</font>",$line);
	 print $line;  
  }
  print "</pre>";
  if ($mathml) { 
    print "</math>";
  }
}

function show_shortcuts() {
 global $producerhost, $producerbase, $producerURL;
 global $consumerhost, $consumerbase, $consumerURL;

 print "<table>\n";
 if (!($producerURL == "")) {
   $producerIdxURL = "http://" . $producerhost . "/" . $producerbase . "/index.php";
?>
	      <td><a href="<?php print $producerURL ?>">Producer Top</a></td><tr>
<?php
 }
 if (!($consumerURL == "")) {
   $consumerURLindex = "http://" . $consumerhost . "/" . $consumerbase . "/index.php";
?>
  <td><a href="<?php print $consumerURLindex ?>" target="bonzo">Consumer Top</a></td><tr>
<?php
 }
 print "</table>\n";
}
  
?>