<?php
// romulus setup --------------------------------------------------

// machine dependent constants
// running the demo on a different machine should only require changes
// in this file
// configure.php should be a link to the right configure-<machine>/php

// The following packages are required on the producer side:
// (those marked with + are external; those with - are part of mrg/progs)
//  + j2sdk toolkit from Sun (best: version 1.4.1)
//  - Camelot compiler
//  - Camelotlib.class, a class file with std Camelot library functions
//  - Grail assembler and disassembler (gdf/gf)
//  - lfd_infer space inference
//  + lp_solve linear programming library

// Note: 
//    - the progs-y2 directory is mrg/progs from the MRG repository
//      from the time of the 2nd year review (Rovereto II)
//    - to build lfd_infer, ocaml is needed; the top-level lfd_infer 
//      generated by such a build is bytecode, with the path to the 
//      bytecode-interpreter hard-wired in it (might need change)
//    - to build gdf, Moscow ML is needed
//    - to build gf, MLj is needed; see the docu in mrg/progs/Grail/gf

// ToDo:
//  - Specify versions for each of the required packages
//  - Give links to the right version for installation
//  - Replace hand-edited configure files with a configure script

# root dir of the web server
$srv_root = "/var/www/html";
$srv_url = "http://romulus.tcs.ifi.lmu.de";

# inlined from former paths.php
$include_prefix = $srv_root . "/mrg/pcc4/producer";
$base_prefix = $srv_url . "/mrg/pcc4/producer";
$cgi_prefix = $srv_url . "/cgi-bin";


#$mrg_root = "/home/hwloidl/mrg-working";
$mrg_root = "/var/www/cgi-bin/mrg";
$progs_root = $mrg_root . "/progs-demo-y4";
$progs_HEAD_root = $mrg_root . "/progs-demo-y4";
#$progs_HEAD_root = $mrg_root . "/progs";

// where to find the Java installation
$java_dir = "/usr/java/j2sdk1.4.1_01/bin";
$java_lib = "/usr/java/j2sdk1.4.1_01";
$java_prg = "java";
//$java_cp  = "/home/hwloidl/mrg/progs-y2/Grail/gf/gf.zip:/home/hwloidl/mrg/progs-y2/Grail/gf/bcel.jar:/usr/java/j2sdk1.4.1_01:.";

$lfd_infer_dir = $progs_root . "/LFD_inference";
$lfd_infer_prg = "lfd_infer";

// Camelot installation
$camelot_dir = $progs_root . "/Camelot/src";
$camelot_prg = "camelot";
$camelot_flags = " -n -thy -C -lfd -lfd-opts \"-olhs 4\" -lfd-dir $lfd_infer_dir -lfd-prg $lfd_infer_prg ";  // space inference and cert gen!


// Camelot library functions as pre-compiled class file
$lib_dir = $srv_root . "/mrg/pcc4/consumer/heaps";
$lib_file = "Camelotlib.class";

// Grail disassembler (this in turn needs java installation above)
$gf_dir = $progs_root . "/Grail/gf";
$gf_prg = "gf";

// Linear programming library used by lfd_infer
$lp_solve_dir = "/usr/local/bin";
$lp_solve_prg = "lp_solve";

?>