<?php
include 'paths.php';

function list_dir ($dir) {
  global $php_self;

  $verbose_list = false;
  if ($dir == "") {
    print "<p>ERROR in list_dir: dir |$dir| is omitted\n";
    return;
  }

 if (strlen($dir)>20) {
    $short_dir = "...".(substr($dir,strlen($dir)-20));
 }
 print "<h2>$short_dir</h2>\n";

 $dd=opendir("$dir");
 print " <p><table>\n";
 print " <th>Filename</th>\n";
 if ($verbose_list) {
   print "<th width=\"20%\">Size</th>\n";
   print "<th width=\"30%\">Modified</th>\n";
 }
 print "<tr>\n";

 clearstatcache();
 while ($f=readdir($dd)) {
   if (is_dir($f)) {
     $d = $dir."/".$f;
     // print "<p>I think I want to enter $d now";
     print "<td><a href=\"" . $php_self . "?dir=" . $d . "\"><em>$f</em></a></td>\n";
     if ($verbose_list) {
       print " <td>".  "</td> <td>" . 
	 date('D\ M,\ Y\ H:i:s',filemtime($dir."/".$f)) . "</td>\n";
     }
     print "<tr> \n";
   } else {
     if (preg_match('/.*~$/',$f) | preg_match('/.*\^$/',$f) | preg_match('/CVS/',$f) | preg_match('/^\./',$f)) { // ignore backup files
       continue;
     }
     print "<td><a href=\"" . $php_self . "?dir=$dir&file=$f\">$f</a></td>\n";
     if ($verbose_list) {
       print " <td>". 
             filesize($dir."/".$f) . "</td> <td>" . 
	     date('D\ M,\ Y\ H:i:s',filemtime($dir."/".$f)) . "</td><tr>";
     }
     print "<tr> \n";
   }
 }
 print "</table>\n";
 closedir($dd);
}

function write_to_file ($dir,$file,$message) {

  if ($dir == "" || $file == "") {
    print "<p>ERROR in write_file: either dir |$dir| or file |$file| is omitted\n";
    return;
  }

 $f = $dir."/".$file;
 if (file_exists($f)) {
   $fd = fopen($f,"w");
   $date_time = date('l\ d\ M,\ Y\ \@\ g:i A');
   fputs ($fd,"$message");
   fputs ($fd,"Last update: $date_time");
   fclose($fd);
 } else {
   print "<p><b>Error: file $f does not exist\n";
 }
}

function show_file ($dir,$file) {  
 $f=$dir."/".$file;

 print "<h2>Contents of file $f</h2>\n";

 if (ereg('.*.html$',$file)) {
   include ($f);
 } else {
   print "<p><pre>\n";
   include ($f);
   print "</pre></p>\n";
 }
}

function edit_file ($dir,$file,$ty,$really_edit){
  global $inferT,  $grailT,  $compileT,  $generateJART,  $runT,  $gdfT,  $allT;
  global $php_self;

  if ($file == "") {
    print "<p>ERROR in edit_file: dir |$dir| is omitted\n";
    return;
  }
  if ($dir == "") {
    $f = $file;
  } else {
    $f = $dir."/".$file;
  }
?>
<h2>Edit file <?php echo "$file" ; ?></h2>

<p>
<form action="<?php echo $php_self; ?>"
      method="GET"
      enctype="multipart/form-data">
<?php
  if ($really_edit) {
    print "<input type=\"hidden\" name=\"file\" value=\"$file\">\n";
    print "<input type=\"hidden\" name=\"dir\" value=\"$dir\">\n";
    print "<textarea name=\"code\" rows=20 cols=80>\n";
    include ($f); // FixMe: literal include!
    print "</textarea>\n";
  } else {
    print "<input type=\"hidden\" name=\"file\" value=\"$file\">\n";
    print "<input type=\"hidden\" name=\"dir\" value=\"$dir\">\n";
  }

  if ($ty == "cmlt") {
?>
<p>
<input type="radio" name="what" value="<?php print $inferT ?>">Space inference, 
<input type="radio" name="what" value="<?php print $grailT ?>">Compile to Grail, 
<input type="radio" name="what" value="<?php print $compileT ?>" checked>Compile to JVM,
<input type="submit"  value="Submit">
</form>
<?php
  } else if ($ty == "gr") {
?>
<input type="radio" name="what" value="<?php print $gdfT ?>">Compile to JVM,
<input type="submit"  value="Submit">
</form>   
<?php
  } else if ($ty == "class") {
?>
<input type="radio" name="what" value="<?php print $generateJART ?>">Generate JAR file,
<input type="submit"  value="Submit">
</form>   
<?php
  } else if ($ty == "jar") {
?>
<input type="radio" name="what" value="<?php print $transmitJART ?>">Transmit JAR file,
<input type="submit"  value="Submit">
</form>   
<?php
  } else {
   print "<p><b>Unknown file type: " . $ty;
   print "<input type=\"submit\"  value=\"Submit\"></form>\n";
 }
}

?>

<?php
function dispatch_from_infer($file,$jvm_file,$mem_mgmt_file,$cert_file,$dir) {
  global  $producerhost, $consumerhost, $producerbase, $consumerbase;
  global $compileT, $generateJART;
  global $php_self;
?>

<p>
<h2>What next?</h2> 

<?php
  if ($cert_file==""){
?>

<p>
<form action="<?php echo $php_self; ?>"
      method="GET"
      enctype="multipart/form-data">
  <input type="hidden" name="file" value="<?php print $file ?>">
  <input type="hidden" name="dir" value="<?php print $dir ?>">
  <input type="hidden" name="producerhost" value="<?php print $producerhost ?>">
  <input type="hidden" name="consumerhost" value="<?php print $consumerhost ?>">
  <input type="hidden" name="producerbase" value="<?php print $producerbase ?>">
  <input type="hidden" name="consumerbase" value="<?php print $consumerbase ?>">
  <input type="hidden" name="what" value="<?php print $compileT ?>">
  <input type="submit" value="Compile this file"><br>
   </p>
</form>

<?php
}

  if ($cert_file!=""){
?>

<form action="<?php echo $php_self; ?>"
      method="POST"
      enctype="multipart/form-data">
  <input type="hidden" name="file" value="<?php print $file ?>">
  <input type="hidden" name="jvm" value="<?php print $jvm_file ?>">
  <input type="hidden" name="mem_mgmt" value="<?php print $mem_mgmt_file ?>">
  <input type="hidden" name="certificate" value="<?php print $cert_file ?>">
  <input type="hidden" name="dir" value="<?php print $dir ?>">
  <input type="hidden" name="producerhost" value="<?php print $producerhost ?>">
  <input type="hidden" name="consumerhost" value="<?php print $consumerhost ?>">
  <input type="hidden" name="producerbase" value="<?php print $producerbase ?>">
  <input type="hidden" name="consumerbase" value="<?php print $consumerbase ?>">
  <input type="hidden" name="what" value="<?php print $generateJART ?>">
  Attach own certificate? <input type="file" name="cert_upload"><br>
  <input type="submit" value="Pack the files">
   </p>
</form>

<?php
}
?>
<!--
<form action="<?php echo $php_self; ?>"
      method="POST"
      enctype="multipart/form-data">
  <input type="hidden" name="file" value="<?php print $file ?>">
  <input type="hidden" name="jvm" value="<?php print $jvm_file ?>">
  <input type="hidden" name="mem_mgmt" value="<?php print $mem_mgmt_file ?>">
  <input type="hidden" name="dir" value="<?php print $dir ?>">
  <input type="hidden" name="producerhost" value="<?php print $producerhost ?>">
  <input type="hidden" name="consumerhost" value="<?php print $consumerhost ?>">
  <input type="hidden" name="producerbase" value="<?php print $producerbase ?>">
  <input type="hidden" name="consumerbase" value="<?php print $consumerbase ?>">
  <input type="hidden" name="what" value="<?php print $generateJART ?>">
  <input type="submit" value="Attach own certificate">
  <input type="file" name="cert_upload"><br>
   </p>
</form>
-->

<form action="<?php echo $php_self; ?>"
      method="GET"
      enctype="multipart/form-data">
  <input type="hidden" name="file" value="">
  <input type="hidden" name="dir" value="">
  <input type="hidden" name="producerhost" value="<?php print $producerhost ?>">
  <input type="hidden" name="consumerhost" value="<?php print $consumerhost ?>">
  <input type="hidden" name="producerbase" value="<?php print $producerbase ?>">
  <input type="hidden" name="consumerbase" value="<?php print $consumerbase ?>">
  <input type="hidden" name="what" value="">
  <input type="submit" value="Producer top"><br>
   </p>
</form>
<?php
}
?>