<?php 
include("header.php");
include("consumer_functions.php");

$debug = 0;
$verbose = 0;
$dry_run = 0;
$show_tables = 1; 
$show_aux_lemmas = 0; 

include("configure.php");
include("constants.php");

include("functions.php");
// also does init lib_specs;

print_header();

// ---------------------------------------------------------------------------
// read arguments from the form

// $Classfile = $_POST['class'];

$mydir = dirname($_SERVER["SCRIPT_FILENAME"]);
$tmp_full_dir = mktmpdir ($mydir);
// name of Isabelle root file for cert check
$ROOTml =    $tmp_full_dir . "ROOT.ML";

// ---------------------------------------------------------------------------
// clean up

$success_file = $tmp_full_dir . $success_name;
if (file_exists($success_file)) {
  unlink($success_file);
  if ($debug) {
    print "<p>Deleted existing success-file: $success_file\n";
  }
}

// ---------------------------------------------------------------------------

report_in_files();

// NB: if jar file is submitted, names of class, proof and dia file should be 
//     read from the MANIFEST file!
if ($_FILES['jar']['name']!="" && ($_FILES['proof']['name']!="" ||
				   $_FILES['class']['name']!="" ||
				   $_FILES['dia']['name']!="")) {
  die("<p>ERROR: can't upload both jar and class/proof/dia files");
}

// ---------------------------------------------------------------------------
// upload files

if ($debug) {
      print "<p><ul><li>file = $file<li>grfile = $grfile<li>thyfile = $thyfile</ul><br>";
      print "<p>FILES: <ul><li>class = " . $_FILES['class']['name'] . "(" . $_FILES['class']['tmp_name'] . ")" . "; size=" . $_FILES['class']['size'] . "<li>proof = " . $_FILES['proof']['name'] . "(" . $_FILES['proof']['tmp_name'] . ")" . "; size=" . $_FILES['proof']['size'] . "</ul><br>";
}

if ($_FILES['jar']['name']!="" || $_GET['url']!="") { // jar file uploaded ---------
  if ($_GET['url']!="") {
    $jar_file = $tmp_full_dir . basename($_GET['url']);
    suck_file($_GET['url'],$jar_file);
  } else { 
    $jar_file   = $tmp_full_dir . $_FILES['jar']['name'];
    upload_file ($_FILES['jar']['tmp_name'],$jar_file);
  }
  if (filesize($jar_file)==0) {
    print "<p>Warning: uploaded jar file $jar_file is empty.<br>\n";
  } else {
    chdir($tmp_full_dir);
    // unpack jar
    if ($debug) {
      print "<p><font size=\"-1\" color=\"grey\">";
      print "Uploaded JAR file with this contents: |$jar_file|<br><pre>";
      system("jar -tf $jar_file");
      print "</pre><p>Now unpacking ...</font></p>";
    }
    $exec_str = "jar -xf $jar_file 1>/dev/null 2>/dev/null";
    system($exec_str);
    if ($debug) {
      print "<p><font size=\"-1\" color=\"grey\"><pre>";
      print "Unpacking: |$exec_str|<br>";
      print "</pre></font></p>";
    }
    // read MANIFEST file to get class name etc
    list($class_name,$cert,$class) = read_manifest();

    // set file names based on manifest
    $class_file = $tmp_full_dir . $class;
    $dia_file = ereg_replace('.class$','$dia_0.class',$class_file);
    $proof_file = $tmp_full_dir . $cert; // ereg_replace('.gr$','.thy',$grfile);
    $class = $class_name;
 } 

} else { // individual files uploaded ---------------------------------------------

 // set file names based on arguments provided
 $class_file   = $tmp_full_dir . $_FILES['class']['name'];
 $dia_file   = $tmp_full_dir . $_FILES['dia']['name'];
 $proof_file = $tmp_full_dir . $_FILES['proof']['name'];
 $class = basename($class_file,'.class');

 // application class file
 if ($_FILES['class']['name']!="") {
  upload_file ($_FILES['class']['tmp_name'],$class_file);
  if (filesize($class_file)==0) {
    print "<p>Warning: uploaded application class $class_file is empty.<br>\n";
  }
 } 

 if ($_FILES['dia']['name']!="") {
  upload_file ($_FILES['dia']['tmp_name'],$dia_file);
  if (filesize($dia_file)==0) {
    print "<p>Warning: uploaded mem mgmt class $dia_file is empty.<br>\n";
  }
 }

 // certificate
 if ($_FILES['proof']['tmp_name']!="") {
  upload_file ($_FILES['proof']['tmp_name'],$proof_file);
  if (filesize($proof_file)==0) {
    print "<p>Warning: uploaded certificate $proof_file is empty.<br>\n";
  }
 }
}

// Filenames from here on (full path!):
//  Input:  $class_file, $dia_file, $proof_file
//  Derived: $class

report_in_files_verbose();

// ---------------------------------------------------------------------------
// reading pragmas from uploaded files for picking flavours for the programs to run

list
 ($layout,          // data layout
 $camelot_flavour, // flavour of compiler; named after CVS tag
 $gdf_flavour,     // flavour of assembler; named after CVS tag 
 $gf_flavour,      // flavour of disassembler; named after CVS tag
 $lib_spec_pragma, // pragmas for library code
 $logic_version,$adt,$spec)   // pragmas for logic version, abs datatype, specification
 = read_pragmas($class,$class_file,$dia_file,$proof_file);

 $logic_version = ($logic_version=="") ? $default_logic : $logic_version;

// ---------------------------------------------------------------------------
// .class --> .gr: run gf disassembler (also builds producer-side certificate)

list($gr_file,$thy_file,$c2file,$c3file) = class2gr($class,$class_file);

fix_gr_file($gr_file);

// ---------------------------------------------------------------------------
// .gr --> .thy

// gdf step not needed on consumer side any more! gf now produces gf files
// $thy_file = gr2thy($gr_file);

//show_files();

$thingies = array (new Thingy($gr_file, "Program code (.gr version)"),
		   new Thingy($thy_file, "Program code (.thy version)"),
		   new Thingy($proof_file, "Producer-side certificate (1)"),
		   new Thingy($c2file, "Consumer-side certificate (2)"),
		   new Thingy($c3file, "Consumer-side certificate (3)"),
		   new Thingy($ROOTml, "Isabelle root file (ROOT.ML)"));

show_thingies($thingies);

//????
// copy uploaded class file back to it's orig place
//system("cp $tmp_class_file $file");

fix_thy_file($thy_file);

// ---------------------------------------------------------------------------
// prepare Isabelle files 

prepare_Isabelle_files($thy_file);

print_certcheck_header($proof_file);

compose_Isabelle_files($LogicFile,$LogicAlias,$proof_file);

// ++++++++++++++
$ret = launch_Isabelle($logic_version, $adt);

// ---------------------------------------------------------------------------
// analyse result from Isabelle run

if ($debug) {
   print "<p>Isabelle returned with code $ret";
}

if (!(file_exists($success_file))) { // $ret!=0
?>

<div id="run">

<p>
<table>
<td> <IMG SRC="icon.stop.gif" ALT="Stop"> &nbsp;&nbsp;&nbsp;  </td>
<td>The resource property couldn't be proven. The code will not be executed.</td>
</table>

<?php
 }

 if (file_exists($success_file) && file_exists($class_file) && file_exists($dia_file)) {
  // ignore producer side input
  //$input_str = $_POST['input'];

?>

<hr>

<div id="run">

<p>
<table>
<td> <IMG SRC="mrg-parcel-transp-64pix.png" ALT="Ok"> &nbsp;&nbsp;&nbsp; </td>
<td> The code fulfills the specified resource property. You can now execute it. </td>
</table>

<br>
<form action="exec.php" method="POST">
 Input: <input type="text" name="input">&nbsp;&nbsp;&nbsp;
 <input type="hidden" name="tmpfulldir" value="<?php print $tmp_full_dir?>">
 <input type="hidden" name="class_file" value="<?php print $class_file?>">
 <input type="hidden" name="dia_file" value="<?php print $dia_file?>">
 <input type="hidden" name="java_dir" value="<?php print $java_dir?>">
 <input type="hidden" name="java_prg" value="<?php print $java_prg?>">
 <input type="hidden" name="java_cp" value="<?php print $java_cp?>">
 <input type="submit" value="Run it">
</form>
</td>
</table>

</div>

<?php
 } // if 'dia' file submitted, too


include("footer.php");
?>
