<?php

function print_header () {
# Header 

print <<< EOFF
<h1>Code Consumer</h1>

<p>
The code consumer receives the transmitted files, checks the certificate and,
 if successful, executes the code.

<div id="bodyText">
EOFF;
}

// ---------------------------------------------------------------------------

function report_in_files() {
  global $debug, $verbose; 

  //    $PCCprogramFile = $tmp_full_dir . $PCCprogramName;
  //$class_tmp_name = $_FILES['class']['tmp_name'];
  //$file   = $tmp_full_dir . $_FILES['class']['name'];

//  if ($debug) {
//   print "<p>FILES:<ul><li>jar=" . $_FILES['jar']['name'] . "<li>Class=" . $_FILES['class']['name'] . "<li>Proof=" . $_FILES['proof']['name'] ."</ul><br>\n";
//   print "<p>Context:<ul><li>producerhost = $producerhost <li>consumerhost = $consumerhost <li>producerbase = $producerbase <li>consumerbase = $consumerbase</ul>\n";
//   if (is_uploaded_file($_FILES['jar']['tmp_name'])){
//     print "<p>JAR file " . $_FILES['jar']['tmp_name'] . " successfully uploaded.\n";
//   } else {
//     print "<p>NO JAR file uploaded. Is this what you want?\n";
//   }
//  }

  $n = 0; $str = "";
  if ($_FILES['jar']['name']) {
    $n++;
    $str .= "<li> a jar file";
  }
  if ($_FILES['dia']['name']) {
    $n++;
    $str .= "<li> a memory management class file";
  }
  if ($_FILES['class']['name']) {
    $n++;
    $str .= "<li> an application class file";
  }
  if ($_FILES['proof']['name']) {
    $n++;
    $str .= "<li> a certificate";
  }

//   if ($n>0) {
//     print "<p>The following $n files have been received: <ul>" . $str . "</ul><br>\n";
//   } else {
//     print "<p>ERROR: no files received\n";
//   }
}

// ---------------------------------------------------------------------------

function report_in_files_verbose() {
  global $debug, $verbose; 
  global $class_file, $dia_file,  $proof_file;

 if ($debug) {
  print "<p><font size=\"-1\" color=\"grey\">Upload summary " . ($jar_file!="")?"(upload of jar file)":"(upload of individual files)" . ":\n<ul>\n";
  print " <li> App class file: |" . $class_file . "|; size = " . filesize($class_file) . "\n";
  print " <li> Mem mgmt class file: |" . $dia_file . "|; size = " . filesize($dia_file) . "\n";
  print " <li> Certificate: |" . $proof_file . "|; size = " . filesize($proof_file) . "\n";
  print "</ul></font></p>\n";
 }
 if ($verbose) {
  if (filesize($class_file)==0) {
    print "<p>Warning: uploaded application class $file is empty.<br>\n";
  }
  if (filesize($dia_file)==0) {
    print "<p>Warning: uploaded mem mgmt file $dia_file is empty.<br>\n";
  }
  if (filesize($proof_file)==0) {
    print "<p>Warning: uploaded certificate $proof_file is empty.<br>\n";
  }
 }
}

// ---------------------------------------------------------------------------

function read_manifest () {
    $fm = fopen("META-INF/MANIFEST.MF","r");
    while ($arr = fgetcsv($fm,120,": ")) {
      switch ($arr[0]) {
	  case "MRG-ClassName":
	    $class_name = $arr[1];
	    break;
	  case "MRG-CertificateName":
	    $cert = $arr[1];
	    break;
	  case "MRG-ProgramFile":
	    $class = $arr[1];
	    break;
	  default:
	    if ($debug) { print "<p>read_manifest: Unknown field $arr[0]\n"; }
	    break;
	  }
    }
    fclose ($fm);
    return array($class_name,$cert,$class);
}

// ---------------------------------------------------------------------------

function mkWrapper ($class, $wrapper) {

  $wrapper_file = $class . "Wrap.thy";
  $fd = fopen($wrapper_file,"w");
  $s0 = "theory " . $class . "Wrap = " . $class . "_Consumer2:\n";
  fputs($fd, $s0);

  $s1 = <<<EOFF
(* --------------------------------------------------------------------------- *)
(* WRAPPER *)

axioms sort_parlist:
 "fst (methtable InsSortM InsSortM'sort) = [RNpar InsSortM'sort'l]"

consts init :: mname
       INPUT :: "ARG list"
       l0 :: rname 

translations 
       "init" == "(MN ''init_'') "
       "l0" == "(RN ''l0_'') "

constdefs emptyheap :: "heap"
"emptyheap == (| oheap = emptyfinmap, iheap = (\<lambda> x r . (0::int)) , rheap = (\<lambda> x r. Nullref), sheap = (\<lambda> c r . Nullref) |)"

constdefs emptyenv :: "env"
"emptyenv == (| ienv = emptyi , renv = emptyr |)"

(*# UNFOLD_LIB init #*)
constdefs initSpecDA :: "vdmassn"
"initSpecDA  == \<lbrace> {}, 0, (emptyfinmap(InsSortM'sort'l \<mapsto>\<^sub>f(IlistET 1 0))) \<ggreater> (IlistET 0 0), 0\<rbrace>"

axioms bonzo: "  \<rhd> cn\<bullet>mn(args) : \<lambda>E. \<lbrace> U , n , G \<ggreater>  T , m \<rbrace>
            (newframe_env Nullref args' args E) 
       \<Longrightarrow> \<rhd> cn\<bullet>mn(args) : \<lbrace> U , n , G \<ggreater>  T , m \<rbrace> "


lemma card_emptyheap0: "card (Dom emptyheap) = 0"
apply (simp add: emptyheap_def)
done

lemma bonzo_1838: "oheap h = oheap hh ==> Dom h = Dom hh"
apply (simp add: fmap_dom_def)
done

lemma empFree: "freelist emptyheap {} 0"
apply (simp add: freelist_def emptyheap_def)
apply (rule FL_NIL)
done

lemma eq_sym: "(a::oheap)=b ==> b=a"
apply auto
done

lemma DA_Weaken_Context: "\<lbrakk> \<rhd> e : \<lbrace> U, m, C  \<ggreater>  T , n \<rbrace> ; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x \<rbrakk> \<Longrightarrow> \<rhd> e : \<lbrace> U, m, D  \<ggreater>  T , n \<rbrace>"
apply (rule vdm_conseq)
apply simp
apply clarsimp
apply (rule DAss_Contexts_same_on_U)
apply (rotate_tac -1)
apply simp
apply clarsimp
done

EOFF;

  fputs($fd, $s1);
  $s2 = "lemma wrapper: \"" . $wrapper . "\"\n";
  fputs($fd,$s2);
  $s3 = <<<EOFF
apply (rule vdm_conseq)
apply (rule DA_letr)
apply (simp add: initSpecDA_def)
apply (erule thin_rl)
apply (insert T_sort [of "InsSortM'sort'l"])
(*<<*)
apply (simp add: sMST_def SPEC_def)
apply (drule bonzo)
apply (rule DA_Weaken_Context)
apply simp
(* -- only side conditions left *)
apply clarsimp
apply simp
apply simp
apply simp
apply clarsimp
(* -- now unwind DASS, and discharge preconds for emptyheap and emptyenv *)
apply (erule thin_rl)   (* don't need spec of init any more *)
apply (erule thin_rl)   (* don't need spec of sort any more *)
apply (drule DAss_Contexts_same_on_U)
apply simp

apply (simp add: DAss_def)
apply (erule_tac x="0" in allE)
apply (erule_tac x="{}" in allE)
apply (erule_tac x="{}" in allE)
apply clarsimp
apply (erule impE)
apply (rule_tac x="0" in exI)
apply (rule conjI)
apply (rule empFree)
apply (rule_tac x="0" in exI)
apply (rule conjI)
apply (insert CS_NIL)
defer 1
(* fails on non-empty usage set claimed by initSpec *)
apply simp
apply (rotate_tac -1)
apply clarsimp
(* apply (erule thin_rl) apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl)apply (erule thin_rl) *)
apply (rotate_tac -1) apply (drule eq_sym) apply (rotate_tac -1)
apply (drule bonzo_1838)
apply (simp)
apply (insert card_emptyheap0)
apply (simp)
(* last side-cond: prove the bound! *)
apply (rule CS_NIL)
apply simp
apply simp
done
EOFF;

  fputs($fd, $s3);
  fclose($fd);

}

// ---------------------------------------------------------------------------


function read_pragmas($class,$class_file,$dia_file,$proof_file) {
  global $debug, $verbose; 
  global $camelot_flavour_dir, $camelot_flavour_prg;
  global $gdf_dir, $gdf_prg, $gdf_args; // might change this!
  global $gf_dir, $gf_prg, $gf_args; // might change this!
  global $camelot_dir, $camelot_prg, $camelot_args; // might change this!
  global $wrapper, $cmn;  

  # name of library functions for which specs should be unfolded;
  # for now, each UNFOLD_LIB x is replaced with lib_spec[x] if x is in this list
  $lib_spec_pragma = get_pragma_string($proof_file,'LIB_SPEC');
  if ($debug && $lib_spec_pragma!="") {
    print "Found LIB_SPEC pragma: |" . $lib_spec_pragma . "|\n";
  }

  # get logic version from file; if nothing there read POST field
  $v = get_pragma($proof_file,'LOGIC_VERSION');

  $adt = get_pragma($proof_file,'DATATYPE');
  if ($debug && $adt!="") {
   print "<p>Found DATATYPE pragma for: " . $adt . "(" . $ADTName[$adt] .")\n<br>";
  }

  $spec = get_pragma_string($proof_file,'SPEC');
  if ($debug && $spec!="") {
   print "<p>Found SPEC pragma: |$spec|\n<br>";
  }


  # a "flavour" picks one of several CVS rep branches; default: demo-y2; others: HEAD
  $gdf_flavour = get_pragma_string($proof_file,'GDF_FLAVOUR');
  if ($debug && $gdf_flavour!="") {
    print "Found GDF_FLAVOUR pragma: |" . $gdf_flavour . "|\n";
  }

  if ($gdf_flavour) {
    $gdf_dir = $gdf_flavour_dir[$gdf_flavour];
    $gdf_prg = $gdf_flavour_prg[$gdf_flavour];
  }

  $gdf_args = get_pragma_string($proof_file,'GDF_ARGS');
  if ($debug && $gdf_args!="") {
    print "Found  GDF_ARGS pragma: |" . $gdf_args . "|\n";
  }

  # DATA_LAYOUT pragma will be passed as argument -L to gf
  $layout = get_pragma_string($proof_file,'DATA_LAYOUT');
  if ($layout!="") {
    if ($debug) {
      print "Found DATA_LAYOUT pragma: |" . $layout . "|<br>\n";
    }
    $gf_args = " -L $layout " . $gf_args;
    if ($debug) {
      print "gf_args is now: |" . $gf_args . "|<br>\n";
    }
  } else {
    if ($debug) {
      print "Warning: empty DATA_LAYOUT pragma<br>\n";
    }
  }

  # TAG_OFFSET pragma will be passed as argument -T to gf
  $tag_offset = get_pragma_string($proof_file,'TAG_OFFSET');
  if ($tag_offset!="") {
    if ($debug!="") {
      print "Found TAG_OFFSET pragma: |" . $tag_offset . "|<br>\n";
    }
    $gf_args = " -T $tag_offset " . $gf_args;
    if ($debug!="") {
      print "gf_args is now: |" . $gf_args . "|<br>\n";
    }
  } else {
    if ($debug) {
      print "Warning: empty TAG_OFFSET pragma<br>\n";
    }
  }


  # TACTIC_FLAVOUR pragma will be passed as argument -F to gf
  $tactic_flavour = get_pragma_string($proof_file,'TACTIC_FLAVOUR');
  if ($tactic_flavour!="") {
    if ($debug!="") {
      print "Found TACTIC_FLAVOUR pragma: |" . $tactic_flavour . "|<br>\n";
    }
    $gf_args = " -F $tactic_flavour " . $gf_args;
    if ($debug!="") {
      print "gf_args is now: |" . $gf_args . "|<br>\n";
    }
  } else {
    if ($debug) {
      print "Warning: empty TACTIC_FLAVOUR pragma<br>\n";
    }
  }


 # a "flavour" picks one of several CVS rep branches; default: demo-y2; others: HEAD
 $gf_flavour = get_pragma_string($proof_file,'GF_FLAVOUR');
 if ($debug && $gf_flavour!="") {
   print "Found GF_FLAVOUR pragma: |" . $gf_flavour . "|<br>\n";
 }

 if ($gf_flavour!="") {
  $gf_dir = $gf_flavour_dir[$gf_flavour];
  $gf_prg = $gf_flavour_prg[$gf_flavour];
  if ($debug) {
    print "<p>gf_dir = |$gf_dir|; gf_prg = |$gf_prg|; gf_args = |$gf_args|<br>\n";
  }
 }

 # a "flavour" picks one of several CVS rep branches; default: demo-y2; others: HEAD
 $camelot_flavour = get_pragma_string($proof_file,'CAMELOT_FLAVOUR');
 if ($debug && $camelot_flavour!="") {
  print "Found CAMELOT_FLAVOUR pragma: |" . $camelot_flavour . "|<br>\n";
 }

 if ($camelot_flavour) {
  $camelot_dir = $camelot_flavour_dir[$camelot_flavour];
  $camelot_prg = $camelot_flavour_prg[$camelot_flavour];
 }

# # -----
#  # Pragmas for theory file
# # only the name of the table used for the top level theorem
# # needed if more than 1 method are certified
# $fullTable = get_pragma_string($proof_file,'FULL_TABLE');
# if ($debug && $cmn!="") {
#   print "Found FULL_TABLE pragma: |" . $fullTable . "|<br>\n";
# }

$cmn = get_pragma_string($proof_file,'CERTIFIED_METHOD');
if ($debug && $cmn!="") {
  print "Found CERTIFIED_METHOD pragma: |" . $cmn . "|<br>\n";
}
if ($cmn) {
  // this flag tells gf to produce a wrapper
  $gf_args .= " -W ";
  // split it into components
    $found_certm = preg_match('/InvokeStatic\s+(\S+)\s+(\S+)(.+)/',$cmn,$res);
    if ($found_certm) {
      $cn = $res[1];
      $mn = $res[2];
      $params = $res[3];
      $str = "|" . $cn . "|" . $mn . "|" . $params . "|";
    } else { 
      if ($debug) { 
	print "<p> Can't split CERTIFIED_METHOD |" . $cmn . 
               "| for logic version |" . $version . "|<br>\n"; 
      }
    }
} else {
  if ($debug) {
    print "<p>Warning: No CERTIFIED_METHOD pragma found\n";
  }
}

#   // split it into components
#   switch ($version) {
#   case '70':
#     $found_certm = preg_match('/InvokeStatic\s+(\S+)\s+(\S+)\(([^)]+)\)/',$cmn,$res);
#     if ($found_certm) {
#       $cn = $res[1];
#       $mn = $res[2];
#       $params = $res[3];
#       $str = "|" . $cn . "|" . $mn . "|" . $params . "|";
#     } else { 
#       if ($debug) { 
# 	print "<p> Can't split CERTIFIED_METHOD |" . $cmn . 
#                "| for logic version |" . $version . "|<br>\n"; 
#       }
#     }
#     break;

#   case '80': // DA1 logic
#     $found_certm = preg_match('/InvokeStatic\s+(\S+)\s+(\S+)\(([^)]+)\)/',$cmn,$res);
#     if ($found_certm) {
# 	$cn = $res[1];
# 	$mn = $res[2];
# 	$params = $res[3];
# 	$str = "|" . $cn . "|" . $mn . "|" . $params . "|";
#     } else { 
#       if ($debug) { 
# 	print "<p> Can't split CERTIFIED_METHOD |" . $cmn . 
#                "| for logic version |" . $version . "|<br>\n"; 
#       }
#     }
#     // NB: no myTable spec in this version
#   $str_mainThm = <<< EOFF
# syntax myTable :: bool
# translations
#  "myTable" => "$fullTable"

# theorem mainThm: "myTable ==> \<rhd> InvokeStatic $cn $mn $params:
#                             MS $cn $mn $params"
# apply (rule GCInvs)
# apply (erule myContext_good)
# apply (simp_all add: myContext_def)
# apply (rule, simp)
# apply (insert mySpec_Framecorrect, fastsimp)
# done 
# EOFF;
#     break;

#   case '90': // DA logic
#     $found_certm = preg_match('/InvokeStatic\s+(\S+)\s+(\S+)\(([^)]+)\)/',$cmn,$res);
#     if ($found_certm) {
# 	$cn = $res[1];
# 	$mn = $res[2];
# 	$params = $res[3];
# 	$str = "|" . $cn . "|" . $mn . "|" . $params . "|";
#     } else { 
#       if ($debug) { 
# 	print "<p> Can't split CERTIFIED_METHOD |" . $cmn . 
#                "| for logic version |" . $version . "|<br>\n"; 
#       }
#     }

#   $str_myTable = <<< EOFF
# constdefs myTable::bool
# "myTable == 
#  (MS $cn $mn = (\<lambda> args E h hh v p . mySpec (newframe_env Nullref (fst (methtable $cn $mn)) args E) h hh v p))"
# EOFF;


#   $str_mainThm = <<< EOFF
# theorem "myTable ==> \<rhd> InvokeStatic $cn $mn $params:
#                             MS $cn $mn $params"
# apply (rule GCInvs)
# apply (erule myContext_good)
# apply (simp_all add: myContext_def)
# apply (rule, simp)
# apply (insert mySpec_Framecorrect, fastsimp)
# done
# EOFF;
#     break;

#   default:
#     # can't split
#     $str = "Can't split";
#     break;
#   }

#   $html_mainThm = htmlspecialchars($str_mainThm);

#   $html_myTable = htmlspecialchars($str_myTable);

#   if ($debug) {
#     print "<p>This is a certificate for the following method: " . $cmn . "\n<br>\n" .
#       "components: $str\n";
#   }

# } else {
#   if ($debug) {
#     print "<p>No CERTIFIED_METHOD pragma found\n";
#   }
# }

// $wrapper = get_pragma_block($proof_file,'WRAPPER');
// if ($debug && $wrapper!="") {
//   print "Found WRAPPER pragma: " . $wrapper . "<br>\n";
// }
// if ($spec) {
//   $str_mySpec = "constdefs mySpec :: vdmassn\n".
//     "\"mySpec == $spec\"";
//   $html_mySpec = htmlspecialchars($str_mySpec);
// }

// if ($cmn) {
//   $gf_args .= " -W ";
// }

//  print <<< EOFF
// <h2>Main Theorem</h2>
// EOFF;

//  $str_wrappedThm = <<<FFFF
// theorem wrapper:   
//    " \\<rhd> InvokeStatic " . $cn . " init INPUT : initSpecDA \\<Longrightarrow>
// \\<rhd> (LET rf " . $cn . "'sort'l = InvokeStatic " . $cn . " init INPUT IN " .
// $cmn . " END) : (\\<lambda> E h hh v p . (ALL n m a X .  h = emptyheap & E =
// emptyenv & n = length INPUT\n -->\n (HSize hh <= (int HEAP_BOUND) )))"
// FFFF;

//  $html_wrappedThm = htmlspecialchars($str_wrappedThm);

//   $html_wrappedThm = ereg_replace("Longrightarrow&gt;","Longrightarrow&gt;\n ",  $html_wrappedThm);
//   $html_wrappedThm = ereg_replace("longrightarrow&gt;","longrightarrow&gt;\n       ",  $html_wrappedThm);
//   $html_wrappedThm = ereg_replace("rhd&gt;","rhd&gt;\n          ",  $html_wrappedThm);
//   $html_wrappedThm = ereg_replace(":",":\n          ",  $html_wrappedThm);
//   $html_wrappedThm = ereg_replace(";",";\n            ",  $html_wrappedThm);
//   $html_wrappedThm = ereg_replace("IN ","IN \n          ",  $html_wrappedThm);

//  print "<p>The main resource property to prove for this program is:<pre>" .
//    $html_wrappedThm . "</pre>\n";

//  } # wrapper?  

 # this is now done in gf when given flag -W
 #mkWrapper($class,$wrapper);

 $leak = get_pragma_string($proof_file,'MEMORY_LEAK');
 $leak_detected = ($leak == "1");
 if ($debug && $leak!="") {
   print "<p>Found MEMORY LEAK pragma: |$leak_detected|\n<br>";
  }

 return array
        ($layout,          // data layout
 	 $camelot_flavour, // flavour of compiler; named after CVS tag
 	 $gdf_flavour,     // flavour of assembler; named after CVS tag 
 	 $gf_flavour,      // flavour of disassembler; named after CVS tag
         $leak,
 	 $lib_spec_pragma,
 	 $v,$adt,$spec);   // pragmas for logic version, abstr data type, specification
}

// ---------------------------------------------------------------------------


function class2gr($class,$class_file) {
 global $debug, $verbose, $tmp_full_dir;
 global $consumerfile, $consumerbase; // read only
 global $gf_dir, $gf_prg, $gf_args;  // read only
 global $c1file, $c2file, $c3file;  // really needed
 global $wrapper, $wrapper_file, $cmn;

 $gr_file = ereg_replace('.class$','.gr',$class_file);
 $thy_file = ereg_replace('.class$','.thy',$class_file);

 // Disassemble class file into a Grail file
 if (!file_exists("$gf_dir/$gf_prg")) {
  die ("Didn't find gf in $gf_dir/$gf_prg<br>");
 }

 //$java_cp  = $gf_dir . "/gf.zip:" . $gf_dir . "/bcel.jar:" . $java_lib . ":.";
 //$gf_cmd = $java_dir . "/" . $java_prg . " -cp " . $java_cp . " " . $gf_prg; 
 $gf_cmd = $gf_dir . "/" . $gf_prg;

 //$c1file = ereg_replace('.thy$','Certificate1.thy',$proof_file);
 $c2file = ereg_replace('.thy$','_Consumer1.thy',$thy_file);
 $c3file = ereg_replace('.thy$','_Consumer2.thy',$thy_file);
 $wrapper_file = ereg_replace('.thy$','Wrap.thy',$thy_file);
 
 $exec_str = "cd $tmp_full_dir; $gf_cmd $gf_args $class > $gr_file";
 if ($debug) {
   print "<p><font size=\"+3\" color=\"grey\">gf_args: |".$gf_args."|; class=|".$class."|\n</font></p>";
   print "<p><font size=\"-1\" color=\"grey\">Now executing: |" . $exec_str . "</font></p>";
 }

 $url = path2url($gr_file,$consumerhost,$consumerbase);

 system($exec_str);

 if ($verbose) {
  print "<p><h2>Grail code from the classfile</h2>\n";
  print "<p><font size=\"-1\"><pre>";
  include ("$gr_file");
  print "</pre></font>";
  if (file_exists($c2file)) {
    print "<p>Produced consumer-side certificate: <a href=\""
      . path2url($c2file,$consumerfile,$consumerbase) . "\">$c2file</a>";
  }
  if (file_exists($c3file)) {
    print "<p>Produced consumer-side certificate: <a href=\""
      . path2url($c3file,$consumerfile,$consumerbase) . "\">$c3file</a>";
  }
 } else {
//   print <<< EOFF
// <p>
// Grail code has been generated. <a href="$url">Click here</a> to examine it.&nbsp;&nbsp;&nbsp;<form action="markup.php" method="POST" target="markup">
//  <input type="hidden" name="kind" value="gr">
//  <input type="hidden" name="file" value="$gr_file">
//  <input type="submit" value="Markup">
// </form>
// EOFF;
 }

 return array($gr_file,$thy_file,$c2file,$c3file);
}

// ---------------------------------------------------------------------------

function fix_gr_file($gr_file) {
 # Fixing .gr file if necessary
 $tmpfile = ereg_replace('.gr$','.tmp',$gr_file);

switch (basename($gr_file)) {
  default:
   # delete first and last line; these are gf-messages!
   system("cat $gr_file | sed '1d;\$d' > $tmpfile; mv $tmpfile $gr_file");
   break;
 }
}

// OLD
//  case "lenM.gr":
//    system("cat $gr_file | sed -e 's/null\[\]/null\[lenM\$dia_0\]/' > $tmpfile; mv $tmpfile $gr_file");
//    break;

//  case "appendM.gr":
//    system("cat $gr_file | sed -e 's/null\[\]/null\[appendM\$dia_0\]/' > $tmpfile; mv $tmpfile $gr_file");
//    break;

//  case "revM.gr":
//    system("cat $gr_file | sed -e 's/null\[\]/null\[revM\$dia_0\]/' > $tmpfile; mv $tmpfile $gr_file");
//    break;

//  case "rM.gr":
//    system("cat $gr_file | sed -e 's/null\[\]/null\[rM\$dia_0\]/' > $tmpfile; mv $tmpfile $gr_file");
//    break;

//  default:
//    $nname = basename($gr_file,'.gr');
//    system("cat $gr_file | sed -e 's/null\[\]/null\[$nname\$dia_0\]/' > $tmpfile; mv $tmpfile $grfile");
//    break;
   
// }


// ---------------------------------------------------------------------------

# obsolete code
function gr2thy($gr_file,$class_file) {
  global $debug, $verbose; 
  global $gdf_dir, $gdf_prg, $gdf_args; # might change this!

 # Generate Isabelle theory file out of Grail file
 if (!is_executable("$gdf_dir/$gdf_prg")) {
  die ("Didn't find gdf in $gdf_dir/$gdf_prg<br>");
 }

 $tmp_class_file = ereg_replace('.class$','-tmp.class',$file);
 # copy uploaded class file; will be overwritten by gdf!!
 copy($class_file,$tmp_class_file);

 # gdf_args maybe set via pragma; if it isn't, set it here
 $args = ($gdf_args ? $gdf_args : "-t vcg");
 
 $errfile = $tmp_full_dir . "/err";
 $exec_str = "cd $tmp_full_dir; $gdf_dir/$gdf_prg -d $tmp_full_dir $args $gr_file 1>>$errfile 2>>$errfile";
 if ($debug) {
  print "<p><font size=\"-2\" color=\"grey\">Now executing: |" . $exec_str . "</font></p>";
 }

 system($exec_str); 
}

// ---------------------------------------------------------------------------

function show_thingies($thingies) {
 global $debug, $verbose, $tmp_full_dir; 

   print <<< EOFF
<p>
<!-- Isabelle theory files for Grail code, and certificate files generated. Click on the
  links to examine the files: -->
<table>
EOFF;

 foreach ($thingies as $x) {
   //$url = path2url($tmp_full_dir."MRG.thy",$consumerhost,$consumerbase);
   $url  = path2url($tmp_full_dir . $x->file,$consumerhost,$consumerbase);

   print "<td> <a href=\"" . $url . "\">" . basename($x->file) . "</a></td>" .
         "<td>" . ($x->description) . "</td><tr>\n";
 }
  print <<< EOFF
</table>
EOFF;

}

# Old stuff
//    if ($verbose) {
//      print "<p>The following files have been produced:<p><table> ";
//      print "<p><font size=\"-1\" color=\"grey\"><pre>";
//      include ($thyfile);
//      print "</pre></font></p>";
//      if ($debug) {
//        print "<p>ERROR file:<br> ";
//        print "<p><font size=\"-1\" color=\"grey\"><pre>";
//        include ($errfile);
//        print "</pre></font></p>";
//      }
//    } else {

// <p>
// <form action="markup.php" method="POST" target="markup">
//  <input type="hidden" name="kind" value="thy">
//  <input type="hidden" name="file" value="$thyfile">
//  <input type="submit" value="Markup">
// </form>
// EOFF;
// }


// ----------------------------------------------------------------------------

function fix_thy_file($thy_file) {
 global $debug, $verbose; 

 # Fixing .thy file if necessary
 $tmpfile = ereg_replace('.thy$','-tmp.thy',$thyfile);

 switch (basename($thyfile)) {
  default :
    if ($debug) {
      print "<p>NOT Fixing .thy file $thy_file...\n";
    }
    break;
 }
}

# Old switch statement over prg name:
 // OLD
 //  case "append.thy":
 //    if ($debug) {
 //      print "<p>Fixing .thy file $thyfile...\n";
 //    }
 //    system("cat $thyfile | sed -e \"s/append'append'fail'_t0/RNarg append'append'_t0/\"  > $tmpfile; mv $tmpfile $thyfile");
 //    break;

 //  case "appendM.thy":
 //    if ($debug) {
 //      print "<p>Fixing .thy file $thyfile...\n";
 //    }
 //    system("cat $thyfile | sed -e \"s/appendM'append'fail'_t0/RNarg appendM'append'_t0/\"  > $tmpfile; mv $tmpfile $thyfile");
 //    system("cat $thyfile | sed -e \"s/printFlatExp says: Ill-formed expression/expr.Null/\" > $tmpfile; mv $tmpfile $thyfile");
 //    system("cat $thyfile | sed -e \"s/axioms Meth_appendM'atol1__2\[simp\]/\(\* axioms Meth_appendM'atol1__2[simp]/;s/axioms Meth_appendM'append\[simp\]/\*\) axioms Meth_appendM'append[simp]/;s/axioms Fun_appendM'atol1__2'f_0\[simp\]/\(\* axioms Fun_appendM'atol1__2'f_0[simp]/;s/axioms Fun_appendM'append'f_0\[simp\]/\*\) axioms Fun_appendM'append'f_0[simp]/\" > $tmpfile ; mv $tmpfile $thyfile");
 //    break;

 //  case "Rev4DA.thy":
 //    if ($debug) {
 //      print "<p>Fixing .thy file $thyfile...\n";
 //    }
 //    system("cat $thyfile | sed -e \"s/Rev4DA'rev'fail'_t0/RNarg Rev4DA'rev'_t0/\" > $tmpfile; mv $tmpfile $thyfile");
 //    break;

 //  case "revM.thy":
 //    if ($debug) {
 //      $pre = $tmp_full_dir . "pre.thy";
 //      system("cp $thyfile $pre");
 //      print "<p>Fixing .thy file $thyfile...\n";
 //    }
 //    system("cat $thyfile | sed -e \"s/revM'rev'fail'_t0/RNarg revM'rev'_t0/\" > $tmpfile; mv $tmpfile $thyfile");
 //    system("cat $thyfile | sed -e \"s/printFlatExp says: Ill-formed expression/expr.Null/\" > $tmpfile; mv $tmpfile $thyfile");
 //    system("cat $thyfile | sed -e \"s/axioms Meth_revM'atol1__2\[simp\]/\(\* axioms Meth_revM'atol1__2[simp]/;s/axioms Meth_revM'rev\[simp\]/\*\) axioms Meth_revM'rev[simp]/;s/axioms Fun_revM'atol1__2'f_0\[simp\]/\(\* axioms Fun_revM'atol1__2'f_0[simp]/;s/axioms Fun_revM'rev'f_0\[simp\]/\*\) axioms Fun_revM'rev'f_0[simp]/\" > $tmpfile ; mv $tmpfile $thyfile");
 //    break;

 //  case "rM.thy":
 //    if ($debug) {
 //      print "<p>Fixing .thy file $thyfile...\n";
 //    }
 //    system("cat $thyfile | sed -e \"s/rM'rev'fail'_t0/RNarg rM'rev'_t0/\" > $tmpfile; mv $tmpfile $thyfile");
 //    system("cat $thyfile | sed -e \"s/printFlatExp says: Ill-formed expression/expr.Null/\" > $tmpfile; mv $tmpfile $thyfile");
 //    break;

 //  case "InsSortM.thy":
 //    if ($debug) {
 //      $pre = $tmp_full_dir . "pre.thy";
 //      system("cp $thyfile $pre");
 //      print "<p>Fixing .thy file $thyfile...\n";
 //    }
 //    // system("cat $thyfile | sed -e \"s/revM'rev'fail'_t0/RNarg revM'rev'_t0/\" > $tmpfile; mv $tmpfile $thyfile");
 //    // system("cat $thyfile | sed -e \"s/printFlatExp says: Ill-formed expression/expr.Null/\" > $tmpfile; mv $tmpfile $thyfile");
 //    system("cat $thyfile | sed -e \"s/axioms Meth_InsSortM'atol1__2/\(\* axioms Meth_InsSortM'atol1__2/;s/axioms Fun_InsSortM'ins/\*\) axioms Fun_InsSortM'ins/;s/axioms Fun_InsSortM'atol1__2'f_0\[simp\]/\(\* axioms Fun_InsSortM'atol1__2'f_0[simp]/;s/axioms Fun_InsSortM'rev'f_0\[simp\]/\*\) axioms Fun_InsSortM'rev'f_0[simp]/\" > $tmpfile ; mv $tmpfile $thyfile");
 //    break;

// ---------------------------------------------------------------------------

function prepare_Isabelle_files($thy_file) {
 global $debug, $verbose, $tmp_full_dir, $mydir; 
 global $logic_version, $adt, $spec;   # pragmas!
 # these are OUTPUT vars!
 global $str_mySpec, $html_mySpec;
 global $LogicFile, $LogicAlias, $str_mySpec, $html_mySpec;
 global $ROOTml, $BaseDir, $PCCbasedir,  $PCCpolicydir; 
 global $success_file, $success_str;
 global $wrapper, $cmn;

 if ($debug) {
   print "<p>Version of the Logic: " . $version . "(" . $LogicName[$version] .")\n<br>";
 }

 // $LogicFile = $tmp_full_dir . "MRG.thy"; // "PCCBase.thy";
// switch ($version) {
//   case '70':
//     //$LogicAlias = "theory PCCBase = " . $LogicModule[$v] . ":\n\nend\n";
//     if ($adt == 7) {
//       $LogicAlias = "theory MRG = Comb + NILList + AuxNILList:";
//     } else {
//       $LogicAlias = "theory MRG = Comb:";
//     }
//     break;

//   case '80':
//     if ($adt == 7) {
//       $LogicAlias = "theory MRG = DAss_rulesU + NILList:";
//     } else {
//       $LogicAlias = "theory MRG = DAss_rulesU:";
//     }
//     break;

//   case '90':
//     if ($adt == 7) {
//       $LogicAlias = "theory MRG = DAss_rulesU + NILList:";
//     } else {
//       $LogicAlias = "theory MRG = DAss_rulesU:";
//     }
//     break;
// }

// //$PCCfinal = "Consumer";
// $ROOTml =    $tmp_full_dir . "ROOT.ML";
// $usecmd =   "use_thy \\\"" . basename($LogicFile,'.thy') . "\\\";\n";
// $usecmd =   "use_thy \\\"" . basename($proof_file,'.thy') . "\\\";\n";
// $usecmd =   'use_thy \"Cert\";';

//$usecmd =   "use_thy \"" . basename($LogicFile,'.thy') . "Certificate3.thy\";\n";
 if ($cmn) { 
   $top_level_thy = basename($thy_file,'.thy') . "Wrap";
 } else {
   $top_level_thy = basename($thy_file,'.thy') . "_Consumer2";
 } 
 $usecmd = "let\n" .
           "  val _  = print_mode := [\"HTML\"] \n" .
           "  val n1 = Time.now ()\n" .
           "  val _  = use_thy \"" . $top_level_thy . "\" handle _ => OS.Process.exit(OS.Process.success):unit\n" .
           "  val _  = TextIO.print \"SUCCESS: Resource property proven\\n\"\n" .
           "  val n2 = Time.now ()\n" . 
           "  val _  = TextIO.print (\"Elapsed time: \"^(Time.toString (n2-n1))^\"sec\")\n".
           "  val s = TextIO.openOut(\"" . $success_file . "\")\n" .
           "  val _ = TextIO.output(s,\"" . $success_str . "\")\n" .
           "  val _ = TextIO.output(s,\"\\n\")\n" .
           "  val _ = TextIO.closeOut(s)\n" .
           "  val _ = OS.Process.exit(OS.Process.success):unit \n" .
           "in\n" .
           " ()\n" .
           "end \n";

 $fx = fopen($ROOTml,"w");
 fputs($fx,$usecmd);
 fclose ($fx);
 // system("echo \"$usecmd\" > $ROOTml");

 if ($debug) {
  print "Generated a root file with name $ROOTml containing:";
  print "<p><font size=\"-2\" color=\"grey\"> <pre>";
  include ("$ROOTml");
  print "</pre></font></p>";
 }

 # Link in the common files and the policy files
 $PCCbasedir   = $mydir . "/" . $BaseDir[$version];
 # ToDo: should be  indxed over logic version
 $PCCpolicydir = $mydir . "/PolicyCurrent";
 system("sh -c \"ln -s $PCCbasedir/*.thy $tmp_full_dir\"");
 system("sh -c \"ln -s $PCCpolicydir/*.thy $tmp_full_dir\"");

 if ($spec) {
  $str_mySpec = "constdefs mySpec :: vdmassn\n".
    "\"mySpec == $spec\"";
  $html_mySpec = htmlspecialchars($str_mySpec);
 }

 print "</div>";

 # print '<p>Assembling files in a  <a href="' . $tmp_full_dir . '">temporary directory</a></p>';
}

// ---------------------------------------------------------------------------

function print_certcheck_header($cfile) {
 global $debug, $verbose, $tmp_full_dir; 
 // INPUT vars
 global $show_aux_lemmas;
 global $cmn, $cn, $html_mainThm, $html_pseudoThm, $str_mainThm, $str_pseudoThm;
 global $wrapper_file;

 print "<h1>Verifying the certificate by running Isabelle</h1>";

 // Make PCCBase.thy
 // Make top-level theory file of that logic version; just an alias

 print "<div id=\"verify\">";

 print <<< EOFF

<h2>Structure of the checked file</h2>

<p>
The assembled Isabelle theory file consists of the following components:
<ul>
 <li> Isabelle version of the <b>Grail code</b>, produced from the class file;
 <li> <b>Certificate</b> that was transmitted with the code, containing information
  on the space consumption;
 <li> Automatically generated <b>specifications for all Camelot functions</b>,
  matching the inferred space consumption;
 <li> Automatically generated <b>top-level theorem</b>, proving the resource property
</ul>
EOFF;

  if ($show_aux_lemmas) {
  print <<< EOFF
<h2>Auxiliary lemmas</h2>

<p>
For each method a <b>specification</b> of its space consumption and
a theorem expressing this <b>resource property</b> are generated.

EOFF;
} else {
 print "";
//   print <<< EOFF
// <h2>Resource Property</h2>
// EOFF;
}


  # pick out the info on space consumption from the certificate
  print "<p>Space consumption for each function, formalised as derived assertion:";
  $fd=fopen($cfile,"r");
  $xx=0;
  print "<p>\n";
  while ($l=fgetcsv($fd,240,"\n")) {
    $line=$l[0];
    if (preg_match('/^defs SPEC/',$line)){
      $xx=1;
      print "<p><table>\n";
      continue;
    }
    if ($xx==1) {
      if (preg_match('/else/',$line)){
	continue;
      }
      if (preg_match('/^if ([^ ]*) = (.*) then (.*)$/',$line,$arr)) {
        #$lc = utf8_encode(chr(0xe3).chr(0x80).chr(0x9a)); # utf8_encode("&DoubleLeftBracket;"); #utf8_decode("〚");
        #$rc = utf8_encode("&DoubleRightBracket;"); #utf8_decode("〛");
        #$lc = chr(0xe3).chr(0x80).chr(0x9a);
        #$rc = "\xe3\x80\x9b";
        $gg= "\xc2\xbb";
	$q = $arr[3];
    	$q = ereg_replace("\\\\<lbrace>","<m:math><m:mi>[[</m:mi></m:math>",$q);
    	$q = ereg_replace("\\\\<rbrace>","<m:math><m:mi>]]</m:mi></m:math>",$q);
    	$q = ereg_replace("\\\\<ggreater>","<m:math><m:mi>&gt;&gt;</m:mi></m:math>",$q);
        $q = ereg_replace("\\\\<\\^sub>f","|->",$q);
        $q = ereg_replace("emptyfinmap","{}",$q);
        $q = ereg_replace("[A-Za-z0-9]*\'[A-Za-z0-9]*\'","",$q);
        $q = ereg_replace("\(\*[A-Za-z0-9_ ]*\*\)","",$q);

	print "<td>".$arr[2]."</td>  <td><font color=\"#BBBB66\">".$q."</font>"."</td><tr>\n";
      }
      if (preg_match('/lambda/',$line)){
	$xx=0;
	print "</p></table>\n";
	continue;
      }
    }
  }
  fclose($fd);

 if ($cmn) {
  #print "<p>The <b>specification</b> of the certified method is:<pre>\n" .
  #    $html_mySpec . "</pre>\n";

  #print "Reading wrapper from file " . $wrapper_file;

  $str_wrappedThm = "<p><table><td>\n";
  $fd=fopen($wrapper_file,"r");
  $xx=0;
  #print "<p><font color=\"#444422\">\n";
  while ($l=fgetcsv($fd,240,"\n")) {
    $line=$l[0];
    $rhd = "⊳";
    $q = $line;
    $q = ereg_replace("\"","",$q);
    $q = ereg_replace("&","&and;",$q);
    $q = ereg_replace("\\\\<rhd>","<m:math><m:mi>|&gt;</m:mi></m:math>",$q);
    $q = ereg_replace("\\\\<lambda>","&lambda;",$q);
    $q = ereg_replace("\\\\<Longrightarrow>","&rArr;",$q);
    $q = ereg_replace("\\\\<longrightarrow>","&rarr;",$q);
    $q = ereg_replace("\\\\<lbrace>","<m:math><m:mi>〚</m:mi></m:math>",$q);
    $q = ereg_replace("\\\\<rbrace>","<m:math><m:mi>〛</m:mi></m:math>",$q);
    $q = ereg_replace("\\\\<ggreater>","<m:math><m:mi>»</m:mi></m:math>",$q);
    $q = ereg_replace("\\\\<\\^sub>f","|->",$q);
    $q = ereg_replace("emptyfinmap","{}",$q);
    $q = ereg_replace("emptyheap","&empty;",$q);
    $q = ereg_replace("emptyenv","&empty;",$q);
    $q = ereg_replace(" IN[^P]"," IN\n     ",$q);
    $q = ereg_replace(" : "," :\n     ",$q);
    $q = ereg_replace("\(ALL","<m:mi>&forall;</m:mi>\n     ",$q);
    $q = ereg_replace(" \" ","\n \" ",$q);
    $q = ereg_replace("==>","&rArr;",$q);
    $q = ereg_replace("-->","&rarr;",$q);
    $q = ereg_replace("(\*[A-Za-z0-9_ ]*\*)","",$q);


    # insert line breaks
    $q = ereg_replace("&rArr;","&rArr;\n</td>\n<tr>\n<td align=left>\n",$q);
    $q = ereg_replace("\(&lambda;","\n</td>\n<tr>\n<td align=left>\n(&lambda;",$q);

    $line = $q;

    if ($xx==1) {
      if (preg_match('/^apply/',$line)){
        $xx = 0;
	$line .= "</td>\n</table>\n";
	continue;
      }
      $str_wrappedThm .= $line;
    } else {
      if (preg_match('/^theorem/',$line)){
        $xx = 1;
        $str_wrappedThm .= ereg_replace("theorem[ ]*resourceStatement:","theorem resourceStatement:</td>\n<tr>\n<td align=left>",$line);
      }
    }
  }
  fclose($fd);

  #print "WRAPPED STR: |". $str_wrappedThm . "|\n";

  # $str_wrappedThm = system("cat InsSortWWrap.thy | sed '/^theorem wrapper/,/^apply/!d' | sed '/^apply/d'");


//   $str_wrappedThm = <<<FFFF
// theorem wrapper:   
//    " \\<rhd> InvokeStatic " . $cn . " init INPUT : initSpecDA \\<Longrightarrow>
// \\<rhd> (LET rf " . $cn . "'sort'l = InvokeStatic " . $cn . " init INPUT IN " .
// $cmn . " END) : (\\<lambda> E h hh v p . (ALL n m a X .  h = emptyheap & E =
// emptyenv & n = length INPUT\n -->\n (HSize hh <= (int HEAP_BOUND) )))"
// FFFF;

//  $html_wrappedThm = htmlspecialchars($str_wrappedThm);
  $html_wrappedThm = $str_wrappedThm;

  $res = preg_match("/^(.*)apply/",$html_mainThm);
  print "<p>Finally, the system proves this <b>overall resource statement</b>:\n" .
    $html_wrappedThm . "\n";

  # $html_pseudoThm = htmlspecialchars("myContext \<rhd> body(method) : DAss ...");
  print <<< EOFF
<!--
<p>
In this proof, an auxiliary lemma is used, verifying that the body
of the certified method fulfils the inferred space property.
This lemma has the following structure:
<pre>
 $html_pseudoThm
</pre>
This is the only part of the Certificate that (currently) has to
be manually generated.
-->
EOFF;
 }
} // print_certcheck_header

// ---------------------------------------------------------------------------

# only needed if we dump everything into one file!

# function compose_Isabelle_files($LogicFile,$LogicAlias,$proof_file) {
#  global $debug, $verbose, $tmp_full_dir, $show_tables;   
#  // INPUT vars
#  global $logic_version, $mydir;
#  global $cmn, $spec, $str_mySpec, $html_mySpec, $str_myTable, $html_myTable,
#         $lib_spec_pragma, $version, $wrapper, $str_wrappedThm, $html_wrappedThm;

#  // make header
#  $fd = fopen($LogicFile,"w");
#  fputs ($fd,"(* Isabelle file generated out of:\n" .
#            "     code         $class_file\n" .
#            "     certificate  $proof_file\n" .
#            "*)\n\n");
#  fputs ($fd,$LogicAlias."\n\n");
#  fputs ($fd,"ML {* print_mode := [\"HTML\"] ; *}\n\n");
#  fputs ($fd,"ML {*  val n1 = Time.now (); *}\n\n");
#  // grab code generated via gf and gdf
#  // fputs ($fd,"(* -- thy file generated via gf and gdf *)\n");

#  fputs ($fd,"(* ---------------------------------------------------- *)\n");
#  fputs ($fd,"(* 1. Prg code *)\n");
#  fclose($fd);
#  $exec_str = "cat $proof_file | sed -e '/^theory/d;/^end/d' >> $LogicFile";
#  if ($debug) {
#   print "<p><font size=\"-2\" color=\"grey\">Now inserting gdf-generated program code: |" . $exec_str . "</font></p>";
#  }
#  system($exec_str);

#  // grab the resource policy
#  //system("echo \"(* -- Resource policy *)\" >> $LogicFile");
#  //system("cat $PCCpolicydir/ResourcePolicy.thy | sed -e '/^theory/d;/^end/d' >>  $LogicFile");

#  $fd = fopen($LogicFile,"a");
#  fputs ($fd,"(* ---------------------------------------------------- *)\n");
#  fputs ($fd,"(* 2. Automatically generated tables and specifications *)\n");
#  fclose($fd);

#  if ($spec) {
#   $fd = fopen($LogicFile,"a");
#   // $str_spec set right after reading pragma
#   fputs ($fd,$str_mySpec);
#   fputs ($fd,"\n\n");
#   fclose($fd);
#  } else {
#   if ($debug) {
#     print "<p>No spec found in generating tables and theorems.\n";
#   }
#  }

 if ($cmn) {
   $fd = fopen($LogicFile,"a");
   // $str_myTable set right after reading pragma
   fputs ($fd,$str_myTable);
   fputs ($fd,"\n\n");
   fclose($fd);
   if ($show_tables && $version!='80') {
     print "<p>The table entry for the certified method is:<pre>\n" .
       $html_myTable . "</pre>\n";
   }
 } else {
   if ($debug) {
     print "<p>No certified method found in generating tables and theorems.\n";
   }
 }

#  // grab certificate from uploaded file
#  $fd = fopen($LogicFile,"a");
#  fputs ($fd, "(* ---------------------------------------------------- *)\n");
#  fputs ($fd, "(* 3. Certificate *)\n");
#  fclose ($fd);

#  // going through file, replacing UNFOLD pragmas with text
#  // ToDo: needs major cleanup!!
#  $fd = fopen($LogicFile,"a");
#  $file = file($proof_file);
#  for($i = 0;$i < count($file);$i++) {
#   $line = $file[$i];
#   $l = $line;
#   if ($lib_spec_pragma != "") { // just 1 lib pragma for now
#    //      $l = preg_replace("/\(\*# UNFOLD_LIB\s+" . $lib_spec_pragma . "|\s+#\*\)/",
#    //  		      $lib_specs[$lib_spec_pragma],
#    //                       $line);

#     // HACK: hardwired for init
#     $f = preg_match("/\(\*# UNFOLD_LIB\s+init\s+#\*\)/",$line,$match);
      
#     if ($f) { // HACK: replaces entire line on mtach
#       //      $l = $lib_specs[$lib_spec_pragma];
#       $l = $lib_specs['init'];
#     }
#   }
#   if ($line != $l) {
#     if ($debug) {
#       print "<p>REPLACED: |$line| -> |$l|<br>\n";
#       $fff = fopen($tmp_full_dir."BONZO","a") ; fputs($fff,$l); fclose($fff);
#     }
#     // fputs ($fd, $l);
#   }

#   $line = $l;

# //   if ($lib_spec_pragma != "") {
# //     $f = preg_match("/\(\*# UNFOLD_LIB\s+(\S+)\s+#\*\)/",$l,$match);
# //     if ($f) {
# //       $x = $match[1];
# //       if ($debug) {
# // 	print "<p>Found UNFOLD_LIB for |". $x . "|<br> in line |" . $l . "|<br>\n";
# //       }
# //       if ($x == $lib_spec_pragma) {
# // 	$str = $lib_specs[$x];
# // 	print "<p>spec for $x is :" . $str;
# // 	$l = preg_replace("/\(\*# UNFOLD_LIB\s+" . $x . "|\s+#\*\)/",$str,$l);
# //       }
# //     }
# //     print "<p>BONXZO 1: l=|" . $l . "|<br>\n";
# //   }

#   if ($wrapper) {
#     $l = ereg_replace("\(\*# UNFOLD mainThm #\*\)",$str_mainThm,$line);
#     $l = ereg_replace("\(\*# UNFOLD wrappedThm #\*\)",$str_wrappedThm,$l);
#   }

#   if ($line != $l) {
#     if ($debug) {
#       print "<p>REPLACED: |$line| -> |$l|<br>\n";
#       $fff = fopen($tmp_full_dir."BONZO","a") ; fputs($fff,$l); fclose($fff);
#     }
#   }
#   fputs ($fd, $l);
#  }
#  fclose($fd);

# // $fin = fopen($proof_file,"r");
# // $fd = fopen($LogicFile,"a");
# // while (!feof($fin)) {
# //   fscanf($fin,"%s\n",$line);
# //   if ($wrapper) {
# //     $l = ereg_replace("(\*# UNFOLD mainThm #\*)",$str_mainThm,$line);
# //     if ($debug && $line != $l) {
# //       print "REPLACED: |$line| -> |$l|<br>\n";
# //     }
# //   } else {
# //     $l = $line;
# //   }
# //   fputs ($fd, $l."\n");
# // }
# // fclose($fin);
# // fclose($fd);

# // if ($wrapper) {
# //   // protect meta-characters
# //   //$str = $str_mainThm;
# //   $str = addcslashes($str_mainThm, '"\\'); // \ -> \\
# //   $exec_str = "cat $proof_file | sed -e \"s/(\*# UNFOLD mainThm #\*)/$str/\" >> $LogicFile";
# // } else {
# //   $exec_str = "cat $proof_file >> $LogicFile";
# // }
# // if ($debug) {
# //   print "<p><font size=\"-2\" color=\"grey\">Now inserting certificate: |" . $exec_str . "</font></p>";
# //   $B = fopen($tmp_full_dir."/str_mainThm","w"); fputs($B,$str); fclose($B);
# // }
# // system($exec_str);

# // NB: splitting of $cmn into $cn,$mn,$params is done right after reading pragma
#  if ($cmn) {
#   switch ($version) {
#   case '70':
#     if ($found_certm && !$wrapper) {
#       $fd = fopen($LogicFile,"a");
# //       if ($debug) {
# // 	print "<p>Got this from split_cmn($cmn):<ul>\n<li> found? " . $found . "\n<li> Class: " . $cn . "\n<li> Method: " . $mn . "\n<li> Params: " . $params . "</ul>\n";
# //       }
#       fputs($fd,"(* -----------------------------------------------------------*)\n");
#       fputs($fd,"(* 4. Top level theorem *)\n");
#       fputs($fd,"\ntheorem \"mySpec \<Longrightarrow> \<rhd> InvokeStatic $cn $mn $params: MS $cn $mn $params\"\n");
#       fputs($fd,"apply (rule GC)\n");
#       fputs($fd,"apply (rule myContext_good)\n");
#       fputs($fd,"apply (simp_all, simp_all add: myContext_def InvContext_def, auto)\n");
#       fputs($fd,"done\n");
#       fclose($fd);

#       if ($verbose) {
# 	print ("<p>Proving the following resource property:<pre>\n" .
# 	       $html_mainThm . "\n</pre>\n");
#       }
#     }
#     break;

#     case '80': // DA logic

#       if ($found_certm && !$wrapper) {
# 	$fd = fopen($LogicFile,"a");
# // 	if ($debug) {
# // 	  print "<p>Got this from split_cmn($cmn):<ul>\n<li> found? " . $found . "\n<li> Class: " . $cn . "\n<li> Method: " . $mn . "\n<li> Params: " . $params . "</ul>\n";
# // 	}
# 	fputs($fd,"(* -----------------------------------------------------------*)\n");
# 	fputs($fd,"(* 4. Top level theorem *)\n");
# 	// str_mainThm is set right after searching for pragma
#         fputs($fd,$str_mainThm);
#         fputs($fd,"\n\n");
# 	fclose($fd);

# 	$html_mainThm = htmlspecialchars($str_mainThm);
# 	print ("<p>Proving the following resource property:<pre>\n" .
# 	        $html_mainThm . "</pre>\n");
#       }
#       break;

#     case '90': // DA logic

#       if ($found_certm && !$wrapper) {
# 	$fd = fopen($LogicFile,"a");
# // 	if ($debug) {
# // 	  print "<p>Got this from split_cmn($cmn):<ul>\n<li> found? " . $found . "\n<li> Class: " . $cn . "\n<li> Method: " . $mn . "\n<li> Params: " . $params . "</ul>\n";
# // 	}
# 	fputs($fd,"(* -----------------------------------------------------------*)\n");
# 	fputs($fd,"(* 4. Top level theorem *)\n");
# 	// str_mainThm is set right after searching for pragma
#         fputs($fd,$str_mainThm);
#         fputs($fd,"\n\n");
# 	fclose($fd);

# 	$html_mainThm = htmlspecialchars($str_mainThm);
# 	print ("<p>Proving the following resource property:<pre>\n" .
# 	        $html_mainThm . "</pre>\n");
#       }
#       break;

#       default:
# 	print "<p>Can't create top level theorem for logic " . $version . ": " . $LogicName[$version] . "<br>\n";
# 	break;
#   }
#  }

#  // footer
#  $footer =  <<< EOFF
#  ML_command {* writeln "Resource property proven"; *}
#  ML_command {* let val n2 = Time.now () in TextIO.print ("Elapsed time: "^(Time.toString (n2-n1))^"sec") end ; *}
#  ML_command {* let val s = TextIO.openOut("$success_file") in ( TextIO.output(s,"$success_str"); TextIO.closeOut(s) ) end *}
#  ML_command {* OS.Process.exit(OS.Process.success):unit; *}
#  end
#  EOFF;
#  $h = fopen($LogicFile,"a");
#  fputs($h,$footer);
#  fclose($h);

#  if ($verbose) {
#   print "<p><h2><font size=\"-1\">Assembled theory file</h2>\n<pre>\n";
#   include ("$LogicFile");
#   print "</pre></font></p>";
#  } else {
#   $url = path2url($LogicFile,$consumerhost,$consumerbase);
#  print <<< EOFF
# <p>
# Overall Isabelle theory has been assembled. <a href="$url">Click here</a> to examine it.&nbsp;&nbsp;&nbsp;<form action="markup.php" method="POST" target="markup">
#  <input type="hidden" name="kind" value="thy">
#  <input type="hidden" name="file" value="$LogicFile">
#  <input type="submit" value="Markup">
# </form>
# EOFF;
#  }

# } // compose_Isabelle_files

// ---------------------------------------------------------------------------

function launch_Isabelle ($version,$adt) {
 global $debug, $verbose, $tmp_full_dir; # settings
 global $isa_dir, $isa_prg, $isa_args, $HeapBase, $Heaps, $HeapDirs, $success_file; # constants
 # INPUT vars
 global $spec; # pragmas
 global $ROOTml;
 global $LogicName; # debugging only

 print <<< EOFF
<h2>Output from Isabelle</h2>
EOFF;

 # Leave Isabelle's output on STDout too.
 if (!is_executable("$isa_dir/$isa_prg")) {
  die ("Didn't find Isabelle in $isa_dir/$isa_prg<br>");
 }
 $img_version = ($adt != "") ? $version + $adt : $version;
 $heap = $Heaps[$img_version]; # ($version=="33") ? "/home/mrg/delv.img" : $isa_heap; 
 # $heap = $HeapBase . "/" . $HeapName;
 $exec_str = "cd $tmp_full_dir; $isa_dir/$isa_prg $heap < $ROOTml";
 if ($debug) {
  print "<p><font size=\"+2\" color=\"grey\">Running Isabelle, with logic version " . $version . "(" . $LogicName[$version] . "), like this:</font><br><font size=\"-2\" color=\"grey\">|" . $exec_str . "</font></p>";
 }

 # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 # call to Isabelle
 print "<p><font color=\"orange\"><pre>"; # special font for Isabelle output
 system($exec_str,$ret_code); 
 print "</pre></font></p>";
 # +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

 return $ret_code;
 # $success_file written --> successful cert check
} # launch_Isabelle

# ---------------------------------------------------------------------------

?>