<?php
// romulus setup --------------------------------------------------

// machine dependent constants
// running the demo on a different machine should only require changes
// in this file
// configure.php should be a link to the right configure-<machine>/php

// The following packages are required on the producer side:
// (those marked with + are external; those with - are part of mrg/progs)
//  + j2sdk toolkit from Sun (best: version 1.4.1)
//  - Camelotlib.class, a class file with std Camelot library functions
//  - Grail assembler and disassembler (gdf/gf)
//  + Isabelle 2003, and the appropriate image files for the theories 
//    used in the certificates (see ../heaps)
//
// (not required, but handy for hacking certificates is Proof General 3.4)

// ToDo:
//  - Specify versions for each of the required packages
//  - Give links to the right version for installation
//  - Replace hand-edited configure files with a configure script

# root dir of the web server
$srv_root = "/var/www/html";
$srv_url = "http://romulus.tcs.ifi.lmu.de";

# inlined from former paths.php
$include_prefix = $srv_root . "/mrg/pcc4/consumer";
$base_prefix = $srv_url . "/mrg/pcc4/consumer";
$cgi_prefix = $srv_url . "/cgi";

#$mrg_root = "/home/hwloidl/mrg-working";
$mrg_root = "/var/www/cgi-bin/mrg";
$progs_root = $mrg_root . "/progs-demo-y4";
$progs_HEAD_root = $mrg_root . "/progs-demo-y4";
#$progs_HEAD_root = $mrg_root . "/progs";

// Isabelle 2003 installation
$isa_dir  = "/home/hwloidl/DISTS/Isabelle/bin";
$isa_prg  = "isabelle-process";
# $isa_heap = "/home/mrg/comb.img";
$HeapBase = $srv_root . "/mrg/pcc4/consumer/heaps";

$gdf_dir = $progs_root . "/Grail/gdf/src";
//$gdf_dir = $mrg_root . "/progs/Grail/gdf/src";
$gdf_prg = "gdf";
$gdf_layout_prg = array('01' => "gdf01", '10' => "gdf10");

/*
// gdf must be the one from the demo-y2 branch!
$gdf_dir = "/home/hwloidl/mrg/progs-y2/Grail/gdf/src";
//$gdf_dir = "/var/tmp/mrg/progs/Grail/gdf/src";
//$gdf_dir = "/home/hwloidl/mrg/progs/Grail/gdf/src";
$gdf_prg = "gdf";
$gdf_layout_prg = array('01' => "gdf01", '10' => "gdf10");
// GDF_FLAVOUR: "HEAD"
$gdf_flavour_dir = array("DEFAULT" => "/home/hwloidl/mrg/progs-y2/Grail/gdf/src",
                        "HEAD" => "/home/hwloidl/mrg/progs/Grail/gdf/src");
$gdf_flavour_prg = array("DEFAULT" => "gdf", 
                        "HEAD" => "gdf");
*/

// Java installation
$java_dir = "/usr/java/j2sdk1.4.1_01/bin";
$java_lib = "/usr/java/j2sdk1.4.1_01";
$java_prg = "java";
$java_cp = $HeapBase . ":.";
//$java_cp  = "/home/hwloidl/mrg/progs-y2/Grail/gf/gf.zip:/home/hwloidl/mrg/progs-y2/Grail/gf/bcel.jar:/usr/java/j2sdk1.4.1_01:.";

$gf_dir = $progs_root . "/Grail/gf/src";
$gf_prg = "gf";
// //$gf_cmd = $java_dir . "/" . $java_prg . " -cp " . $java_cp . " " . $gf_prg; 
// // GF_FLAVOUR: "HEAD"
// $gf_flavour_dir = array("DEFAULT" => $progs_root ."/Grail/gf/src",
//                         "HEAD" => $progs_HEAD_root . "/Grail/gf/src");
// $gf_flavour_prg = array("DEFAULT" => "gf", 
//                         "HEAD" => "gf");
$gf_args = " -d ./ -t mrg -C  "; // surrounding spaces!

/*
// gf must be the one from the demo-y2 branch
$gf_dir = "/home/hwloidl/mrg/progs-y2/Grail/gf";
$gf_prg = "gf";
// GF_FLAVOUR: "HEAD"
$gf_flavour_dir = array("DEFAULT" => "/home/hwloidl/mrg/progs-y2/Grail/gf",
                        "HEAD" => "/home/hwloidl/mrg/progs/Grail/gf");
$gf_flavour_prg = array("DEFAULT" => "gf", 
                        "HEAD" => "gf");
*/

// NB: must come *after* picking gf_dir etc via pragmas; NONA
// $gf_cmd = $java_dir . "/" . $java_prg . " -cp " . $java_cp . " " . $gf_prg; 

// Camelot compiler installation
$camelot_dir = $progs_root . "/Camelot/src";
$camelot_prg = "camelot";
$camelot_flags = " -n -thy -C -lfd -lfd-opts \"-olhs 4\" -lfd-dir $lfd_infer_dir -lfd-prg $lfd_infer_prg ";  // space inference and cert gen!

$lib_dir = $HeapBase;
$lib_file = "Camelotlib.class";

$lfd_infer_dir = $progs_root . "/LFD_inference";
$lfd_infer_prg = "lfd_infer";

$lp_solve_dir = "/usr/local/bin";
$lp_solve_prg = "lp_solve";

/*
// CAMELOT_FLAVOUR: "HEAD"
$camelot_flavour_dir = array("DEFAULT" => "/home/hwloidl/mrg/progs-y2/Camelot/src",
                             "HEAD" => "/home/hwloidl/mrg/progs/Camelot/src");
$camelot_flavour_prg = array("DEFAULT" => "camelot",
                             "HEAD" => "camelot");
*/

// where to find the pre-compiled Camelot libraries
//$lib_dir = "/home/mrg/public_html/mrg/pcc/consumer";
//$lib_file = "Camelotlib.class";


?>