header {*Application: functions over trees and lists*}
(*<*)
theory mTreeList = VDMderived:
(*>*)
text {*The Camelot code
       \begin{verbatim}
         type itree = Leaf of int | Node of itree * itree
         type ilist = Nil | Cons of int * ilist
       \end{verbatim}
results in class \verb|TreeList$dia_0| where we have (amongst other tings):
\begin{verbatim}
   method static public TreeList$dia_0 alloc () =
   let val freelist = getstatic <TreeList$dia_0 TreeList$dia_0.$f>
      fun q(TreeList$dia_0 freelist) =
      let val tl = getfield freelist <TreeList$dia_0 TreeList$dia_0.$n>
          val () = putstatic <TreeList$dia_0 TreeList$dia_0.$f> tl
      in freelist
      end
   in if freelist = null[TreeList$dia_0] then new <TreeList$dia_0()> ()
      else q(freelist)
   end

   method static public void free (TreeList$dia_0 node) =
   let val freelist = getstatic <TreeList$dia_0 TreeList$dia_0.$f>
       val () = putfield node <TreeList$dia_0 TreeList$dia_0.$n> freelist
       val () = putstatic <TreeList$dia_0 TreeList$dia_0.$f> node
   in () end

   method public static TreeList$dia_0 make (int tag) =
     let val ?x = invokestatic <TreeList$dia_0 TreeList$dia_0.alloc ()> ()
     in invokestatic <TreeList$dia_0 TreeList$dia_0.fill (TreeList$dia_0, int)> (?x, tag)
     end

   method public static TreeList$dia_0 make (int tag, int v0, TreeList$dia_0 v1) =
     let val ?x = invokestatic <TreeList$dia_0 TreeList$dia_0.alloc ()> ()
     in invokestatic <TreeList$dia_0 TreeList$dia_0.fill (TreeList$dia_0, int, int, TreeList$dia_0)> (?x, tag, v0, v1)
     end

   method public static TreeList$dia_0 fill (TreeList$dia_0 ?x, int tag) =
     let val () = putfield ?x <int TreeList$dia_0.$> tag
     in ?x end

   method public static TreeList$dia_0 fill (TreeList$dia_0 ?x, int tag, int v0, TreeList$dia_0 v1) =
     let val () = putfield ?x <int TreeList$dia_0.$> tag
         val () = putfield ?x <int TreeList$dia_0.f0> v0
         val () = putfield ?x <TreeList$dia_0 TreeList$dia_0.f1> v1
     in ?x
     end
\end{verbatim}
       should result in the following definitions and lemmas.*}

syntax DIAM :: cname
       DOLLAR_F :: rfldname
       DOLLAR_N :: rfldname
       DOLLAR :: ifldname
       F0 :: ifldname
       F1 :: rfldname
       F2 :: rfldname

       Make_I    :: mname
       Make_IID  :: mname
      Fill_DI   :: mname
      (* Fill_DII   :: mname *)
      Fill_DIID :: mname
      Fill_DIDD :: mname

      Alloc :: mname
      freelist :: rname
      alloc_b :: iname
      Alloc_q :: funame
      alloc_tl :: rname

      tag_ :: iname
      x_   :: rname 
      v0_  :: iname  
      v1_  :: rname 
      v2_  :: rname 

translations
 "DIAM" == "(CN ''dia_0'') "
 "DOLLAR_F" == "(RFN ''$f'')"
 "DOLLAR_N" == "(RFN ''$n'')"
 "DOLLAR" == "(IFN ''$'')"
 "F0" == "(IFN ''f0'')"
 "F1" == "(RFN ''f1'')"
 "F2" == "(RFN ''f2'')"

 "Make_I" == "(MN ''Make_I'')"
 "Make_IID" == "(MN ''Make_IID'')"
 "Fill_DI" == "(MN ''Fill_DI'')"
 (* "Fill_DII" == "(MN ''Fill_DII'')" *)
 "Fill_DIID" == "(MN ''Fill_DIID'')"
 "Fill_DIDD" == "(MN ''Fill_DIDD'')"

 "tag_" == "(In ''tag'') "
 "x_" == "(RN ''?x'') "
 "v0_" == "(In ''v0'') "
 "v1_" == "(RN ''v1'') "
 "v2_" == "(RN ''v2'') "

 "Alloc " == "(MN ''alloc'')"
 "freelist " == "(RN ''freelist'')"
 "alloc_b " == "(In ''b'')"
 "Alloc_q " == "(FN ''q'')"
 "alloc_tl " == "(RN ''tl'')"

axioms Meth_Make_I:
"methtable DIAM Make_I = ([INpar tag_], LET rf x_ = DIAM\<bullet>Alloc([])
                                        IN DIAM\<bullet>Fill_DI ([RNarg x_, INarg tag_]) END)"

axioms Meth_Make_IID:
"methtable DIAM Make_IID = ([INpar tag_, INpar v0_, RNpar v1_],
                            LET rf x_ = DIAM\<bullet>Alloc([])
                            IN DIAM\<bullet>Fill_DIID ([RNarg x_, INarg tag_, INarg v0_, RNarg v1_]) END)"

axioms Meth_Fill_DI:
"methtable DIAM Fill_DI = ([RNpar x_, INpar tag_],
                           LET _ = PutFi x_ DOLLAR tag_
                           IN RVar x_ END)"

(*
axioms Meth_Fill_DII:
"methtable DIAM Fill_DII = ([RNpar x_, INpar tag_, INpar v0_],
                           LET _ = PutFi x_ DOLLAR tag_;
                               _ = PutFi x_ F0 v0_
                           IN RVar x_ END)"
*)

axioms Meth_Fill_DIID:
"methtable DIAM Fill_DIID = ([RNpar x_, INpar tag_, INpar v0_, RNpar v1_],
                             LET _ = PutFi x_ DOLLAR tag_;
                                 _ = PutFi x_ F0 v0_;
                                 _ = PutFr x_ F1 v1_
                             IN RVar x_ END)"

axioms Meth_Fill_DIDD:
"methtable DIAM Fill_DIDD = ([RNpar x_, INpar tag_, RNpar v1_, RNpar v2_],
                             LET _ = PutFi x_ DOLLAR tag_;
                                 _ = PutFr x_ F1 v1_;
                                 _ = PutFr x_ F2 v2_
                             IN RVar x_ END)"

axioms Meth_Alloc:
"methtable DIAM Alloc = ([], LET rf freelist = DIAM\<struct>DOLLAR_F;
                                 alloc_b = RPrimop (\<lambda> x y . if x = Nullref then 1 else 0) freelist freelist
                             IN IF alloc_b THEN NEW <DIAM> ([],[]) ELSE CALL Alloc_q END)"
(*Isabelle problem: why must we not use the pretty GetStat/PutStat syntax in the lemma 
  ''Illegal reference to implicit structure #1''??*)
lemma 
"methtable DIAM Alloc = ([], LET rf freelist = GetStat DIAM DOLLAR_F;
                                           alloc_b = RPrimop (\<lambda> x y . if x = Nullref then 1 else 0) freelist freelist
                                   IN IF alloc_b THEN NEW <DIAM> ([],[]) ELSE CALL Alloc_q END)"
by (simp add: Meth_Alloc)

axioms Fun_AllocQ:
"funtable Alloc_q = LET rf alloc_tl = freelist\<diamondsuit>DOLLAR_N;
                             _ = DIAM\<struct>DOLLAR_F := alloc_tl
                    IN RVar freelist END"
lemma "funtable Alloc_q = LET rf alloc_tl = freelist\<diamondsuit>DOLLAR_N;
                             _ = DIAM\<struct>DOLLAR_F := alloc_tl
                    IN RVar freelist END"
by (simp add: Fun_AllocQ)

subsection {*The list representation predicate*}
consts mList::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive mList intros
mListNIL:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> = 2\<rbrakk> \<Longrightarrow> (0,a,{a},h) : mList"
mListCONS:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> \<noteq> 2; h\<lfloor>a\<diamondsuit>F1\<rfloor> = Ref aa; a \<notin> X; (n,aa,X,h):mList\<rbrakk>
          \<Longrightarrow> (Suc n, a, X \<union> {a}, h): mList"

lemma mListSameOH[rule_format]:
"(n,a,X,h) \<in> mList \<Longrightarrow> (\<forall> hh. sameOH X h hh \<longrightarrow> (n,a,X,hh) \<in> mList)"
apply (erule mList.induct, safe)
apply (rule mListNIL)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply (rule mListCONS)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply simp
apply simp
apply (subgoal_tac "sameOH X h hh", simp)
apply ( simp add: sameOH_def)
done

lemma mListSame:
"\<lbrakk>(n,a,X,h) \<in> mList; same X h hh\<rbrakk> \<Longrightarrow> (n,a,X,hh) \<in> mList"
by (erule mListSameOH, simp add: same_def)

lemma mListDom: "\<lbrakk>(n, a, X, h) \<in> mList\<rbrakk> \<Longrightarrow>  X \<subseteq> Dom h"
by (erule mList.induct, simp_all add:fmap_lookup_def fmap_dom_def dom_def)

lemma mListFresh: "(L, a, X, h) \<in> mList \<Longrightarrow> freshloc (Dom h) \<notin> X"
by (subgoal_tac "X \<subseteq> Dom h", fastsimp, erule mListDom)

lemma mListSameFresh: "(n, a, X, h) \<in> mList
       \<Longrightarrow> same X h
           \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM),
            iheap = (iheap h)
                    (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := U),
                     F0 := (iheap h F0)(freshloc (Dom h) := Y)),
            rheap = (rheap h)(F1 := (rheap h F1)(freshloc (Dom h) := Z)),
            sheap = sheap h\<rparr>"
apply (erule mList.induct)
apply (simp add: same_def sameOH_def)
apply (subgoal_tac "a \<noteq> freshloc (Dom h)", clarsimp) apply (simp add: FMAPlookup1)
  apply (subgoal_tac "a : Dom h")
  apply fastsimp
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
apply (simp add: same_def sameOH_def)
apply (subgoal_tac "a \<noteq> freshloc (Dom h)", clarsimp) apply (erule_tac x=a in allE, clarsimp)
  apply (simp add: FMAPlookup1) 
  apply (subgoal_tac "a : Dom h")
  apply fastsimp
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
done

lemma mListExtend:
"\<lbrakk>(n, a, Y, h) \<in> mList; l \<notin> Dom h\<rbrakk> \<Longrightarrow>
  (Suc n, l, Y \<union> {l}, \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fDIAM), 
                       iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := 1),
                                         F0 := (iheap h F0)(l := i)),
                       rheap = (rheap h)(F1 := (rheap h F1)(l := Ref a)),
                       sheap = sheap h\<rparr>) : mList"
apply (subgoal_tac "l \<noteq> a")
apply (erule mList.elims)
apply (rule mListCONS, safe)
apply (simp add: FMAPlookup1)
apply (clarsimp) 
apply simp
apply (rule mListNIL) 
apply (simp add: FMAPlookup1) apply clarsimp
apply (subgoal_tac "X \<subseteq> Dom h") prefer 2 apply (erule mListDom)
apply (rule mListCONS, safe)
apply (simp add: FMAPlookup1)
apply (clarsimp)
apply simp
apply (fast)  
apply (rule mListCONS) 
apply (simp add: FMAPlookup1) 
apply clarsimp 
apply simp
apply simp
apply (rule mListSameOH, assumption)
apply (simp add: sameOH_def) apply clarsimp apply (simp add: FMAPlookup1)
apply fast
apply (subgoal_tac "a:Y") 
apply (insert mListDom) apply fast
apply (erule mList.elims, simp_all)
done
(* If we define the fields as consts, the previous lemma should be as follows:
lemma mListExtend:
"\<lbrakk>(n, a, Y, h) \<in> mList; l \<notin> Dom h; F0 \<noteq> DOLLAR\<rbrakk> \<Longrightarrow>
  (Suc n, l, Y \<union> {l}, \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fDIAM), 
                       iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := 1),
                                         F0 := (iheap h F0)(l := i)),
                       rheap = (rheap h)(F1 := (rheap h F1)(l := Ref a)),
                       sheap = sheap h\<rparr>) : mList"
apply (subgoal_tac "l \<noteq> a")
apply (erule mList.elims)
apply (rule mListCONS, safe)
apply (simp add: FMAPlookup1)
apply (clarsimp) 
apply simp
apply (rule mListNIL) 
apply (simp add: FMAPlookup1) apply clarsimp
apply (subgoal_tac "X \<subseteq> Dom h") prefer 2 apply (erule mListDom)
apply (rule mListCONS, safe)
apply (simp add: FMAPlookup1)
apply (clarsimp)
apply simp
apply (fast)  
apply (rule mListCONS) 
apply (simp add: FMAPlookup1) 
apply clarsimp 
apply simp
apply simp
apply (rule mListSame, assumption)
apply (simp add: same_def) apply clarsimp apply (simp add: FMAPlookup1)
apply fast
apply (subgoal_tac "a:Y") 
apply (insert mListDom) apply fast
apply (erule mList.elims, simp_all)
done
*)



lemma SameExtend1:"\<lbrakk>l \<notin> X\<rbrakk> \<Longrightarrow> same X h \<lparr>oheap = (oheap h)(l\<mapsto>\<^sub>fC),
                                         iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i1),
                                                           F0 := (iheap h F0)(l := i2)),
                                         rheap = (rheap h)(F1 := (rheap h F1)(l := r)),
                                         sheap = sheap h\<rparr>"
by (simp add: same_def sameOH_def FMAPlookup1)

lemma DomExtend1: 
"\<lbrakk>l \<notin> Dom h \<rbrakk> \<Longrightarrow>
   Dom h \<subseteq> Dom \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fC),
                iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i1), F0 := (iheap h F0)(l := i2)),
                rheap = (rheap h)(F1 := (rheap h F1)(l := r)),
                sheap = sheap h\<rparr>"
by fastsimp

lemma SameExtend2:"\<lbrakk>l \<notin> X\<rbrakk> \<Longrightarrow> same X h \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fC),
                                         iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i)),
                                         rheap = rheap h,
                                         sheap = sheap h\<rparr>"
by (simp add: same_def sameOH_def FMAPlookup1)

lemma DomExtend2: "\<lbrakk>l \<notin> Dom h \<rbrakk> \<Longrightarrow>
                   Dom h \<subseteq> Dom \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fC),
                                iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i)),
                                rheap = rheap h,
                                sheap = sheap h\<rparr>"
by fastsimp

subsection {*The tree representation predicate*}
consts mTree::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive mTree intros
mTreeLEAF:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> (0,a,{a},h) : mTree"
mTreeNODE:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> \<noteq> 0; 
            h\<lfloor>a\<diamondsuit>F1\<rfloor> = Ref a1; (n,a1,X1,h):mTree; 
            h\<lfloor>a\<diamondsuit>F2\<rfloor> = Ref a2; (n,a2,X2,h):mTree;
            X1 \<inter> X2 = {}; a \<notin> X1 \<union> X2 \<rbrakk>
          \<Longrightarrow> (Suc n, a, X1 \<union> X2 \<union> {a}, h): mTree"

lemma mTreeSameOH[rule_format]:
"(n,a,X,h) \<in> mTree \<Longrightarrow> (\<forall> hh. sameOH X h hh \<longrightarrow> (n,a,X,hh) \<in> mTree)"
apply (erule mTree.induct, safe)
apply (rule mTreeLEAF)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply (rule mTreeNODE)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply (subgoal_tac "sameOH X1 h hh", simp)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply (subgoal_tac "sameOH X2 h hh", simp)
apply ( simp add: sameOH_def)
apply simp
apply simp
done

lemma mTreeSame:
"\<lbrakk>(n,a,X,h) \<in> mTree; same X h hh\<rbrakk> \<Longrightarrow> (n,a,X,hh) \<in> mTree"
by (erule mTreeSameOH, simp add: same_def)
lemma mTreeDomAux:"(L,r,X,h) : mTree \<Longrightarrow> (\<forall> x. x \<in> X  \<longrightarrow> x \<in> Dom h)"
 apply (erule mTree.induct) 
 apply clarify
 apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
 apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
done

lemma mTreeDom: "\<lbrakk>(L, r, X, h) \<in> mTree\<rbrakk> \<Longrightarrow>  X \<subseteq> Dom h"
by (insert mTreeDomAux, auto)

lemma mTreeFresh: "(L, a, X, h) \<in> mTree \<Longrightarrow> freshloc (Dom h) \<notin> X"
by (subgoal_tac "X \<subseteq> fmap_dom (oheap h)", fastsimp, erule mTreeDom)

subsection {* My tree representation predicate -- HWL *}

consts myTree::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive myTree intros
myTreeLEAF:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> = 7\<rbrakk> \<Longrightarrow> (1,a,{a},h) : myTree"
myTreeNODE:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> \<noteq> 7; 
            h\<lfloor>a\<diamondsuit>F1\<rfloor> = Ref a1; (n,a1,X1,h):myTree; 
            h\<lfloor>a\<diamondsuit>F2\<rfloor> = Ref a2; (m,a2,X2,h):myTree;
            X1 \<inter> X2 = {}; a \<notin> X1 \<union> X2 \<rbrakk>
          \<Longrightarrow> (m+n, a, X1 \<union> X2 \<union> {a}, h): myTree"

lemma myTreeSameOH[rule_format]:
"(n,a,X,h) \<in> myTree \<Longrightarrow> (\<forall> hh. sameOH X h hh \<longrightarrow> (n,a,X,hh) \<in> myTree)"
apply (erule myTree.induct, safe)
apply (rule myTreeLEAF)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply (rule myTreeNODE)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply (subgoal_tac "sameOH X1 h hh", simp)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply (subgoal_tac "sameOH X2 h hh", simp)
apply ( simp add: sameOH_def)
apply simp
apply simp
done

lemma myTreeSame:
"\<lbrakk>(n,a,X,h) \<in> myTree; same X h hh\<rbrakk> \<Longrightarrow> (n,a,X,hh) \<in> myTree"
by (erule myTreeSameOH, simp add: same_def)
lemma myTreeDomAux:"(L,r,X,h) : myTree \<Longrightarrow> (\<forall> x. x \<in> X  \<longrightarrow> x \<in> Dom h)"
 apply (erule myTree.induct) 
 apply clarify
 apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
 apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
done

lemma myTreeDom: "\<lbrakk>(L, r, X, h) \<in> myTree\<rbrakk> \<Longrightarrow>  X \<subseteq> Dom h"
by (insert myTreeDomAux, auto)

lemma myTreeFresh: "(L, a, X, h) \<in> myTree \<Longrightarrow> freshloc (Dom h) \<notin> X"
by (subgoal_tac "X \<subseteq> fmap_dom (oheap h)", fastsimp, erule myTreeDom)

subsection {*The freelist representation predicate*}
consts FL::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive FL intros
FL_NIL: "(0, Nullref, {},h) : FL"
FL_SUC: "\<lbrakk>h@@a = Some DIAM; a \<notin> X; (n, h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>,X,h):FL\<rbrakk>
        \<Longrightarrow> (Suc n, Ref a,  X \<union> {a}, h) : FL"

lemma FL_SameOH[rule_format]:
"(n,r,X,h) \<in> FL \<Longrightarrow> (\<forall> hh. sameOH X h hh \<longrightarrow> (n,r,X,hh) \<in> FL)"
apply (erule FL.induct, safe)
apply (rule FL_NIL)
apply (rule FL_SUC)
apply (simp_all add: sameOH_def)
done

lemma FL_Same[rule_format]:
"\<lbrakk>(n,r,X,h) \<in> FL; same X h hh\<rbrakk> \<Longrightarrow> (n,r,X,hh) \<in> FL"
by (erule FL_SameOH, simp add: same_def)

lemma FL_Dom: "\<lbrakk>(n, r, X, h) \<in> FL\<rbrakk> \<Longrightarrow>  X \<subseteq> Dom h"
by (erule FL.induct, simp_all add:fmap_lookup_def fmap_dom_def dom_def)

lemma FL_Fresh: "(L, r, X, h) \<in> FL \<Longrightarrow> freshloc (Dom h) \<notin> X"
by (subgoal_tac "X \<subseteq> Dom h", fastsimp, erule FL_Dom)

lemma FL_SameOHFresh: 
"(n, r, X, h) \<in> FL
       \<Longrightarrow> sameOH X h
           \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM),
            iheap = (iheap h)
                    (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := U),
                     F0 := (iheap h F0)(freshloc (Dom h) := Y)),
            rheap = (rheap h)(F1 := (rheap h F1)(freshloc (Dom h) := Z)),
            sheap = ZZ\<rparr>"
apply (erule FL.induct)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply (subgoal_tac "a \<noteq> freshloc (Dom h)", simp add: FMAPlookup1)
  apply (subgoal_tac "a : Dom h")
  apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h", fast)
  apply (rule FreshlocDom)
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
done

lemma FL_SameFresh: 
"(n, r, X, h) \<in> FL
       \<Longrightarrow> same X h
           \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM),
            iheap = (iheap h)
                    (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := U),
                     F0 := (iheap h F0)(freshloc (Dom h) := Y)),
            rheap = (rheap h)(F1 := (rheap h F1)(freshloc (Dom h) := Z)),
            sheap = sheap h\<rparr>"
by (simp add: same_def, erule  FL_SameOHFresh)

end
