theory VCG = TreeVCG:

subsection{* Specialised proof rules for VCG tactic *}
consts SPEC::"mname \<Rightarrow> vdmassn"
consts FST :: FS_T	(* unspecified empty table *)
consts vMST :: vMS_T	(* unspecified empty table *)
constdefs sMST :: sMS_T  
"sMST == (\<lambda> C M args E h hh v p. SPEC M (newframe_env Nullref (fst (methtable C M)) args E) h hh v p)"

text {*First, an auxiliary rule needed for the invokcation rules.
       Again, I think one should be able to prove a variant without
       the condition relating E to newframe .. E* (see above comment
       for Adapt). Both in that condtion, and in the following one
       (the one on contexts), the condition x:fmap_dom f is there
       to help automation. We could delete it (and only leave the condition
       fmap_lookup, at the price of having to do case_tacs in the proof - see
       the comment in the proof of lemma Extract_DAss)*}
lemma InvokeRename:
  "\<lbrakk>G \<rhd> (c\<bullet>M(L)): sMST c M L; 
        SPEC M = \<lbrace>UU, n, C  \<ggreater> T, m\<rbrace>;
        distinct (fst (methtable c M)); distinct L;
        (L, fst (methtable c M), f) \<in> REN;
        U = set (ArgList2RnameList L); U \<subseteq> DOM D;
        UU = set (ParList2RnameList (fst (methtable c M))); UU \<subseteq> DOM C;
     \<forall> E x . x:fmap_dom f \<longrightarrow> (\<forall> y . (fmap_lookup f x = Some y) \<longrightarrow> E\<lfloor>x\<rfloor> = (newframe_env Nullref (fst (methtable c M)) L E)\<lfloor>y\<rfloor>);
     \<forall> x . x:fmap_dom f \<longrightarrow> (\<forall> y . ((fmap_lookup f x = Some y) \<longrightarrow> (GETr D x = GETr C y)))\<rbrakk>
      \<Longrightarrow> G \<rhd> (c\<bullet>M(L)):\<lbrace> U, n , D  \<ggreater> T , m \<rbrace>"
apply (erule vdm_conseq)
apply (simp add: sMST_def)
apply clarsimp
apply (erule AdaptRename)
apply assumption+
apply simp+
apply clarsimp
 apply (erule_tac x=E in allE, rotate_tac -1, erule_tac x=x in allE, erule impE)
 apply (simp add: fmap_dom_def fmap_lookup_def dom_def)
 apply fast
apply clarsimp
 apply (erule_tac x=x in allE, erule impE)
 apply (simp add: fmap_dom_def fmap_lookup_def dom_def)
 apply fast
done

subsubsection {* Leaf cases, no side-conditions: *}

lemma vcg_int: "G \<rhd>  expr.Int i : \<lbrace> {} , n , C \<ggreater>  IntET , n \<rbrace>" 
by (rule DA_Int, simp)

lemma vcg_ivar: "G \<rhd>  IVar x : \<lbrace> {} , n , C \<ggreater>  IntET , n \<rbrace> "
by (rule DA_IVar, simp)

lemma vcg_rvar: "GETr C x = Some T \<Longrightarrow> G \<rhd>  RVar x : \<lbrace> {x} , n , C \<ggreater>  T , n \<rbrace>" 
by (rule DA_RVar)

lemma vcg_prim: "G \<rhd>  Primop f x y : \<lbrace> {} , n , C \<ggreater>  IntET , n \<rbrace>" 
by (rule DA_Prim, simp)

subsubsection {* Leaf cases, two simplifiable side-conditions: *}

lemma vcg_rprim: "\<lbrakk> GETr C x = Some T; GETr C y = Some TT\<rbrakk>
                 \<Longrightarrow> G \<rhd>  RPrimop f x y : \<lbrace> {x, y} , n , C \<ggreater> IntET , n \<rbrace>" 
by (rule DA_Rprim, (erule GETrSome_DOM)+, simp)

lemmas vcg_makelist = DA_MakeList

lemmas vcg_makeresult = DA_MakeResultSome1

subsubsection {* Leaf cases, four simplifiable side-conditions: *}

lemmas vcg_maketree = DA_MakeTree

subsubsection {* Non-leaf cases for call *}
lemma vcg_call: 
  "\<not> isMergePoint f \<and> (dominates f, G, f, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>) \<in> DOM_Call \<or>
  isMergePoint f \<and> U = set (ParList2RnameList (fst (funtable f))) \<and>
	(CALL f, \<lbrace>U, n , restr C (ParList2RnameList (fst (funtable f))) \<ggreater> T , m \<rbrace>) \<in> G \<Longrightarrow>
         G \<rhd>  (CALL f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
by (auto intro: DA_Call3_MP)
 
subsubsection {* Non-leaf cases for let *}

lemmas vcg_letr = DA_Letr

lemma vcg_letprim:"G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace> \<Longrightarrow> 
		   G \<rhd> (LET z =Primop f x y IN e END) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>" by 
(rule DA_Let_Prim)

lemma vcg_letrprim:  
 "\<lbrakk>GETr C x = Some T1; GETr C y = Some T2; G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk>
  \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END) : \<lbrace>{x, y} \<union> U, n, C \<ggreater> T, m\<rbrace>" 
by (erule DA_Let_RPrim, (erule GETrSome_DOM)+)

"\<lbrakk>T1 \<notin> {IntET, UnitET};
lemma vcg_letnull: 
  G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fT1) \<ggreater> T2, k\<rbrace>; 
  G \<rhd> Null : \<lbrace>{}, n, C \<ggreater> T1, m\<rbrace> \<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = Null IN e END): \<lbrace>U-{x}, n, C \<ggreater> T2, k\<rbrace>" 
by (erule DA_Let_Null)

(*lemmas DA_Nullrules = DA_NullList DA_NullTree DA_NullResult *)

subsubsection {* Non-leaf cases for let -- matches *}

lemma vcg_NodeMatchD:
"\<lbrakk>t \<notin> U \<union> {left, right};
  GETr C t = Some (TreeET kL kN); nk = n + kN + 1; left \<noteq> right;
  G \<rhd> e : \<lbrace>U, nk, C(left\<mapsto>\<^sub>fTreeET kL kN)(right\<mapsto>\<^sub>fTreeET kL kN) \<ggreater> T, m\<rbrace> \<rbrakk>
\<Longrightarrow> G \<rhd>  (LET cont =t\<bullet>V0; rf left =t\<diamondsuit>R1; rf right =t\<diamondsuit>R2;  _ =DIAM\<bullet>Free([RNarg t]) 
          IN e END) : \<lbrace>U - {left, right} \<union> {t}, n, C \<ggreater> T, m\<rbrace>"
by (rule DA_NodeMatchD)

lemma vcg_ResultMatchD: 
"\<lbrakk>l \<notin> U;
  GETr C l = Some (ResultET kN TT kS); nk = n+kS+1; l \<noteq> t; 
  G \<rhd> e : \<lbrace>U, nk, C(t\<mapsto>\<^sub>fTT) \<ggreater> T, m\<rbrace> \<rbrakk> 
 \<Longrightarrow> G \<rhd> (LET h = GetFi l V0; rf t = GetFr l R1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END) : 
	  \<lbrace>(U-{t}) \<union> {l}, n, C \<ggreater> T, m\<rbrace>" 
by(rule DA_ResultMatchD)

lemma vcg_ListMatchD: 
"\<lbrakk>l \<notin> U;
  GETr C l = Some (ListET kN kC); nk = n+kC+1; l \<noteq> t; 
  G \<rhd> e : \<lbrace>U, nk, C(t\<mapsto>\<^sub>f(ListET kN kC)) \<ggreater> T, m\<rbrace> \<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l V0; rf t = GetFr l R1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END) : 
	 \<lbrace>(U-{t}) \<union> {l}, n, C \<ggreater> T, m\<rbrace>" 
by (rule DA_ListMatchD)

lemma vcg_letrinvokeconst: 
  "\<lbrakk>U \<inter> (V-{x})={};
    (c\<bullet>M(L), sMST c M L): G;
     \<forall> E h hh v p. sMST c M L E h hh v p \<longrightarrow> \<lbrace>U, n, C \<ggreater> T1, m\<rbrace> E h hh v p;
     \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x; nk = n+k;
     mk = m+ k; T1 \<notin> {IntET, UnitET};
     G \<rhd> e : \<lbrace>V, mk, D(x\<mapsto>\<^sub>fT1) \<ggreater> T, l\<rbrace> \<rbrakk>
   \<Longrightarrow> G \<rhd>  (LET rf x = c\<bullet>M(L) IN e END) : \<lbrace>U \<union> (V-{x}), nk, D \<ggreater> T, l\<rbrace>" 
by (erule DA_Letr_InvokeConst, simp+)

lemma vcg_leti_invokeconst: 
  "\<lbrakk>U \<inter> V ={};
    (c\<bullet>M(L), sMST c M L): G;
     \<forall> E h hh v p. sMST c M L E h hh v p \<longrightarrow> \<lbrace>U, n, C \<ggreater> IntET, m\<rbrace> E h hh v p;
     \<forall> y. y:U \<longrightarrow> GETr D y = GETr C y; nk = n+k;
     mk = m+ k; 
     G \<rhd> e : \<lbrace>V, mk, D \<ggreater> T, l\<rbrace> \<rbrakk>
   \<Longrightarrow> G \<rhd>  (LET x = c\<bullet>M(L) IN e END) : \<lbrace>U \<union> V, nk, D \<ggreater> T, l\<rbrace>" 
by (erule DA_Leti_InvokeConst, simp+)

lemma vcg_letrmakelist:
"\<lbrakk>GETr C y = Some (ListET kN kC); 
  G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fListET kN kC) \<ggreater> T, l\<rbrace>; n=(Suc m + kC); y \<notin> U-{x}\<rbrakk> \<Longrightarrow>
 G \<rhd> (LET rf x = DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg z, RNarg y])  IN e END) : \<lbrace>({y} \<union> (U-{x})), n, C \<ggreater> T, l\<rbrace>" 
by (erule DA_LetrMakeList, simp+)

(*Variation of make list with inequalities -- useful for programs with memory leaks*)
lemma vcg_letrmakelist_ml:
"\<lbrakk>GETr C y = Some (ListET kN kC); 
  G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fListET kNN kCC) \<ggreater> T, l\<rbrace>;
  n=(Suc m + kCC);kNN \<le>kN; kCC\<le>kC;y \<notin> U-{x}\<rbrakk> \<Longrightarrow>
 G \<rhd> (LET rf x = DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg z, RNarg y])  IN e END) : \<lbrace>({y} \<union> (U-{x})), n, C \<ggreater> T, l\<rbrace>" 
by (erule DA_LetrMakeList_ml, simp+)

lemma vcg_letrmakeresult: 
"\<lbrakk>GETr C y = Some (TreeET kL kN); n=(Suc m + kS);
        G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fResultET kN (TreeET kL kN) kS) \<ggreater> T, l\<rbrace>; y \<notin> U-{x}\<rbrakk> \<Longrightarrow>
  G \<rhd> (LET rf x = DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg z, RNarg y]) IN e END) : \<lbrace>{y} \<union> (U-{x}), n, C \<ggreater> T , l\<rbrace>"
by(erule DA_LetrMakeResultSome1, simp+)

lemma vcg_letrmaketree:
     "\<lbrakk>GETr C y = Some (TreeET kL kN);GETr C z = Some (TreeET kL kN); y\<noteq>z; n=(Suc m + kN);
        G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fTreeET kL kN) \<ggreater> T, l\<rbrace>;
        {y,z} \<inter> (U-{x}) = {}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg v, RNarg y, RNarg z]) IN e END): \<lbrace>({y,z} \<union> (U-{x})), n, C \<ggreater> T, l\<rbrace>"
by (erule DA_LetrMakeTree, simp+)

lemma vcg_invokeconstRename: 
  "\<lbrakk>(c\<bullet>M(L), sMST c M L): G;
     SPEC M = \<lbrace>UU, n, C  \<ggreater> T, m\<rbrace>;
     distinct (fst (methtable c M));
     UU = set (ParList2RnameList (fst (methtable c M))); UU \<subseteq> DOM C;
     U = set (ArgList2RnameList L); U \<subseteq> DOM D;
     distinct L;
     nk = n+k; mk = m+k;
     (L, fst (methtable c M),f):REN;
     \<forall> E x. x : fmap_dom f \<longrightarrow> (\<forall> y . (fmap_lookup f x = Some y) \<longrightarrow> E\<lfloor>x\<rfloor> = (newframe_env Nullref (fst (methtable c M)) L E)\<lfloor>y\<rfloor>);
     \<forall> x . x : fmap_dom f \<longrightarrow> (\<forall> y . ((fmap_lookup f x = Some y) \<longrightarrow> (GETr D x = GETr C y)))\<rbrakk>
  \<Longrightarrow> G \<rhd>  (c\<bullet>M(L)) : \<lbrace>U, nk, D \<ggreater> T, mk\<rbrace>"
by (rule DA_Const, rule InvokeRename, erule vdm_ax, assumption+)

lemma vcg_letrinvokeconstRename: 
  "\<lbrakk>U \<inter> (V-{x})={};
    (c\<bullet>M(L), sMST c M L): G;
     SPEC M = \<lbrace>UU, n, C  \<ggreater> T1, m\<rbrace>;
     distinct (fst (methtable c M)); distinct L;
     U = set (ArgList2RnameList L); U \<subseteq> DOM D;
     UU = set (ParList2RnameList (fst (methtable c M))); UU \<subseteq> DOM C;
     nk = n+k; mk = m+ k; T1 \<notin> {IntET, UnitET};
     (L, fst (methtable c M),f):REN;
     \<forall> E x. x : fmap_dom f \<longrightarrow> (\<forall> y . (fmap_lookup f x = Some y) \<longrightarrow> E\<lfloor>x\<rfloor> = (newframe_env Nullref (fst (methtable c M)) L E)\<lfloor>y\<rfloor>);
     \<forall> x . x : fmap_dom f \<longrightarrow> (\<forall> y . ((fmap_lookup f x = Some y) \<longrightarrow> (GETr D x = GETr C y)));
     G \<rhd> e : \<lbrace>V, mk, D(x\<mapsto>\<^sub>fT1) \<ggreater> T, l\<rbrace> \<rbrakk>
   \<Longrightarrow> G \<rhd>  (LET rf x = c\<bullet>M(L) IN e END) : \<lbrace>U \<union> (V-{x}), nk, D \<ggreater> T, l\<rbrace>"
by (rule DA_Letr, erule vcg_invokeconstRename, assumption+)

lemma vcg_letiinvokeconstRename: 
  "\<lbrakk>U \<inter> V={};
    (c\<bullet>M(L), sMST c M L): G;
     SPEC M = \<lbrace>UU, n, C  \<ggreater> IntET, m\<rbrace>;
     distinct (fst (methtable c M)); distinct L;
     U = set (ArgList2RnameList L); U \<subseteq> DOM D;
     UU = set (ParList2RnameList (fst (methtable c M))); UU \<subseteq> DOM C;
     nk = n+k; mk = m+ k; 
     (L, fst (methtable c M),f):REN;
     \<forall> E z. z : fmap_dom f \<longrightarrow> (\<forall> y . (fmap_lookup f z = Some y) \<longrightarrow> E\<lfloor>z\<rfloor> = (newframe_env Nullref (fst (methtable c M)) L E)\<lfloor>y\<rfloor>);
     \<forall> z . z : fmap_dom f \<longrightarrow> (\<forall> y . ((fmap_lookup f z = Some y) \<longrightarrow> (GETr D z = GETr C y)));
     G \<rhd> e : \<lbrace>V, mk, D \<ggreater> T, l\<rbrace> \<rbrakk>
   \<Longrightarrow> G \<rhd>  (LET x = c\<bullet>M(L) IN e END) : \<lbrace>U \<union> V, nk, D \<ggreater> T, l\<rbrace>"
by (rule DA_Leti, erule vcg_invokeconstRename, assumption+, simp)

subsubsection {* DOM_Call *}

lemma vcg_domcallnil:"\<lbrakk>finite G; G \<rhd> snd(funtable f):P\<rbrakk> \<Longrightarrow> 
			([],G,f,P) : DOM_Call" 
by (erule DOM_CallNIL, assumption)

lemma vcg_domcallcons: "\<lbrakk>(t,{(Call h, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)} \<union> G,f,P):DOM_Call;
			  G \<rhd> snd(funtable h): \<lbrace>U, n, C \<ggreater> T, m\<rbrace> \<rbrakk>
                      \<Longrightarrow> ( h # t, G, f, P):DOM_Call" 
by (rule DOM_CallCONS)

ML_setup {*
  val basicsimpset_tac = simp_tac HOL_basic_ss
  fun simpset_tac_thms t = simp_tac (HOL_basic_ss addsimps [fst_conv,snd_conv]@t)

  fun funsimp_tac_thms t = simp_tac (HOL_basic_ss addsimps (snd_conv :: t))

  fun localsimp_tac ctxt = simp_tac (Simplifier.get_local_simpset ctxt)
  fun localsimp_tac_thms ctxt thms = 
     simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)
  fun asm_localsimp_tac ctxt = asm_simp_tac (Simplifier.get_local_simpset ctxt)
  fun asm_localsimp_tac_thms ctxt thms = 
     asm_simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)

  fun repeat 0 tac = all_tac
    | repeat n tac = tac THEN (repeat (n-1) tac)


  (* Bind Isar ids to ML ids *)
  val vcg_weak = thm "DA_Weak"

  val vcg_int = thm "vcg_int"
  val vcg_ivar = thm "vcg_ivar"
  val vcg_rvar = thm "vcg_rvar"
  val vcg_prim = thm "vcg_prim"
  val vcg_rprim = thm "vcg_rprim"
  val vcg_if = thm "DA_If"
  val vcg_letint = thm "DA_Let_Int"
  val vcg_letprim = thm "vcg_letprim"
  val vcg_letrprim = thm "vcg_letrprim"
  val vcg_letnull = thm "vcg_letnull"
  val vcg_call = thm "vcg_call"

  val vcg_nullresult = thm "DA_NullRes"
  val vcg_nulltree = thm "DA_NullTree"
  val vcg_nulllist = thm "DA_NullList"
  val vcg_listmatchd = thm "vcg_ListMatchD"
  val vcg_nodematchd = thm "vcg_NodeMatchD"
  val vcg_resultmatchd = thm "vcg_ResultMatchD"
  
  val vcg_listmatch = thm "DA_ListMatch"
  val vcg_resultmatch = thm "DA_ResultMatch"
  val vcg_nodematch = thm "DA_NodeMatch"

  val vcg_domcallcons = thm "vcg_domcallcons"
  val vcg_domcallnil = thm "vcg_domcallnil"

  val vcg_makelist = thm "vcg_makelist"
  val vcg_makelist_ml = thm "DA_MakeList_ml"
  val vcg_letrmakelist = thm "vcg_letrmakelist"
  val vcg_letrmakelist_ml = thm "vcg_letrmakelist_ml"

  val vcg_makeresult = thm "vcg_makeresult"
  val vcg_letrmakeresult = thm "vcg_letrmakeresult"
  val vcg_maketree = thm "vcg_maketree"
  val vcg_letrmaketree = thm "vcg_letrmaketree"

  val vcg_letrinvokeconst = thm "vcg_letrinvokeconst"
  val vcg_letrinvokeconstRename = thm "vcg_letrinvokeconstRename"

  val vcg_letiinvokeconstRename = thm "vcg_letiinvokeconstRename"

  val vcg_ren_in = thm "REN_IN"
  val vcg_ren_rn = thm "REN_RN"
  val vcg_ren_nil = thm "REN_NIL"

  val vcg_invokeconst = thm "DA_InvokeConst"
  val vcg_invokeconstRename = thm "vcg_invokeconstRename"

  (* Define tactics *)

  fun adapt_tac ctxt i = FIRST []

   (* apply (fast intro: REN.intros) i.e. (apply (rule REN_IN | rule REN_RN | rule REN_NIL)+*)
  fun REN_tac i state = state |> 
    FIRST [EVERY [rtac vcg_ren_in i, REN_tac i],
           EVERY [rtac vcg_ren_rn i, REN_tac i],
           rtac vcg_ren_nil i]

(*  fun invr_tac ctxt (dmp_defs,meth_defs,fun_defs,ctxt_defs) i =
          EVERY [rtac vcg_invokeconst i,
                 localsimp_tac_thms ctxt ctxt_defs i,
                 clarify_tac HOL_cs i,
                 adapt_tac ctxt i,
                 repeat 3 (localsimp_tac ctxt i)]
*)
    fun inv_Rename_tac ctxt (dmp_defs,meth_defs,fun_defs,ctxt_defs) i =
          EVERY [rtac vcg_invokeconstRename i,

                 (*simpset_tac_thms ctxt_defs i, member i,*)
                 localsimp_tac_thms ctxt ctxt_defs i,

                 repeat 3 (localsimp_tac_thms ctxt meth_defs i),
                 repeat 6 (localsimp_tac ctxt i),
                 simpset_tac_thms meth_defs i, REN_tac i,
                 localsimp_tac_thms ctxt ([thm "newframe_env_def", thm "evalARGS_def"] @ meth_defs) i,
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                         localsimp_tac ctxt i]]

  fun leaf_tac ctxt thms i = 
  FIRST
   [resolve_tac [vcg_int, vcg_ivar, vcg_prim] i,
    EVERY [rtac vcg_rvar i, localsimp_tac ctxt i],
    resolve_tac [vcg_prim] i,
    EVERY [resolve_tac [vcg_rprim] i,
	   repeat 2 (localsimp_tac ctxt i)],
    EVERY [resolve_tac [vcg_makelist] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
           localsimp_tac ctxt i],
    EVERY [resolve_tac [vcg_makelist_ml] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
	   repeat 3 (localsimp_tac ctxt i)],
    EVERY [resolve_tac [vcg_makeresult] i,
	   repeat 2 (localsimp_tac ctxt i)],
    EVERY [resolve_tac [vcg_maketree] i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
	   repeat 2 (localsimp_tac ctxt i)],
    inv_Rename_tac ctxt thms i]

  fun if_tac ctxt rec_tacTHEN rec_tacELSE i =
   EVERY [rtac vcg_if i,
	  rec_tacELSE ctxt (i+1),
          rec_tacTHEN ctxt i]

  fun null_tac ctxt i =
   EVERY [TRY (localsimp_tac ctxt i),
          ((rtac vcg_nullresult i) THEN (localsimp_tac ctxt i))
          ORELSE ((rtac vcg_nulltree i) THEN (localsimp_tac ctxt i))
          ORELSE ((rtac vcg_nulllist i) THEN (localsimp_tac ctxt i))]

  fun res_matchd_tac ctxt rec_tac i state = state |> 
          EVERY
           [rtac vcg_resultmatchd i,
            localsimp_tac ctxt (i+1),
	    rtac conjI (i+1),
            localsimp_tac ctxt (i+1),
	    rtac conjI (i+1),
            localsimp_tac ctxt (i+1),
	    repeat 3 (localsimp_tac ctxt (i+1)),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun node_matchd_tac ctxt rec_tac i state = state |> 
          EVERY
           [rtac vcg_nodematchd i,
            FIRST [ EVERY [localsimp_tac ctxt (i+1),
                           rtac conjI (i+1),
                           repeat 2 (localsimp_tac ctxt (i+1))],
                   localsimp_tac ctxt (i+1)],
	    repeat 2 (localsimp_tac ctxt (i+1)),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun node_match_tac ctxt rec_tac i state = state |> 
          EVERY
           [rtac vcg_nodematch i,
            FIRST [ EVERY [localsimp_tac ctxt i,
                           rtac conjI i,
                           repeat 2 (localsimp_tac ctxt i)],
                   localsimp_tac ctxt i],
            localsimp_tac ctxt i,
            rec_tac ctxt i,
            repeat 3 (localsimp_tac ctxt i)]

  fun cons_matchd_tac ctxt rec_tac i state = state |> 
    EVERY [rtac vcg_listmatchd i,
           localsimp_tac ctxt (i+1),
             rtac conjI (i+1),
             repeat 2 (localsimp_tac ctxt (i+1)),
           localsimp_tac ctxt (i+1),
	   (CHANGED (localsimp_tac ctxt (i+1))),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun cons_match_tac ctxt rec_tac i state = state |> 
    EVERY [rtac vcg_listmatch i,
           FIRST [ EVERY [localsimp_tac ctxt i,
                          rtac conjI i,
                          repeat 2 (localsimp_tac ctxt i)],
                  localsimp_tac ctxt i],
	   localsimp_tac ctxt i,
           rec_tac ctxt i,
           localsimp_tac ctxt i]

  fun match_tac ctxt rec_tac i =
   FIRST [cons_matchd_tac ctxt rec_tac i,
          node_matchd_tac ctxt rec_tac i,
          res_matchd_tac ctxt rec_tac i,
          cons_match_tac ctxt rec_tac i,
          node_match_tac ctxt rec_tac i]

  fun let_cons ctxt rec_tac i =
          EVERY [rtac vcg_letrmakelist i,
                 localsimp_tac ctxt i,
	         rtac conjI i,
                 repeat 2 (localsimp_tac ctxt i),
	         rec_tac ctxt i,
	         CHANGED (localsimp_tac ctxt i),
	         CHANGED (localsimp_tac ctxt i)]

  fun let_cons_ML ctxt rec_tac i =
          EVERY [rtac vcg_letrmakelist_ml i,
                 localsimp_tac ctxt i,
	         rtac conjI i,
                 repeat 2 (localsimp_tac ctxt i),
	         rec_tac ctxt i,
	         repeat 4 (localsimp_tac ctxt i)]

  fun letrmakelist_tac ctxt thms rec_tac i =
   FIRST[ let_cons ctxt rec_tac i,
	  let_cons_ML ctxt rec_tac i]

  (* works for: Letint, Letprim, LetRPrim, LetNull *)
  fun let_tac ctxt thms rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
		 rec_tac ctxt i],
          EVERY [rtac vcg_letprim i,
		 rec_tac ctxt i],
          EVERY [resolve_tac [vcg_letrprim] i,
	         localsimp_tac ctxt i,
	         localsimp_tac ctxt i,
	         rec_tac ctxt i],
	  EVERY [rtac vcg_letnull i,
	         rec_tac ctxt (i+1),
                 null_tac ctxt (i+1),
		 localsimp_tac ctxt i],
          letrmakelist_tac ctxt thms rec_tac i,
	  EVERY [rtac vcg_letrmakeresult i,
	         repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i],
	  EVERY [rtac vcg_letrmaketree i,
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
                 FIRST [ EVERY [localsimp_tac ctxt i,
                                rtac conjI i,
                                repeat 2 (localsimp_tac ctxt i)],
                        localsimp_tac ctxt i],
	         repeat 2 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]

   fun letinv_tac ctxt (dmp_defs,prog_defs,fun_defs,ctxt_defs) rec_tac i =
          EVERY [rtac vcg_letrinvokeconst i,
                 localsimp_tac_thms ctxt ctxt_defs (i+1),
                 clarify_tac HOL_cs (i+1),
                 adapt_tac ctxt (i+1),
                 repeat 4 (localsimp_tac ctxt (i+1)),
                 rec_tac ctxt (i+1),
                 localsimp_tac ctxt i]


   fun letrinvRename_tac ctxt (dmp_defs,meth_defs,fun_defs,ctxt_defs) rec_tac i =
          EVERY [rtac vcg_letrinvokeconstRename i,
                 localsimp_tac_thms ctxt ctxt_defs (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1), REN_tac (i+1),
                 localsimp_tac_thms ctxt ([thm "newframe_env_def", thm "evalARGS_def"] @ meth_defs) (i+1),
                 FIRST [ EVERY [localsimp_tac ctxt (i+1),
                                rtac conjI (i+1),
                                repeat 2 (localsimp_tac ctxt (i+1))],
                         localsimp_tac ctxt (i+1)],
                 rec_tac ctxt (i+1),
                 localsimp_tac ctxt i]
   fun letiinvRename_tac ctxt (dmp_defs,meth_defs,fun_defs,ctxt_defs) rec_tac i =
          EVERY [rtac vcg_letiinvokeconstRename i,
                 localsimp_tac_thms ctxt ctxt_defs (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt meth_defs (i+1), REN_tac (i+1),
                 localsimp_tac_thms ctxt ([thm "newframe_env_def", thm "evalARGS_def"] @ meth_defs) (i+1),
                 FIRST [ EVERY [localsimp_tac ctxt (i+1),
                                rtac conjI (i+1),
                                repeat 2 (localsimp_tac ctxt (i+1))],
                         localsimp_tac ctxt (i+1)],
                 rec_tac ctxt (i+1),
                 localsimp_tac ctxt i]

  fun call_tac ctxt thms tac i =
   EVERY [rtac vcg_call i, 
	  localsimp_tac_thms ctxt thms i,
          tac i]

     (* here: solve a subgoal of the same form, then simplify with MFS_defs to expand method body
        in other subgoals (for each of the dominators?)
	We want to do this to maintain invariant for VCG.
        asm_localsimp_tac_thms ctxt thms 2
     *)
  (* rec_tac : ctxt \<rightarrow> thms \<rightarrow> int \<rightarrow> tactic \<rightarrow> tactic \<rightarrow> int \<rightarrow> tactic*)
  fun dom_tac ctxt thms rec_tac tac2 i =
    let fun domcall n state = state |> 
       ((((rtac vcg_domcallcons i) THEN domcall (n+1))
	 ORELSE
	 (EVERY 
	  ([(rtac vcg_domcallnil i),
	    asm_localsimp_tac ctxt i,
	   (* asm_localsimp_tac_thms ctxt thms i,*)
	    funsimp_tac_thms thms i,
	    rec_tac ctxt i] @
	   (map (tac2 ctxt) (rev (i upto (i+n-1)))))))
	 ORELSE
	 (* solve for a merge point by projecting on the context, 
	    solving a set-equality subgoal *)
	 (EVERY
	  [rtac conjI i,  (* leaves subgoal of form ?U = X *)
           localsimp_tac_thms ctxt thms i,
	   rtac disjI1 i,
	   localsimp_tac_thms ctxt thms i]))
      in domcall 0 end

  fun stop ctxt i = all_tac
  fun stop_thms thms ctxt i = all_tac

  fun fst_tac i = fast_tac (claset()) i

  fun weak_tac ctxt thms tac i = 
    EVERY
      [localsimp_tac_thms ctxt thms i,  (* expand SPEC, methtable *)
       rtac vcg_weak i,
       tac ctxt i]
  
  fun w_tac thms tac ctxt i = 
    EVERY
      [localsimp_tac_thms ctxt thms i,  (* expand SPEC, methtable *)
       rtac vcg_weak i,
       tac ctxt i,
       fst_tac i]

   fun l_tac (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac thms) (l_tac thms) i,
           let_tac ctxt thms (l_tac thms) i,
           call_tac ctxt dmp_defs (l_tac thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac thms) (w_tac fun_defs (l_tac thms)) i,
           match_tac ctxt (l_tac thms) i,
           letinv_tac ctxt thms (l_tac thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac2 (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt stop stop i,
           let_tac ctxt thms (l_tac2 thms) i,
           call_tac ctxt dmp_defs (l_tac2 thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac2 thms) stop i,
           match_tac ctxt stop i,
           letrinvRename_tac ctxt thms (l_tac2 thms) i,
           letiinvRename_tac ctxt thms (l_tac2 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac3 (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac3 thms) (l_tac3 thms) i,
           let_tac ctxt thms (l_tac3 thms) i,
           call_tac ctxt dmp_defs (l_tac3 thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac3 thms) stop i,
           res_matchd_tac ctxt (l_tac3 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac4 (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt stop (l_tac4 thms) i,
           let_tac ctxt thms (l_tac4 thms) i,
           call_tac ctxt dmp_defs (l_tac4 thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac4 thms) stop i,
           match_tac ctxt (l_tac4 thms) i,
           letinv_tac ctxt thms (l_tac4 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac5 (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac5 thms) (l_tac5 thms) i,
           let_tac ctxt thms (l_tac5 thms) i,
           call_tac ctxt dmp_defs (l_tac5 thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac5 thms) (w_tac fun_defs (l_tac5 thms)) i,
           match_tac ctxt (l_tac5 thms) i,
           letinv_tac ctxt thms (l_tac5 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac6 (thms as (dmp_defs,meth_defs,fun_defs,ctxt_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac6 thms) (l_tac6 thms) i,
           let_tac ctxt thms (l_tac6 thms) i,
           call_tac ctxt dmp_defs (l_tac6 thms ctxt) i,
           dom_tac ctxt fun_defs (l_tac6 thms) (w_tac fun_defs (l_tac6 thms)) i,
           match_tac ctxt (l_tac6 thms) i,
           letrinvRename_tac ctxt thms (l_tac6 thms) i,
           letiinvRename_tac ctxt thms (l_tac6 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]
*}

end

