(*<*)
theory UA_aux =  NILList:
(*>*)

(* The lemma below should be somewhere before !!!*)

lemma same_heaps: "h=hh \<Longrightarrow> \<forall> l. sameOH {l} h hh"
apply (simp add: sameOH_def)
done


subsection {* Definition of derived assertions*}

subsubsection {* Types, contexts, regions, size of contexts*}



datatype Type = UnitET | IntET | ListET nat


(*>*)
text {*Region calculation*}
consts reg_ua :: "(val \<times> heap \<times> (Type option) \<times> bool \<times> (locn set)) set"
inductive reg_ua intros
regInt_ua:   "(IVal i, h,Some IntET, p, {}): reg_ua"
regUnit_ua:   "(v,h,Some UnitET, p, {}): reg_ua"
regListNull_ua:  "(RVal Nullref, h, Some(ListET k), p, {}) : reg_ua"
regListCons_ua: "\<lbrakk>h@@a = Some DIAM;
                h<a\<bullet>DOLLAR> \<noteq> 2;
                a \<notin> R\<union>R' ; 
                (IVal h<a\<bullet>F0>, h, Some IntET, p, R') : reg_ua;
                (RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), p, R) : reg_ua;
                p \<longrightarrow> R\<inter>R'={}\<rbrakk> \<Longrightarrow> 
                (RVal (Ref a), h, Some(ListET k), p, {a}\<union>R'\<union>R): reg_ua"

lemma regIval: "(v, h,Some IntET, p, {}): reg_ua \<Longrightarrow>
\<exists> i. v=IVal i"
apply (erule reg_ua.cases)
apply simp+
done

lemma regIval_general: "(v, h,Some IntET, p, {}): reg_ua \<Longrightarrow>
\<exists> i. (IVal i, h,Some IntET, p, {}) : reg_ua"
apply (frule regIval)
apply (erule exE)
apply fast
done

lemma regIval_complex: "(v, h,Some IntET, p, {}): reg_ua \<Longrightarrow>
\<exists> i. v=IVal i \<and> (IVal i, h,Some IntET, p, {}) : reg_ua"
apply (erule reg_ua.cases)
apply simp apply (rule regInt_ua)
apply simp+
done

lemma region_ua_in_heap: "(v, h, T, p, R): reg_ua \<Longrightarrow> R \<subseteq> Dom h"
apply (erule reg_ua.induct)
apply simp+
apply (simp add: fmap_lookup_def fmap_dom_def)
apply best
done


lemma reg_ua_Preserved [rule_format]:
"(v,h,T, p, R):reg_ua \<Longrightarrow> 
  ((\<forall> l. l : R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (v,h1,T, p, R):reg_ua)"
apply (erule reg_ua.induct)
apply (rule impI) apply (rule regInt_ua) 
apply (rule impI) apply (rule regUnit_ua) 
apply (rule impI) apply (rule regListNull_ua)
apply (rule impI) apply (rule regListCons_ua)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply assumption
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply assumption
done

lemma reg_ua_sameHeap:
"\<lbrakk>(v,h,T, p, R):reg_ua; sameOH R h h1\<rbrakk> \<Longrightarrow> (v,h1,T, p, R):reg_ua"
apply (rule reg_ua_Preserved)
apply assumption
apply (simp add: sameOH_def)
done

lemma reg_ua_sameHeapRegSubset:
"\<lbrakk>(v,h,T, p, R):reg_ua; sameOH R1 h h1; R \<subseteq> R1\<rbrakk> \<Longrightarrow> (v,h1,T, p, R):reg_ua"
apply (rule reg_ua_sameHeap)
apply assumption
apply (simp add: sameOH_def, fast)
done


lemma reg_ua_IntVal: "(Ival i, h, Some IntET, p, R): reg_ua \<Longrightarrow> R={} "
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_Int: "(v, h, Some IntET, p, R): reg_ua \<Longrightarrow> R={} "
apply (erule reg_ua.cases)
apply clarify+
done


lemma reg_ua_IntValFalseTrue[rule_format]: 
"(IVal i, h, Some IntET, False, R): reg_ua \<Longrightarrow> 
p=True \<longrightarrow> (IVal i, h, Some IntET, p, R): reg_ua"
apply (rule impI)
apply (drule  reg_ua_IntVal)
apply (subgoal_tac "(IVal i, h, Some IntET, p, {}) \<in> reg_ua")
apply simp
apply (rule regInt_ua)
done


lemma reg_ua_IntFalseTrue[rule_format]: 
"(v, h, Some IntET, False, R): reg_ua \<Longrightarrow> p=True \<longrightarrow> (v, h, Some IntET, p, R): reg_ua"
apply (rule impI)
apply (frule  reg_ua_Int)
apply simp
apply (drule  regIval_complex)
apply (erule exE conjE)+
apply (drule_tac p=True in  reg_ua_IntValFalseTrue) 
apply simp+
done

lemma reg_ua_Unit: "(v, h, Some UnitET, p, R): reg_ua \<Longrightarrow> R={}"
apply (erule reg_ua.cases)
apply clarify+
done

lemma reg_ua_UnitFalseTrue[rule_format]: 
"(v, h, Some UnitET, False, R): reg_ua \<Longrightarrow> 
p=True \<longrightarrow> (v, h, Some UnitET, p, R): reg_ua"
apply (rule impI)
apply (drule  reg_ua_Unit)
apply (subgoal_tac "(v, h, Some UnitET, p, {}) \<in> reg_ua")
apply simp
apply (rule regUnit_ua)
done

lemma reg_ua_Null: "(RVal Nullref, h, Some (ListET k), p, R): reg_ua \<Longrightarrow> R={}"
apply (erule reg_ua.cases)
apply clarify+
done


lemma reg_ua_NullFalseTrue[rule_format]: 
"(RVal Nullref, h, Some (ListET k), False, R): reg_ua \<Longrightarrow> 
p=True \<longrightarrow> (RVal Nullref, h, Some (ListET k), p, R): reg_ua"
apply (rule impI)
apply (drule  reg_ua_Null)
apply (subgoal_tac "(RVal Nullref, h, Some (ListET k), p, {}): reg_ua")
apply simp
apply (rule regListNull_ua)
done

lemma reg_ua_Cons:
"(RVal (Ref a), h, Some (ListET k), p, RR): reg_ua \<Longrightarrow>
                h@@a = Some DIAM \<and>
                h<a\<bullet>DOLLAR> \<noteq> 2 \<and>
 (\<exists> R R'. 
                (a \<notin> R\<union>R') \<and>
                ((IVal h<a\<bullet>F0>, h, Some IntET, p, R') : reg_ua) \<and>
                ((RVal h\<lfloor>a\<diamondsuit>F1\<rfloor>, h,  Some(ListET k), p, R) : reg_ua) \<and>
                (p \<longrightarrow> R\<inter>R'={}) \<and>
                RR={a}\<union>R'\<union>R)"
apply (erule reg_ua.cases)
apply clarify apply clarify apply clarify
apply (rule conjI) apply clarify
apply (rule conjI) apply clarify
apply (rule exI)+
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply simp
apply (rule conjI) apply clarify
apply clarify
done


lemma reg_ua_Unique[rule_format]: 
"(v, h, T, p, R) : reg_ua \<Longrightarrow> ( \<forall> RR. (v, h, T, p, RR) : reg_ua \<longrightarrow> R=RR)"
apply (erule reg_ua.induct)

apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Int) apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Unit )apply simp
apply (rule allI)+ apply (rule impI) apply (drule reg_ua_Null )apply simp

apply (rule allI)+ apply (rule impI) 
apply (drule reg_ua_Cons)
apply (erule conjE exE)+
apply (rename_tac R1 R2)
apply (drule_tac x="R2" in spec) 
apply (drule_tac x="R1" in spec) 
apply safe
done



lemma reg_ua_WeakFalse:
"(v, h, T, p, R) : reg_ua  \<Longrightarrow> (v, h, T, False, R) : reg_ua"
apply (erule reg_ua.induct)
apply (rule regInt_ua)
apply (rule regUnit_ua)
apply (rule regListNull_ua)
apply (rule regListCons_ua)
apply assumption
apply assumption
apply assumption
apply assumption
apply assumption
apply clarify
done

lemma reg_ua_WeakTrue:
"(v, h, T, True, R) : reg_ua  \<Longrightarrow> (v, h, T, p, R) : reg_ua"
apply (case_tac "p=True")
apply clarify
apply (subgoal_tac "p=False")
apply clarify
apply (rule reg_ua_WeakFalse)
apply assumption
apply simp
done


lemma reg_ua_coherent_aux [rule_format]:
 "(v, h, T , p, R) : reg_ua \<Longrightarrow>
\<forall> r k1. v=RVal r \<longrightarrow> T= Some (ListET k1) \<longrightarrow>   (v, h, Some (ListET k2) , p, R) : reg_ua"
apply (erule reg_ua.induct)
apply clarify+

apply (rule regListNull_ua)

apply (rule allI)+
apply (rule impI)+
apply (rule regListCons_ua)
apply assumption+
apply (rotate_tac 4)  apply (erule thin_rl)
apply (erule_tac x="h\<lfloor>a\<diamondsuit>F1\<rfloor>" in allE)
apply (erule_tac x="k1" in allE)
apply (rotate_tac 8) apply (drule mp) apply simp
apply (rotate_tac 8) apply (drule mp) apply assumption
apply assumption
apply assumption
done


lemma reg_ua_coherent:
 "(RVal r, h, Some (ListET k1), p, R) : reg_ua \<Longrightarrow>
    (RVal r, h, Some (ListET k2), p, R) : reg_ua"
apply (rule reg_ua_coherent_aux)
apply simp+
done


text{*Contexts*}
types Context = "(rname \<leadsto>\<^sub>f Type)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM == fmap_dom"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> fmap_lookup G x"

lemma DOM_Update: "{x} \<union> (DOM b) = DOM (b(x\<mapsto>\<^sub>fk))" by (simp add: DOM_def)

lemma GETrNDomNone: "x \<notin> DOM C \<Longrightarrow> None = GETr C x"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETrNoneNDom: "GETr C x = None \<Longrightarrow> x \<notin> DOM C"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETrDomSome: " x \<in>  DOM C \<Longrightarrow> \<exists> T. GETr C x = Some T"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)


lemma GETrSome_DOM:"GETr G x = Some T \<Longrightarrow> x \<in> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma  GETrUniq:
"\<lbrakk>GETr G x = A; GETr G x = A'\<rbrakk> \<Longrightarrow> A=A'"
by (simp only: GETr_def)

lemma  GETrSomeUniq:
"\<lbrakk>GETr G x = Some T; GETr G x = Some T'\<rbrakk> \<Longrightarrow> T=T'"
apply (frule_tac A="Some T" and A'="Some T'" in GETrUniq)
apply assumption
apply simp
done

lemma reg_DOM: "(v, h, GETr G x, p, R) : reg_ua \<Longrightarrow> x \<in> DOM G"
apply (erule reg_ua.cases)
apply (simp add:  GETrSome_DOM)
apply (simp add:  GETrSome_DOM)
apply (simp add:  GETrSome_DOM)
apply (simp add:  GETrSome_DOM)
done

(******************)

constdefs coherent::"rname set \<Rightarrow> Context \<Rightarrow> Context \<Rightarrow> bool"
"coherent U G G' \<equiv>  \<forall> x. x\<in>U \<longrightarrow> 
(\<exists> T. GETr G x = Some T \<and> GETr G' x =  Some T) \<or>
(\<exists> k k'. GETr G x = Some (ListET k) \<and>  GETr G' x = Some (ListET k'))"


lemma coherent_DOM: "coherent U G G' \<Longrightarrow> U \<subseteq> DOM G"
apply (simp only: coherent_def)
apply (insert GETrSome_DOM)
apply fast
done

lemma coherent_subset: 
"\<lbrakk>coherent U G G'; U' \<subseteq> U\<rbrakk> \<Longrightarrow> coherent U' G G'"  
apply (simp only: coherent_def)
apply fast 
done

lemma coherent_refl_aux: "U \<subseteq> DOM G \<Longrightarrow> coherent U G G"
apply (simp only: coherent_def)
apply (rule allI) apply (rule impI)
apply (simp)
apply (subgoal_tac "x\<in>DOM G") 
apply (frule_tac x=x in  GETrDomSome) 
apply fastsimp+
done

lemma coherent_sym: 
"coherent U G G' \<Longrightarrow> coherent U G' G"
apply (simp only:  coherent_def)
apply fast
done

lemma coherent_trans: 
"\<lbrakk> coherent U G G'; coherent U G' G'' \<rbrakk> \<Longrightarrow>
coherent U G G''"
apply (simp only: coherent_def)
apply (insert GETrSomeUniq)
apply fast
done

(*lemma reg_ua_coherent_general:
 "\<lbrakk>(RVal r, h, Some (ListET k1), p, R) : reg_ua \<Longrightarrow>
    (RVal r, h, Some (ListET k2), p, R) : reg_ua"
apply (rule reg_ua_coherent_aux)
apply simp+
done*)


text{*Size of contexts, i.e. the region inhabited, and the number
      of freelist-cells owned by a context.*}


consts CR::"(env \<times> heap \<times> bool \<times> (rname set) \<times> Context \<times> nat \<times> (locn set)) set"
inductive CR intros
CR_empty: "(E,h,p, {}, C, i, {}) : CR"
CR_1: "\<lbrakk>(E, h, p, U-{x}, C, 1, R):CR;
         x \<in> U; 
        (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R'): reg_ua; 
         R \<inter> R' = {}\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, 1, R \<union> R') : CR"

CR_2: "\<lbrakk>(E,h, p, U-{x}, C, 2, R):CR; 
        x \<in> U;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R'): reg_ua;
        p \<longrightarrow> R \<inter> R' = {}\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, 2, R \<union> R') : CR"

CR_3: "\<lbrakk>(E,h, p, U-{x}, C, 3, R):CR;
        x \<in> U;
       (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R'): reg_ua\<rbrakk>
        \<Longrightarrow> (E,h, p, U, C, 3, R \<union> R') : CR"

lemma CR_emptyU:"(E,h,p, {}, C, i, R) : CR \<Longrightarrow> R={}"
apply (erule CR.cases)
apply clarify+
done

lemma CR_preserved [rule_format]:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow>
(\<forall> l. l\<in> R \<longrightarrow> sameOH {l} h h') \<longrightarrow>
(E, h', p, U, C, i, R) : CR"
apply (erule CR.induct)
apply clarsimp apply (rule CR_empty)

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CR_1)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
apply clarify

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CR_2)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
apply assumption

apply (rule impI)
apply (drule mp) 
apply clarsimp
apply (rule CR_3)
apply assumption
apply assumption
apply (rule reg_ua_Preserved)
apply assumption
apply simp
done

lemma CR_sameHeap:
"\<lbrakk> (E,h, p, U, C, i, R) : CR; sameOH R h h'\<rbrakk> \<Longrightarrow>
(E, h', p, U, C, i, R) : CR"
apply (rule CR_preserved)
apply assumption
apply (simp add: sameOH_def)
done

lemma CR_sameHeapRegSubset:
"\<lbrakk> (E,h, p, U, C, i, R) : CR; R\<subseteq>R1; sameOH R1 h h'\<rbrakk> \<Longrightarrow>
(E, h', p, U, C, i, R) : CR"
apply (rule CR_preserved)
apply assumption
apply (simp only: sameOH_def)
apply fast
done

lemma CR_Ufinite:
"(E,h, p, U, C, i, R) : CR \<Longrightarrow> finite U"
apply (erule CR.induct)
apply simp+
done


(*******************************************)


lemma CR_1_reverse [rule_format]:
"(E,h, p, U, C, i, RR) : CR \<Longrightarrow>  
i=1 \<longrightarrow> (\<forall> x . x \<in>  U \<longrightarrow>
(\<exists> R R'.   (E,h, p, U-{x}, C, 1, R):CR \<and>
           (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, True, R'): reg_ua \<and>
R \<inter> R' = {} \<and>
RR = R \<union> R'))"
apply (erule_tac CR.induct)
apply clarify
apply (rule allI impI)+
apply (rename_tac x')

apply (case_tac "x=x'")
apply (rule_tac x=R in exI)
apply (rule_tac x=R' in exI)
apply simp

apply (drule mp) apply simp
apply (erule_tac  x=x' in allE)
apply (drule mp) apply fast
apply (erule exE conjE)+
apply (rename_tac RR RR')
apply (rule_tac x="RR \<union> R' " in exI)
apply (rule_tac x="RR'" in exI)

apply (rule conjI)
apply (rule_tac x=x and U="U - {x'}" and R=RR in CR_1)
apply (subgoal_tac " U - {x'} - {x}= U - {x} - {x'}")
apply simp apply fast apply fast
apply assumption apply fast

apply (rule conjI) apply assumption
apply fast

apply clarsimp+
done


lemma CR_2_reverse [rule_format]:
"(E,h, p, U, C, i, RR) : CR \<Longrightarrow> 
i=2 \<longrightarrow> 
(\<forall> x. x \<in>  U \<longrightarrow> (\<exists> R R'.   
(E,h, p, U-{x}, C, i, R):CR \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R'): reg_ua \<and>
(p \<longrightarrow> R \<inter> R' = {}) \<and>
RR = R \<union> R'))"
apply (erule CR.induct)
apply clarify
apply simp

apply (rule impI)
apply (rule allI) apply (rule impI)
apply (drule mp)
apply simp
apply (rename_tac x')
apply (case_tac "x=x'")
apply (rule_tac x=R in exI)
apply (rule_tac x=R' in exI)
apply simp

apply (erule_tac x=x' in allE)
apply (rotate_tac 7)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2') 
apply (rule_tac x= "R1' \<union> R'" in exI)
apply (rule_tac x= "R2'" in exI)
apply (rule conjI)

apply (rule_tac x="x" and U="U - {x'}" in CR_2)
apply (subgoal_tac "U-{x'}-{x}=U-{x}-{x'}")
apply simp
apply fast
apply fast
apply assumption
apply fast

apply (rule conjI)
apply assumption
apply (rule conjI)
apply fast
apply fast
apply simp
done

lemma CR_3_reverse [rule_format]:
"(E,h, p, U, C, i, RR) : CR \<Longrightarrow> 
i=3 \<longrightarrow> 
(\<forall> x. x \<in>  U \<longrightarrow> (\<exists> R R'.   
(E,h, p, U-{x}, C, i, R):CR \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, False, R'): reg_ua \<and>
RR = R \<union> R'))"
apply (erule CR.induct)
apply clarify
apply simp
apply simp

apply (rule impI)
apply (rule allI) apply (rule impI)
apply (drule mp)
apply simp
apply (rename_tac x')
apply (case_tac "x=x'")
apply (rule_tac x=R in exI)
apply (rule_tac x=R' in exI)
apply simp

apply (erule_tac x=x' in allE)
apply (drule mp)
apply fast
apply (erule exE)+
apply (erule conjE)+
apply (rename_tac R1' R2') 
apply (rule_tac x= "R1' \<union> R'" in exI)
apply (rule_tac x= "R2'" in exI)
apply (rule conjI)

apply (rule_tac x="x" and U="U - {x'}" in CR_3)
apply (subgoal_tac "U-{x'}-{x}=U-{x}-{x'}")
apply simp
apply fast
apply fast
apply assumption

apply (rule conjI)
apply assumption
apply fast
done

lemma CR_reverse:
"\<lbrakk>(E,h, p, U, C, i, RR) : CR; x\<in> U \<rbrakk> \<Longrightarrow> 
\<exists> R R' p'.   
((E,h, p, U-{x}, C, i, R):CR \<and>
(RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p', R'): reg_ua \<and>
RR = R \<union> R' )"
apply (case_tac "i=1")
apply (drule CR_1_reverse) apply assumption apply assumption 
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x=R in exI) 
apply (rule_tac x=R' in exI)  
apply (rule_tac x=True in exI)
apply fast
apply (case_tac "i=2")
apply (drule CR_2_reverse) apply assumption apply assumption 
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x=R in exI) 
apply (rule_tac x=R' in exI)
apply fast
apply (case_tac "i=3")
apply (drule CR_3_reverse) apply assumption apply assumption 
apply (erule exE)+
apply (erule conjE)+
apply (rule_tac x=R in exI) 
apply (rule_tac x=R' in exI) 
apply (rule_tac x=False in exI)
apply fast
apply (erule CR.cases)
apply clarsimp
apply simp+
done

(***************************************)

lemma CR_1_region_subset: 
"\<lbrakk>(E,h, p, U, C, 1, RR) : CR;
  x\<in> U;
  (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p', R') : reg_ua\<rbrakk> \<Longrightarrow>
R'\<subseteq> RR"
apply (drule_tac x=x in CR_1_reverse)
apply simp apply assumption
apply (erule exE conjE)+
apply (rename_tac RR')
apply (drule_tac p=p' in reg_ua_WeakTrue)
apply (drule_tac R=R' and RR=RR' in reg_ua_Unique)
apply assumption apply fast
done

lemma CR_2_region_subset: 
"\<lbrakk>(E,h, p, U, C, 2, RR) : CR;
  x\<in> U;
  (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p, R') : reg_ua\<rbrakk> \<Longrightarrow>
R'\<subseteq> RR"
apply (drule_tac x=x in CR_2_reverse)
apply simp apply assumption
apply (erule exE conjE)+
apply (rename_tac RR')
apply (drule_tac R=R' and RR=RR' in reg_ua_Unique)
apply assumption apply fast
done

lemma CR_3_region_subset: 
"\<lbrakk>(E,h, p, U, C, 3, RR) : CR;
  x\<in> U;
  (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, p', R') : reg_ua\<rbrakk> \<Longrightarrow>
R'\<subseteq> RR"
apply (drule_tac x=x in CR_3_reverse)
apply simp apply assumption
apply (erule exE conjE)+
apply (rename_tac RR')
apply (drule_tac p=p' in reg_ua_WeakFalse)
apply (drule_tac R=R' and RR=RR' in reg_ua_Unique)
apply assumption apply fast
done

(******************************************)

lemma CR_1_union[rule_format]:
"(E,h, p, U', C, i, R') : CR \<Longrightarrow>
i=1 \<longrightarrow> 
(E,h, p, U'', C, 1, R'') : CR \<longrightarrow>
R' \<inter> R''={} \<longrightarrow>
(E,h, p, U' \<union>  U'', C, 1, R' \<union> R'') : CR"
apply (erule CR.induct)

apply (rule impI)+
apply simp

apply (rule impI)+
apply (drule mp) apply simp
apply (drule mp) apply assumption
apply (drule mp) apply fast

apply (case_tac "x\<in> U''")
apply (subgoal_tac "U - {x} \<union> U''=U \<union> U''")
apply (subgoal_tac "R'\<subseteq>R''") 
apply (subgoal_tac "R \<union> R''=R \<union> R' \<union> R''")
apply simp apply fast
apply (drule_tac x=x and U=U'' and p'=True and R'=R' in CR_1_region_subset)
apply assumption+  apply fast

apply (subgoal_tac "(E, h, p, U \<union> U'', C, 1, (R \<union> R'') \<union> R') \<in> CR")
apply (subgoal_tac "R \<union> R' \<union> R'' =(R \<union> R'') \<union> R'")
apply simp apply fast
apply (rule_tac x=x and U="U \<union> U''" and R="R \<union> R''" in CR_1)
apply (subgoal_tac "U - {x} \<union> U''=U \<union> U'' - {x}")
apply simp apply fast apply fast
apply assumption apply fast
apply simp+
done

lemma  CR_1_union3:
"\<lbrakk>(E,h, p, U', C, 1, R') : CR;
  (E,h, p, U'', C, 1, R'') : CR;
  (E,h, p, U''', C, 1, R''') : CR;
  R' \<inter> R'' ={};R' \<inter> R''' ={};R'' \<inter> R''' ={}\<rbrakk> \<Longrightarrow>
(E,h, p, U'\<union> U''\<union> U''', C, 1, R'\<union> R'' \<union> R''') : CR"
apply (rule_tac U'="U'\<union> U''" and U''=U''' and i=1 in CR_1_union)
apply (rule_tac U'="U'" and U''=U'' and i=1 in CR_1_union)
apply assumption apply simp
apply assumption+ apply simp
apply assumption apply fast
done


lemma CR_2_union[rule_format]:
"(E,h, p, U', C, i, R') : CR \<Longrightarrow>
i=2 \<longrightarrow> 
(E,h, p, U'', C, 2, R'') : CR \<longrightarrow>
(p \<longrightarrow> R' \<inter> R''={}) \<longrightarrow>
(E,h, p, U' \<union>  U'', C, 2, R' \<union> R'') : CR"
apply (erule CR.induct)

apply (rule impI)+
apply simp

apply simp

apply (rule impI)+
apply (drule mp) apply simp
apply (rotate_tac 7)
apply (drule mp) apply assumption
apply (rotate_tac 7)
apply (drule mp) apply fast

apply (case_tac "x\<in> U''")
apply (subgoal_tac "U - {x} \<union> U''=U \<union> U''")
apply (subgoal_tac "R'\<subseteq>R''") 
apply (subgoal_tac "R \<union> R''=R \<union> R' \<union> R''")
apply simp apply fast
apply (drule_tac x=x and U=U'' and p=p and R'=R' in CR_2_region_subset)
apply assumption+  apply fast

apply (subgoal_tac "(E, h, p, U \<union> U'', C, 2, (R \<union> R'') \<union> R') \<in> CR")
apply (subgoal_tac "R \<union> R' \<union> R'' =(R \<union> R'') \<union> R'")
apply simp apply fast
apply (rule_tac x=x and U="U \<union> U''" and R="R \<union> R''" in CR_2)
apply (subgoal_tac "U - {x} \<union> U''=U \<union> U'' - {x}")
apply simp apply fast apply fast
apply assumption apply fast
apply simp+
done

lemma  CR_2_union3:
"\<lbrakk>(E,h, p, U', C, 2, R') : CR;
  (E,h, p, U'', C, 2, R'') : CR;
  (E,h, p, U''', C, 2, R''') : CR;
  p\<longrightarrow> R' \<inter> R'' ={}; p\<longrightarrow> R' \<inter> R''' ={}; p \<longrightarrow> R'' \<inter> R''' ={}\<rbrakk> \<Longrightarrow>
(E,h, p, U'\<union> U''\<union> U''', C, 2, R'\<union> R'' \<union> R''') : CR"
apply (rule_tac U'="U'\<union> U''" and U''=U''' and i=2 in CR_2_union)
apply (rule_tac U'="U'" and U''=U'' and i=2 in CR_2_union)
apply fastsimp+
done




lemma CR_3_union[rule_format]:
"(E,h, p, U', C, i, R') : CR \<Longrightarrow>
i=3 \<longrightarrow> 
(E,h, p, U'', C, 3, R'') : CR \<longrightarrow>
(E,h, p, U' \<union>  U'', C, 3, R' \<union> R'') : CR"
apply (erule CR.induct)

apply (rule impI)+
apply simp

apply simp apply simp

apply (rule impI)+
apply (drule mp) apply simp
apply (drule mp) apply assumption

apply (case_tac "x\<in>U''")
apply (subgoal_tac "U - {x} \<union> U''=U \<union> U''")
apply (subgoal_tac "R'\<subseteq>R''") 
apply (subgoal_tac "R \<union> R''=R \<union> R' \<union> R''")
apply simp apply fast
apply (drule_tac x=x and U=U'' and p'=False and R'=R' in CR_3_region_subset)
apply assumption+  apply fast

apply (subgoal_tac "R \<union> R' \<union> R'' =(R \<union> R'') \<union> R'")
apply simp 
apply (rule_tac x=x and U="U \<union> U''" and R="R \<union> R''" in CR_3)
apply (subgoal_tac "U - {x} \<union> U''=U \<union> U'' - {x}")
apply simp apply fast apply fast
apply assumption apply fast
done

lemma  CR_3_union3:
"\<lbrakk>(E,h, p, U', C, 3, R') : CR;
  (E,h, p, U'', C, 3, R'') : CR;
  (E,h, p, U''', C, 3, R''') : CR\<rbrakk> \<Longrightarrow>
(E,h, p, U'\<union> U''\<union> U''', C, 3, R'\<union> R'' \<union> R''') : CR"
apply (rule_tac U'="U'\<union> U''" and U''=U''' and i=3 in CR_3_union)
apply (rule_tac U'="U'" and U''=U'' and i=3 in CR_3_union)
apply fastsimp+
done



(************************)

lemma CR_1_unique [rule_format]:
"finite U \<Longrightarrow>
\<forall> R RR .(E,h, p, U, C, i, R) : CR \<longrightarrow>
i=1 \<longrightarrow> 
(E, h, p, U, C, 1, RR) : CR \<longrightarrow> RR=R"
apply (induct set: Finites)
apply (rule impI allI)+ apply (drule CR_emptyU)+ apply simp

apply (rule impI allI)+
apply (drule_tac x=x and U="insert x F" in CR_1_reverse)
apply assumption apply simp
apply (drule_tac x=x and U="insert x F" in CR_1_reverse)
apply simp apply simp
apply (erule exE conjE)+
apply (rename_tac Raux RRaux R' Raux')
apply (erule_tac x=Raux in allE)
apply (erule_tac x=RRaux in allE)
apply (drule mp) apply fastsimp
apply (drule mp) apply assumption
apply (drule mp) apply fastsimp
apply (drule_tac R=R' and RR=Raux' in reg_ua_Unique)
apply assumption
apply fast
done

lemma CR_2_unique [rule_format]:
"finite U \<Longrightarrow>
\<forall> R RR .(E,h, p, U, C, i, R) : CR \<longrightarrow>
i=2 \<longrightarrow> 
(E, h, p, U, C, 2, RR) : CR \<longrightarrow> RR=R"
apply (induct set: Finites)
apply (rule impI allI)+ apply (drule CR_emptyU)+ apply simp

apply (rule impI allI)+
apply (drule_tac x=x and U="insert x F" in CR_2_reverse)
apply assumption apply simp
apply (drule_tac x=x and U="insert x F" in CR_2_reverse)
apply simp apply simp
apply (erule exE conjE)+
apply (rename_tac Raux RRaux R' Raux')
apply (erule_tac x=Raux in allE)
apply (erule_tac x=RRaux in allE)
apply (rotate_tac 11)
apply (drule mp) apply fastsimp
apply (rotate_tac 11)
apply (drule mp) apply assumption
apply (rotate_tac 11)
apply (drule mp) apply fastsimp
apply (drule_tac R=R' and RR=Raux' in reg_ua_Unique)
apply assumption
apply fast
done

lemma CR_3_unique [rule_format]:
"finite U \<Longrightarrow>
\<forall> R RR .(E,h, p, U, C, i, R) : CR \<longrightarrow>
i=3 \<longrightarrow> 
(E, h, p, U, C, 3, RR) : CR \<longrightarrow> RR=R"
apply (induct set: Finites)
apply (rule impI allI)+ apply (drule CR_emptyU)+ apply simp

apply (rule impI allI)+
apply (drule_tac x=x and U="insert x F" in CR_3_reverse)
apply assumption apply simp
apply (drule_tac x=x and U="insert x F" in CR_3_reverse)
apply simp apply simp
apply (erule exE conjE)+
apply (rename_tac Raux RRaux R' Raux')
apply (erule_tac x=Raux in allE)
apply (erule_tac x=RRaux in allE)
apply (drule mp) apply fastsimp
apply (drule mp) apply assumption
apply (drule mp) apply fastsimp
apply (drule_tac R=R' and RR=Raux' in reg_ua_Unique)
apply assumption
apply fast
done




lemma CR_uniqueReg:
"\<lbrakk>(E,h, p, U, C, i, R) : CR; (E, h, p, U, C, i, R'): CR\<rbrakk>   \<Longrightarrow> R'=R"
apply (case_tac "i=1")
apply (rule_tac U=U and i=i and E=E and h=h and p=p and 
C=C and R=R in CR_1_unique) 
apply (rule CR_Ufinite) apply assumption  
apply assumption+ apply simp


apply (case_tac "i=2")
apply (rule_tac U=U and i=i and E=E and h=h and p=p and 
C=C and R=R in CR_2_unique) 
apply (rule CR_Ufinite) apply assumption  
apply assumption+ apply simp


apply (case_tac "i=3")
apply (rule_tac U=U and i=i and E=E and h=h and p=p and 
C=C and R=R in CR_3_unique) 
apply (rule CR_Ufinite) apply assumption  
apply assumption+ apply simp

apply (erule CR.cases)
apply clarsimp
apply (drule CR_emptyU) apply simp
apply simp+
done


(***********************************)

lemma CR_1_subset [rule_format]:
"finite U \<Longrightarrow> \<forall> R . U\<subseteq>U'\<longrightarrow>
(E,h, p, U, C, 1, R) : CR \<longrightarrow> (E, h, p, U', C, 1, RR): CR \<longrightarrow>
R\<subseteq>RR"
apply (induct set: Finites)

apply (rule allI impI)+
apply (drule CR_emptyU) apply simp

apply (rule allI impI)+
apply (drule_tac x=x and U="insert x F" in CR_1_reverse)
apply simp apply fast
apply (erule exE conjE)+
apply (rename_tac Raux Raux')
apply (erule_tac x=Raux in allE)

apply (drule mp) apply fast
apply (drule mp) apply fastsimp
apply (drule mp) apply assumption
apply (drule_tac x=x and U=U' and p'=True and R'=Raux' in CR_1_region_subset)
apply fast apply assumption apply fast
done

lemma CR_2_subset [rule_format]:
"finite U \<Longrightarrow> \<forall> R . U\<subseteq>U'\<longrightarrow>
(E,h, p, U, C, 2, R) : CR \<longrightarrow> (E, h, p, U', C, 2, RR): CR \<longrightarrow>
R\<subseteq>RR"
apply (induct set: Finites)

apply (rule allI impI)+
apply (drule CR_emptyU) apply simp

apply (rule allI impI)+
apply (drule_tac x=x and U="insert x F" in CR_2_reverse)
apply simp apply fast
apply (erule exE conjE)+
apply (rename_tac Raux Raux')
apply (erule_tac x=Raux in allE)

apply (rotate_tac 8) apply (drule mp) apply fast
apply (rotate_tac 8) apply (drule mp) apply fastsimp
apply (rotate_tac 8) apply (drule mp) apply assumption
apply (drule_tac x=x and U=U' and p=p and R'=Raux' in CR_2_region_subset)
apply fast apply assumption apply fast
done

lemma CR_3_subset [rule_format]:
"finite U \<Longrightarrow> \<forall> R . U\<subseteq>U'\<longrightarrow>
(E,h, p, U, C, 3, R) : CR \<longrightarrow> (E, h, p, U', C, 3, RR): CR \<longrightarrow>
R\<subseteq>RR"
apply (induct set: Finites)

apply (rule allI impI)+
apply (drule CR_emptyU) apply simp

apply (rule allI impI)+
apply (drule_tac x=x and U="insert x F" in CR_3_reverse)
apply simp apply fast
apply (erule exE conjE)+
apply (rename_tac Raux Raux')
apply (erule_tac x=Raux in allE)

apply (drule mp) apply fast
apply (drule mp) apply fastsimp
apply (drule mp) apply assumption
apply (drule_tac x=x and U=U' and p'=False and R'=Raux' in CR_3_region_subset)
apply fast apply assumption apply fast
done


lemma CR_subset:
"\<lbrakk>(E,h, p, U, C, i, R) : CR; (E, h, p, U', C, i, RR): CR; U\<subseteq> U'\<rbrakk>   \<Longrightarrow> R \<subseteq> RR"
apply (case_tac "i=1")
apply (rule_tac U=U and U'=U' and E=E and h=h and p=p and 
C=C and R=R in CR_1_subset) 
apply (rule CR_Ufinite) apply assumption  
apply assumption+ apply simp+

apply (case_tac "i=2")
apply (rule_tac U=U and U'=U' and E=E and h=h and p=p and 
C=C and R=R in CR_2_subset) 
apply (rule CR_Ufinite) apply assumption  
apply assumption+ apply simp+

apply (case_tac "i=3")
apply (rule_tac U=U and U'=U' and E=E and h=h and p=p and 
C=C and R=R in CR_3_subset) 
apply (rule CR_Ufinite) apply assumption  
apply assumption+ apply simp+


apply (erule CR.cases)
apply clarsimp
apply simp+
done



lemma CR_1_EquivTrueFalse [rule_format]:
"(E,h,  p, U, G, i, R):CR
 \<Longrightarrow> i=1 \<longrightarrow> (\<forall> p'. (E,h, p', U, G, i, R):CR)"
apply (erule CR.induct)
apply clarify apply (rule CR_empty)

apply clarify 

apply (rule_tac x=x in CR_1)
apply (drule mp)
apply simp
apply (erule_tac x=p' in allE)
apply assumption+
apply simp+
done

lemma CR_3_EquivTrueFalse [rule_format]:
"(E,h,  p, U, G, i, R):CR
 \<Longrightarrow> i=3 \<longrightarrow> (\<forall> p'. (E,h, p', U, G, i, R):CR)"
apply (erule CR.induct)
apply clarify apply (rule CR_empty)
apply simp
apply simp 

apply clarify
apply (rule CR_3)
apply (drule mp)
apply simp
apply (erule_tac x=p' in allE)
apply assumption+
done

lemma CR_2_TrueFalse [rule_format]:
"(E,h,  p, U, G, i, R):CR \<Longrightarrow>
i=(2::nat) \<longrightarrow> p=True \<longrightarrow> (E,h, False, U, G, i, R):CR"
apply (erule CR.induct) 
apply clarify
apply (rule CR_empty)
apply simp
apply (rule impI)+
apply (rule_tac x=x in CR_2)
apply (drule mp)
apply simp
apply (rotate_tac 6)
apply (drule mp)
apply assumption+
apply (rule reg_ua_WeakFalse)
apply assumption
apply clarify
apply simp
done

lemma CR_UDOM [rule_format]: 
"(E,h, p, U, G, i, R):CR \<Longrightarrow> U\<subseteq> DOM G"
apply (erule CR.induct)
apply fast
apply (drule reg_DOM) apply fast
apply (drule reg_DOM) apply fast
apply (drule reg_DOM) apply fast
done



lemma coherent_CR_aux [rule_format]: 
"(E,h, p, U, G, i, R):CR \<Longrightarrow> 
(\<forall> x. x\<in>U \<longrightarrow> 
((\<exists> T. GETr G x = Some T \<and> GETr G' x =  Some T) \<or>
(\<exists> k k'. GETr G x = Some (ListET k) \<and>  GETr G' x = Some (ListET k'))))
\<longrightarrow> (E,h, p, U, G', i, R):CR"
apply (erule CR.induct)
apply (rule impI)+
apply (rule CR_empty)

(***)
apply (rule impI)+
apply (rule_tac x=x in CR_1)
apply (drule mp) apply fast
apply assumption+ 

apply (drule mp) apply fast
apply (erule_tac x=x in allE)
apply (drule mp) apply assumption
apply (erule disjE)

apply (erule exE)+ apply (erule conjE)+ 
apply simp

apply (erule exE)+ apply (erule conjE)+ 
apply (frule_tac r="renv E x" in reg_ua_coherent_aux) 
apply simp+ 

(***)

apply (rule impI)+
apply (rule_tac x=x in CR_2)
apply (drule mp) apply fast
apply assumption+

apply (drule mp) apply fast
apply (erule_tac x=x in allE)
apply (rotate_tac 5)
apply (drule mp) apply assumption+

apply (erule disjE)
apply (erule exE conjE)+
apply simp

apply (erule exE conjE)+ 
apply (frule_tac r="renv E x" in reg_ua_coherent_aux) 
apply simp+ 

(***)

apply (rule impI)+
apply (rule_tac x=x in CR_3)
apply (drule mp) apply fast
apply assumption+ 

apply (drule mp) apply fast
apply (erule_tac x=x in allE)
apply (drule mp) apply assumption

apply (erule disjE)
apply (erule exE conjE)+
apply simp

apply (erule conjE)+  apply (erule exE)+   
apply (frule_tac r="renv E x" in reg_ua_coherent_aux) 
apply simp+ 
done

lemma coherent_CR [rule_format]: 
"\<lbrakk> (E,h, p, U, G, i, R):CR; coherent U G G'\<rbrakk> \<Longrightarrow> 
(E,h, p, U, G', i, R):CR"
apply (rule coherent_CR_aux)
apply assumption
apply (simp only:  coherent_def)
done


lemma coherent_CR_general [rule_format]: 
"\<lbrakk> (E,h, p, U', G, i, R):CR; coherent U G G'; U' \<subseteq> U\<rbrakk> \<Longrightarrow> 
(E,h, p, U', G', i, R):CR"
apply (rule coherent_CR_aux)
apply assumption
apply (drule_tac U'=U' in coherent_subset)
apply assumption
apply (simp only:  coherent_def)
done


lemma rise_CR [rule_format]:
"(E,h, p, U, G, i, R):CR 
\<Longrightarrow> \<forall> j. i\<le>j \<and> j \<le> 3 \<longrightarrow> (E,h, p, U, G, j, R):CR"
apply (erule CR.induct)

apply (rule allI)
apply (rule impI)
apply (rule CR_empty)

apply (rule allI)
apply (rule impI)

apply (case_tac "j=1") 
apply (drule CR_1)
apply assumption+
apply simp

apply (case_tac "j=2") 
apply (erule_tac x=2 in allE)
apply (drule mp)
apply simp
apply (drule_tac x=x in CR_2)
apply assumption
apply (drule_tac p=p in reg_ua_WeakTrue)
apply assumption
apply clarify
apply simp

apply (case_tac "j=3") 
apply (erule_tac x=3 in allE)
apply (drule mp)
apply simp
apply (drule_tac x=x in CR_3)
apply assumption
apply (drule_tac p=False in reg_ua_WeakTrue)
apply assumption
apply simp
apply (erule conjE)
apply simp

apply (rule allI)
apply (rule impI)

apply (case_tac "j=2") 
apply (erule_tac x=2 in allE)
apply (rotate_tac 6)
apply (drule mp)
apply simp
apply (drule_tac x=x in CR_2)
apply assumption
apply assumption
apply clarify
apply simp

apply (case_tac "j=3") 
apply (erule_tac x=3 in allE)
apply (rotate_tac 6)
apply (drule mp)
apply simp
apply (drule_tac x=x in CR_3)
apply assumption
apply (drule reg_ua_WeakFalse)
apply assumption
apply simp
apply (erule conjE)
apply simp

apply (rule allI)
apply (rule impI)

apply (case_tac "j=3") 
apply (erule_tac x=3 in allE)
apply (drule mp)
apply simp
apply (drule_tac x=x in CR_3)
apply assumption
apply assumption
apply simp
apply (erule conjE)
apply simp
done

(*********************************************)


lemma CR_1_union_reverse_aux[rule_format]:
"finite U'' \<Longrightarrow>
\<forall> R. (E,h, p, U' \<union>  U'', C, 1, R) : CR \<longrightarrow>
(\<exists> R' R''. 
(E,h, p, U', C, 1, R') : CR \<and>
(E,h, p, U'', C, 1, R'') : CR \<and>
R=R' \<union> R'')"  
apply (induct set: Finites)

apply (rule allI) apply (rule impI)+
apply (rule_tac x=R in exI)
apply (rule_tac x="{}" in exI)
apply (rule conjI) apply simp
apply (rule conjI) apply (rule CR_empty)
apply simp

apply (rule allI impI)+
apply (frule_tac x=x in CR_1_reverse)
apply simp apply fastsimp
apply (erule exE conjE)+
apply (rename_tac Raux R')


apply (case_tac "x \<in> U'")
apply (erule_tac x="R" in allE)
apply (drule mp)
apply (subgoal_tac "U' \<union> insert x F = U' \<union> F")
apply simp apply fastsimp
apply (erule exE conjE)+
apply (rename_tac Raux' R'')
apply (rule_tac x=Raux' in exI)
apply (rule_tac x="R'' \<union> R'" in exI)
apply (rule conjI) apply assumption
apply (rule conjI) apply (rule_tac x=x in CR_1)
apply simp apply fast apply assumption
apply (subgoal_tac "R''\<subseteq> Raux")
apply fastsimp
apply (frule_tac U="F" and U'="U' \<union> insert x F - {x}" in CR_subset)  
apply assumption apply fast apply assumption
apply fast


apply (erule_tac x="Raux" in allE)
apply (drule mp) apply (subgoal_tac "U' \<union> insert x F-{x}=U' \<union>F")
apply fastsimp apply fast
apply (erule exE conjE)+
apply (rename_tac Raux' R'') 
apply (rule_tac x=Raux' in exI)
apply (rule_tac x="R''\<union> R'" in exI)  
apply (rule conjI) apply assumption
apply (rule conjI) apply (rule_tac x=x in CR_1)
apply simp apply fastsimp
apply assumption apply fastsimp
apply fastsimp
done



lemma CR_1_union_reverse:
"\<lbrakk>(E,h, p, U' \<union>  U'', C, 1, R) : CR\<rbrakk> \<Longrightarrow>
(\<exists> R' R''. 
(E,h, p, U', C, 1, R') : CR \<and>
(E,h, p, U'', C, 1, R'') : CR \<and>
R=R' \<union> R'')"
apply (rule CR_1_union_reverse_aux)
apply (drule CR_Ufinite) apply simp
apply assumption+
done

lemma CR_1_union3_reverse:
"\<lbrakk>(E,h, p, U' \<union>  U''\<union>  U''', C, 1, R) : CR\<rbrakk> \<Longrightarrow>
(\<exists> R' R'' R'''. 
(E,h, p, U', C, 1, R') : CR \<and>
(E,h, p, U'', C, 1, R'') : CR \<and>
(E,h, p, U''', C, 1, R''') : CR \<and>
R=R' \<union> R'' \<union> R''')"
apply (drule CR_1_union_reverse)
apply (erule exE)+ apply (erule conjE)+
apply (frule_tac U'=U' and U''=U'' in CR_1_union_reverse)
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux Raux')
apply (rule_tac x=Raux in exI)
apply (rule_tac x=Raux' in exI)
apply (rule_tac x=R'' in exI)
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply fast
done



lemma CR_1_union_detailed_reverse_aux[rule_format]:
"finite U'' \<Longrightarrow>
\<forall> R .(E,h, p, U' \<union>  U'', C, 1, R) : CR \<longrightarrow>  U' \<inter> U'' ={} \<longrightarrow>
(\<exists> R' R''. 
(E,h, p, U', C, 1, R') : CR \<and>
(E,h, p, U'', C, 1, R'') : CR \<and>
R' \<inter>  R'' ={} \<and> 
R=R' \<union> R'')"  
apply (induct set: Finites)

apply (rule allI) apply (rule impI)+
apply (rule_tac x=R in exI)
apply (rule_tac x="{}" in exI)
apply (rule conjI) apply simp
apply (rule conjI) apply (rule CR_empty)
apply (rule conjI) apply simp apply simp

apply (rule allI) apply (rule impI)+
apply (frule_tac x=x in CR_1_reverse)
apply simp apply simp
apply (erule exE)+ apply (erule conjE)+

apply (rename_tac Raux R')
apply (erule_tac x="Raux" in allE)
apply (drule mp) apply fastsimp
apply (drule mp) apply fast

apply (erule exE conjE)+
apply (rename_tac Raux' R'') 
apply (rule_tac x=Raux' in exI)
apply (rule_tac x="R''\<union> R'" in exI)  
apply (rule conjI) apply assumption
apply (rule conjI) apply (rule_tac x=x in CR_1)
apply simp apply fastsimp
apply assumption apply fastsimp
apply (rule conjI)  apply fastsimp
apply fastsimp
done

lemma CR_1_union_reverse_detailed:
"\<lbrakk>(E,h, p, U' \<union>  U'', C, 1, R) : CR;  U' \<inter> U'' ={}\<rbrakk> \<Longrightarrow>
(\<exists> R' R''. 
(E,h, p, U', C, 1, R') : CR \<and>
(E,h, p, U'', C, 1, R'') : CR \<and>
R' \<inter>  R'' ={} \<and> 
R=R' \<union> R'')"
apply (rule CR_1_union_detailed_reverse_aux)
apply (drule CR_Ufinite) apply simp
apply assumption+
done

lemma CR_1_union3_reverse_detailed:
"\<lbrakk>(E,h, p, U' \<union>  U''\<union>  U''', C, 1, R) : CR;  
U' \<inter> U'' ={}; U' \<inter> U''' ={}; U'' \<inter> U''' ={} \<rbrakk> \<Longrightarrow>
(\<exists> R' R'' R'''. 
(E,h, p, U', C, 1, R') : CR \<and>
(E,h, p, U'', C, 1, R'') : CR \<and>
(E,h, p, U''', C, 1, R''') : CR \<and>
R' \<inter> R'' ={} \<and> R' \<inter> R''' ={} \<and> R'' \<inter> R''' ={} \<and> 
R=R' \<union> R'' \<union> R''')"
apply (drule CR_1_union_reverse_detailed)
apply fast
apply (erule exE conjE)+ 
apply (drule_tac U'=U' and U''=U'' in CR_1_union_reverse_detailed)
apply assumption
apply (erule exE conjE)+
apply (rename_tac Raux Raux')
apply (rule_tac x=Raux in exI)
apply (rule_tac x=Raux' in exI)
apply (rule_tac x=R'' in exI)
apply (rule conjI, assumption)+ 
apply (rule conjI, fast)+ apply fast
done


(**************************************)


lemma CR_2_union_reverse_aux[rule_format]:
"finite U'' \<Longrightarrow>
\<forall> R .(E,h, p, U' \<union>  U'', C, 2, R) : CR \<longrightarrow>  
(\<exists> R' R''. 
(E,h, p, U', C, 2, R') : CR \<and>
(E,h, p, U'', C, 2, R'') : CR \<and>
R=R' \<union> R'')"  
apply (induct set: Finites)

apply (rule allI) apply (rule impI)+
apply (rule_tac x=R in exI)
apply (rule_tac x="{}" in exI)
apply (rule conjI) apply simp
apply (rule conjI) apply (rule CR_empty)
apply simp

apply (rule allI) apply (rule impI)+
apply (frule_tac x=x in CR_2_reverse)
apply simp apply simp
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux R')

apply (case_tac "x \<in> U'")
apply (erule_tac x="R" in allE)
apply (rotate_tac 8)
apply (drule mp)
apply (subgoal_tac "U' \<union> insert x F = U' \<union> F")
apply simp apply fastsimp
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux' R'')
apply (rule_tac x=Raux' in exI)
apply (rule_tac x="R'' \<union> R'" in exI)
apply (rule conjI) apply assumption
apply (rule conjI) apply (rule_tac x=x in CR_2)
apply simp apply fastsimp apply assumption
apply (subgoal_tac "R''\<subseteq> Raux")
apply fastsimp
apply (frule_tac U="F" and U'="U' \<union> insert x F - {x}" in CR_subset)  
apply assumption apply fast apply assumption
apply fast


apply (erule_tac x="Raux" in allE)
apply (rotate_tac 8)
apply (drule mp) apply (subgoal_tac "U' \<union> insert x F-{x}=U' \<union>F")
apply fastsimp apply fast
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux' R'')
apply (rule_tac x=Raux' in exI)
apply (rule_tac x="R''\<union> R'" in exI)  
apply (rule conjI) apply assumption
apply (rule conjI) apply (rule_tac x=x in CR_2)
apply simp apply fastsimp
apply assumption apply fastsimp
apply fastsimp
done

lemma CR_2_union_reverse:
"\<lbrakk>(E,h, p, U' \<union>  U'', C, 2, R) : CR\<rbrakk> \<Longrightarrow>
(\<exists> R' R''. 
(E,h, p, U', C, 2, R') : CR \<and>
(E,h, p, U'', C, 2, R'') : CR \<and>
R=R' \<union> R'')"
apply (rule CR_2_union_reverse_aux)
apply (drule CR_Ufinite) apply simp
apply assumption+
done

lemma CR_2_union3_reverse:
"\<lbrakk>(E,h, p, U' \<union>  U''\<union>  U''', C, 2, R) : CR\<rbrakk> \<Longrightarrow>
(\<exists> R' R'' R'''. 
(E,h, p, U', C, 2, R') : CR \<and>
(E,h, p, U'', C, 2, R'') : CR \<and>
(E,h, p, U''', C, 2, R''') : CR \<and>
R=R' \<union> R'' \<union> R''')"
apply (frule CR_2_union_reverse)
apply (erule exE)+ apply (erule conjE)+
apply (frule_tac U'=U' and U''=U'' in CR_2_union_reverse)
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux Raux')
apply (rule_tac x=Raux in exI)
apply (rule_tac x=Raux' in exI)
apply (rule_tac x=R'' in exI)
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply (rule conjI) apply assumption
apply fast
done



lemma CR_2True_union_detailed_reverse_aux[rule_format]:
"finite U'' \<Longrightarrow>
\<forall> R .(E,h, True, U' \<union>  U'', C, 2, R) : CR \<longrightarrow>  U' \<inter> U'' ={} \<longrightarrow>
(\<exists> R' R''. 
(E,h, True, U', C, 2, R') : CR \<and>
(E,h, True, U'', C, 2, R'') : CR \<and>
R' \<inter>  R'' ={} \<and> 
R=R' \<union> R'')"  
apply (induct set: Finites)

apply (rule allI) apply (rule impI)+
apply (rule_tac x=R in exI)
apply (rule_tac x="{}" in exI)
apply (rule conjI) apply simp
apply (rule conjI) apply (rule CR_empty)
apply (rule conjI) apply simp apply simp

apply (rule allI) apply (rule impI)+
apply (frule_tac x=x in CR_2_reverse)
apply simp apply simp
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux R')

apply (erule_tac x="Raux" in allE)
apply (rotate_tac 8)
apply (drule mp) apply fastsimp
apply (rotate_tac 8)
apply (drule mp) apply fast

apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux' R'')
apply (rule_tac x=Raux' in exI)
apply (rule_tac x="R''\<union> R'" in exI)  
apply (rule conjI) apply assumption
apply (rule conjI) apply (rule_tac x=x in CR_2)
apply simp apply fastsimp
apply assumption apply fastsimp
apply (rule conjI)  apply fastsimp
apply fastsimp
done

lemma CR_2True_union_detailed_reverse:
"\<lbrakk>(E,h, True, U' \<union>  U'', C, 2, R) : CR;  U' \<inter> U'' ={}\<rbrakk> \<Longrightarrow>
(\<exists> R' R''. 
(E,h, True, U', C, 2, R') : CR \<and>
(E,h, True, U'', C, 2, R'') : CR \<and>
R' \<inter>  R'' ={} \<and> 
R=R' \<union> R'')"
apply (rule CR_2True_union_detailed_reverse_aux)
apply (drule CR_Ufinite) apply simp
apply assumption+
done

lemma CR_2True_union3_detailed_reverse:
"\<lbrakk>(E,h, True, U' \<union>  U''\<union>  U''', C, 2, R) : CR;  
U' \<inter> U'' ={}; U' \<inter> U''' ={}; U'' \<inter> U''' ={} \<rbrakk> \<Longrightarrow>
(\<exists> R' R'' R'''. 
(E,h, True, U', C, 2, R') : CR \<and>
(E,h, True, U'', C, 2, R'') : CR \<and>
(E,h, True, U''', C, 2, R''') : CR \<and>
R' \<inter>  R'' ={} \<and> 
R' \<inter>  R''' ={} \<and>
R'' \<inter>  R''' ={} \<and>
R=R' \<union> R'' \<union> R''')"
apply (frule CR_2True_union_detailed_reverse)
apply fast
apply (erule exE)+ apply (erule conjE)+
apply (frule_tac U'=U' and U''=U'' in CR_2True_union_detailed_reverse)
apply assumption
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux Raux')
apply (rule_tac x=Raux in exI)
apply (rule_tac x=Raux' in exI)
apply (rule_tac x=R'' in exI)
apply (rule conjI, assumption)+ 
apply (rule conjI , fast)+
apply fast
done


(*************************************)

lemma CR_3_union_reverse_aux[rule_format]:
"finite U'' \<Longrightarrow>
\<forall> R .(E,h, p, U' \<union>  U'', C, 3, R) : CR \<longrightarrow>  
(\<exists> R' R''. 
(E,h, p, U', C, 3, R') : CR \<and>
(E,h, p, U'', C, 3, R'') : CR \<and>
R=R' \<union> R'')"  
apply (induct set: Finites)

apply (rule allI) apply (rule impI)+
apply (rule_tac x=R in exI)
apply (rule_tac x="{}" in exI)
apply (rule conjI) apply simp
apply (rule conjI) apply (rule CR_empty)
apply simp

apply (rule allI) apply (rule impI)+
apply (frule_tac x=x in CR_3_reverse)
apply simp apply simp
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux R')

apply (case_tac "x \<in> U'")
apply (erule_tac x="R" in allE)
apply (drule mp)
apply (subgoal_tac "U' \<union> insert x F = U' \<union> F")
apply simp apply fastsimp
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux' R'')
apply (rule_tac x=Raux' in exI)
apply (rule_tac x="R'' \<union> R'" in exI)
apply (rule conjI) apply assumption
apply (rule conjI) apply (rule_tac x=x in CR_3)
apply simp apply fastsimp apply assumption
apply (subgoal_tac "R''\<subseteq> Raux")
apply fastsimp
apply (frule_tac U="F" and U'="U' \<union> insert x F - {x}" in CR_subset)  
apply assumption apply fast apply assumption

apply (erule_tac x="Raux" in allE)
apply (drule mp) apply (subgoal_tac "U' \<union> insert x F-{x}=U' \<union>F")
apply fastsimp apply fast
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux' R'')
apply (rule_tac x=Raux' in exI)
apply (rule_tac x="R''\<union> R'" in exI)  
apply (rule conjI) apply assumption
apply (rule conjI) apply (rule_tac x=x in CR_3)
apply simp apply fastsimp
apply assumption apply fastsimp
done

lemma CR_3_union_reverse:
"\<lbrakk>(E,h, p, U' \<union>  U'', C, 3, R) : CR\<rbrakk> \<Longrightarrow>
(\<exists> R' R''. 
(E,h, p, U', C, 3, R') : CR \<and>
(E,h, p, U'', C, 3, R'') : CR \<and>
R=R' \<union> R'')"
apply (rule CR_3_union_reverse_aux)
apply (drule CR_Ufinite) apply simp
apply assumption+
done

lemma CR_3_union3_reverse:
"\<lbrakk>(E,h, p, U' \<union>  U''\<union>  U''', C, 3, R) : CR\<rbrakk> \<Longrightarrow>
(\<exists> R' R'' R'''. 
(E,h, p, U', C, 3, R') : CR \<and>
(E,h, p, U'', C, 3, R'') : CR \<and>
(E,h, p, U''', C, 3, R''') : CR \<and>
R=R' \<union> R'' \<union> R''')"
apply (frule CR_3_union_reverse)
apply (erule exE)+ apply (erule conjE)+
apply (frule_tac U'=U' and U''=U'' in CR_3_union_reverse)
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac Raux Raux')
apply (rule_tac x=Raux in exI)
apply (rule_tac x=Raux' in exI)
apply (rule_tac x=R'' in exI)
apply (rule conjI, assumption)+
apply fast
done

lemma CR_1_subset_reverse_aux[rule_format]:
"finite U \<Longrightarrow>
\<forall> U' R. (E,h, p, U, C, 1, R) : CR \<longrightarrow> U' \<subseteq> U \<longrightarrow>
( \<exists> RR. (E,h, p, U', C, 1, RR) : CR \<and> RR \<subseteq> R)"
apply (induct set: Finites)

apply (rule allI impI)+ apply (rule_tac x="{}" in exI) 
apply (rule conjI) 
apply (simp) apply (rule CR_empty) 
apply simp

apply (rule allI impI)+ 
apply (drule_tac x=x and U="insert x F" in CR_1_reverse)
apply simp apply fast
apply (erule exE conjE)+
apply (rename_tac Raux R')

apply (case_tac "x\<in>U'")
apply (erule_tac x="U'-{x}" in allE)
apply (erule_tac x="Raux" in allE)
apply (drule mp) apply fastsimp
apply (drule mp) apply fast
apply (erule exE conjE)+
apply (rule_tac x="RR\<union>R'" in exI)
apply (rule conjI)
apply (rule_tac x=x and U=U' in CR_1)
apply assumption+ apply fast
apply fast

apply (erule_tac x="U'" in allE)
apply (erule_tac x="Raux" in allE)
apply (drule mp) apply fastsimp
apply (drule mp) apply fast
apply (erule_tac exE conjE)+
apply fast
done

lemma CR_1_subset_reverse[rule_format]:
"\<lbrakk>(E,h, p, U, C, 1, R) : CR; U' \<subseteq> U \<rbrakk>\<Longrightarrow>
\<exists> RR. (E,h, p, U', C, 1, RR) : CR \<and> RR \<subseteq> R"
apply (rule_tac U=U and U'=U' in CR_1_subset_reverse_aux)
apply (rule CR_Ufinite) apply assumption+
done

lemma CR_2_subset_reverse_aux[rule_format]:
"finite U \<Longrightarrow>
\<forall> U' R. (E,h, p, U, C, 2, R) : CR \<longrightarrow> U' \<subseteq> U \<longrightarrow>
( \<exists> RR. (E,h, p, U', C, 2, RR) : CR \<and> RR \<subseteq> R)"
apply (induct set: Finites)

apply (rule allI impI)+ apply (rule_tac x="{}" in exI) 
apply (rule conjI) 
apply (simp) apply (rule CR_empty) 
apply simp

apply (rule allI impI)+ 
apply (drule_tac x=x and U="insert x F" in CR_2_reverse)
apply simp apply fast
apply (erule exE conjE)+
apply (rename_tac Raux R')

apply (case_tac "x\<in>U'")
apply (erule_tac x="U'-{x}" in allE)
apply (erule_tac x="Raux" in allE)
apply (rotate_tac 8)
apply (drule mp) apply fastsimp
apply (rotate_tac 8)
apply (drule mp) apply fast
apply (erule exE conjE)+
apply (rule_tac x="RR\<union>R'" in exI)
apply (rule conjI)
apply (rule_tac x=x and U=U' in CR_2)
apply assumption+ apply fast
apply fast

apply (erule_tac x="U'" in allE)
apply (erule_tac x="Raux" in allE)
apply (rotate_tac 8)
apply (drule mp) apply fastsimp
apply (rotate_tac 8)
apply (drule mp) apply fast
apply (erule_tac exE conjE)+
apply fast
done

lemma CR_2_subset_reverse[rule_format]:
"\<lbrakk>(E,h, p, U, C, 2, R) : CR; U' \<subseteq> U \<rbrakk>\<Longrightarrow>
\<exists> RR. (E,h, p, U', C, 2, RR) : CR \<and> RR \<subseteq> R"
apply (rule_tac U=U and U'=U' in CR_2_subset_reverse_aux)
apply (rule CR_Ufinite) apply assumption+
done


lemma CR_3_subset_reverse_aux[rule_format]:
"finite U \<Longrightarrow>
\<forall> U' R. (E,h, p, U, C, 3, R) : CR \<longrightarrow> U' \<subseteq> U \<longrightarrow>
( \<exists> RR. (E,h, p, U', C, 3, RR) : CR \<and> RR \<subseteq> R)"
apply (induct set: Finites)

apply (rule allI impI)+ apply (rule_tac x="{}" in exI) 
apply (rule conjI) 
apply (simp) apply (rule CR_empty) 
apply simp

apply (rule allI impI)+ 
apply (drule_tac x=x and U="insert x F" in CR_3_reverse)
apply simp apply fast
apply (erule exE conjE)+
apply (rename_tac Raux R')

apply (case_tac "x\<in>U'")
apply (erule_tac x="U'-{x}" in allE)
apply (erule_tac x="Raux" in allE)
apply (drule mp) apply fastsimp
apply (drule mp) apply fast
apply (erule exE conjE)+
apply (rule_tac x="RR\<union>R'" in exI)
apply (rule conjI)
apply (rule_tac x=x and U=U' in CR_3)
apply assumption+ apply fast

apply (erule_tac x="U'" in allE)
apply (erule_tac x="Raux" in allE)
apply (drule mp) apply fastsimp
apply (drule mp) apply fast
apply (erule_tac exE conjE)+
apply fast
done

lemma CR_3_subset_reverse[rule_format]:
"\<lbrakk>(E,h, p, U, C, 3, R) : CR; U' \<subseteq> U \<rbrakk>\<Longrightarrow>
\<exists> RR. (E,h, p, U', C, 3, RR) : CR \<and> RR \<subseteq> R"
apply (rule_tac U=U and U'=U' in CR_3_subset_reverse_aux)
apply (rule CR_Ufinite) apply assumption+
done

(*****************************************)

lemma CR_11_singleton: 
"\<lbrakk>(E, h, p, {x}, G, 1, R) \<in> CR\<rbrakk> \<Longrightarrow> (E, h, p', {x}, G, 1, R) \<in> CR"
apply (drule_tac U="{x}" and x=x in CR_1_reverse)
apply simp apply simp 
apply (erule exE conjE)+
apply (rename_tac R'' R')
apply (subgoal_tac "(E, h, p', {x}, G, 1, R''\<union> R') \<in> CR")
apply simp
apply (rule_tac x=x in CR_1)
apply simp apply (drule CR_emptyU) apply simp
apply (rule CR_empty)
apply simp apply assumption+
done

lemma CR_12_singleton: 
"\<lbrakk>(E, h, p, {x}, G, 1, R) \<in> CR\<rbrakk> \<Longrightarrow> (E, h, p', {x}, G, 2, R) \<in> CR"
apply (drule_tac U="{x}" and x=x in CR_1_reverse)
apply simp apply simp 
apply (erule exE conjE)+
apply (rename_tac R'' R')
apply (subgoal_tac "(E, h, p', {x}, G, 2, R''\<union> R') \<in> CR")
apply simp
apply (rule_tac x=x in CR_2)
apply simp apply (drule CR_emptyU) apply simp
apply (rule CR_empty)
apply simp 
apply (drule_tac p=p' in  reg_ua_WeakTrue)
apply assumption apply fast
done

lemma CR_13_singleton: 
"\<lbrakk>(E, h, p, {x}, G, 1, R) \<in> CR\<rbrakk> \<Longrightarrow> (E, h, p', {x}, G, 3, R) \<in> CR"
apply (drule_tac U="{x}" and x=x in CR_1_reverse)
apply simp apply simp 
apply (erule exE conjE)+
apply (rename_tac R'' R')
apply (subgoal_tac "(E, h, p', {x}, G, 3, R''\<union> R') \<in> CR")
apply simp
apply (rule_tac x=x in CR_3)
apply simp apply (drule CR_emptyU) apply simp
apply (rule CR_empty)
apply simp 
apply (drule_tac p=False in  reg_ua_WeakTrue)
apply assumption
done

(***)

lemma CR_2True1_singleton: 
"\<lbrakk>(E, h, True, {x}, G, 2, R) \<in> CR\<rbrakk> \<Longrightarrow> (E, h, p', {x}, G, 1, R) \<in> CR"
apply (drule_tac U="{x}" and x=x in CR_2_reverse)
apply simp apply simp 
apply (erule exE conjE)+
apply (rename_tac R'' R')
apply (subgoal_tac "(E, h, p', {x}, G, 1, R''\<union> R') \<in> CR")
apply simp
apply (rule_tac x=x in CR_1)
apply simp apply (drule CR_emptyU) apply simp
apply (rule CR_empty)
apply simp apply assumption apply fast
done


lemma CR_23_singleton: 
"\<lbrakk>(E, h, p, {x}, G, 2, R) \<in> CR\<rbrakk> \<Longrightarrow> (E, h, p', {x}, G, 3, R) \<in> CR"
apply (drule_tac U="{x}" and x=x in CR_2_reverse)
apply simp apply simp 
apply (erule exE conjE)+
apply (rename_tac R'' R')
apply (subgoal_tac "(E, h, p', {x}, G, 3, R''\<union> R') \<in> CR")
apply simp
apply (rule_tac x=x in CR_3)
apply simp apply (drule CR_emptyU) apply simp
apply (rule CR_empty)
apply simp 
apply (drule_tac p=p in  reg_ua_WeakFalse)
apply assumption
done

lemma CR_32_singleton: 
"\<lbrakk>(E, h, p, {x}, G, 3, R) \<in> CR\<rbrakk> \<Longrightarrow> (E, h, False, {x}, G, 2, R) \<in> CR"
apply (drule_tac U="{x}" and x=x in CR_3_reverse)
apply simp apply simp 
apply (erule exE conjE)+
apply (rename_tac R'' R')
apply (subgoal_tac "(E, h, False, {x}, G, 2, R''\<union> R') \<in> CR")
apply simp
apply (rule_tac x=x in CR_2)
apply simp apply (drule CR_emptyU) apply simp
apply (rule CR_empty)
apply simp 
apply assumption apply fast
done

(*********************************)

lemma CR_32False[rule_format]:
"(E, h, p, U, G, i, R) \<in> CR \<Longrightarrow> i=3 \<longrightarrow> (E, h, False, U, G, 2, R) \<in> CR"
apply (erule CR.induct)

apply (rule impI) apply (rule CR_empty)
apply simp apply simp 

apply (rule impI) 
apply (drule mp) apply simp
apply (rule_tac x=x in CR_2)
apply assumption+ apply fast
done
(**********)

lemma CR_inHeap [rule_format]:
"(E, h, p, U, G, i, R) \<in> CR \<Longrightarrow>
R \<subseteq> Dom h"
apply (erule CR.induct)
apply simp
apply (drule region_ua_in_heap, fast)+
done

(******)

constdefs modify::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"modify R h hh == \<forall> l . (l: Dom h - R \<longrightarrow> sameOH {l} h hh)"


lemma modify_monot:
"\<lbrakk>modify M h hh; M\<subseteq>M'\<rbrakk> \<Longrightarrow> modify M' h hh"
apply (unfold modify_def)
apply (rule allI)
apply (rule impI)
apply (erule_tac x=l in allE)
apply (drule mp)
apply fast
apply assumption
done

lemma nonmodify_sameHeap:
"\<lbrakk>modify M h hh; R \<inter> M = {}; R \<subseteq> Dom h \<rbrakk> \<Longrightarrow> sameOH R h hh"
apply (simp only: modify_def sameOH_def)
apply (rule allI impI)+
apply (erule_tac x=l in allE)
apply (drule mp) apply fast+ 
done


lemma CR_nonmodify: "\<lbrakk>modify M h hh;
(E, h, p, U, G, i, R) \<in> CR;
R \<inter> M ={}\<rbrakk> \<Longrightarrow> (E, hh, p, U, G, i, R) \<in> CR"
apply (rule_tac h=h in CR_sameHeap)
apply assumption
apply (rule_tac h=h and hh=hh and M=M in nonmodify_sameHeap)
apply assumption+
apply (rule CR_inHeap) apply assumption
done

(*****************)

lemma CR_updEnv [rule_format]:
"(E, h, p, U, G, i, R) \<in> CR \<Longrightarrow>
x \<notin> U \<longrightarrow> (E\<lfloor>x:=r\<rfloor>, h, p, U, G, i, R) \<in> CR"
apply (erule CR.induct)

apply (rule impI) apply (rule CR_empty)

apply (rule impI)  
apply (drule mp) apply fast
apply (rule CR_1) apply assumption+
apply (rename_tac x')
apply (subgoal_tac "x  \<noteq> x'")
apply simp apply fast apply assumption

apply (rule impI)  
apply (drule mp) apply fast
apply (rule CR_2) apply assumption+
apply (rename_tac x')
apply (subgoal_tac "x  \<noteq> x'")
apply simp apply fast apply assumption

apply (rule impI)  
apply (drule mp) apply fast
apply (rule CR_3) apply assumption+
apply (rename_tac x')
apply (subgoal_tac "x  \<noteq> x'")
apply simp apply fast
done



end



