theory TreeVCG = DAss_ListrulesT2 + DAss_TreerulesT2 + DAss_ResultrulesT2:

lemma regionsExist3:
"\<lbrakk>regionsExist U D h E; \<forall> x T. x:U \<longrightarrow> GETr C x = Some T \<longrightarrow> GETr D x = Some T\<rbrakk> \<Longrightarrow> regionsExist U C h E"
apply (simp add: regionsExist_def, clarsimp)
apply (erule_tac x=x in allE)+
apply clarsimp
apply (drule DOM_GETrSome, clarify)
apply (subgoal_tac "x: DOM D", simp)
apply (erule_tac x=T in allE, clarsimp)
apply (erule GETrSome_DOM)
done

lemma regionsDistinct3:
"\<lbrakk>regionsDistinct U D h E; \<forall> x T. x:U \<longrightarrow> GETr C x = Some T \<longrightarrow> GETr D x = Some T\<rbrakk> \<Longrightarrow> regionsDistinct U C h E"
apply (simp add: regionsDistinct_def, clarsimp)
apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, safe)
apply (erule_tac x=x in allE,clarsimp) apply (rule DOM_GETr_DOM, assumption, assumption) 
  apply (drule DOM_GETrSome, clarsimp) 
apply (erule_tac x=xx in allE,clarsimp) apply (rule DOM_GETr_DOM, assumption, assumption)
  apply (rotate_tac 2, drule DOM_GETrSome, clarsimp) 
apply (erule_tac x=x in allE, clarsimp) 
  apply (drule DOM_GETrSome, fastsimp) 
apply (erule_tac x=xx in allE, clarsimp) 
  apply (rotate_tac 2, drule DOM_GETrSome, fastsimp) 
done

lemma distinctFrom3:
"\<lbrakk>distinctFrom U D h E R; \<forall> x T. x:U \<longrightarrow> GETr C x = Some T \<longrightarrow> GETr D x = Some T\<rbrakk> \<Longrightarrow> distinctFrom U C h E R"
apply (simp add: distinctFrom_def, clarsimp)
apply ((erule_tac x=x in allE)+, clarsimp)
apply (frule DOM_GETrSome, clarsimp)
apply (erule impE)
apply (rule DOM_GETr_DOM, assumption, assumption)
apply simp
apply fast
done

lemma modified3:
"\<lbrakk>modified F U C h E hh; \<forall> x T. x:U \<longrightarrow> GETr C x = Some T \<longrightarrow> GETr D x = Some T\<rbrakk> \<Longrightarrow> modified F U D h E hh"
apply (simp add: modified_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (erule_tac x=z in allE, clarsimp)
apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, safe)
 apply (rule DOM_GETr_DOM, assumption, assumption) apply (drule DOM_GETrSome, clarsimp)
 apply (drule DOM_GETrSome, fastsimp)
done

lemma Bounded3:
"\<lbrakk>Bounded R F U C h E; \<forall> x T. x:U \<longrightarrow> GETr C x = Some T \<longrightarrow> GETr D x = Some T\<rbrakk> \<Longrightarrow> Bounded R F U D h E"
apply (simp add: Bounded_def, rule, rule)
apply (erule_tac x=l in allE, erule impE, simp)
apply (erule disjE, simp)
apply (rule disjI2)
apply clarsimp
apply (erule_tac x=x in allE, clarsimp)
apply (rule_tac x=x in exI, safe)
 apply (rule DOM_GETr_DOM, assumption, assumption) apply (drule DOM_GETrSome, clarsimp)
 apply (drule DOM_GETrSome, fastsimp)
done

lemma ContextSize3[rule_format]:
"(E,h,U,D,n) : ContextSize \<Longrightarrow> (regionsExist U D h E \<longrightarrow> ((\<forall> x T. x:U \<longrightarrow> GETr C x = Some T \<longrightarrow> GETr D x = Some T) \<longrightarrow> (\<forall> x . x: DOM D \<and> x:U \<longrightarrow> x:DOM C) \<longrightarrow> (E,h,U,C,n) : ContextSize))"
apply (erule ContextSize.induct, clarsimp)
apply (rule ContextSizeNIL, clarsimp+)
apply (subgoal_tac "\<exists> RR nn. (RVal (renv E x), h, GETr C x, RR, nn) \<in> reg", clarsimp)
apply (rule ContextSizeCONS, assumption, assumption)
  apply (erule impE) apply (erule regionsExist_antimonotone,fast) apply assumption
apply (rotate_tac -1, frule reg_DOM)
apply (rotate_tac -1, frule DOM_GETrSome, clarsimp)
apply (erule_tac x=x in allE, clarsimp)
apply (frule reg_Unique) apply (rotate_tac 2, assumption)
apply clarsimp
apply (frule regionsExist3) apply clarsimp
apply (erule_tac x=xa in allE, clarsimp)
apply (erule_tac x=T in allE, rotate_tac -1, erule impE) apply assumption
apply assumption
apply (simp add: regionsExist_def)
apply (rotate_tac -1 )apply (erule_tac x=x in allE, erule impE)
prefer 2 apply assumption
apply clarsimp
apply (drule reg_DOM)
apply fast
done

lemma restrDOM[rule_format]: "x:set S \<Longrightarrow> (\<forall> C . x:DOM C \<longrightarrow> x:DOM (restr C S))"
apply clarsimp
apply (drule DOM_GETrSome, clarsimp)
apply (rule GETrSome_DOM)
apply (subgoal_tac "GETr C x = GETr (restr C S) x", clarsimp, simp)
apply (erule RestrIn)
done

lemma DAssC_Contexts_implies_on_U:
"\<lbrakk>\<lbrace>U, n, C \<guillemotright> T, m\<rbrace> E h hh v p; \<forall> x. x:U \<longrightarrow> (\<forall> T. GETr C x = Some T \<longrightarrow> GETr D x = Some T); \<forall> x . x: DOM D \<and> x:U \<longrightarrow> x:DOM C\<rbrakk> \<Longrightarrow> \<lbrace>U, n, D \<guillemotright> T, m\<rbrace> E h hh v p"
apply (simp add: DAssComplex_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist3, clarsimp)
apply (erule regionsDistinct3, clarsimp)
apply (erule distinctFrom3, clarsimp)
apply (erule ContextSize3, assumption) apply fast apply fast
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified3, clarsimp)
apply (erule Bounded3, fastsimp)+
done

subsubsection {* Logical rules*}
lemma DAss_monotone_in_U:
"\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p; U \<subseteq> UU\<rbrakk> \<Longrightarrow> \<lbrace>UU, n, C \<ggreater> T, m\<rbrace> E h hh v p"
(*<*)by (rule DAss_Eq2, rule DAssC_monotone_in_U, erule DAss_Eq1, assumption)(*>*)

lemma DA_Weak: "\<lbrakk>G \<rhd> e : \<lbrace> U , n , C \<ggreater> T , m\<rbrace>; U \<subseteq> UU\<rbrakk> \<Longrightarrow> G \<rhd> e : \<lbrace>UU, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_Weak, erule DA_Eq1, assumption)(*>*)

lemma DAss_Contexts_same_on_U:
"\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> \<lbrace>U, n, D \<ggreater> T, m\<rbrace> E h hh v p"
(*<*)by (rule DAss_Eq2, rule DAssC_Contexts_same_on_U, erule DAss_Eq1, assumption)(*>*)

lemma DA_Contexts_same_on_U:
"\<lbrakk>G \<rhd> e: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> G \<rhd> e: \<lbrace>U, n, D \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_Contexts_same_on_U, erule DA_Eq1, assumption)(*>*)

lemma DAss_Contexts_implies_on_U:
"\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p; 
  \<forall> x. x:U \<longrightarrow> (\<forall> T. GETr C x = Some T \<longrightarrow> GETr D x = Some T);
  \<forall> x . x: DOM D \<and> x:U \<longrightarrow> x:DOM C
 \<rbrakk> \<Longrightarrow> \<lbrace>U, n, D \<ggreater> T, m\<rbrace> E h hh v p"
(*<*)by (rule DAss_Eq2, rule  DAssC_Contexts_implies_on_U, erule DAss_Eq1, assumption)(*>*)

lemma DA_Contexts_implies_on_U:
"\<lbrakk>G \<rhd> e: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; 
  \<forall> x. x:U \<longrightarrow> (\<forall> T. GETr C x = Some T \<longrightarrow> GETr D x = Some T);
  \<forall> x . x: DOM D \<and> x:U \<longrightarrow> x:DOM C\<rbrakk> \<Longrightarrow> G \<rhd> e: \<lbrace>U, n, D \<ggreater> T, m\<rbrace>"
(*<*)
by (erule vdm_conseq, clarsimp, drule  DAss_Contexts_implies_on_U, assumption+) (*>*)

lemma DAss_Generalise:
 "\<lbrakk>\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p;  n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>  \<Longrightarrow> \<lbrace>UU, nn, C \<ggreater> T, mm\<rbrace> E h hh v p"
(*<*)by (rule DAss_Eq2, rule DAssC_Generalise, erule DAss_Eq1, assumption+)(*>*)

lemma DA_Generalise: 
"\<lbrakk>G \<rhd> e:\<lbrace>U, n, C \<ggreater> T, m\<rbrace>; n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>
 \<Longrightarrow> G \<rhd> e: \<lbrace>UU, nn, C \<ggreater> T, mm\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_Generalise, erule DA_Eq1, assumption+)(*>*)

lemma DAss_Const: "\<lbrakk>\<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p; nn = n + k; mm = m + k\<rbrakk> \<Longrightarrow> \<lbrace>U, nn, G \<ggreater> T, mm\<rbrace> E h hh v p"
(*<*)by (rule DAss_Eq2, rule DAssC_Const, erule DAss_Eq1, assumption+)(*>*)

lemma DA_Const: "\<lbrakk>G \<rhd> e: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; nn = n + k; mm = m + k\<rbrakk> \<Longrightarrow> G \<rhd> e: \<lbrace>U, nn, C \<ggreater> T, mm\<rbrace>"
(*<*)
by (rule DA_Eq2, rule DA_C_Const, erule DA_Eq1, assumption+)(*>*)

lemma DAss_PConst0: "\<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p = \<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v pp"
(*<*)by (simp add: DAssC_PConst0 DAss_Eq)(*>*)

lemma DAss_PConst: "\<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p \<Longrightarrow> \<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v pp"
(*<*)by (rule DAss_Eq2, rule DAssC_PConst, erule DAss_Eq1)(*>*)

subsubsection {*Rules for primitive operations*}
lemma DA_NullTree: "\<lbrakk>n=m+kL\<rbrakk> \<Longrightarrow> G \<rhd> Null: \<lbrace>{}, n, C \<ggreater> TreeET kL kN, m\<rbrace>"
(*<*) by (rule DA_Eq2, erule DA_C_NullTree) (*>*)

lemma DA_NullList: "n=m+kN \<Longrightarrow> G \<rhd> Null: \<lbrace>{}, n, C \<ggreater> ListET kN kC, m\<rbrace>"
(*<*) by (rule DA_Eq2, rule DA_C_NullList) (*>*)

lemma DA_NullRes: "\<lbrakk>n=m+kN\<rbrakk> \<Longrightarrow> GG \<rhd> Null: \<lbrace>{}, n, G \<ggreater> ResultET kN T kS, m\<rbrace>"
(*<*) by (rule DA_Eq2, drule DA_C_NullRes, assumption+) (*>*)

lemma DA_Null: "\<lbrakk>T \<notin> {UnitET, IntET}; n = k+m; 
                   \<forall> kL kN. T = TreeET kL kN \<longrightarrow> k = kL;
                   \<forall> kN TT kS. T = ResultET kN TT kS \<longrightarrow> k=kN;
                   \<forall> kN kC. T = ListET kN kC \<longrightarrow> k=kN\<rbrakk> \<Longrightarrow> GG \<rhd> Null: \<lbrace>{}, n, G \<ggreater> T, m\<rbrace>"
(*<*)  by (rule DA_Eq2, drule DA_C_Null, assumption+) (*>*)

lemma DA_Int: "\<lbrakk>T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> expr.Int i: \<lbrace>{}, n, G \<ggreater> T, n\<rbrace>"
(*<*)by (rule DA_Eq2, drule DA_C_Int, assumption+) (*>*)

lemma DA_IVar: "\<lbrakk>T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> IVar x: \<lbrace>{}, n, G \<ggreater> T, n\<rbrace>"
(*<*)by (rule DA_Eq2, drule DA_C_IVar, assumption+) (*>*)

lemma DA_RVar: "\<lbrakk>GETr G x = Some T\<rbrakk> \<Longrightarrow> GG \<rhd> RVar x: \<lbrace>{x}, n, G \<ggreater> T, n\<rbrace>"
(*<*) by (rule DA_Eq2, drule DA_C_RVar, assumption+) (*>*)

lemma DA_Prim: "\<lbrakk>T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> Primop f x y: \<lbrace>{}, n, G \<ggreater> T, n\<rbrace>"
(*<*)by (rule DA_Eq2, drule DA_C_Prim, assumption+) (*>*)

lemma DA_Rprim:
"\<lbrakk>x: DOM G; y:DOM G; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> RPrimop f x y: \<lbrace>{x,y}, n, G \<ggreater> T, n\<rbrace>"
(*<*)by (rule DA_Eq2, drule DA_C_Rprim, assumption+) (*>*)

subsubsection {*Rules for program compositions and conditionals*}
lemma DA_Letv:
      "\<lbrakk>G \<rhd> e : \<lbrace>U1, n, C \<ggreater> T1, m\<rbrace>; G \<rhd> ee : \<lbrace>U2, m, C \<ggreater> T2, k\<rbrace>;
        T1 = UnitET; U1 \<inter> U2 = {}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): \<lbrace>U1 \<union> U2, n, C \<ggreater> T2, k\<rbrace>"
(*<*) by (rule DA_Eq2, rule DA_C_Letv, erule DA_Eq1, erule DA_Eq1, assumption+)
lemma DA_letv:
      "\<lbrakk>G \<rhd> e : \<lbrace>U1, n, C \<ggreater> T1, m\<rbrace>;
        G \<rhd> ee : \<lbrace>U2, m, C \<ggreater> T2, k\<rbrace>; T1 = UnitET;
        U1 \<inter> U2 = {}; UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): \<lbrace>UU, n, C \<ggreater> T2, k\<rbrace>"
by (rule DA_Eq2, rule DA_C_letv, erule DA_Eq1, erule DA_Eq1, assumption+)
(*>*)

lemma DA_Leti:
      "\<lbrakk>G \<rhd> e : \<lbrace>U1, n, C \<ggreater> T1, m\<rbrace>;
        G \<rhd> ee : \<lbrace>U2, m, C \<ggreater> T2, k\<rbrace> ;
        U1 \<inter> U2 = {}; T1 = IntET\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET x = e IN ee END): \<lbrace>U1 \<union> U2, n, C \<ggreater> T2, k\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_Leti, erule DA_Eq1, erule DA_Eq1, assumption+)
lemma DA_leti:
      "\<lbrakk>G \<rhd> e : \<lbrace>U1, n, C \<ggreater> T1, m\<rbrace>;
        G \<rhd> ee : \<lbrace>U2, m, C \<ggreater> T2, k\<rbrace>;
        U1 \<inter> U2 = {}; T1 = IntET; UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET x = e IN ee END): \<lbrace>UU, n, C \<ggreater> T2, k\<rbrace>"
by (rule DA_Eq2, rule DA_C_leti, erule DA_Eq1, erule DA_Eq1, assumption+)
(*>*)

lemma DA_Letr:
     "\<lbrakk> G \<rhd> e : \<lbrace>U1, n, C \<ggreater> T1, m\<rbrace>;
        G \<rhd> ee : \<lbrace>U2, m, C(x\<mapsto>\<^sub>fT1) \<ggreater> T2, k\<rbrace>;
        U1 \<inter> (U2-{x}) = {}; T1 \<notin> {IntET, UnitET}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = e IN ee END): \<lbrace>U1 \<union> (U2-{x}), n, C \<ggreater> T2, k\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_Letr, erule DA_Eq1, erule DA_Eq1, assumption+)
lemma DA_letr:
     "\<lbrakk> G \<rhd> e : \<lbrace>U1, n, C \<ggreater> T1, m\<rbrace> ;
        G \<rhd> ee : \<lbrace>U2, m, C(x\<mapsto>\<^sub>fT1) \<ggreater> T2, k\<rbrace>;
        U1 \<inter> (U2-{x}) = {}; T1 \<notin> {IntET, UnitET} ;UU=(U1 \<union> (U2-{x}))\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = e IN ee END): \<lbrace>UU, n, C \<ggreater> T2, k\<rbrace>"
by (rule DA_Eq2, rule DA_C_letr, erule DA_Eq1, erule DA_Eq1, assumption+)
(*>*)

lemma DA_If: 
     "\<lbrakk>G \<rhd> e1 : \<lbrace>U1, n, C \<ggreater> T, m\<rbrace>; G \<rhd> e2 : \<lbrace>U2, n, C \<ggreater> T, m\<rbrace>\<rbrakk>
     \<Longrightarrow> G \<rhd> (IF b THEN e1 ELSE e2): \<lbrace>U1 \<union> U2, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_If, erule DA_Eq1, erule DA_Eq1)
lemma DA_if: 
     "\<lbrakk> G \<rhd> e1 : \<lbrace>U1, n, C \<ggreater> T, m\<rbrace>; G \<rhd> e2 : \<lbrace>U2, n, C \<ggreater> T, m\<rbrace>;UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (IF b THEN e1 ELSE e2): \<lbrace>UU, n, C \<ggreater> T, m\<rbrace>"
by (rule DA_Eq2, rule DA_C_if, erule DA_Eq1, erule DA_Eq1)
(*>*)

subsubsection {* Rules for let-primop combinations *}
lemma DA_Let_Null: 
  "\<lbrakk>G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fT1) \<ggreater> T2, k\<rbrace>;
   G \<rhd> Null : \<lbrace>{}, n, C \<ggreater> T1, m\<rbrace>; T1 \<notin> {IntET, UnitET}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = Null IN e END): \<lbrace>U-{x}, n, C \<ggreater> T2, k\<rbrace>"
(*<*)by (erule DA_letr, simp+)(*>*)

lemma DA_Let_Int:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = expr.Int i IN e END): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule DA_Eq2, rule DA_C_Let_Int, erule DA_Eq1)(*>*)

lemma DA_Let_Prim:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = Primop f x y IN e END): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_Let_Prim, erule DA_Eq1)(*>*)

lemma DA_Let_RPrim:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; x : DOM C; y : DOM C
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): \<lbrace>{x,y} \<union> U, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_Let_RPrim, erule DA_Eq1)
lemma DA_Let_rprim:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; x : DOM C; y : DOM C; UU = ({x,y} \<union> U)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): \<lbrace>UU, n, C \<ggreater> T, m\<rbrace>"
by (rule DA_Eq2, rule DA_C_Let_rprim, erule DA_Eq1)
(*>*)

subsubsection {*Rules for function calls and method invocations*}
lemma DA_Call0:
"\<lbrakk>(G \<union> {(CALL f, \<lambda> E h hh v p . \<exists> pp. tkcall pp = p \<and> \<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v pp)}) \<rhd> 
   snd(funtable f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow>
 G \<rhd> (CALL f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule vdm_conseq, erule Call1, clarsimp, erule DAss_PConst) (*>*)

lemma DA_Call:
"\<lbrakk>(G \<union> {(CALL f, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)}) \<rhd> snd(funtable f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (rule vdm_conseq, rule vdm_call, rule vdm_conseq)
apply (subgoal_tac "(G \<union> {(CALL f, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)}) = ({(CALL f, \<lambda>u ua ub uc ud. \<lbrace>U, n, C \<ggreater> T, m\<rbrace> u ua ub uc ud)} \<union> G)",clarsimp)
apply assumption
apply simp
apply clarsimp apply (erule DAss_PConst)
apply clarsimp 
done
(*>*)

lemma DA_Call2:
"\<lbrakk>G \<rhd> snd(funtable f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (CALL f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_Call2, erule DA_Eq1)
(*by (rule DA_Call, erule CtxtWeak)*)
(*>*)

lemma DA_CutCall:
  "\<lbrakk>rnl = ParList2RnameList (fst(funtable f));
    (CALL f, \<lbrace>U, n, (restr C rnl) \<ggreater>  T, m\<rbrace>) : G; 
    \<forall> x. x:U \<longrightarrow> GETr C x = GETr (restr C rnl) x\<rbrakk>
 \<Longrightarrow> G \<rhd> (CALL f): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*)by(rule DA_Contexts_same_on_U, erule vdm_ax, simp)(*>*)

consts isMergePoint :: "funame \<Rightarrow> bool"
consts dominates::"funame \<Rightarrow> (funame list)"

lemma DA_CutCall1:
  "\<lbrakk>U \<subseteq> set (ParList2RnameList(fst (funtable f))); 
   (CALL f, \<lbrace>U, n, restr C (ParList2RnameList(fst (funtable f))) \<ggreater> T, m\<rbrace>) : G\<rbrakk>
   \<Longrightarrow> G \<rhd> (CALL f): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule DA_Contexts_same_on_U,erule vdm_ax, clarify, rule RestrIn,fast)(*>*)

lemma DA_Call2_MP:"\<lbrakk>\<not> isMergePoint f; G \<rhd> snd(funtable f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (CALL f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Call2)(*>*)

lemma DA_CutCall1_MP[rule_format]:
  "\<lbrakk>isMergePoint f; (CALL f, \<lbrace>U, n, restr C (ParList2RnameList(fst (funtable f))) \<ggreater> T, m\<rbrace>) : G;
    U \<subseteq> set (ParList2RnameList(fst (funtable f)))\<rbrakk>
  \<Longrightarrow> G \<rhd> (CALL f): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (erule DA_CutCall1, assumption)(*>*)
(*A more specific variant that set U=\<lbrace>set (ParList2RnameList(fst (funtable f)))*)
lemma DA_CutCall3_MP[rule_format]:
  "\<lbrakk>isMergePoint f; (CALL f, \<lbrace>set (ParList2RnameList(fst (funtable f))), n, restr C (ParList2RnameList(fst (funtable f))) \<ggreater> T, m\<rbrace>) : G\<rbrakk>
  \<Longrightarrow> G \<rhd> (CALL f): \<lbrace>set (ParList2RnameList(fst (funtable f))), n, C \<ggreater> T, m\<rbrace>"
(*<*)
by (erule DA_CutCall1_MP, assumption,simp)
(*explicit proof:apply (rule vdm_conseq)
apply (erule vdm_ax)
apply clarsimp
apply (rule DAss_Eq2)
apply (rule DAssC_Contexts_implies_on_U)
apply (erule DAss_Eq1)
apply clarsimp
apply (subgoal_tac "GETr C x = GETr (restr C (ParList2RnameList (fst (funtable f)))) x") apply fastsimp
apply (erule RestrIn)
apply clarsimp
apply (erule restrDOM, assumption)
done
*)
(*>*)

consts DOM_Call::"(funame list \<times> vdmcontext \<times> funame \<times> vdmassn) set"
inductive DOM_Call intros
DOM_CallNIL [intro]: "\<lbrakk>G \<rhd> snd(funtable f):P; finite G\<rbrakk> \<Longrightarrow> ([],G,f,P) : DOM_Call"
DOM_CallCONS [intro]: "\<lbrakk>(t,{(Call h, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)} \<union> G,f,P):DOM_Call; 
                        G \<rhd> snd(funtable h): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk>
                      \<Longrightarrow> ( h # t, G, f, P):DOM_Call"

lemma DOM_Call_Sound[rule_format]:
   "(L,G,f,P):DOM_Call \<Longrightarrow> (\<forall> U n C T m . P = \<lbrace>U, n, C \<ggreater> T, m\<rbrace> \<longrightarrow> finite G \<and> G \<rhd> Call f: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)"
(*<*)
apply (erule DOM_Call.induct)
apply clarsimp
apply (erule DA_Call2) 
apply clarsimp
apply (erule_tac x=Ua in allE, erule_tac x=na in allE, erule_tac x=Ca in allE, 
       erule_tac x=Ta in allE, erule_tac x=ma in allE, clarsimp)
apply (rule cut2) prefer 2 apply assumption apply fastsimp+
apply (simp add: contextProvable_def, clarsimp)
apply safe
apply (erule DA_Call2)
apply (erule vdm_ax)
done
(*>*)

lemma DA_Call1_MP:
  "\<lbrakk>(\<not> isMergePoint f \<and> (dominates f, G, f, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>):DOM_Call) \<or>
    (isMergePoint f \<and>  (CALL f, \<lbrace>U, n, restr C (ParList2RnameList(fst (funtable f))) \<ggreater> T, m\<rbrace>) : G \<and> U \<subseteq> set (ParList2RnameList(fst (funtable f))))\<rbrakk>
  \<Longrightarrow> G \<rhd> (CALL f): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*)
apply (erule disjE)
apply clarsimp apply (frule DOM_Call_Sound) apply simp apply simp 
apply clarsimp apply (erule DA_CutCall1_MP, assumption+)
done
(*>*)

(*Again a more specific variant that sets U = ..*)
lemma DA_Call3_MP:
  "\<lbrakk>(\<not> isMergePoint f \<and> (dominates f, G, f, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>):DOM_Call) \<or>
    (isMergePoint f \<and> U = set (ParList2RnameList(fst (funtable f)))) \<and> (CALL f, \<lbrace>U, n, restr C (ParList2RnameList(fst (funtable f))) \<ggreater> T, m\<rbrace>) : G\<rbrakk>
  \<Longrightarrow> G \<rhd> (CALL f): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Call1_MP,fast)(*>*)

lemma DA_Invs:
"\<lbrakk>({(c\<bullet>mn(args), \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)} \<union> G) \<rhd> (snd (methtable c mn)) :  
    (\<lambda> E h hh v p  . \<forall> E'. E = newframe_env Nullref (fst (methtable c mn)) args E'  \<longrightarrow> 
                     (\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E' h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (c\<bullet>mn(args)) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>" 
(*<*)by (rule vdm_conseq, erule vdm_invokestatic, clarsimp)(*>*)

lemma Invoke:
  "\<lbrakk>(c\<bullet>M(L), sMST c M L): G;
     \<forall> E h hh v p. sMST c M L E h hh v p \<longrightarrow> \<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p;
     \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk>
  \<Longrightarrow> G \<rhd>  (c\<bullet>M(L)) : \<lbrace>U, n, D \<ggreater> T, m\<rbrace> "
(*<*)
apply (rule vdm_conseq)  apply(rule vdm_ax) apply simp apply clarsimp 
apply (rule DAss_Contexts_same_on_U) 
apply fast apply fastsimp 
done
(*>*)

lemma DA_InvokeConst: 
  "\<lbrakk>(c\<bullet>M(L), sMST c M L): G;
     \<forall> E h hh v p. sMST c M L E h hh v p \<longrightarrow> \<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p;
     \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x;
     nk = n+k; mk = m+ k\<rbrakk>
  \<Longrightarrow> G \<rhd>  (c\<bullet>M(L)) : \<lbrace>U, nk, D \<ggreater> T, mk\<rbrace>"
(*<*)by (rule DA_Const, erule Invoke, fastsimp+)(*>*)

lemma DA_Letr_InvokeConst: 
  "\<lbrakk>(c\<bullet>M(L), sMST c M L): G;
     \<forall> E h hh v p. sMST c M L E h hh v p \<longrightarrow> \<lbrace>U, n, C \<ggreater> T1, m\<rbrace> E h hh v p;
     \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x;
     nk = n+k; mk = m+ k; T1 \<notin> {IntET, UnitET};
     G \<rhd> e : \<lbrace>V, mk, D(x\<mapsto>\<^sub>fT1) \<ggreater> T, l\<rbrace>;
     U \<inter> (V-{x})={};
     W = U \<union> (V-{x}) \<rbrakk>
   \<Longrightarrow> G \<rhd>  (LET rf x = c\<bullet>M(L) IN e END) : \<lbrace>W, nk, D \<ggreater> T, l\<rbrace>"
(*<*)by (rule DA_letr, erule DA_InvokeConst, assumption+)(*>*)

lemma DA_Leti_InvokeConst: 
  "\<lbrakk>(c\<bullet>M(L), sMST c M L): G;
     \<forall> E h hh v p. sMST c M L E h hh v p \<longrightarrow> \<lbrace>U, n, C \<ggreater> IntET, m\<rbrace> E h hh v p;
     \<forall> y. y:U \<longrightarrow> GETr D y = GETr C y;
     nk = n+k; mk = m+ k;
     G \<rhd> e : \<lbrace>V, mk, D \<ggreater> T, l\<rbrace>;
     U \<inter> V={};
     W = U \<union> V \<rbrakk>
   \<Longrightarrow> G \<rhd>  (LET  x = c\<bullet>M(L) IN e END) : \<lbrace>W, nk, D \<ggreater> T, l\<rbrace>"
(*<*)by (rule DA_leti, erule DA_InvokeConst, assumption+, simp, assumption)(*>*)

subsubsection {*Rules for freelist management*}
text {*The rules for free, alloc, and fill are only used internally. See file DAss_rulesT2.*}

subsubsection{*Rules for the list datatype*}
lemma DA_Let_HD: 
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; GETr C x = Some(ListET kN kC)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET h = GetFi x V0 IN e END): \<lbrace>{x} \<union> U, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule DA_Eq2, rule DA_C_Let_HD, erule DA_Eq1,assumption)
lemma DA_Let_hd: 
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>;
    UU=({x} \<union> U); GETr C x = Some (ListET kN kC)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET h = GetFi x V0 IN e END): \<lbrace>UU, n, C \<ggreater> T, m\<rbrace>"
 by (rule DA_Eq2, rule DA_C_Let_hd, erule DA_Eq1,assumption)
(*>*)

lemma DA_Let_TL: 
  "\<lbrakk>GETr C y = Some (ListET kN kC); nk = n+kC; 
    G \<rhd> e : \<lbrace>U, nk, C(x\<mapsto>\<^sub>f(ListET kN kC)) \<ggreater> T, m\<rbrace>;
    y \<notin> U - {x}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = GetFr y R1 IN e END) : \<lbrace>(U-{x}) \<union> {y}, n, C \<ggreater> T, m\<rbrace>"
(*<*) 
by (rule DA_Eq2, erule DA_C_Let_TL, assumption, erule DA_Eq1,assumption)
lemma DA_Let_tl: 
  "\<lbrakk>GETr C y = Some (ListET kN kC); nk = n+kC; y \<notin> U; 
    G \<rhd> e : \<lbrace>U, nk, C(x\<mapsto>\<^sub>f(ListET kN kC)) \<ggreater> T, m\<rbrace>; UU=((U-{x}) \<union> {y})\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = GetFr y R1 IN e END) : \<lbrace>UU, n, C \<ggreater> T, m\<rbrace>"
by (rule DA_Eq2, erule DA_C_Let_tl, assumption+, erule DA_Eq1,assumption+)
(*>*)

lemma DA_ListMatch: 
  "\<lbrakk>GETr C l = Some (ListET kN kC); nk = n+kC; 
    G \<rhd> e : \<lbrace>U, nk, C(t\<mapsto>\<^sub>f(ListET kN kC)) \<ggreater> T, m\<rbrace>;
    l \<notin> U - {t}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l V0; rf t = GetFr l R1 IN e END) : \<lbrace>(U-{t}) \<union> {l}, n, C \<ggreater> T, m\<rbrace>"
by (rule DA_Eq2, erule DA_C_ListMatch, assumption+, erule DA_Eq1,assumption+)

lemma DA_ListMatchD: 
  "\<lbrakk>GETr C l = Some (ListET kN kC); nk = n+kC+1; 
    G \<rhd> e : \<lbrace>U, nk, C(t\<mapsto>\<^sub>f(ListET kN kC)) \<ggreater> T, m\<rbrace>;
    l \<notin> U; l \<noteq> t\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l V0; rf t = GetFr l R1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END) : \<lbrace>(U-{t}) \<union> {l}, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Eq2, erule DA_C_ListMatchD, assumption+, erule DA_Eq1,assumption+)(*>*)

lemma DA_MakeList:
"\<lbrakk>GETr C y = Some (ListET kN kC);n=(Suc m + kC)\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg x, RNarg y])) : \<lbrace>{y}, n, C \<ggreater> ListET kN kC, m\<rbrace>"
by (rule DA_Eq2, erule DA_C_MakeList, auto)
lemma DA_makeList: 
"\<lbrakk>GETr C y = Some (ListET kN kC);n=(Suc m + kC);U={y}\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg x, RNarg y])) : \<lbrace>U, n, C \<ggreater> ListET kN kC, m\<rbrace>"
by (rule DA_Eq2, erule DA_C_makeList, auto)
(*>*)
lemma DA_LetrMakeList: 
"\<lbrakk>GETr C y = Some (ListET kN kC);n=(Suc m + kC);
  G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fListET kN kC) \<ggreater> T, l\<rbrace>; y \<notin> U-{x}; UU={y} \<union> (U-{x})\<rbrakk> \<Longrightarrow>
  G \<rhd> (LET rf x = DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg z, RNarg y])  IN e END) : \<lbrace>UU, n, C \<ggreater> T, l\<rbrace>"
by (rule DA_letr, erule DA_MakeList, simp+)

(*variation for programs with memory leaks*)

lemma DA_C_MakeList_MemLeak:
"\<lbrakk>GETr C y = Some (ListET kN kC);n=(Suc m + kCC);kNN \<le> kN;kCC \<le> kC\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg x, RNarg y])) : \<lbrace>{y}, n, C \<guillemotright> ListET kNN kCC, m\<rbrace>"
apply (rule vdm_invokestatic, simp) 
apply (rule CtxtWeakSingleton)
apply (simp add: Meth_Make_IID DAssComplex_def, clarsimp)
apply (rule vdm_conseq, rule vdm_letr)
apply (rule DA_Alloc)
apply (rule DA_Fill_DIID)
apply clarsimp
apply (simp add: newObj_def newframe_env_def evalARGS_def self_def)
apply (subgoal_tac "y:DOM C") prefer 2 apply (rule GETrSome_DOM) apply simp
apply (case_tac "h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>")
(*h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Nullref*) apply clarsimp
  apply (simp add: freelist_def)
  apply (erule FL.elims, clarsimp)
  apply clarsimp
(*h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<noteq> Nullref*) 
  apply clarsimp
  apply (simp add: freelist_def)
  apply (erule FL.elims, clarify, clarsimp)
  apply (simp add: regionsExist_def,clarsimp) 
  apply (erule reg.elims, simp_all, clarsimp) 
  apply (rule_tac x="R \<union> {a}" in exI)
  apply (rule_tac x="kNN*N+kCC*(Suc Ca)" in exI)
  apply (rule_tac x="n" in exI)
  apply (rule_tac x="X" in exI)
  apply (rule, erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (rule, simp add: distinctFrom_def) apply (erule_tac x=R in allE,erule impE) apply(rule, erule regList, simp) 
    apply (rule regList)
    apply (rule mLIST_CONS) prefer 5 apply (erule mLIST_Preserved) apply (subgoal_tac "l \<noteq> a", simp add: sameOH_def,fast)
      apply simp apply simp apply simp apply clarsimp apply simp apply simp apply simp 
  apply (rule, simp add: modified_def, clarsimp) apply (subgoal_tac "l \<noteq> a", simp add: sameOH_def,fast)
  apply (rule, simp add: distinctFrom_def) apply (erule_tac x=R in allE,erule impE)  apply (rule, erule regList, simp) apply clarsimp
  apply (rule,simp add: Bounded_def,rule, rule) apply (rule disjI2, rule disjI2) apply (rule, rule, rule,erule regList, simp, assumption)
  apply (rule,simp add: Bounded_def)
  apply (drule ContextSize_contains_region) apply fast apply simp apply (erule regList) apply simp
apply simp
apply (subgoal_tac "m + (kNN * N + (kCC + kCC * Ca)) + q \<le> m + kCC + CS + q") apply simp
apply simp 
apply (subgoal_tac "kCC * Ca \<le> kC * Ca") 
apply (subgoal_tac "kNN * N \<le> kN * N") apply arith apply simp apply simp
done

lemma DA_C_makeList_MemLeak: 
"\<lbrakk>GETr C y = Some(ListET kN kC);n=(Suc m + kCC);kNN \<le> kN;kCC \<le> kC;U={y}\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg x, RNarg y])) : \<lbrace>U, n, C \<guillemotright> ListET kNN kCC, m\<rbrace>"
apply (drule DA_C_MakeList_MemLeak) prefer 4 apply simp+
done

lemma DA_MakeList_ml:
"\<lbrakk>GETr C y = Some (ListET kN kC);n=(Suc m + kCC);kNN \<le> kN;kCC \<le> kC\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg x, RNarg y])) : \<lbrace>{y}, n, C \<ggreater> ListET kNN kCC, m\<rbrace>"
(*<*)by (rule DA_Eq2, erule DA_C_MakeList_MemLeak, simp+)
lemma DA_makeList_ml: 
"\<lbrakk>GETr C y = Some (ListET kN kC);n=(Suc m + kCC);kNN \<le> kN;kCC\<le>kC;U={y}\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg x, RNarg y])) : \<lbrace>U, n, C \<ggreater> ListET kNN kCC, m\<rbrace>"
by (rule DA_Eq2, erule DA_C_makeList_MemLeak, simp+)
(*>*)
lemma DA_LetrMakeList_ml: 
"\<lbrakk>GETr C y = Some (ListET kN kC);n=(Suc m + kCC);kNN \<le> kN; kCC\<le>kC;
  G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fListET kNN kCC) \<ggreater> T, l\<rbrace>; y \<notin> U-{x}; UU={y} \<union> (U-{x})\<rbrakk> \<Longrightarrow>
  G \<rhd> (LET rf x = DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg z, RNarg y])  IN e END) : \<lbrace>UU, n, C \<ggreater> T, l\<rbrace>"
by (rule DA_letr, erule DA_MakeList_ml, simp+)

subsubsection {*Rules for the result datatype*}
lemma DA_Let_ResL: 
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>; GETr C x = Some(ResultET kN TT kS)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET h = GetFi x V0 IN e END): \<lbrace>{x} \<union> U, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule DA_Eq2, rule DA_C_Let_ResL, erule DA_Eq1, assumption)
lemma DA_Let_resL: 
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>;
    UU=({x} \<union> U); GETr C x = Some (ResultET kN TT kS)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET h = GetFi x V0 IN e END): \<lbrace>UU, n, C \<ggreater> T, m\<rbrace>"
by (rule DA_Eq2, rule DA_C_Let_resL, erule DA_Eq1, assumption)
(*>*)

lemma DA_Let_ResR: 
  "\<lbrakk>GETr C y = Some (ResultET kN T kS); nk = n+kS; 
    G \<rhd> e : \<lbrace>U, nk, C(x\<mapsto>\<^sub>fT) \<ggreater> A, m\<rbrace>;
    y \<notin> U - {x}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = GetFr y R1 IN e END) : \<lbrace>(U-{x}) \<union> {y}, n, C \<ggreater> A, m\<rbrace>"
(*<*) by (rule DA_Eq2, rule DA_C_Let_ResR, assumption+, erule DA_Eq1, assumption+)
lemma DA_Let_resr: 
  "\<lbrakk>GETr C y = Some (ResultET kN T kS); nk = n+kS; y \<notin> U; 
    G \<rhd> e : \<lbrace>U, nk, C(x\<mapsto>\<^sub>fT) \<ggreater> A, m\<rbrace>; UU=((U-{x}) \<union> {y})\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = GetFr y R1 IN e END) : \<lbrace>UU, n, C \<ggreater> A, m\<rbrace>"
by (rule DA_Eq2, rule DA_C_Let_resr, assumption+, erule DA_Eq1, assumption+)(*>*)

lemma DA_ResultMatch: 
  "\<lbrakk>GETr C l = Some (ResultET kN TT kS); nk = n+kS; 
    G \<rhd> e : \<lbrace>U, nk, C(t\<mapsto>\<^sub>fTT) \<ggreater> T, m\<rbrace>;
    l \<notin> U - {t}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l V0; rf t = GetFr l R1 IN e END) : \<lbrace>(U-{t}) \<union> {l}, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_ResultMatch, assumption+, erule DA_Eq1, assumption+)(*>*)

lemma DA_ResultMatchD: 
  "\<lbrakk>GETr C l = Some (ResultET kN TT kS); nk = n+kS+1; 
    G \<rhd> e : \<lbrace>U, nk, C(t\<mapsto>\<^sub>fTT) \<ggreater> T, m\<rbrace>;
    l \<notin> U; l \<noteq> t\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l V0; rf t = GetFr l R1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END) : \<lbrace>(U-{t}) \<union> {l}, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (rule DA_Eq2, rule DA_C_ResultMatchD, assumption+, erule DA_Eq1, assumption+)(*>*)

lemma DA_MakeResultSome: 
"\<lbrakk>GETr C y = Some TT; TT = TreeET kL kN; T = (ResultET kN TT kS); n=(Suc m + kS)\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg x, RNarg y])) : \<lbrace>{y}, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule DA_Eq2, rule DA_C_MakeResultSome, assumption+)
lemma DA_makeResultSome: 
"\<lbrakk>GETr C y = Some TT; TT = TreeET kL kN; T = (ResultET kN TT kS); n=(Suc m + kS); U={y}\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg x, RNarg y])) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
by (rule DA_Eq2, rule DA_C_makeResultSome, assumption+)
(*>*)
lemma DA_MakeResultSome1: 
"\<lbrakk>GETr C y = Some (TreeET kL kN); n=(Suc m + kS)\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg x, RNarg y])) : \<lbrace>{y}, n, C \<ggreater> ResultET kN (TreeET kL kN) kS, m\<rbrace>"
(*<*)by(rule DA_MakeResultSome, fastsimp+)(*>*)

lemma DA_LetrMakeResultSome1: 
"\<lbrakk>GETr C y = Some (TreeET kL kN); n=(Suc m + kS);
        G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fResultET kN (TreeET kL kN) kS) \<ggreater> T, l\<rbrace>; y \<notin> U-{x};UU={y} \<union> (U-{x})\<rbrakk> \<Longrightarrow>
  G \<rhd> (LET rf x = DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg z, RNarg y]) IN e END) : \<lbrace>UU, n, C \<ggreater> T , l\<rbrace>"
by(rule DA_letr, erule DA_MakeResultSome1, simp+)

subsubsection {*Rules for the tree datatype*}
lemma DA_NodeMatch: 
  "\<lbrakk>GETr C t = Some (TreeET kL kN); nk = n+kN; 
    G \<rhd> e : \<lbrace>U, nk, (C(left\<mapsto>\<^sub>f(TreeET kL kN))(right\<mapsto>\<^sub>f(TreeET kL kN))) \<ggreater> T, m\<rbrace>;
    left \<noteq> right;
    t \<notin> U - {left,right}; t \<noteq> left\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET cont = GetFi t V0; rf left = GetFr t R1; rf right = GetFr t R2 IN e END) : \<lbrace>(U-{left,right}) \<union> {t}, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule DA_Eq2, rule DA_C_TreeMatch, assumption+, erule DA_Eq1, assumption+)(*>*)

lemma DA_NodeMatchD: 
  "\<lbrakk>GETr C t = Some (TreeET kL kN); nk = n+kN+1; 
    G \<rhd> e : \<lbrace>U, nk, (C(left\<mapsto>\<^sub>f(TreeET kL kN))(right\<mapsto>\<^sub>f(TreeET kL kN))) \<ggreater> T, m\<rbrace>;
    left \<noteq> right;
    t \<notin> U \<union> {left,right}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET cont = GetFi t V0; rf left = GetFr t R1;
           rf right = GetFr t R2 ; _ = DIAM\<bullet>Free ([RNarg t]) IN e END) : \<lbrace>(U-{left,right}) \<union> {t}, n, C \<ggreater> T, m\<rbrace>"
(*<*) by (rule DA_Eq2, rule DA_C_TreeMatchD, assumption+, erule DA_Eq1, assumption+)(*>*)

lemma DA_MakeTree:
"\<lbrakk>GETr C y = Some(TreeET kL kN);GETr C z = Some (TreeET kL kN);y\<noteq>z;n=(Suc m + kN)\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg x, RNarg y, RNarg z])) : \<lbrace>{y,z}, n, C \<ggreater> TreeET kL kN, m\<rbrace>"
(*<*) by (rule DA_Eq2, rule DA_C_MakeTree, auto)
lemma DA_makeTree: 
"\<lbrakk>GETr C y = Some (TreeET kL kN);GETr C z = Some (TreeET kL kN);y\<noteq>z;n=(Suc m + kN);U={y,z}\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg x, RNarg y, RNarg z])) :  \<lbrace>U, n, C \<ggreater> TreeET kL kN, m\<rbrace>"
by (rule DA_Eq2, rule DA_C_makeTree, auto)
(*>*)

lemma DA_LetrMakeTree:
     "\<lbrakk>GETr C y = Some (TreeET kL kN);GETr C z = Some (TreeET kL kN); y\<noteq>z; n=(Suc m + kN);
        G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fTreeET kL kN) \<ggreater> T, l\<rbrace>;
        {y,z} \<inter> (U-{x}) = {}; UU=({y,z} \<union> (U-{x}))\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg v, RNarg y, RNarg z]) IN e END): \<lbrace>UU, n, C \<ggreater> T, l\<rbrace>"
(*<*)by (rule DA_letr, erule DA_MakeTree, simp+)(*>*)

subsubsection{*Renaming*}
consts REN::"(ARGTYPE \<times> PARAMTYPE \<times> (rname \<leadsto>\<^sub>f rname)) set"
inductive REN intros
REN_NIL: "([], [], emptyfinmap):REN"
REN_IN: "(args, pars, f):REN \<Longrightarrow> ((INarg x) # args, (INpar y) # pars, f):REN"
REN_RN: "\<lbrakk>(args, pars, f):REN\<rbrakk>\<Longrightarrow> ((RNarg x) # args, (RNpar y) # pars, f(x\<mapsto>\<^sub>fy)):REN"

lemma REN_property1[rule_format]:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct A \<longrightarrow>
 RenameCond1 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (erule REN.induct)
apply (simp add: RenameCond1_def)
apply (simp add: RenameCond1_def)
apply (simp add: RenameCond1_def, clarsimp)
apply (erule_tac x=xa in allE, clarsimp)
apply (rule_tac x=ya in exI, simp)
apply (subgoal_tac "xa \<noteq> x")
apply (simp add: FMAPlookup2)
apply (drule AL2RL_p1, fastsimp)
done

lemma REN_property2[rule_format]:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct A \<longrightarrow>
 RenameCond2 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (simp add: RenameCond2_def)
apply (erule REN.induct)
apply simp
apply simp
apply clarsimp
apply (rule, clarsimp)
apply (rule_tac x=x in exI, clarsimp)
apply clarsimp
apply (erule_tac x=ya in allE, clarsimp)
apply (rule_tac x=xa in exI, clarsimp)
apply (subgoal_tac "xa \<noteq> x")
apply (simp add: FMAPlookup2)
apply (drule AL2RL_p1, fastsimp)
done

lemma REN_property4a:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct P \<longrightarrow> (\<forall> x y . fmap_lookup f x = Some y \<longrightarrow> x:set (ArgList2RnameList A) \<and> y :set (ParList2RnameList P))"
apply (erule REN.induct)
apply simp
apply simp
apply clarsimp
apply (rule, clarsimp)
apply (case_tac "xa=x", simp)
apply (erule_tac x=xa in allE, erule_tac x=ya in allE, erule impE)
apply (subgoal_tac "fmap_lookup (f(x\<mapsto>\<^sub>fy)) xa = fmap_lookup f xa", clarsimp) apply (rule FMAPlookup1,fast)
apply simp
apply (case_tac "xa=x", simp)
apply (erule_tac x=xa in allE, erule_tac x=ya in allE, erule impE)
apply (subgoal_tac "fmap_lookup (f(x\<mapsto>\<^sub>fy)) xa = fmap_lookup f xa", clarsimp) apply (rule FMAPlookup1,fast)
apply simp
done

declare DOM_def[simp]
declare GETr_def[simp]
declare FMAPlookup1[simp]

lemma REN_property4[rule_format]:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct P \<longrightarrow>
 RenameCond4 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (simp add: RenameCond4_def)
apply (erule REN.induct)
apply simp
apply simp
apply clarsimp
apply (case_tac "x1=x", clarsimp)
(*1*) apply (case_tac "x2=x")
  (*1*) apply clarsimp
  (*2*) apply clarsimp
    apply (subgoal_tac "fmap_lookup f x2 = Some y")
    prefer 2 apply simp 
    apply (drule REN_property4a, erule impE, simp) 
    apply (rotate_tac -1, erule_tac x=x2 in allE, rotate_tac -1,erule_tac x=y in allE, erule impE, simp)
    apply (erule conjE)
    apply (drule PL2RL_p1, simp)
(*2*) apply (case_tac "x2=x")
  (*1*) apply clarsimp
        apply (drule REN_property4a, clarsimp) 
        apply (rotate_tac -1, erule_tac x=x1 in allE, rotate_tac -1,erule_tac x=y in allE, clarsimp)
        apply (drule PL2RL_p1, simp)
  (*2*) apply clarsimp 
done

text{*In principle, the penultimate condition in this lemma (the one about the environments) 
      should always hold. However, a general proof of it (and thus of RenameCond3) appears to
      need a non-partial definition of assign (in FunMachine) or (I think) an
      inductive definition of assign.*}
lemma AdaptRename:
"\<lbrakk>\<lbrace>UU, n, C  \<ggreater> T, m\<rbrace> EE h hh v p;
        distinct P;
        distinct L;
        (L, P ,f):REN;
        U = set (ArgList2RnameList L); U \<subseteq> DOM G;
        UU = set (ParList2RnameList P); UU \<subseteq> DOM C;
        \<forall> x y . ((fmap_lookup f x = Some y) \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>y\<rfloor>);
        \<forall> x y . ((fmap_lookup f x = Some y) \<longrightarrow> (GETr G x = GETr C y))\<rbrakk> \<Longrightarrow>
       \<lbrace>U , n , G \<ggreater> T, m \<rbrace> E h hh v p"
apply (erule DAss_Rename)
apply assumption+
apply (simp, erule REN_property1, assumption)
apply (simp, erule REN_property2, assumption)
prefer 2 apply (simp, erule REN_property4, assumption) 
apply (simp add: RenameCond3_def, clarsimp)
apply (frule REN_property4a, clarsimp)
done

(*
subsubsection{&Alberto's rules: Srules.thy&}
declare DOM_def[simp]
declare GETr_def[simp]
declare FMAPlookup1[simp]

lemma WDA_ax: "\<lbrakk> (e, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>) : G ; nn = n + k ; mm = m + k ; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk> 
               \<Longrightarrow>   G \<rhd> e : \<lbrace> U, nn, D \<ggreater> T, mm \<rbrace>"
(&<&)
by(rule DA_Const, rule DA_Contexts_same_on_U, rule vdm_ax, auto)(&>&)

lemma WDA_ax_sameC: "\<lbrakk> (e, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>) : G ; nn = n + k ; mm = m +k\<rbrakk> \<Longrightarrow>   G \<rhd> e : \<lbrace> U, nn, C \<ggreater> T, mm \<rbrace>"
(&<&)by(rule DA_Const, rule vdm_ax, auto)(&>&)

lemma SDA_Null: "n=m+kN \<Longrightarrow> G \<rhd> Null: \<lbrace>{}, n, C \<ggreater> ListET kN kC, m\<rbrace>"
(&<&)by (rule DA_NullList,auto)(&>&)

lemma SDA_Int: "G \<rhd> expr.Int i: \<lbrace>{}, m, C \<ggreater> IntET, m\<rbrace>"
(&<&) by(rule DA_Int,auto) (&>&)

lemma SDA_IVar: "G \<rhd> IVar i: \<lbrace>{}, m, C \<ggreater> IntET, m\<rbrace>"
(&<&) by(rule DA_IVar,auto) (&>&)

lemma SDA_RVar: "\<lbrakk>fmap_lookup C x = Some T\<rbrakk> \<Longrightarrow> G \<rhd> RVar x: \<lbrace>{x}, m, C \<ggreater> T, m\<rbrace>"
(&<&) by(rule DA_RVar, (simp add: le_refl)+)(&>&)

lemma SDA_Prim: " G \<rhd> Primop f x y: \<lbrace>{}, m, C \<ggreater> IntET, m\<rbrace>"
(&<&)by(rule DA_Prim,auto)(&>&)

lemma SDA_RPrim: " G \<rhd> RPrimop f x y: \<lbrace>{x,y}, m, C \<ggreater> IntET, m\<rbrace>"
(&<&)
apply (rule vdm_conseq, rule vdm_rprim, simp add: DAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply simp
done
(&>&)


lemmas SDA_leaves = SDA_Null SDA_Int SDA_IVar SDA_RVar SDA_Prim SDA_RPrim

lemmas WDA_axs = vdm_ax WDA_ax
*)
end

