theory InsSortProof = InsSortProg + Srules:

text {*Result of lfg-infer -olhs 4:
 \begin{verbatim}
  ins        : 1, int -> iList[0|int,#,0] -> iList[0|int,#,0], 0
  sort       : 0, iList[0|int,#,0] -> iList[0|int,#,0], 0
 \end<verbatim} *}


lemmas get_dom_defs = GETr_def DOM_def
 declare get_dom_defs [simp] 


constdefs Ins_Spec::"vdmassn"
"Ins_Spec == DAss {l_} 1 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0"

constdefs Sort_Spec::"vdmassn"
"Sort_Spec == DAss {l_} 0 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0"

consts FST :: FS_T
(*"FST == \<lambda> f E h hh v p . False" -- definition is arbitrary. Could be \<lambda>..True as well*)

consts vMST :: vMS_T
(*"vMST == \<lambda> x M args E h hh v p . False" -- definition is arbitrary. Could be \<lambda>..True as well"*)

constdefs sMST :: sMS_T
"sMST == (\<lambda> C M args E h hh v p.
         if (C,M) = (InsSort,Ins) then Ins_Spec (newframe_env Nullref (fst (methtable InsSort Ins)) args E) h hh v p else
         if (C,M) = (InsSort,Sort) then Sort_Spec (newframe_env Nullref (fst (methtable InsSort Sort)) args E) h hh v p else
         False)"

lemma InsInvoke: "sMST InsSort Ins [INarg x, RNarg y] = \<lbrace> {y} , Suc 0 , emptyfinmap(y\<mapsto>\<^sub>fListET 0) \<ggreater>  ListET 0 , 0 \<rbrace>"
apply (simp add: sMST_def)
apply (simp add: Meth_Ins Ins_Spec_def newframe_env_def evalARGS_def self_def)
apply rule 
apply (rule, rule, rule, rule, simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply (erule CS.elims, clarsimp, clarsimp)
apply (erule CS.elims, clarsimp)
apply (rule CS_CONS, fast) apply simp apply simp 
  apply (rule CS_NIL) apply simp+
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply (erule CS.elims, clarsimp, clarsimp)
apply (erule CS.elims, clarsimp)
apply (rule CS_CONS, fast) apply simp apply simp
  apply (rule CS_NIL) apply simp+
done

(* following not used *)
lemma SCS_NIL[intro!]: "(E,h,{},C,{},0) : CS"
by(rule CS_NIL,auto)

inductive_cases CS_ELIM_NIL :"(E,h,{},C,{},0) : CS"
inductive_cases CS_ELIM_ONE:"(E,h,{x}  ,C,R,S) : CS"
inductive_cases CS_ELIM_TWO:"(E,h,{x,y}  ,C,R,S) : CS"


lemma SortInvoke:
"sMST InsSort Sort [RNarg y] = \<lbrace> {y} , 0 , (emptyfinmap(y \<mapsto>\<^sub>f(ListET 0))) \<ggreater> (ListET 0), 0 \<rbrace>"
apply (simp add: sMST_def)
apply (simp add: Meth_Sort Sort_Spec_def newframe_env_def evalARGS_def self_def)
apply rule 
apply (rule, rule, rule, rule, simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply (erule CS.elims, clarsimp, clarsimp)
apply (erule CS.elims, clarsimp)
apply (rule CS_CONS, fast)   apply simp+
  apply (rule CS_NIL) apply simp+
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply (erule CS.elims, clarsimp, clarsimp)
apply (erule CS.elims, clarsimp)
apply (rule CS_CONS, fast)  apply simp+
  apply (rule CS_NIL) apply simp+
done



lemmas DA_intros =  SDA_leaves   DA_Call2 DA_Let_RPrim DA_Let_Prim DA_If  
                   DA_Make_IID DA_ListMatchD  DA_Letr 

lemmas fun_simp =  Fun_fIns   Fun_fzeroIns Fun_foneIns  Fun_ftwoIns Fun_fthreeIns
                   Fun_fSort  Fun_fzeroSort  Fun_foneSort

lemmas meth_simp =  Meth_Ins Meth_Sort

lemmas daspec_simp =  Ins_Spec_def  Sort_Spec_def

lemmas mst_simp =  InsInvoke SortInvoke
(* declare mst_simp [simp] *)

constdefs  InsSortContext:: vdmcontext
"InsSortContext \<equiv> {(InsSort\<bullet>Ins([INarg a_,RNarg v2_]), sMST InsSort Ins [INarg a_, RNarg v2_]),
                   (InsSort\<bullet>Ins([INarg v3_,RNarg l_]), sMST InsSort Ins [INarg v3_, RNarg l_]),
                   (InsSort\<bullet>Sort([RNarg v2_]), sMST InsSort Sort [RNarg v2_])}"
lemmas context_simp = InsSortContext_def


(* w/o ML tactic *)

lemma Ins_DAss:
"InsSortContext \<rhd> snd (methtable InsSort Ins) : Ins_Spec"
apply (simp only: meth_simp daspec_simp snd_conv,rule DA_Weak)
apply ((rule DA_intros | (simp (no_asm) add: fun_simp mst_simp)) | (simp only: context_simp,rule WDA_ax))+
done


lemma Sort_DAss:
"InsSortContext \<rhd> snd (methtable InsSort Sort) : Sort_Spec"
apply (simp only: meth_simp daspec_simp snd_conv,rule DA_Weak)
apply ((rule DA_intros | simp (no_asm) add: fun_simp mst_simp) | (simp only: context_simp,rule WDA_ax))+
done


ML{* val DA_intros = thms "DA_intros"*};
ML{*val fun_simp = thms "fun_simp"*};
ML{*val meth_simp = thms "meth_simp"*};
ML{*val daspec_simp = thms "daspec_simp"*};
ML{* val context_simp = thm "context_simp"*};
ML{* val mst_simp = thms "mst_simp"*};

ML{*
val GCInvs = thm "GCInvs";
val WDA_axs = thms "WDA_axs";
val WDA_ax = thm "WDA_ax";
val DA_Weak = thm "DA_Weak";
*}

ML{*
(* single "step": Note REPEAT1 poinless here *)
val step_tac   = FIRST [resolve_tac DA_intros 1, 
                  REPEAT1(CHANGED(simp_tac(simpset() addsimps fun_simp @ mst_simp) 1)),
	          simp_tac(HOL_basic_ss addsimps [context_simp]) 1 THEN  rtac WDA_ax 1];
			
(* recursive *)
fun vdm_naive_tac simp i state = state |> 
	((step_tac THEN (vdm_naive_tac simp  i)) ORELSE all_tac);

fun start_tac_f    simp i  =
	EVERY [
	 simp_tac(HOL_basic_ss addsimps  ([snd_conv] @ meth_simp @ daspec_simp))1,
		rtac DA_Weak 1, vdm_naive_tac simp i  ];

*}

method_setup vcg_f = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      start_tac_f ( Simplifier.get_local_simpset ctxt) 1)) *}
  "recursive verification condition generator"


lemma 
"InsSortContext \<rhd> snd (methtable InsSort Ins) : Ins_Spec"
by vcg_f

lemma Sort_DAss:
"InsSortContext \<rhd> snd (methtable InsSort Sort) : Sort_Spec"
by vcg_f


(* vgc with explixit REPEAT *)

ML{*
fun vdm_naive_tac_r simp  = (REPEAT
	(FIRST [resolve_tac DA_intros 1, 
                CHANGED(simp_tac(simp addsimps (fun_simp @ mst_simp)) 1),
	       (simp_tac(simp addsimps [context_simp]) 1 THEN  rtac WDA_ax 1)]));


fun start_tac    simp  =
	EVERY [
	 simp_tac(HOL_basic_ss addsimps  ([snd_conv] @ meth_simp @ daspec_simp))1,
		rtac DA_Weak 1, vdm_naive_tac_r simp  ];
*}


method_setup vcg_r = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      start_tac ( Simplifier.get_local_simpset ctxt) )) *}
  "recursive verification condition generator"



lemma 
"InsSortContext \<rhd> snd (methtable InsSort Ins) : Ins_Spec"
by vcg_r

lemma Sort_DAss:
"InsSortContext \<rhd> snd (methtable InsSort Sort) : Sort_Spec"
by vcg_r






(* only to get the 'simplified' to work, could use lemmas *)
declare context_simp [simp]

lemma InsSortContext_good: "goodContext FST vMST sMST InsSortContext"

apply (simp add: goodContext_def,clarify,safe)
apply (rule vdm_conseq, rule Ins_DAss[simplified] Sort_DAss[simplified],
    fastsimp simp: sMST_def meth_simp newframe_env_def 
    evalARGS_def daspec_simp   elim!: DAss_PConst)+ 
done



lemmas context_good = InsSortContext_good

ML{* val context_good = thm "context_good"*};
ML{*val meth_tac = EVERY[ rtac GCInvs 1,
		      rtac context_good 1,
		      rewrite_tac [context_simp],
		      Auto_tac]*};


method_setup meth = {*
  Method.no_args (Method.METHOD (fn facts => meth_tac))*}
  "solving top level"

text {*Thus, we can prove that arbitrary invocations of @{text Ins} and  @{text Sort} honour
       their entries in the specification table MST, in the empty VDM context.*}
theorem "\<rhd> InsSort\<bullet>Ins([RNarg x, RNarg y]): sMST InsSort Ins [RNarg x, RNarg y]"
by meth

theorem "\<rhd> InsSort\<bullet>Sort([RNarg x]): sMST InsSort Sort [RNarg x]"
by meth


end


(* for debugging *)
(* 


method_setup simpc = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      (simp_tac (HOL_basic_ss addsimps [context_simp]) 1) THEN rtac WDA_ax 1)) *}
  "verification condition generator plus simplification"

method_setup da = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      resolve_tac (thms "DA_intros") 1)) *}
  "verification condition generator plus simplification"

method_setup simpf = {*
  Method.ctxt_args (fn ctxt =>
    Method.METHOD (fn facts => 
      (simp_tac ((Simplifier.get_local_simpset ctxt) addsimps fun_simp) 1) )) *}
  "verification condition generator plus simplification"

*)

(*
lemma repp : " ? Meth . {(DIAM\<bullet>Ins([INarg a_, RNarg l_]), \<lbrace> {l_} , Suc 0 , emptyfinmap(l_\<mapsto>\<^sub>f
         ListET 0) \<ggreater>  ListET 0 , 0 \<rbrace>),
        (DIAM\<bullet>Ins([INarg a_, RNarg v2_]), \<lbrace> {v2_} , Suc 0 , emptyfinmap(v2_\<mapsto>\<^sub>f
         ListET 0) \<ggreater>  ListET 0 , 0 \<rbrace>),
        (DIAM\<bullet>Ins([INarg v3_, RNarg l_]), \<lbrace> {l_} , Suc 0 , emptyfinmap(l_\<mapsto>\<^sub>f
         ListET 0) \<ggreater>  ListET 0 , 0 \<rbrace>),
        (DIAM\<bullet>Sort([RNarg l_]), \<lbrace> {l_} , 0 , emptyfinmap(l_\<mapsto>\<^sub>fListET 0) \<ggreater>  ListET 0 , 0 \<rbrace>),
        (DIAM\<bullet>Sort([RNarg v2_]), \<lbrace> {v2_} , 0 , emptyfinmap(v2_\<mapsto>\<^sub>f
         ListET
          0) \<ggreater>  ListET
                 0 , 0 \<rbrace>)} \<rhd>  snd (methtable DIAM
                                    Meth) : (\<lambda>E h hh v p.
                                               \<forall>E'.
  E = newframe_env (fst (methtable DIAM Meth) @ [RNpar self]) (x @ [VALarg (RVal Nullref)]) E' \<longrightarrow>
  MST Meth (x @ [VALarg (RVal Nullref)]) E' h hh v
   (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p)))) "

apply (rule exI)
apply (rule vdm_conseq) 
 apply( rule Ins_DAss[simplified])
  apply (simp add: MST_def,clarify)
  apply (simp add: MST_def  meth_simp newframe_env_def evalARGS_def daspec_simp)
  apply (erule DAss_PConst)
done
*)
(*
lemma repp : " ? Meth . {(DIAM\<bullet>Ins([INarg a_, RNarg l_]), \<lbrace> {l_} , Suc 0 , emptyfinmap(l_\<mapsto>\<^sub>f
         ListET 0) \<ggreater>  ListET 0 , 0 \<rbrace>),
        (DIAM\<bullet>Ins([INarg a_, RNarg v2_]), \<lbrace> {v2_} , Suc 0 , emptyfinmap(v2_\<mapsto>\<^sub>f
         ListET 0) \<ggreater>  ListET 0 , 0 \<rbrace>),
        (DIAM\<bullet>Ins([INarg v3_, RNarg l_]), \<lbrace> {l_} , Suc 0 , emptyfinmap(l_\<mapsto>\<^sub>f
         ListET 0) \<ggreater>  ListET 0 , 0 \<rbrace>),
        (DIAM\<bullet>Sort([RNarg l_]), \<lbrace> {l_} , 0 , emptyfinmap(l_\<mapsto>\<^sub>fListET 0) \<ggreater>  ListET 0 , 0 \<rbrace>),
        (DIAM\<bullet>Sort([RNarg v2_]), \<lbrace> {v2_} , 0 , emptyfinmap(v2_\<mapsto>\<^sub>f
         ListET
          0) \<ggreater>  ListET
                 0 , 0 \<rbrace>)} \<rhd>  snd (methtable DIAM
                                    Meth) : (\<lambda>E h hh v p.
                                               \<forall>E'.
  E = newframe_env (fst (methtable DIAM Meth) @ [RNpar self]) (x @ [VALarg (RVal Nullref)]) E' \<longrightarrow>
  MST Meth (x @ [VALarg (RVal Nullref)]) E' h hh v
   (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p)))) "

apply (rule exI)
apply (rule vdm_conseq) 
 apply( rule Ins_DAss[simplified])
  apply (simp add: MST_def,clarify)
  apply (simp add: MST_def  meth_simp newframe_env_def evalARGS_def daspec_simp)
  apply (erule DAss_PConst)
done
*)

(*
lemma SortInvoke:
"MST Sort [RNarg y, VALarg (RVal Nullref)] = \<lbrace> {y} , 0 , (emptyfinmap(y \<mapsto>\<^sub>f(ListET 0))) \<ggreater> (ListET 0), 0 \<rbrace>"
apply (simp add: MST_def Meth_Sort Sort_Spec_def newframe_env_def evalARGS_def self_def)+
apply (rule ext)+
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, clarsimp)

apply (erule CS.elims,clarsimp)+
apply (rule_tac x=N in exI, clarify)
apply (rule_tac x=P in exI,safe)
apply (rule CS_CONS, fast,simp)
 apply (rule CS_NIL,simp+)
apply clarify
apply (simp add: mod2_def)
apply blast



apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: mod2_def)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply (erule CS.elims, clarsimp, clarsimp)
apply (erule CS.elims, clarsimp)
apply (rule CS_CONS, fast) apply (simp add: GETr_def) apply simp
  apply (rule CS_NIL) apply simp+
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: mod2_def)





apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=Ma in exI, rule_tac x=FF in exI, safe)
apply (simp add: mod2_def)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply (erule CS.elims, clarsimp, clarsimp)
apply (erule CS.elims, clarsimp)
apply (rule CS_CONS, fast) apply  simp+
  apply (rule CS_NIL) 
apply (simp add: mod2_def)+
apply blast

apply (erule CS.elims, clarsimp, clarsimp)
apply (erule CS.elims, clarsimp)
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)

apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply(force intro:CS.intros simp add: mod2_def)+ 
done



apply (erule CS.elims, fastsimp)
apply (clarify,erule CS.elims, fastsimp)
apply (fastsimp elim!:CS.elims intro:CS.intros)
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule CS.elims, clarsimp, clarsimp)
apply (erule CS.elims, clarsimp)
apply (rule CS_CONS, fast) apply  simp+
  apply (rule CS_NIL) 
apply (simp add: mod2_def)+
apply blast
done
*)
