(*<*)
theory GA13 = VDMSoundRecPC + VDMCompletePC:
(*>*)


lemma let_aux_1:"
\<lbrakk>\<forall> E h. \<forall> X. Gpre Q X E h  \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> X .Gpre Qi X E h );
Gpre Q X E h; 
G Q Qi Qii
\<rbrakk>\<Longrightarrow> \<exists> Xi .Gpre Qi Xi E h"
apply fast
done

lemma let_aux_3:
"\<lbrakk>\<forall> E h hi r pi. \<forall> X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> 
(\<exists> X. Gpost Qi X E h hi (RVal r) pi) \<longrightarrow> (\<exists> X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi); 
Gpre Q X E h; 
G Q Qi Qii;
Gpost Qi Xi E h hi (RVal r) pi
\<rbrakk>\<Longrightarrow>(\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi)"
apply fast
done


lemma let_aux_3_nondecent:
"\<lbrakk>\<forall> E h hi r pi. \<forall> X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> 
(\<exists> X. Gpost Qi X E h hi (RVal r) pi) \<longrightarrow> A E h hi (RVal r) pi \<longrightarrow> (\<exists> X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi); 
Gpre Q X E h; 
G Q Qi Qii; 
A E h hi (RVal r) pi;
Gpost Qi Xi E h hi (RVal r) pi
\<rbrakk>\<Longrightarrow>(\<exists> Xii. Gpre Qii Xii E\<lfloor>x:=r\<rfloor> hi)"
apply fast
done

lemma let_aux_5:"
\<lbrakk>\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow> (\<exists> Xii. Gpost Qii Xii E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Gpost Q X E h h' v p;
Gpre Q X E h;
Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii\<rbrakk>
\<Longrightarrow>Gpost Q X  E h h' v p"
apply fast
done


lemma let_decent_aux: "
\<lbrakk>
\<forall> X. Gpre Qi X E h \<longrightarrow> Gpost Qi X E h hi (RVal r) pi;
\<forall> X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi  \<longrightarrow> Gpost Qii X  E\<lfloor>x:=r\<rfloor> hi h' v pii;
G Q Qi Qii;
\<forall> E h. \<forall>  X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> X .Gpre Qi X E h);
\<forall> E h hi r pi. \<forall>  X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> X. Gpost Qi X E h hi (RVal r) pi)
 \<longrightarrow> (\<exists> X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow> (\<exists> Xii. Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Gpost Q X E h h' v p
\<rbrakk> \<Longrightarrow>  \<forall> X . Gpre Q X E h \<longrightarrow> Gpost Q X E h h' v p"
(** proof **)
apply (rule allI)
apply (rule impI) 

apply (drule_tac Gpre=Gpre and G=G and Q=Q and Qi=Qi and X=X and E=E and h=h in let_aux_1)
apply assumption apply assumption 
apply (erule exE)

apply (drule_tac Gpre=Gpre and G=G and Q=Q and X=X and E=E and h=h and hi=hi and Xi=Xi
                  and Qi=Qi and pi=pi and r=r in let_aux_3)
apply assumption apply assumption
apply (erule_tac x=Xi in allE)  apply (drule mp) apply assumption
apply assumption apply (erule exE)

apply (rule_tac Gpre=Gpre and E=E and X=X and h=h and x=x and v=v and Qii=Qii and Xii=Xii and
                 hi=hi and h'=h' and p=p and r=r and pii=pii in let_aux_5)
apply assumption apply assumption
apply (rotate_tac 1)
apply (erule_tac x=Xii in allE)  apply (drule mp) apply assumption
apply assumption 
done

lemma let_nondecent_aux: "
\<lbrakk>
\<forall> X. Gpre Qi X E h \<longrightarrow> Gpost Qi X E h hi (RVal r) pi;
\<forall> X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi \<longrightarrow> Gpost Qii X  E\<lfloor>x:=r\<rfloor> hi h' v pii;
G Q Qi Qii;
A E h hi (RVal r) pi;
\<forall> E h. \<forall>  X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> X .Gpre Qi X E h);
\<forall> E h hi r pi. \<forall>  X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> 
(\<exists> X. Gpost Qi X E h hi (RVal r) pi) \<longrightarrow> A E h hi (RVal r) pi
 \<longrightarrow> (\<exists> X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow> (\<exists> Xii. Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Gpost Q X E h h' v p
\<rbrakk> \<Longrightarrow>  \<forall> X . Gpre Q X E h \<longrightarrow> Gpost Q X E h h' v p"
(** proof **)
apply (rule allI)
apply (rule impI) 

apply (drule_tac Gpre=Gpre and G=G and Q=Q and Qi=Qi and X=X and E=E and h=h in let_aux_1)
apply assumption apply assumption 
apply (erule exE)

apply (drule_tac Gpre=Gpre and G=G and Q=Q and X=X and E=E and h=h and hi=hi and Xi=Xi 
                  and Qi=Qi and pi=pi and r=r in let_aux_3_nondecent)
apply assumption apply assumption apply assumption
apply (erule_tac x=Xi in allE)  apply (drule mp) apply assumption
apply assumption apply (erule exE)

apply (rule_tac Gpre=Gpre and E=E and X=X and h=h and x=x and v=v and Qii=Qii and Xii=Xii and
                 hi=hi and h'=h' and p=p and r=r and pii=pii in let_aux_5)
apply assumption apply assumption
apply (rotate_tac 1)
apply (erule_tac x=Xii in allE)  apply (drule mp) apply assumption
apply assumption 
done

lemma let_nondecent_aux': "
\<lbrakk>
\<forall> X. Gpre Qi X E h \<longrightarrow> Gpost Qi X E h hi (RVal r) pi;
\<forall> X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi \<longrightarrow> Gpost Qii X  E\<lfloor>x:=r\<rfloor> hi h' v pii;
G Q Qi Qii;
A E h hi (RVal r) pi;
\<forall> E h. \<forall>  X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> X .Gpre Qi X E h);
\<forall> E h hi r pi. \<forall>  X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> 
(\<exists> X. Gpost Qi X E h hi (RVal r) pi) \<longrightarrow> A E h hi (RVal r) pi
 \<longrightarrow> (\<exists> X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow> (\<exists> Xii. Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Gpost Q X E h h' v p;
Gpre Q X E h
\<rbrakk> \<Longrightarrow>  Gpost Q X E h h' v p"
(** proof **)
apply (frule_tac E=E and x=x and Q=Q and Qi=Qi and Qii=Qii and h=h and h'=h' and A=A 
        and Gpre=Gpre and G=G in let_nondecent_aux)
apply assumption apply assumption apply assumption
apply assumption apply assumption apply assumption
apply fast
done

constdefs ConjAssnP :: "('a \<Rightarrow> 'c \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool) \<Rightarrow> ('b \<Rightarrow> 'd  \<Rightarrow>  env \<Rightarrow> heap \<Rightarrow> bool) \<Rightarrow> 
                        'a \<times> 'b \<Rightarrow> 'c \<times> 'd \<Rightarrow>  env \<Rightarrow> heap \<Rightarrow> bool"
 ("_  \<and>\<and>  _" 1000)
"ConjAssnP G F  \<equiv>  \<lambda> Q. \<lambda> X. \<lambda> E h. G (fst Q) (fst X) E h \<and> F (snd Q) (snd X) E h"


constdefs ConjAssnPost :: "('a \<Rightarrow> 'c \<Rightarrow> vdmassn) \<Rightarrow> ('b \<Rightarrow>'d \<Rightarrow>  vdmassn) \<Rightarrow> 
                           ('a \<times> 'b \<Rightarrow> 'c \<times> 'd \<Rightarrow> vdmassn)"
 ("_  \<and>\<and>\<and>   _" 1000)
"ConjAssnPost G F \<equiv>   \<lambda> Q. \<lambda> X. \<lambda> E h h' v  p. (G (fst Q) (fst X) E h h' v p) \<and> (F (snd Q) (snd X) E h h' v p)"


constdefs ConjCond :: "('a \<Rightarrow> 'a \<Rightarrow> 'a \<Rightarrow> bool) \<Rightarrow> ('b \<Rightarrow>'b \<Rightarrow>'b \<Rightarrow>  bool) \<Rightarrow> 
                        'a \<times> 'b \<Rightarrow>  'a \<times> 'b \<Rightarrow> 'a \<times> 'b \<Rightarrow> bool"
 ("_  \<And>  _" 1000)
"ConjCond G F \<equiv>   \<lambda> Q Qi Qii. G (fst Q) (fst Qi) (fst Qii) \<and> F (snd Q) (snd Qi) (snd Qii)"


lemma let_combo_aux': "
\<lbrakk> 
\<forall> X. ((Gpre  \<and>\<and> Fpre) Qi X E h) \<longrightarrow> 
(((Gpost ::('a \<Rightarrow> 'c \<Rightarrow> vdmassn)) \<and>\<and>\<and> (Fpost :: ('b \<Rightarrow>'d \<Rightarrow>  vdmassn))) Qi X E h hi (RVal r) pi);
\<forall> X. ((Gpre  \<and>\<and> Fpre) Qii X E\<lfloor>x:=r\<rfloor> hi) \<longrightarrow> ((Gpost \<and>\<and>\<and> Fpost) Qii X E\<lfloor>x:=r\<rfloor> hi h' v pii);

(G \<And> F) Q Qi Qii;

\<forall> Y. Fpre (snd Q) Y E h \<longrightarrow> A E h hi (RVal r) pi;

\<forall> E h. \<forall>  X. Gpre (fst Q) X E h \<longrightarrow> G (fst Q) (fst Qi) (fst Qii) \<longrightarrow> (\<exists> X .Gpre (fst Qi) X E h);
\<forall> E h hi r pi. \<forall>  X. Gpre (fst Q) X E h \<longrightarrow> G (fst Q) (fst Qi) (fst Qii) \<longrightarrow> 
(\<exists> X. Gpost (fst Qi) X E h hi (RVal r) pi) \<longrightarrow> A E h hi (RVal r) pi
 \<longrightarrow> (\<exists> X. Gpre (fst Qii) X E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre (fst Q) X E h \<longrightarrow> (\<exists> Xii. Gpost (fst Qii) Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Gpost (fst Q) X E h h' v p;

\<forall> E h. \<forall>  Y. Fpre (snd Q) Y E h \<longrightarrow>  F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> (\<exists> Y .Fpre (snd Qi) Y E h);
\<forall> E h hi r pi. \<forall>  Y. Fpre (snd Q) Y E h \<longrightarrow>  F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> 
(\<exists> Y. Fpost (snd Qi) Y E h hi (RVal r) pi) \<longrightarrow>  (\<exists> Y. Fpre (snd Qii) Y E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> Y. Fpre  (snd Q) Y E h \<longrightarrow> (\<exists> Yii. Fpost (snd Qii) Yii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Fpost (snd Q) Y E h h' v p;

(Gpre  \<and>\<and> Fpre) Q X E h

\<rbrakk> \<Longrightarrow> (Gpost \<and>\<and>\<and> Fpost) Q X E h h' v p"

(** proof **)
apply (rule_tac Gpre ="Gpre \<and>\<and> Fpre" and pi=pi and hi=hi and G="G \<And> F"  and E=E and h=h and
                r=r and x= x and Q=Q and Qi=Qi and Qii=Qii and A=A in let_nondecent_aux')
apply assumption apply assumption apply assumption

apply (simp only: ConjAssnP_def) apply (erule conjE)
apply (rotate_tac 3) apply (erule_tac x="snd X" in allE)
apply (drule mp) apply assumption apply assumption

apply (simp add: ConjCond_def ConjAssnP_def ConjAssnPost_def)

apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) 
apply (rotate_tac 1)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl)
apply (simp only: ConjCond_def ConjAssnP_def ConjAssnPost_def)
apply fastsimp

apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (erule thin_rl) apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl) apply (erule thin_rl)
apply (rotate_tac 1) apply (erule thin_rl)
apply (simp only: ConjAssnP_def ConjAssnPost_def)
apply fastsimp

apply assumption
done


constdefs Impl :: "('a \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool) \<Rightarrow> ('a \<Rightarrow> vdmassn) \<Rightarrow> vdmassn"
                    ("_ \<Rightarrow> _" 1000)
"Impl Fpre  Fpost  \<equiv> \<lambda> E h h' v p. \<forall> X.  Fpre X E h \<longrightarrow>  Fpost X E h h' v p"


lemma let_decent: "\<lbrakk>
\<rhd> e1: (Gpre Qi) \<Rightarrow> (Gpost Qi);
\<rhd> e2: (Gpre Qii) \<Rightarrow>(Gpost Qii);
G Q Qi Qii;
\<forall> E h. \<forall>  X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> X .Gpre Qi X E h);
\<forall> E h hi r pi. \<forall> X. Gpre Q X E h \<longrightarrow>
             G Q Qi Qii \<longrightarrow> (\<exists>X. Gpost Qi X E h hi (RVal r) pi) \<longrightarrow> (\<exists>X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre Q X E h \<longrightarrow>
(\<exists> Xii. Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   \<longrightarrow> Gpost Q X E h h' v p
\<rbrakk> \<Longrightarrow>  \<rhd> (Letr x e1 e2) : (Gpre Q) \<Rightarrow> (Gpost Q)"
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply assumption apply assumption
apply (erule thin_rl) apply (erule thin_rl)

apply (rule allI)+ 
apply (rule impI)
apply (erule exE)+ 
apply (rename_tac hi r)
apply (erule conjE)+
apply (unfold Impl_def)
apply (rule let_decent_aux)
apply assumption apply assumption apply assumption
apply assumption apply assumption apply assumption
done


constdefs ConjAssn :: "vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn"
 ("_  \<And>\<And>   _" 1000)
"ConjAssn P1 P2 \<equiv> \<lambda>  E h h' v p. (P1 E h h' v p) \<and> (P2 E h h' v p)"


lemma let_nondecent': "\<lbrakk>
\<rhd> e1: ((Gpre Qi) \<Rightarrow> (Gpost Qi))  \<And>\<And>  A;
\<rhd> e2: (Gpre Qii) \<Rightarrow> (Gpost Qii);
G Q Qi Qii;
\<forall>  E h. \<forall> X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> X .Gpre Qi X E h);
\<forall> E h hi r pi. \<forall> X. Gpre Q X E h \<longrightarrow>
             G Q Qi Qii \<longrightarrow> (\<exists>X. Gpost Qi X E h hi (RVal r) pi) \<longrightarrow> A E h hi (RVal r) pi \<longrightarrow>
             (\<exists>X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p . \<forall> X. Gpre Q X E h \<longrightarrow>
(\<exists> Xii. Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   \<longrightarrow> Gpost Q X E h h' v p
\<rbrakk> \<Longrightarrow>  \<rhd> (Letr x e1 e2) : (Gpre Q) \<Rightarrow> (Gpost Q)"
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply assumption apply assumption
apply (erule thin_rl) apply (erule thin_rl)

apply (rule allI)+
apply (rule impI)
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac hi r)
apply (unfold ConjAssn_def)
apply (unfold Impl_def)
apply (erule conjE)
apply (rule_tac A=A and Gpre=Gpre and E=E and h'=hh and v=v and G=G and Q=Q and r=r and p=p and x=x 
       and pi=p1 and Qi=Qi and hi=hi and Qii=Qii and pii=p2 in let_nondecent_aux)
apply assumption apply assumption apply assumption
apply assumption apply assumption apply assumption apply assumption
done



lemma ConjAssn_valid: "\<lbrakk>\<Turnstile> e:P; \<Turnstile> e:Q\<rbrakk> \<Longrightarrow> \<Turnstile> e : P  \<And>\<And> Q"
by (simp add: vdm_valid_def  ConjAssn_def)

lemma vdm_ConjI_aux: "\<lbrakk>\<rhd> e:P; \<rhd> e:Q; finite strongContext\<rbrakk> \<Longrightarrow> \<rhd> e : P  \<And>\<And> Q"
apply (drule vdm_sound)
apply (drule vdm_sound)
apply (drule ConjAssn_valid, assumption)
apply (drule vdm_complete) 
prefer 2 apply assumption+
done

axioms strongContextFin: "finite strongContext"

lemma vdm_conjI : "\<lbrakk> \<rhd> e :P; \<rhd> e : Q\<rbrakk>    \<Longrightarrow>   \<rhd> e : P  \<And>\<And> Q"
apply (rule vdm_ConjI_aux)
apply assumption+
apply (rule strongContextFin)
done

lemma let_nondecent: "\<lbrakk>
\<rhd> e1: (Gpre Qi) \<Rightarrow> (Gpost Qi);
\<rhd> e2: (Gpre Qii) \<Rightarrow> (Gpost Qii);
\<rhd> e1: A;
G Q Qi Qii;
\<forall>  E h. \<forall>  X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> X .Gpre Qi X E h);
\<forall> E h hi r pi.\<forall> X. Gpre Q X E h \<longrightarrow>
             G Q Qi Qii \<longrightarrow> (\<exists>X. Gpost Qi X E h hi (RVal r) pi) \<longrightarrow> A E h hi (RVal r) pi \<longrightarrow>
             (\<exists>X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p . \<forall> X. Gpre Q X E h \<longrightarrow>
(\<exists> Xii. Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   \<longrightarrow> Gpost Q X E h h' v p
\<rbrakk> \<Longrightarrow>  \<rhd> (Letr x e1 e2) : (Gpre Q) \<Rightarrow>  (Gpost Q)"
apply (rule_tac G=G and Q=Q and A=A in let_nondecent')
apply (rule_tac vdm_conjI)
apply assumption apply assumption
apply assumption apply assumption
apply assumption apply assumption
apply assumption
done

lemma let_nondecent_concrete: "\<lbrakk>
\<rhd> e1: (Gpre Qi) \<Rightarrow> (Gpost Qi);
\<rhd> e2: (Gpre Qii) \<Rightarrow> (Gpost Qii);
\<rhd> e1: (A Qii);
G Q Qi Qii;
\<forall>  E h. \<forall>  X. Gpre Q X E h \<longrightarrow> G Q Qi Qii \<longrightarrow> (\<exists> X .Gpre Qi X E h);
\<forall> E h hi r pi.\<forall> X. Gpre Q X E h \<longrightarrow>
             G Q Qi Qii \<longrightarrow> (\<exists>X. Gpost Qi X E h hi (RVal r) pi) \<longrightarrow> (A Qii) E h hi (RVal r) pi \<longrightarrow>
             (\<exists>X. Gpre Qii X E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p . \<forall> X. Gpre Q X E h \<longrightarrow>
(\<exists> Xii. Gpost Qii Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   \<longrightarrow> Gpost Q X E h h' v p
\<rbrakk> \<Longrightarrow>  \<rhd> (Letr x e1 e2) : (Gpre Q) \<Rightarrow>  (Gpost Q)"
apply (rule_tac G=G and Q=Q and A="A Qii" in let_nondecent)
apply assumption+
done

lemma let_comb: "
\<lbrakk> 

\<rhd> e1: (((Gpre  \<and>\<and> Fpre) Qi) \<Rightarrow> ((Gpost  \<and>\<and>\<and>  Fpost) Qi));
\<rhd> e2: (((Gpre  \<and>\<and> Fpre) Qii) \<Rightarrow>((Gpost  \<and>\<and>\<and>  Fpost) Qii));

G (fst Q) (fst Qi) (fst Qii);
F (snd Q) (snd Qi) (snd Qii);


\<forall> E h hi r pi. \<forall> Y. Fpre (snd Q) Y E h \<longrightarrow> A E h hi (RVal r) pi;

\<forall> E h. \<forall>  X. Gpre (fst Q) X E h \<longrightarrow> G (fst Q) (fst Qi) (fst Qii) \<longrightarrow> (\<exists> X .Gpre (fst Qi) X E h);
\<forall> E h hi r pi. \<forall>  X. Gpre (fst Q) X E h \<longrightarrow> G (fst Q) (fst Qi) (fst Qii) \<longrightarrow> 
(\<exists> X. Gpost (fst Qi) X E h hi (RVal r) pi) \<longrightarrow> A E h hi (RVal r) pi
 \<longrightarrow> (\<exists> X. Gpre (fst Qii) X E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre (fst Q) X E h \<longrightarrow> (\<exists> Xii. Gpost (fst Qii) Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Gpost (fst Q) X E h h' v p;

\<forall> E h. \<forall>  Y. Fpre (snd Q) Y E h \<longrightarrow>  F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> (\<exists> Y .Fpre (snd Qi) Y E h);
\<forall> E h hi r pi. \<forall>  Y. Fpre (snd Q) Y E h \<longrightarrow>  F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> 
(\<exists> Y. Fpost (snd Qi) Y E h hi (RVal r) pi) \<longrightarrow>  (\<exists> Y. Fpre (snd Qii) Y E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> Y. Fpre  (snd Q) Y E h \<longrightarrow> (\<exists> Yii. Fpost (snd Qii) Yii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Fpost (snd Q) Y E h h' v p

\<rbrakk> \<Longrightarrow>  \<rhd> Letr x e1 e2 : (((Gpre  \<and>\<and> Fpre) Q) \<Rightarrow> ((Gpost  \<and>\<and>\<and>  Fpost) Q))"

(** proof **)
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply assumption apply assumption
apply (erule thin_rl) apply (erule thin_rl)

apply (rule allI)+ apply (rule impI) 
apply (erule exE)+ apply (erule conjE)+
apply (rename_tac E' h' hh v p p1 p2 h1 r')
apply (unfold Impl_def)
apply (rule allI) apply (rule impI)
apply (rule_tac X=X and E=E' and h=h' and h'=hh and v=v and p=p and r=r' and x=x and A=A and
                Q=Q and Qi=Qi and Qii=Qii and hi=h1 and pi=p1 and pii=p2 and G=G and F=F and
                Gpre=Gpre and Fpre=Fpre and Gpost=Gpost and Fpost=Fpost in let_combo_aux')
apply assumption apply assumption apply (simp add: ConjCond_def)
apply clarsimp 
apply assumption apply assumption apply assumption
apply assumption apply assumption apply assumption
apply assumption
done



lemma let_comb_exact: "
\<lbrakk> 

\<rhd> e1: (((Gpre  \<and>\<and> Fpre) Qi) \<Rightarrow> ((Gpost  \<and>\<and>\<and>  Fpost) Qi));
\<rhd> e2: (((Gpre  \<and>\<and> Fpre) Qii) \<Rightarrow>((Gpost  \<and>\<and>\<and>  Fpost) Qii));

G (fst Q) (fst Qi) (fst Qii);
F (snd Q) (snd Qi) (snd Qii);


\<forall> E h hi r pi. \<forall> Y. Fpre (snd Q) Y E h \<longrightarrow> 
F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> A E h hi (RVal r) pi;

\<forall> E h. \<forall>  X. Gpre (fst Q) X E h \<longrightarrow> G (fst Q) (fst Qi) (fst Qii) \<longrightarrow> (\<exists> X .Gpre (fst Qi) X E h);
\<forall> E h hi r pi. \<forall>  X. Gpre (fst Q) X E h \<longrightarrow> G (fst Q) (fst Qi) (fst Qii) \<longrightarrow> 
(\<exists> X. Gpost (fst Qi) X E h hi (RVal r) pi) \<longrightarrow> A E h hi (RVal r) pi
 \<longrightarrow> (\<exists> X. Gpre (fst Qii) X E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre (fst Q) X E h \<longrightarrow> (\<exists> Xii. Gpost (fst Qii) Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Gpost (fst Q) X E h h' v p;

\<forall> E h. \<forall>  Y. Fpre (snd Q) Y E h \<longrightarrow>  F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> (\<exists> Y .Fpre (snd Qi) Y E h);
\<forall> E h hi r pi. \<forall>  Y. Fpre (snd Q) Y E h \<longrightarrow>  F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> 
(\<exists> Y. Fpost (snd Qi) Y E h hi (RVal r) pi) \<longrightarrow>  (\<exists> Y. Fpre (snd Qii) Y E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> Y. Fpre  (snd Q) Y E h \<longrightarrow> (\<exists> Yii. Fpost (snd Qii) Yii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Fpost (snd Q) Y E h h' v p

\<rbrakk> \<Longrightarrow>  \<rhd> Letr x e1 e2 : (((Gpre  \<and>\<and> Fpre) Q) \<Rightarrow> ((Gpost  \<and>\<and>\<and>  Fpost) Q))"

(** proof **)

apply (rule_tac Qi=Qi and Qii=Qii and G=G and F=F 
and Fpre=Fpre and Fpost=Fpost and A=A and Gpre=Gpre in let_comb)
apply assumption+
apply fast
apply assumption+
done


lemma let_comb_concrete: "
\<lbrakk> 

\<rhd> e1: (((Gpre  \<and>\<and> Fpre) Qi) \<Rightarrow> ((Gpost  \<and>\<and>\<and>  Fpost) Qi));
\<rhd> e2: (((Gpre  \<and>\<and> Fpre) Qii) \<Rightarrow>((Gpost  \<and>\<and>\<and>  Fpost) Qii));

G (fst Q) (fst Qi) (fst Qii);
F (snd Q) (snd Qi) (snd Qii);


\<forall> E h hi r pi. \<forall> Y. Fpre (snd Q) Y E h \<longrightarrow> 
F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> (A (snd Qii)) E h hi (RVal r) pi;

\<forall> E h. \<forall>  X. Gpre (fst Q) X E h \<longrightarrow> G (fst Q) (fst Qi) (fst Qii) \<longrightarrow> (\<exists> X .Gpre (fst Qi) X E h);
\<forall> E h hi r pi. \<forall>  X. Gpre (fst Q) X E h \<longrightarrow> G (fst Q) (fst Qi) (fst Qii) \<longrightarrow> 
(\<exists> X. Gpost (fst Qi) X E h hi (RVal r) pi) \<longrightarrow> (A (snd Qii)) E h hi (RVal r) pi
 \<longrightarrow> (\<exists> X. Gpre (fst Qii) X E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> X. Gpre (fst Q) X E h \<longrightarrow> (\<exists> Xii. Gpost (fst Qii) Xii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Gpost (fst Q) X E h h' v p;

\<forall> E h. \<forall>  Y. Fpre (snd Q) Y E h \<longrightarrow>  F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> (\<exists> Y .Fpre (snd Qi) Y E h);
\<forall> E h hi r pi. \<forall>  Y. Fpre (snd Q) Y E h \<longrightarrow>  F (snd Q) (snd Qi) (snd Qii) \<longrightarrow> 
(\<exists> Y. Fpost (snd Qi) Y E h hi (RVal r) pi) \<longrightarrow>  (\<exists> Y. Fpre (snd Qii) Y E\<lfloor>x:=r\<rfloor> hi);
\<forall> E h hi r pi h' v pii p. \<forall> Y. Fpre  (snd Q) Y E h \<longrightarrow> (\<exists> Yii. Fpost (snd Qii) Yii  E\<lfloor>x:=r\<rfloor> hi h' v pii)   
\<longrightarrow> Fpost (snd Q) Y E h h' v p

\<rbrakk> \<Longrightarrow>  \<rhd> Letr x e1 e2 : (((Gpre  \<and>\<and> Fpre) Q) \<Rightarrow> ((Gpost  \<and>\<and>\<and>  Fpost) Q))"
apply (rule_tac Qi=Qi and Qii=Qii and G=G and F=F 
and Fpre=Fpre and Fpost=Fpost and A="A (snd Qii)" and Gpre=Gpre in let_comb_exact)
apply assumption+
done

end