(*<*)
theory Flatten = TreeVCG:
(*>*)

subsection{*Append and flatten*}

text {* Camelot code:
\begin{verbatim}
let append l1 l2 = match l1 with Nil -> l2
                               | Cons(h,t)@_ -> Cons(h,append t l2)

let flatten1 t = match t with Leaf -> Nil
                           | Node(i,l,r) -> append (flatten1 l) (Cons(i,flatten1 r))

let flatten2 t = match t with Leaf -> Nil
                           | Node(i,l,r)@_ -> append (flatten2 l) (Cons(i,flatten2 r))

Analysis:
  append     : 0, iList[0|int,#,0] -> iList[0|int,#,0] -> iList[0|int,#,0], 0;
  flatten1   : 0, iTree[1|int,#,#,0] -> iList[0|int,#,0], 1;
  flatten2   : 0, iTree[0|int,#,#,0] -> iList[0|int,#,0], 0;
(*The type iTree[1|int,#,#,0] is not represented in our set of types, hence flatten1 is not verifiable currently*)
\end{verbatim}
Grail code:
\begin{verbatim}
   method public static HeapSort$dia_0 append (HeapSort$dia_0 l1, HeapSort$dia_0 l2) =
   let

      fun f:append(HeapSort$dia_0 l1, HeapSort$dia_0 l2) =
         if l1 = null[HeapSort$dia_0]{iList}
         then f:0(l2)
         else f:1(l1, l2)

      fun f:0(HeapSort$dia_0 l2) =
         l2

      fun f:1(HeapSort$dia_0 l1, HeapSort$dia_0 l2) =
      let
         val v3 = getfield l1 <int HeapSort$dia_0.V0>
         val r2 = getfield l1 <HeapSort$dia_0 HeapSort$dia_0.R1>
         val () = invokestatic <void HeapSort$dia_0.free (HeapSort$dia_0)> (l1)
         val l1 = invokestatic <HeapSort$dia_0 HeapSort.append (HeapSort$dia_0, HeapSort$dia_0)> (r2, l2)
      in
         invokestatic <HeapSort$dia_0 HeapSort$dia_0.make (int, int, HeapSort$dia_0)> (5, v3, l1)
      end
   in
      f:append(l1, l2)
   end

   method public static HeapSort$dia_0 flatten1 (HeapSort$dia_0 t) =
   let

      fun f:flatten1(HeapSort$dia_0 t) =
         if t = null[HeapSort$dia_0]{iTree}
         then f:0()
         else f:1(t)

      fun f:0() =
         null[HeapSort$dia_0]{iList}

      fun f:1(HeapSort$dia_0 t) =
      let
         val v4 = getfield t <int HeapSort$dia_0.V0>
         val r1 = getfield t <HeapSort$dia_0 HeapSort$dia_0.R1>
         val r3 = getfield t <HeapSort$dia_0 HeapSort$dia_0.R2>
         val r2 = invokestatic <HeapSort$dia_0 HeapSort.flatten1 (HeapSort$dia_0)> (r1)
         val r1 = invokestatic <HeapSort$dia_0 HeapSort.flatten1 (HeapSort$dia_0)> (r3)
         val t = invokestatic <HeapSort$dia_0 HeapSort$dia_0.make (int, int, HeapSort$dia_0)> (5, v4, r1)
      in
         invokestatic <HeapSort$dia_0 HeapSort.append (HeapSort$dia_0, HeapSort$dia_0)> (r2, t)
      end
   in
      f:flatten1(t)
   end

   method public static HeapSort$dia_0 flatten2 (HeapSort$dia_0 t) =
   let

      fun f:flatten2(HeapSort$dia_0 t) =
         if t = null[HeapSort$dia_0]{iTree}
         then f:0()
         else f:1(t)

      fun f:0() =
         null[HeapSort$dia_0]{iList}

      fun f:1(HeapSort$dia_0 t) =
      let
         val v4 = getfield t <int HeapSort$dia_0.V0>
         val r1 = getfield t <HeapSort$dia_0 HeapSort$dia_0.R1>
         val r3 = getfield t <HeapSort$dia_0 HeapSort$dia_0.R2>
         val () = invokestatic <void HeapSort$dia_0.free (HeapSort$dia_0)> (t)
         val r2 = invokestatic <HeapSort$dia_0 HeapSort.flatten2 (HeapSort$dia_0)> (r1)
         val r1 = invokestatic <HeapSort$dia_0 HeapSort.flatten2 (HeapSort$dia_0)> (r3)
         val t = invokestatic <HeapSort$dia_0 HeapSort$dia_0.make (int, int, HeapSort$dia_0)> (5, v4, r1)
      in
         invokestatic <HeapSort$dia_0 HeapSort.append (HeapSort$dia_0, HeapSort$dia_0)> (r2, t)
      end
   in
      f:flatten2(t)
   end 
*}
syntax
       FL :: cname
       Append :: mname

       fAppend :: funame
       fzeroAppend :: funame
       foneAppend  :: funame

       b  :: iname
       v2  :: rname 
       vA3  :: iname
 
       l1  :: rname 
       l2  :: rname 
       l3  :: rname 

translations
 "FL"         == "(CN ''FL'') "
 "Append" == "(MN ''3'')"

 "fAppend" == "(FN ''3'') "
 "fzeroAppend" == "(FN ''0_3'')"
 "foneAppend" == "(FN ''1_3'')"

 "b" == "(In ''b'') "
 "v2" == "(RN ''v2'') "
 "vA3" == "(In ''vA3'') "
 "l1" == "(RN ''l1'') "
 "l2" == "(RN ''l2'') "
 "l3" == "(RN ''l3'') "

axioms Meth_Append: 
"methtable FL Append = ([RNpar l1, RNpar l2], CALL fAppend)"
axioms Fun_fAppend:
"funtable fAppend = ([],LET b = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l1 l1
                    IN IF b THEN CALL fzeroAppend ELSE CALL foneAppend END)"

axioms Fun_fzeroAppend: "funtable fzeroAppend = ([RNpar l2], RVar l2)"

axioms Fun_foneAppend:
"funtable foneAppend =([RNpar l1, RNpar l2],
      LET vA3 = GetFi l1 V0;
        rf v2 = GetFr l1 R1;
             _ = DIAM\<bullet>Free ([RNarg l1]);
        rf l3 = FL\<bullet>Append ([RNarg v2, RNarg l2])
      IN DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg vA3, RNarg l3]) END)"
syntax
       Flatten1 :: mname
       Flatten2 :: mname
       fFlatten1 :: funame
       fzeroFlatten1 :: funame
       foneFlatten1  :: funame

       fFlatten2 :: funame
       fzeroFlatten2 :: funame
       foneFlatten2  :: funame
       t   :: rname
       v1  :: rname 
       v4  :: iname
       v3  :: rname

translations
"Flatten1" == "(MN ''1'')"
"Flatten2" == "(MN ''2'')"
 "fFlatten1" == "(FN ''1'') "
 "fzeroFlatten1" == "(FN ''0_1'')"
 "foneFlatten1" == "(FN ''1_1'')"
  "fFlatten2" == "(FN ''2'') "
 "fzeroFlatten2" == "(FN ''0_2'')"
 "foneFlatten2" == "(FN ''1_2'')"
 "t" == "(RN ''t'') "
 "v1" == "(RN ''v1'') "
 "v4" == "(In ''v4'') "
 "v3" == "(RN ''v3'') "


axioms Meth_Flatten1: "methtable FL Flatten1 = ([RNpar t], CALL fFlatten1)"

axioms Fun_fFlatten1:
"funtable fFlatten1 = ([RNpar t ],
                       LET b = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t t
                       IN IF b THEN CALL fzeroFlatten1 ELSE CALL foneFlatten1 END)"

axioms Fun_foneFlatten1:
"funtable foneFlatten1 = ([],
      LET    v4 = GetFi t V0;
          rf l1 = GetFr t R1;
          rf l3 = GetFr t R2;
          rf l2 = FL\<bullet>Flatten1 ([RNarg l1]);
          rf l1 = FL\<bullet>Flatten1 ([RNarg l3]);
          rf t = DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg v4, RNarg l1])
      IN FL\<bullet>Append ([RNarg l2, RNarg t]) END)"

axioms Fun_fzeroFlatten1:
"funtable fzeroFlatten1 =([],Null)"

axioms Meth_Flatten2: 
"methtable FL Flatten2 = ([RNpar t], CALL fFlatten2)"

axioms Fun_fFlatten2:
"funtable fFlatten2 = ([RNpar t ],
                       LET b = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t t
                       IN IF b THEN CALL fzeroFlatten2 ELSE CALL foneFlatten2 END)"

axioms Fun_foneFlatten2:
"funtable foneFlatten2 =([RNpar t],
      LET v4 = GetFi t V0;
         rf v1 = GetFr t R1;
         rf v3 = GetFr t R2;
          _ = DIAM\<bullet>Free ([RNarg t]);
         rf v2 = FL\<bullet>Flatten2 ([RNarg v1]);
         rf v1 = FL\<bullet>Flatten2 ([RNarg v3]);
         rf t = DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg v4, RNarg v1])
      IN FL\<bullet>Append ([RNarg v2, RNarg t])
      END)"

axioms Fun_fzeroFlatten2:
"funtable fzeroFlatten2 =([], Null)"

lemma "methtable FL Append = ([RNpar l1, RNpar l2], CALL fAppend)" by (simp add: Meth_Append)
lemma "funtable fAppend = ([],LET b = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l1 l1
                    IN IF b THEN CALL fzeroAppend ELSE CALL foneAppend END)"
by (simp add: Fun_fAppend)
lemma "funtable fzeroAppend = ([RNpar l2], RVar l2)"
by (simp add: Fun_fzeroAppend)
lemma "funtable foneAppend = ([RNpar l1, RNpar l2],
      LET vA3 = GetFi l1 V0;
        rf v2 = GetFr l1 R1;
             _ = DIAM\<bullet>Free ([RNarg l1]);
        rf l3 = FL\<bullet>Append ([RNarg v2, RNarg l2])
      IN DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg vA3, RNarg l3]) END)"
by (simp add: Fun_foneAppend)

lemma "methtable FL Flatten1 = ([RNpar t], CALL fFlatten1)"
by (simp add: Meth_Flatten1)
lemma "funtable fFlatten1 = ([RNpar t ],
                       LET b = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t t
                       IN IF b THEN CALL fzeroFlatten1 ELSE CALL foneFlatten1 END)"
by (simp add: Fun_fFlatten1)
lemma "funtable foneFlatten1 = ([],
      LET    v4 = GetFi t V0;
          rf l1 = GetFr t R1;
          rf l3 = GetFr t R2;
          rf l2 = FL\<bullet>Flatten1 ([RNarg l1]);
          rf l1 = FL\<bullet>Flatten1 ([RNarg l3]);
          rf t = DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg v4, RNarg l1])
      IN FL\<bullet>Append ([RNarg l2, RNarg t]) END)"
by (insert Fun_foneFlatten1)
lemma "funtable fzeroFlatten1 =([],Null)"
by (simp add: Fun_fzeroFlatten1)
lemma "methtable FL Flatten2 = ([RNpar t], CALL fFlatten2)" by (simp add: Meth_Flatten2)
lemma "funtable fFlatten2 = ([RNpar t ],
                       LET b = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t t
                       IN IF b THEN CALL fzeroFlatten2 ELSE CALL foneFlatten2 END)"
by (simp add: Fun_fFlatten2)

lemma "funtable foneFlatten2 =([RNpar t],
      LET v4 = GetFi t V0;
         rf v1 = GetFr t R1;
         rf v3 = GetFr t R2;
          _ = DIAM\<bullet>Free ([RNarg t]);
         rf v2 = FL\<bullet>Flatten2 ([RNarg v1]);
         rf v1 = FL\<bullet>Flatten2 ([RNarg v3]);
         rf t = DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg v4, RNarg v1])
      IN FL\<bullet>Append ([RNarg v2, RNarg t])
      END)"
by (simp add: Fun_foneFlatten2)

(*
text {*Auxiliary lemmas on fresh locations.*}
lemma freshlocInsert1[simp, rule_format]: 
"\<forall> h . freshloc (Dom h) \<noteq> freshloc (insert (freshloc (Dom h)) (Dom h))"
apply clarsimp
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> insert (freshloc (Dom h)) (Dom h)")
apply (subgoal_tac "freshloc (Dom h) : insert (freshloc (Dom h)) (Dom h)")
prefer 2 apply simp
prefer 2 apply (rule freshloc, fast)
apply auto
done

lemma freshlocInsert2[simp]: 
"fmap_lookup (oheap h(freshloc (Dom h)\<mapsto>\<^sub>fC)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fC)) (freshloc (Dom h)) = Some C"
by (simp add: FMAPlookup3)

lemma freshlocInsert3[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<noteq> freshloc (Dom h)"
by (insert freshlocInsert1 [of h], fastsimp)

lemma freshlocInsert4[simp]: 
"freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> Dom h"
apply (subgoal_tac "freshloc (insert (freshloc (Dom h)) (Dom h)) \<notin> (insert (freshloc (Dom h)) (Dom h))")
apply (subgoal_tac "Dom h \<subseteq> insert (freshloc (Dom h)) (Dom h)", fast, fast, rule freshloc, fast)
done

lemma freshlocInsert5[simp]:
   "same (Dom h)  h \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM)(freshloc (insert (freshloc (Dom h)) (Dom h))\<mapsto>\<^sub>fDIAM),
                     iheap = (iheap h)
                      (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := 2, freshloc (insert (freshloc (Dom h)) (Dom h)) := 3),
                       F0 := (iheap h F0)(freshloc (insert (freshloc (Dom h)) (Dom h)) := h<a\<bullet>F0>)),
                     rheap = (rheap h)(F1 := (rheap h F1)(freshloc (insert (freshloc (Dom h)) (Dom h)) := Ref (freshloc (Dom h)))),
                     sheap = sheap h\<rparr>"
by (simp add: same_def sameOH_def FMAPlookup3) 
*)

subsubsection {*Verification of @{text append} and @{text flatten}*}

(*
lemma Lookup_SameOH: "\<lbrakk>h@@a = Some C; sameOH X h h1; a : X\<rbrakk> \<Longrightarrow> h1@@a = Some C"
by (simp add: sameOH_def)
lemma Lookup_DOM: "h@@l = Some C \<Longrightarrow> l : Dom h"
by (simp add: fmap_lookup_def fmap_dom_def dom_def)
*)
text {*First, we define a context which associates all syntactically occurring method calls
       to their specifications.
       The entries for \verb|fill| and \verb|alloc| allow to discharge the assumptions in the auxiliary lemmas
       for the \verb|make| methods. Notice that the context has several entries for
       the methods \verb|Make_IID|, \verb|Append| and \verb|Flatten|.*}

defs
isMergePoint_def: "isMergePoint f == False"

dominates_def:
"dominates f ==  []"

end


