(*<*)
theory DAssT2 = TREELIST:(*>*)

subsection {* Definition of derived assertions*}

subsubsection {* Types, contexts, regions, size of contexts*}
(*variation of DAssU.thy with univeral quantification of q C in the outside
  implication,\<dots>
*)
(*<*)
lemma SubsetTriv:"\<lbrakk>x:X; X \<subseteq> Y\<rbrakk> \<Longrightarrow> x:Y" by fast
(*>*)

datatype Type = UnitET | IntET | ListET nat nat | TreeET nat nat | ResultET nat Type nat

types Context = "(rname \<leadsto>\<^sub>f Type)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM == fmap_dom"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> fmap_lookup G x"

(*<*)
lemma GetNONE1: "x \<notin> DOM C \<Longrightarrow> None = GETr C x"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GetNONE2: "GETr C x = None \<Longrightarrow> x \<notin> DOM C"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_Update: "{x} \<union> (DOM b) = DOM (b(x\<mapsto>\<^sub>fT))" by (simp add: DOM_def)

lemma DOM_Update1: "\<lbrakk>y \<in> DOM (C(x\<mapsto>\<^sub>fT)); x \<noteq> y\<rbrakk> \<Longrightarrow> y:DOM C"
by (subgoal_tac "y \<noteq> x", insert DOM_Update, fast,fast)
lemma GETr_Update1: "x \<noteq> y \<Longrightarrow> GETr (G(x\<mapsto>\<^sub>fk)) y = GETr G y"
apply (subgoal_tac "y \<noteq> x")
apply (simp add: GETr_def)
apply (insert FMAPlookup2 [of y x G], auto)
done

lemma GETr_Update1a: "x \<noteq> y \<Longrightarrow> GETr G y = GETr (G(x\<mapsto>\<^sub>fk)) y"
apply (subgoal_tac "y \<noteq> x")
apply (simp add: GETr_def)
apply (insert FMAPlookup2 [of y x G], auto)
done

lemma GETr_Update2: "\<lbrakk>GETr G xa = Some T; x \<noteq> xa\<rbrakk> \<Longrightarrow> GETr (G(x\<mapsto>\<^sub>fk)) xa = Some T"
by (subgoal_tac "GETr (G(x\<mapsto>\<^sub>fk)) xa = GETr G xa", clarsimp, erule GETr_Update1)

lemma GETr_Trans1:"\<lbrakk>GETr C y = S; S=T; x\<noteq>y\<rbrakk> \<Longrightarrow> GETr (C(x\<mapsto>\<^sub>fTT)) y = T"
by (clarsimp, erule GETr_Update1)

lemma GETr_Trans2:"\<lbrakk>S = GETr C y; S=T; x\<noteq>y\<rbrakk> \<Longrightarrow> T = GETr (C(x\<mapsto>\<^sub>fTT)) y"
by (clarsimp, subgoal_tac "GETr (C(x\<mapsto>\<^sub>fTT)) y = GETr C y", clarsimp, erule GETr_Update1)

lemma GETrSome_DOM:"GETr G x = Some T \<Longrightarrow> x \<in> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETrNone_DOM:"GETr G x = None \<Longrightarrow> x \<notin> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETrSome:"x \<in> DOM G \<Longrightarrow> (\<exists> T . GETr G x = Some T)"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETrNone:"x \<notin> DOM G \<Longrightarrow> GETr G x = None"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETr_DOM: "\<lbrakk>x \<in> DOM D; x \<in> U; GETr C x = GETr D x\<rbrakk> \<Longrightarrow> x \<in> DOM C"
apply (subgoal_tac "\<exists> T. GETr D x = Some T", clarsimp)
apply (rule GETrSome_DOM, clarsimp, simp)
apply (erule DOM_GETrSome)
done

lemma UsedVarsDOM1:
"\<lbrakk>\<forall>x. x \<in> U \<longrightarrow> GETr D x = GETr C x; DOM C \<subseteq> DOM D; x \<in> U; x \<in> DOM D\<rbrakk> \<Longrightarrow> x:DOM C"
apply (erule_tac x=x in allE,clarsimp)
apply (subgoal_tac "\<exists> T . GETr D x = Some T",clarsimp)
apply (rule GETrSome_DOM) apply fast
apply (erule DOM_GETrSome)
done
(*>*)

text {*Region calculation*}
consts reg :: "(val \<times> heap \<times> (Type option) \<times> (locn set) \<times> nat) set"
inductive reg intros
regResultNONE:  "\<lbrakk>R={}; m = kN\<rbrakk> \<Longrightarrow> (RVal Nullref, h, Some(ResultET kN T kS), R, m): reg"
regResultSOME:  "\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> = 1; h\<lfloor>a\<diamondsuit>R1\<rfloor> = r; a \<notin> Y; (RVal r,h,Some T,Y,k):reg;
                  R = Y \<union> {a}; m = k+kS\<rbrakk> \<Longrightarrow> (RVal (Ref a), h, Some(ResultET kN T kS), R, m): reg"
regTree:  "\<lbrakk>(L,N, r, R, h) : mTREE; m = kL*L + kN*N\<rbrakk> \<Longrightarrow> (RVal r, h, Some(TreeET kL kN), R, m): reg"
regList:  "\<lbrakk>(N,C, r, R, h) : mLIST; m = kN*N + kC*C\<rbrakk> \<Longrightarrow> (RVal r, h, Some(ListET kN kC), R, m): reg"
regInt:   "(IVal i ,h,Some IntET,{}, 0): reg"
regUnit:   "(arbitrary,h,Some UnitET,{}, 0): reg"

(*<*)
lemma ListsizeNIL:"(N,C,r,R,h):mLIST \<Longrightarrow> 0 < N"
by (erule mLIST.induct, simp_all)
lemma reg_ListsizeNIL: "(r, h, Some (ListET kN kC), R, S) \<in> reg \<Longrightarrow> kN \<le> S"
apply (erule reg.elims, simp_all, clarsimp, drule ListsizeNIL)
apply (subgoal_tac "kN \<le> kN * N") apply arith apply simp
done

lemma reg_ListsizeCONS: "(RVal(Ref a), h, Some (ListET kN kC), R, S) \<in> reg \<Longrightarrow> kC \<le> S"
by (erule reg.elims, simp_all, clarsimp, erule mLIST.elims, simp_all) 

lemma TreesizeLEAF:"(L,N,r,R,h):mTREE \<Longrightarrow> 0 < L"
by (erule mTREE.induct, simp_all)
lemma reg_TreesizeLEAF: "(r, h, Some (TreeET kL kN), R, S) \<in> reg \<Longrightarrow> kL \<le> S"
apply (erule reg.elims, simp_all, clarsimp, drule TreesizeLEAF)
apply (subgoal_tac "kL \<le> kL * L") apply arith apply simp
done

lemma reg_TreesizeNODE: "(RVal(Ref a), h, Some (TreeET kL kN), R, S) \<in> reg \<Longrightarrow> kN \<le> S"
by (erule reg.elims, simp_all, clarsimp, erule mTREE.elims, simp_all) 

lemma reg_ResultsizeSome: "(RVal (Ref a), h, Some (ResultET kN T kS), R, mm):reg \<Longrightarrow> kS \<le> mm" 
by (erule reg.elims, simp_all)
lemma reg_ResultsizeNone: "(RVal Nullref, h, Some (ResultET kN T kS), R, mm):reg \<Longrightarrow> kN \<le> mm" 
by (erule reg.elims, simp_all) 

lemma Ref_reg: "\<lbrakk>(RVal (Ref a), h, Some T, Rx, Sx) \<in> reg; T \<noteq> UnitET\<rbrakk> \<Longrightarrow> a : Rx"
apply (erule reg.elims, simp_all)
apply (clarsimp, erule mTREE.elims, simp_all)
apply (clarsimp, erule mLIST.elims, simp_all)
done

lemma reg_DOM:"(RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, n) \<in> reg \<Longrightarrow> x:DOM G"
apply (subgoal_tac "\<exists> T . GETr G x = Some T", clarsimp) apply (erule GETrSome_DOM)
apply (case_tac "GETr G x", clarsimp) 
apply (erule reg.elims, clarsimp+)
done

lemma reg_Preserved[rule_format]:"(v,h,T,R,S):reg \<Longrightarrow> ((\<forall> l. l : R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (v,h1,T,R,S):reg)"
apply (erule reg.induct, safe)
apply (rule regResultNONE, simp+)
apply (rule regResultSOME) apply (erule_tac x=a in allE, simp add: sameOH_def)
                           apply (erule_tac x=a in allE, simp add: sameOH_def)
                           apply (erule_tac x=a in allE, simp add: sameOH_def)
                           apply (erule_tac x=a in allE, simp add: sameOH_def)
                           apply (erule_tac x=a in allE, simp add: sameOH_def)
                           apply (erule_tac x=a in allE, simp add: sameOH_def)
                           apply (erule_tac x=a in allE, simp add: sameOH_def)
apply (rule regTree) apply (erule mTREE_Preserved, fast, simp)
apply (rule regList) apply (erule mLIST_Preserved, fast, simp)
apply (rule regInt)
apply (rule regUnit)
done

lemma reg_Unique[rule_format]: "(v, h, T, R, S) : reg \<Longrightarrow> (\<forall> RR SS . (v, h, T, RR, SS) : reg \<longrightarrow> (R=RR \<and> S=SS))"
apply (erule reg.induct)
apply clarsimp
  apply (erule reg.elims, clarsimp, clarsimp, clarsimp, clarsimp, clarsimp, clarsimp)
apply (rule, rule, rule)
  apply (erule reg.elims, clarsimp+)
  apply (erule reg.elims, clarsimp+) apply fast apply clarsimp+
  apply (erule reg.elims, clarsimp+)
  apply (erule reg.elims, clarsimp+)
  apply (erule reg.elims, clarsimp+)
  apply (erule reg.elims, clarsimp+) apply fast apply (clarsimp)+
  apply (erule reg.elims, simp_all, clarsimp) 
    apply (drule mTREE_Unique, assumption, clarsimp)
  apply clarsimp
  apply (erule reg.elims, simp_all, clarsimp)
    apply (drule mLIST_Unique, assumption, clarsimp)
apply clarsimp apply (erule reg.elims, simp_all)
apply clarsimp apply (erule reg.elims, simp_all)
done
(*>*)

lemma reg_region_in_heap:"(v,h,T,R,S): reg \<Longrightarrow> R \<subseteq> Dom h"
(*<*)
apply (erule reg.induct, clarsimp+)
apply (simp add: fmap_lookup_def fmap_dom_def,fastsimp) 
apply (erule mTREE_region_in_heap) 
apply (erule mLIST_region_in_heap) 
apply clarify+
done
(*>*)

lemma reg_region_in_heap1:"\<lbrakk>(v,h,T,R,S): reg; a:R\<rbrakk> \<Longrightarrow> a: Dom h"
(*<*)
by (insert reg_region_in_heap, fastsimp)
(*>*)

consts ContextSize::"(env \<times> heap \<times> (rname set) \<times> Context \<times> nat) set"
inductive ContextSize intros
ContextSizeNIL: "\<lbrakk>U={}; S=0 \<rbrakk> \<Longrightarrow> (E,h,U,C, S) : ContextSize"
ContextSizeCONS: "\<lbrakk>x: U;  (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R,n): reg;
                   (E,h,U-{x},C,m):ContextSize; S = n+m\<rbrakk>
                  \<Longrightarrow> (E,h,U,C,S) : ContextSize"
(*ContextSizeNotUsed:"\<lbrakk>x:U; x \<notin> DOM C; (E,h,U-{x},C,S):ContextSize\<rbrakk> \<Longrightarrow> (E,h,U,C,S) : ContextSize"*)

(*<*)
lemma ContextSize_regionsExist[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> (\<forall> x . x:(U \<inter> DOM C)\<longrightarrow> (\<exists> R S . (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R, S) \<in> reg))"
apply (erule ContextSize.induct)
apply clarsimp 
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply fast
apply (erule_tac x=xa in allE, clarsimp)
(*apply clarsimp apply fast*)
done

lemma ContextSize_contains_region[rule_format]:
"(E, h, U, G, CS) \<in> ContextSize \<Longrightarrow> (\<forall> x R S . x:U \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, S) \<in> reg \<longrightarrow> S \<le> CS)" 
apply (erule ContextSize.induct)
apply clarsimp
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply (subgoal_tac "R=Ra \<and> n=Sa",clarsimp) 
apply (erule reg_Unique, assumption)
apply ( erule_tac x=xa in allE, erule impE, clarsimp)
apply (erule_tac x=Ra in allE, erule_tac x=Sa in allE, clarsimp)
(* apply clarsimp
apply (subgoal_tac "xa \<noteq> x",fast)
apply (subgoal_tac "xa:DOM C", fast)
apply (erule reg_DOM)*)
done

lemma ContextSize_delete_nonUsed[rule_format]:
 "(E, h, U, G, CS) \<in> ContextSize \<Longrightarrow> (\<forall> x. x \<notin> DOM G \<longrightarrow> (E,h,U-{x},G,CS):ContextSize)"
apply (erule ContextSize.induct)
apply clarsimp apply (rule ContextSizeNIL,simp+)
apply clarsimp apply (erule_tac x=xa in allE,clarsimp)
  apply (subgoal_tac "x:DOM C") prefer 2 apply (erule reg_DOM)
  apply (case_tac "x=xa",clarsimp) apply (rule ContextSizeCONS) prefer 2 apply assumption apply fast
  apply (subgoal_tac "U - {xa} - {x} = U - {x} - {xa}", clarsimp, assumption) apply fast apply simp
(*apply clarsimp apply (erule_tac x=xa in allE,clarsimp)
  apply (case_tac "x=xa",clarsimp) apply (rule ContextSizeNotUsed)
  apply (subgoal_tac "x:U-{xa}", assumption, fast) apply assumption 
  apply (subgoal_tac "U - {xa} - {x} = U - {x} - {xa}", clarsimp) apply fast *)
done

lemma ContextSize_delete_Used[rule_format]:
 "(E, h, U, G, CS) \<in> ContextSize \<Longrightarrow> 
  (\<forall> x R S . x:U \<longrightarrow> (\<forall> n.(RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, n) \<in> reg \<longrightarrow>(E,h,U-{x},G,CS-n):ContextSize))"
apply (erule ContextSize.induct)
apply clarsimp
apply clarsimp 
  apply (case_tac "xa=x",clarsimp) apply (subgoal_tac "R=Ra \<and> n=na",clarsimp) apply (erule reg_Unique, assumption)
  apply (erule_tac x=xa in allE,clarsimp)
  apply (erule_tac x=Ra in allE, erule_tac x=na in allE, clarsimp) 
  apply (subgoal_tac "U - {x} - {xa} = U - {xa} - {x}", clarsimp) apply (rule ContextSizeCONS) prefer 3 apply assumption
    apply (fast, assumption) apply (subgoal_tac "na \<le> m",clarsimp) 
    apply (erule ContextSize_contains_region) prefer 2 apply (assumption, fast)
  apply fast
(*apply clarsimp apply (subgoal_tac "xa \<noteq> x") apply (erule_tac x=xa in allE,erule impE,clarsimp)
  apply (erule_tac x=R in allE, erule_tac x=n in allE, clarsimp)
  apply (rule ContextSizeNotUsed) prefer 2 apply (assumption, fast) 
  apply (subgoal_tac "U - {xa} - {x} = U - {x} - {xa}", clarsimp) apply fast 
  apply (subgoal_tac "xa : DOM C", fast, erule reg_DOM)*)
done

lemma ContextSize_split[rule_format]:
"(E, h, U, G, CS) \<in> ContextSize \<Longrightarrow> (\<forall> x R S . x:U \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, S) \<in> reg \<longrightarrow>
  (\<exists> n . (E,h,U-{x},G,n):ContextSize \<and> CS = S + n))" 
apply (erule ContextSize.induct)
apply clarsimp
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply (subgoal_tac "R=Ra \<and> n=Sa",clarsimp) 
apply (erule reg_Unique, assumption)
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply (erule_tac x=Ra in allE, erule_tac x=Sa in allE, clarsimp)
apply (rule ContextSizeCONS)
apply (subgoal_tac "x: U -{xa}", assumption,fast)
apply assumption
prefer 2 apply simp
apply (subgoal_tac "U - {x} - {xa} = U - {xa} - {x}", clarsimp)
apply fast
(*
apply clarsimp
apply (subgoal_tac "xa \<noteq> x")
prefer 2 apply (subgoal_tac "xa:DOM C", fast) apply (erule reg_DOM)
apply (erule_tac x=xa in allE, clarsimp)
apply (erule_tac x=R in allE, erule_tac x=Sa in allE, clarsimp) 
apply (subgoal_tac "U - {x} - {xa} = U - {xa} - {x}", clarsimp)
apply (rule ContextSizeNotUsed) prefer 3 apply assumption apply fast apply assumption
apply fast*)
done

lemma ContextSize_Unique[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> (\<forall> n . (E,h,U,C,n):ContextSize \<longrightarrow> S = n)"
apply (erule ContextSize.induct)
(*1*)
apply clarsimp apply (erule ContextSize.elims, clarsimp,clarsimp)
(*2*)
apply (rule, rule) 
apply (rotate_tac -1, erule ContextSize.elims)
(*2a*) apply(fast)
(*2b*) apply clarify
  apply (case_tac "x=xa", clarify)
  apply (erule_tac x=ma in allE, clarsimp)
  apply (simp add: reg_Unique)
  (*x \<noteq> xa*)
  apply (subgoal_tac "\<exists> N .(Ea,ha,Ua-{xa}-{x},Ca,N):ContextSize \<and> ma = n + N",clarify)
  prefer 2 apply (erule ContextSize_split) apply fast apply assumption
  apply (subgoal_tac "\<exists> N .(Ea,ha,Ua-{x}-{xa},Ca,N):ContextSize \<and> m = nb + N",clarify)
  prefer 2 apply (erule ContextSize_split) apply fast apply assumption
  apply (erule_tac x="nb+N" in allE, erule impE)
  prefer 2 apply clarsimp
  apply (rule ContextSizeCONS) apply (subgoal_tac "xa : Ua - {x}", assumption,fast)
  apply assumption 
  prefer 2 apply simp
  apply (subgoal_tac "Ua - {xa} - {x} = Ua - {x} - {xa}", clarsimp,fast)
done

lemma ContextSize_UnusedU_ContextExtension[rule_format]:
"(E, h, U, C, nn) \<in> ContextSize \<Longrightarrow> 
 (\<forall> x . x \<notin> U \<longrightarrow> (E, h, U, C(x\<mapsto>\<^sub>fT), nn) \<in> ContextSize)"
apply (erule ContextSize.induct)
(*1*) apply (clarsimp,rule ContextSizeNIL, simp,simp)
(*2*) apply clarsimp apply (subgoal_tac "xa \<noteq> x") prefer 2 apply fast
      apply (rule ContextSizeCONS,assumption) 
      apply (subgoal_tac "GETr (C(xa\<mapsto>\<^sub>fT)) x = GETr C x", clarsimp,assumption)
      apply (erule GETr_Update1)
      apply fast apply simp
(*3 apply clarsimp apply (subgoal_tac "xa \<noteq> x") prefer 2 apply fast
      apply (erule_tac x=xa in allE, clarsimp)
      apply (rule ContextSizeNotUsed,assumption) apply (simp add: DOM_def,fast)
      apply assumption*)
done

lemma SizePreserved_h_h1[rule_format]:
"(E, h, U, C, CS) \<in> ContextSize \<Longrightarrow> 
   (\<forall> h1 . (\<forall> x R n . x : U \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>),h, GETr C x, R, n) : reg \<longrightarrow> (\<forall> l . l : R \<longrightarrow> sameOH {l} h h1))
          \<longrightarrow> (E, h1, U, C, CS) \<in> ContextSize)"
apply (erule ContextSize.induct)
apply clarsimp apply (rule ContextSizeNIL, simp, simp)
apply clarsimp
apply (rule ContextSizeCONS) 
apply (assumption)
apply (rule reg_Preserved, assumption) apply (erule_tac x=x in allE,clarsimp) 
  apply (erule_tac x=R in allE,erule impE,fast)
  apply fast
apply fast
apply simp
(*
apply clarsimp
apply (rule ContextSizeNotUsed) 
apply (assumption)
apply assumption
apply fast*)
done

lemma ContextSize_SPLIT[rule_format]: 
"(E, h, U, C, CS) \<in> ContextSize \<Longrightarrow> (\<forall> U1 U2 . U1 \<union> U2 = U \<longrightarrow> U1 \<inter> U2 = {} \<longrightarrow>
 (\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2, C, n2) \<in> ContextSize \<and> n1 + n2 = CS))"
apply (erule ContextSize.induct, simp_all)
apply (rule ContextSizeNIL, simp,simp)
(*Case CONS*)
apply clarsimp apply (erule disjE)
(* x:U1*)
  apply (erule_tac x="U1-{x}" in allE, erule_tac x=U2 in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x="n+n1" in exI, clarsimp)
  apply (erule ContextSizeCONS,assumption+, simp)
(* x:U2*)
  apply (erule_tac x=U1 in allE, erule_tac x="U2-{x}" in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x=n1 in exI, clarsimp)
  apply (erule ContextSizeCONS,assumption+, simp)
(*Case NotUsed+)
apply clarsimp apply (erule disjE)
(+ x:U1+)
  apply (erule_tac x="U1-{x}" in allE, erule_tac x=U2 in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x=n1 in exI, clarsimp)
  apply (erule ContextSizeNotUsed,assumption+)
(+ x:U2+)
  apply (erule_tac x=U1 in allE, erule_tac x="U2-{x}" in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x=n1 in exI, clarsimp)
  apply (erule ContextSizeNotUsed,assumption+)*)
done

lemma ContextSizePreserved[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> ((\<forall> x . x : U \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) \<longrightarrow> (EE,h,U,C,S):ContextSize)"
apply (erule ContextSize.induct)
(*NIL*)
apply clarsimp
apply (rule ContextSizeNIL) apply (simp, simp)
(*CONS*)
apply clarsimp
apply (subgoal_tac "x:DOM C")
prefer 2 apply (erule reg_DOM)
apply (erule ContextSizeCONS)
apply (assumption+,simp)
(*NotUsed
apply clarsimp
apply (erule ContextSizeNotUsed,assumption+)*)
done

lemma ContextSizePreservedU[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> ((\<forall> x . x : U \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) \<longrightarrow> 
                              (\<forall> D . (\<forall> x . x : U \<longrightarrow> (\<forall> T . GETr C x = Some T \<longrightarrow> GETr D x = Some T)) \<longrightarrow>
                                     (EE,h,U,D,S):ContextSize))"
apply (erule ContextSize.induct)
(*NIL*)
apply clarsimp
apply (rule ContextSizeNIL) apply (simp, simp)
(*CONS*)
apply clarsimp
apply (subgoal_tac "x:DOM C")
prefer 2 apply (erule reg_DOM) 
apply (erule_tac x=x in allE,clarsimp)
apply (subgoal_tac "GETr C x = GETr D x")
prefer 2 apply (subgoal_tac "\<exists> T . GETr C x = Some T") apply (erule_tac x=x in allE,clarsimp) 
         apply (erule DOM_GETrSome)
apply (erule ContextSizeCONS) 
apply (simp) 
apply (erule_tac x=D in allE) apply (clarsimp, assumption)
apply simp
done
(*>*)

subsubsection {*Auxiliary predicates*}
constdefs freelist::"heap \<Rightarrow> locn set \<Rightarrow> nat \<Rightarrow> bool"
"freelist h F N == (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL"

constdefs regionsExist::"(rname set) \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"regionsExist U G h E == (\<forall> x. (x:(DOM G) \<inter> U) \<longrightarrow> (\<exists> Rx Sx . (RVal (E\<lfloor>x\<rfloor>),h,GETr G x,Rx,Sx): reg))"

constdefs regionsDistinct::"rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"regionsDistinct X G h E == 
  (\<forall> x xx Rx Rxx Sx Sxx. (x : (X \<inter> DOM G) \<and> xx : (X \<inter> DOM G) \<and> x \<noteq> xx \<and> (RVal (E\<lfloor>x\<rfloor>),h,GETr G x,Rx,Sx): reg \<and> 
                           (RVal (E\<lfloor>xx\<rfloor>),h,GETr G xx,Rxx,Sxx): reg) \<longrightarrow>
                          Rx \<inter> Rxx = {})"

constdefs distinctFrom::"rname set \<Rightarrow> Context => heap \<Rightarrow> env \<Rightarrow> locn set \<Rightarrow> bool"
"distinctFrom X G h E F == (\<forall> x . x:(X \<inter> DOM G) \<longrightarrow> (\<forall> Rx Sx. (RVal (E\<lfloor>x\<rfloor>), h, GETr G x,Rx,Sx):reg \<longrightarrow>  Rx \<inter> F = {}))"

constdefs modified::"locn set \<Rightarrow> rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool"
"modified F Z G h E hh == (\<forall> l . (l \<notin> F \<and> l:Dom h \<and> (\<forall> z Rz Sz. (z : (Z \<inter> DOM G) \<and> (RVal (E\<lfloor>z\<rfloor>), h, GETr G z, Rz, Sz):reg) \<longrightarrow> l \<notin> Rz))
                             \<longrightarrow> sameOH {l} h hh)"
constdefs Bounded::"locn set \<Rightarrow> locn set \<Rightarrow> rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"Bounded L F U G h E == (\<forall> l. l:L \<longrightarrow> l:F \<or> (\<exists> x Rx Sx. x:(U \<inter> (DOM G)) \<and> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, Rx, Sx):reg \<and> l:Rx))"

subsubsection {*The heap assertion*}
constdefs DAssComplex::"(rname set) \<Rightarrow> nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ \<guillemotright>  _ , _ \<rbrace>" 1000)
"DAssComplex U n G T m E h hh v p \<equiv>
  (\<forall> q CS F N. 
    (freelist h F N \<and> (regionsExist U G h E) \<and> (regionsDistinct U G h E) \<and> 
     (distinctFrom U G h E F) \<and> (E,h,U,G,CS):ContextSize \<and> n + CS + q \<le> N) \<longrightarrow>
    (\<exists> R S M FF. (freelist hh FF M) \<and> 
                 (v,hh,Some T,R,S) : reg \<and>
                 (modified F U G h E hh) \<and>
                 (R \<inter> FF = {}) \<and>  
                 (Bounded R F U G h E) \<and>
                 (Bounded FF F U G h E) \<and> 
                 (m + S + q \<le> M) \<and> 
                 oheap h = oheap hh))"
(*<*)
lemma regionsExist_Lookup: "\<lbrakk>regionsExist U G h E; x:U; GETr G x = Some T\<rbrakk> \<Longrightarrow> (\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h,Some T,R,S):reg)"
by (simp add: regionsExist_def, erule_tac x=x in allE, insert GETrSome_DOM, auto)

lemma regionsExist_antimonotone:"\<lbrakk>regionsExist XX G h E; X \<subseteq> XX\<rbrakk> \<Longrightarrow> regionsExist X G h E"
by (simp add: regionsExist_def, fast)

lemma regionsDistinct_antimonotone:"\<lbrakk>regionsDistinct XX G h E; X \<subseteq> XX\<rbrakk> \<Longrightarrow> regionsDistinct X G h E"
by (simp add: regionsDistinct_def, fast)

lemma distinctFrom_antimonotone:"\<lbrakk>distinctFrom XX G h E R; X \<subseteq> XX\<rbrakk> \<Longrightarrow> distinctFrom X G h E R"
by (simp add: distinctFrom_def, fast)

lemma modified_monotone:"\<lbrakk>modified F Z G h E hh; Z \<subseteq> ZZ\<rbrakk> \<Longrightarrow> modified F ZZ G h E hh"
by (simp add: modified_def, fast)

lemma Bounded_monotone:
"\<lbrakk>Bounded L F U G h E; LL \<subseteq> L; F \<subseteq> FF; U \<subseteq> UU\<rbrakk> \<Longrightarrow> Bounded LL FF UU G h E"
by (simp add: Bounded_def, fast)

lemma ContextSize_monotone_in_U[rule_format]:
"(E, h, U, D, NN) \<in> ContextSize \<Longrightarrow>
       (\<forall> UU N . (E, h, UU, D, N) \<in> ContextSize \<longrightarrow> U \<subseteq> UU \<longrightarrow>  NN \<le> N)"
apply (erule ContextSize.induct)
apply clarsimp 
apply clarsimp
apply (subgoal_tac "\<exists> M . (E,h,UU-{x},C,M):ContextSize \<and> N = n + M")
prefer 2 apply (erule ContextSize_split) apply fast apply assumption
apply clarsimp
apply (erule_tac x="UU-{x}" in allE, erule_tac x=M in allE, erule impE,clarsimp)
apply fast
(*case non-used
apply clarsimp
apply (subgoal_tac "(E,h,UU-{x},C,N):ContextSize")
apply (erule_tac x="UU-{x}" in allE, erule_tac x=N in allE, fast)
apply (erule ContextSize_delete_nonUsed, assumption)*)
done

lemma ContextSize_existsAux[rule_format]: 
"\<forall> U . ((U,N) : cardR \<longrightarrow> (\<forall> E h C UU. UU \<subseteq> U \<longrightarrow> U \<subseteq> DOM C \<longrightarrow> 
                      regionsExist U C h E \<longrightarrow> (\<exists> S . (E,h,UU,C,S):ContextSize)))"
apply (induct N) 
apply clarsimp apply (rule_tac x=0 in exI, rule ContextSizeNIL) 
  apply (erule cardR.elims, simp,simp, simp)
apply clarsimp
apply (erule cardR.elims,clarsimp,clarsimp)
apply (erule_tac x=A in allE, clarsimp)
apply (erule_tac x= E in allE, erule_tac x=h in allE, erule_tac x=C in allE)
apply (case_tac "a:UU")
apply (erule_tac x="UU-{a}" in allE, erule impE)
apply fast
apply (erule impE, clarsimp)
apply (erule impE)
apply (erule regionsExist_antimonotone,fast)
apply clarsimp 
apply (simp add: regionsExist_def) apply (erule_tac x=a in allE, clarsimp)
apply (rule_tac x="Sx+S" in exI, rule ContextSizeCONS)
prefer 2 apply assumption+ apply simp
apply (erule_tac x="UU" in allE, erule impE)
apply fast
apply (erule impE,clarsimp)
apply (erule impE)
apply (erule regionsExist_antimonotone,fast)
apply clarsimp 
done

lemma ContextSize_exists[rule_format]: 
"\<lbrakk>UU \<subseteq> U; U \<subseteq> DOM C; regionsExist U C h E\<rbrakk> \<Longrightarrow> (\<exists> S . (E,h,UU,C,S):ContextSize)"
apply (subgoal_tac "\<exists> n . (U,n):cardR", clarsimp)
apply (erule ContextSize_existsAux,assumption+)
apply (simp add: finite_dom_fmap DOM_def finite_imp_cardR finite_subset)
done

lemma distinctFrom_Triv1: "distinctFrom {} G h E F" by (simp add: distinctFrom_def)

lemma distinctFrom_Triv2: "distinctFrom X G h E {}" by (simp add: distinctFrom_def)

lemma modified_Sameheap: "modified F Z G h E h" by (simp add: modified_def sameOH_def)

lemma Bounded_SameF: "Bounded F F U G h E" by (simp add: Bounded_def)

lemma Bounded_Empty: "Bounded {} F U G h E" by (simp add: Bounded_def)

lemma distinctFrom_Lookup:"\<lbrakk>distinctFrom U G h E F; (RVal (renv E x), h, GETr G x, R, S) \<in> reg; x:U;
                            xa \<in> R; xa \<in> F\<rbrakk> \<Longrightarrow> A"
apply (simp add: distinctFrom_def)
apply (erule_tac x=x in allE, erule impE)
apply (erule reg.elims, safe) apply (erule GETrSome_DOM)+
apply auto
done

lemma Bounded_lookup:
"\<lbrakk>regionsExist U G h E; x:U; (RVal (renv E x), h, GETr G x, R, S) \<in> reg\<rbrakk> \<Longrightarrow> Bounded R F U G h E"
apply (simp add: Bounded_def)
apply (rule, rule)
apply (subgoal_tac "\<exists>x. x: U \<and> x \<in> DOM G \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr G x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",clarsimp)
apply (rule_tac x=x in exI, safe)
apply (erule reg_DOM)
apply fast
done

lemma regionsExist1:
"\<lbrakk>regionsExist U C h E; \<forall>x. x \<in> U \<inter> (DOM D) \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> regionsExist U D h EE"
by (simp add: regionsExist_def)

lemma regionsDistinct1:
"\<lbrakk>regionsDistinct X C h E; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> regionsDistinct X D h EE"
apply (simp add: regionsDistinct_def, clarsimp)
apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, safe)
apply auto
done

lemma distinctFrom1:
"\<lbrakk>distinctFrom X C h E R; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> distinctFrom X D h EE R"
apply (simp add: distinctFrom_def)
done

lemma modified1:
"\<lbrakk>modified F Z C h E hh; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> modified F Z D h EE hh"
apply (simp add: modified_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (erule_tac x=z in allE, erule impE)
apply (subgoal_tac "z:DOM C", clarsimp, erule reg_DOM)
apply (erule_tac x=z in allE, erule_tac x=Rz in allE, auto)
done

lemma Bounded1:
"\<lbrakk>Bounded R F U D h EE; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; renv E = renv EE\<rbrakk> \<Longrightarrow> Bounded R F U C h E"
apply (simp add: Bounded_def, rule, rule)
apply (erule_tac x=l in allE, erule impE, simp)
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>x. x: U  \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv EE x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",simp)
apply clarsimp
apply (erule_tac x=x in allE, clarsimp)
apply (rule_tac x=x in exI, safe)
apply (erule reg_DOM)
apply fast
done

lemma regionsExist2:
"\<lbrakk>regionsExist U C h E; \<forall>x. x \<in> U \<longrightarrow> GETr C x = GETr D x\<rbrakk> \<Longrightarrow> regionsExist U D h E"
apply (simp add: regionsExist_def, clarsimp)
apply (erule_tac x=x in allE)+
apply clarsimp
apply (subgoal_tac "x: DOM C", simp)
apply (erule DOM_GETr_DOM, assumption, assumption)
done

lemma regionsDistinct2:
"\<lbrakk>regionsDistinct U C h E; \<forall>x. x \<in> U \<longrightarrow> GETr C x = GETr D x\<rbrakk> \<Longrightarrow> regionsDistinct U D h E"
apply (simp add: regionsDistinct_def, clarsimp)
apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, safe)
apply (erule_tac x=x in allE,clarsimp) apply (erule DOM_GETr_DOM, assumption, assumption)
apply (erule_tac x=xx in allE,clarsimp) apply (erule DOM_GETr_DOM, assumption, assumption)
apply (erule_tac x=x in allE,fastsimp) 
apply (erule_tac x=xx in allE,fastsimp) 
done

lemma distinctFrom2:
"\<lbrakk>distinctFrom U C h E R; \<forall>x. x \<in> U \<longrightarrow> GETr C x = GETr D x\<rbrakk> \<Longrightarrow> distinctFrom U D h E R"
apply (simp add: distinctFrom_def, clarsimp)
apply ((erule_tac x=x in allE)+, clarsimp)
apply (erule impE)
apply (erule DOM_GETr_DOM, assumption, assumption)
apply fast
done

lemma modified2:
"\<lbrakk>modified F U C h E hh; \<forall>x. x \<in> U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> modified F U D h E hh"
apply (simp add: modified_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (erule_tac x=z in allE, clarsimp)
apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, safe)
apply (erule DOM_GETr_DOM, assumption+)
apply fastsimp
done

lemma Bounded2:
"\<lbrakk>Bounded R F U D h E; \<forall>x. x \<in> U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> Bounded R F U C h E"
apply (simp add: Bounded_def, rule, rule)
apply (erule_tac x=l in allE, erule impE, simp)
apply (erule disjE, simp)
apply (rule disjI2)
apply clarsimp
apply (erule_tac x=x in allE, clarsimp)
apply (rule_tac x=x in exI, safe)
apply (erule reg_DOM)
apply fast
done

lemma ContextSize2[rule_format]:
"(E,h,U,D,CS) : ContextSize \<Longrightarrow> ((\<forall>x. x \<in> U \<longrightarrow> GETr D x = GETr C x) \<longrightarrow> (E,h,U,C,CS) : ContextSize)"
apply (erule ContextSize.induct, clarsimp)
apply (rule ContextSizeNIL, clarsimp+)
apply (erule ContextSizeCONS, simp+)
done

lemma mLIST_Tailregion:
"\<lbrakk>(RVal (Ref a), h, Some (ListET kN kC), Rxa, Sxa) \<in> reg; (RVal h\<lfloor>a\<diamondsuit>R1\<rfloor>, h, Some (ListET kNN kCC), Rx, Sx) \<in> reg\<rbrakk> \<Longrightarrow> Rx = Rxa - {a}"
apply (erule reg.elims, simp_all, clarsimp)+
apply (erule mLIST.elims, clarsimp, clarsimp)
apply (drule mLIST_Unique, assumption) apply clarsimp
done
lemma mTREE_Leftregion:
"\<lbrakk>(RVal (Ref a), h, Some (TreeET kL kN), Rxa, Sxa) \<in> reg; (RVal h\<lfloor>a\<diamondsuit>R1\<rfloor>, h, Some (TreeET kLL kNN), Rx, Sx) \<in> reg\<rbrakk> \<Longrightarrow> Rx \<subseteq> Rxa - {a}"
apply (erule reg.elims, simp_all, clarsimp)+
apply (erule mTREE.elims, clarsimp, clarsimp)
apply (drule mTREE_Unique, assumption) apply clarsimp
done
lemma mTREE_Rightregion:
"\<lbrakk>(RVal (Ref a), h, Some (TreeET kL kN), Rxa, Sxa) \<in> reg; (RVal h\<lfloor>a\<diamondsuit>R2\<rfloor>, h, Some (TreeET kLL kNN), Rx, Sx) \<in> reg\<rbrakk> \<Longrightarrow> Rx \<subseteq> Rxa - {a}"
apply (erule reg.elims, simp_all, clarsimp)+
apply (erule mTREE.elims, clarsimp, clarsimp)
apply (drule mTREE_Unique, assumption) apply clarsimp
done
lemma mRESULT_NONEregion:
"\<lbrakk>(RVal (Nullref), h, Some (ResultET kN T kS), R, S) \<in> reg\<rbrakk> \<Longrightarrow> R={} \<and> S=kN"
by (erule reg.elims, simp_all)
lemma mRESULT_SOMEregion:
"\<lbrakk>(RVal (Ref a), h, Some (ResultET kN T kS), Rxa, Sxa) \<in> reg; (RVal h\<lfloor>a\<diamondsuit>R1\<rfloor>, h, Some T, Rx, Sx) \<in> reg\<rbrakk> \<Longrightarrow> Rx \<subseteq> Rxa - {a}"
apply (erule reg.elims, simp_all, clarsimp)
apply (drule reg_Unique, assumption) apply clarsimp
done

lemma reg_R1_mLIST:
"(RVal (Ref a), h, Some (ListET kN kC), R, S) \<in> reg \<Longrightarrow> (RVal h\<lfloor>a\<diamondsuit>R1\<rfloor>, h, Some (ListET kN kC), R-{a}, S-kC) \<in> reg"
apply (erule reg.elims, simp_all, clarsimp)
apply (erule mLIST.elims, simp_all, clarsimp)
apply (erule regList, simp)
done

lemma reg_R1_mTREE:
"(RVal (Ref a), h, Some (TreeET kL kN), R, S) \<in> reg \<Longrightarrow> 
 (\<exists> RR SS . (RVal h\<lfloor>a\<diamondsuit>R1\<rfloor>, h, Some (TreeET kL kN), RR, SS) \<in> reg \<and> RR \<subseteq> R - {a} \<and> SS \<le> S - kN)"
apply (erule reg.elims, simp_all, clarsimp)
apply (erule mTREE.elims, simp_all, clarsimp)
apply (rule, rule, rule)
apply (erule regTree, simp, rule, fastsimp)
apply (subgoal_tac "kL * L1 \<le> kL * (L1 + L2)")
apply (subgoal_tac "kN * N1 \<le> kN * (N1 + N2)")
apply arith
apply simp+
done
lemma reg_R2_mTREE:
"(RVal (Ref a), h, Some (TreeET kL kN), R, S) \<in> reg \<Longrightarrow> 
 (\<exists> RR SS . (RVal h\<lfloor>a\<diamondsuit>R2\<rfloor>, h, Some (TreeET kL kN), RR, SS) \<in> reg \<and> RR \<subseteq> R - {a} \<and> SS \<le> S - kN)"
apply (erule reg.elims, simp_all, clarsimp)
apply (erule mTREE.elims, simp_all, clarsimp)
apply (rule, rule, rule)
apply (erule regTree, simp,rule, fastsimp)
apply (subgoal_tac "kL * L2 \<le> kL * (L1 + L2)")
apply (subgoal_tac "kN * N2 \<le> kN * (N1 + N2)")
apply arith
apply simp+
done

lemma reg_R1_mRESULT:
"(RVal (Ref a), h, Some (ResultET kN T kS), R, S) \<in> reg \<Longrightarrow> (RVal h\<lfloor>a\<diamondsuit>R1\<rfloor>, h, Some T, R-{a}, S-kS) \<in> reg"
by (erule reg.elims, simp_all)
(*>*)

lemma Class_is_DIAM:
"\<lbrakk>GETr C x = Some T; T \<noteq> IntET; T \<noteq> UnitET; regionsExist {x} C h E; E\<lfloor>x\<rfloor> = Ref a\<rbrakk>
  \<Longrightarrow> fmap_lookup (oheap h) a = Some DIAM"
(*<*)
apply (simp add: regionsExist_def, erule impE, safe)
apply (erule GETrSome_DOM)
apply (erule reg.elims, simp_all)
apply (erule mTREE.elims, simp_all) 
apply (erule mLIST.elims, simp_all) 
done
(*>*)


(*------------ Concise definition of DAss, and equivalence to messy definition -----*)

consts CS::"(env \<times> heap \<times> (rname set) \<times> Context \<times> (locn set) \<times> nat) set"
inductive CS intros
CS_NIL: "\<lbrakk>U={}; S=0 \<rbrakk> \<Longrightarrow> (E,h,U,C,{},S) : CS"
CS_CONS: "\<lbrakk>x: U;  (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, RR1,n): reg;
           (E,h,U-{x},C,RR2,m):CS; RR1 \<inter> RR2 = {}; R = RR1 \<union> RR2;S = n+m\<rbrakk>
        \<Longrightarrow> (E,h,U,C,R,S) : CS"

constdefs mod2::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"mod2 R h hh == \<forall> l . (l: Dom h - R \<longrightarrow> sameOH {l} h hh)"

lemma mod2_Sameheap[simp]: "mod2 R h h" (*<*) by (simp add: mod2_def sameOH_def)(*>*)

constdefs DAss::"(rname set) \<Rightarrow> nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ \<ggreater>  _ , _ \<rbrace>" 1000)
"DAss U n G T m E h hh v p \<equiv>
  (\<forall> q F R. 
    (\<exists> N P. freelist h F N \<and> (E,h,U,G,R,P):CS \<and> R \<inter> F = {} \<and> n + P + q \<le> N) \<longrightarrow>
    (\<exists> Rv S M FF. (freelist hh FF M) \<and> 
                 (v,hh,Some T,Rv,S) : reg \<and>
                 (mod2 (F \<union> R) h hh) \<and>
                 (Rv \<inter> FF = {}) \<and>  
                 (Rv \<union> FF) \<subseteq> (R \<union> F) \<and>
                 (m + S + q \<le> M) \<and> 
                 oheap h = oheap hh))"

(*<*)
lemma L1[rule_format]:
     "(E, h, V, C, Ra, m) \<in> CS \<Longrightarrow> 
       (\<forall> x U R n . V = U - {x} \<longrightarrow> x \<in> U \<longrightarrow> (RVal (renv E x), h, GETr C x, R, n) \<in> reg \<longrightarrow> 
                    regionsExist U C h E \<longrightarrow> regionsDistinct U C h E \<longrightarrow> R \<inter> Ra = {})"
apply (erule CS.induct)
apply simp
apply clarsimp
apply (erule_tac x=xa in allE)
apply (erule_tac x="Ua-{x}" in allE)
apply (erule impE, fast)
apply (erule impE, fast)
apply (erule_tac x=Ra in allE, erule impE,fastsimp)
apply (erule impE)
apply (erule regionsExist_antimonotone,fast)
apply (erule impE)
apply (erule regionsDistinct_antimonotone,fast)
apply (subgoal_tac "Ra \<inter> RR1 = {}", fast)
apply (subgoal_tac "x : DOM C")
apply (subgoal_tac "xa : DOM C")
apply (simp add: regionsDistinct_def)
apply (erule_tac x=x in allE, erule_tac x=xa in allE) apply fastsimp
apply (erule reg_DOM)+
done

lemma L2[rule_format]:
"(E,h,U,G,S):ContextSize \<Longrightarrow> (regionsExist U G h E \<longrightarrow> regionsDistinct U G h E \<longrightarrow> (\<exists> R . (E,h,U,G,R,S):CS))"
apply (erule ContextSize.induct)
apply clarsimp
apply (rule_tac x="{}" in exI)
apply (rule CS_NIL, simp, simp)
apply clarsimp
apply (erule impE)
apply (erule regionsExist_antimonotone,fast)
apply (erule impE)
apply (erule regionsDistinct_antimonotone,fast)
apply clarsimp
apply (rule_tac x="R \<union> Ra" in exI)
apply (rule CS_CONS, assumption)
apply simp
apply simp
apply (erule L1) apply simp+
done

lemma L3[rule_format]:
 "(E, h, U, C, R, m) \<in> CS \<Longrightarrow> (\<forall> x . x \<in> U \<longrightarrow> (\<forall> S n . (RVal (renv E x), h, GETr C x, S, n) \<in> reg \<longrightarrow> S \<subseteq> R))" 
apply (erule CS.induct)
apply clarsimp
apply clarsimp
apply (erule_tac x=xa in allE)
apply (case_tac "xa=x", clarsimp)
apply (subgoal_tac "RR1=Sa \<and> n=na", fast)
apply (erule reg_Unique, assumption)
apply clarsimp
apply (erule_tac x=Sa in allE)
apply (erule impE, fast)
apply fast
done

lemma L4[rule_format]:
  "(E,h,U,G,R,S):CS \<Longrightarrow> ((E,h,U,G,S):ContextSize \<and> regionsExist U G h E \<and> regionsDistinct U G h E)"
apply (erule CS.induct)
apply clarsimp
apply rule
apply (rule ContextSizeNIL, simp, simp)
apply (simp add: regionsExist_def regionsDistinct_def)
apply clarsimp
apply rule
apply (erule ContextSizeCONS) apply simp apply simp apply simp
apply rule
apply (simp add: regionsExist_def, clarsimp)
apply (case_tac "xa=x", fastsimp)
apply clarsimp
apply (simp add: regionsDistinct_def, clarsimp)
apply (case_tac "xa=x", clarsimp)
(*xa=x*)
  apply (rotate_tac 6, erule thin_rl)
  apply (subgoal_tac "RR1 = Rx \<and> n=Sx", clarsimp)
  prefer 2 apply (erule reg_Unique, assumption)
  apply (subgoal_tac "Rxx \<subseteq> RR2", fast)
  apply (erule L3) apply fastsimp apply simp
(*xa \<noteq> x*)
  apply (case_tac "xx=x", clarsimp)
  (*xx=x*)
    apply (rotate_tac 6, erule thin_rl)
    apply (subgoal_tac "RR1 = Rxx \<and> n=Sxx", clarsimp)
    prefer 2 apply (erule reg_Unique, assumption)
    apply (subgoal_tac "Rx \<subseteq> RR2", fast)
    apply (erule L3) apply fastsimp apply simp
  (*xx \<noteq> x*)
    apply (erule_tac x=xa in allE, erule_tac x=xx in allE, fastsimp)
done

lemma L5[rule_format]:
" (E, h, U, C, R, CSa) \<in> CS \<Longrightarrow> (\<forall> F. distinctFrom U C h E F \<longrightarrow> R \<inter> F = {})"
apply (erule CS.induct, clarsimp+)
apply (erule_tac x=F in allE, erule impE)
apply (simp add: distinctFrom_def, clarsimp)
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply fastsimp
apply (simp add: distinctFrom_def)
apply (erule_tac x=x in allE, erule impE, clarsimp)
apply (erule reg_DOM)
apply fastsimp
done
(*>*)

lemma CS_reg[rule_format]:
"(E, h, U, C, R, m) \<in> CS \<Longrightarrow> 
  (\<forall> l . l : R \<longrightarrow> (\<exists> z . z \<in> U \<and> z \<in> DOM C \<and> (\<exists> Rz Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg \<and> l:Rz)))"
(*<*)
apply (erule CS.induct)
apply clarsimp
apply safe
apply (rule_tac x=x in exI, safe) apply (erule reg_DOM) apply fastsimp
apply fastsimp
done
(*>*)

lemma DAss_Eq1: "\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p \<Longrightarrow> \<lbrace>U, n, C \<guillemotright> T, m\<rbrace> E h hh v p"
(*<*)
apply (simp add: DAss_def DAssComplex_def)
apply safe
apply (frule L2, assumption+, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE)
apply (rule_tac x=N in exI, clarsimp)
apply (rule_tac x=CSa in exI, clarsimp)
apply (erule L5, assumption)
apply clarsimp
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
apply (rule, simp add: modified_def mod2_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (frule CS_reg) apply assumption apply fastsimp
apply (simp add: Bounded_def, clarsimp)
apply (subgoal_tac "l : R \<or> l: F") prefer 2 apply fast
apply (erule disjE)
apply (frule CS_reg, assumption) apply fastsimp 
apply simp
apply (simp add: Bounded_def, clarsimp)
apply (subgoal_tac "l : R \<or> l: F") prefer 2 apply fast
apply (erule disjE)
apply (frule CS_reg, assumption) apply fastsimp 
apply simp
done
(*>*)

lemma DAss_Eq2: "\<lbrace>U, n, C \<guillemotright> T, m\<rbrace> E h hh v p \<Longrightarrow> \<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p"
(*<*)
apply (simp add: DAss_def DAssComplex_def)
apply safe
apply (frule L4, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=P in allE, erule_tac x=F in allE, erule impE,clarsimp)
apply (rule_tac x=N in exI, clarsimp)
apply (simp add: distinctFrom_def, clarsimp)
apply (frule L3, assumption+)
apply fast
apply clarsimp
apply (rule_tac x=Ra in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
apply (rule, simp add: modified_def mod2_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (drule L3, assumption+,fast) 
apply (simp add: Bounded_def)
apply (erule_tac x=x in allE, clarsimp)
apply (drule L3, assumption+,fast) 
apply (rotate_tac -6, erule thin_rl)
apply (simp add: Bounded_def)
apply (erule_tac x=x in allE, clarsimp)
apply (drule L3, assumption+,fast)
done
(*>*)

lemma DAss_Eq: "\<lbrace>U, n, C \<ggreater> T, m\<rbrace> E h hh v p = \<lbrace>U, n, C \<guillemotright> T, m\<rbrace> E h hh v p"
(*<*) by (rule, erule DAss_Eq1, erule DAss_Eq2)(*>*)

lemma DA_Eq1: "G \<rhd> e: \<lbrace>U, n, C \<ggreater> T, m\<rbrace> \<Longrightarrow> G \<rhd> e: \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>"
(*<*)by (erule vdm_conseq, clarsimp, erule DAss_Eq1)(*>*)

lemma DA_Eq2: "G \<rhd> e: \<lbrace>U, n, C \<guillemotright> T, m\<rbrace> \<Longrightarrow> G \<rhd> e: \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"
(*<*)by (erule vdm_conseq, clarsimp, erule DAss_Eq2)(*>*)

lemma DA_Eq: "(G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>) = (G \<rhd> e : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>)"
(*<*) by (rule, erule DA_Eq1, erule DA_Eq2)(*>*)

subsubsection{*Renaming*}
constdefs RenameCond1::"(rname set) \<Rightarrow> (rname \<leadsto>\<^sub>f rname) \<Rightarrow> (rname set) \<Rightarrow> bool"
"RenameCond1 U f UU == (\<forall> x . x:U \<longrightarrow> (\<exists> y. fmap_lookup f x = Some y \<and> y:UU))"

constdefs RenameCond2::"(rname set) \<Rightarrow> (rname \<leadsto>\<^sub>f rname) \<Rightarrow> (rname set) \<Rightarrow> bool"
"RenameCond2 U f UU == (\<forall> y . y:UU \<longrightarrow> (\<exists> x. fmap_lookup f x = Some y \<and> x:U))"

constdefs RenameCond3::"(rname set) \<Rightarrow> (rname \<leadsto>\<^sub>f rname) \<Rightarrow> (rname set) \<Rightarrow> env \<Rightarrow> env \<Rightarrow> Context \<Rightarrow> Context \<Rightarrow> bool"
"RenameCond3 U f UU E EE G GG == (\<forall> x y . (x:U \<and> fmap_lookup f x = Some y) \<longrightarrow> (y : UU \<and> E\<lfloor>x\<rfloor> = EE\<lfloor>y\<rfloor> \<and> GETr G x = GETr GG y))"

constdefs RenameCond4::"(rname set) \<Rightarrow> (rname \<leadsto>\<^sub>f rname) \<Rightarrow> (rname set) \<Rightarrow> bool"
"RenameCond4 U f UU == (\<forall> x1 x2 y1 y2 . (x1:U \<and> x2:U \<and> x1\<noteq>x2 \<and> fmap_lookup f x1 = y1 \<and> fmap_lookup f x2 = y2) \<longrightarrow> y1 \<noteq> y2)"

constdefs RenameCond5:: "rname list \<Rightarrow> bool"
"RenameCond5 P == (\<forall> x . x:set P \<longrightarrow> x \<noteq> self)"

lemma CS_Preserved_Rename[rule_format]:
"(E,h,U,C,R,S):CS \<Longrightarrow> (\<forall> EE D UU. (RenameCond1 U f UU \<and> RenameCond2 U f UU \<and> RenameCond3 U f UU E EE C D \<and> RenameCond4 U f UU) \<longrightarrow>
                                (EE,h,UU,D,R,S):CS)"
(*<*)
apply (erule CS.induct)
(*NIL*)
apply clarsimp
apply (rule CS_NIL) apply (simp add: RenameCond2_def, simp) 
(*CONS*)
apply clarsimp
apply (subgoal_tac "\<exists> y . fmap_lookup f x = Some y \<and> y:UU", clarsimp)
prefer 2 apply (simp add: RenameCond1_def) 
apply (erule CS_CONS)
(*1*) apply (simp add: RenameCond3_def) 
(*2*) apply (erule_tac x=EE in allE)
      apply (erule_tac x=D in allE)
      apply (erule_tac x="UU - {y}" in allE, erule impE)
        apply rule
          apply (simp add: RenameCond1_def RenameCond4_def, clarsimp)
          apply (erule_tac x=xa in allE, clarsimp)
          apply (erule_tac x=x in allE)
          apply (erule_tac x=xa in allE, clarsimp)
        apply rule apply (simp add: RenameCond2_def, clarsimp)
          apply (erule_tac x=ya in allE, fastsimp)
        apply rule apply (simp add: RenameCond3_def RenameCond4_def, clarsimp)
          apply rule 
            apply (erule_tac x=xa in allE)
            apply (erule_tac x=ya in allE, clarsimp)
            apply (erule_tac x=x in allE)
            apply (erule_tac x=xa in allE)
            apply (erule_tac x=y in allE, clarsimp)
            apply (erule_tac x=x in allE, clarsimp)
          apply (simp add: RenameCond4_def)
      apply assumption
(*3*) apply assumption 
(*4*) apply simp 
(*5*) apply simp 
done

lemma DAss_Rename[rule_format]:
       "\<lbrakk>\<lbrace>UU, n, GG \<ggreater> T, m\<rbrace> EE h hh v p; UU \<subseteq> DOM GG; U \<subseteq> DOM G;
         RenameCond1 U f UU; RenameCond2 U f UU; RenameCond3 U f UU E EE G GG; RenameCond4 U f UU\<rbrakk>
       \<Longrightarrow> \<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p"
apply (simp add: DAss_def, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE)
apply (rule_tac x=N in exI, simp)
apply (rule_tac x=P in exI, simp)
apply (erule CS_Preserved_Rename, fast, clarsimp)
done

(*Version with functions f instead of finmaps:
lemma CS_Preserved_Rename[rule_format]:
"(E,h,U,C,R,S):CS \<Longrightarrow> (\<forall> EE . (\<forall> x . x : U \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>(f x)\<rfloor>) \<longrightarrow> 
                       (\<forall> D . (\<forall> x . x : U \<longrightarrow> (\<forall> T . GETr C x = GETr D (f x))) \<longrightarrow>
                       (\<forall> UU . (\<forall> x. x:U \<longrightarrow> (f x) : UU) \<longrightarrow> ((\<forall> y. y:UU \<longrightarrow> (\<exists> x . x : U \<and> (f x) = y)) \<longrightarrow>
                               ((\<forall> x y . (x:U \<and> y:U \<and> x\<noteq>y) \<longrightarrow> (f x) \<noteq> (f y)) \<longrightarrow>
                                (EE,h,UU,D,R,S):CS)))))"
(&<&)
apply (erule CS.induct)
(&NIL&)
apply clarsimp
apply (rule CS_NIL) apply (simp, simp)
(&CONS&)
apply clarsimp
apply (subgoal_tac "f x:UU")
prefer 2 apply fast
apply (erule CS_CONS)
(&1&) apply assumption
(&2&) apply (erule_tac x=EE in allE, erule impE)
        apply fast
      apply (erule_tac x=D in allE, erule impE)
        apply fast
      apply (erule_tac x="UU - {f x}" in allE, erule impE)
        apply fastsimp
      apply (erule impE)
        apply fast
      apply assumption
(&3&) apply assumption 
(&4&) apply simp 
(&5&) apply simp 
done

lemma DAss_Rename[rule_format]:
       "\<lbrakk>\<lbrace>UU, n, GG \<ggreater> T, m\<rbrace> EE h hh v p; UU=DOM GG; U = DOM G;
         \<forall> x. x:DOM G \<longrightarrow> (E\<lfloor>x\<rfloor> = EE\<lfloor>(f x)\<rfloor> \<and> GETr G x = GETr GG (f x));
         \<forall> y. y:DOM GG \<longrightarrow> (\<exists> x . x : DOM G \<and> (f x) = y);
         \<forall> x y . (x:U \<and> y:U \<and> x\<noteq>y) \<longrightarrow> (f x) \<noteq> (f y)\<rbrakk>
       \<Longrightarrow> \<lbrace>U, n, G \<ggreater> T, m\<rbrace> E h hh v p"
apply (simp add: DAss_def, clarsimp)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE)
apply (rule_tac x=N in exI, simp)
apply (rule_tac x=P in exI, simp)
apply (erule CS_Preserved_Rename)
  (&1&) apply fast 
  (&2&) apply fast
  (&3&) apply (erule_tac x=x in allE, clarsimp) apply (frule DOM_GETrSome, clarsimp) 
        apply (erule GETrSome_DOM)
  (&4&) apply fast
  (&5&) apply fast
apply clarsimp
done
*)

(*<*)
end
(*>*)
